/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.test;

import com.kingdee.eas.cp.hsqldb.jdbcDriver;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;

class TestSelf {
    TestSelf() {
    }

    public static void main(String[] argv) {
        String a1;
        TestSelf.print("Usage: TestSelf [records [-m]] (-m means in-memory only)");
        int max = 500;
        if (argv.length >= 1) {
            max = Integer.parseInt(argv[0]);
        }
        boolean persistent = true;
        boolean update = false;
        if (argv.length >= 2 && (a1 = argv[1]).equals("-m")) {
            persistent = false;
        }
        TestSelf.test(max, persistent);
    }

    static void test(int max, boolean persistent) {
        try {
            DriverManager.registerDriver(new jdbcDriver());
            if (persistent) {
                TestSelf.testPersistence();
                TestSelf.deleteDatabase("test2");
                TestSelf.test("jdbc:hsqldb:test2", "sa", "", true);
                TestSelf.testPerformance("jdbc:hsqldb:test2", "sa", "", max, true);
            }
            TestSelf.test("jdbc:hsqldb:.", "sa", "", false);
            TestSelf.testPerformance("jdbc:hsqldb:.", "sa", "", max, false);
        }
        catch (Exception e) {
            TestSelf.print("TestSelf error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    static void delete(String file) {
        try {
            new File(file).delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void deleteDatabase(String path) {
        TestSelf.delete(path + ".backup");
        TestSelf.delete(path + ".properties");
        TestSelf.delete(path + ".script");
        TestSelf.delete(path + ".data");
    }

    static void test(String url, String user, String password, boolean persistent) throws Exception {
        String name = persistent ? "Persistent" : "Memory";
        TestSelf.print(name);
        Connection cConnection = null;
        try {
            cConnection = DriverManager.getConnection(url, user, password);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestSelf.print("TestSelf init error: " + e.getMessage());
        }
        TestSelf.testMainScript(cConnection, persistent);
        TestSelf.testTabProfile(cConnection, persistent);
        TestSelf.testMarotest(cConnection, persistent);
        cConnection.close();
    }

    static void testPersistence() {
        TestSelf.deleteDatabase("test1");
        try {
            String url = "jdbc:hsqldb:test1";
            String user = "sa";
            String password = "";
            Connection cConnection = null;
            cConnection = DriverManager.getConnection(url, user, password);
            TestSelf.testScript(cConnection, "TestSelfCreate.txt");
            cConnection.close();
            cConnection = DriverManager.getConnection(url, user, password);
            TestSelf.testScript(cConnection, "TestSelfModify.txt");
            cConnection.close();
            cConnection = DriverManager.getConnection(url, user, password);
            TestSelf.testScript(cConnection, "TestSelfVerify.txt");
            cConnection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestSelf.print("TestSelf init error: " + e.getMessage());
        }
    }

    static void testMainScript(Connection cConnection, boolean persistent) {
        String name = persistent ? "Persistent" : "Memory";
        TestSelf.print(name + " TestScript");
        String path = "TestSelf.txt";
        TestSelf.testScript(cConnection, path);
    }

    static void testScript(Connection cConnection, String path) {
        try {
            String line;
            Statement sStatement = cConnection.createStatement();
            File testfile = new File(path);
            LineNumberReader read = new LineNumberReader(new FileReader(testfile));
            String s = "";
            TestSelf.print("Opened test script file: " + testfile.getAbsolutePath());
            while ((line = read.readLine()) != null) {
                if (line.startsWith(" ")) {
                    s = s + line;
                    continue;
                }
                TestSelf.test(sStatement, s);
                s = line;
            }
            sStatement.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestSelf.print("test script file error: " + e.getMessage());
        }
    }

    static void testTabProfile(Connection cConnection, boolean persistent) {
        Statement sStatement = null;
        String s = "";
        boolean bDropError = false;
        String name = persistent ? "Persistent" : "Memory";
        TestSelf.print(name + " TabProfile");
        try {
            sStatement = cConnection.createStatement();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestSelf.print("TabProfile init error: " + e.getMessage());
            return;
        }
        try {
            s = "create table TabProfile(id int primary key,car char,won bit,licence varbinary,name char,sex char,chance double,birthday date)";
            sStatement.execute(s);
            s = "insert into TabProfile values ( ?, ?, ?, ?,'\"John\" the bird''s best friend', 'M',?,?);";
            PreparedStatement p = cConnection.prepareStatement(s);
            p.clearParameters();
            p.setInt(1, 10);
            p.setString(2, "Matchcartoon");
            p.setBoolean(3, true);
            byte[] b1 = new byte[]{0, 1, -128, 44, 12};
            p.setBytes(4, b1);
            p.setDouble(5, 50.5);
            p.setNull(6, 91);
            p.executeUpdate();
            p.clearParameters();
            p.setInt(1, -2);
            p.setString(2, "\"Birdie\"'s car ?");
            p.setBoolean(3, false);
            byte[] b2 = new byte[]{10, 127};
            p.setBytes(4, b2);
            p.setDouble(5, -3.1415E-20);
            Calendar cal = Calendar.getInstance();
            cal.set(2000, 2, 29);
            p.setDate(6, new Date(cal.getTime().getTime()));
            p.executeUpdate();
            s = "select * from TabProfile where id=-2";
            ResultSet r = sStatement.executeQuery(s);
            r.next();
            if (!r.getString(2).equals("\"Birdie\"'s car ?")) {
                throw new Exception("Unicode error.");
            }
            r.close();
            s = "drop table TabProfile";
            sStatement.execute(s);
            s = "create table obj(id int,o object)";
            sStatement.execute(s);
            s = "insert into obj values(?,?)";
            p = cConnection.prepareStatement(s);
            p.setInt(1, 1);
            int[] ia1 = new int[]{1, 2, 3};
            p.setObject(2, ia1);
            p.executeUpdate();
            p.clearParameters();
            p.setInt(1, 2);
            Rectangle r1 = new Rectangle(10, 11, 12, 13);
            p.setObject(2, r1);
            p.executeUpdate();
            r = sStatement.executeQuery("SELECT o FROM obj ORDER BY id DESC");
            r.next();
            Rectangle r2 = (Rectangle)r.getObject(1);
            if (r2.x != 10 || r2.y != 11 || r2.width != 12 || r2.height != 13) {
                throw new Exception("Object data error: Rectangle");
            }
            r.next();
            int[] ia2 = (int[])r.getObject(1);
            if (ia2[0] != 1 || ia2[1] != 2 || ia2[2] != 3 || ia2.length != 3) {
                throw new Exception("Object data error: int[]");
            }
            s = "drop table obj";
            sStatement.execute(s);
            sStatement.close();
        }
        catch (Exception e) {
            TestSelf.print("");
            TestSelf.print("TabProfile error: " + e);
            TestSelf.print("with SQL command: " + s);
            e.printStackTrace();
        }
    }

    static void testMarotest(Connection cConnection, boolean persistent) {
        Statement sStatement = null;
        String s = "";
        boolean bDropError = false;
        String name = persistent ? "Persistent" : "Memory";
        TestSelf.print(name + " Marotest");
        try {
            sStatement = cConnection.createStatement();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestSelf.print("Marotest init error: " + e.getMessage());
        }
        try {
            s = "CREATE TABLE marotest (id int PRIMARY KEY, dat int);INSERT INTO marotest VALUES (1,0);INSERT INTO marotest VALUES (2,0);INSERT INTO marotest VALUES (2,0);";
            try {
                sStatement.execute(s);
                s = "";
            }
            catch (Exception e) {
                // empty catch block
            }
            if (s.equals("")) {
                throw new Exception("Duplicate key gave no error on insert");
            }
            try {
                s = "UPDATE marotest SET id=1, dat=-1 WHERE dat=0";
                sStatement.execute(s);
                s = "";
            }
            catch (Exception e) {
                // empty catch block
            }
            if (s.equals("")) {
                throw new Exception("Duplicate key gave no error on update");
            }
            int count = 0;
            s = "SELECT *, id as marotest_id FROM marotest";
            ResultSet r = sStatement.executeQuery(s);
            while (r.next()) {
                r.getFloat(1);
                r.getString("id");
                r.getInt("DaT");
                r.getInt("marotest_id");
                if (r.getShort("dat") != 0) {
                    throw new Exception("Bad update worked");
                }
                r.getLong("DAT");
                r.getString(2);
                r.getObject("ID");
                r.clearWarnings();
                try {
                    r.getTimestamp("Timestamp?");
                    count = 99;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++count;
            }
            r.close();
            if (count != 2) {
                throw new Exception("Should have 2 but has " + count + " rows");
            }
            DatabaseMetaData dbMeta = cConnection.getMetaData();
            r = dbMeta.getColumns(null, "dbo", "MAROTEST", "%");
            while (r.next()) {
                s = r.getString(4).trim();
                int i = r.getInt(5);
                s = s + i + r.getString("TYPE_NAME");
                i = r.getInt(7);
                i = r.getInt(9);
                i = r.getInt(11);
                if ((s = s.toUpperCase()).equals("ID4INTEGER") || s.equals("DAT4INTEGER")) continue;
                throw new Exception("Wrong database meta data");
            }
            s = "DROP TABLE marotest";
            sStatement.execute(s);
            sStatement.close();
        }
        catch (Exception e) {
            TestSelf.print("");
            TestSelf.print("Marotest error: " + e);
            TestSelf.print("with SQL command: " + s);
            e.printStackTrace();
        }
    }

    static void testPerformance(String url, String user, String password, int max, boolean persistent) throws Exception {
        if (persistent) {
            TestSelf.delete("test2.backup");
            TestSelf.delete("test2.properties");
            TestSelf.delete("test2.script");
            TestSelf.delete("test2.data");
        }
        Statement sStatement = null;
        Connection cConnection = null;
        String s = "";
        boolean bDropError = false;
        String name = persistent ? "Persistent" : "Memory";
        TestSelf.print(name + " Performance");
        try {
            cConnection = DriverManager.getConnection(url, user, password);
            sStatement = cConnection.createStatement();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestSelf.print("TestSelf init error: " + e.getMessage());
        }
        try {
            int i;
            s = "CREATE CACHED TABLE Addr(ID INT PRIMARY KEY,First CHAR,Name CHAR,ZIP INT)";
            sStatement.execute(s);
            s = "CREATE INDEX iName ON Addr(Name)";
            sStatement.execute(s);
            s = "SET WRITE_DELAY TRUE";
            sStatement.execute(s);
            long start = System.currentTimeMillis();
            for (int i2 = 0; i2 < max; ++i2) {
                s = "INSERT INTO Addr VALUES(" + i2 + ",'Marcel" + i2 + "','Renggli" + (max - i2 - i2 % 31) + "'," + (3000 + i2 % 100) + ")";
                if (sStatement.executeUpdate(s) != 1) {
                    throw new Exception("Insert failed");
                }
                if (i2 % 100 != 0) continue;
                TestSelf.printStatus("insert   ", i2, max, start);
            }
            TestSelf.printStatus("insert   ", max, max, start);
            TestSelf.print("");
            s = "SELECT COUNT(*) FROM Addr";
            ResultSet r = sStatement.executeQuery(s);
            r.next();
            int c = r.getInt(1);
            if (c != max) {
                throw new Exception("Count should be " + max + " but is " + c);
            }
            if (persistent) {
                cConnection.close();
                cConnection = DriverManager.getConnection(url, user, password);
                sStatement = cConnection.createStatement();
            }
            start = System.currentTimeMillis();
            for (i = 0; i < max; ++i) {
                s = "UPDATE Addr SET Name='Robert" + (i + i % 31) + "' WHERE ID=" + i;
                if (sStatement.executeUpdate(s) != 1) {
                    throw new Exception("Update failed");
                }
                if (i % 100 != 0) continue;
                TestSelf.printStatus("updated  ", i, max, start);
            }
            TestSelf.printStatus("update   ", max, max, start);
            TestSelf.print("");
            if (persistent) {
                s = "SHUTDOWN IMMEDIATELY";
                sStatement.execute(s);
                cConnection.close();
                cConnection = DriverManager.getConnection(url, user, password);
                sStatement = cConnection.createStatement();
            }
            start = System.currentTimeMillis();
            for (i = 0; i < max; ++i) {
                s = "DELETE FROM Addr WHERE ID=" + (max - 1 - i);
                if (sStatement.executeUpdate(s) != 1) {
                    throw new Exception("Delete failed");
                }
                if (i % 100 != 0) continue;
                TestSelf.printStatus("deleting ", i, max, start);
            }
            TestSelf.printStatus("delete   ", max, max, start);
            TestSelf.print("");
            sStatement.execute("DROP TABLE Addr");
        }
        catch (Exception e) {
            TestSelf.print("");
            TestSelf.print("TestSelf error: " + e);
            TestSelf.print("with SQL command: " + s);
            e.printStackTrace();
        }
        cConnection.close();
        TestSelf.print("Test finished");
    }

    static void test(Statement stat, String s) throws Exception {
        block14: {
            String result = "";
            char type = ' ';
            if (s.startsWith("/*")) {
                type = s.charAt(2);
                int end = s.indexOf("*/");
                result = s.substring(3, end);
            }
            try {
                stat.execute(s);
                int u = stat.getUpdateCount();
                int i = 0;
                switch (type) {
                    case ' ': {
                        break;
                    }
                    case 'u': {
                        if (u == Integer.parseInt(result)) break;
                        throw new Exception("Expected update count=" + result + " but update count was " + u + " / " + s);
                    }
                    case 'r': {
                        if (u != -1) {
                            throw new Exception("Expected ResultSet but update count was " + u + " / " + s);
                        }
                        ResultSet r = stat.getResultSet();
                        r.next();
                        String col = r.getString(1);
                        if (r.wasNull() || col == null) {
                            if (result.equals("")) break;
                            throw new Exception("Expected " + result + " but got null / " + s);
                        }
                        if (col.equals(result)) break;
                        throw new Exception("Expected >" + result + "< but got >" + col + "< / " + s);
                    }
                    case 'c': {
                        if (u != -1) {
                            throw new Exception("Expected ResultSet but update count was " + u + " / " + s);
                        }
                        ResultSet r = stat.getResultSet();
                        while (r.next()) {
                            ++i;
                        }
                        if (i == Integer.parseInt(result)) break;
                        throw new Exception("Expected " + result + " rows  but got " + i + " rows / " + s);
                    }
                    case 'e': {
                        throw new Exception("Expected error but got no error / " + s);
                    }
                }
            }
            catch (SQLException e) {
                if (type == 101) break block14;
                throw new Exception("Expected " + type + "/" + result + " but got error " + e.getMessage() + " / " + s);
            }
        }
    }

    static void printStatus(String s, int i, int max, long start) {
        System.out.print(s + ": " + i + "/" + max + " " + 100 * i / max + "% ");
        long now = System.currentTimeMillis();
        if (now > start) {
            System.out.print((long)(i * 1000) / (now - start));
        }
        System.out.print(" rows/s                \r");
    }

    private static void print(String s) {
        System.out.println(s);
    }
}

