/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.test;

import com.kingdee.eas.cp.hsqldb.HsqlProperties;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Random;

public class TestTextTables {
    protected String url = "jdbc:hsqldb:";
    protected String filepath = "/hsql/testtext/test";
    String user;
    String password;
    Statement sStatement;
    Connection cConnection;
    boolean indexZip = true;
    boolean indexId = true;
    boolean indexLastName = false;
    boolean addForeignKey = false;
    boolean refIntegrity = false;
    boolean createTempTable = false;
    boolean deleteWhileInsert = false;
    int deleteWhileInsertInterval = 10000;

    protected void setUp() {
        this.user = "sa";
        this.password = "";
        try {
            this.sStatement = null;
            this.cConnection = null;
            HsqlProperties props = new HsqlProperties(this.filepath);
            boolean fileexists = props.checkFileExists();
            Class.forName("org.hsqldb.jdbcDriver");
            if (!fileexists) {
                this.cConnection = DriverManager.getConnection(this.url + this.filepath, this.user, this.password);
                this.sStatement = this.cConnection.createStatement();
                this.sStatement.execute("SHUTDOWN");
                this.cConnection.close();
                props.load();
                props.setProperty("hsqldb.log_size", "400");
                props.setProperty("hsqldb.cache_scale", "12");
                props.save();
                this.cConnection = DriverManager.getConnection(this.url + this.filepath, this.user, this.password);
                this.sStatement = this.cConnection.createStatement();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("TestSql.setUp() error: " + e.getMessage());
        }
    }

    public void testFillUp() {
        int bigrows = 1000;
        int smallrows = 4095;
        double value = 0.0;
        String ddl1 = "DROP TABLE test IF EXISTS;DROP TABLE zip IF EXISTS;";
        String ddl2 = "CREATE TABLE zip( zip INT IDENTITY );";
        String ddl3 = "CREATE TEXT TABLE test( id INT, firstname VARCHAR, lastname VARCHAR,  zip INTEGER,  filler VARCHAR, obj OTHER ); SET TABLE test SOURCE \"test.csv\";";
        String ddl4 = "CREATE INDEX idx1 ON TEST (lastname);";
        String ddl5 = "CREATE INDEX idx2 ON TEST (zip);";
        String ddl6 = "ALTER TABLE test add constraint c1 FOREIGN KEY (zip) REFERENCES zip(zip);";
        String ddl7 = "CREATE TEMP TABLE temptest( id INT, firstname VARCHAR,  lastname VARCHAR,  zip INTEGER,  filler VARCHAR); ";
        String ddl8 = "CREATE INDEX idx3 ON TEST (id);";
        String filler = "ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ";
        try {
            int i;
            System.out.println("connect");
            System.out.println(new Date(System.currentTimeMillis()));
            this.cConnection = null;
            this.sStatement = null;
            this.cConnection = DriverManager.getConnection(this.url + this.filepath, this.user, this.password);
            System.out.println("connected");
            System.out.println(new Date(System.currentTimeMillis()));
            this.sStatement = this.cConnection.createStatement();
            Random randomgen = new Random();
            this.sStatement.execute(ddl1);
            this.sStatement.execute(ddl2);
            this.sStatement.execute(ddl3);
            System.out.println("test table with no index");
            if (this.indexId) {
                this.sStatement.execute(ddl8);
                System.out.println("create index on id");
            }
            if (this.indexLastName) {
                this.sStatement.execute(ddl4);
                System.out.println("create index on lastname");
            }
            if (this.indexZip) {
                this.sStatement.execute(ddl5);
                System.out.println("create index on zip");
            }
            if (this.addForeignKey) {
                this.sStatement.execute(ddl6);
                System.out.println("add foreign key");
            }
            if (this.createTempTable) {
                this.sStatement.execute(ddl7);
                System.out.println("temp table");
            }
            for (i = 0; i <= smallrows; ++i) {
                this.sStatement.execute("INSERT INTO zip VALUES(null);");
            }
            this.sStatement.execute("SET REFERENTIAL_INTEGRITY " + this.refIntegrity + ";");
            PreparedStatement ps = this.cConnection.prepareStatement("INSERT INTO test (id,firstname,lastname,zip,filler,obj) VALUES (?,?,?,?,?,?)");
            ps.setString(2, "Julia");
            ps.setString(3, "Clancy");
            long startTime = System.currentTimeMillis();
            for (i = 0; i < bigrows; ++i) {
                ps.setInt(1, i);
                ps.setInt(4, randomgen.nextInt() & smallrows);
                long nextrandom = randomgen.nextLong();
                int randomlength = (int)nextrandom & 0x7F;
                if (randomlength > filler.length()) {
                    randomlength = filler.length();
                }
                String varfiller = nextrandom + filler.substring(0, randomlength);
                ps.setString(5, varfiller);
                ps.setObject(6, null, 1111);
                ps.execute();
                if ((i + 1) % 10000 == 0) {
                    System.out.println(i + 1);
                    System.out.println(new Date(System.currentTimeMillis()));
                }
                if (!this.deleteWhileInsert || i == 0 || i % this.deleteWhileInsertInterval != 0) continue;
                this.sStatement.execute("CALL IDENTITY();");
                ResultSet rs = this.sStatement.getResultSet();
                rs.next();
                int lastId = rs.getInt(1);
                this.sStatement.execute("SELECT * INTO TEMP tempt FROM test WHERE id > " + (lastId - 4000) + " ;");
                this.sStatement.execute("DELETE FROM test WHERE id > " + (lastId - 4000) + " ;");
                this.sStatement.execute("INSERT INTO test SELECT * FROM tempt;");
                this.sStatement.execute("DROP TABLE tempt;");
            }
            long endTime = System.currentTimeMillis();
            System.out.println(i);
            System.out.println(new Date(endTime));
            System.out.println("Insert Time:" + (endTime - startTime));
            this.sStatement.execute("SHUTDOWN");
            this.cConnection.close();
            System.out.println("Shutdown Time:" + (System.currentTimeMillis() - endTime));
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    protected void tearDown() {
    }

    protected void checkResults() {
        try {
            long startTime = System.currentTimeMillis();
            this.cConnection = DriverManager.getConnection(this.url + this.filepath, this.user, this.password);
            this.sStatement = this.cConnection.createStatement();
            this.sStatement.execute("SELECT count(*) from TEST");
            this.cConnection.close();
            System.out.println("Checked results:" + (System.currentTimeMillis() - startTime));
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void main(String[] argv) {
        TestTextTables test = new TestTextTables();
        test.setUp();
        test.testFillUp();
        test.tearDown();
    }
}

