/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.util;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Vector;

public class CodeSwitcher {
    private static final String ls = System.getProperty("line.separator", "\n");
    private Vector vList = new Vector();
    private Vector vSwitchOn = new Vector();
    private Vector vSwitchOff = new Vector();
    private Vector vSwitches = new Vector();
    private boolean bAdd;
    private boolean bRemove;
    private static final int MAX_LINELENGTH = 82;

    public static void main(String[] a) {
        CodeSwitcher s = new CodeSwitcher();
        if (a.length == 0) {
            CodeSwitcher.showUsage();
            return;
        }
        boolean path = false;
        for (int i = 0; i < a.length; ++i) {
            String p = a[i];
            if (p.startsWith("+")) {
                if (p.length() == 1) {
                    s.bAdd = true;
                    continue;
                }
                s.vSwitchOn.addElement(p.substring(1));
                continue;
            }
            if (p.startsWith("-")) {
                if (p.length() == 1) {
                    s.bRemove = true;
                    continue;
                }
                s.vSwitchOff.addElement(p.substring(1));
                continue;
            }
            s.addDir(p);
            path = true;
        }
        if (!path) {
            CodeSwitcher.printError("no path specified");
            CodeSwitcher.showUsage();
        }
        s.process();
        if (s.vSwitchOff.size() == 0 && s.vSwitchOn.size() == 0) {
            s.printSwitches();
        }
    }

    static void showUsage() {
        System.out.print("Usage: java CodeSwitcher [paths] [labels] [+][-]\nIf no labels are specified then all used\nlabels in the source code are shown.\nUse +MODE to switch on the things labeld MODE\nUse -MODE to switch off the things labeld MODE\nPath: Any number of path or files may be\nspecified. Use . for the current directory\n(including sub-directories).\nExample: java CodeSwitcher +JAVA2 .\nThis example switches on code labeled JAVA2\nin all *.java files in the current directory\nand all subdirectories.\njava CodeSwitcher + .\nAdds test code to the code.\njava CodeSwitcher - .\nRemoved test code from the code.\n");
    }

    CodeSwitcher() {
    }

    void process() {
        int len = this.vList.size();
        for (int i = 0; i < len; ++i) {
            System.out.print(".");
            String file = (String)this.vList.elementAt(i);
            if (this.bAdd || this.bRemove) {
                int maxlen = this.testFile(file);
                if (this.bAdd && !this.bRemove) {
                    this.addTest(file, maxlen);
                    continue;
                }
                this.removeTest(file);
                continue;
            }
            if (this.processFile(file)) continue;
            System.out.println("in file " + file + " !");
        }
        System.out.println("");
    }

    void printSwitches() {
        System.out.println("Used labels:");
        for (int i = 0; i < this.vSwitches.size(); ++i) {
            System.out.println((String)this.vSwitches.elementAt(i));
        }
    }

    void addDir(String path) {
        File f = new File(path);
        if (f.isFile() && path.endsWith(".java")) {
            this.vList.addElement(path);
        } else if (f.isDirectory()) {
            String[] list = f.list();
            for (int i = 0; i < list.length; ++i) {
                this.addDir(path + File.separatorChar + list[i]);
            }
        }
    }

    void removeTest(String name) {
        File f = new File(name);
        File fnew = new File(name + ".new");
        try {
            String line;
            LineNumberReader read = new LineNumberReader(new FileReader(f));
            FileWriter write = new FileWriter(fnew);
            while ((line = read.readLine()) != null) {
                if (line.startsWith("Profile.visit(")) {
                    int s = line.indexOf(59);
                    line = line.substring(s + 1);
                }
                write.write(line + ls);
            }
            read.close();
            write.flush();
            write.close();
            File fbak = new File(name + ".bak");
            fbak.delete();
            f.renameTo(fbak);
            File fcopy = new File(name);
            fnew.renameTo(fcopy);
            fbak.delete();
        }
        catch (Exception e) {
            CodeSwitcher.printError(e.getMessage());
        }
    }

    void addTest(String name, int maxline) {
        File f = new File(name);
        File fnew = new File(name + ".new");
        String key = name;
        key = key.replace('\\', '.');
        try {
            String line;
            LineNumberReader read = new LineNumberReader(new FileReader(f));
            FileWriter write = new FileWriter(fnew);
            int l = 0;
            boolean longline = false;
            while ((line = read.readLine()) != null) {
                if (line.startsWith(" ")) {
                    int spaces;
                    for (spaces = 0; spaces < line.length() && line.charAt(spaces) == ' '; ++spaces) {
                    }
                    if (spaces > 3 && this.testLine(line) && !longline) {
                        line = "org.hsqldb.test.Profile.visit(\"" + key + "\"," + l + "," + maxline + ");" + line;
                        ++l;
                    } else {
                        longline = this.isLongline(line);
                    }
                }
                write.write(line + ls);
            }
            read.close();
            write.flush();
            write.close();
            File fbak = new File(name + ".bak");
            fbak.delete();
            f.renameTo(fbak);
            File fcopy = new File(name);
            fnew.renameTo(fcopy);
            fbak.delete();
        }
        catch (Exception e) {
            CodeSwitcher.printError(e.getMessage());
        }
    }

    int testFile(String name) {
        File f = new File(name);
        try {
            String line;
            LineNumberReader read = new LineNumberReader(new FileReader(f));
            int l = 1;
            int maxline = 0;
            boolean longline = false;
            while ((line = read.readLine()) != null) {
                if (line.length() > 82 && !line.startsWith("org.hsqldb.test.Profile.")) {
                    System.out.println("long line in " + name + " at line " + l);
                }
                if (line.startsWith(" ")) {
                    int spaces;
                    for (spaces = 0; spaces < line.length() && line.charAt(spaces) == ' '; ++spaces) {
                    }
                    if (spaces > 3 && this.testLine(line) && !longline) {
                        ++maxline;
                    } else {
                        longline = this.isLongline(line);
                    }
                    String s = line.substring(spaces);
                    if (s.startsWith("if(")) {
                        if (!s.endsWith(" {")) {
                            System.out.println("if( without { in " + name + " at line " + l);
                        }
                    } else if (s.startsWith("} else if(")) {
                        if (!s.endsWith(" {")) {
                            System.out.println("} else if without { in " + name + " at line " + l);
                        }
                    } else if (s.startsWith("while(")) {
                        if (!s.endsWith(" {")) {
                            System.out.println("while( without { in " + name + " at line " + l);
                        }
                    } else if (s.startsWith("switch(")) {
                        if (!s.endsWith(" {")) {
                            System.out.println("switch( without { in " + name + " at line " + l);
                        }
                    } else if (s.startsWith("do ") && !s.endsWith(" {")) {
                        System.out.println("do without { in " + name + " at line " + l);
                    }
                }
                ++l;
            }
            read.close();
            return maxline;
        }
        catch (Exception e) {
            CodeSwitcher.printError(e.getMessage());
            return -1;
        }
    }

    boolean testLine(String line) {
        if (!line.endsWith(";")) {
            return false;
        }
        return !line.trim().startsWith("super(");
    }

    boolean isLongline(String s) {
        char c = s.charAt(s.length() - 1);
        return ",(+-&|".indexOf(c) >= 0;
    }

    boolean processFile(String name) {
        File f = new File(name);
        File fnew = new File(name + ".new");
        int state = 0;
        boolean switchoff = false;
        boolean working = false;
        try {
            String line;
            int i;
            Vector v = CodeSwitcher.getFileLines(f);
            Vector v1 = new Vector(v.size());
            for (i = 0; i < v.size(); ++i) {
                v1.addElement(v.elementAt(i));
            }
            for (i = 0; i < v.size() && (line = (String)v.elementAt(i)) != null; ++i) {
                if (working && (line.equals("/*") || line.equals("*/"))) {
                    v.removeElementAt(i--);
                    continue;
                }
                if (!line.startsWith("//#")) continue;
                if (line.startsWith("//#ifdef ")) {
                    if (state != 0) {
                        CodeSwitcher.printError("'#ifdef' not allowed inside '#ifdef'");
                        return false;
                    }
                    state = 1;
                    String s = line.substring(9);
                    if (this.vSwitchOn.indexOf(s) != -1) {
                        working = true;
                        switchoff = false;
                    } else if (this.vSwitchOff.indexOf(s) != -1) {
                        working = true;
                        v.insertElementAt("/*", ++i);
                        switchoff = true;
                    }
                    if (this.vSwitches.indexOf(s) != -1) continue;
                    this.vSwitches.addElement(s);
                    continue;
                }
                if (line.startsWith("//#else")) {
                    if (state != 1) {
                        CodeSwitcher.printError("'#else' without '#ifdef'");
                        return false;
                    }
                    state = 2;
                    if (!working) continue;
                    if (switchoff) {
                        if (v.elementAt(i - 1).equals("")) {
                            v.insertElementAt("*/", i - 1);
                            ++i;
                        } else {
                            v.insertElementAt("*/", i++);
                        }
                        switchoff = false;
                        continue;
                    }
                    v.insertElementAt("/*", ++i);
                    switchoff = true;
                    continue;
                }
                if (!line.startsWith("//#endif")) continue;
                if (state == 0) {
                    CodeSwitcher.printError("'#endif' without '#ifdef'");
                    return false;
                }
                state = 0;
                if (working && switchoff) {
                    if (v.elementAt(i - 1).equals("")) {
                        v.insertElementAt("*/", i - 1);
                        ++i;
                    } else {
                        v.insertElementAt("*/", i++);
                    }
                }
                working = false;
            }
            if (state != 0) {
                CodeSwitcher.printError("'#endif' missing");
                return false;
            }
            boolean filechanged = false;
            for (int i2 = 0; i2 < v.size(); ++i2) {
                if (v1.elementAt(i2).equals(v.elementAt(i2))) continue;
                filechanged = true;
                break;
            }
            if (!filechanged) {
                return true;
            }
            CodeSwitcher.writeFileLines(v, fnew);
            File fbak = new File(name + ".bak");
            fbak.delete();
            f.renameTo(fbak);
            File fcopy = new File(name);
            fnew.renameTo(fcopy);
            fbak.delete();
            return true;
        }
        catch (Exception e) {
            CodeSwitcher.printError(e.getMessage());
            return false;
        }
    }

    static Vector getFileLines(File f) throws IOException {
        String line;
        LineNumberReader read = new LineNumberReader(new FileReader(f));
        Vector<String> v = new Vector<String>();
        while ((line = read.readLine()) != null) {
            v.addElement(line);
        }
        read.close();
        return v;
    }

    static void writeFileLines(Vector v, File f) throws IOException {
        FileWriter write = new FileWriter(f);
        for (int i = 0; i < v.size(); ++i) {
            write.write((String)v.elementAt(i));
            write.write(ls);
        }
        write.flush();
        write.close();
    }

    static void printError(String error) {
        System.out.println("");
        System.out.println("ERROR: " + error);
    }
}

