/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.util;

import com.kingdee.eas.cp.hsqldb.util.ConnectionDialogCommon;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.DriverManager;

class ConnectionDialog
extends Dialog
implements ActionListener,
ItemListener {
    protected Connection mConnection;
    protected TextField mDriver;
    protected TextField mURL;
    protected TextField mUser;
    protected TextField mPassword;
    protected Label mError;
    private String[][] connTypes;

    public static Connection createConnection(String driver, String url, String user, String password) throws Exception {
        Class.forName(driver).newInstance();
        return DriverManager.getConnection(url, user, password);
    }

    ConnectionDialog(Frame owner, String title) {
        super(owner, title, true);
    }

    private void create() {
        Panel pButton;
        Panel pText;
        Panel pLabel;
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLayout(new BorderLayout());
        Panel p = new Panel(new BorderLayout());
        if (d.width >= 640) {
            pLabel = new Panel(new GridLayout(6, 1, 10, 10));
            pText = new Panel(new GridLayout(6, 1, 10, 10));
            pButton = new Panel(new GridLayout(1, 2, 10, 10));
        } else {
            pLabel = new Panel(new GridLayout(6, 1));
            pText = new Panel(new GridLayout(6, 1));
            pButton = new Panel(new GridLayout(1, 2));
        }
        p.add("West", pLabel);
        p.add("Center", pText);
        p.add("South", pButton);
        p.add("North", ConnectionDialog.createLabel(""));
        p.add("East", ConnectionDialog.createLabel(""));
        p.setBackground(SystemColor.control);
        pText.setBackground(SystemColor.control);
        pLabel.setBackground(SystemColor.control);
        pButton.setBackground(SystemColor.control);
        pLabel.add(ConnectionDialog.createLabel("Type:"));
        Choice types = new Choice();
        this.connTypes = ConnectionDialogCommon.getTypes();
        for (int i = 0; i < this.connTypes.length; ++i) {
            types.add(this.connTypes[i][0]);
        }
        types.addItemListener(this);
        pText.add(types);
        pLabel.add(ConnectionDialog.createLabel("Driver:"));
        this.mDriver = new TextField(this.connTypes[0][1]);
        pText.add(this.mDriver);
        pLabel.add(ConnectionDialog.createLabel("URL:"));
        this.mURL = new TextField(this.connTypes[0][2]);
        this.mURL.addActionListener(this);
        pText.add(this.mURL);
        pLabel.add(ConnectionDialog.createLabel("User:"));
        this.mUser = new TextField("sa");
        this.mUser.addActionListener(this);
        pText.add(this.mUser);
        pLabel.add(ConnectionDialog.createLabel("Password:"));
        this.mPassword = new TextField("");
        this.mPassword.addActionListener(this);
        this.mPassword.setEchoChar('*');
        pText.add(this.mPassword);
        Button b = new Button("Ok");
        b.setActionCommand("ConnectOk");
        b.addActionListener(this);
        pButton.add(b);
        b = new Button("Cancel");
        b.setActionCommand("ConnectCancel");
        b.addActionListener(this);
        pButton.add(b);
        this.add("East", ConnectionDialog.createLabel(""));
        this.add("West", ConnectionDialog.createLabel(""));
        this.mError = new Label("");
        Panel pMessage = ConnectionDialog.createBorderPanel(this.mError);
        this.add("South", pMessage);
        this.add("North", ConnectionDialog.createLabel(""));
        this.add("Center", p);
        this.doLayout();
        this.pack();
        Dimension size = this.getSize();
        if (d.width >= 640) {
            this.setLocation((d.width - size.width) / 2, (d.height - size.height) / 2);
        } else {
            this.setLocation(0, 0);
            this.setSize(d);
        }
        this.show();
    }

    public static Connection createConnection(Frame owner, String title) {
        ConnectionDialog dialog = new ConnectionDialog(owner, title);
        dialog.create();
        return dialog.mConnection;
    }

    protected static Label createLabel(String s) {
        Label l = new Label(s);
        l.setBackground(SystemColor.control);
        return l;
    }

    protected static Panel createBorderPanel(Component center) {
        Panel p = new Panel();
        p.setBackground(SystemColor.control);
        p.setLayout(new BorderLayout());
        p.add("Center", center);
        p.add("North", ConnectionDialog.createLabel(""));
        p.add("South", ConnectionDialog.createLabel(""));
        p.add("East", ConnectionDialog.createLabel(""));
        p.add("West", ConnectionDialog.createLabel(""));
        p.setBackground(SystemColor.control);
        return p;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String s = ev.getActionCommand();
        if (s.equals("ConnectOk") || ev.getSource() instanceof TextField) {
            try {
                this.mConnection = ConnectionDialog.createConnection(this.mDriver.getText(), this.mURL.getText(), this.mUser.getText(), this.mPassword.getText());
                this.dispose();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mError.setText(e.toString());
            }
        } else if (s.equals("ConnectCancel")) {
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String s = (String)e.getItem();
        for (int i = 0; i < this.connTypes.length; ++i) {
            if (!s.equals(this.connTypes[i][0])) continue;
            this.mDriver.setText(this.connTypes[i][1]);
            this.mURL.setText(this.connTypes[i][2]);
        }
    }
}

