/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.util.Vector;

class Grid
extends Panel {
    private Dimension dMinimum;
    private Font fFont;
    private FontMetrics fMetrics;
    private Graphics gImage;
    private Image iImage;
    private int iWidth;
    private int iHeight;
    private int iRowHeight;
    private int iFirstRow;
    private int iGridWidth;
    private int iGridHeight;
    private int iX;
    private int iY;
    private String[] sColHead = new String[0];
    private Vector vData = new Vector();
    private int[] iColWidth;
    private int iColCount;
    private int iRowCount;
    private Scrollbar sbHoriz;
    private Scrollbar sbVert;
    private int iSbWidth;
    private int iSbHeight;
    private boolean bDrag;
    private int iXDrag;
    private int iColDrag;

    public Grid() {
        this.fFont = new Font("Dialog", 0, 12);
        this.setLayout(null);
        this.sbHoriz = new Scrollbar(0);
        this.add(this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.add(this.sbVert);
    }

    String[] getHead() {
        return this.sColHead;
    }

    Vector getData() {
        return this.vData;
    }

    @Override
    public void setMinimumSize(Dimension d) {
        this.dMinimum = d;
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.iSbHeight = this.sbHoriz.getPreferredSize().height;
        this.iSbWidth = this.sbVert.getPreferredSize().width;
        this.iHeight = h - this.iSbHeight;
        this.iWidth = w - this.iSbWidth;
        this.sbHoriz.setBounds(0, this.iHeight, this.iWidth, this.iSbHeight);
        this.sbVert.setBounds(this.iWidth, 0, this.iSbWidth, this.iHeight);
        this.adjustScroll();
        this.iImage = null;
        this.repaint();
    }

    public void setHead(String[] head) {
        this.iColCount = head.length;
        this.sColHead = new String[this.iColCount];
        this.iColWidth = new int[this.iColCount];
        for (int i = 0; i < this.iColCount; ++i) {
            this.sColHead[i] = head[i];
            this.iColWidth[i] = 100;
        }
        this.iRowCount = 0;
        this.iRowHeight = 0;
        this.vData = new Vector();
    }

    public void addRow(String[] data) {
        if (data.length != this.iColCount) {
            return;
        }
        String[] row = new String[this.iColCount];
        for (int i = 0; i < this.iColCount; ++i) {
            row[i] = data[i];
            if (row[i] != null) continue;
            row[i] = "(null)";
        }
        this.vData.addElement(row);
        ++this.iRowCount;
    }

    public void update() {
        this.adjustScroll();
        this.repaint();
    }

    void adjustScroll() {
        if (this.iRowHeight == 0) {
            return;
        }
        int w = 0;
        for (int i = 0; i < this.iColCount; ++i) {
            w += this.iColWidth[i];
        }
        this.iGridWidth = w;
        this.iGridHeight = this.iRowHeight * (this.iRowCount + 1);
        this.sbHoriz.setValues(this.iX, this.iWidth, 0, this.iGridWidth);
        int v = this.iY / this.iRowHeight;
        int h = this.iHeight / this.iRowHeight;
        this.sbVert.setValues(v, h, 0, this.iRowCount + 1);
        this.iX = this.sbHoriz.getValue();
        this.iY = this.iRowHeight * this.sbVert.getValue();
    }

    @Override
    public boolean handleEvent(Event e) {
        switch (e.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                this.iX = this.sbHoriz.getValue();
                this.iY = this.iRowHeight * this.sbVert.getValue();
                this.repaint();
                return true;
            }
        }
        return super.handleEvent(e);
    }

    @Override
    public void paint(Graphics g) {
        int y;
        if (g == null) {
            return;
        }
        if (this.sColHead.length == 0) {
            super.paint(g);
            return;
        }
        if (this.iWidth <= 0 || this.iHeight <= 0) {
            return;
        }
        g.setColor(SystemColor.control);
        g.fillRect(this.iWidth, this.iHeight, this.iSbWidth, this.iSbHeight);
        if (this.iImage == null) {
            this.iImage = this.createImage(this.iWidth, this.iHeight);
            this.gImage = this.iImage.getGraphics();
            this.gImage.setFont(this.fFont);
            if (this.fMetrics == null) {
                this.fMetrics = this.gImage.getFontMetrics();
            }
        }
        if (this.iRowHeight == 0) {
            this.iRowHeight = Grid.getMaxHeight(this.fMetrics);
            for (int i = 0; i < this.iColCount; ++i) {
                this.calcAutoWidth(i);
            }
            this.adjustScroll();
        }
        this.gImage.setColor(Color.white);
        this.gImage.fillRect(0, 0, this.iWidth, this.iHeight);
        this.gImage.setColor(Color.darkGray);
        this.gImage.drawLine(0, this.iRowHeight, this.iWidth, this.iRowHeight);
        int x = -this.iX;
        for (int i = 0; i < this.iColCount; ++i) {
            int w = this.iColWidth[i];
            this.gImage.setColor(SystemColor.control);
            this.gImage.fillRect(x + 1, 0, w - 2, this.iRowHeight);
            this.gImage.setColor(Color.black);
            this.gImage.drawString(this.sColHead[i], x + 2, this.iRowHeight - 5);
            this.gImage.setColor(Color.darkGray);
            this.gImage.drawLine(x + w - 1, 0, x + w - 1, this.iRowHeight - 1);
            this.gImage.setColor(Color.white);
            this.gImage.drawLine(x + w, 0, x + w, this.iRowHeight - 1);
            x += w;
        }
        this.gImage.setColor(SystemColor.control);
        this.gImage.fillRect(0, 0, 1, this.iRowHeight);
        this.gImage.fillRect(x + 1, 0, this.iWidth - x, this.iRowHeight);
        this.gImage.drawLine(0, 0, 0, this.iRowHeight - 1);
        int j = 0;
        for (y = this.iRowHeight + 1 - this.iY; y < this.iRowHeight + 1; y += this.iRowHeight) {
            ++j;
        }
        this.iFirstRow = j;
        for (y = this.iRowHeight + 1; y < this.iHeight && j < this.iRowCount; ++j, y += this.iRowHeight) {
            x = -this.iX;
            for (int i = 0; i < this.iColCount; ++i) {
                int w = this.iColWidth[i];
                Color b = Color.white;
                Color t = Color.black;
                this.gImage.setColor(b);
                this.gImage.fillRect(x, y, w - 1, this.iRowHeight - 1);
                this.gImage.setColor(t);
                this.gImage.drawString(this.getDisplay(i, j), x + 2, y + this.iRowHeight - 5);
                this.gImage.setColor(Color.lightGray);
                this.gImage.drawLine(x + w - 1, y, x + w - 1, y + this.iRowHeight - 1);
                this.gImage.drawLine(x, y + this.iRowHeight - 1, x + w - 1, y + this.iRowHeight - 1);
                x += w;
            }
            this.gImage.setColor(Color.white);
            this.gImage.fillRect(x, y, this.iWidth - x, this.iRowHeight - 1);
        }
        g.drawImage(this.iImage, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public boolean mouseMove(Event e, int x, int y) {
        if (y <= this.iRowHeight) {
            int i;
            int xb = x;
            x += this.iX - this.iGridWidth;
            for (i = this.iColCount - 1; i >= 0 && (x <= -7 || x >= 7); x += this.iColWidth[i], --i) {
            }
            if (i >= 0) {
                if (!this.bDrag) {
                    this.setCursor(new Cursor(11));
                    this.bDrag = true;
                    this.iXDrag = xb - this.iColWidth[i];
                    this.iColDrag = i;
                }
                return true;
            }
        }
        return this.mouseExit(e, x, y);
    }

    @Override
    public boolean mouseDrag(Event e, int x, int y) {
        if (this.bDrag && x < this.iWidth) {
            int w = x - this.iXDrag;
            if (w < 0) {
                w = 0;
            }
            this.iColWidth[this.iColDrag] = w;
            this.adjustScroll();
            this.repaint();
        }
        return true;
    }

    @Override
    public boolean mouseExit(Event e, int x, int y) {
        if (this.bDrag) {
            this.setCursor(new Cursor(0));
            this.bDrag = false;
        }
        return true;
    }

    @Override
    public Dimension preferredSize() {
        return this.dMinimum;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.dMinimum;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.dMinimum;
    }

    @Override
    public Dimension minimumSize() {
        return this.dMinimum;
    }

    private void calcAutoWidth(int i) {
        int w = 10;
        w = Math.max(w, this.fMetrics.stringWidth(this.sColHead[i]));
        for (int j = 0; j < this.iRowCount; ++j) {
            String[] s = (String[])this.vData.elementAt(j);
            w = Math.max(w, this.fMetrics.stringWidth(s[i]));
        }
        this.iColWidth[i] = w + 6;
    }

    private String getDisplay(int x, int y) {
        return ((String[])this.vData.elementAt(y))[x];
    }

    private String get(int x, int y) {
        return ((String[])this.vData.elementAt(y))[x];
    }

    private static int getMaxHeight(FontMetrics f) {
        return f.getHeight() + 4;
    }
}

