/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.util;

import com.kingdee.eas.cp.hsqldb.util.jdbcSystem;
import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class ScriptTool {
    private static Properties pProperties = new Properties();
    private Connection cConn;
    private Statement sStatement;
    private boolean BATCH = true;
    private String EKW = new String("go");
    private boolean EOF = false;
    private int ln = 0;

    public static void main(String[] arg) {
        for (int i = 0; i < arg.length; ++i) {
            String p = arg[i];
            if (!p.equals("-?")) continue;
            ScriptTool.printHelp();
            System.exit(0);
        }
        ScriptTool tool = new ScriptTool();
        tool.execute(arg);
        System.exit(0);
    }

    public void execute(String[] arg) {
        Object p;
        for (int i = 0; i < arg.length; ++i) {
            p = arg[i];
            if (((String)p).charAt(0) != '-') continue;
            pProperties.put(((String)p).substring(1), arg[i + 1]);
            ++i;
        }
        this.ln = 0;
        this.EOF = false;
        BufferedReader in = null;
        p = pProperties;
        String driver = ((Properties)p).getProperty("driver", "org.hsqldb.jdbcDriver");
        String url = ((Properties)p).getProperty("url", "jdbc:hsqldb:");
        String database = ((Properties)p).getProperty("database", "test");
        String user = ((Properties)p).getProperty("user", "sa");
        String password = ((Properties)p).getProperty("password", "");
        String script = ((Properties)p).getProperty("script", "st.sql");
        boolean log = ((Properties)p).getProperty("log", "false").equalsIgnoreCase("true");
        this.BATCH = ((Properties)p).getProperty("batch", "true").equalsIgnoreCase("true");
        try {
            if (log) {
                this.trace("driver   = " + driver);
                this.trace("url      = " + url);
                this.trace("database = " + database);
                this.trace("user     = " + user);
                this.trace("password = " + password);
                this.trace("script   = " + script);
                this.trace("log      = " + log);
                this.trace("batch    = " + this.BATCH);
                jdbcSystem.setLogToSystem(true);
            }
            Class.forName(driver).newInstance();
            this.cConn = DriverManager.getConnection(url + database, user, password);
            in = new BufferedReader(new FileReader(script));
        }
        catch (Exception e) {
            System.out.println("ScriptTool.init error: " + e.getMessage());
            e.printStackTrace();
        }
        try {
            String sql;
            this.sStatement = this.cConn.createStatement();
            while ((sql = this.fileToString(in)) != null) {
                if (sql.length() == 1) continue;
                if (log) {
                    this.trace("SQL (" + this.ln + ") : " + sql.substring(0, sql.length() - 2));
                }
                this.sStatement.execute(sql);
                ResultSet results = this.sStatement.getResultSet();
                int updateCount = this.sStatement.getUpdateCount();
                if (updateCount == -1) {
                    this.trace(this.toString(results));
                    continue;
                }
                this.trace("update count " + updateCount);
            }
        }
        catch (SQLException e) {
            System.out.println("SQL Error at line " + this.ln + ": " + e);
        }
        try {
            this.cConn.close();
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String toString(ResultSet r) {
        try {
            int i;
            if (r == null) {
                return "No Result";
            }
            ResultSetMetaData m = r.getMetaData();
            int col = m.getColumnCount();
            StringBuffer strbuf = new StringBuffer();
            for (i = 1; i <= col; ++i) {
                strbuf = strbuf.append(m.getColumnLabel(i) + "\t");
            }
            strbuf = strbuf.append("\n");
            while (r.next()) {
                for (i = 1; i <= col; ++i) {
                    strbuf = strbuf.append(r.getString(i) + "\t");
                    if (!r.wasNull()) continue;
                    strbuf = strbuf.append("(null)\t");
                }
                strbuf = strbuf.append("\n");
            }
            return strbuf.toString();
        }
        catch (SQLException e) {
            return null;
        }
    }

    private String fileToString(BufferedReader in) {
        if (this.EOF) {
            return null;
        }
        this.EOF = true;
        StringBuffer a = new StringBuffer();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                ++this.ln;
                if (this.BATCH) {
                    if (line.startsWith("print ")) {
                        this.trace("\n" + line.substring(5));
                        continue;
                    }
                    if (line.equalsIgnoreCase(this.EKW)) {
                        this.EOF = false;
                        break;
                    }
                }
                a.append(line);
                a.append('\n');
            }
            a.append('\n');
            return a.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private void trace(String s) {
        System.out.println(s);
    }

    private static void printHelp() {
        System.out.println("Usage: java ScriptTool [-options]\nwhere options include:\n    -driver <classname>     name of the driver class\n    -url <name>             first part of the jdbc url\n    -database <name>        second part of the jdbc url\n    -user <name>            username used for connection\n    -password <name>        password for this user\n    -log <true/false>       write log to system out\n    -batch <true/false>     allow go/print pseudo statements\n    -script <script file>   reads from script file\n");
    }
}

