/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.hsqldb.util;

import com.kingdee.eas.cp.hsqldb.util.ConnectionDialog;
import com.kingdee.eas.cp.hsqldb.util.DataAccessPoint;
import com.kingdee.eas.cp.hsqldb.util.Traceable;
import com.kingdee.eas.cp.hsqldb.util.TransferCommon;
import com.kingdee.eas.cp.hsqldb.util.TransferDb;
import com.kingdee.eas.cp.hsqldb.util.TransferSQLText;
import com.kingdee.eas.cp.hsqldb.util.TransferTable;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.util.Enumeration;
import java.util.Vector;

public class Transfer
extends Applet
implements WindowListener,
ActionListener,
ItemListener,
Traceable {
    Frame fMain;
    Image imgEmpty;
    DataAccessPoint sourceDb;
    DataAccessPoint targetDb;
    TransferTable tCurrent;
    int iMaxRows;
    int iSelectionStep;
    Vector tTable;
    List lTable;
    String[] sSourceSchemas;
    String sSourceCatalog;
    String sDestSchema;
    String sDestCatalog;
    TextField tSourceTable;
    TextField tDestTable;
    TextField tDestDropIndex;
    TextField tDestCreateIndex;
    TextField tDestDrop;
    TextField tDestCreate;
    TextField tDestDelete;
    TextField tDestAlter;
    TextField tSourceSelect;
    TextField tDestInsert;
    Checkbox cTransfer;
    Checkbox cDrop;
    Checkbox cCreate;
    Checkbox cDelete;
    Checkbox cInsert;
    Checkbox cAlter;
    Checkbox cCreateIndex;
    Checkbox cDropIndex;
    Checkbox cFKForced;
    Checkbox cIdxForced;
    Button bStart;
    Button bContinue;
    TextField tMessage;
    int iTransferMode;
    static boolean bMustExit;
    int CurrentTransfer;
    int CurrentAlter;
    static final int SELECT_SOURCE_CATALOG = 1;
    static final int SELECT_SOURCE_SCHEMA = 2;
    static final int SELECT_DEST_CATALOG = 3;
    static final int SELECT_DEST_SCHEMA = 4;
    static final int SELECT_SOURCE_TABLES = 5;
    static final int TRFM_TRANSFER = 1;
    static final int TRFM_DUMP = 2;
    static final int TRFM_RESTORE = 3;

    @Override
    public void trace(String s) {
        if (s != null && !s.equals("")) {
            this.tMessage.setText(s);
            if (TRACE) {
                System.out.println(s);
            }
        }
    }

    @Override
    public void init() {
        Transfer m = new Transfer();
        m._main(null);
    }

    public static void work(String[] arg) {
        Transfer m = new Transfer();
        m._main(arg);
    }

    public static void main(String[] arg) {
        System.getProperties().put("sun.java2d.noddraw", "true");
        bMustExit = true;
        Transfer.work(arg);
    }

    private boolean CatalogToSelect() {
        Vector result = null;
        try {
            this.lTable.removeAll();
            if (this.iSelectionStep == 1) {
                result = this.sourceDb.getCatalog();
            } else if (this.iSelectionStep == 3) {
                result = this.targetDb.getCatalog();
            } else {
                this.Exit();
            }
            if (result.size() > 1) {
                this.lTable.setMultipleMode(true);
                if (this.iSelectionStep == 1) {
                    this.bStart.setLabel("Select Catalog: Source");
                } else {
                    this.bStart.setLabel("Select Catalog: Destination");
                }
                this.bStart.invalidate();
                this.bStart.setEnabled(true);
                Enumeration e = result.elements();
                while (e.hasMoreElements()) {
                    this.lTable.add(e.nextElement().toString());
                }
            } else {
                if (result.size() == 1) {
                    if (this.iSelectionStep == 1) {
                        this.sSourceCatalog = (String)result.firstElement();
                        this.sSourceSchemas = null;
                    } else {
                        this.sDestCatalog = (String)result.firstElement();
                        this.sDestSchema = null;
                    }
                } else if (this.iSelectionStep == 1) {
                    this.sSourceCatalog = null;
                    this.sSourceSchemas = null;
                } else {
                    this.sDestCatalog = null;
                    this.sDestSchema = null;
                }
                if (this.iSelectionStep == 3 && this.sDestCatalog != null) {
                    try {
                        this.targetDb.setCatalog(this.sDestCatalog);
                    }
                    catch (Exception ex) {
                        this.trace("Catalog " + this.sSourceCatalog + " could not be selected in the target database");
                        this.sSourceCatalog = null;
                    }
                }
                ++this.iSelectionStep;
                this.ProcessNextStep();
                return false;
            }
            this.lTable.repaint();
            this.trace("Select correct Catalog");
        }
        catch (Exception exp) {
            this.lTable.removeAll();
            this.trace("Exception reading catalog: " + exp);
            exp.printStackTrace();
        }
        return this.lTable.getItemCount() > 0;
    }

    private boolean SchemaToSelect() {
        Vector result = null;
        try {
            this.lTable.removeAll();
            if (this.iSelectionStep == 2) {
                result = this.sourceDb.getSchemas();
            } else if (this.iSelectionStep == 4) {
                result = this.targetDb.getSchemas();
            } else {
                this.Exit();
            }
            if (result.size() > 1) {
                this.lTable.setMultipleMode(true);
                if (this.iSelectionStep == 2) {
                    this.bStart.setLabel("Select Schema: Source");
                } else {
                    this.bStart.setLabel("Select Schema: Destination");
                }
                this.bStart.invalidate();
                this.bStart.setEnabled(true);
                Enumeration e = result.elements();
                while (e.hasMoreElements()) {
                    this.lTable.add(e.nextElement().toString());
                }
            } else {
                if (result.size() == 1) {
                    if (this.iSelectionStep == 2) {
                        this.sSourceSchemas = new String[1];
                        this.sSourceSchemas[0] = (String)result.firstElement();
                    } else {
                        this.sDestSchema = (String)result.firstElement();
                    }
                } else if (this.iSelectionStep == 2) {
                    this.sSourceSchemas = null;
                } else {
                    this.sDestSchema = null;
                }
                this.iSelectionStep = this.iTransferMode == 2 ? 5 : ++this.iSelectionStep;
                this.ProcessNextStep();
                return false;
            }
            this.lTable.repaint();
            this.trace("Select correct Schema or load Settings file");
        }
        catch (Exception exp) {
            this.lTable.removeAll();
            this.trace("Exception reading schemas: " + exp);
            exp.printStackTrace();
        }
        return this.lTable.getItemCount() > 0;
    }

    void _main(String[] arg) {
        this.iTransferMode = 1;
        if (arg != null && arg.length > 0) {
            if (arg[0].toLowerCase().equals("-r") || arg[0].toLowerCase().equals("--restore")) {
                this.iTransferMode = 3;
            } else if (arg[0].toLowerCase().equals("-d") || arg[0].toLowerCase().equals("--dump")) {
                this.iTransferMode = 2;
            }
        }
        this.fMain = new Frame("HSQL Transfer Tool");
        this.imgEmpty = this.createImage(new MemoryImageSource(2, 2, new int[16], 2, 2));
        this.fMain.setIconImage(this.imgEmpty);
        this.fMain.addWindowListener(this);
        this.fMain.setSize(640, 480);
        this.fMain.add("Center", this);
        MenuBar bar = new MenuBar();
        String[] extras = new String[]{"Insert 10 rows only", "Insert 1000 rows only", "Insert all rows", "-", "Load Settings...", "Save Settings...", "-", "Exit"};
        Menu menu = new Menu("Options");
        this.addMenuItems(menu, extras);
        bar.add(menu);
        this.fMain.setMenuBar(bar);
        this.initGUI();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.fMain.getSize();
        if (d.width >= 640) {
            this.fMain.setLocation((d.width - size.width) / 2, (d.height - size.height) / 2);
        } else {
            this.fMain.setLocation(0, 0);
            this.fMain.setSize(d);
        }
        this.fMain.setVisible(true);
        this.CurrentAlter = 0;
        this.CurrentTransfer = 0;
        try {
            String Path2;
            String sFileName;
            FileDialog f;
            if (this.iTransferMode == 2 || this.iTransferMode == 1) {
                this.sourceDb = new TransferDb(ConnectionDialog.createConnection(this.fMain, "Source Database"), this);
                if (!this.sourceDb.isConnected()) {
                    this.Exit();
                    return;
                }
            } else {
                f = new FileDialog(this.fMain, "Restore FileName", 0);
                f.show();
                sFileName = f.getFile();
                Path2 = f.getDirectory();
                if (sFileName == null || sFileName.equals("")) {
                    this.Exit();
                    return;
                }
                this.sourceDb = new TransferSQLText(Path2 + sFileName, this);
            }
            if (this.iTransferMode == 3 || this.iTransferMode == 1) {
                this.targetDb = new TransferDb(ConnectionDialog.createConnection(this.fMain, "Target Database"), this);
                if (!this.targetDb.isConnected()) {
                    this.Exit();
                    return;
                }
            } else {
                f = new FileDialog(this.fMain, "Dump FileName", 1);
                f.show();
                sFileName = f.getFile();
                Path2 = f.getDirectory();
                if (sFileName == null || sFileName.equals("")) {
                    this.Exit();
                    return;
                }
                this.targetDb = new TransferSQLText(Path2 + sFileName, this);
            }
        }
        catch (Exception e) {
            this.Exit();
            e.printStackTrace();
            return;
        }
        if (this.iTransferMode == 2 || this.iTransferMode == 1) {
            this.iSelectionStep = 1;
            this.sSourceCatalog = null;
        } else {
            this.iSelectionStep = 3;
            this.sDestCatalog = null;
        }
        this.ProcessNextStep();
        this.fMain.show();
    }

    private void RefreshMainDisplay() {
        this.lTable.removeAll();
        this.lTable.repaint();
        try {
            this.tTable = this.sourceDb.getTables(this.sSourceCatalog, this.sSourceSchemas);
            for (int i = 0; i < this.tTable.size(); ++i) {
                TransferTable t = (TransferTable)this.tTable.elementAt(i);
                t.setDest(this.sDestSchema, this.targetDb);
                t.extractTableStructure(this.sourceDb, this.targetDb);
                this.lTable.add(t.Stmts.sSourceTable);
                this.lTable.select(i);
                this.displayTable(t);
            }
            this.bStart.setEnabled(true);
            if (this.iTransferMode == 1) {
                this.trace("Edit definitions and press [Start Transfer]");
            } else if (this.iTransferMode == 2) {
                this.trace("Edit definitions and press [Start Dump]");
            }
        }
        catch (Exception e) {
            this.trace("Exception reading source tables: " + e);
            e.printStackTrace();
        }
        this.fMain.show();
    }

    private void addMenuItems(Menu f, String[] m) {
        for (int i = 0; i < m.length; ++i) {
            if (m[i].equals("-")) {
                f.addSeparator();
                continue;
            }
            MenuItem item = new MenuItem(m[i]);
            item.addActionListener(this);
            f.add(item);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable item = e.getItemSelectable();
        if (item == this.lTable) {
            if (this.iSelectionStep == 5) {
                String table = this.lTable.getSelectedItem();
                int selected = (Integer)e.getItem();
                for (int i = 0; i < this.tTable.size(); ++i) {
                    TransferTable t = (TransferTable)this.tTable.elementAt(i);
                    if (t == null || i != selected) continue;
                    this.saveTable();
                    this.displayTable(t);
                    this.updateEnabled(true);
                }
            }
        } else {
            this.saveTable();
            this.updateEnabled(true);
        }
    }

    private void saveTable() {
        if (this.tCurrent == null) {
            return;
        }
        TransferTable t = this.tCurrent;
        t.Stmts.sSourceTable = this.tSourceTable.getText();
        t.Stmts.sDestTable = this.tDestTable.getText();
        t.Stmts.sDestDrop = this.tDestDrop.getText();
        t.Stmts.sDestCreateIndex = this.tDestCreateIndex.getText();
        t.Stmts.sDestDropIndex = this.tDestDropIndex.getText();
        t.Stmts.sDestCreate = this.tDestCreate.getText();
        t.Stmts.sDestDelete = this.tDestDelete.getText();
        t.Stmts.sSourceSelect = this.tSourceSelect.getText();
        t.Stmts.sDestInsert = this.tDestInsert.getText();
        t.Stmts.bTransfer = this.cTransfer.getState();
        t.Stmts.bDrop = this.cDrop.getState();
        t.Stmts.bCreate = this.cCreate.getState();
        t.Stmts.bDelete = this.cDelete.getState();
        t.Stmts.bInsert = this.cInsert.getState();
        t.Stmts.bAlter = this.cAlter.getState();
        t.Stmts.bCreateIndex = this.cCreateIndex.getState();
        t.Stmts.bDropIndex = this.cDropIndex.getState();
        boolean reparsetable = t.Stmts.bFKForced != this.cFKForced.getState() || t.Stmts.bIdxForced != this.cIdxForced.getState();
        t.Stmts.bFKForced = this.cFKForced.getState();
        t.Stmts.bIdxForced = this.cIdxForced.getState();
        if (reparsetable) {
            try {
                this.sourceDb.getTableStructure(t, this.targetDb);
            }
            catch (Exception e) {
                this.trace("Exception reading source tables: " + e);
                e.printStackTrace();
            }
        }
    }

    private void displayTable(TransferTable t) {
        this.tCurrent = t;
        if (t == null) {
            return;
        }
        this.tSourceTable.setText(t.Stmts.sSourceTable);
        this.tDestTable.setText(t.Stmts.sDestTable);
        this.tDestDrop.setText(t.Stmts.sDestDrop);
        this.tDestCreateIndex.setText(t.Stmts.sDestCreateIndex);
        this.tDestDropIndex.setText(t.Stmts.sDestDropIndex);
        this.tDestCreate.setText(t.Stmts.sDestCreate);
        this.tDestDelete.setText(t.Stmts.sDestDelete);
        this.tSourceSelect.setText(t.Stmts.sSourceSelect);
        this.tDestInsert.setText(t.Stmts.sDestInsert);
        this.tDestAlter.setText(t.Stmts.sDestAlter);
        this.cTransfer.setState(t.Stmts.bTransfer);
        this.cDrop.setState(t.Stmts.bDrop);
        this.cCreate.setState(t.Stmts.bCreate);
        this.cDropIndex.setState(t.Stmts.bDropIndex);
        this.cCreateIndex.setState(t.Stmts.bCreateIndex);
        this.cDelete.setState(t.Stmts.bDelete);
        this.cInsert.setState(t.Stmts.bInsert);
        this.cAlter.setState(t.Stmts.bAlter);
        this.cFKForced.setState(t.Stmts.bFKForced);
        this.cIdxForced.setState(t.Stmts.bIdxForced);
    }

    private void updateEnabled(boolean and) {
        boolean b = this.cTransfer.getState();
        this.tDestTable.setEnabled(and && b);
        this.tDestDrop.setEnabled(and && b && this.cDrop.getState());
        this.tDestCreate.setEnabled(and && b && this.cCreate.getState());
        this.tDestDelete.setEnabled(and && b && this.cDelete.getState());
        this.tDestCreateIndex.setEnabled(and && b && this.cCreateIndex.getState());
        this.tDestDropIndex.setEnabled(and && b && this.cDropIndex.getState());
        this.tSourceSelect.setEnabled(and && b);
        this.tDestInsert.setEnabled(and && b && this.cInsert.getState());
        this.tDestAlter.setEnabled(and && b && this.cAlter.getState());
        this.cDrop.setEnabled(and && b);
        this.cCreate.setEnabled(and && b);
        this.cDelete.setEnabled(and && b);
        this.cCreateIndex.setEnabled(and && b);
        this.cDropIndex.setEnabled(and && b);
        this.cInsert.setEnabled(and && b);
        this.cAlter.setEnabled(and && b);
        this.cFKForced.setEnabled(this.cAlter.getState());
        this.cIdxForced.setEnabled(this.cCreateIndex.getState());
        this.bStart.setEnabled(and);
        if (this.iTransferMode == 1) {
            this.bContinue.setEnabled(and);
        }
    }

    private void ProcessNextStep() {
        switch (this.iSelectionStep) {
            case 1: 
            case 3: {
                if (!this.CatalogToSelect()) break;
                this.fMain.show();
                return;
            }
            case 2: 
            case 4: {
                if (!this.SchemaToSelect()) break;
                this.fMain.show();
                return;
            }
            case 5: {
                if (this.iTransferMode == 1) {
                    this.bStart.setLabel("Start Transfer");
                } else if (this.iTransferMode == 2) {
                    this.bStart.setLabel("Start Dump");
                } else if (this.iTransferMode == 3) {
                    this.bStart.setLabel("Start Restore");
                }
                this.bStart.invalidate();
                this.bStart.setEnabled(false);
                this.lTable.setMultipleMode(false);
                this.RefreshMainDisplay();
                break;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource() instanceof TextField) {
            this.saveTable();
            return;
        }
        String s = ev.getActionCommand();
        MenuItem i = new MenuItem();
        if (s == null && ev.getSource() instanceof MenuItem) {
            i = (MenuItem)ev.getSource();
            s = i.getLabel();
        }
        if (s.equals("Start Transfer") || s.equals("ReStart Transfer")) {
            this.bStart.setLabel("ReStart Transfer");
            this.bStart.invalidate();
            this.CurrentTransfer = 0;
            this.CurrentAlter = 0;
            this.transfer();
        } else if (s.equals("Continue Transfer")) {
            this.transfer();
        } else if (s.equals("Start Dump") || s.equals("Start Restore")) {
            this.CurrentTransfer = 0;
            this.CurrentAlter = 0;
            this.transfer();
        } else if (s.equals("Quit")) {
            this.Exit();
        } else if (s.indexOf("Select Schema") >= 0) {
            String[] selection = this.lTable.getSelectedItems();
            if (selection == null || selection.length == 0) {
                return;
            }
            if (this.iSelectionStep == 2) {
                this.sSourceSchemas = selection;
            } else {
                this.sDestSchema = selection[0];
            }
            this.iSelectionStep = this.iTransferMode == 2 ? 5 : ++this.iSelectionStep;
            this.ProcessNextStep();
        } else if (s.indexOf("Select Catalog") >= 0) {
            String selection = this.lTable.getSelectedItem();
            if (selection == null || selection.equals("")) {
                return;
            }
            if (this.iSelectionStep == 1) {
                this.sSourceCatalog = selection;
                this.sSourceSchemas = null;
            } else {
                this.sDestCatalog = selection;
                this.sDestSchema = null;
                try {
                    this.targetDb.setCatalog(this.sDestCatalog);
                }
                catch (Exception ex) {
                    this.trace("Catalog " + this.sDestCatalog + " could not be selected in the target database");
                    this.sDestCatalog = null;
                }
            }
            ++this.iSelectionStep;
            this.ProcessNextStep();
        } else if (s.equals("Insert 10 rows only")) {
            this.iMaxRows = 10;
        } else if (s.equals("Insert 1000 rows only")) {
            this.iMaxRows = 1000;
        } else if (s.equals("Insert all rows")) {
            this.iMaxRows = 0;
        } else if (s.equals("Load Settings...")) {
            FileDialog f = new FileDialog(this.fMain, "Load Settings", 0);
            f.show();
            String file = f.getFile();
            if (file != null) {
                this.LoadPrefs(file);
                this.displayTable(this.tCurrent);
            }
        } else if (s.equals("Save Settings...")) {
            FileDialog f = new FileDialog(this.fMain, "Save Settings", 1);
            f.show();
            String file = f.getFile();
            if (file != null) {
                this.SavePrefs(file);
            }
        } else if (s.equals("Exit")) {
            this.windowClosing(null);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    private void cleanup() {
        try {
            if (this.sourceDb != null) {
                this.sourceDb.close();
            }
            if (this.targetDb != null) {
                this.targetDb.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void windowClosing(WindowEvent ev) {
        this.fMain.dispose();
        if (bMustExit) {
            System.exit(0);
        }
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private void initGUI() {
        Font fFont = new Font("Dialog", 0, 12);
        this.setLayout(new BorderLayout());
        Panel p = new Panel();
        p.setBackground(SystemColor.control);
        p.setLayout(new GridLayout(16, 1));
        this.tSourceTable = new TextField();
        this.tSourceTable.setEnabled(false);
        this.tDestTable = new TextField();
        this.tDestTable.addActionListener(this);
        this.tDestDrop = new TextField();
        this.tDestDrop.addActionListener(this);
        this.tDestCreate = new TextField();
        this.tDestCreate.addActionListener(this);
        this.tDestDelete = new TextField();
        this.tDestDelete.addActionListener(this);
        this.tDestCreateIndex = new TextField();
        this.tDestCreateIndex.addActionListener(this);
        this.tDestDropIndex = new TextField();
        this.tDestDropIndex.addActionListener(this);
        this.tSourceSelect = new TextField();
        this.tSourceSelect.addActionListener(this);
        this.tDestInsert = new TextField();
        this.tDestInsert.addActionListener(this);
        this.tDestAlter = new TextField();
        this.tDestAlter.addActionListener(this);
        this.cTransfer = new Checkbox("Transfer to destination table", true);
        this.cTransfer.addItemListener(this);
        this.cDrop = new Checkbox("Drop destination table (ignore error)", true);
        this.cDrop.addItemListener(this);
        this.cCreate = new Checkbox("Create destination table", true);
        this.cCreate.addItemListener(this);
        this.cDropIndex = new Checkbox("Drop destination index (ignore error)", true);
        this.cDropIndex.addItemListener(this);
        this.cIdxForced = new Checkbox("force Idx_ prefix for indexes names", false);
        this.cIdxForced.addItemListener(this);
        this.cCreateIndex = new Checkbox("Create destination index", true);
        this.cCreateIndex.addItemListener(this);
        this.cDelete = new Checkbox("Delete rows in destination table", true);
        this.cDelete.addItemListener(this);
        this.cInsert = new Checkbox("Insert into destination", true);
        this.cInsert.addItemListener(this);
        this.cFKForced = new Checkbox("force FK_ prefix for foreign key names", false);
        this.cFKForced.addItemListener(this);
        this.cAlter = new Checkbox("Alter destination table", true);
        this.cAlter.addItemListener(this);
        p.add(this.createLabel("Source table"));
        p.add(this.tSourceTable);
        p.add(this.cTransfer);
        p.add(this.tDestTable);
        p.add(this.cDrop);
        p.add(this.tDestDrop);
        p.add(this.cCreate);
        p.add(this.tDestCreate);
        p.add(this.cDropIndex);
        p.add(this.tDestDropIndex);
        p.add(this.cCreateIndex);
        p.add(this.tDestCreateIndex);
        p.add(this.cDelete);
        p.add(this.tDestDelete);
        p.add(this.cAlter);
        p.add(this.tDestAlter);
        p.add(this.createLabel("Select source records"));
        p.add(this.tSourceSelect);
        p.add(this.cInsert);
        p.add(this.tDestInsert);
        p.add(this.createLabel(""));
        p.add(this.createLabel(""));
        p.add(this.cIdxForced);
        p.add(this.cFKForced);
        p.add(this.createLabel(""));
        p.add(this.createLabel(""));
        if (this.iTransferMode == 1) {
            this.bStart = new Button("Start Transfer");
            this.bContinue = new Button("Continue Transfer");
            this.bContinue.setEnabled(false);
        } else if (this.iTransferMode == 2) {
            this.bStart = new Button("Start Dump");
        } else if (this.iTransferMode == 3) {
            this.bStart = new Button("Start Restore");
        }
        this.bStart.addActionListener(this);
        p.add(this.bStart);
        if (this.iTransferMode == 1) {
            this.bContinue.addActionListener(this);
            p.add(this.bContinue);
        }
        this.bStart.setEnabled(false);
        this.fMain.add("Center", this.createBorderPanel(p));
        this.lTable = new List(10);
        this.lTable.addItemListener(this);
        this.fMain.add("West", this.createBorderPanel(this.lTable));
        this.tMessage = new TextField();
        Panel pMessage = this.createBorderPanel(this.tMessage);
        this.fMain.add("South", pMessage);
    }

    private Panel createBorderPanel(Component center) {
        Panel p = new Panel();
        p.setBackground(SystemColor.control);
        p.setLayout(new BorderLayout());
        p.add("Center", center);
        p.add("South", this.createLabel(""));
        p.add("East", this.createLabel(""));
        p.add("West", this.createLabel(""));
        p.setBackground(SystemColor.control);
        return p;
    }

    private Label createLabel(String s) {
        Label l = new Label(s);
        l.setBackground(SystemColor.control);
        return l;
    }

    private void SavePrefs(String f) {
        this.saveTable();
        TransferCommon.savePrefs(f, this.sourceDb, this.targetDb, this, this.tTable);
    }

    private void LoadPrefs(String f) {
        TransferTable t;
        this.trace("Parsing Settings file");
        this.bStart.setEnabled(false);
        if (this.iTransferMode == 1) {
            this.bContinue.setEnabled(false);
        }
        this.tTable = TransferCommon.loadPrefs(f, this.sourceDb, this.targetDb, this);
        this.iSelectionStep = 5;
        this.lTable.removeAll();
        for (int i = 0; i < this.tTable.size(); ++i) {
            t = (TransferTable)this.tTable.elementAt(i);
            this.lTable.add(t.Stmts.sSourceTable);
        }
        t = (TransferTable)this.tTable.elementAt(0);
        this.displayTable(t);
        this.lTable.select(0);
        this.updateEnabled(true);
        this.lTable.invalidate();
        if (this.iTransferMode == 1) {
            this.bStart.setLabel("Start Transfer");
            this.trace("Edit definitions and press [Start Transfer]");
        } else if (this.iTransferMode == 2) {
            this.bStart.setLabel("Start Dump");
            this.trace("Edit definitions and press [Start Dump]");
        } else if (this.iTransferMode == 3) {
            this.bStart.setLabel("Start Restore");
            this.trace("Edit definitions and press [Start Restore]");
        }
        this.bStart.invalidate();
        if (this.iTransferMode == 1) {
            this.bContinue.setEnabled(false);
        }
    }

    private void transfer() {
        this.saveTable();
        this.updateEnabled(false);
        this.trace("Start Transfer");
        int TransferIndex = this.CurrentTransfer;
        int AlterIndex = this.CurrentAlter;
        TransferTable t = null;
        long startTime = System.currentTimeMillis();
        try {
            int i;
            for (i = TransferIndex; i < this.tTable.size(); ++i) {
                this.CurrentTransfer = i;
                t = (TransferTable)this.tTable.elementAt(i);
                this.lTable.select(i);
                this.displayTable(t);
                t.transferStructure();
                t.transferData(this.iMaxRows);
            }
            for (i = AlterIndex; i < this.tTable.size(); ++i) {
                this.CurrentAlter = i;
                t = (TransferTable)this.tTable.elementAt(i);
                this.lTable.select(i);
                this.displayTable(t);
                t.transferAlter();
            }
            long stopTime = System.currentTimeMillis();
            this.trace("Transfer finished successfully in: " + (double)(stopTime - startTime) / 1000.0 + " sec");
            if (this.iTransferMode == 1) {
                this.bContinue.setLabel("Quit");
                this.bContinue.setEnabled(true);
                this.bContinue.invalidate();
            } else {
                this.bStart.setLabel("Quit");
                this.bStart.setEnabled(true);
                this.bStart.invalidate();
            }
        }
        catch (Exception e) {
            String last = this.tMessage.getText();
            this.trace("Transfer stopped - " + last + " /  / Error: " + e.getMessage());
            e.printStackTrace();
        }
        if (this.iTransferMode == 1) {
            this.bContinue.setEnabled(this.CurrentAlter < this.tTable.size());
        }
        this.updateEnabled(true);
        System.gc();
    }

    protected void Exit() {
        this.cleanup();
        this.fMain.dispose();
        if (bMustExit) {
            System.exit(0);
        }
    }
}

