/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extcommon.server.DbUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AccountLimitCollection;
import com.kingdee.eas.cp.bc.AccountLimitFactory;
import com.kingdee.eas.cp.bc.AccountLimitFilterFacadeFactory;
import com.kingdee.eas.cp.bc.AccountLimitInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.ControlMethod;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IAccountLimit;
import com.kingdee.eas.cp.bc.StandardException;
import com.kingdee.eas.cp.bc.app.AbstractAccountLimitControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountLimitControllerBean
extends AbstractAccountLimitControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.AccountLimitControllerBean");
    private static final String WEBRES = "com.kingdee.eas.cp.bc.WebCommonUtilResource";
    private String tempTable = null;
    private String tempTableB = null;

    private void getTempTable(Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T ( \n");
        sql.append("     FID varchar(44), \n");
        sql.append("     FYear int, \n");
        sql.append("     FPersonID varchar(44), \n");
        sql.append("     FExpenseTypeID varchar(44), \n");
        sql.append("     FCurrencyID varchar(44), \n");
        sql.append("     FAdminID varchar(44), \n");
        sql.append("     FCompanyID varchar(44), \n");
        sql.append("     FSettingID varchar(44), \n");
        sql.append("     FAccountStandardID varchar(44), \n");
        sql.append("     FMonthLimit NUMERIC(17,4) \n");
        sql.append(") \n");
        try {
            this.tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            this.tempTableB = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void releaseTempTable(Context ctx) {
        TempTablePool.getInstance((Context)ctx).releaseTable(this.tempTable);
        TempTablePool.getInstance((Context)ctx).releaseTable(this.tempTableB);
    }

    private void buildTempTable(Context ctx, String companyId, java.util.Date date) throws SQLException {
        if (this.tempTable == null) {
            this.getTempTable(ctx);
        }
        StringBuffer insertSql = new StringBuffer();
        Calendar now = Calendar.getInstance();
        int year = now.get(1);
        if (date != null) {
            now.setTime(date);
            if (year - 1 > now.get(1)) {
                return;
            }
            year = now.get(1);
        }
        insertSql.append("INSERT INTO ").append(this.tempTable).append(" \n");
        insertSql.append("\t(\tFID, FYear, FPersonID, FExpenseTypeID, FCurrencyID, FAdminID, FCompanyID, FSettingID, FAccountStandardID, FMonthLimit) \n");
        insertSql.append("\t( \n");
        insertSql.append("\t\tSELECT DISTINCT newbosid('4A44F49F') fid,?, setting.fpersonid fpersonid, setting.fexpensetypeid fexpensetypeid, stand.fcurrencytypeid fcurrencyid, setting.fadminorgunitid,setting.fcompanyorgunitid, \n");
        insertSql.append("\t\t\t   setting.fid FSettingID, stand.fid faccountstandardid, stand.fmonthlimit fmonthlimit\n");
        insertSql.append("\t\tFROM t_bc_reimburselevelsetting setting \n");
        insertSql.append("\t\tINNER JOIN t_bc_accountstandard stand \n");
        insertSql.append("\t\t\tON stand.fexpensetypeid = setting.fexpensetypeid AND stand.freimburselvid = setting.freimburselevelid AND setting.fcompanyorgunitid = stand.fcompanyid \n");
        insertSql.append("\t\tWHERE \n");
        insertSql.append("\t\t\tsetting.fstate = 20 AND stand.fstate = 1 \n");
        insertSql.append("\t\t\tAND setting.fcompanyorgunitid = ? \n");
        insertSql.append("\t); \n");
        DbUtil.executeUpdate((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{year, companyId});
        insertSql.setLength(0);
        insertSql.append("INSERT INTO ").append(this.tempTableB).append(" \n");
        insertSql.append("\t(\tFID, FPersonID, FExpenseTypeID, FCurrencyID, FAdminID, FCompanyID, FSettingID, FAccountStandardID, FMonthLimit) \n");
        insertSql.append("\t( \n");
        insertSql.append("\t\tSELECT DISTINCT newbosid('4A44F49F'), setting.fpersonid, setting.fexpensetypeid, stand.fcurrencytypeid, setting.fadminorgunitid,setting.fcompanyorgunitid, \n");
        insertSql.append("\t\t\t   setting.fid, stand.fid, stand.fmonthlimit \n");
        insertSql.append("\t\tFROM t_bc_reimburselevelsetting setting \n");
        insertSql.append("\t\tINNER JOIN t_bc_accountstdassignorg assign \n");
        insertSql.append("\t\t\tON assign.fcompanyid = setting.fcompanyorgunitid \n");
        insertSql.append("\t\tINNER JOIN t_bc_accountstandard stand \n");
        insertSql.append("\t\t\tON stand.fid = assign.faccountstandardid \n");
        insertSql.append("\t\tWHERE \n");
        insertSql.append("\t\t\tstand.fexpensetypeid = setting.fexpensetypeid AND stand.freimburselvid = setting.freimburselevelid \n");
        insertSql.append("\t\t\tAND setting.fstate = 20 AND stand.fstate = 1 \n");
        insertSql.append("\t\t\tAND setting.fcompanyorgunitid = ? \n");
        insertSql.append("\t); \n");
        DbUtil.executeUpdate((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{companyId});
        insertSql.setLength(0);
        insertSql.append("INSERT INTO ").append(this.tempTable).append(" \n");
        insertSql.append("\t(\tFID, FYear, FPersonID, FExpenseTypeID, FCurrencyID, FAdminID, FCompanyID, FSettingID, FAccountStandardID, FMonthLimit) \n");
        insertSql.append("\t( \n");
        insertSql.append("\t\tSELECT tb.fid, ?, tb.fpersonid, tb.fexpensetypeid, tb.fcurrencyid, tb.fadminid, tb.fcompanyid, \n");
        insertSql.append("\t\t\t   tb.fsettingid, tb.faccountstandardid, tb.fmonthlimit\n");
        insertSql.append("\t\tFROM ").append(this.tempTableB).append(" tb \n");
        insertSql.append("\t\tWHERE NOT EXISTS ( SELECT 1 FROM ").append(this.tempTable).append(" t \n");
        insertSql.append("\t\t\t\t\tWHERE tb.fpersonid = t.fpersonid AND tb.fexpensetypeid = t.fexpensetypeid AND tb.fcurrencyid = t.fcurrencyid \n");
        insertSql.append("\t\t\t  ) \n");
        insertSql.append("\t); \n");
        DbUtil.executeUpdate((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{year});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _updateAllLimit(Context ctx, String companyId, java.util.Date date) throws BOSException, EASBizException {
        try {
            this.buildTempTable(ctx, companyId, date);
            this.updateLimit(ctx, null, null, date, companyId);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            this.releaseTempTable(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _updateByAccountSTDs(Context ctx, String companyId, List stds, java.util.Date date) throws BOSException, EASBizException {
        try {
            this.buildTempTable(ctx, companyId, date);
            this.updateLimit(ctx, null, stds, date, companyId);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            this.releaseTempTable(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _updateByReimburseLVs(Context ctx, String companyId, List lvs, java.util.Date date) throws BOSException, EASBizException {
        try {
            this.buildTempTable(ctx, companyId, date);
            this.updateLimit(ctx, lvs, null, date, companyId);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            this.releaseTempTable(ctx);
        }
    }

    private void updateLimit(Context ctx, List lvIds, List standIds, java.util.Date date, String companyId) throws SQLException, StandardException {
        int i;
        StringBuffer updateSql = new StringBuffer();
        StringBuffer insertSql = new StringBuffer();
        StringBuffer select = new StringBuffer();
        StringBuffer selectItem = new StringBuffer();
        Calendar now = Calendar.getInstance();
        int year = now.get(1);
        int month = 0;
        if (date != null) {
            now.setTime(date);
            month = now.get(2);
            if (year - 1 > now.get(1)) {
                throw new StandardException(StandardException.ACCOUNTLIMTPREYEAR);
            }
            year = now.get(1);
        }
        for (int j = 0; j < month; ++j) {
            selectItem.append("0,");
        }
        String[] months = new String[]{"fone", "ftwo", "fthree", "ffour", "ffive", "fsix", "fseven", "feight", "fnine", "ften", "feleven", "ftwelve"};
        String tempWhere = null;
        if (lvIds != null) {
            tempWhere = "t.fsettingid in ( " + this.getSqlStringByList(ctx, lvIds) + " )";
        }
        if (standIds != null) {
            tempWhere = "t.faccountstandardid in ( " + this.getSqlStringByList(ctx, standIds) + " )";
        }
        updateSql.append("UPDATE t_bc_accountlimit accountlimit SET ( \n");
        for (i = month; i < 12; ++i) {
            updateSql.append(months[i]).append(",");
            select.append("t.fmonthlimit,");
            selectItem.append("t.fmonthlimit,");
        }
        updateSql.deleteCharAt(updateSql.length() - 1);
        select.deleteCharAt(select.length() - 1);
        updateSql.append(", faccountstdid) = ( SELECT ").append(select).append(",t.faccountstandardid FROM \n");
        updateSql.append("\t\t").append(this.tempTable).append(" t \n");
        updateSql.append("\t\tWHERE \n");
        updateSql.append("\t\t\taccountlimit.fpersonid = t.fpersonid AND accountlimit.fexpensetypeid = t.fexpensetypeid AND accountlimit.fcurrencyid = t.fcurrencyid  \n");
        updateSql.append("\t\t\tAND accountlimit.fcompanyorgunitid = t.fcompanyid AND accountlimit.fyear = t.fyear");
        if (tempWhere != null) {
            updateSql.append("\t \tAND ").append(tempWhere);
        }
        updateSql.append("\t  ) \n");
        DbUtil.executeUpdate((Context)ctx, (String)updateSql.toString(), null);
        insertSql.append("INSERT INTO t_bc_accountlimit \n");
        insertSql.append("\t(\tfid, fpersonid, fexpensetypeid, fcurrencyid, fyear, faccountstdid, fadminorgunitid, fcompanyorgunitid, \n");
        insertSql.append("\t\tfone, ftwo, fthree, ffour, ffive, fsix, fseven, feight, fnine, ften, feleven, ftwelve, \n");
        insertSql.append("\t\tfcreatorid, fcreatetime ) \n");
        insertSql.append("\t( \n");
        insertSql.append("\t\tSELECT newbosid('98E4E4EC'), t.fpersonid, t.fexpensetypeid, t.fcurrencyid, t.fyear, t.faccountstandardid, t.fadminid, t.fcompanyid, \n");
        insertSql.append(selectItem);
        insertSql.append("\t\t\t   ?,getDate() \n");
        insertSql.append("\t\tFROM ").append(this.tempTable).append(" t \n");
        insertSql.append("\t\tWHERE  NOT EXISTS ( SELECT 1 FROM t_bc_accountlimit accountlimit \n");
        insertSql.append("\t\t\t\tWHERE accountlimit.fpersonid = t.fpersonid AND accountlimit.fexpensetypeid = t.fexpensetypeid AND accountlimit.fcurrencyid = t.fcurrencyid AND accountlimit.fyear = t.fyear AND accountlimit.fcompanyorgunitid = ? \n");
        insertSql.append("\t\t\t\t) \n");
        if (tempWhere != null) {
            insertSql.append("\t \tAND ").append(tempWhere);
        }
        insertSql.append("\t)");
        DbUtil.executeUpdate((Context)ctx, (String)insertSql.toString(), (Object[])new Object[]{null, companyId});
        updateSql.setLength(0);
        select.setLength(0);
        updateSql.append("UPDATE t_bc_accountlimit accountlimit SET ( \n");
        for (i = month; i < 12; ++i) {
            updateSql.append(months[i]).append(",");
            select.append("0,");
        }
        updateSql.deleteCharAt(updateSql.length() - 1);
        select.deleteCharAt(select.length() - 1);
        updateSql.append(") = ( SELECT ").append(select).append(" ) \n");
        updateSql.append("WHERE NOT EXISTS ( \n");
        updateSql.append("\tSELECT 1 FROM ").append(this.tempTable).append(" t \n");
        updateSql.append("\t\tWHERE accountlimit.fpersonid = t.fpersonid AND accountlimit.fexpensetypeid = t.fexpensetypeid AND accountlimit.fcurrencyid = t.fcurrencyid AND accountlimit.fcompanyorgunitid = t.fcompanyid AND accountlimit.fyear = t.fyear \n");
        updateSql.append("\t  \t) \n");
        updateSql.append("AND accountlimit.fyear = ? AND accountlimit.fcompanyorgunitid = ? \n");
        if (lvIds != null) {
            updateSql.append("\tAND EXISTS ( \n");
            updateSql.append("\t\tSELECT 1 FROM ").append("t_bc_reimburselevelsetting setting \n");
            updateSql.append("\t\t\tWHERE accountlimit.fpersonid = setting.fpersonid AND accountlimit.fexpensetypeid = setting.fexpensetypeid \n");
            updateSql.append("\t\t\t\tAND setting.fid in (").append(this.getSqlStringByList(ctx, lvIds)).append(") \n");
            updateSql.append("\t  \t) \n");
        }
        DbUtil.executeUpdate((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{year, companyId});
    }

    private String getSqlStringByList(Context ctx, List ids) {
        if (ids == null || ids.size() == 0) {
            return "'nodata'";
        }
        StringBuffer result = new StringBuffer();
        for (String id : ids) {
            result.append("'").append(id).append("',");
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    private void checkIsCanUpdateLimit(Context ctx, String companyId) throws SQLException, StandardException {
        boolean isHasSet = false;
        boolean isHasSTD = false;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT 1 FROM t_bc_reimburselevelsetting setting \n");
        sql.append("\t\tINNER JOIN t_bd_person person \n");
        sql.append("\t\t\tON setting.fpersonid = person.fid \n");
        sql.append("\t\tINNER JOIN t_org_positionmember member \n");
        sql.append("\t\t\tON person.fid = member.fpersonid \n");
        sql.append("\t\tINNER JOIN t_org_position position \n");
        sql.append("\t\t\tON member.fpositionid = position.fid \n");
        sql.append("\t\tINNER JOIN t_org_admin admin \n");
        sql.append("\t\t\tON position.fadminorgunitid = admin.fid \n");
        sql.append("\t\tINNER JOIN t_org_unitrelation unitRelation \n");
        sql.append("\t\t\tON admin.fid = unitRelation.ffromunitid \n");
        sql.append("\t\tINNER JOIN t_org_company company \n");
        sql.append("\t\t\tON unitRelation.ftounitid = company.fid \n");
        sql.append("\t\tINNER JOIN t_org_typerelation typeRelation \n");
        sql.append("\t\t\tON unitRelation.ftyperelationid = typeRelation.fid \n");
        sql.append("\t\tWHERE \n");
        sql.append("\t\t\tmember.fisprimary = 1 AND typeRelation.ffromtype = 0 AND typeRelation.ftotype = 1 \n");
        sql.append("\t\t\tAND setting.fstate = 20 \n");
        sql.append("\t\t\tAND company.fid = ? \n");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId});
        if (rows.next()) {
            isHasSet = true;
        }
        sql.setLength(0);
        sql.append("SELECT 1 FROM t_bc_accountstandard stand \n");
        sql.append("\t\tLEFT JOIN t_bc_accountstdassignorg assign \n");
        sql.append("\t\t\tON stand.fid = assign.faccountstandardid \n");
        sql.append("\t\tWHERE \n");
        sql.append("\t\t\tstand.fstate = 1 \n");
        sql.append("\t\t\tAND (stand.fcompanyid = ? OR assign.fcompanyid = ?) \n");
        rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, companyId});
        if (rows.next()) {
            isHasSTD = true;
        }
        if (!isHasSet) {
            throw new StandardException(StandardException.PLEASECHECKREIMBURSELEVELSET);
        }
        if (!isHasSTD) {
            throw new StandardException(StandardException.PLEASECHECKREIMBURSELEVELSET);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _deleteLimit(Context ctx, List lvids, List stdids, String companyid) throws BOSException, EASBizException {
        try {
            this.buildTempTable(ctx, companyid, null);
            this.delLimit(ctx, lvids, stdids, companyid);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            this.releaseTempTable(ctx);
        }
    }

    private void delLimit(Context ctx, List lvIds, List stdIds, String companyId) throws SQLException {
        Calendar now = Calendar.getInstance();
        int year = now.get(1);
        int month = now.get(2);
        String[] months = new String[]{"fone", "ftwo", "fthree", "ffour", "ffive", "fsix", "fseven", "feight", "fnine", "ften", "feleven", "ftwelve"};
        StringBuffer updateSql = new StringBuffer();
        StringBuffer select = new StringBuffer();
        String tempWhere = null;
        if (lvIds != null) {
            tempWhere = "t.fsettingid in ( " + this.getSqlStringByList(ctx, lvIds) + " )";
        }
        if (stdIds != null) {
            tempWhere = "t.faccountstandardid in ( " + this.getSqlStringByList(ctx, stdIds) + " )";
        }
        updateSql.append("UPDATE t_bc_accountlimit accountlimit SET ( \n");
        for (int i = month; i < 12; ++i) {
            updateSql.append(months[i]).append(",");
            select.append("0,");
        }
        updateSql.deleteCharAt(updateSql.length() - 1);
        select.deleteCharAt(select.length() - 1);
        updateSql.append(") = ( SELECT ").append(select).append(" ) \n");
        updateSql.append("WHERE NOT EXISTS ( \n");
        updateSql.append("\tSELECT 1 FROM ").append(this.tempTable).append(" t \n");
        updateSql.append("\t\tWHERE accountlimit.fpersonid = t.fpersonid AND accountlimit.fexpensetypeid = t.fexpensetypeid AND accountlimit.fcurrencyid = t.fcurrencyid AND accountlimit.fcompanyorgunitid = t.fcompanyid AND accountlimit.fyear = t.fyear \n");
        if (tempWhere != null) {
            updateSql.append("\tAND t.fsettingid in (").append(this.getSqlStringByList(ctx, lvIds)).append(") \n");
        }
        updateSql.append("\t  \t) \n");
        updateSql.append("AND accountlimit.fyear = ? AND accountlimit.fcompanyorgunitid = ? \n");
        if (lvIds != null) {
            updateSql.append("\tAND EXISTS ( \n");
            updateSql.append("\t\tSELECT 1 FROM ").append("t_bc_reimburselevelsetting setting \n");
            updateSql.append("\t\t\tWHERE accountlimit.fpersonid = setting.fpersonid AND accountlimit.fexpensetypeid = setting.fexpensetypeid \n");
            updateSql.append("\t\t\t\tAND setting.fid in (").append(this.getSqlStringByList(ctx, lvIds)).append(") \n");
            updateSql.append("\t  \t) \n");
        }
        DbUtil.executeUpdate((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{year, companyId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _countAmountByLimitIds(Context ctx, List limitIds, java.util.Date beginDate, java.util.Date endDate) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmtInsert = null;
        HashMap<String, String> result = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT accountlimit.fid id, \n");
        sql.append("\tSUM(CASE WHEN bill.fstate in (25, 30) THEN entry.famountori WHEN bill.fstate >= 45 THEN entry.famountapprovedori END) amount ");
        sql.append(" FROM t_bc_accountlimit accountlimit \n");
        sql.append(" INNER JOIN t_bc_bizaccountbill bill \n");
        sql.append(" \tON accountlimit.fpersonid = bill.fapplierid \n");
        sql.append(" INNER JOIN t_bc_bizaccountbillentry entry \n");
        sql.append("\tON bill.fid = entry.fbillid \n");
        sql.append(" WHERE \n");
        sql.append("\taccountlimit.fcurrencyid = entry.fcurrencyid AND accountlimit.fexpensetypeid = entry.fexpensetypeid\n");
        sql.append("\tAND entry.fhappentime between ? and ? \n");
        sql.append("\tAND accountlimit.fid in (").append(this.getSqlStringByList(ctx, limitIds)).append(") \n");
        sql.append(" GROUP BY accountlimit.fid \n");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtInsert = conn.prepareStatement(sql.toString());
            pstmtInsert.setDate(1, new Date(beginDate.getTime()));
            pstmtInsert.setDate(2, new Date(endDate.getTime()));
            ResultSet rowSet = pstmtInsert.executeQuery();
            while (rowSet.next()) {
                result.put(rowSet.getString("id"), rowSet.getString("amount"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
        }
        SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _countAmountByLimitIds(Context ctx, List limitIds, java.util.Date beginDate, java.util.Date endDate, String companyId) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmtInsert = null;
        HashMap<String, String> result = new HashMap<String, String>();
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP050");
        Map params = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, companyId);
        boolean isCalCurCompany = new Boolean(params.get("CP050").toString());
        String companyProperty = "fappliercompanyid";
        String exCompanyProperty = AccountLimitFilterFacadeFactory.getLocalInstance(ctx).getCompanyKey();
        if (exCompanyProperty != null && exCompanyProperty.length() > 0) {
            companyProperty = exCompanyProperty;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT accountlimit.fid id, \n");
        sql.append("\tSUM(CASE WHEN bill.fstate in (25, 30) THEN entry.famountori WHEN bill.fstate >= 45 THEN entry.famountapprovedori END) amount ");
        sql.append(" FROM t_bc_accountlimit accountlimit \n");
        sql.append(" INNER JOIN t_bc_bizaccountbill bill \n");
        sql.append(" \tON accountlimit.fpersonid = bill.fapplierid \n");
        sql.append(" INNER JOIN t_bc_bizaccountbillentry entry \n");
        sql.append("\tON bill.fid = entry.fbillid \n");
        sql.append(" WHERE \n");
        sql.append("\taccountlimit.fcurrencyid = entry.fcurrencyid AND accountlimit.fexpensetypeid = entry.fexpensetypeid\n");
        if (isCalCurCompany) {
            sql.append("\tAND accountlimit.fcompanyorgunitid = bill." + companyProperty + " \n");
        } else {
            sql.append("\tAND bill.fappliercompanyid in \n");
            sql.append("\t(SELECT paramitem.forgunitid FROM T_Bas_paramitem paramitem \n");
            sql.append("WHERE paramitem.fkeyid in \n");
            sql.append("\t(SELECT param.fid FROM T_BAS_Param param \n");
            sql.append("WHERE param.fnumber = 'CP027') \n");
            sql.append("\tAND paramitem.fvalue_l2 = 'true') \n");
        }
        sql.append("\tAND entry.fhappentime between ? and ? \n");
        sql.append("\tAND accountlimit.fid in (").append(this.getSqlStringByList(ctx, limitIds)).append(") \n");
        sql.append(" GROUP BY accountlimit.fid \n");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtInsert = conn.prepareStatement(sql.toString());
            pstmtInsert.setDate(1, new Date(beginDate.getTime()));
            pstmtInsert.setDate(2, new Date(endDate.getTime()));
            ResultSet rowSet = pstmtInsert.executeQuery();
            while (rowSet.next()) {
                result.put(rowSet.getString("id"), rowSet.getString("amount"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
        }
        SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
        logger.error((Object)("---cpbc---countAmountByLimitIds---sql:" + sql.toString() + "result:" + result));
        return result;
    }

    @Override
    @Deprecated
    protected List _getLimitDetail(Context ctx, String accountLimitId, int year) throws BOSException, EASBizException {
        if (accountLimitId == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(accountLimitId);
        HashMap<String, Object> limitMap = new HashMap<String, Object>();
        limitMap.put("year", ResourceBase.getString((String)WEBRES, (String)"LIMIT", (Locale)ctx.getLocale()));
        HashMap<String, Object> usedMap = new HashMap<String, Object>();
        usedMap.put("year", ResourceBase.getString((String)WEBRES, (String)"USEDLIMIT", (Locale)ctx.getLocale()));
        HashMap<String, Object> adjustMap = new HashMap<String, Object>();
        adjustMap.put("year", ResourceBase.getString((String)WEBRES, (String)"ADJUSTLIMIT", (Locale)ctx.getLocale()));
        HashMap<String, Object> balanceMap = new HashMap<String, Object>();
        java.util.Date beginDate = null;
        java.util.Date endDate = null;
        Calendar ca = Calendar.getInstance();
        int month = 12;
        if (String.valueOf(year).indexOf(ca.get(1)) > -1) {
            month = ca.get(2) + 1;
        }
        String[] months = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve"};
        String[] monthsAdjust = new String[]{"oneAdjust", "twoAdjust", "threeAdjust", "fourAdjust", "fiveAdjust", "sixAdjust", "sevenAdjust", "eightAdjust", "nightAdjust", "tenAdjust", "elevenAdjust", "twelveAdjust"};
        AccountLimitInfo accountLimit = this.getAccountLimitInfo(ctx, "select expenseType.id,expensetype.controlMethod,one,two,three,four,five,six,seven,eight,nine,ten,eleven,twelve,oneAdjust,twoAdjust,threeAdjust,fourAdjust,fiveAdjust,sixAdjust,sevenAdjust,eightAdjust,nightAdjust,tenAdjust,elevenAdjust,twelveAdjust where id = '" + accountLimitId + "'");
        ExpenseTypeInfo expenseType = accountLimit.getExpenseType();
        if (expenseType.getControlMethod().equals((Object)ControlMethod.month)) {
            balanceMap.put("year", ResourceBase.getString((String)WEBRES, (String)"MONTHBALANCELIMIT", (Locale)ctx.getLocale()));
        } else {
            balanceMap.put("year", ResourceBase.getString((String)WEBRES, (String)"TOTALBALANCELIMIT", (Locale)ctx.getLocale()));
        }
        BigDecimal lastBalance = new BigDecimal(0.0);
        for (int i = 0; i < month; ++i) {
            BigDecimal limit = accountLimit.getBigDecimal(months[i]);
            limitMap.put(months[i], limit);
            BigDecimal adjust = accountLimit.getBigDecimal(monthsAdjust[i]);
            adjustMap.put(months[i], adjust);
            ca.clear();
            ca.set(1, year);
            ca.set(2, i);
            beginDate = ca.getTime();
            ca.add(2, 1);
            ca.add(5, -1);
            endDate = ca.getTime();
            Map limitAmountMap = this._countAmountByLimitIds(ctx, ids, beginDate, endDate);
            BigDecimal used = limitAmountMap.get(accountLimitId) == null ? new BigDecimal(0.0) : new BigDecimal(limitAmountMap.get(accountLimitId).toString());
            usedMap.put(months[i], used);
            BigDecimal balance = limit.subtract(used.add(adjust));
            lastBalance = lastBalance.add(balance);
            if (expenseType.getControlMethod().equals((Object)ControlMethod.month)) {
                balanceMap.put(months[i], balance);
                continue;
            }
            balanceMap.put(months[i], lastBalance);
        }
        result.add(limitMap);
        result.add(usedMap);
        result.add(adjustMap);
        result.add(balanceMap);
        return result;
    }

    @Override
    protected List _getLimitDetail(Context ctx, String accountLimitId, String companyId, int year) throws BOSException, EASBizException {
        if (accountLimitId == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(accountLimitId);
        HashMap<String, Object> limitMap = new HashMap<String, Object>();
        limitMap.put("year", ResourceBase.getString((String)WEBRES, (String)"LIMIT", (Locale)ctx.getLocale()));
        HashMap<String, Object> usedMap = new HashMap<String, Object>();
        usedMap.put("year", ResourceBase.getString((String)WEBRES, (String)"USEDLIMIT", (Locale)ctx.getLocale()));
        HashMap<String, Object> adjustMap = new HashMap<String, Object>();
        adjustMap.put("year", ResourceBase.getString((String)WEBRES, (String)"ADJUSTLIMIT", (Locale)ctx.getLocale()));
        HashMap<String, Object> balanceMap = new HashMap<String, Object>();
        java.util.Date beginDate = null;
        java.util.Date endDate = null;
        Calendar ca = Calendar.getInstance();
        int month = 12;
        if (String.valueOf(year).indexOf(ca.get(1)) > -1) {
            month = ca.get(2) + 1;
        }
        String[] months = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve"};
        String[] monthsAdjust = new String[]{"oneAdjust", "twoAdjust", "threeAdjust", "fourAdjust", "fiveAdjust", "sixAdjust", "sevenAdjust", "eightAdjust", "nightAdjust", "tenAdjust", "elevenAdjust", "twelveAdjust"};
        AccountLimitInfo accountLimit = this.getAccountLimitInfo(ctx, "select expenseType.id,expensetype.controlMethod,one,two,three,four,five,six,seven,eight,nine,ten,eleven,twelve,oneAdjust,twoAdjust,threeAdjust,fourAdjust,fiveAdjust,sixAdjust,sevenAdjust,eightAdjust,nightAdjust,tenAdjust,elevenAdjust,twelveAdjust where id = '" + accountLimitId + "'");
        ExpenseTypeInfo expenseType = accountLimit.getExpenseType();
        if (expenseType.getControlMethod().equals((Object)ControlMethod.month)) {
            balanceMap.put("year", ResourceBase.getString((String)WEBRES, (String)"MONTHBALANCELIMIT", (Locale)ctx.getLocale()));
        } else {
            balanceMap.put("year", ResourceBase.getString((String)WEBRES, (String)"TOTALBALANCELIMIT", (Locale)ctx.getLocale()));
        }
        BigDecimal lastBalance = new BigDecimal(0.0);
        for (int i = 0; i < month; ++i) {
            BigDecimal limit = new BigDecimal(0.0);
            if (null != accountLimit.getBigDecimal(months[i])) {
                limit = accountLimit.getBigDecimal(months[i]);
            }
            limitMap.put(months[i], limit);
            BigDecimal adjust = accountLimit.getBigDecimal(monthsAdjust[i]) == null ? BigDecimal.ZERO : accountLimit.getBigDecimal(monthsAdjust[i]);
            adjustMap.put(months[i], adjust);
            ca.clear();
            ca.set(1, year);
            ca.set(2, i);
            beginDate = ca.getTime();
            ca.add(2, 1);
            ca.add(5, -1);
            endDate = ca.getTime();
            Map limitAmountMap = this._countAmountByLimitIds(ctx, ids, beginDate, endDate, companyId);
            BigDecimal used = limitAmountMap.get(accountLimitId) == null ? new BigDecimal(0.0) : new BigDecimal(limitAmountMap.get(accountLimitId).toString());
            usedMap.put(months[i], used);
            BigDecimal balance = limit.subtract(used.add(adjust));
            lastBalance = lastBalance.add(balance);
            if (expenseType.getControlMethod().equals((Object)ControlMethod.month)) {
                balanceMap.put(months[i], balance);
                continue;
            }
            balanceMap.put(months[i], lastBalance);
        }
        result.add(limitMap);
        result.add(usedMap);
        result.add(adjustMap);
        result.add(balanceMap);
        return result;
    }

    @Override
    protected Map _getTotalAdjustAmountByLimitIds(Context ctx, List limitIds) throws BOSException {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        try {
            Calendar calendar = Calendar.getInstance();
            int year = calendar.get(1);
            int month = calendar.get(2);
            String[] selectAdjustItem = new String[]{"foneAdjust", "ftwoAdjust", "fthreeAdjust", "ffourAdjust", "ffiveAdjust", "fsixAdjust", "fsevenAdjust", "feightAdjust", "fnightAdjust", "ftenAdjust", "felevenAdjust", "ftwelveAdjust"};
            StringBuffer oql = new StringBuffer();
            oql.append("select fid id,");
            for (int i = 0; i <= month; ++i) {
                oql.append(selectAdjustItem[i]).append(" + ");
            }
            oql.deleteCharAt(oql.length() - 2);
            oql.append(" totalAdjustAmount from t_bc_accountlimit ");
            oql.append("\tWHERE fid in (").append(this.getSqlStringByList(ctx, limitIds)).append(") \n");
            IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), null);
            while (rows.next()) {
                result.put(rows.getString("id"), rows.getBigDecimal("totalAdjustAmount"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountLimitInfo accountLimitInfo = (AccountLimitInfo)model;
        CompanyOrgUnitInfo companyInfo = accountLimitInfo.getCompanyOrgUnit();
        CompanyOrgUnitInfo companyInfoEx = AccountLimitFilterFacadeFactory.getLocalInstance(ctx).getFilterWithCompany(companyInfo);
        if (companyInfoEx != null) {
            accountLimitInfo.setCompanyOrgUnit(companyInfoEx);
        }
        this.isExitStandard(ctx, accountLimitInfo);
        this.removeCarryOverDate(accountLimitInfo);
        accountLimitInfo.setIsStart(false);
        IObjectPK objectPK = super._save(ctx, (IObjectValue)accountLimitInfo);
        return objectPK;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AccountLimitInfo accountLimitInfo = (AccountLimitInfo)model;
        this.isExitStandard(ctx, accountLimitInfo);
        IObjectPK objectPK1 = super._save(ctx, (IObjectValue)this.CarryOverInfo(ctx, accountLimitInfo));
        this.removeCarryOverDate(accountLimitInfo);
        IObjectPK objectPK = super._save(ctx, (IObjectValue)accountLimitInfo);
        return objectPK;
    }

    private void removeCarryOverDate(AccountLimitInfo accountLimitInfo) {
        if (accountLimitInfo.getCarryOverDate() == 0) {
            accountLimitInfo.remove("carryOverDate");
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AccountLimitInfo toInfo = this.getAccountLimitInfo(ctx, pk);
        AccountLimitInfo fromInfo = null;
        CompanyOrgUnitInfo currentCompany = toInfo.getCompanyOrgUnit();
        java.util.Date beginDate = null;
        java.util.Date endDate = null;
        java.util.Date beginDate1 = null;
        java.util.Date endDate1 = null;
        Calendar ca = Calendar.getInstance();
        ca.set(5, 1);
        beginDate = ca.getTime();
        ca.add(2, 1);
        ca.add(5, -1);
        endDate = ca.getTime();
        endDate1 = ca.getTime();
        ca.clear();
        ca.set(1, toInfo.getYear());
        beginDate1 = ca.getTime();
        String id = toInfo.getId().toString();
        ArrayList<String> limitIds = new ArrayList<String>();
        limitIds.add(id);
        Map monthAmountMap = this._countAmountByLimitIds(ctx, limitIds, beginDate, endDate, currentCompany.getId().toString());
        Map totalAmountMap = this._countAmountByLimitIds(ctx, limitIds, beginDate1, endDate1, currentCompany.getId().toString());
        String[] months = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve"};
        BigDecimal monthAmount = monthAmountMap.get(id) == null ? new BigDecimal(0.0) : new BigDecimal(monthAmountMap.get(id).toString());
        BigDecimal totalAmount = totalAmountMap.get(id) == null ? new BigDecimal(0.0) : new BigDecimal(totalAmountMap.get(id).toString());
        Integer controlMethod = toInfo.getExpenseType().getControlMethod().getValue();
        if (((Object)controlMethod).equals(ControlMethod.total.getValue())) {
            if (totalAmount.compareTo(new BigDecimal(0)) > 0) {
                throw new StandardException(StandardException.NOTDELETE_HASTOTALAMOUNT, new Object[]{totalAmount});
            }
        } else if (monthAmount.compareTo(new BigDecimal(0)) > 0) {
            throw new StandardException(StandardException.NOTDELETE_HASMONTHAMOUNT, new Object[]{monthAmount});
        }
        if (null != toInfo.getFromBill()) {
            fromInfo = this.getAccountLimitInfo(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)toInfo.getFromBill())));
            int carryOverDate = 0;
            carryOverDate = fromInfo.getCarryOverDate();
            IAccountLimit iacc = AccountLimitFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("one"));
            sic.add(new SelectorItemInfo("two"));
            sic.add(new SelectorItemInfo("three"));
            sic.add(new SelectorItemInfo("four"));
            sic.add(new SelectorItemInfo("five"));
            sic.add(new SelectorItemInfo("six"));
            sic.add(new SelectorItemInfo("seven"));
            sic.add(new SelectorItemInfo("eight"));
            sic.add(new SelectorItemInfo("nine"));
            sic.add(new SelectorItemInfo("ten"));
            sic.add(new SelectorItemInfo("eleven"));
            sic.add(new SelectorItemInfo("twelve"));
            sic.add(new SelectorItemInfo("carryOverDate"));
            iacc.updatePartial((CoreBaseInfo)this.DelReverseSourceInfo(toInfo, carryOverDate, fromInfo), sic);
        }
        super._delete(ctx, pk);
    }

    private AccountLimitInfo DelReverseSourceInfo(AccountLimitInfo toInfo, int carryOverDate, AccountLimitInfo fromInfo) {
        switch (carryOverDate) {
            case 1: {
                fromInfo.setOne(toInfo.getOne());
                fromInfo.setTwo(toInfo.getTwo());
                fromInfo.setThree(toInfo.getThree());
                fromInfo.setFour(toInfo.getFour());
                fromInfo.setFive(toInfo.getFive());
                fromInfo.setSix(toInfo.getSix());
                fromInfo.setSeven(toInfo.getSeven());
                fromInfo.setEight(toInfo.getEight());
                fromInfo.setNine(toInfo.getNine());
                fromInfo.setTen(toInfo.getTen());
                fromInfo.setEleven(toInfo.getEleven());
                fromInfo.setTwelve(toInfo.getTwelve());
                fromInfo.setCarryOverDate(0);
                break;
            }
            case 2: {
                fromInfo.setTwo(toInfo.getTwo());
                fromInfo.setThree(toInfo.getThree());
                fromInfo.setFour(toInfo.getFour());
                fromInfo.setFive(toInfo.getFive());
                fromInfo.setSix(toInfo.getSix());
                fromInfo.setSeven(toInfo.getSeven());
                fromInfo.setEight(toInfo.getEight());
                fromInfo.setNine(toInfo.getNine());
                fromInfo.setTen(toInfo.getTen());
                fromInfo.setEleven(toInfo.getEleven());
                fromInfo.setTwelve(toInfo.getTwelve());
                fromInfo.setCarryOverDate(0);
                break;
            }
            case 3: {
                fromInfo.setThree(toInfo.getThree());
                fromInfo.setFour(toInfo.getFour());
                fromInfo.setFive(toInfo.getFive());
                fromInfo.setSix(toInfo.getSix());
                fromInfo.setSeven(toInfo.getSeven());
                fromInfo.setEight(toInfo.getEight());
                fromInfo.setNine(toInfo.getNine());
                fromInfo.setTen(toInfo.getTen());
                fromInfo.setEleven(toInfo.getEleven());
                fromInfo.setTwelve(toInfo.getTwelve());
                fromInfo.setCarryOverDate(0);
                break;
            }
            case 4: {
                fromInfo.setFour(toInfo.getFour());
                fromInfo.setFive(toInfo.getFive());
                fromInfo.setSix(toInfo.getSix());
                fromInfo.setSeven(toInfo.getSeven());
                fromInfo.setEight(toInfo.getEight());
                fromInfo.setNine(toInfo.getNine());
                fromInfo.setTen(toInfo.getTen());
                fromInfo.setEleven(toInfo.getEleven());
                fromInfo.setTwelve(toInfo.getTwelve());
                fromInfo.setCarryOverDate(0);
                break;
            }
            case 5: {
                fromInfo.setFive(toInfo.getFive());
                fromInfo.setSix(toInfo.getSix());
                fromInfo.setSeven(toInfo.getSeven());
                fromInfo.setEight(toInfo.getEight());
                fromInfo.setNine(toInfo.getNine());
                fromInfo.setTen(toInfo.getTen());
                fromInfo.setEleven(toInfo.getEleven());
                fromInfo.setTwelve(toInfo.getTwelve());
                fromInfo.setCarryOverDate(0);
                break;
            }
            case 6: {
                fromInfo.setSix(toInfo.getSix());
                fromInfo.setSeven(toInfo.getSeven());
                fromInfo.setEight(toInfo.getEight());
                fromInfo.setNine(toInfo.getNine());
                fromInfo.setTen(toInfo.getTen());
                fromInfo.setEleven(toInfo.getEleven());
                fromInfo.setTwelve(toInfo.getTwelve());
                fromInfo.setCarryOverDate(0);
                break;
            }
            case 7: {
                fromInfo.setSeven(toInfo.getSeven());
                fromInfo.setEight(toInfo.getEight());
                fromInfo.setNine(toInfo.getNine());
                fromInfo.setTen(toInfo.getTen());
                fromInfo.setEleven(toInfo.getEleven());
                fromInfo.setTwelve(toInfo.getTwelve());
                fromInfo.setCarryOverDate(0);
                break;
            }
            case 8: {
                fromInfo.setEight(toInfo.getEight());
                fromInfo.setNine(toInfo.getNine());
                fromInfo.setTen(toInfo.getTen());
                fromInfo.setEleven(toInfo.getEleven());
                fromInfo.setTwelve(toInfo.getTwelve());
                fromInfo.setCarryOverDate(0);
                break;
            }
            case 9: {
                fromInfo.setNine(toInfo.getNine());
                fromInfo.setTen(toInfo.getTen());
                fromInfo.setEleven(toInfo.getEleven());
                fromInfo.setTwelve(toInfo.getTwelve());
                fromInfo.setCarryOverDate(0);
                break;
            }
            case 10: {
                fromInfo.setTen(toInfo.getTen());
                fromInfo.setEleven(toInfo.getEleven());
                fromInfo.setTwelve(toInfo.getTwelve());
                fromInfo.setCarryOverDate(0);
                break;
            }
            case 11: {
                fromInfo.setEleven(toInfo.getEleven());
                fromInfo.setTwelve(toInfo.getTwelve());
                fromInfo.setCarryOverDate(0);
                break;
            }
            case 12: {
                fromInfo.setTwelve(toInfo.getTwelve());
                fromInfo.setCarryOverDate(0);
                break;
            }
        }
        this.removeCarryOverDate(fromInfo);
        return fromInfo;
    }

    private AccountLimitInfo CarryOverInfo(Context ctx, AccountLimitInfo accountLimitInfo) throws EASBizException, BOSException {
        AccountLimitInfo accountNew = (AccountLimitInfo)accountLimitInfo.clone();
        CompanyOrgUnitInfo companyFrom = accountLimitInfo.getCarryOverCompany();
        int carryOverDate = accountLimitInfo.getCarryOverDate();
        accountLimitInfo.setCompanyOrgUnit(companyFrom);
        accountNew.setId(BOSUuid.create((BOSObjectType)new AccountLimitInfo().getBOSType()));
        accountNew.setCarryOverCompany(null);
        accountNew.setCarryOverDate(0);
        accountNew.setFromBill(accountLimitInfo.getId().toString());
        BigDecimal zero = new BigDecimal(0.0);
        this.checkLimitForCarryOver(ctx, accountLimitInfo, carryOverDate);
        switch (carryOverDate) {
            case 1: {
                accountLimitInfo.setOne(zero);
                accountLimitInfo.setTwo(zero);
                accountLimitInfo.setThree(zero);
                accountLimitInfo.setFour(zero);
                accountLimitInfo.setFive(zero);
                accountLimitInfo.setSix(zero);
                accountLimitInfo.setSeven(zero);
                accountLimitInfo.setEight(zero);
                accountLimitInfo.setNine(zero);
                accountLimitInfo.setTen(zero);
                accountLimitInfo.setEleven(zero);
                accountLimitInfo.setTwelve(zero);
                break;
            }
            case 2: {
                accountLimitInfo.setTwo(zero);
                accountLimitInfo.setThree(zero);
                accountLimitInfo.setFour(zero);
                accountLimitInfo.setFive(zero);
                accountLimitInfo.setSix(zero);
                accountLimitInfo.setSeven(zero);
                accountLimitInfo.setEight(zero);
                accountLimitInfo.setNine(zero);
                accountLimitInfo.setTen(zero);
                accountLimitInfo.setEleven(zero);
                accountLimitInfo.setTwelve(zero);
                accountNew.setOne(zero);
                break;
            }
            case 3: {
                accountLimitInfo.setThree(zero);
                accountLimitInfo.setFour(zero);
                accountLimitInfo.setFive(zero);
                accountLimitInfo.setSix(zero);
                accountLimitInfo.setSeven(zero);
                accountLimitInfo.setEight(zero);
                accountLimitInfo.setNine(zero);
                accountLimitInfo.setTen(zero);
                accountLimitInfo.setEleven(zero);
                accountLimitInfo.setTwelve(zero);
                accountNew.setOne(zero);
                accountNew.setTwo(zero);
                break;
            }
            case 4: {
                accountLimitInfo.setFour(zero);
                accountLimitInfo.setFive(zero);
                accountLimitInfo.setSix(zero);
                accountLimitInfo.setSeven(zero);
                accountLimitInfo.setEight(zero);
                accountLimitInfo.setNine(zero);
                accountLimitInfo.setTen(zero);
                accountLimitInfo.setEleven(zero);
                accountLimitInfo.setTwelve(zero);
                accountNew.setOne(zero);
                accountNew.setTwo(zero);
                accountNew.setThree(zero);
                break;
            }
            case 5: {
                accountLimitInfo.setFive(zero);
                accountLimitInfo.setSix(zero);
                accountLimitInfo.setSeven(zero);
                accountLimitInfo.setEight(zero);
                accountLimitInfo.setNine(zero);
                accountLimitInfo.setTen(zero);
                accountLimitInfo.setEleven(zero);
                accountLimitInfo.setTwelve(zero);
                accountNew.setOne(zero);
                accountNew.setTwo(zero);
                accountNew.setThree(zero);
                accountNew.setFour(zero);
                break;
            }
            case 6: {
                accountLimitInfo.setSix(zero);
                accountLimitInfo.setSeven(zero);
                accountLimitInfo.setEight(zero);
                accountLimitInfo.setNine(zero);
                accountLimitInfo.setTen(zero);
                accountLimitInfo.setEleven(zero);
                accountLimitInfo.setTwelve(zero);
                accountNew.setOne(zero);
                accountNew.setTwo(zero);
                accountNew.setThree(zero);
                accountNew.setFour(zero);
                accountNew.setFive(zero);
                break;
            }
            case 7: {
                accountLimitInfo.setSeven(zero);
                accountLimitInfo.setEight(zero);
                accountLimitInfo.setNine(zero);
                accountLimitInfo.setTen(zero);
                accountLimitInfo.setEleven(zero);
                accountLimitInfo.setTwelve(zero);
                accountNew.setOne(zero);
                accountNew.setTwo(zero);
                accountNew.setThree(zero);
                accountNew.setFour(zero);
                accountNew.setFive(zero);
                accountNew.setSix(zero);
                break;
            }
            case 8: {
                accountLimitInfo.setEight(zero);
                accountLimitInfo.setNine(zero);
                accountLimitInfo.setTen(zero);
                accountLimitInfo.setEleven(zero);
                accountLimitInfo.setTwelve(zero);
                accountNew.setOne(zero);
                accountNew.setTwo(zero);
                accountNew.setThree(zero);
                accountNew.setFour(zero);
                accountNew.setFive(zero);
                accountNew.setSix(zero);
                accountNew.setSeven(zero);
                break;
            }
            case 9: {
                accountLimitInfo.setNine(zero);
                accountLimitInfo.setTen(zero);
                accountLimitInfo.setEleven(zero);
                accountLimitInfo.setTwelve(zero);
                accountNew.setOne(zero);
                accountNew.setTwo(zero);
                accountNew.setThree(zero);
                accountNew.setFour(zero);
                accountNew.setFive(zero);
                accountNew.setSix(zero);
                accountNew.setSeven(zero);
                accountNew.setEight(zero);
                break;
            }
            case 10: {
                accountLimitInfo.setTen(zero);
                accountLimitInfo.setEleven(zero);
                accountLimitInfo.setTwelve(zero);
                accountNew.setOne(zero);
                accountNew.setTwo(zero);
                accountNew.setThree(zero);
                accountNew.setFour(zero);
                accountNew.setFive(zero);
                accountNew.setSix(zero);
                accountNew.setSeven(zero);
                accountNew.setEight(zero);
                accountNew.setNine(zero);
                break;
            }
            case 11: {
                accountLimitInfo.setEleven(zero);
                accountLimitInfo.setTwelve(zero);
                accountNew.setOne(zero);
                accountNew.setTwo(zero);
                accountNew.setThree(zero);
                accountNew.setFour(zero);
                accountNew.setFive(zero);
                accountNew.setSix(zero);
                accountNew.setSeven(zero);
                accountNew.setEight(zero);
                accountNew.setNine(zero);
                accountNew.setTen(zero);
                break;
            }
            case 12: {
                accountLimitInfo.setTwelve(zero);
                accountNew.setOne(zero);
                accountNew.setTwo(zero);
                accountNew.setThree(zero);
                accountNew.setFour(zero);
                accountNew.setFive(zero);
                accountNew.setSix(zero);
                accountNew.setSeven(zero);
                accountNew.setEight(zero);
                accountNew.setNine(zero);
                accountNew.setTen(zero);
                accountNew.setEleven(zero);
                break;
            }
        }
        this.removeCarryOverDate(accountNew);
        return accountNew;
    }

    protected void isExitStandard(Context ctx, AccountLimitInfo accountLimitInfo) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)accountLimitInfo.getPerson().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("expenseType.id", (Object)accountLimitInfo.getExpenseType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)accountLimitInfo.getCurrency().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)accountLimitInfo.getYear()));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)accountLimitInfo.getCompanyOrgUnit().getId().toString()));
        evi.setFilter(filter);
        AccountLimitCollection alc = AccountLimitFactory.getLocalInstance(ctx).getAccountLimitCollection(evi);
        if (!alc.isEmpty()) {
            throw new StandardException(StandardException.ISNOTONLY);
        }
    }

    protected void checkLimitForCarryOver(Context ctx, AccountLimitInfo accountLimitInfo, int carryOverDate) throws EASBizException, BOSException {
        String limitId = accountLimitInfo.getId().toString();
        int controlMethod = accountLimitInfo.getExpenseType().getControlMethod().getValue();
        String[] months = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve"};
        Map totalLimitMap = BizCollUtil.getTotalAccountLimit(limitId);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("accountLimitId", limitId);
        parameters.put("companyId", accountLimitInfo.getCompanyOrgUnit().getId().toString());
        parameters.put("year", accountLimitInfo.getYear());
        parameters.put("curMonth", carryOverDate);
        Map usedLimitMap = BizCollUtil.getUsedAccountLimit(ctx, parameters, false);
        logger.error((Object)("---cpbc---AccountLimitControllerBean--limitId:" + limitId + ",curMonth:" + carryOverDate + ",totalResultMap:" + totalLimitMap + ",usedLimitMap:" + usedLimitMap));
        if (controlMethod == 0) {
            BigDecimal totalLimit = new BigDecimal(0);
            for (int i = 0; i < carryOverDate - 1; ++i) {
                totalLimit = totalLimit.add((BigDecimal)totalLimitMap.get(months[i]));
            }
            BigDecimal usedMonthLimit = (BigDecimal)usedLimitMap.get("totalLimitAmount");
            if (totalLimit.compareTo(usedMonthLimit) < 0) {
                throw new StandardException(StandardException.NOTCARRYOVER_MONTHLIMITOVER, new Object[]{usedMonthLimit, totalLimit});
            }
        } else {
            BigDecimal usedMonthLimit = (BigDecimal)usedLimitMap.get("monthLimitAmount");
            if (usedMonthLimit.compareTo(new BigDecimal(0)) > 0) {
                throw new StandardException(StandardException.NOTCARRYOVER_USEDMONTHLIMIT, new Object[]{usedMonthLimit});
            }
        }
    }
}

