/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountOutBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillLoanCheckEntryCollection;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.DailyLoanBillException;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseReqException;
import com.kingdee.eas.cp.bc.IExpenseAccountFacade;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.AbstractBizAccountOutBillControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BizAccountOutBillControllerBean
extends AbstractBizAccountOutBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.BizAccountOutBillControllerBean");

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BizAccountOutBillInfo info = (BizAccountOutBillInfo)model;
        BizAccountOutBillLoanCheckEntryCollection loanCheckEntries = info.getLoanCheckEntries();
        if (null != loanCheckEntries && loanCheckEntries.size() > 0) {
            info.setIsRelevanceLoan(true);
        } else {
            info.setIsRelevanceLoan(false);
        }
        this.savaAccesoryCount(ctx, info);
        return super._save(ctx, (IObjectValue)info);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BizAccountOutBillInfo info = (BizAccountOutBillInfo)model;
        BizAccountOutBillLoanCheckEntryCollection loanCheckEntries = info.getLoanCheckEntries();
        if (null != loanCheckEntries && loanCheckEntries.size() > 0) {
            info.setIsRelevanceLoan(true);
        } else {
            info.setIsRelevanceLoan(false);
        }
        this.savaAccesoryCount(ctx, info);
        IObjectPK retValue = super._submit(ctx, model);
        return retValue;
    }

    protected void reserveDelete(Context ctx, IObjectPK srcBillPK, ExpenseAccountBillInfo srcObj, BOTRelationInfo botObj, Locale local) throws BOSException, EASBizException {
        if (this.isSourceBillClose(ctx, srcObj)) {
            throw new BizCollException(BizCollException.ISSOURCEBILLCLOSE);
        }
        if (this.isSourceBillRelatedBill(ctx, srcObj, botObj.getDestObjectID())) {
            throw new BizCollException(BizCollException.CANNOT_DELPAYMENT_HASBOTP);
        }
        if (StateEnum.ISPAYBILL.equals((Object)srcObj.getState())) {
            logger.info((Object)(ResourceBase.getString((String)bizCollResource, (String)"AccountBillBeChecked", (Locale)local) + srcBillPK.toString()));
            ctx.put((Object)"isReWrite", (Object)new Boolean(true));
            srcObj.setState(StateEnum.CHECKED);
            if ("R".equals(srcObj.getActionFlag())) {
                this.reWriteBillState(ctx, srcBillPK.toString(), StateEnum.ISSUSPENSEACCOUNT);
            } else {
                this.reWriteBillState(ctx, srcBillPK.toString(), StateEnum.CHECKED);
            }
            ctx.put((Object)"isReWrite", null);
            logger.info((Object)ResourceBase.getString((String)bizCollResource, (String)"AccountBillHasBeChecked", (Locale)local));
        } else {
            logger.info((Object)ResourceBase.getString((String)bizCollResource, (String)"BillMustBePayed", (Locale)local));
        }
    }

    private void reWriteBillState(Context ctx, String id, StateEnum state) throws BOSException, EASBizException {
        IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
        facade.setState(BOSUuid.read((String)id), state);
    }

    @Override
    protected IObjectValue _getCustomerByPersonId(Context ctx, String personId) throws BOSException {
        StringBuffer getUserIdSql = new StringBuffer();
        getUserIdSql.append(" select FID from T_PM_User where FPersonId='");
        getUserIdSql.append(personId).append("'");
        IRowSet userIdRows = DbUtil.executeQuery((Context)ctx, (String)getUserIdSql.toString());
        if (userIdRows == null || userIdRows.size() == 0 || userIdRows.size() > 0) {
            return null;
        }
        String userId = "";
        try {
            if (userIdRows.next()) {
                userId = userIdRows.getString("FID");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        boolean ENABLE_VALUE = false;
        StringBuffer getRelationNumberCIdSql = new StringBuffer();
        getRelationNumberCIdSql.append(" select FRelationNumberCID from T_CHA_UserChannelRelation where FUserAccountID='");
        getRelationNumberCIdSql.append(userId).append("'");
        getRelationNumberCIdSql.append(" and FDataState=").append(0);
        IRowSet relationNumberCIdRows = DbUtil.executeQuery((Context)ctx, (String)getRelationNumberCIdSql.toString());
        if (relationNumberCIdRows == null || relationNumberCIdRows.size() < 1) {
            return null;
        }
        String channelId = "";
        try {
            if (relationNumberCIdRows.next()) {
                channelId = relationNumberCIdRows.getString("FRelationNumberCID");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        String TCS_APPROVED_VALUE = "0";
        StringBuffer getCustomerIdSql = new StringBuffer();
        getCustomerIdSql.append(" select FCustomerID from T_BD_ChannelBase where FID='");
        getCustomerIdSql.append(channelId).append("' and FTerminalChannelStatus='").append("0").append("'");
        IRowSet customerIdRows = DbUtil.executeQuery((Context)ctx, (String)getCustomerIdSql.toString());
        if (customerIdRows == null || customerIdRows.size() < 1) {
            return null;
        }
        String customerId = "";
        try {
            if (customerIdRows.next()) {
                customerId = customerIdRows.getString("FCustomerID");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        StringBuffer getCustomerInfoSql = new StringBuffer();
        getCustomerInfoSql.append(" select FID,FNumber,FName_L2,FUsedStatus from T_BD_Customer where FID='");
        getCustomerInfoSql.append(customerId).append("' and FUsedStatus=").append(1);
        IRowSet customerInfoRows = DbUtil.executeQuery((Context)ctx, (String)getCustomerInfoSql.toString());
        if (customerInfoRows == null || customerInfoRows.size() < 1) {
            return null;
        }
        String cid = "";
        String number = "";
        String name = "";
        CustomerInfo customerInfo = new CustomerInfo();
        try {
            if (customerIdRows.next()) {
                cid = customerInfoRows.getString("FCustomerID");
                number = customerInfoRows.getString("FNumber");
                name = customerInfoRows.getString("FName_L2");
            }
            BOSUuid buid = BOSUuid.create((String)cid);
            customerInfo.setId(buid);
            customerInfo.setNumber(number);
            customerInfo.setName(name);
            customerInfo.setUsedStatus(UsedStatusEnum.APPROVED);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return customerInfo;
    }

    @Override
    protected void checkBillValidate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.checkBillValidate(ctx, model);
        BizAccountOutBillInfo info = (BizAccountOutBillInfo)model;
        String sourceId = info.getSourceBillId();
        BizAccountOutBillEntryInfo entry = null;
        if (info.getApplierCompany() == null) {
            throw new ExpAccException(ExpAccException.A_COMPANY_NOTNULL);
        }
        if (info.getNumber() == null) {
            throw new ExpAccException(DailyLoanBillException.NUMBER_NOT_NULL);
        }
        if (info.getPrior() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_PRIOR_EXCEPTION);
        }
        if (info.getCurrencyType() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_CURRENCY_EXCEPTION);
        }
        if (info.getBizReqDate() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_REQDATE_EXCEPTION);
        }
        if (info.getApplier() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_APLLIER_EXCEPTION);
        }
        if (info.getOrgUnit() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_REQDEPT_EXCEPTION);
        }
        for (int i = info.getEntries().size() - 1; i > -1; --i) {
            entry = info.getEntries().get(i);
            if (entry.getHappenTime() == null) {
                throw new ExpAccException(ExpAccException.HAPPENDATA_NOT_NULL);
            }
            if (!StringUtils.isEmpty((String)entry.getComment()) && entry.getComment().length() > 200) {
                throw new ExpAccException(ExpAccException.MEMO_TOO_LONG);
            }
            if (entry.getCurrencyType() == null) {
                throw new ExpAccException(ExpAccException.CUR_NOT_NULL);
            }
            if (entry.getCostCenter() == null) {
                throw new ExpAccException(ExpAccException.ENTRY_COMPANY_NOT_NULL);
            }
            if (entry.getCompany() == null) {
                throw new ExpAccException(ExpAccException.ENTRY_COMPANY_NOT_NULL);
            }
            if (entry.getExpenseType() == null) {
                throw new ExpAccException(ExpAccException.EXPENSE_TYPE_NOT_NULL);
            }
            if (sourceId != null) {
                if (entry.getAmount() == null) {
                    throw new ExpAccException(ExpAccException.AMOUNTNOTLESSTHENZERO);
                }
            } else if (entry.getAmount() == null) {
                throw new ExpenseReqException(ExpenseReqException.NULL_ENTRYAMOUNT_EXCEPTION);
            }
            if (BizCollUtil.bigDecimalObjectLessThan(entry.getAmountApproved(), entry.getAmount())) continue;
            throw new BizCollException(BizCollException.CHECKAMOUNT_LESS_APPROVEDAMOUNT, new Object[]{i + 1, entry.getAmountApproved(), entry.getAmount()});
        }
    }

    @Override
    protected String getPermItemName() {
        return "cp_bc_BizAccountOutBill_Update";
    }
}

