/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AbstractBizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.AmountReverseRecordCollection;
import com.kingdee.eas.cp.bc.AmountReverseRecordFactory;
import com.kingdee.eas.cp.bc.AmountReverseRecordInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.BizCollVersion;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.IAmountReverseRecord;
import com.kingdee.eas.cp.bc.IDailyLoanBill;
import com.kingdee.eas.cp.bc.IDailyLoanBillEntry;
import com.kingdee.eas.cp.bc.IEvectionLoanBill;
import com.kingdee.eas.cp.bc.IEvectionLoanBillEntry;
import com.kingdee.eas.cp.bc.ILoanBill;
import com.kingdee.eas.cp.bc.LoanBillInfo;
import com.kingdee.eas.cp.bc.RePaymentBillEntryCollection;
import com.kingdee.eas.cp.bc.RePaymentBillEntryInfo;
import com.kingdee.eas.cp.bc.RePaymentBillInfo;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.reverse.payment.BillReverseHandler;
import com.kingdee.eas.cp.bc.util.ReverseUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBillEntryBase;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BizAppUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.BizAppUtil");

    public static Map getParams(Context ctx, List paramNumberList, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        HashMap paramMap = new HashMap();
        Iterator iterator = paramNumberList.iterator();
        IParamControl iParam = ParamControlFactory.getLocalInstance((Context)ctx);
        String companyId = null;
        if (companyInfo != null) {
            companyId = companyInfo.getId().toString();
        } else if (ContextUtil.getCurrentFIUnit((Context)ctx) != null) {
            companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        String[] paramNumbers = null;
        int size = paramNumberList.size();
        if (paramNumberList != null && size > 0) {
            paramNumbers = new String[size];
            for (int i = 0; i < size; ++i) {
                paramNumbers[i] = (String)paramNumberList.get(i);
            }
            paramMap = iParam.getParamHashMap(paramNumbers, companyId);
        }
        return paramMap;
    }

    public static void reverseSaveLoanBill(Context ctx, RePaymentBillInfo repayInfo, boolean isRequestAmount, boolean onlyCheckAmount) throws EASBizException, BOSException {
        if (repayInfo == null) {
            return;
        }
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP032");
        paramList.add("CP080");
        Map paramMap = BizAppUtil.getParams(ctx, paramList, repayInfo.getApplierCompany());
        boolean checkStandard = "0".equals(paramMap.get("CP032").toString());
        if (!(isRequestAmount || BizCollVersion.isRepayOld1Version(repayInfo.getVersion()) || StringUtils.isEmpty((String)repayInfo.getCheckStandard()))) {
            checkStandard = "0".equals(repayInfo.getCheckStandard());
        }
        BigDecimal payPrec = paramMap.get("CP080") == null ? new BigDecimal("0.00") : new BigDecimal(paramMap.get("CP080").toString());
        RePaymentBillEntryCollection repayCollectionCopy = (RePaymentBillEntryCollection)((Object)repayInfo.getEntries().clone());
        if (repayCollectionCopy.size() > 0) {
            StringBuilder logStrBu = new StringBuilder(500);
            logStrBu.append(" \u8fd8\u6b3e\u5355:" + repayInfo.getNumber() + ",\u501f\u6b3e\u5355:");
            BizCollUtil.sortCollection(new String[]{"sourceBillID", "sourceBillEntryID"}, repayCollectionCopy);
            IDailyLoanBill dailyLoanService = DailyLoanBillFactory.getLocalInstance(ctx);
            IEvectionLoanBill evectionLoanService = EvectionLoanBillFactory.getLocalInstance(ctx);
            IDailyLoanBillEntry dailyLoanEntryService = DailyLoanBillEntryFactory.getLocalInstance(ctx);
            IEvectionLoanBillEntry evectionLoanEntryService = EvectionLoanBillEntryFactory.getLocalInstance(ctx);
            IAmountReverseRecord reverseRecordService = AmountReverseRecordFactory.getLocalInstance(ctx);
            ICoreBillEntryBase iloanEntryService = null;
            AbstractBizCollBillBaseInfo billInfo = null;
            CoreBillEntryBaseInfo entryInfo = null;
            CoreBaseCollection updateDailyEntryCon = new CoreBaseCollection();
            CoreBaseCollection updateEvectionEntryCon = new CoreBaseCollection();
            CoreBaseCollection reverseRecordCon = new CoreBaseCollection();
            HashMap<String, Integer> dailyMap = new HashMap<String, Integer>();
            HashMap<String, Integer> evectionMap = new HashMap<String, Integer>();
            RePaymentBillEntryInfo rePaymentBillEntryInfo = null;
            CurrencyInfo repayCurrency = repayInfo.getCurrencyType();
            String sourceBillID = null;
            String sourceBillEntryID = null;
            BigDecimal rePayAmount = null;
            int version = repayInfo.getVersion();
            dailyMap.put("version", version);
            evectionMap.put("version", version);
            boolean isOldRepay = BizCollVersion.isRepayOld1Version(version);
            for (int i = 0; i < repayCollectionCopy.size(); ++i) {
                rePaymentBillEntryInfo = repayCollectionCopy.get(i);
                rePayAmount = rePaymentBillEntryInfo.getAmount();
                sourceBillID = rePaymentBillEntryInfo.getSourceBillId();
                if (StringUtils.isEmpty((String)sourceBillID)) {
                    throw new ExpAccException(ExpAccException.REPAYENTRYSOURCEBILLIDNOTNULL, new Object[]{i + 1});
                }
                sourceBillEntryID = rePaymentBillEntryInfo.getSourceBillEntryId();
                if (StringUtils.isEmpty((String)sourceBillEntryID)) {
                    throw new ExpAccException(ExpAccException.REPAYENTRYSOURCEDNOTNULL, new Object[]{i + 1});
                }
                String sqlLock = "update " + BizAppUtil.getTableName(ctx, sourceBillID) + " set fid = fid where fid =?; update " + BizAppUtil.getTableName(ctx, sourceBillEntryID) + " set fid = fid where fid =?; ";
                DbUtil.execute((Context)ctx, (String)sqlLock, (Object[])new String[]{sourceBillID, sourceBillEntryID});
                iloanEntryService = (ICoreBillEntryBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, BOSUuid.read((String)sourceBillEntryID));
                entryInfo = (CoreBillEntryBaseInfo)iloanEntryService.getValue((IObjectPK)new ObjectUuidPK(sourceBillEntryID), ReverseUtil.getReverseBillSelectSicRePay());
                billInfo = (BizCollBillBaseInfo)entryInfo.get("bill");
                String number = billInfo.getNumber();
                if (logStrBu.indexOf(number) == -1) {
                    logStrBu.append(number);
                }
                if (StateEnum.CLOSED.equals((Object)billInfo.getState())) {
                    throw new BizCollException(BizCollException.SOURCEBILLISCLOSED);
                }
                CurrencyInfo loanCurrency = billInfo.getCurrencyType();
                if (repayCurrency != null && loanCurrency != null && !repayCurrency.getId().equals((Object)loanCurrency.getId())) {
                    String repayCurrencyName = repayCurrency.getName() == null ? "" : repayCurrency.getName();
                    String loanCurrencyName = loanCurrency.getName() == null ? "" : loanCurrency.getName();
                    throw new ExpAccException(ExpAccException.REPAY_CURRENCY_NOT_SAME, new Object[]{repayCurrencyName, number, loanCurrencyName});
                }
                if (!isOldRepay && billInfo.getBoolean("isRePay")) {
                    throw new ExpAccException(ExpAccException.SOURCE_LOAN_WITH_REPAY, new Object[]{number});
                }
                if (!isOldRepay && onlyCheckAmount) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("payPrec", payPrec);
                map.put("checkStandard", checkStandard);
                map.put("isRequestAmount", isRequestAmount);
                map.put("reverseRecordService", reverseRecordService);
                if (BizCollUtil.isDailyLoanBill(sourceBillID)) {
                    BizAppUtil.buildReverseEntry(ctx, repayInfo, rePaymentBillEntryInfo, entryInfo, dailyMap, reverseRecordCon, map);
                    BizAppUtil.checkReturnAmount(dailyMap, rePaymentBillEntryInfo, (BizCollBillBaseInfo)billInfo, isRequestAmount);
                    if (!onlyCheckAmount) {
                        updateDailyEntryCon.add((CoreBaseInfo)entryInfo);
                    }
                } else if (BizCollUtil.isEvectionLoanBill(sourceBillID)) {
                    BizAppUtil.buildReverseEntry(ctx, repayInfo, rePaymentBillEntryInfo, entryInfo, evectionMap, reverseRecordCon, map);
                    BizAppUtil.checkReturnAmount(evectionMap, rePaymentBillEntryInfo, (BizCollBillBaseInfo)billInfo, isRequestAmount);
                    if (!onlyCheckAmount) {
                        updateEvectionEntryCon.add((CoreBaseInfo)entryInfo);
                    }
                }
                logStrBu.append(",rePayAmt=" + rePayAmount + "," + entryInfo.getBigDecimal("amountPaid") + "," + entryInfo.getBigDecimal("amountBalance") + " \n");
            }
            if (updateDailyEntryCon.size() > 0) {
                dailyLoanEntryService.updateBatchData(updateDailyEntryCon);
                BizAppUtil.updateSourceBill(dailyLoanService, dailyMap, isRequestAmount);
            }
            if (updateEvectionEntryCon.size() > 0) {
                evectionLoanEntryService.updateBatchData(updateEvectionEntryCon);
                BizAppUtil.updateSourceBill(evectionLoanService, evectionMap, isRequestAmount);
            }
            if (reverseRecordCon.size() > 0) {
                Result result = reverseRecordService.save(reverseRecordCon);
                int size = result.size();
                for (int i = 0; i < size; ++i) {
                    Exception exception = result.getLineResult(i).getException();
                    if (exception == null) continue;
                    throw new BOSException(exception.getMessage(), (Throwable)exception);
                }
            }
            if (billInfo != null) {
                String logStr = logStrBu.toString();
                if (logStr.length() > 1500) {
                    logStr = logStr.substring(0, 1500);
                }
                IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"returnLoanBillEntry", (BOSObjectType)billInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(billInfo.getId()), (String)logStr);
                LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void buildReverseEntry(Context ctx, RePaymentBillInfo rePaymentBillInfo, RePaymentBillEntryInfo rePaymentBillEntryInfo, CoreBillEntryBaseInfo entryInfo, Map billMap, CoreBaseCollection reverseRecordCon, Map paramMap) throws EASBizException, BOSException {
        BigDecimal amountBalanceNew;
        BigDecimal amountBalanceOriNew;
        boolean checkStandard = (Boolean)paramMap.get("checkStandard");
        boolean isRequestAmount = (Boolean)paramMap.get("isRequestAmount");
        IAmountReverseRecord reverseRecordService = (IAmountReverseRecord)paramMap.get("reverseRecordService");
        String sourceBillEntryId = entryInfo.getId().toString();
        String sourceBillNumber = ((BizCollBillBaseInfo)entryInfo.get("bill")).getNumber();
        BigDecimal amountBalanceOri = entryInfo.getBigDecimal("amountBalanceOri");
        amountBalanceOri = amountBalanceOri == null ? BizCollUtil.ZERO : amountBalanceOri;
        BigDecimal amountBalance = entryInfo.getBigDecimal("amountBalance");
        amountBalance = amountBalance == null ? BizCollUtil.ZERO : amountBalance;
        BigDecimal amountPaid = entryInfo.getBigDecimal("amountPaid");
        amountPaid = amountPaid == null ? BizCollUtil.ZERO : amountPaid;
        String rePayEntryId = rePaymentBillEntryInfo.getId().toString();
        String billNumber = rePaymentBillInfo.getNumber();
        BigDecimal rePayAmount = BizAppUtil.amountNotNull(rePaymentBillEntryInfo.getAmount());
        billNumber = StringUtils.isEmpty((String)billNumber) ? "" : billNumber;
        BigDecimal rePayAmountOri = BizAppUtil.amountNotNull(rePaymentBillEntryInfo.getAmountOri());
        if (checkStandard) {
            boolean isSameCurrency = rePaymentBillEntryInfo.getCurrency().getId().equals((Object)((CurrencyInfo)entryInfo.get("currencytype")).getId());
            if (isRequestAmount && isSameCurrency && amountBalance.compareTo(rePayAmount) == 0) {
                rePayAmountOri = amountBalanceOri;
            } else if (!isSameCurrency || rePaymentBillEntryInfo.getBigDecimal("exchangeRate").compareTo(entryInfo.getBigDecimal("exchangeRate")) != 0) {
                rePayAmountOri = entryInfo.getInt("convertMode") == 0 ? rePayAmount.divide(entryInfo.getBigDecimal("exchangeRate"), 2, 4).setScale(2, 4) : rePayAmount.multiply(entryInfo.getBigDecimal("exchangeRate")).setScale(2, 4);
            }
        } else if (isRequestAmount && amountBalanceOri.compareTo(rePayAmountOri) == 0) {
            rePayAmount = amountBalance;
        } else {
            BigDecimal exchangeRate = entryInfo.getBigDecimal("exchangeRate");
            rePayAmount = entryInfo.getInt("convertMode") == 0 ? rePayAmountOri.multiply(exchangeRate).setScale(2, 4) : rePayAmountOri.divide(exchangeRate, 2, 4);
        }
        int version = rePaymentBillInfo.getVersion();
        AmountReverseRecordInfo reverseRecord = new AmountReverseRecordInfo();
        boolean isOld1Version = BizCollVersion.isRepayOld1Version(version);
        if (!isOld1Version) {
            reverseRecord.setBillNumber(billNumber);
            reverseRecord.setBillId(rePaymentBillInfo.getId().toString());
            reverseRecord.setCheckEntryId(rePayEntryId);
            reverseRecord.setSourceBillId(((BizCollBillBaseInfo)entryInfo.get("bill")).getId().toString());
            reverseRecord.setSourceBillNumber(sourceBillNumber);
            reverseRecord.setSourceBillEntryId(sourceBillEntryId);
            reverseRecord.setIsRequest(isRequestAmount);
            reverseRecord.setIsLatest(true);
        }
        if (isRequestAmount) {
            if (!isOld1Version && reverseRecordService.exists("where isLatest = 1 and isRequest = 1 and checkEntryId = '" + rePayEntryId + "'")) {
                throw new ExpAccException(ExpAccException.LOAN_EXIST_REPAYENTRY, new Object[]{sourceBillNumber});
            }
            if (checkStandard && rePayAmount.compareTo(amountBalance) > 0) {
                logger.error((Object)("----cpbc--BizAppUtil--buildReverseEntry--rePayAmount=" + rePayAmount + ",amountBalance" + entryInfo.getBigDecimal("amountBalance")));
                throw new BizCollException(BizCollException.RETURNBIGGERTHANAMOUNTBALANCEWITHBILLNUM, new Object[]{billNumber, rePayAmount, amountBalance});
            }
            if (!checkStandard && rePayAmountOri.compareTo(amountBalanceOri) > 0) {
                throw new BizCollException(BizCollException.RETURNBIGGERTHANAMOUNTORIBALANCE, new Object[]{billNumber, rePayAmountOri, amountBalanceOri});
            }
            amountBalanceOriNew = amountBalanceOri.subtract(rePayAmountOri);
            entryInfo.setBigDecimal("amountBalanceOri", amountBalanceOriNew);
            amountBalanceNew = amountBalance.subtract(rePayAmount);
            entryInfo.setBigDecimal("amountBalance", amountBalanceNew);
            BigDecimal amountPaidNew = amountPaid.add(rePayAmount);
            entryInfo.setBigDecimal("amountPaid", amountPaidNew);
            if (!isOld1Version) {
                reverseRecord.setCheckAmountOri(rePayAmountOri);
                reverseRecord.setCheckAmount(rePayAmount);
                reverseRecord.setSourceEntryAmountBalance(amountBalanceNew);
                reverseRecord.setSourceEntryAmountBalanceOri(amountBalanceOriNew);
                reverseRecord.setSourceEntryAmountUsed(amountPaidNew);
                reverseRecord.setIsLatest(true);
                reverseRecordCon.add((CoreBaseInfo)reverseRecord);
            }
        } else {
            if (!isOld1Version) {
                AmountReverseRecordCollection reverseRecordCollection = reverseRecordService.getAmountReverseRecordCollection("where isLatest = 1 and isRequest = 1 and checkEntryId = '" + rePayEntryId + "'");
                int size = reverseRecordCollection.size();
                if (size <= 0) return;
                if (size != 1) throw new ExpAccException(ExpAccException.LOAN_REVERSED_MANY_TIMES, new Object[]{sourceBillNumber});
                AmountReverseRecordInfo reverseRecordInfoOld = reverseRecordCollection.get(0);
                BigDecimal recordReverseAmountOri = BizAppUtil.amountNotNull(reverseRecordInfoOld.getCheckAmountOri());
                BigDecimal recordReverseAmount = BizAppUtil.amountNotNull(reverseRecordInfoOld.getCheckAmount());
                if (checkStandard) {
                    if (rePayAmount.compareTo(recordReverseAmount) != 0) {
                        throw new ExpAccException(ExpAccException.REVERSE_REPAY_AMOUNT_NOT_EQUAL, new Object[]{sourceBillNumber});
                    }
                    rePayAmountOri = recordReverseAmountOri;
                } else {
                    if (rePayAmountOri.compareTo(recordReverseAmountOri) != 0) {
                        throw new ExpAccException(ExpAccException.REVERSE_REPAY_AMOUNT_NOT_EQUAL, new Object[]{sourceBillNumber});
                    }
                    rePayAmount = recordReverseAmount;
                }
                reverseRecordInfoOld.setIsLatest(false);
                reverseRecordCon.add((CoreBaseInfo)reverseRecordInfoOld);
                reverseRecord.setCheckAmountOri(rePayAmountOri);
                reverseRecord.setCheckAmount(rePayAmount);
                reverseRecordCon.add((CoreBaseInfo)reverseRecord);
                reverseRecordCollection = reverseRecordService.getAmountReverseRecordCollection("where isLatest = 1 and isRequest = 0 and checkEntryId = '" + rePayEntryId + "'");
                size = reverseRecordCollection.size();
                if (size > 0) {
                    reverseRecordInfoOld = reverseRecordCollection.get(0);
                    reverseRecordInfoOld.setIsLatest(false);
                    reverseRecordCon.add((CoreBaseInfo)reverseRecordInfoOld);
                }
            }
            amountBalanceOriNew = amountBalanceOri.add(rePayAmountOri);
            entryInfo.setBigDecimal("amountBalanceOri", amountBalanceOriNew);
            amountBalanceNew = amountBalance.add(rePayAmount);
            BigDecimal amountApproved = entryInfo.getBigDecimal("amountApproved");
            if (amountBalanceNew.compareTo(amountApproved) > 0) {
                throw new ExpAccException(ExpAccException.BALANCE_GREATER_APPROVED, new Object[]{sourceBillNumber, amountBalanceNew, amountApproved});
            }
            entryInfo.setBigDecimal("amountBalance", amountBalanceNew);
            BigDecimal amountPaidNew = amountPaid.subtract(rePayAmount);
            entryInfo.setBigDecimal("amountPaid", amountPaidNew);
            if (!isOld1Version) {
                reverseRecord.setSourceEntryAmountBalance(amountBalanceNew);
                reverseRecord.setSourceEntryAmountBalanceOri(amountBalanceOriNew);
                reverseRecord.setSourceEntryAmountUsed(amountPaidNew);
            }
        }
        Map<String, BigDecimal> valueMap = null;
        BigDecimal returnAmount = rePayAmount;
        if (billMap.containsKey(rePaymentBillEntryInfo.getSourceBillId())) {
            valueMap = (Map)billMap.get(rePaymentBillEntryInfo.getSourceBillId());
            BigDecimal tempAmount = (BigDecimal)valueMap.get("returnAmount");
            tempAmount = tempAmount.add(returnAmount);
            valueMap.put("returnAmount", tempAmount);
        } else {
            valueMap = new HashMap<String, IObjectValue>();
            valueMap.put("bill", (BigDecimal)entryInfo.getObjectValue("bill"));
            valueMap.put("returnAmount", returnAmount);
        }
        billMap.put(rePaymentBillEntryInfo.getSourceBillId(), valueMap);
    }

    @Deprecated
    public static void buildReverseEntry(RePaymentBillEntryInfo rePaymentBillEntryInfo, boolean checkStandard, CoreBillEntryBaseInfo entryInfo, boolean isRequestAmount, BigDecimal rePayAmount) throws BizCollException {
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)entryInfo.get("bill");
        String billNumber = "";
        if (billInfo != null) {
            String string = billNumber = billInfo.getNumber() == null ? "" : billInfo.getNumber();
        }
        if (checkStandard) {
            BigDecimal amountPaid;
            BigDecimal rePayAmountOri = rePaymentBillEntryInfo.getAmountOri();
            if (!rePaymentBillEntryInfo.getCurrency().getId().equals((Object)((CurrencyInfo)entryInfo.get("currencytype")).getId())) {
                rePayAmountOri = entryInfo.getInt("convertMode") == 0 ? rePayAmount.divide(entryInfo.getBigDecimal("exchangeRate"), 2, 4).setScale(2, 4) : rePayAmount.multiply(entryInfo.getBigDecimal("exchangeRate")).setScale(2, 4);
            }
            BigDecimal amountBalanceOri = entryInfo.getBigDecimal("amountBalanceOri") == null ? BizCollUtil.ZERO : entryInfo.getBigDecimal("amountBalanceOri");
            BigDecimal amountBalance = entryInfo.getBigDecimal("amountBalance") == null ? BizCollUtil.ZERO : entryInfo.getBigDecimal("amountBalance");
            BigDecimal bigDecimal = amountPaid = entryInfo.getBigDecimal("amountPaid") == null ? BizCollUtil.ZERO : entryInfo.getBigDecimal("amountPaid");
            if (isRequestAmount) {
                if (rePayAmount.compareTo(amountBalance) > 0) {
                    logger.error((Object)("----cpbc--BizAppUtil--buildReverseEntry--rePayAmount=" + rePayAmount + ",amountBalance" + entryInfo.getBigDecimal("amountBalance")));
                    throw new BizCollException(BizCollException.RETURNBIGGERTHANAMOUNTBALANCEWITHBILLNUM, new Object[]{billNumber, rePayAmount, amountBalance});
                }
                entryInfo.setBigDecimal("amountBalanceOri", amountBalanceOri.subtract(rePayAmountOri));
                entryInfo.setBigDecimal("amountBalance", amountBalance.subtract(rePayAmount));
                entryInfo.setBigDecimal("amountPaid", amountPaid.add(rePayAmount));
            } else {
                entryInfo.setBigDecimal("amountBalanceOri", amountBalanceOri.add(rePayAmountOri));
                entryInfo.setBigDecimal("amountBalance", amountBalance.add(rePayAmount));
                entryInfo.setBigDecimal("amountPaid", amountPaid.subtract(rePayAmount));
            }
        } else {
            BigDecimal amountPaid;
            BigDecimal rePayAmountOri = rePaymentBillEntryInfo.getAmountOri();
            BigDecimal exchangeRate = entryInfo.getBigDecimal("exchangeRate");
            rePayAmount = entryInfo.getInt("convertMode") == 0 ? rePayAmountOri.multiply(exchangeRate).setScale(2, 4) : rePayAmountOri.divide(exchangeRate, 2, 4);
            BigDecimal amountBalanceOri = entryInfo.getBigDecimal("amountBalanceOri") == null ? BizCollUtil.ZERO : entryInfo.getBigDecimal("amountBalanceOri");
            BigDecimal amountBalance = entryInfo.getBigDecimal("amountBalance") == null ? BizCollUtil.ZERO : entryInfo.getBigDecimal("amountBalance");
            BigDecimal bigDecimal = amountPaid = entryInfo.getBigDecimal("amountPaid") == null ? BizCollUtil.ZERO : entryInfo.getBigDecimal("amountPaid");
            if (isRequestAmount) {
                if (rePayAmountOri.compareTo(amountBalanceOri) > 0) {
                    throw new BizCollException(BizCollException.RETURNBIGGERTHANAMOUNTBALANCEWITHBILLNUM, new Object[]{billNumber, rePayAmountOri, amountBalanceOri});
                }
                entryInfo.setBigDecimal("amountBalanceOri", amountBalanceOri.subtract(rePayAmountOri));
                entryInfo.setBigDecimal("amountBalance", amountBalance.subtract(rePayAmount));
                entryInfo.setBigDecimal("amountPaid", amountPaid.add(rePayAmount));
            } else {
                entryInfo.setBigDecimal("amountBalanceOri", amountBalanceOri.add(rePayAmountOri));
                entryInfo.setBigDecimal("amountBalance", amountBalance.add(rePayAmount));
                entryInfo.setBigDecimal("amountPaid", amountPaid.subtract(rePayAmount));
            }
        }
    }

    public static void checkReturnAmount(Map dailyMap, RePaymentBillEntryInfo rePaymentBillEntryInfo, BizCollBillBaseInfo billInfo, boolean isRequestAmount) throws EASBizException, BOSException {
        Map valueMap = (Map)dailyMap.get(rePaymentBillEntryInfo.getSourceBillId());
        if (valueMap != null) {
            String billNumber;
            BigDecimal returnAmount = (BigDecimal)valueMap.get("returnAmount");
            BigDecimal amountBalance = billInfo.getAmountBalance() == null ? BizCollUtil.ZERO : billInfo.getAmountBalance();
            String string = billNumber = billInfo.getNumber() == null ? "" : billInfo.getNumber();
            if (isRequestAmount && returnAmount.compareTo(amountBalance) > 0) {
                logger.error((Object)("----cpbc--BizAppUtil--buildReverseEntry--rePayAmount=" + returnAmount + ",amountBalance" + amountBalance));
                throw new BizCollException(BizCollException.RETURNBIGGERTHANAMOUNTBALANCEWITHBILLNUM, new Object[]{billNumber, returnAmount, amountBalance});
            }
        }
    }

    public static String getTableName(Context ctx, String billId) {
        BOSObjectType type = BOSUuid.read((String)billId).getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo vo = loader.getEntity(type);
        return vo.getTable().getName();
    }

    private static void updateSourceBill(ILoanBill service, Map valueMap, boolean isRequestAmount) throws EASBizException, BOSException {
        Map tmpMap = null;
        Set keys = valueMap.keySet();
        LoanBillInfo billInfo = null;
        int version = (Integer)valueMap.get("version");
        valueMap.remove("version");
        boolean isRePay = false;
        for (Object key : keys) {
            tmpMap = (Map)valueMap.get(key);
            billInfo = (LoanBillInfo)tmpMap.get("bill");
            if (billInfo.getReturnAmount() == null) {
                billInfo.setReturnAmount(BizCollUtil.ZERO);
            }
            if (isRequestAmount) {
                billInfo.setAmountBalance(billInfo.getAmountBalance().subtract((BigDecimal)tmpMap.get("returnAmount")));
                billInfo.setReturnAmount(billInfo.getReturnAmount().add((BigDecimal)tmpMap.get("returnAmount")));
                isRePay = false;
            } else {
                billInfo.setAmountBalance(billInfo.getAmountBalance().add((BigDecimal)tmpMap.get("returnAmount")));
                billInfo.setReturnAmount(billInfo.getReturnAmount().subtract((BigDecimal)tmpMap.get("returnAmount")));
                isRePay = true;
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("returnAmount"));
            sic.add(new SelectorItemInfo("amountBalance"));
            if (BizCollVersion.isRepayOld1Version(version)) {
                billInfo.setIsRePay(isRePay);
                sic.add(new SelectorItemInfo("isRePay"));
            }
            service.updatePartial((CoreBaseInfo)billInfo, sic);
        }
        valueMap.put("version", version);
    }

    private static void buildReverseMap(Map billmap, RePaymentBillEntryInfo rePaymentBillEntryInfo, CoreBillEntryBaseInfo entryInfo, boolean checkStandard, boolean isRequestAmount, BigDecimal rePayAmount) throws BizCollException {
        Map<String, BigDecimal> valueMap = null;
        BigDecimal tempAmount = null;
        BigDecimal returnAmount = null;
        returnAmount = checkStandard ? rePayAmount : (entryInfo.getInt("convertMode") == 0 ? rePaymentBillEntryInfo.getAmountOri().multiply(entryInfo.getBigDecimal("exchangeRate")).setScale(2, 4) : rePaymentBillEntryInfo.getAmountOri().divide(entryInfo.getBigDecimal("exchangeRate"), 2, 4));
        if (billmap.containsKey(rePaymentBillEntryInfo.getSourceBillId())) {
            valueMap = (Map)billmap.get(rePaymentBillEntryInfo.getSourceBillId());
            tempAmount = (BigDecimal)valueMap.get("returnAmount");
            tempAmount = tempAmount.add(returnAmount);
            valueMap.put("returnAmount", tempAmount);
        } else {
            valueMap = new HashMap<String, IObjectValue>();
            valueMap.put("bill", (BigDecimal)entryInfo.getObjectValue("bill"));
            valueMap.put("returnAmount", returnAmount);
        }
        billmap.put(rePaymentBillEntryInfo.getSourceBillId(), valueMap);
    }

    public static void updateLoanBillFlag(Context ctx, RePaymentBillInfo rePaymentBillInfo, boolean isRePay) throws EASBizException, BOSException {
        RePaymentBillEntryCollection con = rePaymentBillInfo.getEntries();
        RePaymentBillEntryInfo info = null;
        if (con.size() > 0) {
            String billId = null;
            int size = con.size();
            for (int i = 0; i < size; ++i) {
                info = con.get(i);
                billId = info.getSourceBillId();
                LoanBillInfo billInfo = null;
                if (BizCollUtil.isDailyLoanBill(billId)) {
                    billInfo = new DailyLoanBillInfo();
                    billInfo.setId(BOSUuid.read((String)billId));
                } else if (BizCollUtil.isEvectionLoanBill(billId)) {
                    billInfo = new EvectionLoanBillInfo();
                    billInfo.setId(BOSUuid.read((String)billId));
                }
                BillReverseHandler.updateBillProperty(ctx, billInfo, "isRePay", isRePay);
            }
        }
    }

    public static void existsLoanBillUsedOtherRePayBill(Context ctx, RePaymentBillInfo rePaymentBillInfo, StateEnum billState) throws EASBizException, BOSException {
        RePaymentBillEntryCollection con = rePaymentBillInfo.getEntries();
        RePaymentBillEntryInfo info = null;
        StringBuilder loanBillIdSql = new StringBuilder();
        StringBuilder evectionLoanBillIdSql = new StringBuilder();
        ArrayList idSqlList = new ArrayList();
        HashSet<String> loanBillSet = new HashSet<String>();
        HashSet<String> evectionLoanBillSet = new HashSet<String>();
        if (con.size() > 0) {
            String billId = null;
            int size = con.size();
            for (int i = 0; i < size; ++i) {
                info = con.get(i);
                billId = info.getSourceBillId();
                if (StringUtils.isEmpty((String)billId)) continue;
                if (BizCollUtil.isDailyLoanBill(billId)) {
                    loanBillSet.add(billId);
                    loanBillIdSql.append("?,");
                    continue;
                }
                if (!BizCollUtil.isEvectionLoanBill(billId)) continue;
                evectionLoanBillSet.add(billId);
                evectionLoanBillIdSql.append("?,");
            }
        }
        if (loanBillSet.size() == 0 && evectionLoanBillSet.size() == 0) {
            return;
        }
        StringBuilder querySql = new StringBuilder();
        String billStateFilter = "";
        billStateFilter = StateEnum.CHECKFAILD.equals((Object)billState) ? " REPAY.FSTATE IN ( 20 ,25, 30) " : " REPAY.FSTATE = 40 ";
        if (loanBillSet.size() > 0) {
            loanBillIdSql.deleteCharAt(loanBillIdSql.toString().length() - 1);
            idSqlList.addAll(loanBillSet);
            querySql.append("SELECT  DLB.FID,DLB.FNUMBER AS DLBNUMBER  ,REPAY.FNUMBER AS REPAYNUMBER ");
            querySql.append("FROM T_BC_DAILYLOANBILL AS DLB ");
            querySql.append(" LEFT JOIN T_BC_REPAYMENTBILLENTRY AS RPENTRY ON DLB.FID = RPENTRY.FSOURCEBILLID ");
            querySql.append(" LEFT JOIN T_BC_REPAYMENTBILL AS REPAY ON REPAY.FID =RPENTRY.FPARENTID ");
            querySql.append("WHERE " + billStateFilter + "  AND DLB.FID IN( " + loanBillIdSql.toString() + ") ");
        }
        if (loanBillSet.size() > 0 && evectionLoanBillSet.size() > 0) {
            querySql.append(" union all ");
        }
        if (evectionLoanBillSet.size() > 0) {
            evectionLoanBillIdSql.deleteCharAt(evectionLoanBillIdSql.toString().length() - 1);
            idSqlList.addAll(evectionLoanBillSet);
            querySql.append("SELECT  DLB.FID,DLB.FNUMBER AS DLBNUMBER ,REPAY.FNUMBER AS REPAYNUMBER ");
            querySql.append("FROM T_BC_EVECTIONLOANBILL AS DLB ");
            querySql.append(" LEFT JOIN T_BC_REPAYMENTBILLENTRY AS RPENTRY ON DLB.FID = RPENTRY.FSOURCEBILLID ");
            querySql.append(" LEFT JOIN T_BC_REPAYMENTBILL AS REPAY ON REPAY.FID =RPENTRY.FPARENTID ");
            querySql.append("WHERE " + billStateFilter + "  AND DLB.FID IN( " + evectionLoanBillIdSql.toString() + ") ");
        }
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])idSqlList.toArray());
            if (rowSet.next()) {
                String loanBillNumber = rowSet.getString("DLBNUMBER");
                String repayBillNumber = rowSet.getString("REPAYNUMBER");
                logger.error((Object)("----cpbc--BizAppUtil--existsLoanRepayFlagUsedOtherBill--loanBillNumber:" + loanBillNumber + ",repayBillNumber:" + repayBillNumber));
                throw new BizCollException(BizCollException.EXISTSLOANBILL_USED_OTHERREPAYBILL, new Object[]{loanBillNumber, repayBillNumber});
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String getAccountUnVoucheredBillID(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, String tableName) throws BOSException, EASBizException {
        StringBuffer sqlID = new StringBuffer();
        Boolean isRelaFi = true;
        Boolean isRelaCn = false;
        Boolean onlyAlreadyPaymentCanCreateVoucher = false;
        Boolean cp024 = false;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP002");
        paramList.add("CP008");
        paramList.add("CP00801");
        paramList.add("CP024");
        Map paramMap = BizAppUtil.getParams(ctx, paramList, company);
        isRelaFi = (boolean)new Boolean(paramMap.get("CP002").toString());
        isRelaCn = (boolean)new Boolean(paramMap.get("CP008").toString());
        if (paramMap.get("CP00801") != null) {
            onlyAlreadyPaymentCanCreateVoucher = (boolean)new Boolean(paramMap.get("CP00801").toString());
        }
        if (paramMap.get("CP024") != null) {
            cp024 = (boolean)new Boolean(paramMap.get("CP024").toString());
        }
        String resultSql = null;
        String companyId = company.getId().toString();
        if (isRelaFi.booleanValue() && isRelaCn.booleanValue() && cp024.booleanValue()) {
            sqlID.append("SELECT BAB.FID FROM %s BAB ").append("WHERE BAB.FAPPLIERCOMPANYID = '%s' ").append("AND (BAB.FISVOUCHERED=0 OR BAB.FISVOUCHERED IS NULL) ").append("AND (BAB.FSTATE = 70");
            if (onlyAlreadyPaymentCanCreateVoucher.booleanValue()) {
                sqlID.append(" OR (BAB.FSTATE= 60").append(" AND BAB.FAMOUNTENCASHED=0)) ");
            } else {
                sqlID.append(" OR BAB.FSTATE= 60").append(" OR BAB.FSTATE= 65) ");
            }
            resultSql = String.format(sqlID.toString(), tableName, companyId);
        } else if (isRelaFi.booleanValue() && isRelaCn.booleanValue() && !cp024.booleanValue()) {
            sqlID.append("SELECT BAB.FID FROM %s BAB ").append("WHERE BAB.FAPPLIERCOMPANYID = '%s' ").append("AND BAB.FSTATE='%s' AND BAB.FAMOUNTENCASHED=0 ").append("AND BAB.FISRELEVANCELOAN=1 ").append("AND (BAB.FISVOUCHERED=0 OR BAB.FISVOUCHERED IS NULL) ");
            if ("T_BC_TRAVELACCOUNTBILL".equals(tableName)) {
                sqlID.append(" UNION ALL ").append("SELECT TRA.FID FROM T_BC_TRAVELACCOUNTBILL TRA ").append("INNER JOIN T_BC_TRAVELACCOUNTBILLENTRY ENY ON ENY.FBILLID = TRA.FID ").append(" WHERE TRA.FSTATE >=60 AND TRA.FISVOUCHERED =0 AND ENY.FMONTHLYBALANCE = 1");
            }
            resultSql = String.format(sqlID.toString(), tableName, companyId, 60);
        } else if (isRelaFi.booleanValue() && !isRelaCn.booleanValue()) {
            sqlID.append("SELECT BAB.FID FROM %s BAB ").append("WHERE BAB.FAPPLIERCOMPANYID = '%s' ").append("AND BAB.FSTATE='%s' AND (BAB.FISVOUCHERED = 0 OR BAB.FISVOUCHERED IS NULL) ");
            resultSql = String.format(sqlID.toString(), tableName, companyId, 60);
        }
        return resultSql;
    }

    public static String getLoanUnVoucheredBillID(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, String tableName) throws BOSException, EASBizException {
        StringBuffer sqlID = new StringBuffer();
        Boolean isRelaFi = true;
        Boolean isRelaCn = false;
        Boolean onlyAlreadyPaymentCanCreateVoucher = false;
        Boolean billCanCreateVoucher = false;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP002");
        paramList.add("CP008");
        paramList.add("CP00801");
        paramList.add("CP024");
        Map paramMap = BizAppUtil.getParams(ctx, paramList, company);
        isRelaFi = (boolean)new Boolean(paramMap.get("CP002").toString());
        isRelaCn = (boolean)new Boolean(paramMap.get("CP008").toString());
        if (paramMap.get("CP00801") != null) {
            onlyAlreadyPaymentCanCreateVoucher = (boolean)new Boolean(paramMap.get("CP00801").toString());
        }
        billCanCreateVoucher = (boolean)new Boolean(paramMap.get("CP024").toString());
        String resultSql = null;
        if (isRelaFi.booleanValue() && !isRelaCn.booleanValue()) {
            sqlID.append("SELECT DLB.FID FROM %s DLB ").append("WHERE DLB.FAPPLIERCOMPANYID='%s' AND DLB.FSTATE= '%s' ").append("AND (DLB.FISVOUCHERED=0 OR DLB.FISVOUCHERED IS NULL) ");
            resultSql = String.format(sqlID.toString(), tableName, company.getId().toString(), 60);
        } else if (isRelaFi.booleanValue() && isRelaCn.booleanValue() && billCanCreateVoucher.booleanValue()) {
            sqlID.append("SELECT DLB.FID FROM %s DLB ").append("WHERE DLB.FAPPLIERCOMPANYID='%s' ").append("AND (DLB.FISVOUCHERED=0 OR DLB.FISVOUCHERED IS NULL) ");
            if ("T_BC_DAILYLOANBILL".equals(tableName)) {
                sqlID.append("AND DLB.FISCREATEPREPAYMENTBILL=0 ");
            }
            sqlID.append(" AND (DLB.FSTATE= 70");
            if (!onlyAlreadyPaymentCanCreateVoucher.booleanValue()) {
                sqlID.append(" OR DLB.FSTATE= 60").append(" OR DLB.FSTATE= 65");
            }
            sqlID.append(")");
            resultSql = String.format(sqlID.toString(), tableName, company.getId().toString());
        } else if (isRelaFi.booleanValue() && isRelaCn.booleanValue() && !billCanCreateVoucher.booleanValue()) {
            sqlID.append("SELECT DLB.FID FROM %s DLB ").append("WHERE DLB.FID = 'nodata' ");
            resultSql = String.format(sqlID.toString(), tableName);
        }
        return resultSql;
    }

    public static String getRePaymentUnVoucheredBillID(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, String tableName) throws EASBizException, BOSException {
        StringBuffer sqlID = new StringBuffer();
        Boolean isRelaFi = true;
        Boolean isRelaCn = false;
        Boolean isUseRePayment = false;
        Boolean billCanCreateVoucher = false;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP002");
        paramList.add("CP008");
        paramList.add("CP034");
        paramList.add("CP024");
        Map paramMap = BizAppUtil.getParams(ctx, paramList, company);
        isRelaFi = (boolean)new Boolean(paramMap.get("CP002").toString());
        isRelaCn = (boolean)new Boolean(paramMap.get("CP008").toString());
        if (paramMap.get("CP034") != null) {
            isUseRePayment = (boolean)new Boolean(paramMap.get("CP034").toString());
        }
        billCanCreateVoucher = (boolean)new Boolean(paramMap.get("CP024").toString());
        String resultSql = null;
        if (isRelaFi.booleanValue() && !isRelaCn.booleanValue() && isUseRePayment.booleanValue()) {
            sqlID.append("SELECT DLB.FID FROM %s DLB ").append("WHERE DLB.FAPPLIERCOMPANYID='%s' AND DLB.FSTATE= '%s' ").append("AND (DLB.FFivouchered=0 OR DLB.FFivouchered IS NULL) ");
            resultSql = String.format(sqlID.toString(), tableName, company.getId().toString(), 60);
        } else if (isRelaFi.booleanValue() && isRelaCn.booleanValue() && billCanCreateVoucher.booleanValue() && isUseRePayment.booleanValue()) {
            sqlID.append("SELECT DLB.FID FROM %s DLB ").append("WHERE DLB.FAPPLIERCOMPANYID='%s' AND ( DLB.FSTATE in ('%s','%s') ) ").append("AND (DLB.FFivouchered=0 OR DLB.FFivouchered IS NULL) ");
            resultSql = String.format(sqlID.toString(), tableName, company.getId().toString(), 60, 140);
        }
        if (resultSql == null) {
            resultSql = "SELECT DLB.FID FROM " + tableName + " DLB WHERE DLB.FID = 'nodata'";
        }
        return resultSql;
    }

    public static String getAccountSouceBillFilter(Context ctx, OrgUnitInfo org, PeriodInfo period, String tableName) throws BOSException, EASBizException {
        StringBuffer sqlID = new StringBuffer();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)org;
        Boolean isRelaCn = false;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP008");
        Map paramMap = BizAppUtil.getParams(ctx, paramList, company);
        isRelaCn = (boolean)new Boolean(paramMap.get("CP008").toString());
        String resultSql = null;
        String companyId = company.getId().toString();
        if (isRelaCn.booleanValue()) {
            sqlID.append("SELECT BAB.FID FROM %s BAB ").append("WHERE BAB.FAPPLIERCOMPANYID = '%s' ").append("AND BAB.FAMOUNTENCASHED > 0 ").append("AND BAB.FSTATE IN ('%s') ");
            resultSql = String.format(sqlID.toString(), tableName, companyId, 60);
        } else {
            sqlID.append("SELECT BAB.FID FROM %s BAB ").append("WHERE BAB.FAPPLIERCOMPANYID = '%s' ").append("AND BAB.FSTATE IN ('%s') ").append("AND (BAB.fid IS NULL) ");
            resultSql = String.format(sqlID.toString(), tableName, companyId, 60);
        }
        return resultSql;
    }

    public static String getLoanSouceBillFilter(Context ctx, OrgUnitInfo org, PeriodInfo period, String tableName) throws BOSException, EASBizException {
        StringBuffer sqlID = new StringBuffer();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)org;
        Boolean isRelaCn = false;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP008");
        Map paramMap = BizAppUtil.getParams(ctx, paramList, company);
        isRelaCn = (boolean)new Boolean(paramMap.get("CP008").toString());
        String resultSql = null;
        String companyId = company.getId().toString();
        if (isRelaCn.booleanValue()) {
            sqlID.append("SELECT BAB.FID FROM %s BAB ").append("WHERE BAB.FAPPLIERCOMPANYID = '%s' ").append("AND BAB.FSTATE IN ('%s') ");
            resultSql = String.format(sqlID.toString(), tableName, companyId, 60);
        } else {
            sqlID.append("SELECT BAB.FID FROM %s BAB ").append("WHERE BAB.FAPPLIERCOMPANYID = '%s' ").append("AND BAB.FSTATE IN ('%s') ").append("AND (BAB.fid IS NULL) ");
            resultSql = String.format(sqlID.toString(), tableName, companyId, 60);
        }
        return resultSql;
    }

    public static String getAccountOrLoanSuspenseFilter(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, String tableName) throws BOSException, EASBizException {
        StringBuffer sqlID = new StringBuffer();
        Boolean isRelaFi = true;
        Boolean isRelaCn = false;
        Boolean cp00802 = false;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP002");
        paramList.add("CP008");
        paramList.add("CP00802");
        Map paramMap = BizAppUtil.getParams(ctx, paramList, company);
        isRelaFi = (boolean)new Boolean(paramMap.get("CP002").toString());
        isRelaCn = (boolean)new Boolean(paramMap.get("CP008").toString());
        if (paramMap.get("CP00802") != null) {
            cp00802 = (boolean)new Boolean(paramMap.get("CP00802").toString());
        }
        String resultSql = null;
        String companyId = company.getId().toString();
        if (isRelaFi.booleanValue() && isRelaCn.booleanValue() && cp00802.booleanValue()) {
            sqlID.append("SELECT BAB.FID FROM %s BAB ").append("WHERE BAB.FAPPLIERCOMPANYID = '%s' ").append("AND (BAB.FSTATE='%s' ").append("OR BAB.FSTATE='%s' ").append("OR BAB.FSTATE='%s' ) ").append("AND (BAB.FISVOUCHERED=0 OR BAB.FISVOUCHERED IS NULL) ").append("AND (BAB.FisDapVouchered=0 OR BAB.FisDapVouchered IS NULL) ");
            resultSql = String.format(sqlID.toString(), tableName, companyId, 60, 65, 70);
        } else if (isRelaFi.booleanValue()) {
            sqlID.append("SELECT BAB.FID FROM %s BAB ").append("WHERE BAB.FAPPLIERCOMPANYID = '%s' ").append("AND (BAB.FSTATE='%s' ").append("OR BAB.FSTATE='%s' ) ").append("AND (BAB.FISVOUCHERED=0 OR BAB.FISVOUCHERED IS NULL) ").append("AND (BAB.FisDapVouchered=0 OR BAB.FisDapVouchered IS NULL) ");
            resultSql = String.format(sqlID.toString(), tableName, companyId, 60, 65);
        }
        return resultSql;
    }

    public static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        return sic;
    }

    public static BigDecimal amountNotNull(BigDecimal value) {
        return value == null ? BizCollUtil.ZERO : value;
    }
}

