/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AccountLimitFilterFacadeFactory;
import com.kingdee.eas.cp.bc.AccountLimitInfo;
import com.kingdee.eas.cp.bc.AccountStandardFactory;
import com.kingdee.eas.cp.bc.AccountStandardInfo;
import com.kingdee.eas.cp.bc.CreditControlSTDInfo;
import com.kingdee.eas.cp.bc.EnableStateEnum;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingInfo;
import com.kingdee.eas.cp.bc.FileBrowseUtil;
import com.kingdee.eas.cp.bc.IOperationTypeCostCenterEntry;
import com.kingdee.eas.cp.bc.InvoiceTypeEntryInfo;
import com.kingdee.eas.cp.bc.OperationTypeCollection;
import com.kingdee.eas.cp.bc.OperationTypeCostCenterEntryCollection;
import com.kingdee.eas.cp.bc.OperationTypeCostCenterEntryFactory;
import com.kingdee.eas.cp.bc.OperationTypeCostCenterEntryInfo;
import com.kingdee.eas.cp.bc.OperationTypeFactory;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.cp.bc.ReimburseLevelFactory;
import com.kingdee.eas.cp.bc.ReimburseLevelInfo;
import com.kingdee.eas.cp.bc.ReimburseLevelSettingInfo;
import com.kingdee.eas.cp.bc.app.AbstractBizBaseDataWebFacadeControllerBean;
import com.kingdee.eas.cp.bc.app.CommonDataWebUtils;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class BizBaseDataWebFacadeControllerBean
extends AbstractBizBaseDataWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.BizBaseDataWebFacadeControllerBean");
    private static final String RESBIZCOLL = "com.kingdee.eas.cp.bc.BizCollResource";

    @Override
    protected IObjectValue _buildModel(Context ctx, IObjectValue object) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        Map initData = new HashMap<String, Object>();
        DataBaseInfo dataBaseInfo = (DataBaseInfo)object;
        if (dataBaseInfo instanceof ExpenseTypeSubjectMappingInfo) {
            ((ExpenseTypeSubjectMappingInfo)dataBaseInfo).setCompany(company);
            String accountTypeFilter = this.getAccountTypeFilter(company);
            initData.put("accountTypeFilter", accountTypeFilter);
        } else if (dataBaseInfo instanceof ExpenseTypeInfo) {
            ArrayList<Object> fileList = new ArrayList();
            fileList = FileBrowseUtil.getFiles(FileBrowseUtil.getFilePath());
            Map paramsMap = (Map)dataBaseInfo.get("params");
            if (paramsMap != null && paramsMap.get("operationTypeId") != null) {
                String operationTypeId = paramsMap.get("operationTypeId").toString();
                OperationTypeInfo operation = OperationTypeFactory.getLocalInstance(ctx).getOperationTypeInfo("select id, number, name where id = '" + operationTypeId + "'");
                ((ExpenseTypeInfo)dataBaseInfo).setOperationType(operation);
            }
            FilterInfo fi = new FilterInfo();
            FilterItemCollection fic = fi.getFilterItems();
            fic.add(new FilterItemInfo("isEnable", (Object)Boolean.TRUE));
            fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
            String ln = company.getLongNumber();
            String[] lnSecs = ln.split("!");
            int size = lnSecs.length;
            HashSet<String> lnUps = new HashSet<String>();
            for (int i = 0; i < size; ++i) {
                lnUps.add(lnSecs[i]);
            }
            if (lnUps.size() != 0) {
                fic.add(new FilterItemInfo("company.number", lnUps, CompareType.INCLUDE));
                fi.setMaskString("(#1 or #2) and #0");
            }
            ArrayList<String> param = new ArrayList<String>();
            param.add("CP027");
            Map params = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(param, company.getId().toString());
            initData.putAll(params);
            initData.put("operationTypeFilter", fi.toString());
            initData.put("fileList", fileList);
        } else if (dataBaseInfo instanceof CreditControlSTDInfo) {
            List<String> adminIds = CommonDataWebUtils.getChildAdminIds(ctx);
            initData.put("adminIds", adminIds);
            CompanyOrgUnitInfo companOrgInfo = new CompanyOrgUnitInfo();
            companOrgInfo.setId(company.getId());
            ((CreditControlSTDInfo)dataBaseInfo).setCompany(companOrgInfo);
        } else if (dataBaseInfo instanceof AccountStandardInfo) {
            Map paramsMap = (Map)dataBaseInfo.get("params");
            String companyId = null;
            String[] sql = null;
            if (paramsMap.get("companyId") != null) {
                companyId = paramsMap.get("companyId").toString();
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                sql = CommonDataWebUtils.getParentCuIds(ctx, companyInfo.getCU().getId().toString());
            }
            if (paramsMap.get("expenseTypeId") != null) {
                ExpenseTypeInfo expenseType = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeInfo("select id, number, name where id = '" + paramsMap.get("expenseTypeId").toString() + "'");
                ((AccountStandardInfo)dataBaseInfo).setExpenseType(expenseType);
            }
            if (paramsMap.get("reimburseLevelId") != null) {
                ReimburseLevelInfo reimburseLevel = ReimburseLevelFactory.getLocalInstance(ctx).getReimburseLevelInfo("select id, number, name where id = '" + paramsMap.get("reimburseLevelId").toString() + "'");
                ((AccountStandardInfo)dataBaseInfo).setReimburseLV(reimburseLevel);
            }
            CompanyOrgUnitInfo companOrgInfo = new CompanyOrgUnitInfo();
            if (companyId != null) {
                companOrgInfo.setId(BOSUuid.read((String)companyId));
            } else {
                companOrgInfo = company;
            }
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id, baseCurrency.id, baseCurrency.number, baseCurrency.name where id = '" + companOrgInfo.getId().toString() + "'");
            ((AccountStandardInfo)dataBaseInfo).setCompany(companyInfo);
            ((AccountStandardInfo)dataBaseInfo).setEffectiveDate(new Date());
            ((AccountStandardInfo)dataBaseInfo).setState(EnableStateEnum.ENABLE);
            ((AccountStandardInfo)dataBaseInfo).setEffectiveDate(new Date());
            ((AccountStandardInfo)dataBaseInfo).setCurrencyType(companyInfo.getBaseCurrency());
            initData = AccountStandardFactory.getLocalInstance(ctx).getFilterInfoData();
            ArrayList<String> param = new ArrayList<String>();
            param.add("CP026");
            Map params = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(param, companyInfo.getId().toString());
            initData.put("cuIdsFilter", sql);
            initData.putAll(params);
            initData.put("companyId", companyInfo.getId().toString());
        } else if (dataBaseInfo instanceof ReimburseLevelSettingInfo) {
            Map paramsMap = (Map)dataBaseInfo.get("params");
            String companyId = null;
            String[] sql = null;
            if (paramsMap.get("companyId") != null) {
                companyId = paramsMap.get("companyId").toString();
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                ((ReimburseLevelSettingInfo)dataBaseInfo).setCompanyOrgUnit(companyInfo);
                sql = CommonDataWebUtils.getParentCuIds(ctx, companyInfo.getCU().getId().toString());
            }
            initData.put("cuIdsFilter", sql);
            if (paramsMap != null && paramsMap.get("reimburseLevelId") != null) {
                ReimburseLevelInfo reimburseLevel = ReimburseLevelFactory.getLocalInstance(ctx).getReimburseLevelInfo("select id, number, name where id = '" + paramsMap.get("reimburseLevelId").toString() + "'");
                ((ReimburseLevelSettingInfo)dataBaseInfo).setReimburseLevel(reimburseLevel);
            }
            if (paramsMap != null && paramsMap.get("companyId") != null) {
                initData.put("companyId", paramsMap.get("companyId").toString());
            } else {
                initData.put("companyId", ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
            }
            Set idSet = CommonDataWebUtils.getApplierAdminOrgUnitIds(ctx);
            initData.put("adminOrgUnitIds", idSet);
        } else if (dataBaseInfo instanceof AccountLimitInfo) {
            Map paramsMap = (Map)dataBaseInfo.get("params");
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id, baseCurrency.id, baseCurrency.number, baseCurrency.name where id = '" + company.getId().toString() + "'");
            Calendar now = Calendar.getInstance();
            int year = now.get(1);
            initData.put("currency", companyInfo.getBaseCurrency());
            initData.put("companyId", ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
            initData.put("company", company);
            initData.put("year", year);
            Set idSet = CommonDataWebUtils.getApplierAdminOrgUnitIds(ctx);
            initData.put("adminOrgUnitIds", idSet);
            CompanyOrgUnitInfo companyInfoEx = AccountLimitFilterFacadeFactory.getLocalInstance(ctx).getFilterWithCompany(companyInfo);
            if (companyInfoEx != null && companyInfoEx.size() > 0) {
                initData.put("companyIdForWk", companyInfoEx.getId().toString());
            }
            ArrayList<CompanyOrgUnitInfo> companyInfos = new ArrayList<CompanyOrgUnitInfo>();
            companyInfos.add(companyInfo);
            List companyInfoListEx = AccountLimitFilterFacadeFactory.getLocalInstance(ctx).getFilterWithCompanys(companyInfos);
            HashSet adminOrgUnitIdsForWk = new HashSet();
            if (companyInfoListEx != null && companyInfoListEx.size() > 0) {
                for (int i = 0; i < companyInfoListEx.size(); ++i) {
                    CompanyOrgUnitInfo companyInfoFromCityCompanyEx = (CompanyOrgUnitInfo)companyInfoListEx.get(i);
                    Set adminOrgUnitIdsFromEx = CommonDataWebUtils.getApplierAdminOrgUnitIds(ctx, companyInfoFromCityCompanyEx);
                    if (adminOrgUnitIdsFromEx == null || adminOrgUnitIdsFromEx.size() <= 0) continue;
                    for (Object adminOrgUnitId : adminOrgUnitIdsFromEx) {
                        adminOrgUnitIdsForWk.add(adminOrgUnitId);
                    }
                }
                initData.put("adminOrgUnitIdsForWk", adminOrgUnitIdsForWk);
            }
        } else if (dataBaseInfo instanceof InvoiceTypeEntryInfo) {
            initData.put("companyId", ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        }
        dataBaseInfo.put("initData", initData);
        return dataBaseInfo;
    }

    protected String getAccountTypeFilter(CompanyOrgUnitInfo company) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        if (company.getAccountTable() != null) {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
            filter.setMaskString("#0 and #1");
        } else {
            filter.setMaskString("#0 ");
        }
        return filter.toString();
    }

    @Override
    protected String _getAccountFilter(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        String filterStr = this.getAccountTypeFilter(company);
        return filterStr;
    }

    @Override
    protected IObjectValue _getCurrencyInfo(Context ctx) throws BOSException, EASBizException {
        CurrencyInfo currencyInfo = null;
        ICurrency ic = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo baseCurrency = ContextUtil.getCurrentFIUnit((Context)ctx).getBaseCurrency();
        if (baseCurrency != null) {
            currencyInfo = (CurrencyInfo)ic.getValue((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
        }
        return currencyInfo;
    }

    @Override
    protected Set _getOperationIdsByCompany(Context ctx, String companyId, String billType, String costCenterId) throws BOSException, EASBizException {
        HashSet<String> operationIds = new HashSet<String>();
        if (StringUtils.isBlank((String)companyId) || companyId.equals("null")) {
            return operationIds;
        }
        List<Map<String, Object>> treeNodes = this._getOperationTreeNodes(ctx, companyId, costCenterId, billType, null);
        for (Map<String, Object> treeNode : treeNodes) {
            if (treeNode.get("id") == null || "root".equals(treeNode.get("id").toString())) continue;
            operationIds.add(treeNode.get("id").toString());
        }
        return operationIds;
    }

    @Override
    protected List<Map<String, Object>> _getOperationTreeNodes(Context ctx, String companyId, String costCenterId, String billType, Map paramMap) throws BOSException, EASBizException {
        Long startTime = System.currentTimeMillis();
        ArrayList<Map<String, Object>> treeNodes = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> rootNode = new HashMap<String, Object>();
        rootNode.put("id", "root");
        String rootNodeName = ResourceBase.getString((String)"com.kingdee.eas.cp.bc.WebCommonUtilResource", (String)"BUSINESSTYPE", (Locale)ctx.getOriginLocale());
        rootNode.put("name", rootNodeName);
        rootNode.put("open", true);
        treeNodes.add(rootNode);
        if (StringUtils.isEmpty((String)companyId)) {
            return treeNodes;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("ID"));
        sic.add(new SelectorItemInfo("LONGNUMBER"));
        sic.add(new SelectorItemInfo("ISBIZUNIT"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sic);
        String[] longNumbers = company.getLongNumber().split("!");
        List<String> companyNumberList = Arrays.asList(longNumbers);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.OperationTypeInitTreeQuery");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sort = new SorterItemInfo();
        sort = new SorterItemInfo("operationType.number");
        sort.setSortType(SortType.ASCEND);
        sortColl.add(sort);
        entityViewInfo.setSorter(sortColl);
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("operationType.id"));
        sic.add(new SelectorItemInfo("operationType.name"));
        sic.add(new SelectorItemInfo("operationType.number"));
        sic.add(new SelectorItemInfo("company.id"));
        entityViewInfo.setSelector(sic);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(entityViewInfo);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection fic = filterInfo.getFilterItems();
        fic.add(new FilterItemInfo("operationType.isEnable", (Object)Boolean.TRUE));
        if (!StringUtils.isEmpty((String)billType)) {
            fic.add(new FilterItemInfo("billType.number", (Object)billType));
        }
        fic.add(new FilterItemInfo("operationType.company.number", new HashSet<String>(companyNumberList), CompareType.INCLUDE));
        FilterInfo operationFilter = this.getOperationFilter(ctx, company, costCenterId, billType, paramMap);
        filterInfo.mergeFilter(operationFilter, "and");
        entityViewInfo.setFilter(filterInfo);
        Set operIdsInCompany = null;
        if (company.isIsBizUnit()) {
            operIdsInCompany = this._getOperationIdsByCompany(ctx, company);
        }
        Set<Object> operIdsNotInCost = new HashSet();
        if (!StringUtils.isEmpty((String)costCenterId)) {
            operIdsNotInCost = this.getOperationIdsNotInCostCenter(ctx, companyId, costCenterId);
        }
        Long endTime = System.currentTimeMillis();
        logger.error((Object)("##cp.bc getOperationTreeNodes time\uff1a" + (endTime - startTime) + "ms, filterInfo=" + filterInfo + "\n operIdsNotInCost=" + operIdsNotInCost));
        IRowSet rowSet = exec.executeQuery();
        try {
            while (rowSet.next()) {
                String operationTypeId = rowSet.getObject("operationType.id").toString();
                if (operIdsInCompany != null && !operIdsInCompany.contains(operationTypeId) || operIdsNotInCost != null && operIdsNotInCost.contains(operationTypeId)) continue;
                HashMap<String, Object> treeNode = new HashMap<String, Object>();
                treeNode.put("id", operationTypeId);
                if (rowSet.getObject("operationType.name") == null) {
                    treeNode.put("name", "");
                } else {
                    treeNode.put("name", rowSet.getObject("operationType.name").toString());
                }
                treeNode.put("pId", "root");
                HashMap<String, String> dataMap = new HashMap<String, String>();
                dataMap.put("id", rowSet.getObject("operationType.id").toString());
                dataMap.put("number", rowSet.getObject("operationType.number").toString());
                if (rowSet.getObject("operationType.name") == null) {
                    dataMap.put("name", "");
                } else {
                    dataMap.put("name", rowSet.getObject("operationType.name").toString());
                }
                dataMap.put("companyId", rowSet.getString("company.id"));
                treeNode.put("data", dataMap);
                treeNodes.add(treeNode);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return treeNodes;
    }

    protected FilterInfo getOperationFilter(Context ctx, CompanyOrgUnitInfo company, String costCenterId, String billType, Map paramMap) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Set _getOperationIdsByCompany(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        Long startTime = System.currentTimeMillis();
        HashSet<String> operationIdsSet = new HashSet<String>();
        if (company == null || company.getId() == null) {
            return operationIdsSet;
        }
        String companyId = company.getId().toString();
        if (StringUtils.isBlank((String)company.getLongNumber())) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("longNumber"));
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), sic);
        }
        String[] longNumbers = company.getLongNumber().split("!");
        List<String> numberList = Arrays.asList(longNumbers);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", new HashSet<String>(numberList), CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        if (companyColl == null || companyColl.size() == 0) {
            return operationIdsSet;
        }
        ArrayList<String> companyIds = new ArrayList<String>();
        for (int i = 0; i < companyColl.size(); ++i) {
            if (companyColl.get(i).getId() == null) continue;
            companyIds.add(companyColl.get(i).getId().toString());
        }
        StringBuilder queryOql = new StringBuilder();
        queryOql.append(" SELECT DISTINCT oper.FID AS FID FROM T_BC_OPERATIONTYPE oper \n");
        queryOql.append(" LEFT JOIN T_BC_OPERATIONTYPECOMPANYENTRY operce on operce.FOPERATIONTYPEID = oper.FID \n");
        queryOql.append(" WHERE oper.FCOMPANYID in (");
        int size = companyIds.size();
        for (int j = 0; j < size; ++j) {
            queryOql.append("?,");
        }
        queryOql.deleteCharAt(queryOql.toString().length() - 1);
        queryOql.append(")");
        queryOql.append(" AND operce.FOPERATIONTYPEID IS NULL \n");
        queryOql.append(" UNION ALL \n");
        queryOql.append(" SELECT FOPERATIONTYPEID AS FID FROM T_BC_OPERATIONTYPECOMPANYENTRY ");
        queryOql.append(" WHERE FCOMPANYORGUNITID = ? \n");
        ArrayList<String> params = new ArrayList<String>();
        params.addAll(companyIds);
        params.add(companyId);
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)queryOql.toString(), (Object[])params.toArray());
        Long endTime = System.currentTimeMillis();
        logger.error((Object)("##cp.bc getOperationIdsByCompany time\uff1a" + (endTime - startTime) + "ms, params=" + params));
        try {
            while (result.next()) {
                operationIdsSet.add(result.getString("FID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return operationIdsSet;
    }

    protected Set<String> getOperationIdsNotInCostCenter(Context ctx, String companyId, String costCenterId) throws BOSException, EASBizException {
        HashSet<String> notInSet = new HashSet<String>();
        if (!StringUtils.isEmpty((String)costCenterId)) {
            OperationTypeCostCenterEntryInfo operationTypeCCEInfo;
            int j;
            IOperationTypeCostCenterEntry iOperationTypeCCE = OperationTypeCostCenterEntryFactory.getLocalInstance(ctx);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("OPERATIONTYPEID"));
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("COMPANY.ID", (Object)companyId));
            filter.getFilterItems().add(new FilterItemInfo("COSTCENTER.ID", (Object)costCenterId, CompareType.NOTEQUALS));
            view.setFilter(filter);
            OperationTypeCostCenterEntryCollection operationTypeCCECollection = iOperationTypeCCE.getOperationTypeCostCenterEntryCollection(view);
            int js = operationTypeCCECollection.size();
            for (j = 0; j < js; ++j) {
                operationTypeCCEInfo = operationTypeCCECollection.get(j);
                notInSet.add(operationTypeCCEInfo.getOperationTypeId());
            }
            view = new EntityViewInfo();
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("OPERATIONTYPEID"));
            view.setSelector(selector);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("COMPANY.ID", (Object)companyId));
            filter.getFilterItems().add(new FilterItemInfo("COSTCENTER.ID", (Object)costCenterId));
            view.setFilter(filter);
            operationTypeCCECollection = iOperationTypeCCE.getOperationTypeCostCenterEntryCollection(view);
            js = operationTypeCCECollection.size();
            for (j = 0; j < js; ++j) {
                operationTypeCCEInfo = operationTypeCCECollection.get(j);
                notInSet.remove(operationTypeCCEInfo.getOperationTypeId());
            }
        }
        return notInSet;
    }

    @Override
    @Deprecated
    protected List _getOperationsByCompany(Context ctx) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        fic.add(new FilterItemInfo("isEnable", (Object)Boolean.TRUE));
        String ln = company.getLongNumber();
        String[] lnSecs = ln.split("!");
        int size = lnSecs.length;
        HashSet<String> lnUps = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            lnUps.add(lnSecs[i]);
        }
        if (lnUps.size() != 0) {
            fic.add(new FilterItemInfo("company.number", lnUps, CompareType.INCLUDE));
            fi.setMaskString("(#0 or #2) and #1");
        }
        evi.setFilter(fi);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        evi.setSorter(sorter);
        OperationTypeCollection otc = OperationTypeFactory.getLocalInstance(ctx).getOperationTypeCollection(evi);
        Iterator it = otc.iterator();
        ArrayList result = new ArrayList();
        while (it.hasNext()) {
            OperationTypeInfo info = (OperationTypeInfo)it.next();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", info.getId().toString());
            map.put("number", info.getNumber().toString());
            map.put("name", info.getName().toString());
            map.put("companyId", info.getCompany().getId().toString());
            result.add(map);
        }
        return result;
    }

    @Override
    protected Map _getExpenseTypeGroupFilter(Context ctx, String companyId) throws BOSException, EASBizException {
        Locale local = ctx.getOriginLocale();
        HashMap<String, Object> expenseTypeGroup = new HashMap<String, Object>();
        expenseTypeGroup.put("field", "expenseType.id");
        expenseTypeGroup.put("dataType", "ObjectValue");
        expenseTypeGroup.put("title", ResourceBase.getString((String)RESBIZCOLL, (String)"ExpenseType", (Locale)local));
        expenseTypeGroup.put("mitiSelect", "false");
        expenseTypeGroup.put("displayCount", 8);
        expenseTypeGroup.put("unlimited", true);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        if (StringUtils.isNotBlank((String)companyId)) {
            SelectorItemCollection companySelector = new SelectorItemCollection();
            companySelector.add(new SelectorItemInfo("id"));
            companySelector.add(new SelectorItemInfo("longNumber"));
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), companySelector);
        }
        String longNumber = company.getLongNumber();
        String[] numbers = longNumber.split("!");
        HashSet<String> companyNumbers = new HashSet<String>();
        int is = numbers.length;
        for (int i = 0; i < is; ++i) {
            companyNumbers.add(numbers[i]);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("operationType.isEnable", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.number", companyNumbers, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("controlType", (Object)0, CompareType.NOTEQUALS));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        entityViewInfo.setSelector(selector);
        ExpenseTypeCollection expenseTypeCollection = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeCollection(entityViewInfo);
        ArrayList<String> expenseTypeIds = new ArrayList<String>();
        ArrayList filterItems = new ArrayList();
        int js = expenseTypeCollection.size();
        for (int j = 0; j < js; ++j) {
            ExpenseTypeInfo expenseTypeInfo = expenseTypeCollection.get(j);
            String expenseTypeId = expenseTypeInfo.getId().toString();
            if (expenseTypeIds.contains(expenseTypeId)) continue;
            expenseTypeIds.add(expenseTypeId);
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            filterMap.put("alias", expenseTypeInfo.getName());
            filterMap.put("value", expenseTypeId);
            filterMap.put("isDefault", false);
            filterItems.add(filterMap);
        }
        expenseTypeGroup.put("filterItems", filterItems);
        return expenseTypeGroup;
    }
}

