/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.ImageStateEnum;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AccountAdjustEntryCoreBaseInfo;
import com.kingdee.eas.cp.bc.AdjustStateEnum;
import com.kingdee.eas.cp.bc.BcParamInfo;
import com.kingdee.eas.cp.bc.BizAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseCollection;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CollectionAccountCollection;
import com.kingdee.eas.cp.bc.CollectionAccountCoreBaseInfo;
import com.kingdee.eas.cp.bc.CollectionAccountFactory;
import com.kingdee.eas.cp.bc.CollectionAccountInfo;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillEntryInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillEntryInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillEntryInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.IExpenseAccountBill;
import com.kingdee.eas.cp.bc.IExpenseAccountFacade;
import com.kingdee.eas.cp.bc.IExpenseCommenFacade;
import com.kingdee.eas.cp.bc.IRePaymentBill;
import com.kingdee.eas.cp.bc.LoanBillInfo;
import com.kingdee.eas.cp.bc.OperationException;
import com.kingdee.eas.cp.bc.OperationTypeCollection;
import com.kingdee.eas.cp.bc.OperationTypeFactory;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillEntryInfo;
import com.kingdee.eas.cp.bc.OtherExpenseBillInfo;
import com.kingdee.eas.cp.bc.PayState;
import com.kingdee.eas.cp.bc.RePaymentBillCollection;
import com.kingdee.eas.cp.bc.RePaymentBillInfo;
import com.kingdee.eas.cp.bc.RePaymentFacadeFactory;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.app.AbstractCommonWebUtilFacadeControllerBean;
import com.kingdee.eas.cp.bc.app.CommonDataWebUtils;
import com.kingdee.eas.cp.bc.app.invoicepool.util.BizInvoicePoolUtil;
import com.kingdee.eas.cp.bc.app.reverse.BillReverse;
import com.kingdee.eas.cp.bc.util.InvoiceUtil;
import com.kingdee.eas.cp.bc.util.NBgControlCallerUtil;
import com.kingdee.eas.cp.bc.util.ReverseUtil;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CommonWebUtilFacadeControllerBean
extends AbstractCommonWebUtilFacadeControllerBean {
    private static String invoiceResource = "com.kingdee.eas.cp.bc.InvoiceResource";
    private String commonUtilResource = "com.kingdee.eas.cp.bc.CommonUtilResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.CommonWebUtilFacadeControllerBean");
    private static final String CFG_FILE = "com/kingdee/eas/cp/bc/app/services/CPBCService.properties";
    private static Properties props = new Properties();
    private static Map<String, Class> classes = new HashMap<String, Class>();

    @Override
    protected String _getBudget(Context ctx, IObjectValue billInfo, IObjectValue expenseType, IObjectValue operationType, IObjectValue costCenter, String id) throws BOSException, EASBizException {
        BizCollBillBaseInfo bill = (BizCollBillBaseInfo)billInfo;
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (expenseType != null) {
            map.put("expenseType", expenseType);
        }
        if (operationType != null) {
            map.put("operationType", operationType);
        }
        if (costCenter != null) {
            map.put("costCenter", costCenter);
        }
        if (id != null) {
            map.put("sourceEntryId", id);
        }
        try {
            IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
            String labelText = iExpenseCommenFacade.getBudget(bill, bill.getId(), map);
            return labelText;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected List _getBudgets(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BizCollBillBaseInfo info = (BizCollBillBaseInfo)model;
        if (info instanceof OtherExpenseBillInfo) {
            return this.getBudgetsForOtherExpense(ctx, (OtherExpenseBillInfo)info);
        }
        if (info instanceof DailyLoanBillInfo) {
            return this.getBudgetsForDailyLoan(ctx, (DailyLoanBillInfo)info);
        }
        if (info instanceof BizAccountBillInfo) {
            return this.getBudgetsForBizAccount(ctx, (BizAccountBillInfo)info);
        }
        if (info instanceof BizAccountOutBillInfo) {
            return this.getBudgetsForBizOutAccount(ctx, (BizAccountOutBillInfo)info);
        }
        if (info instanceof EvectionReqBillInfo) {
            return this.getBudgetsForEvectionReq(ctx, (EvectionReqBillInfo)info);
        }
        if (info instanceof EvectionLoanBillInfo) {
            return this.getBudgetsForEvectionLoan(ctx, (EvectionLoanBillInfo)info);
        }
        if (info instanceof TravelAccountBillInfo) {
            return this.getBudgetsForTravelAccount(ctx, (TravelAccountBillInfo)info);
        }
        if (info instanceof DailyPurchaseAccountBillInfo) {
            return this.getBudgetsForPurchaseAccount(ctx, (DailyPurchaseAccountBillInfo)info);
        }
        return new ArrayList();
    }

    @Override
    protected Map _getParams(Context ctx, List paramList) throws BOSException, EASBizException {
        Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
        return paramMap;
    }

    @Override
    protected boolean _checkBillHasRePaybill(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        boolean result = false;
        try {
            result = CommonDataWebUtils.checkBillHasRePaybill(ctx, (BizCollBillBaseInfo)info);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    @Override
    protected boolean _checkForBillClose(Context ctx, String id) throws BOSException, EASBizException {
        boolean result = false;
        try {
            result = CommonDataWebUtils.checkForBillClose(ctx, id);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    @Override
    protected boolean _checkBillHasNextBill(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        boolean result = false;
        try {
            result = CommonDataWebUtils.checkBillHasNextBill(ctx, (BizCollBillBaseInfo)info);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    @Override
    protected void _reBgForCheckEntry(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP029");
        paramList.add("CP030");
        paramList.add("CP051");
        boolean loanUseBg = false;
        boolean reqBillUseBg = false;
        boolean eveReqBillUseBg = false;
        boolean bizAccountOutUseBg = false;
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)info;
        Map paramMap = null;
        paramMap = billInfo.getApplierCompany() != null && billInfo.getApplierCompany().getId() != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, billInfo.getApplierCompany().getId().toString()) : ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
        if (Boolean.valueOf(paramMap.get("CP029").toString()).booleanValue()) {
            loanUseBg = true;
        }
        if (Boolean.valueOf(paramMap.get("CP030").toString()).booleanValue()) {
            reqBillUseBg = true;
        }
        if (Boolean.valueOf(paramMap.get("CP051").toString()).booleanValue()) {
            eveReqBillUseBg = true;
        }
        if (billInfo instanceof ExpenseAccountBillInfo || billInfo instanceof DailyLoanBillInfo) {
            BizCollBillBaseInfo baseInfo = null;
            try {
                baseInfo = (BizCollBillBaseInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(billInfo.getId().getType(), (IObjectPK)new ObjectUuidPK(billInfo.getId()), BizCollUtil.getBudgetSelector());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (baseInfo != null && billInfo.getState().equals((Object)StateEnum.CHECKING)) {
                BillReverse reverse = new BillReverse();
                reverse.doReverseAmountBalance(ctx, baseInfo, "returnBudget");
                reverse.doReverseBg(ctx, baseInfo, "returnBudget", reqBillUseBg, loanUseBg, eveReqBillUseBg, bizAccountOutUseBg);
                reverse.doReverseAmountBalance(ctx, billInfo, "bgAudit");
                reverse.doReverseBg(ctx, billInfo, "bgAudit", reqBillUseBg, loanUseBg, eveReqBillUseBg, bizAccountOutUseBg);
            }
        }
    }

    @Override
    protected String _getAccount(Context ctx, String applierId, String costedDeptId, String currencyTypeId, String orgUnitId, String billTypeId, String companyId) throws BOSException, EASBizException {
        Map map = new HashMap();
        String tempStr = null;
        BcParamInfo bcParamInfo = null;
        PersonInfo person = null;
        CostCenterOrgUnitInfo costcenter = null;
        CurrencyInfo currency = null;
        AdminOrgUnitInfo adminOrgUnit = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        String loanBalanceAccountNumber = null;
        String loanBalanceShowName = null;
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("longNumber");
        if (!StringUtils.isEmpty((String)applierId) && !"null".equals(applierId)) {
            person = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(applierId), selector);
        }
        if (!StringUtils.isEmpty((String)costedDeptId) && !"null".equals(costedDeptId)) {
            costcenter = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(costedDeptId), selector);
        }
        if (!StringUtils.isEmpty((String)currencyTypeId) && !"null".equals(currencyTypeId)) {
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyTypeId), selector);
        }
        if (!StringUtils.isEmpty((String)orgUnitId) && !"null".equals(orgUnitId)) {
            adminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitId), selector);
        }
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP012");
        paramList.add("CP013");
        Map paramMap = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, companyId);
        loanBalanceAccountNumber = paramMap.get("CP012") == null ? null : paramMap.get("CP012").toString();
        loanBalanceShowName = paramMap.get("CP013") == null ? null : paramMap.get("CP013").toString();
        map = CommonUtilFacadeFactory.getLocalInstance(ctx).getAccount(person, costcenter, currency, adminOrgUnit, loanBalanceAccountNumber, companyId);
        tempStr = (String)map.get("tempStr");
        bcParamInfo = (BcParamInfo)map.get("bcParamInfo");
        if (bcParamInfo == null || !bcParamInfo.isCostCenterParam() && !bcParamInfo.isPersonParam() && !bcParamInfo.isOrgUnitParam()) {
            throw new BizCollException(BizCollException.BC_ACCOUNTYPE_NOT_SET);
        }
        if (tempStr == null || tempStr.equals("")) {
            tempStr = "0.00";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(loanBalanceShowName).append(ResourceBase.getString((String)"com.kingdee.eas.cp.bc.WebCommonUtilResource", (String)"BALANCE", (Locale)ctx.getLocale())).append(" : ");
        if (bcParamInfo != null) {
            if (!(bcParamInfo.isOrgUnitParam() || bcParamInfo.isCostCenterParam() || bcParamInfo.isPersonParam())) {
                tempStr = "0.00";
            }
            if (bcParamInfo.isOrgUnitParam() && adminOrgUnit != null) {
                sb.append(adminOrgUnit.getName());
                sb.append(" \u4e28 ");
            }
            if (bcParamInfo.isCostCenterParam() && costcenter != null) {
                sb.append(costcenter.getName());
                sb.append(" \u4e28 ");
            }
            if (bcParamInfo.isPersonParam() && person != null) {
                sb.append(person.getName());
                sb.append(" \u4e28 ");
            }
            tempStr = this.parseString(tempStr, "0.00");
            sb.append(tempStr);
            return sb.toString();
        }
        return null;
    }

    @Override
    protected String _getSpecialData(Context ctx, String userId) throws BOSException, EASBizException {
        return CommonDataWebUtils.getSpecialData(ctx, userId);
    }

    protected List<String> getBudgetsForOtherExpense(Context context, OtherExpenseBillInfo info) throws EASBizException, BOSException {
        ArrayList<String> budgets = new ArrayList<String>();
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            return budgets;
        }
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(context);
        OtherExpenseBillInfo clone = (OtherExpenseBillInfo)info.clone();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            OtherExpenseBillEntryInfo entry = info.getEntries().get(i);
            clone.getEntries().clear();
            clone.getEntries().add(entry);
            ExpenseTypeInfo expenseType = this.getExpenseType(context, entry.getExpenseType());
            entry.setExpenseType(expenseType);
            String sourceEntryId = entry.getSourceBillEntryID();
            HashMap<String, OtherExpenseBillEntryInfo> map = new HashMap<String, OtherExpenseBillEntryInfo>();
            map.put("entry", entry);
            String budget = iExpenseCommenFacade.getBudget(clone, clone.getId(), map);
            budgets.add(budget);
        }
        return budgets;
    }

    protected ExpenseTypeInfo getExpenseType(Context context, ExpenseTypeInfo expenseType) throws EASBizException, BOSException {
        if (expenseType == null || expenseType.getId() == null) {
            return expenseType;
        }
        if (expenseType.getNumber() != null && expenseType.getName() != null && expenseType.getTypeName() != null) {
            return expenseType;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("typeName");
        selector.add("operationType.id");
        selector.add("operationType.number");
        selector.add("operationType.name");
        ExpenseTypeInfo result = ExpenseTypeFactory.getLocalInstance(context).getExpenseTypeInfo((IObjectPK)new ObjectUuidPK(expenseType.getId().toString()), selector);
        return result;
    }

    protected List<String> getBudgetsForDailyLoan(Context context, DailyLoanBillInfo info) throws EASBizException, BOSException {
        ArrayList<String> budgets = new ArrayList<String>();
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            return budgets;
        }
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(context);
        DailyLoanBillInfo clone = (DailyLoanBillInfo)info.clone();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            DailyLoanBillEntryInfo entry = info.getEntries().get(i);
            clone.getEntries().clear();
            clone.getEntries().add(entry);
            ExpenseTypeInfo expenseType = this.getExpenseType(context, entry.getExpenseType());
            entry.setExpenseType(expenseType);
            if (expenseType == null) continue;
            String sourceEntryId = entry.getSourceBillEntryID();
            HashMap<String, DailyLoanBillEntryInfo> map = new HashMap<String, DailyLoanBillEntryInfo>();
            map.put("entry", entry);
            String budget = iExpenseCommenFacade.getBudget(clone, clone.getId(), map);
            budgets.add(budget);
        }
        return budgets;
    }

    protected List<String> getBudgetsForBizAccount(Context context, BizAccountBillInfo info) throws EASBizException, BOSException {
        ArrayList<String> budgets = new ArrayList<String>();
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            return budgets;
        }
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(context);
        BizAccountBillInfo clone = (BizAccountBillInfo)info.clone();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            BizAccountBillEntryInfo entry = info.getEntries().get(i);
            clone.getEntries().clear();
            clone.getEntries().add(entry);
            ExpenseTypeInfo expenseType = this.getExpenseType(context, entry.getExpenseType());
            entry.setExpenseType(expenseType);
            OperationTypeInfo operationType = entry.getOperationType();
            if (operationType == null && expenseType != null) {
                operationType = expenseType.getOperationType();
                entry.setOperationType(operationType);
            }
            CostCenterOrgUnitInfo costCenter = entry.getCostCenter();
            String sourceEntryId = entry.getSourceBillEntryID();
            HashMap<String, BizAccountBillEntryInfo> map = new HashMap<String, BizAccountBillEntryInfo>();
            map.put("entry", entry);
            String budget = iExpenseCommenFacade.getBudget(clone, clone.getId(), map);
            if (budget == null) {
                budget = "";
            }
            budgets.add(budget);
        }
        return budgets;
    }

    protected List<String> getBudgetsForBizOutAccount(Context context, BizAccountOutBillInfo info) throws EASBizException, BOSException {
        ArrayList<String> budgets = new ArrayList<String>();
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            return budgets;
        }
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(context);
        BizAccountOutBillInfo clone = (BizAccountOutBillInfo)info.clone();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            BizAccountOutBillEntryInfo entry = info.getEntries().get(i);
            clone.getEntries().clear();
            clone.getEntries().add(entry);
            ExpenseTypeInfo expenseType = this.getExpenseType(context, entry.getExpenseType());
            entry.setExpenseType(expenseType);
            OperationTypeInfo operationType = entry.getOperationType();
            if (operationType == null && expenseType != null) {
                operationType = expenseType.getOperationType();
                entry.setOperationType(operationType);
            }
            CostCenterOrgUnitInfo costCenter = entry.getCostCenter();
            String sourceEntryId = entry.getSourceBillEntryID();
            HashMap<String, BizAccountOutBillEntryInfo> map = new HashMap<String, BizAccountOutBillEntryInfo>();
            map.put("entry", entry);
            String budget = iExpenseCommenFacade.getBudget(clone, clone.getId(), map);
            if (budget == null) {
                budget = "";
            }
            budgets.add(budget);
        }
        return budgets;
    }

    protected List<String> getBudgetsForPurchaseAccount(Context context, DailyPurchaseAccountBillInfo info) throws EASBizException, BOSException {
        ArrayList<String> budgets = new ArrayList<String>();
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            return budgets;
        }
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(context);
        DailyPurchaseAccountBillInfo clone = (DailyPurchaseAccountBillInfo)info.clone();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            DailyPurchaseAccountBillEntryInfo entry = info.getEntries().get(i);
            clone.getEntries().clear();
            clone.getEntries().add(entry);
            ExpenseTypeInfo expenseType = this.getExpenseType(context, entry.getExpenseType());
            entry.setExpenseType(expenseType);
            OperationTypeInfo operationType = entry.getOperationType();
            if (operationType == null && expenseType != null) {
                operationType = expenseType.getOperationType();
                entry.setOperationType(operationType);
            }
            CostCenterOrgUnitInfo costCenter = entry.getCostCenter();
            String sourceEntryId = entry.getSourceBillEntryID();
            HashMap<String, DailyPurchaseAccountBillEntryInfo> map = new HashMap<String, DailyPurchaseAccountBillEntryInfo>();
            map.put("entry", entry);
            String budget = iExpenseCommenFacade.getBudget(clone, clone.getId(), map);
            if (budget == null) {
                budget = "";
            }
            budgets.add(budget);
        }
        return budgets;
    }

    protected List<String> getBudgetsForEvectionReq(Context context, EvectionReqBillInfo info) throws EASBizException, BOSException {
        ArrayList<String> budgets = new ArrayList<String>();
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            return budgets;
        }
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(context);
        EvectionReqBillInfo clone = (EvectionReqBillInfo)info.clone();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            EvectionReqBillEntryInfo entry = info.getEntries().get(i);
            clone.getEntries().clear();
            clone.getEntries().add(entry);
            ExpenseTypeInfo expenseType = this.getExpenseType(context, entry.getExpenseType());
            entry.setExpenseType(expenseType);
            String sourceEntryId = entry.getSourceBillEntryID();
            HashMap<String, EvectionReqBillEntryInfo> map = new HashMap<String, EvectionReqBillEntryInfo>();
            map.put("entry", entry);
            String budget = iExpenseCommenFacade.getBudget(clone, clone.getId(), map);
            budgets.add(budget);
        }
        return budgets;
    }

    protected List<String> getBudgetsForEvectionLoan(Context context, EvectionLoanBillInfo info) throws EASBizException, BOSException {
        ArrayList<String> budgets = new ArrayList<String>();
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            return budgets;
        }
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(context);
        EvectionLoanBillInfo clone = (EvectionLoanBillInfo)info.clone();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            EvectionLoanBillEntryInfo entry = info.getEntries().get(i);
            clone.getEntries().clear();
            clone.getEntries().add(entry);
            ExpenseTypeInfo expenseType = this.getExpenseType(context, entry.getExpenseType());
            entry.setExpenseType(expenseType);
            if (expenseType == null) continue;
            String sourceEntryId = entry.getSourceBillEntryID();
            HashMap<String, EvectionLoanBillEntryInfo> map = new HashMap<String, EvectionLoanBillEntryInfo>();
            map.put("entry", entry);
            String budget = iExpenseCommenFacade.getBudget(clone, clone.getId(), map);
            budgets.add(budget);
        }
        return budgets;
    }

    private List<String> getBudgetsForTravelAccount(Context context, TravelAccountBillInfo info) throws EASBizException, BOSException {
        ArrayList<String> budgets = new ArrayList<String>();
        if (info.getEntries() == null || info.getEntries().size() == 0) {
            return budgets;
        }
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(context);
        TravelAccountBillInfo clone = (TravelAccountBillInfo)info.clone();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            TravelAccountBillEntryInfo entry = info.getEntries().get(i);
            clone.getEntries().clear();
            clone.getEntries().add(entry);
            ExpenseTypeInfo expenseType = this.getExpenseType(context, entry.getExpenseType());
            entry.setExpenseType(expenseType);
            OperationTypeInfo operationType = entry.getOperationType();
            if (operationType == null && expenseType != null) {
                operationType = expenseType.getOperationType();
                entry.setOperationType(operationType);
            }
            CostCenterOrgUnitInfo costCenter = entry.getCostCenter();
            String sourceEntryId = entry.getSourceBillEntryID();
            HashMap<String, TravelAccountBillEntryInfo> map = new HashMap<String, TravelAccountBillEntryInfo>();
            map.put("entry", entry);
            String budget = iExpenseCommenFacade.getBudget(clone, clone.getId(), map);
            budgets.add(budget);
        }
        return budgets;
    }

    protected String parseString(String str, String back) {
        if (str == null || str.trim().length() == 0) {
            return back;
        }
        if (str.indexOf(46) > 0) {
            String tempStr = str.substring(str.indexOf(46) + 1);
            if (tempStr.length() < 2) {
                for (int i = 0; i < 2 - tempStr.length(); ++i) {
                    str = str + "0";
                }
                return str;
            }
            if (tempStr.length() == 2) {
                return str;
            }
            if (tempStr.length() > 2) {
                return str.substring(0, str.lastIndexOf(46) + 3);
            }
        }
        try {
            Integer d = new Integer(str);
            return str + ".00";
        }
        catch (NumberFormatException e) {
            return back;
        }
    }

    @Override
    protected IObjectValue _getExRateInfo(Context ctx, String srcCurrId, String destCurrId, String companyId, Date date) throws BOSException, EASBizException {
        ExchangeTableInfo baseExchangeTable;
        CompanyOrgUnitInfo companyInfo;
        CompanyOrgUnitInfo company;
        CompanyOrgUnitInfo companyCommInfo = new CompanyOrgUnitInfo();
        companyCommInfo = companyId != null && !companyId.equals("") ? (company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId))) : (companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo"));
        if (destCurrId == null) {
            destCurrId = companyCommInfo.getBaseCurrency().getId().toString();
        }
        if ((baseExchangeTable = companyCommInfo.getBaseExchangeTable()) == null) {
            return null;
        }
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurrId);
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurrId);
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        ExchangeRateInfo exRateInfo = null;
        try {
            IExchangeRate iExchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
            exRateInfo = iExchangRate.getExchangeRate((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, DateTimeUtils.truncateDate((Date)date));
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return exRateInfo;
    }

    @Override
    protected IObjectValue _getCurrencyInfo(Context ctx, String id) throws BOSException, EASBizException {
        return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
    }

    @Override
    protected IObjectValue _getCompanyByCostDeptId(Context ctx, String costDeptId) throws BOSException, EASBizException {
        CostCenterOrgUnitInfo costCenter = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(costDeptId));
        BizCollBillBaseInfo info = CommonUtilFacadeFactory.getLocalInstance(ctx).forLoanBillCostCenterAction(costCenter);
        return info.getCompany();
    }

    @Override
    protected IObjectValue _getCostCenterOrgUnitInfo(Context ctx, String id) throws BOSException, EASBizException {
        return CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
    }

    @Override
    protected String _getCostDeptFilter(Context ctx, String companyId) throws BOSException, EASBizException {
        return CommonDataWebUtils.getCostDeptFilter(ctx, companyId);
    }

    @Override
    protected Map _fetchBudgetCtrl(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        HashMap<String, List> result = new HashMap<String, List>();
        if (billInfo == null) {
            return result;
        }
        List list = null;
        list = NBgControlCallerUtil.getBalance(ctx, billInfo);
        result.put("BGBALANCE", list);
        return result;
    }

    @Override
    protected Map _getApplierRelatedInfo(Context ctx, String applierId) throws BOSException, EASBizException {
        return CommonDataWebUtils.getApplierRelatedInfo(ctx, applierId);
    }

    @Override
    protected Set _getOrgIdsByUserAndType(Context ctx, String userId, String orgRangeType, Set orgIdSet) throws BOSException, EASBizException {
        return CommonDataWebUtils.getOrgIdsByUserAndType(ctx, userId, orgRangeType, orgIdSet);
    }

    @Override
    protected Map _getAdminAndCompanyFilter(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        ObjectUuidPK userPK = new ObjectUuidPK(user.getId());
        List companyOrgUnitIds = OrgRangeFactory.getLocalInstance((Context)ctx).getOrgIdByUserAndType((IObjectPK)userPK, OrgRangeType.BIZ_ORG_TYPE);
        if (companyOrgUnitIds == null || companyOrgUnitIds.size() == 0) {
            return result;
        }
        StringBuffer companyOrgUnitIdsBuffer = new StringBuffer();
        for (int i = 0; i < companyOrgUnitIds.size(); ++i) {
            companyOrgUnitIdsBuffer.append("'").append(companyOrgUnitIds.get(i)).append("',");
        }
        companyOrgUnitIdsBuffer.deleteCharAt(companyOrgUnitIdsBuffer.length() - 1);
        result.put("companyIds", companyOrgUnitIdsBuffer.toString());
        String adminOrgUnitIds = this.getAdminOrgIdsByCompany(companyOrgUnitIds, ctx);
        result.put("adminIds", adminOrgUnitIds);
        return result;
    }

    @Override
    protected String _getAdminIdsByCompany(Context ctx, String companyId) throws BOSException, EASBizException {
        StringBuffer adminSb = new StringBuffer();
        OrgUnitCollection unitColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getFromUnit(companyId, 1, 0);
        for (OrgUnitInfo unitInfo : unitColl) {
            adminSb.append("'").append(unitInfo.getId().toString()).append("',");
        }
        adminSb.deleteCharAt(adminSb.length() - 1);
        return adminSb.toString();
    }

    @Override
    protected Set _getApplierAdminOrgUnitIds(Context ctx) throws BOSException, EASBizException {
        return CommonDataWebUtils.getApplierAdminOrgUnitIds(ctx);
    }

    @Override
    protected IObjectValue _getCompanyByAdminId(Context ctx, String adminId) throws BOSException, EASBizException {
        return (CompanyOrgUnitInfo)OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(adminId, 0, 1).get(0);
    }

    @Override
    protected Map _getCompanysMapByAdmins(Context ctx, List adminIds) throws BOSException, EASBizException {
        HashMap<String, CompanyOrgUnitInfo> result = new HashMap<String, CompanyOrgUnitInfo>();
        Iterator it = adminIds.iterator();
        while (it.hasNext()) {
            String adminId = it.next().toString();
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(adminId, 0, 1).get(0);
            CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
            companyInfo.put("id", (Object)company.getId().toString());
            companyInfo.put("number", (Object)company.getNumber().toString());
            companyInfo.put("name", (Object)company.getName().toString());
            result.put(adminId, companyInfo);
        }
        return result;
    }

    @Override
    protected Map _getEqAndChildCUAdminIds(Context ctx) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        AdminOrgUnitInfo primaryAdminOrgUnit = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(user.getPerson().getId());
        CtrlUnitInfo currentCU = primaryAdminOrgUnit.getCU();
        CtrlUnitInfo ctrlUnitInfo = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(currentCU.getId()));
        result.put("parentCUId", ctrlUnitInfo.getParent().getId().toString());
        result.put("currentCUNumber", ctrlUnitInfo.getNumber());
        TreeBaseCollection eqCU = CtrlUnitFactory.getLocalInstance((Context)ctx).getChildren((TreeBaseInfo)ctrlUnitInfo.getParent());
        ArrayList<String> cuIds = new ArrayList<String>();
        int is = eqCU.size();
        for (int i = 0; i < is; ++i) {
            cuIds.add(eqCU.get(i).getId().toString());
        }
        TreeBaseCollection allChildren = CtrlUnitFactory.getLocalInstance((Context)ctx).getAllChildren((TreeBaseInfo)currentCU);
        int js = allChildren.size();
        for (int j = 0; j < js; ++j) {
            cuIds.add(allChildren.get(j).getId().toString());
        }
        EntityViewInfo adminEntityViewInfo = new EntityViewInfo();
        FilterInfo queryAdminFilter = new FilterInfo();
        queryAdminFilter.getFilterItems().add(new FilterItemInfo("cu.id", new HashSet(cuIds), CompareType.INCLUDE));
        adminEntityViewInfo.setFilter(queryAdminFilter);
        AdminOrgUnitCollection adminOrgUnitCollection = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(adminEntityViewInfo);
        ArrayList<String> adminOrgUnitIds = new ArrayList<String>();
        StringBuffer adminOrgUnitIdsBuffer = new StringBuffer();
        int ks = adminOrgUnitCollection.size();
        for (int k = 0; k < ks; ++k) {
            adminOrgUnitIds.add(adminOrgUnitCollection.get(k).getId().toString());
            adminOrgUnitIdsBuffer.append("'").append(adminOrgUnitCollection.get(k).getId().toString()).append("',");
        }
        adminOrgUnitIdsBuffer.deleteCharAt(adminOrgUnitIdsBuffer.length() - 1);
        result.put("adminIds", adminOrgUnitIdsBuffer.toString());
        return result;
    }

    private String getAdminOrgIdsByCompany(List<String> companyOrgUnitIds, Context context) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)0, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("toUnit", new HashSet<String>(companyOrgUnitIds), CompareType.INCLUDE));
        filterInfo.setMaskString("#0 AND #1 AND #2");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        CoreBaseCollection orgUnitRelations = OrgUnitRelationFactory.getLocalInstance((Context)context).getCollection(entityViewInfo);
        StringBuffer adminOrgUnitIdsBuffer = new StringBuffer();
        for (int i = 0; i < orgUnitRelations.size(); ++i) {
            OrgUnitRelationInfo orgUnitRelationInfo = (OrgUnitRelationInfo)orgUnitRelations.get(i);
            String fromUnitId = orgUnitRelationInfo.getFromUnit().getId().toString();
            adminOrgUnitIdsBuffer.append("'").append(fromUnitId).append("',");
        }
        adminOrgUnitIdsBuffer.deleteCharAt(adminOrgUnitIdsBuffer.length() - 1);
        return adminOrgUnitIdsBuffer.toString();
    }

    @Override
    protected String _getParamValue(Context ctx, IObjectPK companyId, String number) throws BOSException, EASBizException {
        return ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(companyId, number);
    }

    @Override
    protected Map _getParamValues(Context ctx, List paramList) throws BOSException, EASBizException {
        return ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
    }

    @Override
    protected Map _getPersonAndAdminOrgIdByUser(Context ctx, String userId) throws BOSException, EASBizException {
        if (userId == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("person.id"));
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId), selector);
        if (userInfo != null && userInfo.getPerson() != null && userInfo.getPerson().getId() != null) {
            String personId = userInfo.getPerson().getId().toString();
            AdminOrgUnitInfo adminOrg = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(BOSUuid.read((String)personId));
            if (adminOrg != null) {
                result.put("adminOrgId", adminOrg.getId().toString());
            }
            result.put("personId", personId);
        }
        return result;
    }

    @Override
    protected String _getPersonIdByUser(Context ctx, String userId) throws BOSException, EASBizException {
        if (userId == null) {
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("person.id"));
        UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId), selector);
        if (userInfo != null && userInfo.getPerson() != null && userInfo.getPerson().getId() != null) {
            return userInfo.getPerson().getId().toString();
        }
        return null;
    }

    @Override
    protected Map _getPrimaryAdminOrgUnit(Context ctx, List personIds) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        CompanyOrgUnitInfo info = new CompanyOrgUnitInfo();
        Iterator it = personIds.iterator();
        while (it.hasNext()) {
            ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>();
            String personId = (String)it.next();
            AdminOrgUnitInfo unitInfo = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(BOSUuid.read((String)personId));
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(unitInfo.getId().toString(), 0, 1).get(0);
            info.put("id", (Object)companyInfo.getId().toString());
            info.put("number", (Object)companyInfo.getNumber().toString());
            info.put("name", (Object)companyInfo.getName().toString());
            list.add(info);
            result.put(personId, list);
        }
        return result;
    }

    @Override
    protected boolean _hasWorkflow(Context ctx, String billId) throws BOSException, EASBizException {
        IEnactmentService service2 = EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(billId);
        int n = procInsts.length;
        for (int i = 0; i < n; ++i) {
            String state = procInsts[i].getState();
            if (!"open.running".equals(state) && !"open.not_running.suspended".equals(state)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Object _invokeService(Context ctx, String serviceName, String serviceMethod, Map params) throws BOSException, EASBizException {
        Class clazz = CommonWebUtilFacadeControllerBean.getServiceClass(serviceName);
        if (clazz == null) {
            throw new BOSException();
        }
        try {
            Method method = clazz.getMethod(serviceMethod, Context.class, Map.class);
            return method.invoke(clazz.newInstance(), ctx, params);
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private static synchronized Class getServiceClass(String serviceName) {
        if (serviceName == null || serviceName.trim().length() == 0) {
            return null;
        }
        if (classes.containsKey(serviceName = serviceName.trim())) {
            return classes.get(serviceName);
        }
        String className = props.getProperty(serviceName);
        className = className == null || className.trim().length() == 0 ? serviceName : className.trim();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (Exception e) {
            logger.error((Object)"can not load service.", (Throwable)e);
        }
        classes.put(serviceName, clazz);
        return clazz;
    }

    @Override
    protected Map _checkBudgetAfterReturnBg(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        BizCollBillBaseInfo bizBillInfo = (BizCollBillBaseInfo)billInfo;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP001");
        paramList.add("CP009");
        paramList.add("CP029");
        paramList.add("CP030");
        paramList.add("CP051");
        boolean isExisted = false;
        boolean isBgAuditAfterSubmit = false;
        Map paramMap = null;
        paramMap = bizBillInfo.getApplierCompany() != null && bizBillInfo.getApplierCompany().getId() != null ? ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, bizBillInfo.getApplierCompany().getId().toString()) : ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParams(paramList);
        Boolean reqBillUseBg = (boolean)new Boolean(paramMap.get("CP030").toString());
        Boolean loanBillUseBg = (boolean)new Boolean(paramMap.get("CP029").toString());
        Boolean isNeedBudget = (boolean)new Boolean(paramMap.get("CP001").toString());
        isBgAuditAfterSubmit = paramMap.get("CP009") == null ? false : new Boolean(paramMap.get("CP009").toString());
        Boolean eveReqBillUseBg = (boolean)new Boolean(paramMap.get("CP051").toString());
        if (bizBillInfo.getId() != null && DynamicObjectFactory.getLocalInstance((Context)ctx).exists(bizBillInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(bizBillInfo.getId()))) {
            isExisted = true;
        }
        BizCollBillBaseInfo infoOld = null;
        BillReverse reverse = new BillReverse();
        if (isExisted) {
            infoOld = (BizCollBillBaseInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(bizBillInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(bizBillInfo.getId()));
            if (isBgAuditAfterSubmit && infoOld.getState().getValue() == 25 && isNeedBudget.booleanValue() && BizCollUtil.checkBillUseBg(bizBillInfo, reqBillUseBg, loanBillUseBg, eveReqBillUseBg)) {
                IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"10_BizCollBillBaseControllerBean", (Locale)ctx.getLocale()));
                iExpenseCommenFacade.returnBudget(bizBillInfo.getId(), infoOld, false);
            }
        }
        throw new BOSException(JSONUtils.convertObjectToJson((Context)ctx, result));
    }

    @Override
    protected Map _getZhaoShangInitData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        CollectionAccountInfo collectionAccount = null;
        String personId = user.getPerson().getId().toString();
        StringBuffer oql = new StringBuffer();
        oql.append("select branchBankStr,isPublicAccount where applier.id = '").append(personId).append("' and isDefault = 1");
        CollectionAccountCollection collectionAccountCollection = CollectionAccountFactory.getLocalInstance(ctx).getCollectionAccountCollection(oql.toString());
        String branchBankStr = "";
        boolean isPublicAccount = false;
        if (collectionAccountCollection.size() > 0) {
            collectionAccount = (CollectionAccountInfo)collectionAccountCollection.getObject(0);
            branchBankStr = (String)collectionAccount.get("branchBankStr");
            isPublicAccount = (Boolean)collectionAccount.get("isPublicAccount");
        }
        resultMap.put("branchBankStr", branchBankStr);
        resultMap.put("isPublicAccount", isPublicAccount);
        resultMap.put("payState", (Object)PayState.NOPAY);
        CtrlUnitInfo currentCu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        String currentCuId = currentCu.getId().toString();
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.F7CostObjectQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)currentCuId));
        entityViewInfo.setFilter(filterInfo);
        SorterItemCollection sortItemCollection = new SorterItemCollection();
        SorterItemInfo sorterItemInfo = new SorterItemInfo();
        sorterItemInfo.setPropertyName("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        sortItemCollection.add(sorterItemInfo);
        entityViewInfo.setSorter(sortItemCollection);
        exec.setObjectView(entityViewInfo);
        IRowSet rowSet = exec.executeQuery(0, 1);
        CostObjectInfo costObject = new CostObjectInfo();
        try {
            while (rowSet.next()) {
                costObject.setId(BOSUuid.read((String)rowSet.getString("id")));
                costObject.setNumber(rowSet.getString("number"));
                costObject.setName(rowSet.getString("name"));
                resultMap.put("supportedObj", costObject);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    @Override
    protected boolean _saveZhaoShangDepModel(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        String personId = user.getPerson().getId().toString();
        if (model instanceof LoanBillInfo) {
            String sql = "UPDATE T_BC_COLLECTIONACCOUNT SET CFBRANCHBANKSTR='%s' WHERE CFBANKACCOUNT='%s' AND CFAPPLIERID='%s'";
            String payerAccount = model.getString("payerAccount");
            String payerName = model.getString("payerName");
            String payerBank = model.getString("payerBank");
            String branchBankStr = model.getString("branchBankStr");
            if (StringUtils.isBlank((String)payerAccount) || StringUtils.isBlank((String)payerBank) || StringUtils.isBlank((String)payerName)) {
                return true;
            }
            DbUtil.execute((Context)ctx, (String)String.format(sql, branchBankStr, payerAccount, personId));
        } else if (model instanceof ExpenseAccountBillInfo) {
            String sql = "UPDATE T_BC_COLLECTIONACCOUNT SET CFBRANCHBANKSTR='%s', CFIsPublicAccount='%s' WHERE CFBANKACCOUNT='%s' AND CFAPPLIERID='%s'";
            AbstractObjectCollection collectionAccounts = (AbstractObjectCollection)model.get("collectionEntries");
            int is = collectionAccounts.size();
            for (int i = 0; i < is; ++i) {
                CollectionAccountCoreBaseInfo accountInfo = (CollectionAccountCoreBaseInfo)collectionAccounts.getObject(i);
                String payerAccount = accountInfo.getPayerAccount();
                String payerName = accountInfo.getPayerName();
                String payerBank = accountInfo.getPayerBank();
                Boolean isPublicAccount = accountInfo.getBoolean("isPublicAccount");
                int isPublicAccountValue = isPublicAccount != false ? 1 : 0;
                String branchBankStr = "";
                if (StringUtils.isNotBlank((String)accountInfo.getString("branchBankStr"))) {
                    branchBankStr = accountInfo.getString("branchBankStr");
                }
                if (StringUtils.isBlank((String)payerAccount) || StringUtils.isBlank((String)payerBank) || StringUtils.isBlank((String)payerName)) continue;
                DbUtil.execute((Context)ctx, (String)String.format(sql, branchBankStr, isPublicAccountValue, payerAccount, personId));
            }
        }
        return false;
    }

    @Override
    @Deprecated
    protected boolean _disAudit(Context ctx, String billId) throws BOSException, EASBizException {
        ObjectUuidPK objectPk = new ObjectUuidPK(billId);
        BOSUuid bosId = BOSUuid.read((String)billId);
        BOSObjectType bosType = bosId.getType();
        IBizCollBillBase bizCtrl = (IBizCollBillBase)this.getEntityBizInterface(ctx, bosType);
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)bizCtrl.getValue((IObjectPK)objectPk, BizCollUtil.getReverseSourceBillSic());
        if (billInfo.getState().getValue() != 60) {
            if (!this.hasWorkFlow(ctx, billId)) {
                throw new BizCollException(BizCollException.HASNOWORKFLOW);
            }
            IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
            facade.setAuditInfoNull(bosId);
            bizCtrl.antiAudit(bosId);
            return true;
        }
        if (this.checkBillHasNextBill(ctx, billInfo)) {
            throw new BizCollException(BizCollException.HASNEXTBILLCANNOTDISAUDIT);
        }
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP001");
        paramList.add("CP002");
        paramList.add("CP008");
        paramList.add("CP029");
        paramList.add("CP030");
        paramList.add("CP024");
        String bosTypeStr = bosType.toString();
        Map params = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, billInfo.getApplierCompany().getId().toString());
        IExpenseCommenFacade expenseCtrl = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
        expenseCtrl.returnBudget(bosId, billInfo, false);
        new BillReverse().doReverseAmountBalance(ctx, billInfo, "returnBudget");
        if ("8110AAB2".equals(bosTypeStr)) {
            BizCollUtil.setBillStateReverse(billInfo, StateEnum.DRAFT);
            bizCtrl.updatePartial((CoreBaseInfo)billInfo, BizCollUtil.getBillCloseSic());
            if (BizCollUtil.hasCheckEntry(billInfo)) {
                CommonUtilFacadeFactory.getLocalInstance(ctx).reverseSourceBillState(billInfo, false, params);
            }
        } else if ("E76173AD".equals(bosTypeStr)) {
            BizCollUtil.setBillStateReverse(billInfo, StateEnum.DRAFT);
            bizCtrl.updatePartial((CoreBaseInfo)billInfo, BizCollUtil.getBillCloseSic());
        } else if ("4A44F49F".equals(bosTypeStr)) {
            IExpenseAccountFacade expenseAccountFacade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
            expenseAccountFacade.setState(bosId, StateEnum.DRAFT);
            if (BizCollUtil.hasCheckEntry(billInfo)) {
                CommonUtilFacadeFactory.getLocalInstance(ctx).reverseSourceBillState(billInfo, false, params);
            }
        } else if ("92F938DD".equals(bosTypeStr)) {
            IExpenseAccountFacade expenseAccountFacade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
            expenseAccountFacade.setState(bosId, StateEnum.DRAFT);
            if (BizCollUtil.hasCheckEntry(billInfo)) {
                CommonUtilFacadeFactory.getLocalInstance(ctx).reverseSourceBillState(billInfo, false, params);
            }
        } else if ("30BD2798".equals(bosTypeStr)) {
            IExpenseAccountFacade expenseAccountFacade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
            expenseAccountFacade.setState(bosId, StateEnum.DRAFT);
            if (BizCollUtil.hasCheckEntry(billInfo)) {
                CommonUtilFacadeFactory.getLocalInstance(ctx).reverseSourceBillState(billInfo, false, params);
            }
        } else if ("DE853384".equals(bosTypeStr)) {
            IExpenseAccountFacade expenseAccountFacade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
            expenseAccountFacade.setState(bosId, StateEnum.DRAFT);
        } else if ("7AE53B38".equals(bosTypeStr)) {
            BizCollUtil.setBillStateReverse(billInfo, StateEnum.DRAFT);
            bizCtrl.updatePartial((CoreBaseInfo)billInfo, BizCollUtil.getBillCloseSic());
            if (BizCollUtil.hasCheckEntry(billInfo)) {
                CommonUtilFacadeFactory.getLocalInstance(ctx).reverseSourceBillState(billInfo, false, params);
            }
        } else if ("C57003BC".equals(bosTypeStr)) {
            IExpenseAccountFacade expenseAccountFacade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
            expenseAccountFacade.setState(bosId, StateEnum.DRAFT);
            if (BizCollUtil.hasCheckEntry(billInfo)) {
                CommonUtilFacadeFactory.getLocalInstance(ctx).reverseSourceBillState(billInfo, false, params);
            }
        }
        ReverseUtil.reverseEvectionReqBillState(ctx, billId);
        return true;
    }

    private boolean hasWorkFlow(Context ctx, String bizObjId) throws BOSException {
        IEnactmentService enactmentService = EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessInstInfo[] processInsts = enactmentService.getProcessInstanceByHoldedObjectId(bizObjId);
        int il = processInsts.length;
        for (int i = 0; i < il; ++i) {
            String workFlowState = processInsts[i].getState();
            if (!"open.running".equals(workFlowState) && !"open.not_running.suspended".equals(workFlowState)) continue;
            return true;
        }
        return false;
    }

    private IBizCtrl getEntityBizInterface(Context ctx, BOSObjectType bosType) throws BOSException {
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(bosType);
        if (entityObjectInfo.isDynamic()) {
            return (IBizCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        }
        String clzFactoryName = entityObjectInfo.getBusinessImplFactory();
        try {
            Class<?> clzFactory = Class.forName(clzFactoryName);
            Class[] parameterTypes = new Class[]{Context.class};
            Method mGetInstance = clzFactory.getMethod("getLocalInstance", parameterTypes);
            IBizCtrl iBiz = (IBizCtrl)mGetInstance.invoke(null, ctx);
            return iBiz;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean checkBillHasNextBill(Context ctx, BizCollBillBaseInfo info) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)info.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("operatorid", (Object)"InvoicePool", CompareType.NOTEQUALS));
        viewInfo.setFilter(filter);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        exec.setObjectView(viewInfo);
        try {
            IRowSet rs = exec.executeQuery();
            return rs.next();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return true;
        }
    }

    @Override
    protected boolean _payOff(Context ctx, String billId) throws BOSException, EASBizException {
        if (!this.checkVoucherHasSubmit(ctx, billId, true)) {
            throw new BizCollException(BizCollException.CANNOTVOUCHER);
        }
        ObjectUuidPK objectPk = new ObjectUuidPK(billId);
        IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        LoanBillInfo loanBillInfo = (LoanBillInfo)dynamicObject.getValue(objectPk.getObjectType(), (IObjectPK)objectPk);
        loanBillInfo.setFiVouchered(false);
        dynamicObject.update(objectPk.getObjectType(), (IObjectPK)objectPk, (IObjectValue)loanBillInfo);
        return false;
    }

    private boolean checkVoucherHasSubmit(Context ctx, String billId, boolean checkState) throws BOSException {
        VoucherCollection voucherCollection;
        String ksql = "select bizStatus where sourceBillId='" + billId + "'";
        if (checkState) {
            ksql = ksql + " and bizStatus=0";
        }
        return (voucherCollection = VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(ksql)) == null || voucherCollection.size() <= 0;
    }

    @Override
    protected void _checkOperationTypeAndExpenseType(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ArrayList resultList = new ArrayList();
        AbstractObjectCollection entries = (AbstractObjectCollection)model.get("entries");
        HashSet<String> operationTypeIds = new HashSet<String>();
        HashSet<String> expenseTypeIds = new HashSet<String>();
        int is = entries.size();
        for (int i = 0; i < is; ++i) {
            CoreBillEntryBaseInfo entryInfo = (CoreBillEntryBaseInfo)entries.getObject(i);
            if (entryInfo.get("operationType") != null) {
                operationTypeIds.add(((OperationTypeInfo)entryInfo.get("operationType")).getId().toString());
            }
            if (entryInfo.get("expenseType") == null) continue;
            expenseTypeIds.add(((ExpenseTypeInfo)entryInfo.get("expenseType")).getId().toString());
        }
        SelectorItemCollection selecotr = new SelectorItemCollection();
        selecotr.add("id");
        selecotr.add("name");
        if (operationTypeIds.size() > 0) {
            EntityViewInfo operationTypeEv = new EntityViewInfo();
            FilterInfo queryOperationTypeFilter = new FilterInfo();
            queryOperationTypeFilter.getFilterItems().add(new FilterItemInfo("id", operationTypeIds, CompareType.INCLUDE));
            queryOperationTypeFilter.getFilterItems().add(new FilterItemInfo("isEnable", (Object)false));
            operationTypeEv.setSelector(selecotr);
            operationTypeEv.setFilter(queryOperationTypeFilter);
            OperationTypeCollection operationTypeCollection = OperationTypeFactory.getLocalInstance(ctx).getOperationTypeCollection(operationTypeEv);
            if (operationTypeCollection.size() > 0) {
                throw new OperationException(OperationException.OPERATIONTYPE_NOT_ENABLE);
            }
        }
        if (expenseTypeIds.size() > 0) {
            EntityViewInfo expenseTypeEv = new EntityViewInfo();
            expenseTypeEv.setSelector(selecotr);
            FilterInfo queryExpenseTypeFilter = new FilterInfo();
            queryExpenseTypeFilter.getFilterItems().add(new FilterItemInfo("id", expenseTypeIds, CompareType.INCLUDE));
            queryExpenseTypeFilter.getFilterItems().add(new FilterItemInfo("isStart", (Object)false));
            expenseTypeEv.setSelector(selecotr);
            expenseTypeEv.setFilter(queryExpenseTypeFilter);
            ExpenseTypeCollection expenseTypeCollection = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeCollection(expenseTypeEv);
            if (expenseTypeCollection.size() > 0) {
                throw new OperationException(OperationException.EXPENSETYPE_NOT_ENABLE);
            }
            queryExpenseTypeFilter = new FilterInfo();
            queryExpenseTypeFilter.getFilterItems().add(new FilterItemInfo("id", expenseTypeIds, CompareType.INCLUDE));
            queryExpenseTypeFilter.getFilterItems().add(new FilterItemInfo("operationType.isEnable", (Object)false));
            expenseTypeEv.setFilter(queryExpenseTypeFilter);
            expenseTypeCollection = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeCollection(expenseTypeEv);
            if (expenseTypeCollection.size() > 0) {
                throw new OperationException(OperationException.OPERATIONTYPE_NOT_ENABLE);
            }
        }
    }

    @Override
    protected Map _audit(Context ctx, String[] ids, String permissionItem) throws BOSException, EASBizException {
        if (ids == null || ids.length == 0) {
            return null;
        }
        BOSUuid bosId = BOSUuid.read((String)ids[0]);
        BOSObjectType bosType = bosId.getType();
        IRePaymentBill rePayCtrl = (IRePaymentBill)this.getEntityBizInterface(ctx, bosType);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(Arrays.asList(ids)), CompareType.INCLUDE));
        view.setSelector(this.getRepaySelector());
        view.setFilter(filter);
        RePaymentBillCollection rePayColl = rePayCtrl.getRePaymentBillCollection(view);
        if (rePayColl == null || rePayColl.size() == 0) {
            return null;
        }
        RePaymentBillInfo billInfo = null;
        HashMap<String, String> data = new HashMap<String, String>();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        int is = rePayColl.size();
        for (int i = 0; i < is; ++i) {
            billInfo = rePayColl.get(i);
            bosId = billInfo.getId();
            StateEnum billState = billInfo.getState();
            String billNumber = billInfo.getNumber();
            try {
                if (!StringUtils.isBlank((String)permissionItem)) {
                    PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId().toString()), (IObjectPK)new ObjectUuidPK(billInfo.getApplierCompany().getId().toString()), permissionItem);
                }
                if (!StateEnum.SUBMIT.equals((Object)billState)) {
                    throw new BizCollException(BizCollException.CANNOTAUDIT);
                }
                boolean idInProcess = FMHelper.hasWFInstance(null, (String)bosId.toString());
                if (idInProcess) {
                    throw new BizCollException(BizCollException.STARTEDWORKFLOW);
                }
                RePaymentFacadeFactory.getLocalInstance(ctx).setAudit(bosId, null);
                continue;
            }
            catch (Exception e) {
                data.put(billInfo.getNumber(), e.getMessage());
            }
        }
        return data;
    }

    @Override
    protected Map _antiaudit(Context ctx, String[] ids, String permissionItem) throws BOSException {
        if (ids == null || ids.length == 0) {
            return null;
        }
        BOSUuid bosId = BOSUuid.read((String)ids[0]);
        BOSObjectType bosType = bosId.getType();
        IRePaymentBill rePayCtrl = (IRePaymentBill)this.getEntityBizInterface(ctx, bosType);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(Arrays.asList(ids)), CompareType.INCLUDE));
        view.setSelector(this.getRepaySelector());
        view.setFilter(filter);
        RePaymentBillCollection rePayColl = rePayCtrl.getRePaymentBillCollection(view);
        if (rePayColl == null || rePayColl.size() == 0) {
            return null;
        }
        RePaymentBillInfo billInfo = null;
        HashMap<String, String> data = new HashMap<String, String>();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        int is = rePayColl.size();
        for (int i = 0; i < is; ++i) {
            billInfo = rePayColl.get(i);
            bosId = billInfo.getId();
            StateEnum billState = billInfo.getState();
            String billNumber = billInfo.getNumber();
            try {
                if (!StringUtils.isBlank((String)permissionItem)) {
                    PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId().toString()), (IObjectPK)new ObjectUuidPK(billInfo.getApplierCompany().getId().toString()), permissionItem);
                }
                if (!StateEnum.CHECKED.equals((Object)billState)) {
                    throw new BizCollException(BizCollException.CANNOTANTIAUDIT);
                }
                String srcBillId = null;
                boolean srcIsClosed = false;
                if (!BizCollUtil.objectIsNull(billInfo.getSourceBillId())) {
                    srcBillId = billInfo.getSourceBillId().toString();
                    srcIsClosed = this.checkSourceIsClose(ctx, srcBillId);
                }
                if (srcIsClosed) {
                    throw new BizCollException(BizCollException.SOURCEBILLISCLOSED);
                }
                if (BizCollUtil.checkRePayBillHasNextBill(ctx, bosId)) {
                    throw new BizCollException(BizCollException.HASNEXTBILLCANNOTDISAUDIT);
                }
                RePaymentFacadeFactory.getLocalInstance(ctx).setAntiAudit(bosId, null);
                continue;
            }
            catch (Exception e) {
                data.put(billInfo.getNumber(), e.getMessage());
            }
        }
        return data;
    }

    @Override
    protected boolean _getRepayStateByLoan(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        boolean isSubmit = false;
        String bill = billId.toString();
        String queryOql = "SELECT ID WHERE ID='%s' AND ISREPAY='%s'";
        if (DynamicObjectFactory.getLocalInstance((Context)ctx).exists(new ObjectUuidPK(billId).getObjectType(), String.format(queryOql, billId, 1))) {
            isSubmit = true;
        }
        return isSubmit;
    }

    private boolean checkSourceIsClose(Context ctx, String billId) {
        boolean closed = false;
        ObjectUuidPK objpk = new ObjectUuidPK(billId);
        try {
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            BizCollBillBaseInfo sourceinfo = (BizCollBillBaseInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk, CommonWebUtilFacadeControllerBean.getSelector());
            if (StateEnum.CLOSED.equals((Object)sourceinfo.getState())) {
                closed = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return closed;
    }

    private static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    private SelectorItemCollection getRepaySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("applierCompany.id"));
        sic.add(new SelectorItemInfo("applierCompany.name"));
        sic.add(new SelectorItemInfo("applierCompany.number"));
        return sic;
    }

    @Override
    @Deprecated
    protected Map _disAuditBatch(Context ctx, String[] ids, String permissionItem) throws BOSException {
        if (ids == null || ids.length == 0) {
            return null;
        }
        BOSUuid bosId = BOSUuid.read((String)ids[0]);
        BOSObjectType bosType = bosId.getType();
        IBizCollBillBase bizCtrl = (IBizCollBillBase)this.getEntityBizInterface(ctx, bosType);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(Arrays.asList(ids)), CompareType.INCLUDE));
        view.setSelector(BizCollUtil.getReverseSourceBillSic());
        view.setFilter(filter);
        BizCollBillBaseCollection billCol = bizCtrl.getBizCollBillBaseCollection(view);
        if (billCol == null || billCol.size() == 0) {
            return null;
        }
        BizCollBillBaseInfo billInfo = null;
        HashMap<String, String> data = new HashMap<String, String>();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        int is = billCol.size();
        for (int i = 0; i < is; ++i) {
            billInfo = billCol.get(i);
            bosId = billInfo.getId();
            StateEnum billState = billInfo.getState();
            String billNumber = billInfo.getNumber();
            try {
                SelectorItemCollection sic;
                if (!StringUtils.isBlank((String)permissionItem)) {
                    PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId().toString()), (IObjectPK)new ObjectUuidPK(billInfo.getApplierCompany().getId().toString()), permissionItem);
                }
                if (!StateEnum.CHECKING.equals((Object)billState) && !StateEnum.CHECKED.equals((Object)billState)) {
                    throw new BizCollException(BizCollException.CANNOTUNAPPROVE);
                }
                if (!StateEnum.CHECKED.equals((Object)billState)) {
                    if (!this.hasWorkFlow(ctx, billInfo.getId().toString())) {
                        throw new BizCollException(BizCollException.HASNOWORKFLOW);
                    }
                    bizCtrl.antiAudit(bosId);
                    continue;
                }
                if (this.checkBillHasNextBill(ctx, billInfo)) {
                    throw new BizCollException(BizCollException.HASNEXTBILLCANNOTDISAUDIT);
                }
                ArrayList<String> paramList = new ArrayList<String>();
                paramList.add("CP001");
                paramList.add("CP002");
                paramList.add("CP008");
                paramList.add("CP029");
                paramList.add("CP030");
                paramList.add("CP024");
                String bosTypeStr = bosType.toString();
                Map params = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, billInfo.getApplierCompany().getId().toString());
                if (BizCollUtil.hasCheckEntry(billInfo)) {
                    CommonUtilFacadeFactory.getLocalInstance(ctx).reverseSourceBillState(billInfo, false, params);
                }
                IExpenseCommenFacade expenseCtrl = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
                expenseCtrl.returnBudget(bosId, billInfo, false);
                new BillReverse().doReverseAmountBalance(ctx, billInfo, "returnBudget");
                if (billInfo instanceof OtherExpenseBillInfo) {
                    BizCollUtil.setBillStateReverse(billInfo, StateEnum.DRAFT);
                    billInfo.setAuditor(null);
                    billInfo.setAuditDate(null);
                    sic = BizCollUtil.getBillCloseSic();
                    sic.add(new SelectorItemInfo("auditor"));
                    sic.add(new SelectorItemInfo("auditDate"));
                    bizCtrl.updatePartial((CoreBaseInfo)billInfo, sic);
                } else if (billInfo instanceof EvectionReqBillInfo) {
                    BizCollUtil.setBillStateReverse(billInfo, StateEnum.DRAFT);
                    billInfo.setAuditor(null);
                    billInfo.setAuditDate(null);
                    sic = BizCollUtil.getBillCloseSic();
                    sic.add(new SelectorItemInfo("auditor"));
                    sic.add(new SelectorItemInfo("auditDate"));
                    bizCtrl.updatePartial((CoreBaseInfo)billInfo, sic);
                } else if (billInfo instanceof DailyLoanBillInfo || billInfo instanceof EvectionLoanBillInfo) {
                    BizCollUtil.setBillStateReverse(billInfo, StateEnum.DRAFT);
                    billInfo.setAmountNotPaid(BizCollUtil.ZERO);
                    billInfo.setAuditor(null);
                    billInfo.setAuditDate(null);
                    sic = BizCollUtil.getBillCloseSic();
                    sic.add(new SelectorItemInfo("amountNotPaid"));
                    sic.add(new SelectorItemInfo("auditor"));
                    sic.add(new SelectorItemInfo("auditDate"));
                    bizCtrl.updatePartial((CoreBaseInfo)billInfo, sic);
                } else if (billInfo instanceof BizAccountBillInfo || billInfo instanceof TravelAccountBillInfo || billInfo instanceof BizAccountOutBillInfo || billInfo instanceof DailyPurchaseAccountBillInfo) {
                    ExpenseAccountBillInfo eabillInfo = (ExpenseAccountBillInfo)billInfo;
                    IExpenseAccountBill iBiz = (IExpenseAccountBill)bizCtrl;
                    eabillInfo.setState(StateEnum.DRAFT);
                    eabillInfo.setAmountNotPaid(BizCollUtil.ZERO);
                    eabillInfo.setAmountEncashed(BizCollUtil.calcuAmountEncashed(eabillInfo));
                    billInfo.setAuditor(null);
                    billInfo.setAuditDate(null);
                    SelectorItemCollection sic2 = new SelectorItemCollection();
                    sic2.add(new SelectorItemInfo("state"));
                    sic2.add(new SelectorItemInfo("amountNotPaid"));
                    sic2.add(new SelectorItemInfo("amountEncashed"));
                    sic2.add(new SelectorItemInfo("auditor"));
                    sic2.add(new SelectorItemInfo("auditDate"));
                    iBiz.updatePartial((CoreBaseInfo)eabillInfo, sic2);
                    if (BizInvoicePoolUtil.getCpbcParams(ctx, billInfo.getId().toString())) {
                        BizInvoicePoolUtil.deleteInvoicePool(ctx, billInfo.getId());
                    }
                    if (InvoiceUtil.getTicketinVoice(ctx, billInfo.getId().toString())) {
                        logger.error((Object)"#############################cpbc  CommonWebUtilFacadeControllerBean _disAuditBatch  start##############################");
                        InvoiceUtil.updateInvoiceNewState(ctx, billInfo.getId());
                        logger.error((Object)"#############################cpbc  CommonWebUtilFacadeControllerBean _disAuditBatch  end##############################");
                    }
                }
                ReverseUtil.reverseEvectionReqBillState(ctx, billInfo.getId().toString());
                continue;
            }
            catch (MissMatchParticipantException e) {
                String msg = e.getMessage();
                if (msg.indexOf("id") != -1) {
                    msg = msg.substring(0, msg.lastIndexOf("\uff0c")) + "\uff01";
                }
                data.put(billInfo.getNumber(), msg);
                continue;
            }
            catch (Exception e) {
                data.put(billInfo.getNumber(), e.getMessage());
            }
        }
        return data;
    }

    @Override
    protected Map _getPosition(Context ctx, String applierId, String orgUnitId) throws BOSException, EASBizException {
        String queryOql;
        IPositionMember iPosiMember;
        PositionMemberCollection posiMemberColl;
        HashMap<String, Object> result = new HashMap<String, Object>();
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        boolean userInOrgUnit = false;
        if (!StringUtils.isEmpty((String)applierId) && !StringUtils.isEmpty((String)orgUnitId)) {
            AdminOrgUnitCollection orgUnitCol = iPerson.getAllAdminOrgUnit(BOSUuid.read((String)applierId));
            int is = orgUnitCol.size();
            for (int i = 0; i < is; ++i) {
                String adminId = orgUnitCol.get(i).getId().toString();
                if (!adminId.equals(orgUnitId)) continue;
                userInOrgUnit = true;
                break;
            }
        }
        result.put("userInOrgUnit", userInOrgUnit);
        String positionFilter = "";
        if (!StringUtils.isEmpty((String)applierId)) {
            positionFilter = String.format("PERSON.ID = '%s'", applierId);
        }
        result.put("positionFilter", positionFilter);
        PositionInfo position = null;
        if (!StringUtils.isEmpty((String)orgUnitId) && !StringUtils.isEmpty((String)applierId) && (posiMemberColl = (iPosiMember = PositionMemberFactory.getLocalInstance((Context)ctx)).getPositionMemberCollection(String.format(queryOql = "SELECT POSITION.ID,POSITION.NAME,POSITION.NUMBER WHERE POSITION.ADMINORGUNIT.ID = '%s' AND PERSON.ID = '%s' ORDER BY ISPRIMARY DESC, POSITION.NUMBER ASC", orgUnitId, applierId))) != null && posiMemberColl.size() > 0) {
            position = posiMemberColl.get(0).getPosition();
        }
        result.put("position", position);
        return result;
    }

    @Override
    protected int _getCountBillByState(Context ctx, String applierId, int state) throws BOSException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String userId = userInfo.getId().toString();
        String companyId = company.getId().toString();
        int count = 0;
        StringBuilder sql = new StringBuilder();
        ArrayList<java.sql.Date> params = new ArrayList<java.sql.Date>();
        Calendar cal = Calendar.getInstance();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        Date now = cal.getTime();
        java.sql.Date nowDate = new java.sql.Date(now.getTime());
        cal.set(1, cal.get(1) - 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date beforeYear = cal.getTime();
        java.sql.Date beforeYearDate = new java.sql.Date(beforeYear.getTime());
        if (state == 0) {
            sql.append("SELECT count(1) FROM T_BC_BizAccountBill WHERE (FIsEvaluation = " + state + " OR FIsEvaluation is null) and ( fstate in  ( 60,65,70,45 ) ) ");
            sql.append("AND (FApplierID = '" + applierId + "' OR FCreatorID = '" + userId + "') ");
            sql.append("and (FBIZREQDATE >= ? AND FBIZREQDATE <= ?)  UNION ALL ");
            sql.append("SELECT count(1) FROM T_BC_TravelAccountBill WHERE (FIsEvaluation = " + state + " OR FIsEvaluation is null) and ( fstate in  ( 60,65,70,45 ) ) ");
            sql.append("AND (FApplierID = '" + applierId + "' OR FCreatorID = '" + userId + "') ");
            sql.append("and (FBIZREQDATE >= ? AND FBIZREQDATE <= ?) ");
            for (int i = 0; i < 2; ++i) {
                params.add(beforeYearDate);
                params.add(nowDate);
            }
        } else {
            String myState = null;
            myState = state == 30 ? "FSTATE in ( " + state + ", 145 )" : "FSTATE = " + state + "";
            sql.append("SELECT count(1) FROM T_BC_BizAccountBill WHERE ").append(myState).append(" AND (FApplierID = '" + applierId + "' OR FCreatorID = '" + userId + "') ");
            sql.append("and (FBIZREQDATE >= ? AND FBIZREQDATE <= ?) UNION ALL ");
            sql.append("SELECT count(1) FROM T_BC_BizAccountOutBill WHERE ").append(myState).append(" AND (FApplierID = '" + applierId + "' OR FCreatorID = '" + userId + "') ");
            sql.append("and (FBIZREQDATE >= ? AND FBIZREQDATE <= ?) UNION ALL ");
            sql.append("SELECT count(1) FROM T_BC_DailyPurchaseAccountBill WHERE ").append(myState).append(" AND (FApplierID = '" + applierId + "' OR FCreatorID = '" + userId + "') ");
            sql.append("and (FBIZREQDATE >= ? AND FBIZREQDATE <= ?) UNION ALL ");
            sql.append("SELECT count(1) FROM T_BC_TravelAccountBill WHERE ").append(myState).append(" AND (FApplierID = '" + applierId + "' OR FCreatorID = '" + userId + "') ");
            sql.append("and (FBIZREQDATE >= ? AND FBIZREQDATE <= ?) UNION ALL ");
            sql.append("SELECT count(1) FROM T_BC_DailyLoanBill WHERE ").append(myState).append(" AND (FApplierID = '" + applierId + "' OR FCreatorID = '" + userId + "') ");
            sql.append("and (FBIZREQDATE >= ? AND FBIZREQDATE <= ?) UNION ALL ");
            sql.append("SELECT count(1) FROM T_BC_EvectionLoanBill WHERE ").append(myState).append(" AND (FApplierID = '" + applierId + "' OR FCreatorID = '" + userId + "') ");
            sql.append("and (FBIZREQDATE >= ? AND FBIZREQDATE <= ?) UNION ALL ");
            sql.append("SELECT count(1) FROM T_BC_EvectionReqBill WHERE ").append(myState).append(" AND (FApplierID = '" + applierId + "' OR FCreatorID = '" + userId + "') ");
            sql.append("and (FBIZREQDATE >= ? AND FBIZREQDATE <= ?) UNION ALL ");
            sql.append("SELECT count(1) FROM T_BC_OtherExpenseBill WHERE ").append(myState).append(" AND (FApplierID = '" + applierId + "' OR FCreatorID = '" + userId + "') ");
            sql.append("and (FBIZREQDATE >= ? AND FBIZREQDATE <= ?) ");
            for (int i = 0; i < 8; ++i) {
                params.add(beforeYearDate);
                params.add(nowDate);
            }
        }
        try {
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
            params.clear();
            while (set.next()) {
                count += set.getInt(1);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return count;
    }

    @Override
    protected Set _getCostDeptIds(Context ctx, String companyId) throws BOSException, EASBizException {
        return CommonDataWebUtils.getCostDeptIds(ctx, companyId);
    }

    @Override
    protected boolean _disAuditAddMessage(Context ctx, String billId, String disAuditPersonId, String disAuditOption) throws BOSException, EASBizException {
        BillImageMapCollection billImageMapCollection;
        boolean IsPaperParkIntegration01;
        SelectorItemCollection sic;
        if (disAuditOption != null && disAuditOption.length() > 600) {
            throw new BizCollException(BizCollException.DISAUDITOPTION_TOO_LG);
        }
        ObjectUuidPK objectPk = new ObjectUuidPK(billId);
        BOSUuid bosId = BOSUuid.read((String)billId);
        BOSObjectType bosType = bosId.getType();
        String table = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType).getTable().getName();
        String sqlLock = "UPDATE " + table + " SET FID = FID WHERE FID =?";
        DbUtil.execute((Context)ctx, (String)sqlLock, (Object[])new String[]{billId});
        IBizCollBillBase bizCtrl = (IBizCollBillBase)this.getEntityBizInterface(ctx, bosType);
        SelectorItemCollection selector = BizCollUtil.getReverseSourceBillSic();
        SelectorItemCollection selectorForTm = InvoiceUtil.getSelectorForTm();
        selector.addObjectCollection((IObjectCollection)selectorForTm);
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)bizCtrl.getValue((IObjectPK)objectPk, selector);
        StateEnum billState = billInfo.getState();
        if (billState.getValue() > 60) {
            throw new BizCollException(BizCollException.CANNOTANTIAUDIT);
        }
        if (billInfo instanceof BizAccountOutBillInfo) {
            AbstractObjectCollection acAdjustEntries = (AbstractObjectCollection)billInfo.get("acAdjustEntries");
            HashMap temMap = new HashMap();
            for (AccountAdjustEntryCoreBaseInfo adEntryInfo : acAdjustEntries) {
                if (adEntryInfo.getAdjustState() == AdjustStateEnum.CHECKED) continue;
                throw new BizCollException(BizCollException.ADJUST_ANTI_AUDIT);
            }
            billInfo.put("adjustState", (Object)AdjustStateEnum.DEFAULT);
            billInfo.put("disAuditAdjustOption", "");
            billInfo.put("disAuditAdjustPerson", null);
        }
        boolean hasWorkflow = this.hasWorkFlow(ctx, billId);
        if (billState.getValue() != 60) {
            if (!hasWorkflow) {
                throw new BizCollException(BizCollException.HASNOWORKFLOW);
            }
            IExpenseAccountFacade facade = ExpenseAccountFacadeFactory.getLocalInstance(ctx);
            facade.setAuditInfoNull(bosId);
            bizCtrl.antiAudit(bosId);
            facade.setChenckingDisAudit(BOSUuid.read((String)billId), disAuditOption);
            IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, bosId);
            iBizCollBillBase.ngisc_reverse((IObjectPK)new ObjectUuidPK(billId), billInfo);
            IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"_disAuditAddMessage", (BOSObjectType)billInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(billInfo.getId()), (String)("\u6d41\u7a0b\u4e2d\u53cd\u5ba1\u6838 \u5355\u636e\u7f16\u7801=" + billInfo.getNumber() + ",\u5355\u636e\u72b6\u6001=" + (Object)((Object)billState)));
            LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
            return true;
        }
        if (hasWorkflow) {
            throw new BizCollException(BizCollException.HASWORKFLOW);
        }
        String bosTypeStr = bosType.toString();
        if (this.checkBillHasNextBill(ctx, billInfo)) {
            throw new BizCollException(BizCollException.HASNEXTBILLCANNOTDISAUDIT);
        }
        boolean isTicketAndTm = false;
        if (BizInvoicePoolUtil.getCpbcParams(ctx, billInfo.getId().toString())) {
            BizInvoicePoolUtil.deleteInvoicePool(ctx, billInfo.getId());
            isTicketAndTm = true;
        }
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP001");
        paramList.add("CP002");
        paramList.add("CP008");
        paramList.add("CP029");
        paramList.add("CP030");
        paramList.add("CP024");
        paramList.add("CP051");
        paramList.add("IsPaperParkIntegration");
        paramList.add("IsPaperParkIntegration01");
        Map params = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, billInfo.getApplierCompany().getId().toString());
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        IExpenseCommenFacade expenseCtrl = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
        expenseCtrl.returnBudget(bosId, billInfo, false);
        new BillReverse().doReverseAmountBalance(ctx, billInfo, "returnBudget");
        params.put("isTicketAndTm", isTicketAndTm);
        if ("8110AAB2".equals(bosTypeStr)) {
            BizCollUtil.setBillStateOptionReverse(billInfo, StateEnum.DRAFT, disAuditOption, user);
            sic = BizCollUtil.getBillCloseSic();
            sic.add(new SelectorItemInfo("amountNotPaid"));
            sic.add(new SelectorItemInfo("amountPaid"));
            sic.add(new SelectorItemInfo("disAuditPerson"));
            sic.add(new SelectorItemInfo("disAuditOption"));
            sic.add(new SelectorItemInfo("auditor"));
            sic.add(new SelectorItemInfo("auditDate"));
            sic.add(new SelectorItemInfo("isCallBackPayPlan"));
            bizCtrl.updatePartial((CoreBaseInfo)billInfo, sic);
            if (BizCollUtil.hasCheckEntry(billInfo)) {
                CommonUtilFacadeFactory.getLocalInstance(ctx).reverseSourceBillState(billInfo, false, params);
            }
        } else if ("E76173AD".equals(bosTypeStr)) {
            BizCollUtil.setBillStateOptionReverse(billInfo, StateEnum.DRAFT, disAuditOption, user);
            sic = BizCollUtil.getBillCloseSic();
            sic.add(new SelectorItemInfo("disAuditPerson"));
            sic.add(new SelectorItemInfo("disAuditOption"));
            sic.add(new SelectorItemInfo("auditor"));
            sic.add(new SelectorItemInfo("auditDate"));
            bizCtrl.updatePartial((CoreBaseInfo)billInfo, sic);
        } else if ("4A44F49F".equals(bosTypeStr)) {
            BizCollUtil.setBillStateOptionReverse(billInfo, StateEnum.DRAFT, disAuditOption, user);
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("state"));
            sic.add(new SelectorItemInfo("amountNotPaid"));
            sic.add(new SelectorItemInfo("amountPaid"));
            sic.add(new SelectorItemInfo("disAuditPerson"));
            sic.add(new SelectorItemInfo("disAuditOption"));
            sic.add(new SelectorItemInfo("auditor"));
            sic.add(new SelectorItemInfo("auditDate"));
            sic.add(new SelectorItemInfo("isCallBackPayPlan"));
            bizCtrl.updatePartial((CoreBaseInfo)billInfo, sic);
            if (InvoiceUtil.getTicketinVoice(ctx, billInfo.getId().toString())) {
                logger.error((Object)"#############################cpbc  CommonWebUtilFacadeControllerBean _disAuditAddMessage  start##############################");
                InvoiceUtil.updateInvoiceStateReturnString(ctx, billInfo, 1, params);
                logger.error((Object)"#############################cpbc  CommonWebUtilFacadeControllerBean _disAuditAddMessage  end##############################");
            }
            if (BizCollUtil.hasCheckEntry(billInfo)) {
                CommonUtilFacadeFactory.getLocalInstance(ctx).reverseSourceBillState(billInfo, false, params);
            }
        } else if ("DE853384".equals(bosTypeStr)) {
            BizCollUtil.setBillStateOptionReverse(billInfo, StateEnum.DRAFT, disAuditOption, user);
            sic = BizCollUtil.getBillCloseSic();
            sic.add(new SelectorItemInfo("disAuditPerson"));
            sic.add(new SelectorItemInfo("disAuditOption"));
            sic.add(new SelectorItemInfo("auditor"));
            sic.add(new SelectorItemInfo("auditDate"));
            bizCtrl.updatePartial((CoreBaseInfo)billInfo, sic);
        } else if ("7AE53B38".equals(bosTypeStr)) {
            BizCollUtil.setBillStateOptionReverse(billInfo, StateEnum.DRAFT, disAuditOption, user);
            sic = BizCollUtil.getBillCloseSic();
            sic.add(new SelectorItemInfo("amountNotPaid"));
            sic.add(new SelectorItemInfo("amountPaid"));
            sic.add(new SelectorItemInfo("disAuditPerson"));
            sic.add(new SelectorItemInfo("disAuditOption"));
            sic.add(new SelectorItemInfo("auditor"));
            sic.add(new SelectorItemInfo("auditDate"));
            sic.add(new SelectorItemInfo("isCallBackPayPlan"));
            bizCtrl.updatePartial((CoreBaseInfo)billInfo, sic);
            if (BizCollUtil.hasCheckEntry(billInfo)) {
                CommonUtilFacadeFactory.getLocalInstance(ctx).reverseSourceBillState(billInfo, false, params);
            }
        } else if ("C57003BC".equals(bosTypeStr)) {
            BizCollUtil.setBillStateOptionReverse(billInfo, StateEnum.DRAFT, disAuditOption, user);
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("state"));
            sic.add(new SelectorItemInfo("amountNotPaid"));
            sic.add(new SelectorItemInfo("amountPaid"));
            sic.add(new SelectorItemInfo("disAuditPerson"));
            sic.add(new SelectorItemInfo("disAuditOption"));
            sic.add(new SelectorItemInfo("auditor"));
            sic.add(new SelectorItemInfo("auditDate"));
            sic.add(new SelectorItemInfo("isCallBackPayPlan"));
            bizCtrl.updatePartial((CoreBaseInfo)billInfo, sic);
            if (InvoiceUtil.getTicketinVoice(ctx, billInfo.getId().toString())) {
                logger.error((Object)"#############################cpbc  CommonWebUtilFacadeControllerBean _disAuditAddMessage  start##############################");
                InvoiceUtil.updateInvoiceStateReturnString(ctx, billInfo, 1, params);
                logger.error((Object)"#############################cpbc  CommonWebUtilFacadeControllerBean _disAuditAddMessage  end##############################");
            }
            if (BizCollUtil.hasCheckEntry(billInfo)) {
                CommonUtilFacadeFactory.getLocalInstance(ctx).reverseSourceBillState(billInfo, false, params);
            }
        } else if ("30BD2798".equals(bosTypeStr)) {
            BizCollUtil.setBillStateOptionReverse(billInfo, StateEnum.DRAFT, disAuditOption, user);
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("state"));
            sic.add(new SelectorItemInfo("amountNotPaid"));
            sic.add(new SelectorItemInfo("amountPaid"));
            sic.add(new SelectorItemInfo("disAuditPerson"));
            sic.add(new SelectorItemInfo("disAuditOption"));
            sic.add(new SelectorItemInfo("auditor"));
            sic.add(new SelectorItemInfo("auditDate"));
            sic.add(new SelectorItemInfo("isCallBackPayPlan"));
            bizCtrl.updatePartial((CoreBaseInfo)billInfo, sic);
            if (InvoiceUtil.getTicketinVoice(ctx, billInfo.getId().toString())) {
                logger.error((Object)"#############################cpbc  CommonWebUtilFacadeControllerBean _disAuditAddMessage  start##############################");
                InvoiceUtil.updateInvoiceStateReturnString(ctx, billInfo, 1, params);
                logger.error((Object)"#############################cpbc  CommonWebUtilFacadeControllerBean _disAuditAddMessage  end##############################");
            }
            if (BizCollUtil.hasCheckEntry(billInfo)) {
                CommonUtilFacadeFactory.getLocalInstance(ctx).reverseSourceBillState(billInfo, false, params);
            }
        } else if ("92F938DD".equals(bosTypeStr)) {
            BizCollUtil.setBillStateOptionReverse(billInfo, StateEnum.DRAFT, disAuditOption, user);
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("state"));
            sic.add(new SelectorItemInfo("amountNotPaid"));
            sic.add(new SelectorItemInfo("amountPaid"));
            sic.add(new SelectorItemInfo("disAuditPerson"));
            sic.add(new SelectorItemInfo("disAuditOption"));
            sic.add(new SelectorItemInfo("auditor"));
            sic.add(new SelectorItemInfo("auditDate"));
            sic.add(new SelectorItemInfo("isCallBackPayPlan"));
            sic.add(new SelectorItemInfo("adjustState"));
            sic.add(new SelectorItemInfo("disAuditAdjustOption"));
            sic.add(new SelectorItemInfo("disAuditAdjustPerson"));
            bizCtrl.updatePartial((CoreBaseInfo)billInfo, sic);
            if (InvoiceUtil.getTicketinVoice(ctx, billInfo.getId().toString())) {
                logger.error((Object)"#############################cpbc  CommonWebUtilFacadeControllerBean _disAuditAddMessage  start##############################");
                InvoiceUtil.updateInvoiceStateReturnString(ctx, billInfo, 1, params);
                logger.error((Object)"#############################cpbc  CommonWebUtilFacadeControllerBean _disAuditAddMessage  end##############################");
            }
            if (BizCollUtil.hasCheckEntry(billInfo)) {
                CommonUtilFacadeFactory.getLocalInstance(ctx).reverseSourceBillState(billInfo, false, params);
            }
            this.deleteAdjustEntry(ctx, billInfo);
        }
        ReverseUtil.reverseEvectionReqBillState(ctx, billId);
        IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, bosId);
        iBizCollBillBase.ngisc_reverse((IObjectPK)new ObjectUuidPK(billId), billInfo);
        boolean IsPaperParkIntegration = params.get("IsPaperParkIntegration") == null ? false : new Boolean(params.get("IsPaperParkIntegration").toString());
        boolean bl = IsPaperParkIntegration01 = params.get("IsPaperParkIntegration01") == null ? false : new Boolean(params.get("IsPaperParkIntegration01").toString());
        if (IsPaperParkIntegration && IsPaperParkIntegration01 && (billImageMapCollection = BillImageMapFactory.getLocalInstance((Context)ctx).getBillImageMapCollection("select imageNumber, imageState, sscUnit where billID = '" + billId + "'")).size() != 0 && !billImageMapCollection.get(0).getImageState().equals((Object)ImageStateEnum.NO_IMAGE)) {
            BillImageFacadeFactory.getLocalInstance((Context)ctx).imageRescan(BOSUuid.read((String)billId), ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString(), EASResource.getString((String)this.commonUtilResource, (String)"bill_is_disAudited"));
        }
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"_disAuditAddMessage", (BOSObjectType)bosType, (IObjectPK)objectPk, (String)("\u5355\u636e\u53cd\u5ba1\u6838 \u5355\u636e\u7f16\u7801=" + billInfo.getNumber() + ",\u5355\u636e\u72b6\u6001=" + (Object)((Object)billState)));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteAdjustEntry(Context ctx, BizCollBillBaseInfo billInfo) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement stmt = null;
        conn = this.getConnection(ctx);
        String sql = "delete from T_BC_BizOutBillAcAdjustEntry where FBillID = ?";
        String billId = billInfo.getId().toString();
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, billId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"deleteAdjustEntry", (BOSObjectType)billInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(billId), (String)"\u5355\u636e\u53cd\u5ba1\u6838\u5220\u9664\u6536\u6b3e\u8c03\u6574\u5206\u5f55");
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
    }

    @Override
    protected boolean _antiauditAddMessage(Context ctx, String billId, String disAuditPersonId, String disAuditOption) throws BOSException, EASBizException {
        BillImageMapCollection billImageMapCollection;
        boolean IsPaperParkIntegration01;
        if (disAuditOption != null && disAuditOption.length() > 600) {
            throw new BizCollException(BizCollException.DISAUDITOPTION_TOO_LG);
        }
        ObjectUuidPK objectPk = new ObjectUuidPK(billId);
        BOSUuid bosId = BOSUuid.read((String)billId);
        BOSObjectType bosType = bosId.getType();
        IRePaymentBill rePayCtrl = (IRePaymentBill)this.getEntityBizInterface(ctx, bosType);
        RePaymentBillInfo billInfo = (RePaymentBillInfo)rePayCtrl.getValue((IObjectPK)objectPk, this.getRepaySelector());
        String srcBillId = null;
        boolean srcIsClosed = false;
        if (!BizCollUtil.objectIsNull(billInfo.getSourceBillId())) {
            srcBillId = billInfo.getSourceBillId().toString();
            srcIsClosed = this.checkSourceIsClose(ctx, srcBillId);
        }
        if (srcIsClosed) {
            throw new BizCollException(BizCollException.SOURCEBILLISCLOSED);
        }
        if (BizCollUtil.checkRePayBillHasNextBill(ctx, bosId)) {
            throw new BizCollException(BizCollException.HASNEXTBILLCANNOTDISAUDIT);
        }
        RePaymentFacadeFactory.getLocalInstance(ctx).setAntiAudit(bosId, null);
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        billInfo.setDisAuditOption(disAuditOption);
        billInfo.setDisAuditPerson(user);
        billInfo.setAuditDate(null);
        billInfo.setAuditor(null);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("disAuditPerson"));
        sic.add(new SelectorItemInfo("disAuditOption"));
        sic.add(new SelectorItemInfo("auditor"));
        sic.add(new SelectorItemInfo("auditDate"));
        rePayCtrl.updatePartial((CoreBaseInfo)billInfo, sic);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("IsPaperParkIntegration");
        paramList.add("IsPaperParkIntegration01");
        Map params = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, billInfo.getApplierCompany().getId().toString());
        boolean IsPaperParkIntegration = params.get("IsPaperParkIntegration") == null ? false : new Boolean(params.get("IsPaperParkIntegration").toString());
        boolean bl = IsPaperParkIntegration01 = params.get("IsPaperParkIntegration01") == null ? false : new Boolean(params.get("IsPaperParkIntegration01").toString());
        if (IsPaperParkIntegration && IsPaperParkIntegration01 && (billImageMapCollection = BillImageMapFactory.getLocalInstance((Context)ctx).getBillImageMapCollection("select imageNumber, imageState, sscUnit where billID = '" + billId + "'")).size() != 0 && !billImageMapCollection.get(0).getImageState().equals((Object)ImageStateEnum.NO_IMAGE) && billInfo.getState().getValue() == 60) {
            BillImageFacadeFactory.getLocalInstance((Context)ctx).imageRescan(BOSUuid.read((String)billId), ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString(), EASResource.getString((String)this.commonUtilResource, (String)"bill_is_disAudited"));
        }
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"_antiauditAddMessage", (BOSObjectType)bosType, (IObjectPK)objectPk, (String)("\u8fd8\u6b3e\u5355\u53cd\u5ba1\u6838 \u5355\u636e\u7f16\u7801=" + billInfo.getNumber() + ",\u5355\u636e\u72b6\u6001=" + (Object)((Object)billInfo.getState())));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        return true;
    }

    @Override
    protected Map _getParamAndState(Context ctx, List billIds, boolean isWithParam) throws BOSException, EASBizException {
        HashMap returnMap = new HashMap();
        if (billIds == null || billIds.isEmpty()) {
            return returnMap;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection selector = ev.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("state"));
        selector.add(new SelectorItemInfo("applierCompany.id"));
        ev.setSelector(selector);
        HashSet idset = new HashSet(billIds);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
        ev.setFilter(filterInfo);
        BOSObjectType bosType = null;
        bosType = BizCollUtil.getBOSType((String)billIds.get(0));
        IObjectCollection collection = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(bosType, ev);
        ArrayList<String> companyIds = new ArrayList<String>();
        HashMap<String, StateEnum> numberStateMap = new HashMap<String, StateEnum>();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue billInfo = collection.getObject(i);
            String number = billInfo.getString("number");
            numberStateMap.put(number, StateEnum.getEnum(billInfo.getInt("state")));
            String applierCompanyIds = ((CompanyOrgUnitInfo)billInfo.get("applierCompany")).getId().toString();
            if (companyIds.contains(applierCompanyIds)) continue;
            companyIds.add(applierCompanyIds);
        }
        returnMap.put("numberStateMap", numberStateMap);
        if (isWithParam) {
            ArrayList<String> paramList = new ArrayList<String>();
            paramList.add("CP065");
            paramList.add("CP_BC_STATEPRINT");
            ArrayList list = ParamControlFactory.getLocalInstance((Context)ctx).getParamListPatch(paramList, companyIds);
            HashMap<String, HashMap> paraMap = new HashMap<String, HashMap>();
            for (int i = 0; i < list.size(); ++i) {
                ParamSimpleInfo paramSimpleInfo = (ParamSimpleInfo)list.get(i);
                String companyId = paramSimpleInfo.getOrgUnitPK().toString();
                HashMap hashMap = null;
                hashMap = paraMap.containsKey(companyId) ? (HashMap)paraMap.get(companyId) : new HashMap();
                String paramNumber = paramSimpleInfo.getParamNumber();
                String paramValue = paramSimpleInfo.getParamValue();
                if (paramNumber.equals("CP065")) {
                    hashMap.put(paramNumber, paramValue == null ? false : new Boolean(paramValue.toString()));
                } else {
                    hashMap.put(paramNumber, paramValue);
                }
                paraMap.put(companyId, hashMap);
            }
            returnMap.put("paraMap", paraMap);
        }
        return returnMap;
    }
}

