/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollBillTypeEnum;
import com.kingdee.eas.cp.bc.BizCollCoreBillBaseInfo;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.LoanTypeEnum;
import com.kingdee.eas.cp.bc.PriorEnum;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.AbstractDailyLoanBillEditUIHandler;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class DailyLoanBillEditUIHandler
extends AbstractDailyLoanBillEditUIHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.DailyLoanBillEditUIHandler");

    @Override
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
    }

    @Override
    protected void loadFields(RequestContext request, ResponseContext response, Context context) throws Exception {
        BizCollBillBaseInfo info;
        super.loadFields(request, response, context);
        if (request.getState() != null && (OprtState.ADDNEW.equals(request.getState()) || OprtState.EDIT.equals(request.getState())) && (info = (BizCollBillBaseInfo)request.getValue()) != null && info.getSourceBillId() != null) {
            ObjectUuidPK objpk = new ObjectUuidPK(info.getSourceBillId());
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)context);
            BizCollCoreBillBaseInfo bizCollCoreBillBaseInfo = (BizCollCoreBillBaseInfo)iDynamicObject.getValue(objpk.getObjectType(), (IObjectPK)objpk, this.getAmountControlTypeSelector());
        }
    }

    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSubmit(request, response, context);
    }

    @Override
    protected void _handleActionViewBudgetBalance(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionViewBudgetBalance(request, response, context);
        BizCollBillBaseInfo info = (BizCollBillBaseInfo)request.get("info");
    }

    @Override
    protected void _handleActionViewRrcdsOfLendAndRepay(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected IObjectValue createNewData(RequestContext request, ResponseContext response, Context context) throws Exception {
        DailyLoanBillInfo info = new DailyLoanBillInfo();
        try {
            BizCollBillBaseInfo baseInfo = CommonUtilFacadeFactory.getLocalInstance(context).forLoanBillCreateNewData();
            info.setCurrencyType(baseInfo.getCurrencyType());
            if (StringUtils.isEmpty((String)info.getName())) {
                info.setName(BizCollBillTypeEnum.DAILY_LOAN.toString());
            }
            info.setState(StateEnum.NEW);
            if (info.getBillTypeCode() == null) {
                info.setBillTypeCode(BizCollBillTypeEnum.DAILY_LOAN);
            }
            info.setPrior(PriorEnum.LOW);
            info.setLoanType(LoanTypeEnum.DAILY_PURCHASE);
            info.setPayMode(((DailyLoanBillInfo)baseInfo).getPayMode());
            Date now = new Date();
            info.setBizReqDate(DateTimeUtils.truncateDate((Date)now));
            info.setBiller(ContextUtil.getCurrentUserInfo((Context)context));
            info.setBillDate(DateTimeUtils.truncateDate((Date)now));
            info.setAmount(new BigDecimal("0.0"));
            info.setApplier(baseInfo.getApplier());
            info.setPosition(baseInfo.getPosition());
            info.setOrgUnit(baseInfo.getOrgUnit());
            info.setApplierCompany(baseInfo.getApplierCompany());
            info.setCostedDept(baseInfo.getCostedDept());
            info.setCompany(baseInfo.getCompany());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return info;
    }

    @Override
    public void handleInitUIData(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.handleInitUIData(request, response, context);
    }

    private SelectorItemCollection getAmountControlTypeSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("amountControlType"));
        return sic;
    }
}

