/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.DailyLoanBillException;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillEntryInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillLoanCheckEntryCollection;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseReqException;
import com.kingdee.eas.cp.bc.app.AbstractDailyPurchaseAccountBillControllerBean;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class DailyPurchaseAccountBillControllerBean
extends AbstractDailyPurchaseAccountBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.DailyPurchaseAccountBillControllerBean");

    @Override
    protected void checkEntry(ExpenseAccountBillInfo model) throws BOSException, EASBizException {
        DailyPurchaseAccountBillInfo info = (DailyPurchaseAccountBillInfo)model;
        DailyPurchaseAccountBillEntryInfo entry = null;
        for (int i = info.getEntries().size() - 1; i > -1; --i) {
            entry = info.getEntries().get(i);
            if (entry.getHappenTime() == null) {
                throw new ExpAccException(ExpAccException.PURDATA_NOT_NULL);
            }
            if (!StringUtils.isEmpty((String)entry.getComment()) && entry.getComment().length() > 200) {
                throw new ExpAccException(ExpAccException.MEMO_TOO_LONG);
            }
            if (entry.getCostCenter() == null) {
                throw new ExpAccException(ExpAccException.ENTRY_COSTCENTER_NOT_NULL);
            }
            if (entry.getCompany() != null) continue;
            throw new ExpAccException(ExpAccException.ENTRY_COMPANY_NOT_NULL);
        }
    }

    @Override
    protected void checkSaveEntry(ExpenseAccountBillInfo model) throws BOSException, EASBizException {
        super.checkSaveEntry(model);
        DailyPurchaseAccountBillInfo info = (DailyPurchaseAccountBillInfo)model;
        DailyPurchaseAccountBillEntryInfo entry = null;
        for (int i = info.getEntries().size() - 1; i > -1; --i) {
            entry = info.getEntries().get(i);
            if (!StringUtils.isEmpty((String)entry.getName()) && entry.getName().length() > 80) {
                throw new ExpAccException(ExpAccException.MAT_TOO_LONG);
            }
            if (StringUtils.isEmpty((String)entry.getComment()) || entry.getComment().length() <= 200) continue;
            throw new ExpAccException(ExpAccException.MEMO_TOO_LONG);
        }
    }

    @Override
    protected void checkBillValidate(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.checkBillValidate(ctx, model);
        DailyPurchaseAccountBillInfo info = (DailyPurchaseAccountBillInfo)model;
        String sourceId = info.getSourceBillId();
        DailyPurchaseAccountBillEntryInfo entry = null;
        if (info.getApplierCompany() == null) {
            throw new ExpAccException(ExpAccException.A_COMPANY_NOTNULL);
        }
        if (info.getNumber() == null) {
            throw new ExpAccException(DailyLoanBillException.NUMBER_NOT_NULL);
        }
        if (info.getPrior() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_PRIOR_EXCEPTION);
        }
        if (info.getCurrencyType() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_CURRENCY_EXCEPTION);
        }
        if (info.getBizReqDate() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_REQDATE_EXCEPTION);
        }
        if (info.getApplier() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_APLLIER_EXCEPTION);
        }
        if (info.getOrgUnit() == null) {
            throw new ExpenseReqException(ExpenseReqException.NULL_REQDEPT_EXCEPTION);
        }
        for (int i = info.getEntries().size() - 1; i > -1; --i) {
            entry = info.getEntries().get(i);
            if (entry.getHappenTime() == null) {
                throw new ExpAccException(ExpAccException.PURDATA_NOT_NULL);
            }
            if (entry.getCurrencyType() == null) {
                throw new ExpAccException(ExpAccException.CUR_NOT_NULL);
            }
            if (!StringUtils.isEmpty((String)entry.getComment()) && entry.getComment().length() > 200) {
                throw new ExpAccException(ExpAccException.MEMO_TOO_LONG);
            }
            if (entry.getCostCenter() == null) {
                throw new ExpAccException(ExpAccException.ENTRY_COMPANY_NOT_NULL);
            }
            if (entry.getCompany() == null) {
                throw new ExpAccException(ExpAccException.ENTRY_COMPANY_NOT_NULL);
            }
            if (entry.getExpenseType() == null) {
                throw new ExpAccException(ExpAccException.EXPENSE_TYPE_NOT_NULL);
            }
            if (sourceId != null) {
                if (entry.getAmount() == null) {
                    throw new ExpAccException(ExpAccException.AMOUNTNOTLESSTHENZERO);
                }
            } else if (entry.getAmount() == null) {
                throw new ExpenseReqException(ExpenseReqException.NULL_ENTRYAMOUNT_EXCEPTION);
            }
            if (BizCollUtil.bigDecimalObjectLessThan(entry.getAmountApproved(), entry.getAmount())) continue;
            throw new BizCollException(BizCollException.CHECKAMOUNT_LESS_APPROVEDAMOUNT, new Object[]{i + 1, entry.getAmountApproved(), entry.getAmount()});
        }
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DailyPurchaseAccountBillInfo info = (DailyPurchaseAccountBillInfo)model;
        DailyPurchaseAccountBillLoanCheckEntryCollection loanCheckEntries = info.getLoanCheckEntries();
        if (null != loanCheckEntries && loanCheckEntries.size() > 0) {
            info.setIsRelevanceLoan(true);
        } else {
            info.setIsRelevanceLoan(false);
        }
        this.savaAccesoryCount(ctx, info);
        return super._save(ctx, (IObjectValue)info);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DailyPurchaseAccountBillInfo info = (DailyPurchaseAccountBillInfo)model;
        DailyPurchaseAccountBillLoanCheckEntryCollection loanCheckEntries = info.getLoanCheckEntries();
        if (null != loanCheckEntries && loanCheckEntries.size() > 0) {
            info.setIsRelevanceLoan(true);
        } else {
            info.setIsRelevanceLoan(false);
        }
        this.savaAccesoryCount(ctx, info);
        IObjectPK retValue = super._submit(ctx, model);
        return retValue;
    }

    @Override
    protected String getPermItemName() {
        return "cp_bc_DailyAccount_Update";
    }
}

