/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.BudgetControlException;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionReqBillFactory;
import com.kingdee.eas.cp.bc.EvectionReqBillInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.OtherExpenseBillFactory;
import com.kingdee.eas.cp.bc.OtherExpenseBillInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillFactory;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.app.AbstractFetchDataFacadeControllerBean;
import com.kingdee.eas.cp.bc.app.CreateTimeComparetor;
import com.kingdee.eas.cp.bc.ng.ConfigUtil;
import com.kingdee.eas.cp.bc.ng.HttpServiceHelper;
import com.kingdee.eas.cp.bc.ng.ISCHelper;
import com.kingdee.eas.cp.bc.util.NBgControlCallerUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class FetchDataFacadeControllerBean
extends AbstractFetchDataFacadeControllerBean {
    private static final long serialVersionUID = -2759757811828052828L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.FetchDataFacadeControllerBean");
    private static BgControlCaller caller = new BgControlCaller();

    @Override
    protected String _fetchDataToJson(Context ctx, String bostype, String oql) throws BOSException {
        return null;
    }

    @Override
    protected String _syncAttachment(Context ctx, String reqJson) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String _getServerTime(Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String _fetchBillDataToJson(Context ctx, String bostype, String oql) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String _getCurrentPerson(Context ctx, String[] ids) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String _syncData4ng(Context ctx, String methodName, String datajson) throws BOSException, EASBizException {
        String traceid = Uuid.randomUUID().toString();
        logger.info((Object)String.format("methodName:[%s],dataJson:[%s],traceid:[%s]", methodName, datajson, traceid));
        try {
            Method method = this.getClass().getDeclaredMethod(methodName, Context.class, String.class);
            String ret = (String)method.invoke((Object)this, ctx, datajson);
            logger.info((Object)String.format("[%s]\u5904\u7406\u6210\u529f,ret:[%s]", traceid, ret));
            return ret;
        }
        catch (Exception e) {
            StringWriter errorsWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(errorsWriter));
            logger.error((Object)String.format("[%s]\u5904\u7406\u5931\u8d25,errorsWriter:[%s]", traceid, errorsWriter), (Throwable)e);
            throw new BOSException(errorsWriter.toString(), (Throwable)e);
        }
    }

    protected String doWfPost(Context ctx, String ngBillId) throws Exception {
        Map<String, String> loginInfo = ISCHelper.getLoginInfo(ctx.getAIS());
        String server_url = loginInfo.get("ierp_server_url");
        if (!server_url.endsWith("/")) {
            server_url = server_url.concat("/");
        }
        String wfRecordURL = server_url.concat("kapi/app/wf/getAllApprovalRecord");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("api", "true");
        String token = ISCHelper.getAccessToken(loginInfo);
        headerMap.put("access_token", token);
        JSONObject ngIdJson = new JSONObject();
        ngIdJson.put("businessKey", (Object)ngBillId);
        String bodyStr = ngIdJson.toJSONString();
        logger.error((Object)String.format("\u5f00\u59cb\u67e5\u8be2\u82cd\u7a79\u5de5\u4f5c\u6d41\u5ba1\u6838\u8bb0\u5f55, \u53c2\u6570 url:%s, header:%s, body:%s", wfRecordURL, headerMap, bodyStr));
        JSONObject resultObj = HttpServiceHelper.doPost(wfRecordURL, headerMap, bodyStr, JSONObject.class);
        logger.error((Object)("\u7ed3\u675f\u67e5\u8be2\u82cd\u7a79\u5de5\u4f5c\u6d41\u5ba1\u6838\u8bb0\u5f55 response:" + resultObj));
        if (!((Boolean)resultObj.get((Object)"success")).booleanValue()) {
            throw new Exception("\u67e5\u8be2\u82cd\u7a79\u5de5\u4f5c\u6d41\u5ba1\u6838\u8bb0\u5f55\u51fa\u9519, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5!");
        }
        return resultObj.toJSONString();
    }

    protected String inEASProcess(Context ctx, String easId) throws Exception {
        String ret = null;
        if (ConfigUtil.enableISC().booleanValue()) {
            ret = this.inprocess(ctx, easId) ? Boolean.TRUE.toString() : ISCHelper.getNgId(ctx, easId);
        }
        return ret;
    }

    private boolean inprocess(Context ctx, String easId) throws BOSException, SQLException {
        String sql = "select FPROCINSTID from t_wfr_procinstref where  ftype = 1 and frefid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{easId});
        return rs.next();
    }

    protected String getEASApprove(Context ctx, String datajson) throws BOSException, EASBizException {
        HashMap map = JSONUtils.convertJsonToObject((Context)ctx, (String)datajson);
        Object number = map.get("number");
        Object bostype = map.get("bostype");
        if (number == null || bostype == null) {
            throw new BOSException("number,bostype is null!");
        }
        IObjectValue value = null;
        try {
            value = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(BOSObjectType.create((String)bostype.toString()), String.format("select id where number = '%s'", number));
        }
        catch (ObjectNotFoundException e) {
            e.printStackTrace();
        }
        if (value != null) {
            String billId = value.getString("id");
            return this._getApprove(ctx, billId);
        }
        return null;
    }

    @Override
    protected String _getApprove(Context ctx, String billId) throws BOSException, EASBizException {
        WfUtil ut = new WfUtil(ctx);
        long before = System.currentTimeMillis();
        String procInstID = ut.getProcInstId(billId);
        long after = System.currentTimeMillis();
        logger.error((Object)("\u83b7\u53d6eas\u6d41\u7a0b\u5b9e\u4f8b\u65f6\u95f4\u82b1\u8d39\uff1a" + (after - before) + ",billId=" + billId + ",procInstID=" + procInstID));
        if (!StringUtils.isEmpty((String)procInstID)) {
            String str = this.getApprove(ctx, billId, procInstID);
            logger.error((Object)("\u83b7\u5f97eas\u5ba1\u6279\u8be6\u60c5\u603b\u82b1\u8d39\uff1a" + (System.currentTimeMillis() - before) + ",billId=" + billId + ",approve=" + str));
            return str;
        }
        return null;
    }

    private String getApprove(Context ctx, String billId, String procInstId) throws EASBizException, BOSException {
        JSONObject approve;
        if (billId == null || procInstId == null) {
            return "param is null !";
        }
        if (billId.equals("") || procInstId.equals("")) {
            return "param is empty !";
        }
        TreeSet<JSONObject> set = new TreeSet<JSONObject>(new CreateTimeComparetor());
        StringBuffer select = new StringBuffer();
        select.append("SELECT  PERSON.FNAME_L2 AS PERSONNAME,PERSON.FID AS PERSONID,A.FCREATEDTIME,POSITION.FNAME_L2 AS POSITIONNAME ");
        select.append("FROM T_WFR_PROCINST A ");
        select.append("INNER JOIN T_PM_USER AS CREATOR   ON A.FINITIATORID = CREATOR.FID   ");
        select.append("INNER JOIN T_BD_PERSON AS PERSON ON CREATOR.FPERSONID = PERSON.FID  ");
        select.append("LEFT OUTER JOIN T_HR_PERSONPOSITION AS PERSONPOSITION  ON PERSON.FID = PERSONPOSITION.FPERSONID   \r\n");
        select.append("LEFT OUTER JOIN T_ORG_POSITION AS POSITION  ON PERSONPOSITION.FPRIMARYPOSITIONID = POSITION.FID   \r\n");
        select.append("WHERE A.FPROCINSTID = ? \r\n");
        long before = System.currentTimeMillis();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)select.toString(), (Object[])new Object[]{procInstId});
        long after = System.currentTimeMillis();
        logger.error((Object)("\u53d6\u6d41\u7a0b\u53d1\u8d77\u4eba\u82b1\u8d39:" + (after - before)));
        try {
            while (rs.next()) {
                JSONObject approve2 = new JSONObject();
                approve2.put("type", (Object)0);
                approve2.put("createtime", (Object)rs.getDate("FCREATEDTIME"));
                approve2.put("personid", (Object)rs.getString("PERSONID"));
                approve2.put("personname", (Object)rs.getString("PERSONNAME"));
                approve2.put("positionname", (Object)rs.getString("POSITIONNAME"));
                approve2.put("aactdefname", (Object)"");
                approve2.put("personnumber", (Object)"");
                approve2.put("adminname", (Object)"");
                approve2.put("admindisplayname", (Object)"");
                set.add(approve2);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        WfUtil ut = new WfUtil(ctx);
        StringBuffer sb = new StringBuffer();
        try {
            long before2 = System.currentTimeMillis();
            String[] ids = ut.getApproveAssignIds(billId);
            long after2 = System.currentTimeMillis();
            logger.error((Object)("\u83b7\u53d6assignIds\u82b1\u8d39:" + (after2 - before2)));
            if (ids != null) {
                for (int i = 0; i < ids.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append("'").append(ids[i]).append("'");
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (sb.length() != 0) {
            select.setLength(0);
            select.append("--\u5ba1\u6279\u610f\u89c1--\r\n");
            select.append("SELECT ");
            select.append("MULTIAPPROVE.FCreateTime AS CREATETIME,PERSONID.FName_l2 AS PERSONNAME, ");
            select.append("PERSONID.FID PERSONID, MULTIAPPROVE.FOpinion_l2 AS OPINION,MULTIAPPROVE.FIsPass AS ISPASS, ");
            select.append("ASSIGNDETAIL.FACTDEFNAME_l2 AS AACTDEFNAME, ");
            select.append("POSITION.FNAME_L2 AS POSITIONNAME ");
            select.append("FROM T_BAS_MultiApprove AS MULTIAPPROVE ");
            select.append("INNER JOIN T_PM_User AS CREATOR ON MULTIAPPROVE.FCreatorID = CREATOR.FID ");
            select.append("INNER JOIN T_BD_Person AS PERSONID  ON CREATOR.FPersonId = PERSONID.FID ");
            select.append("LEFT OUTER JOIN T_WFR_AssignDetail AS ASSIGNDETAIL ON MULTIAPPROVE.FASSIGNMENTID = ASSIGNDETAIL.FASSIGNID \r\n");
            select.append("LEFT OUTER JOIN T_HR_PERSONPOSITION AS PERSONPOSITION  ON PERSONID.FID = PERSONPOSITION.FPERSONID   \r\n");
            select.append("LEFT OUTER JOIN T_ORG_POSITION AS POSITION  ON PERSONPOSITION.FPRIMARYPOSITIONID = POSITION.FID   \r\n");
            select.append("WHERE MULTIAPPROVE.FSTATUS='1' AND MULTIAPPROVE.FBillID = ?  ");
            select.append("AND MULTIAPPROVE.FASSIGNMENTID in (").append(sb).append(")  \r\n");
            sb.setLength(sb.length() - 1);
            long before3 = System.currentTimeMillis();
            rs = DbUtil.executeQuery((Context)ctx, (String)select.toString(), (Object[])new Object[]{billId});
            long after3 = System.currentTimeMillis();
            logger.error((Object)("\u67e5\u8be2\u5df2\u5ba1\u6279\u4fe1\u606f\u82b1\u8d39:" + (after3 - before3)));
            try {
                while (rs.next()) {
                    approve = new JSONObject();
                    approve.put("type", (Object)1);
                    approve.put("personid", (Object)rs.getString("PERSONID"));
                    approve.put("personname", (Object)rs.getString("PERSONNAME"));
                    approve.put("ispass", (Object)rs.getString("ISPASS"));
                    approve.put("opinion", (Object)rs.getString("OPINION"));
                    approve.put("createtime", (Object)rs.getDate("CREATETIME"));
                    approve.put("positionname", (Object)rs.getString("POSITIONNAME"));
                    approve.put("aactdefname", (Object)rs.getString("AACTDEFNAME"));
                    approve.put("personnumber", (Object)"");
                    approve.put("adminname", (Object)"");
                    approve.put("admindisplayname", (Object)"");
                    set.add(approve);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        select.setLength(0);
        select.append("select  A.FBIZOBJID,A.FPERSONEMPID as PERSONID,A.FPERSONEMPNAME_L2 as PERSONNAME,A.FCREATEDTIME as CREATETIME,A.FACTDEFNAME_L2 as AACTDEFNAME,POSITION.FName_l2 AS POSITIONNAME ");
        select.append("from T_WFR_ASSIGNDETAIL A ");
        select.append("INNER JOIN T_BD_Person B ON A.FPERSONEMPID = B.FID ");
        select.append("LEFT OUTER JOIN T_HR_PersonPosition AS PERSONPOSITION  ON B.FID = PERSONPOSITION.FPersonID ");
        select.append("LEFT OUTER JOIN T_ORG_Position AS POSITION  ON PERSONPOSITION.FPrimaryPositionID = POSITION.FID ");
        select.append("where  A.FBIZOBJID =? and A.FSTATE = 16 and A.FBIZFUNCTION != 'MultiApproveUIFunction'");
        long before5 = System.currentTimeMillis();
        rs = DbUtil.executeQuery((Context)ctx, (String)select.toString(), (Object[])new Object[]{billId});
        long after5 = System.currentTimeMillis();
        logger.error((Object)("\u67e5\u8be2\u6838\u5b9a\u63d0\u4ea4\u8282\u70b9\u82b1\u8d39:" + (before5 - after5) + ",syn1234xxxbillinfo:" + billId));
        try {
            while (rs.next()) {
                approve = new JSONObject();
                approve.put("type", (Object)1);
                approve.put("personid", (Object)rs.getString("PERSONID"));
                approve.put("personname", (Object)rs.getString("PERSONNAME"));
                approve.put("ispass", (Object)"true");
                approve.put("opinion", (Object)"");
                approve.put("createtime", (Object)rs.getDate("CREATETIME"));
                approve.put("positionname", (Object)rs.getString("POSITIONNAME"));
                approve.put("aactdefname", (Object)rs.getString("AACTDEFNAME"));
                approve.put("personnumber", (Object)"");
                approve.put("adminname", (Object)"");
                approve.put("admindisplayname", (Object)"");
                set.add(approve);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        select.setLength(0);
        select.append("SELECT distinct PERSON.FName_l2 AS PERSONNAME,PERSON.FID PERSONID, ");
        select.append("ASS.FCREATEDTIME AS CREATETIME ,");
        select.append("POSITION.FName_l2 AS POSITIONNAME ");
        select.append("FROM T_WFR_ASSIGN AS ASS ");
        select.append("INNER JOIN T_PM_User AS CREATOR  ON ASS.FPERSONUSERID = CREATOR.FID  ");
        select.append("INNER JOIN T_BD_Person AS PERSON ON CREATOR.FPersonId = PERSON.FID ");
        select.append("LEFT OUTER JOIN T_HR_PersonPosition AS PERSONPOSITION  ON PERSON.FID = PERSONPOSITION.FPersonID     \r\n");
        select.append("LEFT OUTER JOIN T_ORG_Position AS POSITION  ON PERSONPOSITION.FPrimaryPositionID = POSITION.FID     \r\n");
        select.append("WHERE ASS.FBIZPACKAGE ='com.kingdee.eas.base.multiapprove.client' AND ASS.FSTATE in (1,2) AND ASS.FBIZOBJID = ? \r\n");
        long before4 = System.currentTimeMillis();
        rs = DbUtil.executeQuery((Context)ctx, (String)select.toString(), (Object[])new Object[]{billId});
        long after4 = System.currentTimeMillis();
        logger.error((Object)("\u67e5\u8be2\u5f53\u524d\u5ba1\u6279\u4eba\u4fe1\u606f\u82b1\u8d39:" + (after4 - before4)));
        try {
            while (rs.next()) {
                JSONObject approve3 = new JSONObject();
                approve3.put("type", (Object)2);
                approve3.put("personid", (Object)rs.getString("PERSONID"));
                approve3.put("personname", (Object)rs.getString("PERSONNAME"));
                approve3.put("createtime", (Object)rs.getDate("CREATETIME"));
                approve3.put("positionname", (Object)rs.getString("POSITIONNAME"));
                approve3.put("personnumber", (Object)"");
                approve3.put("adminname", (Object)"");
                approve3.put("admindisplayname", (Object)"");
                set.add(approve3);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        JSONArray approves = new JSONArray();
        approves.addAll(set);
        return approves.toJSONString();
    }

    private void checkEASBillBudget(Context ctx, String datajson) throws Exception {
        BizCollBillBaseInfo model = this.convertJsonToInfo(ctx, datajson);
        logger.error((Object)"\u82cd\u7a79\u5355\u636e\u6821\u9a8cEAS\u9884\u7b97start--------");
        ExpenseCommenFacadeFactory.getLocalInstance(ctx).checkBillBg_api(model, null);
        logger.error((Object)"\u82cd\u7a79\u5355\u636e\u6821\u9a8cEAS\u9884\u7b97end--------");
    }

    private String checkEASBillBudgetReturn(Context ctx, String datajson) throws Exception {
        BizCollBillBaseInfo model = this.convertJsonToInfo(ctx, datajson);
        logger.info((Object)"\u82cd\u7a79\u5355\u636e\u6821\u9a8cEAS\u9884\u7b97\u5e76\u8fd4\u56destart--------");
        String result = ExpenseCommenFacadeFactory.getLocalInstance(ctx).checkBillBg_api(model, null);
        logger.info((Object)"\u82cd\u7a79\u5355\u636e\u6821\u9a8cEAS\u9884\u7b97\u5e76\u8fd4\u56deend--------");
        return result;
    }

    private String checkEASBillBudgetAfterBgReturn(Context ctx, String datajson) throws Exception {
        BizCollBillBaseInfo model = this.convertJsonToInfo(ctx, datajson);
        logger.info((Object)"\u82cd\u7a79\u5355\u636e\u6838\u5b9a\u63d0\u4ea4\u6821\u9a8cEAS\u9884\u7b97\u5e76\u8fd4\u56destart--------");
        String result = ExpenseCommenFacadeFactory.getLocalInstance(ctx).checkBillBgAfterBg_api(model, null);
        logger.info((Object)"\u82cd\u7a79\u5355\u636e\u6838\u5b9a\u63d0\u4ea4\u6821\u9a8cEAS\u9884\u7b97\u5e76\u8fd4\u56deend--------");
        return result;
    }

    private String queryEASBillBudget(Context ctx, String datajson) throws Exception {
        BizCollBillBaseInfo model = this.convertJsonToInfo(ctx, datajson);
        logger.info((Object)("\u82cd\u7a79\u5355\u636e\u5b9e\u65f6\u67e5\u8be2EAS\u9884\u7b97start--number=" + model.getNumber()));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("isDealStandField", true);
        paramMap.put("fieldlog", "");
        NBgControlCallerUtil.handleModelForBudget(ctx, (IObjectValue)model, paramMap);
        String bgBalance = caller.queryBalanceToCQ(ctx, (IObjectValue)model, 1);
        JSONObject fieldlog = new JSONObject();
        fieldlog.put("fieldlog", paramMap.get("fieldlog"));
        if (bgBalance == null) {
            bgBalance = "";
        }
        bgBalance = bgBalance + fieldlog.toString();
        return bgBalance;
    }

    private String btnQueryEASBillBudget(Context ctx, String datajson) throws Exception {
        BizCollBillBaseInfo model = this.convertJsonToInfo(ctx, datajson);
        logger.info((Object)("\u82cd\u7a79\u5355\u636e\u6309\u94ae\u67e5\u8be2EAS\u9884\u7b97start--number=" + model.getNumber()));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("isDealStandField", true);
        paramMap.put("fieldlog", "");
        NBgControlCallerUtil.handleModelForBudget(ctx, (IObjectValue)model, paramMap);
        String bgBalance = caller.queryBalanceToCQ(ctx, (IObjectValue)model, 0);
        JSONObject fieldlog = new JSONObject();
        fieldlog.put("fieldlog", paramMap.get("fieldlog"));
        if (bgBalance == null) {
            bgBalance = "";
        }
        bgBalance = bgBalance + fieldlog.toString();
        return bgBalance;
    }

    private BizCollBillBaseInfo convertJsonToInfo(Context ctx, String datajson) throws BOSException, Exception {
        HashMap map = (HashMap)com.kingdee.bos.openapi.util.json.JSONUtils.convertJsonToObject((Context)ctx, (String)datajson, HashMap.class);
        Object billTypeName = map.get("name");
        String billTypeNameStr = "";
        if (billTypeName != null) {
            billTypeNameStr = billTypeName.toString();
        }
        logger.info((Object)String.format("\u82cd\u7a79\u5355\u636e\u6570\u636e\u8f6c\u6210info\u5bf9\u8c61,\u82cd\u7a79\u4f20\u5165\u5355\u636e\u7c7b\u578b\u4e3a:%s,\u5355\u636e\u6570\u636e\u4e3a:%s", billTypeNameStr, datajson));
        BizCollBillBaseInfo model = null;
        String billId = (String)map.get("id");
        if (!StringUtils.isEmpty((String)billId)) {
            EntityObjectInfo entityInfo;
            Object infoInstance;
            BOSUuid uuid = null;
            try {
                uuid = BOSUuid.read((String)billId);
            }
            catch (Exception e) {
                logger.error((Object)("uuid isNotValid " + e.getMessage()), (Throwable)e);
            }
            if (uuid != null && (infoInstance = Class.forName((entityInfo = BizCollUtil.getEntityObjectInfoByBOSUuid(ctx, uuid)).getObjectValueClass()).newInstance()) instanceof BizCollBillBaseInfo) {
                model = (BizCollBillBaseInfo)infoInstance;
                ICoreBase bizCtrl = BizCollUtil.getBizInterfaceByBOSUuid(ctx, uuid);
                model = (BizCollBillBaseInfo)this.fillValue(bizCtrl, (IObjectValue)model, datajson, ctx);
                logger.info((Object)(model.getNumber() + " get model by id"));
            }
        }
        if (model == null && !StringUtils.isEmpty((String)billTypeNameStr)) {
            IBizCollBillBase localInstance;
            if ("\u5dee\u65c5\u62a5\u9500\u5355".equals(billTypeNameStr) || "\u5dee\u65c5\u8d39\u62a5\u9500\u5355".equals(billTypeNameStr)) {
                localInstance = TravelAccountBillFactory.getLocalInstance(ctx);
                model = (TravelAccountBillInfo)this.fillValue((ICoreBase)localInstance, (IObjectValue)new TravelAccountBillInfo(), datajson, ctx);
            } else if ("\u51fa\u5dee\u7533\u8bf7\u5355".equals(billTypeNameStr)) {
                localInstance = EvectionReqBillFactory.getLocalInstance(ctx);
                model = (EvectionReqBillInfo)this.fillValue((ICoreBase)localInstance, (IObjectValue)new EvectionReqBillInfo(), datajson, ctx);
            } else if ("\u501f\u6b3e\u5355".equals(billTypeNameStr)) {
                localInstance = DailyLoanBillFactory.getLocalInstance(ctx);
                model = (DailyLoanBillInfo)this.fillValue((ICoreBase)localInstance, (IObjectValue)new DailyLoanBillInfo(), datajson, ctx);
            } else if ("\u51fa\u5dee\u501f\u6b3e\u5355".equals(billTypeNameStr)) {
                localInstance = EvectionLoanBillFactory.getLocalInstance(ctx);
                model = (EvectionLoanBillInfo)this.fillValue((ICoreBase)localInstance, (IObjectValue)new EvectionLoanBillInfo(), datajson, ctx);
            } else if ("\u8d39\u7528\u7533\u8bf7\u5355".equals(billTypeNameStr)) {
                localInstance = OtherExpenseBillFactory.getLocalInstance(ctx);
                model = (OtherExpenseBillInfo)this.fillValue((ICoreBase)localInstance, (IObjectValue)new OtherExpenseBillInfo(), datajson, ctx);
            } else if ("\u8d39\u7528\u62a5\u9500\u5355".equals(billTypeNameStr)) {
                localInstance = BizAccountBillFactory.getLocalInstance(ctx);
                model = (BizAccountBillInfo)this.fillValue((ICoreBase)localInstance, (IObjectValue)new BizAccountBillInfo(), datajson, ctx);
            } else if ("\u5bf9\u516c\u62a5\u9500\u5355".equals(billTypeNameStr)) {
                localInstance = BizAccountOutBillFactory.getLocalInstance(ctx);
                model = (BizAccountOutBillInfo)this.fillValue((ICoreBase)localInstance, (IObjectValue)new BizAccountOutBillInfo(), datajson, ctx);
            } else if ("\u7269\u54c1\u91c7\u8d2d\u62a5\u9500\u5355".equals(billTypeNameStr)) {
                localInstance = DailyPurchaseAccountBillFactory.getLocalInstance(ctx);
                model = (DailyPurchaseAccountBillInfo)this.fillValue((ICoreBase)localInstance, (IObjectValue)new DailyPurchaseAccountBillInfo(), datajson, ctx);
            }
        }
        if (model == null) {
            throw new BudgetControlException(BudgetControlException.NGISC_BILLISNULL, new Object[]{billId, billTypeNameStr});
        }
        String modelJson = null;
        try {
            modelJson = JSONUtils.convertObjectToJson((Context)ctx, model);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)("\u82cd\u7a79\u5355\u636e\u6570\u636e\u8f6c\u6210info\u5bf9\u8c61,\u8f6c\u6362\u540e\u7684EAS\u5b9e\u4f53\u4e3a:" + modelJson));
        return model;
    }

    private IObjectValue fillValue(ICoreBase icorebase, IObjectValue objectInfo, String datajson, Context ctx) throws Exception {
        BOSObjectType type = icorebase.getType();
        Map<String, PropertyInfo>[] properties = this.collectProperties(ctx, type);
        Map<String, PropertyInfo> entryPropMap = properties[2];
        Map<String, PropertyInfo> linkedPropMap = properties[1];
        Map<String, PropertyInfo> ownPropMap = properties[0];
        JSON json = (JSON)JSON.parse((String)datajson);
        if (json instanceof JSONObject) {
            for (String s : ((JSONObject)json).keySet()) {
                if (entryPropMap.containsKey(s.toLowerCase())) {
                    EntityObjectInfo entityObjectInfo = ((LinkPropertyInfo)entryPropMap.get(s.toLowerCase())).getRelationship().getSupplierObject();
                    IObjectCollection entries = (IObjectCollection)Class.forName(entityObjectInfo.getObjectCollectionClass()).newInstance();
                    BOSObjectType entryType = entityObjectInfo.getType();
                    JSONArray entryList = (JSONArray)((JSONObject)json).get((Object)s);
                    int entrysize = entryList.size();
                    if (entrysize == 0) {
                        objectInfo.put(s, null);
                        continue;
                    }
                    for (int i = 0; i < entrysize; ++i) {
                        IObjectValue entry = (IObjectValue)Class.forName(entityObjectInfo.getObjectValueClass()).newInstance();
                        Map<String, PropertyInfo>[] entryProperties = this.collectProperties(ctx, entryType);
                        Map<String, PropertyInfo> entryEntryPropMap = entryProperties[2];
                        Map<String, PropertyInfo> entryOwnPropMap = entryProperties[0];
                        Map<String, PropertyInfo> entryLinkedPropMap = entryProperties[1];
                        JSONObject ejson = (JSONObject)entryList.get(i);
                        for (String es : ejson.keySet()) {
                            Object value = ejson.get((Object)es);
                            if (entryLinkedPropMap.containsKey(es)) {
                                entry.put(es, (Object)this.getLinkedValue(ctx, (LinkPropertyInfo)entryLinkedPropMap.get(es), value));
                                continue;
                            }
                            if (entryOwnPropMap.containsKey(es)) {
                                entry.put(es, this.getOwnedValue(ctx, (OwnPropertyInfo)entryOwnPropMap.get(es), value));
                                continue;
                            }
                            if (entryEntryPropMap != null && entryEntryPropMap.containsKey(es.toLowerCase())) {
                                EntityObjectInfo thirdEntityObjectInfo = ((LinkPropertyInfo)entryEntryPropMap.get(es.toLowerCase())).getRelationship().getSupplierObject();
                                IObjectCollection thirdEntries = (IObjectCollection)Class.forName(thirdEntityObjectInfo.getObjectCollectionClass()).newInstance();
                                BOSObjectType thirdEntryType = thirdEntityObjectInfo.getType();
                                Object thirdEntryListObject = ejson.get((Object)es);
                                JSONArray thirdEntryList = null;
                                if (thirdEntryListObject instanceof JSONArray) {
                                    thirdEntryList = (JSONArray)thirdEntryListObject;
                                }
                                if (thirdEntryList == null) continue;
                                int thirdEntrysize = thirdEntryList.size();
                                if (thirdEntrysize == 0) {
                                    entry.put(es, null);
                                    continue;
                                }
                                for (int j = 0; j < thirdEntrysize; ++j) {
                                    IObjectValue thirdEntry = (IObjectValue)Class.forName(thirdEntityObjectInfo.getObjectValueClass()).newInstance();
                                    Map<String, PropertyInfo>[] thirdEntryProperties = this.collectProperties(ctx, thirdEntryType);
                                    Map<String, PropertyInfo> thirdEntryOwnPropMap = thirdEntryProperties[0];
                                    Map<String, PropertyInfo> thirdEntryLinkedPropMap = thirdEntryProperties[1];
                                    JSONObject eejson = (JSONObject)thirdEntryList.get(j);
                                    for (String ees : eejson.keySet()) {
                                        Object eValue = eejson.get((Object)ees);
                                        if (thirdEntryLinkedPropMap.containsKey(ees)) {
                                            thirdEntry.put(ees, (Object)this.getLinkedValue(ctx, (LinkPropertyInfo)thirdEntryLinkedPropMap.get(ees), eValue));
                                            continue;
                                        }
                                        if (thirdEntryOwnPropMap.containsKey(ees)) {
                                            thirdEntry.put(ees, this.getOwnedValue(ctx, (OwnPropertyInfo)thirdEntryOwnPropMap.get(ees), eValue));
                                            continue;
                                        }
                                        thirdEntry.put(ees, eValue);
                                    }
                                    thirdEntries.addObject(thirdEntry);
                                }
                                entry.put(es, (Object)thirdEntries);
                                continue;
                            }
                            entry.put(es, value);
                        }
                        Object entryCollection = null;
                        for (String subentry : entryEntryPropMap.keySet()) {
                            entryCollection = entry.get(subentry);
                            if (entryCollection == null || !(entryCollection instanceof JSONArray)) continue;
                            entry.put(subentry, null);
                        }
                        entries.addObject(entry);
                    }
                    objectInfo.put(s, (Object)entries);
                    continue;
                }
                Object value = ((JSONObject)json).get((Object)s);
                if (linkedPropMap.containsKey(s)) {
                    objectInfo.put(s, (Object)this.getLinkedValue(ctx, (LinkPropertyInfo)linkedPropMap.get(s), value));
                    continue;
                }
                if (ownPropMap.containsKey(s)) {
                    objectInfo.put(s, this.getOwnedValue(ctx, (OwnPropertyInfo)ownPropMap.get(s), value));
                    continue;
                }
                objectInfo.put(s, value);
            }
        }
        Object entryCollection = null;
        for (String entry : entryPropMap.keySet()) {
            entryCollection = objectInfo.get(entry);
            if (entryCollection == null || !(entryCollection instanceof JSONArray)) continue;
            objectInfo.put(entry, null);
        }
        return objectInfo;
    }

    private Object getOwnedValue(Context ctx, OwnPropertyInfo prop, Object value) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException, ClassNotFoundException {
        if (value == null) {
            return null;
        }
        if ("enum".equals(prop.getStateManager().getStateValue("dataType").toString().toLowerCase())) {
            Object realValue = null;
            try {
                realValue = Class.forName(prop.getStateManager().getStateValue("metadataRef").toString()).getField(value.toString()).get(null);
            }
            catch (NoSuchFieldException e) {
                realValue = value;
            }
            catch (Exception e) {
                logger.error((Object)String.format("\u83b7\u53d6\u679a\u4e3e\u8f6c\u6362\u503c\u5931\u8d25,\u679a\u4e3e:%s,\u679a\u4e3e\u503c\u4e3a:%s,\u5f02\u5e38\u4fe1\u606f:%s", prop.getName(), value, e.getMessage()), (Throwable)e);
                realValue = value;
            }
            return realValue;
        }
        String propName = prop.getName();
        if (DataType.DATE.equals((Object)prop.getDataType()) && value instanceof String) {
            return this.convertToDate(propName, value.toString());
        }
        if (DataType.TIMESTAMP.equals((Object)prop.getDataType()) && value instanceof String) {
            return this.convertToTimestamp(propName, value.toString());
        }
        return value;
    }

    private Date convertToDate(String propName, String time) {
        Date date = null;
        if (time == null || time.isEmpty()) {
            return date;
        }
        try {
            if (time.length() == 19) {
                date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time);
            } else if (time.length() == 16) {
                date = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(time);
            } else if (time.length() == 10) {
                date = new SimpleDateFormat("yyyy-MM-dd").parse(time);
            }
        }
        catch (ParseException e) {
            logger.error((Object)String.format("%s:\u65e5\u671f\u503c:%s\u8f6c\u6362\u5931\u8d25:%s", propName, time, e.getMessage()), (Throwable)e);
        }
        return date;
    }

    private Timestamp convertToTimestamp(String propName, String value) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        Timestamp time = null;
        try {
            Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(value);
            time = new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            logger.error((Object)String.format("%s:\u65f6\u95f4\u6233\u503c:%s\u8f6c\u6362\u5931\u8d25:%s", propName, value, e.getMessage()), (Throwable)e);
        }
        return time;
    }

    private IObjectValue getLinkedValue(Context ctx, LinkPropertyInfo linkProp, Object oLinkedId) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (BizCollUtil.objectIsNull(oLinkedId)) {
            return null;
        }
        String linkedId = oLinkedId.toString();
        EntityObjectInfo entity = linkProp.getRelationship().getSupplierObject();
        IObjectValue linkObjectInfo = (IObjectValue)Class.forName(entity.getObjectValueClass()).newInstance();
        linkObjectInfo.put("id", (Object)linkedId);
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        try {
            IObjectValue iDynamicObjectInfo = iDynamicObject.getValue(BizCollUtil.getBOSType(linkedId), "select number,longNumber,name where id='" + linkedId + "'");
            linkObjectInfo.put("number", iDynamicObjectInfo.get("number"));
            linkObjectInfo.put("longNumber", iDynamicObjectInfo.get("longNumber"));
            linkObjectInfo.put("name", iDynamicObjectInfo.get("name"));
            return linkObjectInfo;
        }
        catch (BOSException e) {
            logger.error((Object)("\u6839\u636e\u57fa\u7840\u8d44\u6599id=" + linkedId + ",\u5c01\u88c5\u57fa\u7840\u8d44\u6599\u5bf9\u8c61\u62a5\u9519: " + e.getMessage()), (Throwable)e);
        }
        catch (RuntimeException e) {
            logger.error((Object)("\u6839\u636e\u57fa\u7840\u8d44\u6599id=" + linkedId + ",\u5c01\u88c5\u57fa\u7840\u8d44\u6599\u5bf9\u8c61\u62a5\u9519: " + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private Map<String, PropertyInfo>[] collectProperties(Context ctx, BOSObjectType type) {
        Map[] ret = new Map[]{new HashMap(), new HashMap(), new HashMap()};
        PropertyCollection properties = this.getProperties(ctx, type);
        for (int i = 0; i < properties.size(); ++i) {
            PropertyInfo property = properties.get(i);
            if (property instanceof LinkPropertyInfo) {
                if (this.isEntry((LinkPropertyInfo)property)) {
                    ret[2].put(property.getName().toLowerCase(), (LinkPropertyInfo)property);
                    continue;
                }
                ret[1].put(property.getName(), (LinkPropertyInfo)property);
                continue;
            }
            ret[0].put(property.getName(), (OwnPropertyInfo)property);
        }
        return ret;
    }

    private PropertyCollection getProperties(Context ctx, BOSObjectType type) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entity = loader.getEntity(type);
        PropertyCollection properties = entity.getInheritedPropertiesRuntime();
        return properties;
    }

    private boolean isEntry(LinkPropertyInfo property) {
        RelationshipInfo relationship = property.getRelationship();
        return Boolean.TRUE.toString().equalsIgnoreCase(property.getExtendedProperty("isEntries")) || relationship != null && relationship.getClientObject() != null && RelationshipType.COMPOSITION.equals((Object)relationship.getType()) && (CardinalityType.ONE.equals((Object)relationship.getClientCardinality()) || CardinalityType.ZERO_TO_ONE.equals((Object)relationship.getClientCardinality())) && (CardinalityType.ZERO_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()) || CardinalityType.ONE_TO_UNBOUNDED.equals((Object)relationship.getSupplierCardinality()));
    }
}

