/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.FixExpenseAccountBillFactory;
import com.kingdee.eas.cp.bc.FixExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.FixExpenseAccountEntryCollection;
import com.kingdee.eas.cp.bc.app.AbstractFixExpenseAccountBillControllerBean;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class FixExpenseAccountBillControllerBean
extends AbstractFixExpenseAccountBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.FixExpenseAccountBillControllerBean");

    @Override
    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.checkNumberDup(ctx, model);
    }

    @Override
    protected void checkDelete(Context ctx, CoreBillBaseInfo info) throws BOSException, EASBizException {
        super.checkDelete(ctx, info);
    }

    @Override
    protected void checkEntry(ExpenseAccountBillInfo model) throws BOSException, EASBizException {
        FixExpenseAccountBillInfo info = (FixExpenseAccountBillInfo)model;
        FixExpenseAccountEntryCollection entries = info.getEntries();
        int size = entries.size();
        if (size < 1) {
            throw new ExpAccException(ExpAccException.ENTRY_NOT_NULL);
        }
        for (int i = 0; i < size; ++i) {
            if (entries.get(i).getAmount().compareTo(new BigDecimal("0.0")) > 0) continue;
            throw new ExpAccException(ExpAccException.AMOUNT_GT_ZERO);
        }
        super.checkEntry(model);
    }

    @Override
    protected BigDecimal getBudgetValue(Context ctx, IObjectPK pk, IObjectValue model) {
        FixExpenseAccountBillInfo newInfo = (FixExpenseAccountBillInfo)model;
        FixExpenseAccountBillInfo oldInfo = null;
        BigDecimal tempValue = null;
        try {
            oldInfo = FixExpenseAccountBillFactory.getLocalInstance(ctx).getFixExpenseAccountBillInfo(pk);
            tempValue = newInfo.getAmountApproved().subtract(oldInfo.getAmountApproved());
        }
        catch (Exception e) {
            tempValue = null;
        }
        return tempValue;
    }

    @Override
    protected int getOldState(Context ctx, IObjectPK pk) {
        FixExpenseAccountBillInfo oldInfo = null;
        int state = 1111;
        try {
            oldInfo = FixExpenseAccountBillFactory.getLocalInstance(ctx).getFixExpenseAccountBillInfo(pk);
            state = oldInfo.getState().getValue();
        }
        catch (Exception e) {
            state = 1111;
        }
        return state;
    }
}

