/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.IOperationTypeCompanyEntry;
import com.kingdee.eas.cp.bc.OperationTypeCompanyEntryCollection;
import com.kingdee.eas.cp.bc.OperationTypeCompanyEntryFactory;
import com.kingdee.eas.cp.bc.OperationTypeCompanyEntryInfo;
import com.kingdee.eas.cp.bc.OperationTypeCostCenterEntryInfo;
import com.kingdee.eas.cp.bc.app.AbstractOperationTypeCompanyEntryControllerBean;
import com.kingdee.eas.cp.bc.app.CommonDataWebUtils;
import com.kingdee.eas.cp.bc.util.OperationTypeUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OperationTypeCompanyEntryControllerBean
extends AbstractOperationTypeCompanyEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.OperationTypeCompanyEntryControllerBean");

    @Override
    protected Map _initOperationTypeCompanyView(Context ctx, List operationTypes, String companyId) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (operationTypes == null || operationTypes.size() == 0) {
            return resultMap;
        }
        ArrayList operationTypeIds = new ArrayList();
        int is = operationTypes.size();
        for (int i = 0; i < is; ++i) {
            Map operationType = (Map)operationTypes.get(i);
            operationTypeIds.add(operationType.get("id"));
        }
        HashSet<String> companyOrgUnitIds = new HashSet<String>();
        FilterInfo queryCompanyFilter = new FilterInfo();
        queryCompanyFilter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId));
        queryCompanyFilter.getFilterItems().add(new FilterItemInfo("operationTypeId", new HashSet(operationTypeIds), CompareType.INCLUDE));
        EntityViewInfo queryCompanyEntity = new EntityViewInfo();
        queryCompanyEntity.setFilter(queryCompanyFilter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("companyOrgUnit.id"));
        queryCompanyEntity.setSelector(selector);
        CoreBaseCollection operationTypeCompanyEntry = OperationTypeCompanyEntryFactory.getLocalInstance(ctx).getCollection(queryCompanyEntity);
        int is2 = operationTypeCompanyEntry.size();
        for (int i = 0; i < is2; ++i) {
            OperationTypeCompanyEntryInfo operationTypeCompanyInfo = (OperationTypeCompanyEntryInfo)operationTypeCompanyEntry.get(i);
            companyOrgUnitIds.add(operationTypeCompanyInfo.getCompanyOrgUnit().getId().toString());
        }
        resultMap.put("companyOrgUnitIds", companyOrgUnitIds);
        String companyFilter = CommonDataWebUtils.getChildCompanyOrgFilter(ctx);
        resultMap.put("companyFilter", companyFilter);
        return resultMap;
    }

    @Override
    protected void _saveOperCompany(Context ctx, Set operationIdSet, Map paramMap) throws BOSException, EASBizException {
        if (operationIdSet.size() == 0) {
            return;
        }
        CompanyOrgUnitInfo curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        String curCompanyId = curCompany != null ? curCompany.getId().toString() : null;
        boolean isCover = paramMap.get("isCover") == null ? false : (Boolean)paramMap.get("isCover");
        CompanyOrgUnitCollection companyColl = (CompanyOrgUnitCollection)paramMap.get("companyCollection");
        if (companyColl == null || companyColl.size() == 0) {
            return;
        }
        IOperationTypeCompanyEntry iOperCompanyService = OperationTypeCompanyEntryFactory.getLocalInstance(ctx);
        OperationTypeCompanyEntryCollection operationCompanyCon = null;
        Map<String, Object> operCompanyMap = null;
        if (!isCover && (operationCompanyCon = OperationTypeUtil.getCompanyEntry(iOperCompanyService, operationIdSet, curCompanyId)) != null && operationCompanyCon.size() > 0) {
            operCompanyMap = OperationTypeUtil.getOperLinkInfoMap(operationCompanyCon, "companyOrgUnit");
        }
        Set operCompanySet = null;
        CoreBaseCollection companyEntryCon = new CoreBaseCollection();
        String operationId = null;
        OperationTypeCompanyEntryInfo operCompanyInfo = null;
        CompanyOrgUnitInfo companyInfo = null;
        StringBuilder operationIds = new StringBuilder(60);
        Iterator it = operationIdSet.iterator();
        while (it.hasNext()) {
            operationId = it.next().toString();
            if (operCompanyMap != null) {
                operCompanySet = (Set)operCompanyMap.get(operationId);
            }
            int size = companyColl.size();
            for (int i = 0; i < size; ++i) {
                companyInfo = companyColl.get(i);
                if (!isCover && operCompanySet != null && operCompanySet.contains(companyInfo.getId().toString())) continue;
                operCompanyInfo = new OperationTypeCompanyEntryInfo();
                operCompanyInfo.setOperationTypeId(operationId);
                operCompanyInfo.setCompanyOrgUnit(companyInfo);
                operCompanyInfo.setCompany(curCompany);
                companyEntryCon.add((CoreBaseInfo)operCompanyInfo);
            }
            if (!isCover) continue;
            operationIds.append("'" + operationId + "',");
        }
        if (companyEntryCon.size() > 0) {
            if (isCover && operationIds.length() > 0) {
                operationIds = operationIds.deleteCharAt(operationIds.length() - 1);
                OperationTypeUtil.deleteMappingByOperationId(iOperCompanyService, operationIds.toString(), curCompanyId);
            }
            iOperCompanyService.save(companyEntryCon);
        }
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        IObjectPK[] iObjectPKs = super._delete(ctx, oql);
        String log = "\u4e1a\u52a1\u7c7b\u522b\u5173\u8054\u8d22\u52a1\u7ec4\u7ec7\u5220\u9664," + oql;
        if (log.length() > 150) {
            log.substring(0, 149);
        }
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"_delete", (BOSObjectType)new OperationTypeCostCenterEntryInfo().getBOSType(), null, (String)log);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        logger.info((Object)("\u4e1a\u52a1\u7c7b\u522b\u5173\u8054\u8d22\u52a1\u7ec4\u7ec7\u5220\u9664\uff1auserId=" + user.getId() + ", oql=" + oql));
        return iObjectPKs;
    }
}

