/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizBaseDataException;
import com.kingdee.eas.cp.bc.EnableStateEnum;
import com.kingdee.eas.cp.bc.ProxyReimburseCollection;
import com.kingdee.eas.cp.bc.ProxyReimburseFactory;
import com.kingdee.eas.cp.bc.ProxyReimburseInfo;
import com.kingdee.eas.cp.bc.ProxyReimburseType;
import com.kingdee.eas.cp.bc.app.AbstractProxyReimburseControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ProxyReimburseControllerBean
extends AbstractProxyReimburseControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.ProxyReimburseControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ProxyReimburseInfo proxyReimInfo = (ProxyReimburseInfo)model;
        if (proxyReimInfo.getProxyType() == ProxyReimburseType.Person && proxyReimInfo.getReimbursePerson() == null) {
            throw new BizBaseDataException(BizBaseDataException.REIMBURSEPERSON_NOT_NULL);
        }
        CompanyOrgUnitInfo proxyCompanyInfo = this.queryCompanyOrgUnitInfo(ctx, proxyReimInfo.getProxyPerson().getId().toString(), null);
        proxyReimInfo.setCompany(proxyCompanyInfo);
        if (proxyReimInfo.getCostCenter() != null) {
            this.checkOrgUnit(ctx, proxyReimInfo);
        } else {
            this.checkReimbursePerson(ctx, proxyReimInfo);
        }
        proxyReimInfo.setState(EnableStateEnum.ENABLE);
        IObjectPK objectPK = super._save(ctx, (IObjectValue)proxyReimInfo);
        return objectPK;
    }

    private CompanyOrgUnitInfo queryCompanyOrgUnitInfo(Context ctx, String personId, AdminOrgUnitInfo adminOrgUnitInfo) throws BOSException, EASBizException {
        CompanyOrgUnitInfo currentCompany = null;
        String adminOrgUnitInfoId = "";
        if (personId != null) {
            adminOrgUnitInfo = PersonFactory.getLocalInstance((Context)ctx).getPrimaryAdminOrgUnit(BOSUuid.read((String)personId));
            if (adminOrgUnitInfo != null && adminOrgUnitInfo.size() > 0) {
                adminOrgUnitInfoId = adminOrgUnitInfo.getId().toString();
            } else {
                String sql = "SELECT DISTINCT ADMINORGUNIT.FID FID FROM T_BD_Person PERSON LEFT OUTER JOIN T_HR_BDEmployeeType EMPLOYEETYPE ON PERSON.FEmployeeTypeID = EMPLOYEETYPE.FID LEFT OUTER JOIN T_ORG_PositionMember PM ON PERSON.FID = PM.FPersonID LEFT OUTER JOIN T_HR_PersonPosition PP ON PERSON.FID = PP.FPersonID LEFT OUTER JOIN T_ORG_Position POSITION ON PM.FPositionID = POSITION.FID LEFT OUTER JOIN T_ORG_Admin ADMINORGUNIT ON PP.FPersonDep = ADMINORGUNIT.FID LEFT OUTER JOIN T_ORG_CtrlUnit CU2 ON ADMINORGUNIT.FControlUnitID = CU2.FID LEFT OUTER JOIN T_PM_OrgRange ORGRANGE ON PP.FPersonDep = ORGRANGE.FOrgID LEFT OUTER JOIN T_PM_User PMUSER ON ORGRANGE.FUserID = PMUSER.FID WHERE (PM.FPositionID IS NULL AND PERSON.FID =  '%s')";
                IRowSet result = DbUtil.executeQuery((Context)ctx, (String)String.format(sql, personId));
                try {
                    while (result.next()) {
                        adminOrgUnitInfoId = result.getString("FID");
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        } else if (adminOrgUnitInfo != null) {
            adminOrgUnitInfoId = adminOrgUnitInfo.getId().toString();
        }
        logger.error((Object)("---cpbc---ProxyReimburseControllerBean---personId: " + personId + ",adminOrgUnitInfoId: " + adminOrgUnitInfoId));
        OrgUnitCollection appliyerComColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(adminOrgUnitInfoId, 0, 1);
        if (appliyerComColl != null && appliyerComColl.size() > 0) {
            currentCompany = (CompanyOrgUnitInfo)appliyerComColl.get(0);
        } else {
            logger.error((Object)("---cpbc---ProxyReimburseControllerBean---personId: " + personId + "\uff0c\u4e3b\u804c\u4f4d\u6240\u5728\u884c\u653f\u7ec4\u7ec7\u6ca1\u6709\u59d4\u6258\u8d22\u52a1\u7ec4\u7ec7    \u6216\u8005\u4e0d\u5728\u804c\u4eba\u5458\u6302\u9760\u7684\u884c\u653f\u7ec4\u7ec7\u6ca1\u6709\u59d4\u6258\u8d22\u52a1\u7ec4\u7ec7"));
        }
        return currentCompany;
    }

    private void checkReimbursePerson(Context ctx, ProxyReimburseInfo proxyReimbuserInfo) throws BOSException, EASBizException {
        if (this.queryCountIsExist(ctx, proxyReimbuserInfo) > 0) {
            throw new BizBaseDataException(BizBaseDataException.CANNOTREIMBURSEMORE, new Object[]{proxyReimbuserInfo.getReimburseCompany().getName()});
        }
    }

    private void checkOrgUnit(Context ctx, ProxyReimburseInfo proxyReimbuserInfo) throws BOSException, EASBizException {
        String orgUnitId = proxyReimbuserInfo.getCostCenter().getId().toString();
        String proxyPersonId = proxyReimbuserInfo.getProxyPerson().getId().toString();
        String proxyReimId = proxyReimbuserInfo.getId().toString();
        FilterInfo queryFilter = new FilterInfo();
        queryFilter.getFilterItems().add(new FilterItemInfo("costCenter", (Object)orgUnitId));
        queryFilter.getFilterItems().add(new FilterItemInfo("proxyPerson", (Object)proxyPersonId));
        if (StringUtils.isNotBlank((String)proxyReimId)) {
            queryFilter.getFilterItems().add(new FilterItemInfo("id", (Object)proxyReimId, CompareType.NOTEQUALS));
        }
        EntityViewInfo entityView = new EntityViewInfo();
        entityView.setFilter(queryFilter);
        ProxyReimburseCollection proxyReimburses = ProxyReimburseFactory.getLocalInstance(ctx).getProxyReimburseCollection(entityView);
        if (proxyReimburses.size() > 0) {
            throw new BizBaseDataException(BizBaseDataException.CANNOTORGUNITMORE);
        }
    }

    protected int queryCountIsExist(Context ctx, ProxyReimburseInfo proxyReimbuserInfo) throws BOSException, EASBizException {
        String reimbursePersonId = proxyReimbuserInfo.getReimbursePerson().getId().toString();
        String proxyPersonId = proxyReimbuserInfo.getProxyPerson().getId().toString();
        String companyId = null;
        companyId = proxyReimbuserInfo.getReimburseCompany() != null ? proxyReimbuserInfo.getReimburseCompany().getId().toString() : (String)ctx.get((Object)"CurCompanyId");
        String proxyReimId = proxyReimbuserInfo.getId().toString();
        int count = 0;
        StringBuilder querySql = new StringBuilder();
        querySql.append("select count(*) from T_BC_PROXYREIMBURSE WHERE ").append("FREIMBURSEPERSONID = '" + reimbursePersonId + "'").append(" AND FPROXYPERSONID = '" + proxyPersonId + "'").append(" AND FReimburseCompanyID = '" + companyId + "'").append(" AND FID <> '" + proxyReimId + "'");
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        try {
            while (row.next()) {
                count = row.getInt(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return count;
    }

    @Override
    protected void _changeState(Context ctx, List ids, boolean enableState) throws BOSException, EASBizException {
        int state = enableState ? 1 : 0;
        StringBuffer idStr = new StringBuffer();
        int is = ids.size();
        for (int i = 0; i < is; ++i) {
            idStr.append("'").append(ids.get(i).toString()).append("',");
        }
        idStr.deleteCharAt(idStr.length() - 1);
        String updateSql = "update t_bc_proxyreimburse set fstate = %s where fid in (%s)";
        DbUtil.execute((Context)ctx, (String)String.format(updateSql, state, idStr.toString()));
    }

    @Override
    protected String _queryPeronFilter(Context ctx, String personId) throws BOSException, EASBizException {
        String filterStr = "ADMINORGUNIT.ID IN (SELECT DISTINCT TOA.FID FROM T_ORG_COMPANY TOC INNER JOIN T_ORG_UNITRELATION TOUR ON TOUR.FTOUNITID = TOC.FID INNER JOIN T_ORG_ADMIN TOA ON TOA.FID = TOUR.FFROMUNITID INNER JOIN T_ORG_TYPERELATION TOTR ON TOTR.FID = TOUR.FTYPERELATIONID WHERE TOTR.FFROMTYPE = 0 AND TOTR.FTOTYPE = 1 ) AND ID != '%s' AND DELETEDSTATUS != 2 ";
        return String.format(filterStr, personId);
    }

    @Override
    protected List _queryReimbursePerson(Context ctx, String personId) throws BOSException, EASBizException {
        ArrayList<String> reimbursePersonIds = new ArrayList<String>();
        if (StringUtils.isEmpty((String)personId)) {
            return reimbursePersonIds;
        }
        String queryOql = "select reimbursePerson.id where state = 1 and proxyPerson.id = '%s'";
        ProxyReimburseCollection proxyReimburseCollection = ProxyReimburseFactory.getLocalInstance(ctx).getProxyReimburseCollection(String.format(queryOql, personId));
        int is = proxyReimburseCollection.size();
        for (int i = 0; i < is; ++i) {
            if (proxyReimburseCollection.get(i).getReimbursePerson() == null) continue;
            reimbursePersonIds.add(proxyReimburseCollection.get(i).getReimbursePerson().getId().toString());
        }
        return reimbursePersonIds;
    }

    @Override
    protected String _queryOrgFilter(Context ctx, String companyId) throws BOSException, EASBizException {
        String filterStr = "ID IN (SELECT adminOrg.FID FROM T_ORG_Admin adminOrg INNER JOIN T_ORG_UnitRelation unitrelation ON unitrelation.FFromUnitID = adminOrg.fid INNER JOIN T_ORG_TypeRelation typerelation ON typerelation.Fid = unitrelation.FTypeRelationID INNER JOIN T_ORG_Company company ON company.fid = unitrelation.FToUnitID WHERE typerelation.FFromType = 0 AND typerelation.FToType = 1  and company.fid = '%s') ";
        return String.format(filterStr, companyId);
    }

    @Override
    protected boolean _isCompanyPerson(Context ctx, String userId, String companyId) throws BOSException {
        String queryCompanySql = "SELECT DISTINCT PERSON.FID FID FROM T_BD_Person PERSON INNER JOIN T_ORG_POSITIONMEMBER TOPM ON TOPM.FPERSONID = PERSON.FID INNER JOIN T_ORG_POSITION TOPO ON TOPM.FPOSITIONID = TOPO.FID INNER JOIN T_ORG_ADMIN TOA ON TOA.FID = TOPO.FADMINORGUNITID INNER JOIN T_ORG_UNITRELATION TOUR ON TOUR.FFROMUNITID = TOA.FID INNER JOIN T_ORG_COMPANY TOC ON TOUR.FTOUNITID = TOC.FID INNER JOIN T_ORG_TYPERELATION TOTR ON TOTR.FID = TOUR.FTYPERELATIONID WHERE TOTR.FFROMTYPE = 0 AND TOTR.FTOTYPE = 1 AND TOPM.FPERSONID = '%s' AND TOC.FID = '%s'";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)String.format(queryCompanySql, userId, companyId));
        return result.size() != 0;
    }

    @Override
    protected List _queryAdminOrgUnit(Context ctx, String personId) throws BOSException {
        ArrayList<String> adminOrgIds = new ArrayList<String>();
        if (StringUtils.isEmpty((String)personId)) {
            return adminOrgIds;
        }
        String queryOql = "select costCenter.id where state = 1 and proxyPerson.id = '%s'";
        ProxyReimburseCollection proxyReimburseCollection = ProxyReimburseFactory.getLocalInstance(ctx).getProxyReimburseCollection(String.format(queryOql, personId));
        int is = proxyReimburseCollection.size();
        for (int i = 0; i < is; ++i) {
            if (proxyReimburseCollection.get(i).getCostCenter() == null) continue;
            adminOrgIds.add(proxyReimburseCollection.get(i).getCostCenter().getId().toString());
        }
        return adminOrgIds;
    }

    @Override
    protected String _queryPersonsByAdminOrg(Context ctx, List adminOrgIds) throws BOSException {
        if (adminOrgIds == null || adminOrgIds.size() == 0) {
            adminOrgIds.add("nodata");
        }
        String adminIdStr = StringUtils.join((Object[])adminOrgIds.toArray(), (String)"','");
        String queryPersonsSql = "SELECT DISTINCT PERSON.FID FID FROM T_BD_Person PERSON INNER JOIN T_ORG_POSITIONMEMBER TOPM ON TOPM.FPERSONID = PERSON.FID INNER JOIN T_ORG_POSITION TOPO ON TOPM.FPOSITIONID = TOPO.FID INNER JOIN T_ORG_ADMIN TOA ON TOA.FID = TOPO.FADMINORGUNITID WHERE TOA.FID IN ('%s') ";
        return String.format(queryPersonsSql, adminIdStr);
    }

    @Override
    protected List _getPersonIdsByAdminOrg(Context ctx, List adminOrgIds) throws BOSException {
        ArrayList<String> personIds = new ArrayList<String>();
        String queryOrgsql = this._queryPersonsByAdminOrg(ctx, adminOrgIds);
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)String.format(queryOrgsql, new Object[0]));
        try {
            while (result.next()) {
                personIds.add(result.getString("FID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return personIds;
    }

    @Override
    protected List _queryPersonIdsByAdminOrg(Context ctx, List adminOrgIds) throws BOSException {
        if (adminOrgIds == null || adminOrgIds.size() == 0) {
            adminOrgIds.add("nodata");
        }
        ArrayList<String> personIds = new ArrayList<String>();
        String adminIdStr = StringUtils.join((Object[])adminOrgIds.toArray(), (String)"','");
        String queryPersonsSql = "SELECT DISTINCT PERSON.FID FID FROM T_BD_Person PERSON INNER JOIN T_ORG_POSITIONMEMBER TOPM ON TOPM.FPERSONID = PERSON.FID INNER JOIN T_ORG_POSITION TOPO ON TOPM.FPOSITIONID = TOPO.FID INNER JOIN T_ORG_ADMIN TOA ON TOA.FID = TOPO.FADMINORGUNITID WHERE TOA.FID IN ('%s') ";
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)String.format(queryPersonsSql, adminIdStr));
        try {
            while (result.next()) {
                personIds.add(result.getString("FID"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return personIds;
    }
}

