/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.BizCollVersion;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.IExpenseCommenFacade;
import com.kingdee.eas.cp.bc.IRePaymentBill;
import com.kingdee.eas.cp.bc.IRePaymentFacade;
import com.kingdee.eas.cp.bc.RePaymentBillFactory;
import com.kingdee.eas.cp.bc.RePaymentBillInfo;
import com.kingdee.eas.cp.bc.RePaymentBillReceiveEntryInfo;
import com.kingdee.eas.cp.bc.RePaymentFacadeFactory;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.AbstractRePaymentFacadeControllerBean;
import com.kingdee.eas.cp.bc.app.BizAppUtil;
import com.kingdee.eas.cp.bc.ng.ISCHelper;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import org.apache.log4j.Logger;

public class RePaymentFacadeControllerBean
extends AbstractRePaymentFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.RePaymentFacadeControllerBean");
    public static final String RES_BIZCOLL = "com.kingdee.eas.cp.bc.client.ExpAccResource";

    @Override
    protected void _setAudit(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        RePaymentBillInfo info = this.rePaymentReverse(ctx, billId, auditorId, true);
        if (BizCollVersion.isRepayOld1Version(info.getVersion())) {
            BizAppUtil.updateLoanBillFlag(ctx, info, false);
        }
        if (info.getReceiveEntries() != null && info.getReceiveEntries().size() > 0) {
            this.setNowState(ctx, billId, StateEnum.ISRECEIVEBILL, auditorId);
        } else {
            this.setNowState(ctx, billId, StateEnum.CHECKED, auditorId);
        }
        if (!ISCHelper.isFromISC()) {
            RePaymentBillFactory.getLocalInstance(ctx).ngisc_reverse((IObjectPK)new ObjectUuidPK(billId));
        }
    }

    @Override
    protected void _setAntiAudit(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        boolean isPay = false;
        this.rePaymentReverse(ctx, billId, auditorId, isPay);
        this.setNowState(ctx, billId, StateEnum.DRAFT, auditorId);
        if (!ISCHelper.isFromISC()) {
            RePaymentBillFactory.getLocalInstance(ctx).ngisc_reverse((IObjectPK)new ObjectUuidPK(billId));
        }
    }

    private RePaymentBillInfo rePaymentReverse(Context ctx, BOSUuid billId, BOSUuid auditorId, boolean isPay) throws BOSException, EASBizException {
        RePaymentBillInfo rePaymentBillInfo = null;
        IRePaymentBill iBiz = RePaymentBillFactory.getLocalInstance(ctx);
        rePaymentBillInfo = iBiz.getRePaymentBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getRepaySelector());
        int version = rePaymentBillInfo.getVersion();
        if (BizCollVersion.isRepayOld1Version(version)) {
            BizAppUtil.reverseSaveLoanBill(ctx, rePaymentBillInfo, isPay, false);
        } else if (!isPay) {
            BizAppUtil.reverseSaveLoanBill(ctx, rePaymentBillInfo, isPay, false);
        }
        if (isPay) {
            this.checkReceiveBillState(ctx, rePaymentBillInfo);
        }
        return rePaymentBillInfo;
    }

    private SelectorItemCollection getRepaySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("cause"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("repayDate"));
        sic.add(new SelectorItemInfo("version"));
        sic.add(new SelectorItemInfo("checkStandard"));
        sic.add(new SelectorItemInfo("applier.id"));
        sic.add(new SelectorItemInfo("applier.name"));
        sic.add(new SelectorItemInfo("applier.number"));
        sic.add(new SelectorItemInfo("applierCompany.id"));
        sic.add(new SelectorItemInfo("applierCompany.name"));
        sic.add(new SelectorItemInfo("applierCompany.number"));
        sic.add(new SelectorItemInfo("repayOrgUnit.id"));
        sic.add(new SelectorItemInfo("repayOrgUnit.name"));
        sic.add(new SelectorItemInfo("repayOrgUnit.number"));
        sic.add(new SelectorItemInfo("costCompany.id"));
        sic.add(new SelectorItemInfo("costCompany.name"));
        sic.add(new SelectorItemInfo("costCompany.number"));
        sic.add(new SelectorItemInfo("costCenter.id"));
        sic.add(new SelectorItemInfo("costCenter.name"));
        sic.add(new SelectorItemInfo("costCenter.number"));
        sic.add(new SelectorItemInfo("currencyType.id"));
        sic.add(new SelectorItemInfo("entries.sourceBillId"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
        sic.add(new SelectorItemInfo("entries.amount"));
        sic.add(new SelectorItemInfo("entries.amountOri"));
        sic.add(new SelectorItemInfo("entries.exchangeRate"));
        sic.add(new SelectorItemInfo("entries.expenseType.id"));
        sic.add(new SelectorItemInfo("entries.expenseType.name"));
        sic.add(new SelectorItemInfo("entries.expenseType.number"));
        sic.add(new SelectorItemInfo("entries.currency.id"));
        sic.add(new SelectorItemInfo("entries.currency.name"));
        sic.add(new SelectorItemInfo("entries.currency.number"));
        sic.add(new SelectorItemInfo("entries.loanNumber"));
        sic.add(new SelectorItemInfo("entries.loanAmountBalanceOri"));
        sic.add(new SelectorItemInfo("entries.loanAmountBalance"));
        sic.add(new SelectorItemInfo("entries.loanExchangeRate"));
        sic.add(new SelectorItemInfo("entries.loanCurrency.id"));
        sic.add(new SelectorItemInfo("entries.loanCurrency.name"));
        sic.add(new SelectorItemInfo("entries.loanCurrency.number"));
        sic.add(new SelectorItemInfo("receiveEntries.receiveBillId"));
        return sic;
    }

    private void setNowState(Context ctx, BOSUuid billId, StateEnum state, BOSUuid auditorId) throws BOSException, EASBizException {
        BOSObjectType type = billId.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String userId = ctx.getCaller().toString();
        if (auditorId != null) {
            userId = auditorId.toString();
        }
        EntityObjectInfo vo = loader.getEntity(type);
        String table = vo.getTable().getName();
        StringBuffer sql = new StringBuffer();
        boolean isCheck = false;
        sql.append("update ");
        sql.append(table);
        sql.append(" set FState=?");
        String nowTime = this.getTime().toString();
        Boolean isReWriter = (Boolean)ctx.get((Object)"isReWrite");
        if (StateEnum.CHECKING.equals((Object)state) || isReWriter == null && StateEnum.CHECKED.equals((Object)state) || StateEnum.CHECKFAILD.equals((Object)state) || StateEnum.ISRECEIVEBILL.equals((Object)state)) {
            isCheck = true;
            sql.append(", FAuditorID=?");
            sql.append(" ,FAuditDate=?");
        }
        sql.append(" ,FLastUpdateTime=?");
        sql.append(" where FID=?");
        String sql_state = sql.toString();
        Connection conn = null;
        PreparedStatement stmt = null;
        int index = 0;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql_state);
            stmt.setInt(++index, state.getValue());
            if (isCheck) {
                stmt.setString(++index, userId);
                stmt.setDate(++index, new Date(System.currentTimeMillis()));
            }
            stmt.setDate(++index, new Date(System.currentTimeMillis()));
            stmt.setString(++index, billId.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"setNowState", (BOSObjectType)type, (IObjectPK)new ObjectUuidPK(billId), (String)("setNowState\u8fd8\u6b3e\u5355\u8bbe\u7f6e\u5355\u636e\u72b6\u6001  state=" + (Object)((Object)state) + ",billId=" + billId + ",auditorId=" + auditorId));
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
    }

    private Timestamp getTime() {
        java.util.Date date = new java.util.Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private void checkReceiveBillState(Context ctx, RePaymentBillInfo rePaymentBillInfo) throws BOSException, EASBizException {
        if (rePaymentBillInfo.getReceiveEntries() != null) {
            RePaymentBillReceiveEntryInfo entry = null;
            StringBuilder logStr = new StringBuilder("##triggerReceiveBillAuditWF success id=");
            IRePaymentFacade iRePaymentFacade = RePaymentFacadeFactory.getLocalInstance(ctx);
            for (int i = 0; i < rePaymentBillInfo.getReceiveEntries().size(); ++i) {
                entry = rePaymentBillInfo.getReceiveEntries().get(i);
                String receiveBillId = entry.getReceiveBillId();
                try {
                    iRePaymentFacade.triggerReceiveBillAuditWF((IObjectPK)new ObjectUuidPK(receiveBillId));
                    logStr.append(receiveBillId + ",");
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("##triggerReceiveBillAuditWF error id=" + receiveBillId + ". " + e.getMessage()), (Throwable)e);
                }
            }
            logger.info((Object)logStr);
        }
    }

    @Override
    protected void _setSubmitState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setNowState(ctx, billId, StateEnum.SUBMIT, null);
    }

    @Override
    protected void _setNoPassState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        IRePaymentBill iBiz = RePaymentBillFactory.getLocalInstance(ctx);
        RePaymentBillInfo rePaymentBillInfo = iBiz.getRePaymentBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getRepaymentApplimerCompanyAndEntrySelector());
        if (BizCollVersion.isRepayOld1Version(rePaymentBillInfo.getVersion())) {
            String applierCompanyId = rePaymentBillInfo.getApplierCompany().getId().toString();
            Map paramMap = this.getParamMap(ctx, applierCompanyId);
            boolean CP035 = Boolean.valueOf(paramMap.get("CP035").toString());
            if (!CP035) {
                BizAppUtil.updateLoanBillFlag(ctx, rePaymentBillInfo, false);
            }
        } else {
            this.rePaymentReverse(ctx, billId, auditorId, false);
        }
        this.setNowState(ctx, billId, StateEnum.CHECKFAILD, auditorId);
        iBiz.ngisc_reverse((IObjectPK)new ObjectUuidPK(billId));
    }

    private SelectorItemCollection getRepaymentApplimerCompanyAndEntrySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("applierCompany.id"));
        sic.add(new SelectorItemInfo("entries.sourceBillId"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
        sic.add(new SelectorItemInfo("version"));
        return sic;
    }

    public Map getParamMap(Context ctx, String companyId) throws EASBizException, BOSException {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP035");
        IExpenseCommenFacade iExpenseCommenFacade = ExpenseCommenFacadeFactory.getLocalInstance(ctx);
        Map paramMap = iExpenseCommenFacade.getParamsForCompany(paramList, companyId);
        return paramMap;
    }

    @Override
    protected void _setApproveState(Context ctx, BOSUuid billId, BOSUuid auditorId) throws BOSException, EASBizException {
        this.setNowState(ctx, billId, StateEnum.CHECKING, auditorId);
        RePaymentBillFactory.getLocalInstance(ctx).ngisc_reverse((IObjectPK)new ObjectUuidPK(billId));
    }

    @Override
    protected void _setAbandonState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this.setNowState(ctx, billId, StateEnum.ALREADYABANDON, null);
        IRePaymentBill iBiz = RePaymentBillFactory.getLocalInstance(ctx);
        RePaymentBillInfo rePaymentBillInfo = iBiz.getRePaymentBillInfo((IObjectPK)new ObjectUuidPK(billId), this.getRepaySelector());
        if (BizCollVersion.isRepayOld1Version(rePaymentBillInfo.getVersion())) {
            BizAppUtil.updateLoanBillFlag(ctx, rePaymentBillInfo, false);
        } else {
            this.rePaymentReverse(ctx, billId, null, false);
        }
        if (billId != null) {
            BizCollUtil.deleteBotpRelationBySrcBillId(ctx, billId.toString());
        }
        iBiz.ngisc_reverse((IObjectPK)new ObjectUuidPK(billId));
    }

    @Override
    protected void _triggerReceiveBillAuditWF(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ReceivingBillFactory.getLocalInstance((Context)ctx).audit4WF(pk);
    }
}

