/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillCollection;
import com.kingdee.eas.cp.bc.BizAccountBillFactory;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.IImageHandleTask;
import com.kingdee.eas.cp.bc.IImageScanRecords;
import com.kingdee.eas.cp.bc.ImageHandleTaskCollection;
import com.kingdee.eas.cp.bc.ImageHandleTaskEntryCollection;
import com.kingdee.eas.cp.bc.ImageHandleTaskEntryFactory;
import com.kingdee.eas.cp.bc.ImageHandleTaskEntryInfo;
import com.kingdee.eas.cp.bc.ImageHandleTaskFactory;
import com.kingdee.eas.cp.bc.ImageHandleTaskInfo;
import com.kingdee.eas.cp.bc.ImageScanRecordsFactory;
import com.kingdee.eas.cp.bc.ImageScanRecordsInfo;
import com.kingdee.eas.cp.bc.ImageStateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillCollection;
import com.kingdee.eas.cp.bc.TravelAccountBillFactory;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.helper.WebServiceUtil;
import com.kingdee.eas.cp.bc.image.BaseBillInfo;
import com.kingdee.eas.cp.bc.image.BaseImageInfo;
import com.kingdee.eas.cp.bc.image.BaseImageList;
import com.kingdee.eas.cp.bc.image.ReceiveImageInfo;
import com.kingdee.eas.cp.bc.image.SSCImageUtils;
import com.kingdee.eas.cp.bc.image.SendImageInfo;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class SSCImageHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.SSCImageHandler");
    static String IMAGE_READY = "1";
    static String IMAGE_NOT_READY = "0";

    void saveImageReady(Context ctx, BaseImageList baseList) throws BOSException, EASBizException {
        System.out.print("*********saveImageReady begin");
        ReceiveImageInfo imageInfo2 = null;
        System.out.print("*********saveImageReady begin");
        IImageScanRecords iRecords = ImageScanRecordsFactory.getLocalInstance(ctx);
        IImageHandleTask handTask = ImageHandleTaskFactory.getLocalInstance(ctx);
        HashSet<String> imageNoSet = new HashSet<String>();
        for (ReceiveImageInfo imageInfo2 : baseList.getImageList()) {
            ImageScanRecordsInfo recordsInfo = new ImageScanRecordsInfo();
            recordsInfo.setScanClientIP(imageInfo2.getScanClientIP());
            recordsInfo.setScanTime(SSCImageUtils.convertStr2Date(imageInfo2.getScanTime()));
            recordsInfo.setImageNo(imageInfo2.getImageNo());
            if (imageInfo2.getScanUserID().indexOf("((()))") > -1) {
                int end = imageInfo2.getScanUserID().indexOf("((()))");
                recordsInfo.setScanUserID(imageInfo2.getScanUserID().substring(0, end));
            } else {
                recordsInfo.setScanUserID(imageInfo2.getScanUserID());
            }
            iRecords.save(recordsInfo);
            imageNoSet.add(imageInfo2.getImageNo());
        }
        System.out.print("*********saveImageReady end");
        System.out.print("********* saveImageReady updateHandleTask begin");
        this.updateHandleTask(ctx, imageNoSet);
        System.out.print("*********saveImageReady updateHandleTask end");
    }

    void updateHandleTask(Context ctx, Set imageNoSet) throws BOSException, EASBizException {
        System.out.print("*********updateHandleTask begin");
        String currentPid = "";
        if (null != ContextUtil.getCurrentUserInfo((Context)ctx).getPerson()) {
            currentPid = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        IImageHandleTask handTask = ImageHandleTaskFactory.getLocalInstance(ctx);
        ImageHandleTaskCollection icls = null;
        ImageHandleTaskInfo handleTaskInfo = null;
        Object handleTaskEntryInfo = null;
        ImageHandleTaskEntryCollection handleTaskEntryCollection = null;
        icls = handTask.getImageHandleTaskCollection("select *,entry.* where barcode  in" + SSCImageUtils.getStrFromSet(imageNoSet) + " and state ='" + IMAGE_NOT_READY + "'");
        if (null != icls && icls.size() > 0) {
            int j = icls.size();
            for (int i = 0; i < j; ++i) {
                handleTaskInfo = icls.get(i);
                handleTaskInfo.setHandleTime(new Timestamp(System.currentTimeMillis()));
                handleTaskInfo.setState(IMAGE_READY);
                handleTaskEntryCollection = handleTaskInfo.getEntry();
                if (handleTaskEntryCollection.size() > 0) {
                    int n = handleTaskEntryCollection.size();
                    for (int m = 0; m < n; ++m) {
                        ImageHandleTaskEntryInfo entryInfo = handleTaskEntryCollection.get(m);
                        entryInfo.setSelfHandle(currentPid.equals(entryInfo.getImageHandler()));
                    }
                }
                handTask.update((IObjectPK)new ObjectUuidPK(handleTaskInfo.getId()), handleTaskInfo);
            }
        }
        System.out.print("*********updateHandleTask end");
    }

    void createAccount(Context ctx, List<String> imageList, BaseImageList newList) throws BOSException {
        for (String imageNo : imageList) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)imageNo));
            BOSObjectType type = new ObjectUuidPK(BOSUuid.read((String)imageNo)).getObjectType();
            IObjectValue value = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, (IObjectPK)pk);
            BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)value;
            newList.addImageList(this.getImageInfo(billInfo));
        }
    }

    void updateAccount(Context ctx, List<String> imageList) throws BOSException {
        System.out.print("**********updateAccount begin ");
        for (String imageNo : imageList) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)imageNo));
            BOSObjectType type = new ObjectUuidPK(BOSUuid.read((String)imageNo)).getObjectType();
            IObjectValue value = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, (IObjectPK)pk);
            ((BizCollBillBaseInfo)value).setIsRefPaperPark(ImageStateEnum.HAS_IMAGE);
            DynamicObjectFactory.getLocalInstance((Context)ctx).update(type, (IObjectPK)pk, value);
        }
        System.out.print("**********updateAccount end ");
    }

    BaseImageList getImageList(Context ctx, String scanUserID) throws BOSException {
        BaseImageList newList = new BaseImageList();
        ImageHandleTaskEntryCollection icls = ImageHandleTaskEntryFactory.getLocalInstance(ctx).getImageHandleTaskEntryCollection("select parent.* where imageHandler = '" + scanUserID + "' and parent.state = '" + IMAGE_NOT_READY + "'");
        if (null != icls && icls.size() > 0) {
            System.out.print(String.valueOf(icls.size()));
            int j = icls.size();
            for (int i = 0; i < j; ++i) {
                BaseImageInfo imageInfo = new BaseImageInfo();
                imageInfo.setImageNo(icls.get(i).getParent().getBarcode());
                newList.addImageList(imageInfo);
            }
        }
        return newList;
    }

    BaseImageList getNeedScanImageList(Context ctx, String personID) throws BOSException {
        BaseImageList newList = new BaseImageList();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fnumber , fcause,famount from t_bc_bizaccountbill where FApplierID = ?  ");
        sql.append(" and fneedphoto=1 and (fisrefpaperpark = 0 or fisrefpaperpark=3 or fisrefpaperpark is null ) ");
        sql.append(" union ");
        sql.append(" select fnumber , fcause,famount from T_BC_TravelAccountBill where FApplierID = ? ");
        sql.append(" and fneedphoto=1 and (fisrefpaperpark = 0 or fisrefpaperpark=3 or fisrefpaperpark is null ) ");
        IRowSet rows = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{personID, personID});
        try {
            while (rows.next()) {
                BaseBillInfo info = new BaseBillInfo();
                info.setNumber(rows.getString("fnumber"));
                info.setCause(rows.getString("fcause"));
                info.setAmount(rows.getBigDecimal("famount").toString());
                info.setImageMark(null);
            }
        }
        catch (SQLException e) {
            System.out.print("getNeedScanImageList error");
            e.printStackTrace();
        }
        return newList;
    }

    void updateTravelAccount(Context ctx, Set imageNoSet) throws BOSException {
        String inSql = SSCImageUtils.getStrFromSet(imageNoSet);
        String sql = "update T_BC_TravelAccountBill set fisRefPaperPark=2 where fimageNo in " + inSql;
        DbUtil.execute((Context)ctx, (String)sql);
    }

    void updateBizAccount(Context ctx, Set imageNoSet) throws BOSException {
        String inSql = SSCImageUtils.getStrFromSet(imageNoSet);
        String sql = "update T_BC_BizAccountBill set fisRefPaperPark=2 where fimageNo in " + inSql;
        DbUtil.execute((Context)ctx, (String)sql);
    }

    void createTravelAccount(Context ctx, Set imageNoSet, BaseImageList newList) throws BOSException {
        TravelAccountBillCollection tacls = TravelAccountBillFactory.getLocalInstance(ctx).getTravelAccountBillCollection(this.buildSendImageView(imageNoSet));
        if (null != tacls && tacls.size() > 0) {
            int j = tacls.size();
            for (int i = 0; i < j; ++i) {
                TravelAccountBillInfo billInfo = tacls.get(i);
                newList.addImageList(this.getImageInfo(billInfo));
            }
        }
    }

    private SendImageInfo getImageInfo(BizCollBillBaseInfo billInfo) {
        SendImageInfo imageInfo = new SendImageInfo();
        imageInfo.setBillNo(billInfo.getId().toString());
        imageInfo.setImageNo(billInfo.getImageNo());
        imageInfo.setImageExists("Exists");
        if (billInfo.getIsRefPaperPark().equals((Object)ImageStateEnum.NO_IMAGE) || billInfo.getIsRefPaperPark().equals((Object)ImageStateEnum.RESCAN_IAMGE)) {
            imageInfo.setImageAllowScan("AllowScan");
        }
        imageInfo.setBillStatus(String.valueOf(billInfo.getState().getValue()));
        String amount = String.valueOf(billInfo.getAmount());
        if ("0E-10".equals(amount)) {
            amount = "0.00";
        }
        if (amount.indexOf(".") >= 0 && amount.length() > amount.indexOf(".") + 3) {
            imageInfo.setBillAmount(amount.substring(0, amount.indexOf(".") + 3));
        } else {
            imageInfo.setBillAmount(amount);
        }
        return imageInfo;
    }

    void createBizAccount(Context ctx, Set imageNoSet, BaseImageList newList) throws BOSException {
        BizAccountBillCollection tacls = BizAccountBillFactory.getLocalInstance(ctx).getBizAccountBillCollection(this.buildSendImageView(imageNoSet));
        if (null != tacls && tacls.size() > 0) {
            int j = tacls.size();
            for (int i = 0; i < j; ++i) {
                BizAccountBillInfo billInfo = tacls.get(i);
                newList.addImageList(this.getImageInfo(billInfo));
            }
        }
    }

    EntityViewInfo buildSendImageView(Set imageNoSet) {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("isRefPaperPark"));
        view.getSelector().add(new SelectorItemInfo("state"));
        view.getSelector().add(new SelectorItemInfo("imageNo"));
        view.getSelector().add(new SelectorItemInfo("amount"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("imageNo", (Object)imageNoSet, CompareType.INCLUDE));
        return view;
    }

    void invokeTaskCenterService(Context ctx, BaseImageList baseList) throws BOSException, EASBizException, RemoteException {
        System.out.print("***************invokeTaskCenterService:begin");
        IImageHandleTask handleTask = ImageHandleTaskFactory.getLocalInstance(ctx);
        ImageHandleTaskCollection icls = null;
        ReceiveImageInfo imageInfo2 = null;
        ImageHandleTaskInfo taskInfo = null;
        JSONArray msg = new JSONArray();
        HashSet<String> taskImageSet = new HashSet<String>();
        boolean flag = false;
        for (ReceiveImageInfo imageInfo2 : baseList.getImageList()) {
            icls = handleTask.getImageHandleTaskCollection("where barcode = '" + imageInfo2.getImageNo() + "' and state = '" + IMAGE_NOT_READY + "' order by handleTime desc");
            if (null == icls || icls.size() <= 0) continue;
            taskInfo = icls.get(0);
            msg.put((Object)SSCImageUtils.getTaskJosnObj(taskInfo));
            taskImageSet.add(taskInfo.getBarcode());
        }
        if (msg.length() > 0) {
            System.out.print("addPersonMessage is :" + msg.toString());
            flag = WebServiceUtil.getTaskCenterServiceInstance().addPersonMessage(msg.toString());
            System.out.print("addPersonMessage return :" + flag);
        }
        System.out.print("*********taskImageSet.size:" + taskImageSet.size() + ",baseList.getImageList().size():" + baseList.getImageList().size());
        JSONArray imageArr = new JSONArray();
        for (ReceiveImageInfo imageInfo2 : baseList.getImageList()) {
            System.out.print("**********imageInfo.getImageNo():" + imageInfo2.getImageNo());
            if (!taskImageSet.contains(imageInfo2.getImageNo())) continue;
            System.out.print("********** contains");
            imageArr.put((Object)SSCImageUtils.getImageJosnObj(imageInfo2.getImageNo()));
        }
        if (imageArr.length() > 0) {
            System.out.print("updateImageState is :" + imageArr.toString());
            String res = WebServiceUtil.getTaskInterServiceInstance().updateImageState(imageArr.toString());
            System.out.print("updateImageState return :" + res);
        }
    }
}

