/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountBaseBillInfo;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillWKEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillWKFactory;
import com.kingdee.eas.cp.bc.TravelAccountBillWKInfo;
import com.kingdee.eas.cp.bc.app.AbstractTravelAccountBillWKControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class TravelAccountBillWKControllerBean
extends AbstractTravelAccountBillWKControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.TravelAccountBillWKControllerBean");

    @Override
    protected void checkEntry(ExpenseAccountBillInfo model) throws BOSException, EASBizException {
        TravelAccountBillWKInfo info = (TravelAccountBillWKInfo)model;
        TravelAccountBillWKEntryInfo entry = null;
        int size = info.getEntries().size();
        if (size < 1) {
            throw new ExpAccException(ExpAccException.ENTRY_NOT_NULL);
        }
        for (int i = size - 1; i > -1; --i) {
            Date toDate;
            entry = info.getEntries().get(i);
            if (entry.getStartDate() == null) {
                throw new ExpAccException(ExpAccException.BEGINDATE_NOT_NULL);
            }
            if (StringUtils.isEmpty((String)entry.getFrom())) {
                throw new ExpAccException(ExpAccException.BEGIN_NOT_NULL);
            }
            if (entry.getFrom().length() > 200) {
                throw new ExpAccException(ExpAccException.BEGIN_TOO_LONG);
            }
            if (entry.getEndDate() == null) {
                throw new ExpAccException(ExpAccException.ENDDATE_NOT_NULL);
            }
            if (entry.getTo().length() > 200) {
                throw new ExpAccException(ExpAccException.END_TOO_LONG);
            }
            if (StringUtils.isEmpty((String)entry.getTo())) {
                throw new ExpAccException(ExpAccException.END_NOT_NULL);
            }
            if (entry.getVehicle() == null) {
                throw new ExpAccException(ExpAccException.VEHICLE_NOT_NULL);
            }
            Date fromDate = entry.getStartDate();
            if (fromDate.compareTo(toDate = entry.getEndDate()) <= 0) continue;
            throw new ExpAccException(ExpAccException.BEGIN_LT_END);
        }
    }

    @Override
    protected BigDecimal getBudgetValue(Context ctx, IObjectPK pk, IObjectValue model) {
        TravelAccountBillWKInfo newInfo = (TravelAccountBillWKInfo)model;
        TravelAccountBillWKInfo oldInfo = null;
        BigDecimal tempValue = null;
        try {
            oldInfo = TravelAccountBillWKFactory.getLocalInstance(ctx).getTravelAccountBillWKInfo(pk);
            tempValue = newInfo.getAmountApproved().subtract(oldInfo.getAmountApproved());
        }
        catch (Exception e) {
            tempValue = null;
        }
        return tempValue;
    }

    @Override
    protected int getOldState(Context ctx, IObjectPK pk) {
        TravelAccountBillWKInfo oldInfo = null;
        int state = 1111;
        try {
            oldInfo = TravelAccountBillWKFactory.getLocalInstance(ctx).getTravelAccountBillWKInfo(pk);
            state = oldInfo.getState().getValue();
        }
        catch (Exception e) {
            state = 1111;
        }
        return state;
    }

    @Override
    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super.checkNumberDup(ctx, model);
    }

    @Override
    protected void bizRuleBind(Context ctx, ExpenseAccountBillInfo model) {
    }

    @Override
    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo coreBaseInfo = (CoreBaseInfo)model;
        if (this._isExistPropertyName(ctx, coreBaseInfo, "effectedStatus")) {
            coreBaseInfo.setInt("effectedStatus", 2);
        }
        ServiceStateManager.getInstance().enableNextCallServices();
        if (coreBaseInfo.getId() != null && this._exists(ctx, pk)) {
            ExpenseAccountBaseBillInfo info = (ExpenseAccountBaseBillInfo)model;
            BigDecimal tempValue = null;
            TravelAccountBillWKInfo oldInfo = null;
            oldInfo = TravelAccountBillWKFactory.getLocalInstance(ctx).getTravelAccountBillWKInfo(pk);
            tempValue = 20 == oldInfo.getState().getValue() ? info.getAmountApproved() : this.getBudgetValue(ctx, pk, model);
            this.setBudgetValue(ctx, pk, model, tempValue);
            super.update(ctx, pk, coreBaseInfo);
        } else {
            this.checkBudgetControl(ctx, (ExpenseAccountBaseBillInfo)model);
            super.addnew(ctx, pk, coreBaseInfo);
        }
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBaseInfo coreBaseInfo = (CoreBaseInfo)model;
        if (this._isExistPropertyName(ctx, coreBaseInfo, "effectedStatus")) {
            coreBaseInfo.setInt("effectedStatus", 2);
        }
        ServiceStateManager.getInstance().enableNextCallServices();
        if (coreBaseInfo.getId() != null && this._exists(ctx, (IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            ObjectUuidPK retValue = new ObjectUuidPK(coreBaseInfo.getId());
            ExpenseAccountBaseBillInfo info = (ExpenseAccountBaseBillInfo)model;
            BigDecimal tempValue = null;
            TravelAccountBillWKInfo newInfo = (TravelAccountBillWKInfo)model;
            TravelAccountBillWKInfo oldInfo = null;
            oldInfo = TravelAccountBillWKFactory.getLocalInstance(ctx).getTravelAccountBillWKInfo((IObjectPK)retValue);
            tempValue = 20 == oldInfo.getState().getValue() ? info.getAmountApproved() : this.getBudgetValue(ctx, (IObjectPK)retValue, model);
            this.setBudgetValue(ctx, (IObjectPK)retValue, model, tempValue);
            super.update(ctx, (IObjectPK)retValue, coreBaseInfo);
            return retValue;
        }
        this.checkBudgetControl(ctx, (ExpenseAccountBaseBillInfo)model);
        IObjectPK retValue = super.addnew(ctx, coreBaseInfo);
        return retValue;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return super._getLogInfo(ctx, pk);
    }
}

