/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BudgetBalanceCollection;
import com.kingdee.eas.cp.bc.BudgetBalanceInfo;
import com.kingdee.eas.cp.bc.BudgetControlCollection;
import com.kingdee.eas.cp.bc.BudgetControlException;
import com.kingdee.eas.cp.bc.BudgetControlFactory;
import com.kingdee.eas.cp.bc.BudgetControlInfo;
import com.kingdee.eas.cp.bc.ExpAccException;
import com.kingdee.eas.cp.bc.ExpenseAccountBaseBillInfo;
import com.kingdee.eas.cp.bc.ExpenseSortInfo;
import com.kingdee.eas.cp.bc.IBudgetControl;
import com.kingdee.eas.cp.bc.IItemApprovedTree;
import com.kingdee.eas.cp.bc.IVoucherTemplate;
import com.kingdee.eas.cp.bc.IVoucherTemplateEntry;
import com.kingdee.eas.cp.bc.ItemApprovedTreeCollection;
import com.kingdee.eas.cp.bc.ItemApprovedTreeFactory;
import com.kingdee.eas.cp.bc.ItemApprovedTreeInfo;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.VoucherTempException;
import com.kingdee.eas.cp.bc.VoucherTemplateCollection;
import com.kingdee.eas.cp.bc.VoucherTemplateEntryCollection;
import com.kingdee.eas.cp.bc.VoucherTemplateEntryFactory;
import com.kingdee.eas.cp.bc.VoucherTemplateEntryInfo;
import com.kingdee.eas.cp.bc.VoucherTemplateFactory;
import com.kingdee.eas.cp.bc.VoucherTemplateInfo;
import com.kingdee.eas.cp.bc.app.AbstractTravelAccountWKFacadeControllerBean;
import com.kingdee.eas.cp.bc.util.ReadBudgetType;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.log4j.Logger;

public class TravelAccountWKFacadeControllerBean
extends AbstractTravelAccountWKFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.TravelAccountWKFacadeControllerBean");
    private static final int ARRAYLENGTH = 36;
    private static final String TARGETPATH = "f:" + File.separator + "target.xls";

    @Override
    protected void _audit(Context ctx, IObjectValue billInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void _setPassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, StateEnum.CHECKED);
    }

    @Override
    protected void _setUnpassState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, StateEnum.CHECKFAILD);
        this.UnpassState_reverseDate(ctx, billId);
    }

    @Override
    protected void _setCancelState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
    }

    @Override
    protected void _setAlreadyVoucherState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, StateEnum.ALREADVOUCHER);
    }

    @Override
    protected void _setCloseState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
    }

    @Override
    protected void _setAuditingState(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        this._setState(ctx, billId, StateEnum.CHECKING);
    }

    @Override
    protected void _setState(Context ctx, BOSUuid billId, StateEnum state) throws BOSException, EASBizException {
        this.setNowState(ctx, billId, state);
    }

    protected void UnpassState_reverseDate(Context ctx, BOSUuid billId) throws BOSException, EASBizException {
        IObjectValue dataObjectTmp = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(billId.getType(), (IObjectPK)new ObjectUuidPK(billId));
        ExpenseAccountBaseBillInfo info = (ExpenseAccountBaseBillInfo)dataObjectTmp;
        ExpenseSortInfo sortInfo = info.getSortName();
        CostCenterOrgUnitInfo costInfo = info.getCostedDept();
        BigDecimal amountApproved = info.getAmountApproved();
        CtrlUnitInfo ctrlUnitInfo = info.getCU();
        Timestamp createTime = info.getCreateTime();
        int year = createTime.getYear() + 1900;
        int month = createTime.getMonth();
        Date currentDate = DateTimeUtils.truncateDate((Date)new Timestamp(System.currentTimeMillis()));
        int currentYear = currentDate.getYear() + 1900;
        int currentMonth = currentDate.getMonth();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ctrlUnitInfo.getId(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("yearTime", (Object)new Integer(currentYear), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isCumulate", (Object)new Boolean(true), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("controlObj.id", (Object)costInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("expenseSort.id", (Object)sortInfo.getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3 and #4");
        ev.setFilter(filter);
        BudgetControlCollection tempCollection = BudgetControlFactory.getLocalInstance(ctx).getBudgetControlCollection(ev);
        if (tempCollection.size() <= 0 || tempCollection.size() > 1) {
            return;
        }
        BudgetControlInfo bcInfo = tempCollection.get(0);
        BudgetBalanceCollection bbcCollection = bcInfo.getEntries();
        BudgetBalanceInfo bbInfo = bbcCollection.get(month);
        BudgetBalanceInfo tempInfo = null;
        BudgetBalanceInfo foreMonthInfo = null;
        BigDecimal tempBD = null;
        if (year == currentYear) {
            IBudgetControl ibc = BudgetControlFactory.getLocalInstance(ctx);
            if (!bcInfo.isIsCumulate()) {
                tempInfo = bbcCollection.get(month);
                bbcCollection.get(month).setMonthBalance(tempInfo.getMonthBalance().add(amountApproved));
                bbcCollection.get(month).setFreezeAccount(tempInfo.getFreezeAccount().subtract(amountApproved));
                BigDecimal tempBig = tempInfo.getMonthAccount().multiply(new BigDecimal(String.valueOf(11 - currentMonth)));
                tempBig = tempBig.add(tempInfo.getMonthBalance().add(amountApproved));
                bcInfo.setYearBalance(tempBig);
                ibc.update((IObjectPK)new ObjectUuidPK(bcInfo.getId()), (CoreBaseInfo)bcInfo);
            } else {
                bcInfo.setYearBalance(bcInfo.getYearBalance().add(amountApproved));
                if (month == currentMonth) {
                    tempInfo = bbcCollection.get(month);
                    bbcCollection.get(month).setMonthBalance(tempInfo.getMonthBalance().add(amountApproved));
                    bbcCollection.get(month).setFreezeAccount(tempInfo.getFreezeAccount().subtract(amountApproved));
                    ibc.update((IObjectPK)new ObjectUuidPK(bcInfo.getId()), (CoreBaseInfo)bcInfo);
                } else {
                    for (int i = month; i <= currentMonth; ++i) {
                        if (i == month) {
                            tempInfo = bbcCollection.get(i);
                            bbcCollection.get(i).setMonthBalance(tempInfo.getMonthBalance().add(amountApproved));
                            bbcCollection.get(i).setFreezeAccount(tempInfo.getFreezeAccount().subtract(amountApproved));
                            continue;
                        }
                        tempInfo = bbcCollection.get(i);
                        if (!tempInfo.isIsAdd()) {
                            foreMonthInfo = bbcCollection.get(i - 1);
                            tempBD = foreMonthInfo.getMonthBalance();
                            bbcCollection.get(i).setMonthBalance(tempInfo.getMonthBalance().add(tempBD));
                            bbcCollection.get(i).setIsAdd(true);
                            continue;
                        }
                        bbcCollection.get(i).setMonthBalance(tempInfo.getMonthBalance().add(amountApproved));
                    }
                    ibc.update((IObjectPK)new ObjectUuidPK(bcInfo.getId()), (CoreBaseInfo)bcInfo);
                }
            }
        } else {
            throw new BudgetControlException(BudgetControlException.AUDIT_PASS_YEAR);
        }
    }

    @Override
    protected boolean _dataToExcel(Context ctx, String fileName, String querySql) throws BOSException, BizCollException, EASBizException {
        try {
            this.dataToExcel(this.getResultData(ctx, querySql), fileName, TARGETPATH);
        }
        catch (RowsExceededException e) {
            throw new VoucherTempException(VoucherTempException.FILE_READ_ERROR);
        }
        catch (WriteException e) {
            throw new VoucherTempException(VoucherTempException.FILE_READ_ERROR);
        }
        catch (BiffException e) {
            throw new VoucherTempException(VoucherTempException.FILE_READ_ERROR);
        }
        catch (SQLException e) {
            throw new VoucherTempException(VoucherTempException.DB_ACCESS_ERROR);
        }
        catch (IOException e) {
            throw new VoucherTempException(VoucherTempException.FILE_READ_ERROR);
        }
        return true;
    }

    private void setNowState(Context ctx, BOSUuid billId, StateEnum state) throws BOSException, EASBizException {
        IObjectValue dataObjectTmp = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(billId.getType(), (IObjectPK)new ObjectUuidPK(billId));
        BOSObjectType type = billId.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String userId = ctx.getCaller().toString();
        EntityObjectInfo vo = loader.getEntity(type);
        String table = vo.getTable().getName();
        StringBuffer sql = new StringBuffer();
        sql.append("update ");
        sql.append(table);
        sql.append(" set FState=");
        String nowTime = this.getTime().toString();
        sql.append(state.getValue());
        if (StateEnum.CHECKING.equals((Object)state) || StateEnum.CHECKED.equals((Object)state) || StateEnum.CHECKFAILD.equals((Object)state)) {
            sql.append(", FAuditorID='");
            sql.append(userId);
            sql.append("'");
            sql.append(" ,FAuditDate='");
            sql.append(nowTime);
            sql.append("'");
        }
        sql.append(" where FID='");
        sql.append(billId.toString());
        sql.append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void setNowState(Context ctx, BOSUuid billId, BOSUuid auditerID, StateEnum state) throws BOSException, EASBizException {
        IObjectValue dataObjectTmp = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(billId.getType(), (IObjectPK)new ObjectUuidPK(billId));
        BOSObjectType type = billId.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String userId = auditerID.toString();
        EntityObjectInfo vo = loader.getEntity(type);
        String table = vo.getTable().getName();
        StringBuffer sql = new StringBuffer();
        sql.append("update ");
        sql.append(table);
        sql.append(" set FState=");
        String nowTime = this.getTime().toString();
        sql.append(state.getValue());
        if (StateEnum.CHECKING.equals((Object)state) || StateEnum.CHECKED.equals((Object)state) || StateEnum.CHECKFAILD.equals((Object)state)) {
            sql.append(", FAuditorID='");
            sql.append(userId);
            sql.append("'");
            sql.append(" ,FAuditDate='");
            sql.append(nowTime);
            sql.append("'");
        }
        sql.append(" where FID='");
        sql.append(billId.toString());
        sql.append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private ArrayList getResultData(Context ctx, String querySql) {
        ArrayList<String[]> totalList = new ArrayList<String[]>();
        String[] arrCre = null;
        String[] arrDeb = null;
        IRowSet rowSet = null;
        String tempString = null;
        try {
            int total = 1;
            rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql);
            while (rowSet.next()) {
                arrCre = new String[36];
                arrDeb = new String[36];
                for (int i = 0; i < 5; ++i) {
                    if (i == 4) {
                        arrCre[i] = new Integer(total).toString();
                        arrDeb[i] = new Integer(total).toString();
                        continue;
                    }
                    arrCre[i] = tempString = rowSet.getString(i + 1);
                    arrDeb[i] = tempString;
                }
                arrDeb[5] = rowSet.getString(6);
                arrDeb[6] = rowSet.getString(7);
                arrCre[5] = rowSet.getString(8);
                arrCre[6] = rowSet.getString(9);
                for (int j = 7; j < 36; ++j) {
                    arrCre[j] = tempString = rowSet.getString(j + 3);
                    arrDeb[j] = tempString;
                }
                arrCre[11] = "0";
                arrDeb[10] = "0";
                arrCre[31] = "0";
                arrDeb[31] = "1";
                totalList.add(arrCre);
                totalList.add(arrDeb);
                ++total;
            }
        }
        catch (Exception e) {
            MsgBox.showInfo((String)ResourceBase.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"43_TravelAccountWKFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        return totalList;
    }

    private void dataToExcel(List list, String fileName, String targetFile) throws EASBizException, RowsExceededException, WriteException, SQLException, BiffException, IOException {
        ArrayList dataList = (ArrayList)list;
        if (dataList == null || dataList.size() <= 0) {
            throw new VoucherTempException(VoucherTempException.PAYFORMAT_NOT_EXIT);
        }
        String[] cellArray = this.readExcel(fileName);
        String[] arr2 = null;
        Workbook rw = Workbook.getWorkbook((File)new File(fileName));
        WritableWorkbook wwb = Workbook.createWorkbook((File)new File(targetFile), (Workbook)rw);
        WritableSheet ws = null;
        ws = wwb.createSheet("Page1", 1);
        Label labelA = null;
        Number labelN = null;
        Object df = null;
        Object wcfDF = null;
        Object labelDTF = null;
        Object df1 = null;
        Object wcfDF1 = null;
        Object labelDTF1 = null;
        int rows = 0;
        boolean cols = false;
        int m = cellArray.length;
        for (int j = 0; j < m; ++j) {
            labelA = new Label(j, rows, cellArray[j]);
            ws.addCell((WritableCell)labelA);
        }
        ++rows;
        for (String[] arr2 : dataList) {
            int n = arr2.length;
            block5: for (int i = 0; i < n; ++i) {
                switch (i) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 26: 
                    case 27: 
                    case 30: 
                    case 31: 
                    case 33: {
                        labelN = arr2[i].equals("") ? new Number(i, rows, 0.0) : (arr2[i].length() > 1 && arr2[i].indexOf(".") > 0 ? new Number(i, rows, Double.parseDouble(arr2[i])) : new Number(i, rows, (double)Integer.parseInt(arr2[i])));
                        ws.addCell((WritableCell)labelN);
                        continue block5;
                    }
                    default: {
                        labelA = new Label(i, rows, arr2[i]);
                        ws.addCell((WritableCell)labelA);
                    }
                }
            }
            ++rows;
        }
        wwb.write();
        wwb.close();
    }

    private String[] readExcel(String fileName) throws EASBizException {
        FileInputStream is = null;
        Workbook rwb = null;
        String[] cellArray = null;
        try {
            is = new FileInputStream(fileName);
            rwb = Workbook.getWorkbook((InputStream)is);
            Sheet rs = rwb.getSheet(0);
            Object cell = null;
            int length = rs.getRows();
            cellArray = new String[length - 4];
            for (int i = 4; i <= length - 1; ++i) {
                cellArray[i - 4] = rs.getCell(1, i).getContents();
            }
            rwb.close();
            ((InputStream)is).close();
        }
        catch (IOException e) {
            throw new VoucherTempException(VoucherTempException.FILE_NOT_EXIT_OR_ERROR);
        }
        catch (BiffException ee) {
            throw new VoucherTempException(VoucherTempException.FILE_READ_ERROR);
        }
        return cellArray;
    }

    private boolean dataToVoucher(String targetFile, int method, String sa) {
        int mark = -1;
        return mark != 0;
    }

    public native int callCom(String var1, int var2, String var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] _getBudgetNumber(Context ctx, ExpenseSortInfo expenseSort, PersonInfo perInfo, CostCenterOrgUnitInfo costInfo) throws BOSException, EASBizException {
        String[] tempArr = new String[]{"", ""};
        String[] tempAcc = null;
        if (expenseSort == null || perInfo == null && costInfo == null) {
            return tempArr;
        }
        tempAcc = this.getDetailAccount(ctx, expenseSort);
        if (tempAcc == null || "".equals(tempAcc[0]) || "".equals(tempAcc[1])) {
            return tempArr;
        }
        Connection conn = null;
        try {
            conn = this.getConn(ctx);
            if (conn == null) {
                throw new ExpAccException(ExpAccException.LINK_K3_ERROR);
            }
            tempArr[0] = this.getDetailBudget(ctx, conn, tempAcc[0], perInfo, costInfo, expenseSort);
            tempArr[1] = this.getDetailBudget(ctx, conn, tempAcc[1], perInfo, costInfo, expenseSort);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        return tempArr;
    }

    protected String[] getDetailAccount(Context ctx, ExpenseSortInfo expenseSort) throws ExpAccException, BOSException {
        String[] tempAccount = new String[]{"", ""};
        IVoucherTemplateEntry iVou = VoucherTemplateEntryFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("expenseType.id", (Object)expenseSort.getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 ");
        ev.setFilter(filter);
        VoucherTemplateEntryCollection vteCollection = iVou.getVoucherTemplateEntryCollection(ev);
        int size = vteCollection.size();
        if (size <= 0) {
            return tempAccount;
        }
        if (size > 1) {
            throw new ExpAccException(ExpAccException.CU_EXIST_SAME_VOUTEMPLATE);
        }
        VoucherTemplateEntryInfo vteInfo = vteCollection.get(0);
        tempAccount[0] = vteInfo.getCreditAccountNumber();
        tempAccount[1] = vteInfo.getDebitAccountNumber();
        return tempAccount;
    }

    private String getDetailBudget(Context ctx, Connection conn, String budgetNumber, PersonInfo perInfo, CostCenterOrgUnitInfo costInfo, ExpenseSortInfo sortInfo) throws BOSException {
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("   select \tv1.faccountid  AS faccountid, v1.fnumber AS fnumber,\t\t\t\t\t");
        tempSql.append("\t\t\tv1.fname AS fname, u1.fitemclassid AS fitemclassid, u2.fname AS fname \t");
        tempSql.append(" \tfrom \tt_account v1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        tempSql.append("    inner join t_ItemDetailv\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        tempSql.append("\t\t\tu1 on (v1.fdetailid > 0 and v1.fdetailid = u1.fdetailid) \t\t\t\t");
        tempSql.append(" \tinner join t_itemclass\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        tempSql.append("\t\t\tu2 on (u1.fitemclassid = u2.fitemclassid)\t\t\t\t\t\t\t\t");
        tempSql.append(" \twhere  v1.FNumber = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        String seleSql = tempSql.toString();
        ResultSet rs = null;
        Object stmt = null;
        PreparedStatement pStmt = null;
        try {
            pStmt = conn.prepareStatement(seleSql);
            pStmt.setString(1, budgetNumber);
            rs = pStmt.executeQuery();
        }
        catch (SQLException e1) {
            logger.error((Object)e1.getMessage());
        }
        String tempStr = null;
        StringBuffer tempBufferStr = new StringBuffer();
        int fitemclassid = -111;
        try {
            if (rs != null) {
                while (rs.next()) {
                    fitemclassid = rs.getInt("fitemclassid");
                    if (fitemclassid == ReadBudgetType.DEPARTIDVALUE) {
                        tempStr = this.getBudget_K3(ctx, costInfo.getId().toString());
                        if (tempStr == null || tempStr.length() <= 0) break;
                        tempBufferStr.append(tempStr);
                        tempBufferStr.append(",");
                        continue;
                    }
                    if (fitemclassid != ReadBudgetType.PERSONIDVALUE) continue;
                    tempStr = this.getBudget_K3(ctx, perInfo.getId().toString());
                    if (tempStr == null || tempStr.length() <= 0) break;
                    tempBufferStr.append(tempStr);
                    tempBufferStr.append(",");
                }
                return tempBufferStr.substring(0, tempBufferStr.lastIndexOf(",") > 0 ? tempBufferStr.lastIndexOf(",") : tempBufferStr.length());
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return tempBufferStr.toString();
    }

    private String getBudget_K3(Context ctx, String id) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("linkId", (Object)id, CompareType.EQUALS));
        filter.setMaskString("#0");
        ev.setFilter(filter);
        IItemApprovedTree itemTree = ItemApprovedTreeFactory.getLocalInstance(ctx);
        ItemApprovedTreeCollection itemCollection = itemTree.getItemApprovedTreeCollection(ev);
        ItemApprovedTreeInfo itemInfo = null;
        int itemClass = -100;
        if (itemCollection.size() > 0) {
            itemInfo = itemCollection.get(0);
            return itemInfo.getItemNumber();
        }
        return null;
    }

    private Connection getConn(Context ctx) {
        String dbIp = null;
        String dbPort = null;
        String dbName = null;
        String dbUser = null;
        String dbPwd = null;
        Connection conn = null;
        Object rs = null;
        Object stmt = null;
        Object pStmt = null;
        String seleSql = "select distinct FK3dbIP,FK3dbPort,FDbName,FK3dbUser,FK3dbPwd from T_BC_VoucherTemplate";
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0");
        ev.setFilter(filter);
        try {
            IVoucherTemplate ivoucher = VoucherTemplateFactory.getLocalInstance(ctx);
            VoucherTemplateCollection vouCollection = ivoucher.getVoucherTemplateCollection(ev);
            int size = vouCollection.size();
            if (size > 0 && size <= 1) {
                VoucherTemplateInfo tempInfo = vouCollection.get(0);
                dbIp = tempInfo.getK3dbIP();
                dbPort = tempInfo.getK3dbPort();
                dbName = tempInfo.getDbName();
                dbUser = tempInfo.getK3dbUser();
                dbPwd = tempInfo.getK3dbPwd();
            }
        }
        catch (BOSException e1) {
            logger.error((Object)e1.getMessage());
        }
        String dbDriver = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
        String url = "jdbc:microsoft:sqlserver://" + dbIp + ":" + dbPort + ";DatabaseName=" + dbName;
        try {
            Class.forName(dbDriver).newInstance();
            conn = DriverManager.getConnection(url, dbUser, dbPwd);
        }
        catch (Exception e) {
            return null;
        }
        return conn;
    }

    @Override
    protected void _setBudget(Context ctx, BOSUuid billId, BigDecimal budgetValue) throws BOSException, EASBizException {
        IObjectValue dataObjectTmp = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(billId.getType(), (IObjectPK)new ObjectUuidPK(billId));
        BOSObjectType type = billId.getType();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String userId = ctx.getCaller().toString();
        EntityObjectInfo vo = loader.getEntity(type);
        String table = vo.getTable().getName();
        String nowTime = this.getTime().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("update ");
        sql.append(table);
        sql.append(" set FAmountApproved = ");
        sql.append(budgetValue);
        sql.append(", FAuditorID='");
        sql.append(userId);
        sql.append("'");
        sql.append(" ,FAuditDate='");
        sql.append(nowTime);
        sql.append("'");
        sql.append(",FLastUpdateUserID='");
        sql.append(userId);
        sql.append("'");
        sql.append(" ,FLastUpdateTime='");
        sql.append(nowTime);
        sql.append("'");
        sql.append(" where FID='");
        sql.append(billId.toString());
        sql.append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDetailAccHasBudget(Context ctx, String detailBudget, int itemClassID) throws BOSException, EASBizException {
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("   select \tv1.faccountid  AS faccountid, v1.fnumber AS fnumber,\t\t\t\t\t");
        tempSql.append("\t\t\tv1.fname AS fname, u1.fitemclassid AS fitemclassid, u2.fname AS fname \t");
        tempSql.append(" \tfrom \tt_account v1 \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        tempSql.append("    inner join t_ItemDetailv\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        tempSql.append("\t\t\tu1 on (v1.fdetailid > 0 and v1.fdetailid = u1.fdetailid) \t\t\t\t");
        tempSql.append(" \tinner join t_itemclass\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        tempSql.append("\t\t\tu2 on (u1.fitemclassid = u2.fitemclassid)\t\t\t\t\t\t\t\t");
        tempSql.append(" \twhere  v1.FNumber = ? \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t");
        String seleSql = tempSql.toString();
        Connection conn = null;
        ResultSet rs = null;
        Object stmt = null;
        PreparedStatement pStmt = null;
        try {
            conn = this.getConn(ctx);
            pStmt = conn.prepareStatement(seleSql);
            pStmt.setString(1, detailBudget);
            rs = pStmt.executeQuery();
            Object tempStr = null;
            int fitemclassid = -111;
            while (rs.next()) {
                fitemclassid = rs.getInt("fitemclassid");
                if (itemClassID != fitemclassid) continue;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e1) {
                rs = null;
            }
            try {
                if (pStmt != null) {
                    pStmt.close();
                }
            }
            catch (Exception e2) {
                pStmt = null;
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e3) {
                conn = null;
            }
        }
        return false;
    }

    @Override
    protected boolean[] _checkAccHasBudget(Context ctx, ExpenseSortInfo expenseSort, int itemClassID) throws BOSException, EASBizException {
        boolean[] mark = new boolean[]{false, false};
        String[] tempAccount = this.getDetailAccount(ctx, expenseSort);
        mark[0] = this.checkDetailAccHasBudget(ctx, tempAccount[0], itemClassID);
        mark[1] = this.checkDetailAccHasBudget(ctx, tempAccount[1], itemClassID);
        return mark;
    }

    @Override
    protected void _setUnpassState(Context ctx, BOSUuid billID, BOSUuid auditerID) throws BOSException, EASBizException {
        this.setNowState(ctx, billID, auditerID, StateEnum.CHECKFAILD);
    }
}

