/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.TravelAreaInfo;
import com.kingdee.eas.cp.bc.app.AbstractTravelAreaControllerBean;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TravelAreaControllerBean
extends AbstractTravelAreaControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.TravelAreaControllerBean");

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkInfo(ctx, model);
        this.checkNumberDup(ctx, (DataBaseInfo)model);
        super._update(ctx, pk, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkInfo(ctx, model);
        this._checkNumberDup(ctx, model);
        return super._save(ctx, model);
    }

    private void checkInfo(Context ctx, IObjectValue model) throws EASBizException {
        TravelAreaInfo info = (TravelAreaInfo)model;
        if (StringUtils.isBlank((String)info.getNumber())) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        if (StringUtils.isBlank((String)info.getName())) {
            throw new EASBizException(EASBizException.CHECKNAMEBLANK);
        }
    }

    @Override
    protected List _getCityList(Context ctx, String travelAreaId) throws BOSException, EASBizException {
        ArrayList cityList = new ArrayList();
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.TravelAreaWithEntryQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItemCollection = filterInfo.getFilterItems();
        filterItemCollection.add(new FilterItemInfo("id", (Object)travelAreaId));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        exec.setObjectView(entityViewInfo);
        IRowSet rowSet = exec.executeQuery();
        try {
            while (rowSet.next()) {
                HashMap<String, String> city = new HashMap<String, String>();
                city.put("name", (String)rowSet.getObject("city.name"));
                city.put("id", (String)rowSet.getObject("city.id"));
                cityList.add(city);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return cityList;
    }

    @Override
    protected List _getCityName(Context ctx, List travelAreaIds) throws BOSException, EASBizException {
        ArrayList<String> result = new ArrayList<String>();
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.TravelAreaWithEntryQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        for (Object id : travelAreaIds) {
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection filterItemCollection = filterInfo.getFilterItems();
            filterItemCollection.add(new FilterItemInfo("id", (Object)id.toString()));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            exec.setObjectView(entityViewInfo);
            IRowSet rowSet = exec.executeQuery();
            StringBuffer cityName = new StringBuffer();
            try {
                while (rowSet.next()) {
                    cityName.append((String)rowSet.getObject("city.name"));
                    cityName.append("\u3001");
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
            result.add(cityName.toString().replaceAll("\u3001$", ""));
        }
        return result;
    }

    @Override
    protected Map _getCusPermission(Context ctx, List cuIds) throws BOSException, EASBizException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        HashMap<String, String> result = new HashMap<String, String>();
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        for (int i = 0; i < cuIds.size(); ++i) {
            boolean isHasEditPermission = false;
            isHasEditPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(user.getId()), (IObjectPK)new ObjectUuidPK(cuIds.get(i).toString()), "cp_bc_travelAreaEdit");
            map.put(cuIds.get(i).toString(), isHasEditPermission);
        }
        String json = JSONUtils.convertObjectToJson((Context)ctx, map);
        result.put("permissions", json);
        return result;
    }
}

