/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizAccountBillPayEntryFactory;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizAccountOutBillPayEntryFactory;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollPayEntryInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CollectionAccountFactory;
import com.kingdee.eas.cp.bc.CollectionAccountInfo;
import com.kingdee.eas.cp.bc.CommonWebUtilFacadeFactory;
import com.kingdee.eas.cp.bc.CreateVoucherRecordFactory;
import com.kingdee.eas.cp.bc.CreateVoucherRecordInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillPayEntryFactory;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillPayEntryFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillPayEntryFactory;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.IBizCollPayEntry;
import com.kingdee.eas.cp.bc.ICreateVoucherRecord;
import com.kingdee.eas.cp.bc.LoanBillInfo;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillPayEntryFactory;
import com.kingdee.eas.cp.bc.VoucherTypeEnum;
import com.kingdee.eas.cp.bc.app.AbstractUpgradeBillFacadeControllerBean;
import com.kingdee.eas.cp.bc.upgrade.datatask.UpgradeTaskSchedule;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UpgradeBillFacadeControllerBean
extends AbstractUpgradeBillFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.UpgradeBillFacadeControllerBean");

    @Override
    protected String _upgradeBillPayEntry(Context ctx, String billType) throws BOSException, EASBizException {
        String taskId = "upgrade" + billType + "PayEntry";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("upgradeAdapter", "com.kingdee.eas.cp.bc.upgrade.datatask.UpgradeBillPayEntryAdapter");
        paramMap.put("billType", billType);
        UpgradeTaskSchedule.addUpgradeTask(ctx, taskId, paramMap);
        return taskId;
    }

    @Override
    protected boolean _updatePayEntry(Context ctx, String billId) throws BOSException, EASBizException {
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK objectUuidPK = new ObjectUuidPK(billId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("entries.exchangerate"));
        selector.add(new SelectorItemInfo("entries.convertMode"));
        selector.add(new SelectorItemInfo("entries.exchangeRatePrecision"));
        selector.add(new SelectorItemInfo("entries.currencyType.id"));
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)iDynamicObject.getValue(objectUuidPK.getObjectType(), (IObjectPK)objectUuidPK);
        IBizCollPayEntry iBizCollPayEntry = null;
        if (billInfo instanceof DailyLoanBillInfo) {
            iBizCollPayEntry = DailyLoanBillPayEntryFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof EvectionLoanBillInfo) {
            iBizCollPayEntry = EvectionLoanBillPayEntryFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof BizAccountBillInfo) {
            iBizCollPayEntry = BizAccountBillPayEntryFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof TravelAccountBillInfo) {
            iBizCollPayEntry = TravelAccountBillPayEntryFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof BizAccountOutBillInfo) {
            iBizCollPayEntry = BizAccountOutBillPayEntryFactory.getLocalInstance(ctx);
        } else if (billInfo instanceof DailyPurchaseAccountBillInfo) {
            iBizCollPayEntry = DailyPurchaseAccountBillPayEntryFactory.getLocalInstance(ctx);
        } else {
            return true;
        }
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance((Context)ctx);
        String queryOql = "SELECT NUMBER, BILLSTATUS, PAYERACCOUNT.ID, PAYERACCOUNTBANK.ID, CURRENCY.ID, PAYEEID, PAYEENAME, ENTRIES.AMOUNT, COMPANY.ID WHERE SOURCEBILLID = '%s'";
        PaymentBillCollection paymentBills = iPaymentBill.getPaymentBillCollection(String.format(queryOql, billId));
        int ks = paymentBills.size();
        for (int k = 0; k < ks; ++k) {
            PaymentBillInfo paymentBillInfo = paymentBills.get(k);
            String payNumber = paymentBillInfo.getNumber();
            FilterInfo existFilter = new FilterInfo();
            existFilter.getFilterItems().add(new FilterItemInfo("payBillNumber", (Object)payNumber));
            if (iBizCollPayEntry.exists(existFilter) || BillStatusEnum.SAVE.equals((Object)paymentBillInfo.getBillStatus())) continue;
            AccountViewInfo payerAccount = paymentBillInfo.getPayerAccount();
            AccountBankInfo payerAccountBank = paymentBillInfo.getPayerAccountBank();
            CurrencyInfo payCurrency = paymentBillInfo.getCurrency();
            CompanyOrgUnitInfo company = paymentBillInfo.getCompany();
            PaymentBillEntryCollection paymentBillEntries = paymentBillInfo.getEntries();
            AbstractObjectCollection billEntries = (AbstractObjectCollection)billInfo.get("entries");
            BigDecimal exchangeRate = new BigDecimal(1);
            ConvertModeEnum convertMode = ConvertModeEnum.DIRECTEXCHANGERATE;
            int exchangeRatePrecision = 4;
            BigDecimal prec = new BigDecimal(0.5);
            int js = billEntries.size();
            for (int j = 0; j < js; ++j) {
                CurrencyInfo currencyType;
                IObjectValue billEntryInfo = billEntries.getObject(j);
                CurrencyInfo currencyInfo = currencyType = billEntryInfo.get("currencyType") == null ? null : (CurrencyInfo)billEntryInfo.get("currencyType");
                if (currencyType == null || payCurrency == null) continue;
                if (currencyType.getId().toString().equals(payCurrency.getId().toString())) {
                    if (billEntryInfo.get("exchangeRate") != null) {
                        exchangeRate = (BigDecimal)billEntryInfo.get("exchangeRate");
                    }
                    if (billEntryInfo.get("convertMode") != null) {
                        convertMode = ConvertModeEnum.getEnum((int)((Integer)billEntryInfo.get("convertMode")));
                    }
                    if (billEntryInfo.get("exchangeRatePrecision") == null) continue;
                    exchangeRatePrecision = (Integer)billEntryInfo.get("exchangeRatePrecision");
                    continue;
                }
                ExchangeRateInfo exRateInfo = (ExchangeRateInfo)CommonWebUtilFacadeFactory.getLocalInstance(ctx).getExRateInfo(payCurrency.getId().toString(), null, billInfo.getApplierCompany().getId().toString(), new Date());
                if (exRateInfo == null) continue;
                exchangeRate = exRateInfo.getConvertRate();
                convertMode = exRateInfo.getConvertMode();
                exchangeRatePrecision = exRateInfo.getPrecision();
            }
            BigDecimal totalPayAmount = new BigDecimal(0);
            BigDecimal amountApproved = billInfo.getAmountApproved();
            int is = paymentBillEntries.size();
            for (int i = 0; i < is; ++i) {
                PaymentBillEntryInfo paymentBillEntryInfo = paymentBillEntries.get(i);
                BizCollPayEntryInfo bizCollPayEntryInfo = new BizCollPayEntryInfo();
                bizCollPayEntryInfo.put("bill", billInfo);
                bizCollPayEntryInfo.setPayBillNumber(payNumber);
                bizCollPayEntryInfo.setPayerAccount(payerAccount);
                bizCollPayEntryInfo.setPayerAccountBank(payerAccountBank);
                bizCollPayEntryInfo.setCurrencyType(payCurrency);
                bizCollPayEntryInfo.setPayCompany(company);
                bizCollPayEntryInfo.setExchangeRate(exchangeRate);
                bizCollPayEntryInfo.setExchangeRatePrecision(exchangeRatePrecision);
                bizCollPayEntryInfo.setConvertMode(convertMode);
                BigDecimal payAmountOri = paymentBillEntryInfo.getAmount();
                bizCollPayEntryInfo.setPayAmountOri(payAmountOri);
                bizCollPayEntryInfo.setPayerId(paymentBillInfo.getPayeeID());
                bizCollPayEntryInfo.setPayerName(paymentBillInfo.getPayeeName());
                BigDecimal payAmount = convertMode.equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE) ? payAmountOri.multiply(exchangeRate).setScale(2) : payAmountOri.divide(exchangeRate, 2);
                if (i == is - 1 && amountApproved.subtract(totalPayAmount.add(payAmount)).abs().compareTo(prec) < 0) {
                    payAmount = amountApproved.subtract(totalPayAmount);
                }
                bizCollPayEntryInfo.setPayAmount(payAmount);
                iBizCollPayEntry.addnew(bizCollPayEntryInfo);
            }
        }
        return true;
    }

    @Override
    protected int _getUpgradePayEntryProcess(Context ctx, String taskId) throws BOSException, EASBizException {
        return UpgradeTaskSchedule.getProcess(taskId);
    }

    @Override
    protected String _upgradeBillCreateVoucherRecord(Context ctx, String billType) throws BOSException, EASBizException {
        String taskId = "upgrade" + billType + "PayEntry";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("upgradeAdapter", "com.kingdee.eas.cp.bc.upgrade.datatask.UpgradeBillCreateVoucherRecordAdapter");
        paramMap.put("billType", billType);
        UpgradeTaskSchedule.addUpgradeTask(ctx, taskId, paramMap);
        return taskId;
    }

    @Override
    protected boolean _updateCreateVoucherRecord(Context ctx, IObjectValue model, Map paramMap) throws BOSException, EASBizException {
        boolean isRelaFi = new Boolean(paramMap.get("CP002").toString());
        boolean isRelaCn = new Boolean(paramMap.get("CP008").toString());
        if (!isRelaFi) {
            return true;
        }
        ICreateVoucherRecord iCreateVoucherRecord = CreateVoucherRecordFactory.getLocalInstance(ctx);
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)model;
        String billId = billInfo.getId().toString();
        StateEnum billState = billInfo.getState();
        String actionFlag = (String)billInfo.get("actionFlag");
        BigDecimal amountNotPaid = billInfo.getAmountNotPaid();
        BigDecimal amountEncashed = (BigDecimal)billInfo.get("amountEncashed");
        BigDecimal amountApproved = billInfo.getAmountApproved();
        String existOql = "SELECT ID WHERE BILLID = '%s'";
        boolean ifUpgraded = iCreateVoucherRecord.exists(String.format(existOql, billId));
        if (ifUpgraded) {
            return true;
        }
        boolean isDapVouchered = "T".equals(actionFlag) || "R".equals(actionFlag);
        IBOTRelation ibotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        ArrayList voucherIds = ibotRelation.getDestObjIdByDestType(billId, new VoucherInfo().getBOSType().toString());
        if (voucherIds.size() == 0) {
            return true;
        }
        String queryOql = "SELECT ID,NUMBER,BIZSTATUS,entries.account.isCashEquivalent,entries.account.isBank,entries.account.isCash,entries.entryDC,entries.localAmount WHERE ID IN ('%s') ORDER BY CREATETIME ASC";
        String voucherIdStr = StringUtils.join((Object[])voucherIds.toArray(), (String)"','");
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        VoucherCollection vouchers = iVoucher.getVoucherCollection(String.format(queryOql, voucherIdStr));
        boolean isVouchered = vouchers.size() > 1 || vouchers.size() == 1 && !isDapVouchered;
        boolean isReturnVouchered = false;
        BigDecimal billReturnAmount = (BigDecimal)billInfo.get("returnAmount");
        if (billReturnAmount != null && billReturnAmount.compareTo(BizCollUtil.ZERO) > 0) {
            isReturnVouchered = true;
        }
        boolean isPayVouchered = false;
        CoreBaseCollection voucherRecords = new CoreBaseCollection();
        if (StateEnum.ISSUSPENSEACCOUNT.equals((Object)billState) || StateEnum.ALREADYSUSPENSEACCOUNT.equals((Object)billState)) {
            billInfo.setIsDapVouchered(true);
            billInfo.setIsVouchered(false);
            billInfo.setState(StateEnum.CHECKED);
            VoucherInfo voucherInfo = vouchers.get(0);
            CreateVoucherRecordInfo dapVoucherRecord = new CreateVoucherRecordInfo();
            dapVoucherRecord.setVoucherID(voucherInfo.getId().toString());
            dapVoucherRecord.setVoucherNumber(voucherInfo.getNumber());
            dapVoucherRecord.setBillID(billId);
            dapVoucherRecord.setBillNumber(billInfo.getNumber());
            dapVoucherRecord.setVoucherType(VoucherTypeEnum.DAPVOUCHER);
            voucherRecords.add((CoreBaseInfo)dapVoucherRecord);
        } else if (isRelaFi && !isRelaCn) {
            if (isDapVouchered) {
                VoucherInfo dapVoucher = vouchers.get(0);
                vouchers.removeObject(0);
                CreateVoucherRecordInfo dapVoucherRecord = new CreateVoucherRecordInfo();
                dapVoucherRecord.setVoucherID(dapVoucher.getId().toString());
                dapVoucherRecord.setVoucherNumber(dapVoucher.getNumber());
                dapVoucherRecord.setBillID(billId);
                dapVoucherRecord.setBillNumber(billInfo.getNumber());
                dapVoucherRecord.setVoucherType(VoucherTypeEnum.DAPVOUCHER);
                voucherRecords.add((CoreBaseInfo)dapVoucherRecord);
            }
            if (StateEnum.ISPAYBILL.equals((Object)billState) || StateEnum.ALREADYPAYMENT.equals((Object)billState)) {
                billInfo.setIsDapVouchered(isDapVouchered);
                billInfo.setIsVouchered(true);
                billInfo.setState(StateEnum.CHECKED);
            } else if (StateEnum.ALREADYVOUCHER.equals((Object)billState)) {
                billInfo.setIsDapVouchered(isDapVouchered);
                billInfo.setIsVouchered(true);
                billInfo.setState(StateEnum.CHECKED);
            } else if (StateEnum.CLOSED.equals((Object)billState)) {
                billInfo.setIsDapVouchered(isDapVouchered);
                billInfo.setIsVouchered(isVouchered);
            }
            int is = vouchers.size();
            for (int i = 0; i < is; ++i) {
                VoucherInfo voucherInfo = vouchers.get(i);
                VoucherTypeEnum voucherType = this.getVoucherType(voucherInfo);
                CreateVoucherRecordInfo voucherRecord = new CreateVoucherRecordInfo();
                voucherRecord.setVoucherID(voucherInfo.getId().toString());
                voucherRecord.setVoucherNumber(voucherInfo.getNumber());
                voucherRecord.setBillID(billId);
                voucherRecord.setBillNumber(billInfo.getNumber());
                voucherRecord.setVoucherType(voucherType);
                voucherRecords.add((CoreBaseInfo)voucherRecord);
            }
        } else if (isRelaFi && isRelaCn) {
            if (isDapVouchered) {
                VoucherInfo dapVoucher = vouchers.get(0);
                vouchers.removeObject(0);
                CreateVoucherRecordInfo dapVoucherRecord = new CreateVoucherRecordInfo();
                dapVoucherRecord.setVoucherID(dapVoucher.getId().toString());
                dapVoucherRecord.setVoucherNumber(dapVoucher.getNumber());
                dapVoucherRecord.setBillID(billId);
                dapVoucherRecord.setBillNumber(billInfo.getNumber());
                dapVoucherRecord.setVoucherType(VoucherTypeEnum.DAPVOUCHER);
                voucherRecords.add((CoreBaseInfo)dapVoucherRecord);
            }
            if (StateEnum.ISPAYBILL.equals((Object)billState) || StateEnum.ALREADYPAYMENT.equals((Object)billState)) {
                billInfo.setIsDapVouchered(isDapVouchered);
                billInfo.setIsVouchered(isVouchered);
            } else if (StateEnum.ALREADYVOUCHER.equals((Object)billState)) {
                billInfo.setIsDapVouchered(isDapVouchered);
                billInfo.setIsVouchered(isVouchered);
                if (billInfo instanceof ExpenseAccountBillInfo) {
                    if (amountEncashed.compareTo(BizCollUtil.ZERO) > 0 && amountNotPaid.compareTo(BizCollUtil.ZERO) == 0) {
                        billInfo.setState(StateEnum.ALREADYPAYMENT);
                    } else {
                        billInfo.setState(StateEnum.CHECKED);
                    }
                } else if (billInfo instanceof LoanBillInfo) {
                    if (amountNotPaid.compareTo(BizCollUtil.ZERO) == 0) {
                        billInfo.setState(StateEnum.ALREADYPAYMENT);
                    } else {
                        billInfo.setState(StateEnum.CHECKED);
                    }
                }
            } else if (StateEnum.CLOSED.equals((Object)billState)) {
                // empty if block
            }
            int is = vouchers.size();
            for (int i = 0; i < is; ++i) {
                VoucherInfo voucherInfo = vouchers.get(i);
                CreateVoucherRecordInfo voucherRecord = new CreateVoucherRecordInfo();
                voucherRecord.setVoucherID(voucherInfo.getId().toString());
                voucherRecord.setVoucherNumber(voucherInfo.getNumber());
                voucherRecord.setBillID(billId);
                voucherRecord.setBillNumber(billInfo.getNumber());
                voucherRecord.setVoucherType(VoucherTypeEnum.VOUCHER);
                voucherRecords.add((CoreBaseInfo)voucherRecord);
                billInfo.setIsVouchered(true);
            }
        }
        if (voucherRecords.size() > 0) {
            iCreateVoucherRecord.addnewBatchData(voucherRecords);
        }
        IBizCollBillBase iBizCollBillBase = (IBizCollBillBase)BizCollUtil.getBizInterfaceByBOSUuid(ctx, billInfo.getId());
        SelectorItemCollection updateBillSelector = new SelectorItemCollection();
        updateBillSelector.add(new SelectorItemInfo("isDapVouchered"));
        updateBillSelector.add(new SelectorItemInfo("isVouchered"));
        updateBillSelector.add(new SelectorItemInfo("state"));
        iBizCollBillBase.updatePartial((CoreBaseInfo)billInfo, updateBillSelector);
        return true;
    }

    private VoucherTypeEnum getVoucherType(VoucherInfo voucher) {
        VoucherEntryInfo voucherEntry;
        AccountViewInfo account;
        VoucherTypeEnum voucherType = VoucherTypeEnum.PAYVOUCHER;
        VoucherEntryCollection voucherEntrys = voucher.getEntries();
        if (voucherEntrys == null || voucherEntrys.size() == 0) {
            return voucherType;
        }
        BigDecimal payAmount = BizCollUtil.ZERO;
        BigDecimal returnAmount = BizCollUtil.ZERO;
        int is = voucherEntrys.size();
        for (int i = 0; i < is && (account = (voucherEntry = voucherEntrys.get(i)).getAccount()) != null; ++i) {
            boolean isCashAccount = account.isIsCashEquivalent() || account.isIsBank() || account.isIsCash();
            EntryDC entryDC = voucherEntry.getEntryDC();
            BigDecimal entryAmount = voucherEntry.getLocalAmount();
            if (EntryDC.CREDIT.equals((Object)entryDC) && isCashAccount && entryAmount != null) {
                payAmount = payAmount.add(entryAmount);
                continue;
            }
            if (!EntryDC.DEBIT.equals((Object)entryDC) || !isCashAccount || entryAmount == null) continue;
            returnAmount = returnAmount.add(entryAmount);
        }
        if (payAmount.compareTo(BizCollUtil.ZERO) > 0) {
            voucherType = VoucherTypeEnum.PAYVOUCHER;
        } else if (returnAmount.compareTo(BizCollUtil.ZERO) > 0) {
            voucherType = VoucherTypeEnum.RETURNVOUCHER;
        }
        return voucherType;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _updateCollectionBeBank(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Serializable> resultMap = new HashMap<String, Serializable>();
        StringBuffer queryOql = new StringBuffer();
        queryOql.append("SELECT FID, CFBebankID, FBebankStr FROM T_BC_CollectionAccount WHERE CFBebankID IS NOT NULL");
        CollectionAccountInfo collectionAccount = null;
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        int count = 0;
        int succUpdateCount = 0;
        ArrayList<String> failIds = new ArrayList<String>();
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            rs = statement.executeQuery(queryOql.toString());
            while (rs.next()) {
                ++count;
                String billId = rs.getString("FID");
                String bebankStr = rs.getString("FBebankStr");
                String bebankId = rs.getString("CFBebankID");
                if (bebankId == null) continue;
                if (!new BEBankInfo().getBOSType().equals((Object)BOSUuid.getBOSObjectType((String)bebankId, (boolean)true))) {
                    failIds.add(billId);
                    continue;
                }
                BEBankCollection beBankColl = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection("select id, name where id='" + bebankId + "'");
                if (beBankColl.size() == 0) {
                    failIds.add(billId);
                    continue;
                }
                BEBankInfo beBankInfo = beBankColl.get(0);
                if (StringUtils.isEmpty((String)beBankInfo.getName())) {
                    logger.error((Object)("####updateCollectionBeBank--bebankId=" + bebankId + ",name=" + beBankInfo.getName()));
                    failIds.add(billId);
                    continue;
                }
                if (StringUtils.isNotEmpty((String)beBankInfo.getName()) && !beBankInfo.getName().equals(bebankStr)) {
                    ++succUpdateCount;
                    collectionAccount = new CollectionAccountInfo();
                    collectionAccount.setId(BOSUuid.read((String)billId));
                    collectionAccount.setBebankStr(beBankInfo.getName());
                    coreBaseCollection.add((CoreBaseInfo)collectionAccount);
                }
                if (coreBaseCollection.size() <= 1000) continue;
                CollectionAccountFactory.getLocalInstance(ctx).updateBatchData(coreBaseCollection);
                logger.error((Object)("####updateCollectionBeBank--count=" + count + ",succUpdateCount=" + succUpdateCount + ",failIds=" + failIds.size()));
                coreBaseCollection.clear();
            }
            if (coreBaseCollection.size() > 0) {
                CollectionAccountFactory.getLocalInstance(ctx).updateBatchData(coreBaseCollection);
                logger.error((Object)("####updateCollectionBeBank--count=" + count + ",succUpdateCount=" + succUpdateCount + ",failIds=" + failIds.size()));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
                catch (Exception e2) {
                    logger.error((Object)e2);
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        logger.error((Object)("####updateCollectionBeBank--count=" + count + ",succUpdateCount=" + succUpdateCount + ",failIds=" + failIds.size()));
        resultMap.put("count", Integer.valueOf(count));
        resultMap.put("succUpdateCount", Integer.valueOf(succUpdateCount));
        resultMap.put("failIds", failIds);
        return resultMap;
    }
}

