/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpEmpBankAccException;
import com.kingdee.eas.cp.bc.VehicleBDException;
import com.kingdee.eas.cp.bc.VehicleBaseDataCollection;
import com.kingdee.eas.cp.bc.VehicleBaseDataInfo;
import com.kingdee.eas.cp.bc.app.AbstractVehicleBaseDataControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class VehicleBaseDataControllerBean
extends AbstractVehicleBaseDataControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.VehicleBaseDataControllerBean");

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addNewCheck(ctx, (VehicleBaseDataInfo)model);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addNewCheck(ctx, (VehicleBaseDataInfo)model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberSame(ctx, pk, model);
        super._update(ctx, pk, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        block2: {
            try {
                super._delete(ctx, pk);
            }
            catch (Exception ee) {
                if (!VehicleBaseDataControllerBean.getSQLException(ee)) break block2;
                throw new VehicleBDException(VehicleBDException.VEHICLE_HAS_USED);
            }
        }
    }

    private void checkNumberSame(Context ctx, IObjectPK pk, IObjectValue model) throws ExpEmpBankAccException, EASBizException, BOSException {
        BOSUuid billId = ((VehicleBaseDataInfo)model).getId();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        ev.setFilter(filter);
        VehicleBaseDataInfo tempInfo = null;
        VehicleBaseDataCollection tempCollection = this.getVehicleBaseDataCollection(ctx, ev);
        int j = tempCollection.size();
        for (int i = 0; i < j; ++i) {
            tempInfo = tempCollection.get(i);
            if (!tempInfo.getVehNumber().equals(((VehicleBaseDataInfo)model).getVehNumber()) || tempInfo.getId().equals((Object)billId)) continue;
            throw new VehicleBDException(VehicleBDException.VEHICLE_NUMBER_NOT_REPEAT);
        }
    }

    private void addNewCheck(Context ctx, VehicleBaseDataInfo info) throws EASBizException, VehicleBDException, BOSException {
        if (this.objectIsNull(info.getVehNumber())) {
            throw new VehicleBDException(VehicleBDException.VEHICLE_NUMBER_NOT_NULL);
        }
        if (info.getVehNumber().length() > 80) {
            throw new VehicleBDException(VehicleBDException.VEHICLE_NUMBER_TOO_LONG);
        }
        this.checkVehicleNumberSame(ctx, info);
        if (this.objectIsNull(info.getName())) {
            throw new VehicleBDException(VehicleBDException.VEHICLE_NAME_NOT_NULL);
        }
        if (info.getName().length() > 80) {
            throw new VehicleBDException(VehicleBDException.VEHICLE_NAME_TOO_LONG);
        }
        if (info.getDescription() != null && info.getDescription().length() > 200) {
            throw new VehicleBDException(VehicleBDException.VEHICLE_DESC_TOO_LONG);
        }
    }

    private boolean objectIsNull(Object obj) {
        return obj == null || StringUtils.isEmpty((String)obj.toString());
    }

    private void checkVehicleNumberSame(Context ctx, VehicleBaseDataInfo info) throws BOSException, VehicleBDException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        ev.setFilter(filter);
        VehicleBaseDataInfo tempInfo = null;
        VehicleBaseDataCollection tempCollection = this.getVehicleBaseDataCollection(ctx, ev);
        int j = tempCollection.size();
        for (int i = 0; i < j; ++i) {
            tempInfo = tempCollection.get(i);
            if (!tempInfo.getVehNumber().equals(info.getVehNumber())) continue;
            throw new VehicleBDException(VehicleBDException.VEHICLE_NUMBER_NOT_REPEAT);
        }
    }

    private static boolean getSQLException(Exception e) {
        Throwable ex = null;
        for (ex = e; ex != null && ex.getCause() != ex; ex = ex.getCause()) {
            if (!(ex instanceof ObjectReferedException)) continue;
            return true;
        }
        return false;
    }
}

