/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.cp.bc.DailyLoanBillCollection;
import com.kingdee.eas.cp.bc.DailyLoanBillFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillCollection;
import com.kingdee.eas.cp.bc.EvectionLoanBillFactory;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.LoanBillInfo;
import com.kingdee.eas.cp.bc.util.MultilingualUtil;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RecordsOfLoanAndRepayment {
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.RecordsOfLoanAndRepayment");

    public List getRecordsOfLoanAndRepayment(Context ctx, Map params) throws BOSException {
        ArrayList listModel = new ArrayList();
        boolean containsHasRepay = false;
        if (params != null) {
            Object temp = params.get("containsHasRepay");
            containsHasRepay = temp != null && temp instanceof Boolean ? (Boolean)temp : false;
        }
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = this.initSelector();
        FilterInfo filter = this.contructEntityView(ctx, containsHasRepay, params);
        ev.getSelector().addObjectCollection((IObjectCollection)selector);
        ev.setFilter(filter);
        SorterItemCollection sortCols = ev.getSorter();
        SorterItemInfo tempItemInfo = new SorterItemInfo("bizReqDate");
        tempItemInfo.setSortType(SortType.ASCEND);
        sortCols.add(tempItemInfo);
        SorterItemInfo tempItemInfo1 = new SorterItemInfo("number");
        tempItemInfo1.setSortType(SortType.ASCEND);
        sortCols.add(tempItemInfo1);
        this.getDailyLoanRecords(ctx, ev, params, containsHasRepay, listModel);
        this.getEvectionLoanRecords(ctx, ev, params, containsHasRepay, listModel);
        return listModel;
    }

    public List getRecordsOfLoanAndRepayment(Context ctx, EntityViewInfo ev, Map params) throws BOSException {
        ArrayList listModel = new ArrayList();
        boolean containsHasRepay = false;
        if (params != null) {
            Object temp = params.get("containsHasRepay");
            containsHasRepay = temp != null && temp instanceof Boolean ? (Boolean)temp : false;
        }
        this.getDailyLoanRecords(ctx, ev, params, containsHasRepay, listModel);
        this.getEvectionLoanRecords(ctx, ev, params, containsHasRepay, listModel);
        return listModel;
    }

    protected List getDailyLoanRecords(Context ctx, EntityViewInfo ev, Map params, boolean containsHasRepay, List listModel) throws BOSException {
        DailyLoanBillCollection col = DailyLoanBillFactory.getLocalInstance(ctx).getDailyLoanBillCollection(ev);
        int dailyLoanSize = col.size();
        for (int i = 0; i < dailyLoanSize; ++i) {
            DailyLoanBillInfo info = col.get(i);
            this.contructModel(info, listModel, containsHasRepay, ctx);
        }
        return listModel;
    }

    protected List getEvectionLoanRecords(Context ctx, EntityViewInfo ev, Map params, boolean containsHasRepay, List listModel) throws BOSException {
        EvectionLoanBillCollection cols = EvectionLoanBillFactory.getLocalInstance(ctx).getEvectionLoanBillCollection(ev);
        int evectionLoanSize = cols.size();
        for (int i = 0; i < evectionLoanSize; ++i) {
            EvectionLoanBillInfo info = cols.get(i);
            this.contructModel(info, listModel, containsHasRepay, ctx);
        }
        return listModel;
    }

    protected FilterInfo contructEntityView(Context ctx, boolean containsHasRepay, Map params) throws BOSException {
        boolean isRelaFi = new Boolean(params.get("isRelaFi").toString());
        boolean isRelaCn = new Boolean(params.get("isRelaCn").toString());
        String applierId = params.get("applierId") != null ? params.get("applierId").toString() : null;
        Object tempDate = params.get("startDate");
        Date startDate = tempDate != null && tempDate instanceof Date ? (Date)tempDate : new Date();
        tempDate = params.get("endDate");
        Date endDate = tempDate != null && tempDate instanceof Date ? (Date)tempDate : new Date();
        endDate = this.maxDate(endDate);
        FilterInfo filter = new FilterInfo();
        FilterInfo tmpFilter = new FilterInfo();
        tmpFilter.getFilterItems().add(new FilterItemInfo("applier.id", (Object)applierId, CompareType.EQUALS));
        filter.mergeFilter(tmpFilter, "and");
        tmpFilter = new FilterInfo();
        tmpFilter.getFilterItems().add(new FilterItemInfo("bizReqDate", (Object)startDate, CompareType.GREATER_EQUALS));
        tmpFilter.getFilterItems().add(new FilterItemInfo("bizReqDate", (Object)endDate, CompareType.LESS));
        if (!containsHasRepay) {
            tmpFilter.getFilterItems().add(new FilterItemInfo("amountBalance", (Object)new BigDecimal("0.00"), CompareType.GREATER));
            tmpFilter.setMaskString("#0 and #1 and #2)");
        } else if (isRelaFi && !isRelaCn) {
            tmpFilter.getFilterItems().add(new FilterItemInfo("state", (Object)60));
            tmpFilter.getFilterItems().add(new FilterItemInfo("amountBalance", (Object)new BigDecimal("0.00"), CompareType.EQUALS));
            tmpFilter.getFilterItems().add(new FilterItemInfo("returnAmount", (Object)new BigDecimal("0.00"), CompareType.GREATER));
            tmpFilter.getFilterItems().add(new FilterItemInfo("amountUsed", (Object)new BigDecimal("0.00"), CompareType.GREATER));
            tmpFilter.getFilterItems().add(new FilterItemInfo("state", (Object)80));
            tmpFilter.getFilterItems().add(new FilterItemInfo("amountBalance", (Object)new BigDecimal("0.00"), CompareType.GREATER));
            tmpFilter.setMaskString("(#0 and #1 and (#2 and #3 and (#4 or #5) or #6 or #7))");
        } else if (isRelaCn) {
            tmpFilter.getFilterItems().add(new FilterItemInfo("state", (Object)70));
            tmpFilter.getFilterItems().add(new FilterItemInfo("amountBalance", (Object)new BigDecimal("0.00"), CompareType.EQUALS));
            tmpFilter.getFilterItems().add(new FilterItemInfo("state", (Object)80));
            tmpFilter.getFilterItems().add(new FilterItemInfo("amountBalance", (Object)new BigDecimal("0.00"), CompareType.GREATER));
            tmpFilter.setMaskString("(#0 and #1 and (#2 and #3 or #4 or #5))");
        } else {
            tmpFilter.getFilterItems().add(new FilterItemInfo("state", (Object)60));
            tmpFilter.getFilterItems().add(new FilterItemInfo("amountBalance", (Object)new BigDecimal("0.00"), CompareType.EQUALS));
            tmpFilter.getFilterItems().add(new FilterItemInfo("state", (Object)80));
            tmpFilter.getFilterItems().add(new FilterItemInfo("amountBalance", (Object)new BigDecimal("0.00"), CompareType.GREATER));
            tmpFilter.setMaskString("(#0 and #1 and (#2 and #3 or #4 or #5))");
        }
        filter.mergeFilter(tmpFilter, "and");
        return filter;
    }

    protected void contructModel(LoanBillInfo info, List listModel, boolean noReturn, Context ctx) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BigDecimal amountApproved = new BigDecimal("0.00");
        BigDecimal amountUsed = new BigDecimal("0.00");
        BigDecimal returnAmount = new BigDecimal("0.00");
        BigDecimal noReturnAmount = new BigDecimal("0.00");
        if (info != null) {
            amountApproved = info.getAmountApproved() == null ? new BigDecimal("0.00") : info.getAmountApproved();
            amountUsed = info.getAmountUsed() == null ? new BigDecimal("0.00") : info.getAmountUsed();
            returnAmount = info.getReturnAmount() == null ? new BigDecimal("0.00") : info.getReturnAmount();
            noReturnAmount = info.getAmountBalance();
            if (!noReturn && noReturnAmount.compareTo(new BigDecimal("0.00")) <= 0) {
                return;
            }
            map.put("bizReqDate", info.getBizReqDate());
            map.put("number", info.getNumber());
            map.put("amountApproved", amountApproved);
            map.put("amountUsed", amountUsed);
            map.put("returnAmount", returnAmount);
            map.put("foreseeDate", info.getForeseeDate());
            map.put("amountBalance", info.getAmountBalance());
            map.put("id", info.getId().toString());
            map.put("cause", info.getCause());
            map.put("noReturnAmount", noReturnAmount);
            listModel.add(map);
        }
    }

    protected SelectorItemCollection initSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("amountApproved"));
        selector.add(new SelectorItemInfo("bizReqDate"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("returnAmount"));
        selector.add(new SelectorItemInfo("amountUsed"));
        selector.add(new SelectorItemInfo("loanState"));
        selector.add(new SelectorItemInfo("foreseeDate"));
        selector.add(new SelectorItemInfo("amountBalance"));
        selector.add(new SelectorItemInfo("cause"));
        selector.add(new SelectorItemInfo("id"));
        return selector;
    }

    private Date maxDate(Date currentDate) {
        Date date = null;
        SimpleDateFormat DATE_FORMAT = (SimpleDateFormat)MultilingualUtil.getDateTimeFormat();
        try {
            if (DATE_FORMAT != null) {
                date = DATE_FORMAT.parse(MultilingualUtil.formatDate(currentDate) + " 23:59:59");
            } else {
                currentDate.setHours(23);
                currentDate.setMinutes(59);
                currentDate.setSeconds(59);
                date = currentDate;
            }
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage());
        }
        return date;
    }
}

