/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.control;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.StaffLevelAttriEnum;
import com.kingdee.eas.cp.bc.TravelAreaInfo;
import com.kingdee.eas.cp.bc.app.control.IControl;
import com.kingdee.eas.cp.bc.app.control.util.ControlUtil;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TravelControl
implements IControl {
    private static Logger logger = Logger.getLogger(TravelControl.class);

    @Override
    public List<Map> check(Context ctx, StaffLevelAttriEnum staffLevel, Map valuemap) {
        ArrayList<Map> resultList = new ArrayList<Map>();
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)valuemap.get("billinfo");
        CompanyOrgUnitInfo company = billInfo.getApplierCompany();
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (company != null) {
            cu = company.getCU();
        }
        try {
            if (company != null && cu == null) {
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
                cu = company.getCU();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        AbstractObjectCollection entryCollection = (AbstractObjectCollection)billInfo.get("entries");
        CoreBillEntryBaseInfo entryInfo = null;
        int is = entryCollection.size();
        for (int i = 0; i < is; ++i) {
            String personId;
            Map evectionStMap;
            HashMap<String, TravelAreaInfo> resultMap = new HashMap<String, TravelAreaInfo>();
            entryInfo = (CoreBillEntryBaseInfo)entryCollection.getObject(i);
            TravelAreaInfo areaInfo = (TravelAreaInfo)entryInfo.getObjectValue("travelArea");
            if (areaInfo == null) {
                areaInfo = ControlUtil.getTravelArea(ctx, entryInfo.getString("to"), cu.getId().toString());
                resultMap.put("areaInfo", areaInfo);
            }
            if (areaInfo == null) {
                resultList.add(null);
                continue;
            }
            CurrencyInfo currency = (CurrencyInfo)entryInfo.getObjectValue("currencyType");
            PersonInfo applier = billInfo.getApplier();
            if (currency != null && applier != null && (evectionStMap = ControlUtil.getEvectionStandard(ctx, personId = applier.getId().toString(), company, currency.getId().toString(), areaInfo.getId().toString())) != null) {
                resultMap.putAll(evectionStMap);
            }
            resultList.add(resultMap);
        }
        return resultList;
    }
}

