/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.creditcontrol.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.CreditControlSTDAssignCollection;
import com.kingdee.eas.cp.bc.CreditControlSTDAssignFactory;
import com.kingdee.eas.cp.bc.CreditControlSTDCollection;
import com.kingdee.eas.cp.bc.CreditControlSTDEntryCollection;
import com.kingdee.eas.cp.bc.CreditControlSTDEntryFactory;
import com.kingdee.eas.cp.bc.CreditControlSTDFactory;
import com.kingdee.eas.cp.bc.CreditControlSTDInfo;
import com.kingdee.eas.cp.bc.CreditControlType;
import com.kingdee.eas.cp.bc.ICreditControlSTD;
import com.kingdee.eas.cp.bc.ICreditControlSTDAssign;
import com.kingdee.eas.cp.bc.ICreditControlSTDEntry;
import com.kingdee.eas.cp.bc.IStaffReimburseLevelSetting;
import com.kingdee.eas.cp.bc.ReimburseLevelInfo;
import com.kingdee.eas.cp.bc.StaffReimburseLevelSettingCollection;
import com.kingdee.eas.cp.bc.StaffReimburseLevelSettingFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CreditControlUtil {
    public static Map getPersonUsedCredit(Context ctx, String personId) throws BOSException, SQLException {
        HashMap<String, BigDecimal> usedMap = new HashMap<String, BigDecimal>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT \n");
        sql.append("    SUM(FNumber) FNumber, FApplierID, SUM(FAmount) FAmount \n");
        sql.append("FROM ( \n ");
        sql.append("    SELECT COUNT(FID) FNumber, FApplierID, \n");
        sql.append("           SUM(CASE WHEN FState in(25,30,40) THEN FAmount-FAmountUsed-FReturnAmount ELSE FAmountApproved-FAmountUsed-FReturnAmount END) FAmount \n");
        sql.append("    FROM t_bc_dailyloanbill \n");
        sql.append("    WHERE FApplierID = '").append(personId).append("' \n");
        sql.append("          AND  FState <> 10 AND FState <> 20 AND FState <> 27 AND FState <> 80 \n");
        sql.append("          AND  FAmount > 0 \n");
        sql.append("    GROUP BY FApplierID \n");
        sql.append("    UNION ALL");
        sql.append("    SELECT COUNT(FID) number, FApplierID, \n");
        sql.append("           SUM(CASE WHEN FState in(25,30,40) THEN FAmount-FAmountUsed-FReturnAmount ELSE FAmountApproved-FAmountUsed-FReturnAmount END) FAmount \n");
        sql.append("    FROM t_bc_evectionloanbill \n");
        sql.append("    WHERE FApplierID = '").append(personId).append("' \n");
        sql.append("          AND  FState <> 10 AND FState <> 20 AND FState <> 27 AND FState <> 80 \n");
        sql.append("          AND  FAmount > 0 \n");
        sql.append("    GROUP BY FApplierID \n");
        sql.append("    ) a \n");
        sql.append("GROUP BY FApplierID \n");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (set.next()) {
            usedMap.put("count", set.getBigDecimal("FNumber"));
            usedMap.put("amount", set.getBigDecimal("FAmount"));
        }
        return usedMap;
    }

    public static Map getPersonsUsedCredit(Context ctx, String adminOrgUnitId) throws BOSException, SQLException {
        HashMap<String, BigDecimal> usedMap = new HashMap<String, BigDecimal>();
        HashMap<String, HashMap<String, BigDecimal>> result = new HashMap<String, HashMap<String, BigDecimal>>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT \n");
        sql.append("    SUM(a.FNumber) FNumber, FApplierID, SUM(a.FAmount) FAmount \n");
        sql.append("FROM ( \n ");
        sql.append("    SELECT COUNT(FID) FNumber, FApplierID, \n");
        sql.append("           SUM(CASE WHEN FState in(25,30,40) THEN FAmount-FAmountUsed-FReturnAmount ELSE FAmountApproved-FAmountUsed-FReturnAmount END) FAmount \n");
        sql.append("    FROM t_bc_dailyloanbill \n");
        sql.append("    WHERE FState <> 10 AND FState <> 20 AND FState <> 27 AND FState <> 80 \n");
        sql.append("          AND  FAmount > 0 \n");
        sql.append("    GROUP BY FApplierID \n");
        sql.append("    UNION ALL");
        sql.append("    SELECT COUNT(FID) FNumber, FApplierID, \n");
        sql.append("           SUM(CASE WHEN FState in(25,30,40) THEN FAmount-FAmountUsed-FReturnAmount ELSE FAmountApproved-FAmountUsed-FReturnAmount END) FAmount \n");
        sql.append("    FROM t_bc_evectionloanbill \n");
        sql.append("    WHERE FState <> 10 AND FState <> 20 AND FState <> 27 AND FState <> 80 \n");
        sql.append("          AND  FAmount > 0 \n");
        sql.append("    GROUP BY FApplierID \n");
        sql.append("    ) a \n");
        sql.append("    INNER JOIN T_ORG_PositionMember AS positionMember \n");
        sql.append("          ON a.FApplierID = positionMember.FPersonID \n");
        sql.append("    INNER JOIN T_ORG_Position AS position \n");
        sql.append("          ON positionMember.FPositionID = position.FID \n");
        sql.append("WHERE position.FAdminOrgUnitID = '").append(adminOrgUnitId).append("' \n");
        sql.append("GROUP BY FApplierID \n");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (set.next()) {
            usedMap.put("count", set.getBigDecimal("FNumber"));
            usedMap.put("amount", set.getBigDecimal("FAmount"));
            result.put(set.getString("FApplierID"), usedMap);
        }
        return result;
    }

    public static IRowSet getPersonOverdueLoans(Context ctx, String personId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT \n");
        sql.append("     FID, FNumber, FForeseeDate, FApplierID\n");
        sql.append("FROM ( \n ");
        sql.append("    SELECT FID, FNumber, FForeseeDate, FApplierID \n");
        sql.append("    FROM t_bc_dailyloanbill \n");
        sql.append("    WHERE FForeseeDate < GetDate() \n");
        sql.append("          AND  FApplierID = '").append(personId).append("' \n");
        sql.append("          AND  FState in(45,60,65,70,110,115) \n");
        sql.append("    UNION ALL");
        sql.append("    SELECT FID, FNumber, FForeseeDate, FApplierID \n");
        sql.append("    FROM t_bc_evectionloanbill \n");
        sql.append("    WHERE FForeseeDate < GetDate() \n");
        sql.append("          AND  FApplierID = '").append(personId).append("' \n");
        sql.append("          AND  FState in(45,60,65,70,110,115) \n");
        sql.append("    ) a \n");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (set.size() > 0) {
            return set;
        }
        return null;
    }

    public static Map<String, Object> checkPersonCredit(Context ctx, String personId, BigDecimal amount, String creditControlSTDId) throws EASBizException, BOSException, SQLException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean isStop = false;
        StringBuffer errorString = new StringBuffer();
        if (personId == null || amount == null) {
            return null;
        }
        CreditControlSTDInfo creditInfo = null;
        if (StringUtils.isNotBlank((String)creditControlSTDId)) {
            ICreditControlSTD creditControlFactory = CreditControlSTDFactory.getLocalInstance(ctx);
            creditInfo = creditControlFactory.getCreditControlSTDInfo((IObjectPK)new ObjectUuidPK(creditControlSTDId));
        } else {
            creditInfo = CreditControlUtil.getCreditControlSTDByPerson(ctx, personId);
        }
        if (creditInfo == null) {
            return null;
        }
        if (creditInfo.getNumberCtrl().equals((Object)CreditControlType.NOTPROMPT) && creditInfo.getQuotaCtrl().equals((Object)CreditControlType.NOTPROMPT) && creditInfo.getQuotaCtrl().equals((Object)CreditControlType.NOTPROMPT)) {
            return null;
        }
        Map usedMap = null;
        if (!creditInfo.getQuotaCtrl().equals((Object)CreditControlType.NOTPROMPT)) {
            usedMap = CreditControlUtil.getPersonUsedCredit(ctx, personId);
            BigDecimal usedAmount = (BigDecimal)usedMap.get("amount");
            result.put("usedAmount", usedAmount);
            result.put("stdAmount", creditInfo.getQuotaCtrlVal());
            Boolean ifOverAmount = usedAmount.add(amount).compareTo(creditInfo.getQuotaCtrlVal()) > 0;
            result.put("ifOverAmount", ifOverAmount);
            result.put("ifStrictAmount", creditInfo.getQuotaCtrl().equals((Object)CreditControlType.STRICT));
        }
        if (!creditInfo.getNumberCtrl().equals((Object)CreditControlType.NOTPROMPT)) {
            if (usedMap == null) {
                usedMap = CreditControlUtil.getPersonUsedCredit(ctx, personId);
            }
            BigDecimal usedCount = (BigDecimal)usedMap.get("count");
            result.put("usedCount", usedCount);
            BigDecimal stdCount = creditInfo.getNumberCtrlVal();
            result.put("stdCount", stdCount);
            Boolean ifOverCount = usedCount.compareTo(stdCount) > 0;
            result.put("ifOverCount", ifOverCount);
            result.put("ifStrictCount", creditInfo.getNumberCtrl().equals((Object)CreditControlType.STRICT));
        }
        if (!creditInfo.getTermCtrl().equals((Object)CreditControlType.NOTPROMPT)) {
            IRowSet personOverdueLoans = CreditControlUtil.getPersonOverdueLoans(ctx, personId);
            int termCount = personOverdueLoans.size();
            result.put("term", termCount);
            result.put("ifStrictTerm", creditInfo.getTermCtrl().equals((Object)CreditControlType.STRICT));
        }
        return result;
    }

    public static CreditControlSTDInfo getCreditControlSTDByPerson(Context context, String personId) throws BOSException, EASBizException {
        String queryReimburseLevelIdOql;
        if (StringUtils.isEmpty((String)personId)) {
            return null;
        }
        CreditControlSTDInfo creditControlSTDInfo = null;
        ICreditControlSTDEntry creditControlSTDEntryFactory = CreditControlSTDEntryFactory.getLocalInstance(context);
        StringBuffer queryCreditControlSTDOql = new StringBuffer();
        queryCreditControlSTDOql.append("select parent.id, parent.termCtrl, parent.termCtrlVal, ").append("parent.numberCtrl, parent.numberCtrlVal, ").append("parent.quotaCtrl, parent.quotaCtrlVal ");
        String querySql = queryCreditControlSTDOql.toString() + "where person.id = '" + personId + "' ";
        CreditControlSTDEntryCollection creditControlSTDEntryCollection = creditControlSTDEntryFactory.getCreditControlSTDEntryCollection(querySql);
        if (creditControlSTDEntryCollection.size() != 0) {
            creditControlSTDInfo = creditControlSTDEntryCollection.get(0).getParent();
            return creditControlSTDInfo;
        }
        IPerson personFactory = PersonFactory.getLocalInstance((Context)context);
        AdminOrgUnitInfo primaryAdminOrgUnit = personFactory.getPrimaryAdminOrgUnit(BOSUuid.read((String)personId));
        IOrgUnitRelation orgUnitRelationFactory = OrgUnitRelationFactory.getLocalInstance((Context)context);
        OrgUnitCollection toUnits = orgUnitRelationFactory.getToUnit(primaryAdminOrgUnit.getId().toString(), 0, 1);
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)toUnits.get(0);
        String companyOrgUnitId = companyOrgUnitInfo.getId().toString();
        IStaffReimburseLevelSetting staffReimburseLevelSettingFactory = StaffReimburseLevelSettingFactory.getLocalInstance(context);
        StaffReimburseLevelSettingCollection staffReimLevelSettingInfos = staffReimburseLevelSettingFactory.getStaffReimburseLevelSettingCollection(queryReimburseLevelIdOql = "select reimburseLevel.id where person.id = '" + personId + "'");
        if (staffReimLevelSettingInfos.size() == 0) {
            return null;
        }
        ReimburseLevelInfo reimburseLevelInfo = staffReimLevelSettingInfos.get(0).getReimburseLevel();
        String reimburseLevelId = reimburseLevelInfo.getId().toString();
        queryCreditControlSTDOql = new StringBuffer();
        queryCreditControlSTDOql.append("select id, termCtrl, termCtrlVal, numberCtrl, numberCtrlVal, quotaCtrl, quotaCtrlVal ").append("where company.id = '").append(companyOrgUnitId).append("' and reimburseLV.id = '").append(reimburseLevelId).append("'").toString();
        ICreditControlSTD creditControlFactory = CreditControlSTDFactory.getLocalInstance(context);
        CreditControlSTDCollection creditControlSTDCollection = creditControlFactory.getCreditControlSTDCollection(queryCreditControlSTDOql.toString());
        creditControlSTDInfo = creditControlSTDCollection.get(0);
        if (creditControlSTDInfo != null) {
            return creditControlSTDInfo;
        }
        queryCreditControlSTDOql = new StringBuffer();
        queryCreditControlSTDOql.append("select creditControlSTD.id, ").append("creditControlSTD.termCtrl, creditControlSTD.termCtrlVal, ").append("creditControlSTD.numberCtrl, creditControlSTD.numberCtrlVal, ").append("creditControlSTD.quotaCtrl, creditControlSTD.quotaCtrlVal ").append("where creditControlSTD.reimburseLV.id = '").append(reimburseLevelId).append("' ").append("and companyOrgUnit.id = '").append(companyOrgUnitId).append("'");
        ICreditControlSTDAssign crediControlSTDAssignFactory = CreditControlSTDAssignFactory.getLocalInstance(context);
        CreditControlSTDAssignCollection creditControlSTDAssignInfos = crediControlSTDAssignFactory.getCreditControlSTDAssignCollection(queryCreditControlSTDOql.toString());
        if (creditControlSTDAssignInfos.size() != 0) {
            creditControlSTDInfo = creditControlSTDAssignInfos.get(0).getCreditControlSTD();
        }
        return creditControlSTDInfo;
    }
}

