/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.cp.bc.BudgetControlException;
import com.kingdee.eas.cp.bc.app.datatask.BCTaskBlockDataRunner;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.log.ILog;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class AbstractBatchDataImport
extends BlockDataTransmission {
    private static Logger logger = SysLog.getLogger(AbstractBatchDataImport.class);
    public static final String ConnectionKey = "ConnectionKey";
    private BCTaskBlockDataRunner runner = null;
    protected CompanyOrgUnitInfo company = null;
    protected String companyId = null;
    protected String userId = null;
    protected String cuId = null;
    protected String personId = null;
    protected String tempTable = null;
    protected int index = -1;
    protected int rowNum;

    public void importFile(Context ctx, TaskExternalCode task) throws TaskExternalException {
        try {
            this.runner = new BCTaskBlockDataRunner(task, this, ctx);
            this.index = this.runner.getBiginIndex();
            this.setLog((ILog)this.runner.getTaskLog());
            this.runner.run();
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected void doBeforeProcessData(Context ctx) throws Exception {
        this.company = ContextUtil.getCurrentFIUnit((Context)ctx);
        this.companyId = this.company.getId().toString();
        this.userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            this.personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        this.cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String sql = this.buildTempTableSQL();
        if (sql != null && sql.length() > 0) {
            this.tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(sql);
        }
    }

    protected String buildTempTableSQL() {
        return null;
    }

    protected abstract void doProcessBlockData(Context var1, RecordCollection var2) throws Exception;

    protected abstract int doProcessData(Context var1) throws Exception;

    protected void doAfterProcessData(Context ctx) throws Exception {
        if (this.tempTable != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(this.tempTable);
        }
    }

    protected void onDataError(int nCurCount, Object error) throws TaskExternalException, TaskRunnerException {
        this.runner.onDataError(nCurCount, error);
    }

    protected void onDataErrorForWeb(int nCurCount, Object error) throws TaskExternalException, TaskRunnerException {
        BudgetControlException e = new BudgetControlException(BudgetControlException.BANK, new Object[]{error});
        this.writeLog(nCurCount, (Exception)((Object)e));
    }

    protected String getResource(Context ctx, String key, Object[] args) {
        if (args == null) {
            return this.getResource(key, ctx.getOriginLocale());
        }
        return this.getResource(key, ctx.getOriginLocale(), args);
    }

    protected String getResource(String key, Locale locale) {
        return ResourceBase.getString((String)"com.kingdee.eas.cp.bc.BCImportExportResource", (String)key, (Locale)locale);
    }

    protected String getResource(String key, Locale locale, Object[] args) {
        return ResourceBase.getString((String)"com.kingdee.eas.cp.bc.BCImportExportResource", (String)key, (Locale)locale, (Object[])args);
    }

    public String getNotBlankString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    public Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    public String getData(SimpleRecord record, String key) {
        String result;
        Object value;
        DataToken token = record.get(key);
        if (token != null && (value = token.data) != null && (result = value.toString().trim()).length() > 0) {
            return result;
        }
        return null;
    }

    protected BigDecimal getBigDecimalValueByFeildData(Context ctx, String fieldName, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return new BigDecimal("0");
        }
        BigDecimal value = null;
        try {
            value = TypeConversionUtils.objToBigDecimal((Object)data);
        }
        catch (Exception e) {
            throw new BOSException(this.getResource(ctx, "TRANSBIGDECIMALERROE", new Object[]{fieldName, data}));
        }
        return value;
    }

    protected String getTempTable() {
        return this.tempTable;
    }

    protected String getCompanyId() {
        return this.companyId;
    }

    protected String getCUId() {
        return this.cuId;
    }

    public static void BatchSqlExecute(Context ctx, String sql, String separator) throws BOSException {
        String[] list = sql.split(separator);
        AbstractBatchDataImport.BatchSqlExecute(ctx, list);
    }

    public static void BatchSqlExecute(Context ctx, String[] sqlList) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        StringBuffer sb = new StringBuffer();
        boolean isNewGetConnection = false;
        int i = 0;
        try {
            conn = (Connection)ctx.get((Object)ConnectionKey);
            if (conn == null) {
                isNewGetConnection = true;
                conn = EJBFactory.getConnection((Context)ctx);
            }
            statement = conn.createStatement();
            while (i < sqlList.length) {
                if (sqlList[i].trim().length() > 0) {
                    statement.addBatch(sqlList[i]);
                    sb.append(sqlList[i]).append(" ; ");
                }
                ++i;
            }
            long timeFrom = System.currentTimeMillis();
            int[] rowNum = statement.executeBatch();
            long l = System.currentTimeMillis();
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)AbstractBatchDataImport.buildLogString(sqlList), (Throwable)exc);
                throw new BOSException("\r\nSQL is: " + Arrays.toString(sqlList), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                if (isNewGetConnection) {
                    SQLUtils.cleanup((Connection)conn);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        if (isNewGetConnection) {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private static String buildLogString(String[] sql) {
        StringBuffer log = new StringBuffer();
        log.append("\r\n----BC Exception Start----");
        log.append("\r\nThread ID:" + Thread.currentThread().toString());
        for (int i = 0; i < sql.length && i <= 20; ++i) {
            if (sql[i].trim().length() <= 0) continue;
            log.append("\r\nSQL" + i + " is:" + sql[i]);
        }
        if (sql.length > 20) {
            log.append("\r\nSQL is too mutch. All sql qty: ").append(sql.length);
        }
        log.append("\r\n----NCM Exception End----");
        return log.toString();
    }

    public Object transform(Context ctx, RecordCollection coll) throws TaskExternalException {
        try {
            this.doBeforeProcessData(ctx);
            this.doProcessBlockData(ctx, coll);
            this.doProcessData(ctx);
            this.doAfterProcessData(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void submitBlock(Context ctx, Object o) throws TaskExternalException {
    }
}

