/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.datatask;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.bc.app.datatask.AbstractBatchDataImport;
import com.kingdee.eas.cp.bc.app.datatask.BCBlockDataReader;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.tools.datatask.TaskStateEnum;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.log.TaskLogUtil;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.task.ITask;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.TaskIERunner;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.eas.util.ResourceBase;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BCTaskBlockDataRunner
extends TaskIERunner {
    private static Logger logger = SysLog.getLogger(BCTaskBlockDataRunner.class);
    private static final String RESBIZCOLL = "com.kingdee.eas.cp.bc.BizCollResource";
    private ErrorHandleModeEnum errorHandle = ErrorHandleModeEnum.ReturnRightnow;
    private TaskRunnerException stopEx = new TaskRunnerException("stop");
    private AbstractBatchDataImport blockTrans = null;
    private BCBlockDataReader reader = null;
    private Map errors = new HashMap();

    public BCTaskBlockDataRunner(TaskExternalCode task, AbstractBatchDataImport trans, Context ctx) throws Exception {
        super((ITask)task, ctx);
        this.blockTrans = trans;
        this.reader = new BCBlockDataReader(task, ctx.getLocale());
    }

    public int getBiginIndex() {
        return this.reader.getBiginIndex();
    }

    protected void onInitResources() throws TaskRunnerException {
        super.onInitResources();
        this.initErrorHandleMode();
    }

    private void initErrorHandleMode() {
        TaskExternalCode taskCode = (TaskExternalCode)this.task;
        DatataskParameter dp = (DatataskParameter)taskCode.getTaskParameter();
        if (dp.getContextParam().get("errorHandleMode") != null) {
            this.errorHandle = (ErrorHandleModeEnum)dp.getContextParam().get("errorHandleMode");
        }
    }

    protected boolean hasMoreRecord() throws TaskRunnerException {
        return this.reader.hasNextBlock();
    }

    protected void onBeforeEachRunningLoop() throws TaskRunnerException {
        super.onBeforeEachRunningLoop();
    }

    protected void onRecordProcess() throws TaskRunnerException {
        try {
            this.blockTrans.doBeforeProcessData(this.ctx);
            while (this.continueCondition && this.hasMoreRecord()) {
                this.onEachRunningLoop();
            }
            int count = this.blockTrans.doProcessData(this.ctx);
            this.tl.setSuccessRecordCount(count);
            this.fillDataError();
            if (this.tl.getFailRecordCount() == 0) {
                this.tl.setTaskState(TaskStateEnum.SUCCESSEND);
            }
        }
        catch (Throwable e) {
            if (e != this.stopEx) {
                this.tl.setTaskState(TaskStateEnum.FAILEND);
                this.tl.addException(ResourceBase.getString((String)RESBIZCOLL, (String)"executeImportError", (Locale)this.ctx.getLocale()), e, Integer.valueOf(this.nCurCount));
            } else {
                this.fillDataError();
            }
        }
        finally {
            try {
                this.blockTrans.doAfterProcessData(this.ctx);
            }
            catch (Exception e) {
                this.onDataError(e);
            }
        }
        TaskLogUtil.putLog((TaskLog)this.tl);
    }

    protected void onEachRunningLoop() throws Exception {
        RecordCollection coll = this.reader.getNextBlock();
        this.blockTrans.doProcessBlockData(this.ctx, coll);
    }

    protected String getMsgOnDataErr() {
        String sheetName = "";
        String rowNumber = String.valueOf(this.nCurCount);
        return sheetName + EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importNo", (Locale)this.locale) + rowNumber + EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"lineData", (Locale)this.locale);
    }

    protected void onFinishingRunning() throws TaskRunnerException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    protected String getFatalError() {
        String sheetName = "";
        return sheetName + EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"fatalError", (Locale)this.locale);
    }

    private void fillDataError() throws TaskRunnerException {
        if (this.errors.size() <= 0) {
            return;
        }
        LinkedList indexs = new LinkedList();
        indexs.addAll(this.errors.keySet());
        Collections.sort(indexs, (Comparator)new Comparator(){

            public int compare(Object o1, Object o2) {
                return Integer.parseInt((String)o1) - Integer.parseInt((String)o2);
            }
        });
        for (int i = 0; i < indexs.size(); ++i) {
            String key = (String)indexs.get(i);
            TaskError te = (TaskError)this.errors.get(key);
            this.tl.addException(te.errMsg, te.t, Integer.valueOf(this.nCurCount));
        }
        this.tl.setFailRecordCount(this.errors.size());
        this.tl.setTaskState(TaskStateEnum.FAILEND);
    }

    protected void dataErrorHandle(Throwable ex) throws TaskRunnerException {
        switch (this.errorHandle.getValue()) {
            case 1: {
                this.onDataErrorStop(ex);
                throw this.stopEx;
            }
            case 2: {
                this.dataErrorHandle2(ex, 10);
                break;
            }
            case 3: {
                this.dataErrorHandle2(ex, 50);
                break;
            }
            case 4: {
                this.dataErrorHandle2(ex, 100);
                break;
            }
            case 5: {
                this.onDataErrorSkip(ex);
                break;
            }
            default: {
                this.onDataErrorStop(ex);
                throw this.stopEx;
            }
        }
    }

    private void dataErrorHandle2(Throwable ex, int failcount) throws TaskRunnerException {
        if (this.errors.size() >= failcount) {
            this.onDataErrorStop(ex);
            throw this.stopEx;
        }
        this.onDataErrorSkip(ex);
    }

    public void onDataError(int index, Object error) throws TaskRunnerException {
        this.nCurCount = index;
        String key = String.valueOf(index);
        if (this.errors.containsKey(key)) {
            return;
        }
        Throwable ex = error instanceof Throwable ? (Throwable)error : new Exception(error.toString());
        String errMsg = this.getMsgOnDataErr();
        TaskError te = new TaskError(errMsg, ex);
        this.errors.put(key, te);
        if (ex instanceof TaskRunnerException && ((TaskRunnerException)ex).getExceptionCode() == 4) {
            throw (TaskRunnerException)ex;
        }
        if (this.errors.size() > 100) {
            throw new TaskRunnerException(ex.getMessage(), ex);
        }
        this.dataErrorHandle(ex);
    }

    class TaskError {
        String errMsg;
        Throwable t;

        public TaskError() {
        }

        public TaskError(String errMsg, Throwable t) {
            this.errMsg = errMsg;
            this.t = t;
        }
    }
}

