/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IExpenseType;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ExpenseTypeDataImport
extends BlockDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.datatask.ExpenseTypeDataImport");
    private final String RESOURCE = "com.kingdee.eas.cp.bc.BCImportExportResource";
    private static final String[] notNullFields = new String[]{"FNumber", "FTypeName_l2", "FOperationType_number", "FOperationType$company_number", "FCompany_number"};
    private static final String[] colNames = new String[]{"\u7f16\u7801", "\u7c7b\u522b\u540d\u79f0_l2", "\u4e1a\u52a1\u7c7b\u522b_\u7f16\u7801", "\u4e1a\u52a1\u7c7b\u522b$\u516c\u53f8_\u7f16\u7801", "\u516c\u53f8_\u7f16\u7801"};
    ExpenseTypeInfo supExpenseType = null;
    Map expenseTypeIsRefMap = new HashMap();

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo exportFilter = new FilterInfo();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String longNumber = company.getLongNumber();
        String[] numbers = StringUtils.split((String)longNumber, (String)"!");
        HashSet<String> numberSet = new HashSet<String>(Arrays.asList(numbers));
        exportFilter.getFilterItems().add(new FilterItemInfo("company.number", numberSet, CompareType.INCLUDE));
        return exportFilter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.cp.bc.app.ExpenseTypeForImporQuery";
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        IExpenseType iExpenseType = null;
        try {
            iExpenseType = ExpenseTypeFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return iExpenseType;
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        Map obj = (Map)hsData.get(0);
        DataToken controlType = (DataToken)obj.get("FControlType");
        String cType = (String)controlType.data;
        if (StringUtils.isEmpty((String)cType) || !"0".equals(cType) && !"1".equals(cType) && !"2".equals(cType) && !"3".equals(cType)) {
            controlType.data = 0;
        }
        DataToken controlMethod = (DataToken)obj.get("FControlMethod");
        String cMethod = (String)controlMethod.data;
        if (StringUtils.isEmpty((String)cMethod) || !"0".equals(cMethod) && !"1".equals(cMethod)) {
            controlMethod.data = 0;
        }
        this.validateNotNullField(hsData, ctx);
        this.checkOperationType(hsData, ctx);
        this.checkExpenseType(hsData, ctx);
        return null;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ExpenseTypeInfo superexpenseType = (ExpenseTypeInfo)coreBaseInfo;
        superexpenseType.setParent(this.supExpenseType);
        super.submit((CoreBaseInfo)superexpenseType, ctx);
    }

    private void validateNotNullField(Map hsData, Context ctx) throws TaskExternalException {
        Map obj = (Map)hsData.get(0);
        int il = notNullFields.length;
        for (int i = 0; i < il; ++i) {
            DataToken dataToken = (DataToken)obj.get(notNullFields[i]);
            if (dataToken == null) {
                Object[] params = new Object[]{notNullFields[i]};
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCImportExportResource", (String)"NOT_NULL"), params));
            }
            Object data = dataToken.data;
            if (data != null && !StringUtils.isBlank((String)data.toString())) continue;
            String desc = dataToken.desc;
            if (StringUtils.isBlank((String)desc)) {
                desc = colNames[i];
            }
            Object[] params = new Object[]{desc};
            throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCImportExportResource", (String)"NOT_NULL"), params));
        }
    }

    private void checkOperationType(Map hsData, Context ctx) throws TaskExternalException {
        Map obj = (Map)hsData.get(0);
        DataToken companyNumber = (DataToken)obj.get("FCompany_number");
        DataToken operationType$companyNumber = (DataToken)obj.get("FOperationType$company_number");
        if (!companyNumber.data.equals(operationType$companyNumber.data)) {
            Object[] params = new Object[]{companyNumber.desc, operationType$companyNumber.desc};
            throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCImportExportResource", (String)"OperationTypeCompanyNumber_NotEqual_CompanyNumber"), params));
        }
        OperationTypeInfo operationType = (OperationTypeInfo)this.getInfoByNumber(ctx, obj, new OperationTypeInfo().getBOSType(), "FOperationType_number");
        if (null != operationType && !operationType.isIsEnable()) {
            throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCImportExportResource", (String)"Operation_Not_Enable"));
        }
    }

    private void checkExpenseType(Map hsData, Context ctx) throws TaskExternalException {
        this.supExpenseType = null;
        Map obj = (Map)hsData.get(0);
        DataToken number = (DataToken)obj.get("FNumber");
        DataToken parentNumber = (DataToken)obj.get("FParent_number");
        String numberStr = number.data.toString();
        String parentNumberStr = parentNumber.data.toString();
        int pointIndex = numberStr.lastIndexOf(".");
        if (pointIndex != -1 && StringUtils.isEmpty((String)parentNumberStr)) {
            Object[] params = new Object[]{number.data};
            throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCImportExportResource", (String)"PARENTNUMBER_NOT_NULL"), params));
        }
        if (!StringUtils.isEmpty((String)parentNumberStr)) {
            if (pointIndex != -1) {
                String parentNumberStrTemp = numberStr.substring(0, pointIndex);
                if (!parentNumberStr.equals(parentNumberStrTemp)) {
                    throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCImportExportResource", (String)"PARENTNUMBER_NUMBER_ERROR"));
                }
            } else {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCImportExportResource", (String)"PARENTNUMBER_NUMBER_ERROR"));
            }
            try {
                CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.getInfoByNumber(ctx, obj, new CompanyOrgUnitInfo().getBOSType(), "FCompany_number");
                ExpenseTypeInfo expenseType = null;
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("ID"));
                selector.add(new SelectorItemInfo("ISSTART"));
                selector.add(new SelectorItemInfo("ISLEAF"));
                entityViewInfo.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("NUMBER", (Object)parentNumber));
                filter.getFilterItems().add(new FilterItemInfo("COMPANY.ID", (Object)companyInfo.getId().toString()));
                entityViewInfo.setFilter(filter);
                CoreBaseCollection coll = this.getController(ctx).getCollection(entityViewInfo);
                if (coll != null && coll.size() > 0) {
                    expenseType = (ExpenseTypeInfo)coll.get(0);
                    if (!expenseType.isIsStart()) {
                        throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCImportExportResource", (String)"PARENTNUMBER_NOT_START"));
                    }
                    if (this.expenseTypeIsRefMap.containsKey(expenseType.getId())) {
                        boolean isRef = (Boolean)this.expenseTypeIsRefMap.get(expenseType.getId());
                        if (isRef) {
                            Object[] params = new Object[]{parentNumber.data};
                            throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCImportExportResource", (String)"PARENTNUMBER_IS_REFERENCED"), params));
                        }
                    } else {
                        if (expenseType.isIsLeaf()) {
                            try {
                                ExpenseTypeFactory.getLocalInstance(ctx).isReferenced((IObjectPK)new ObjectUuidPK(expenseType.getId()));
                            }
                            catch (ObjectReferedException e) {
                                this.expenseTypeIsRefMap.put(expenseType.getId(), true);
                                Object[] params = new Object[]{parentNumber.data};
                                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCImportExportResource", (String)"PARENTNUMBER_IS_REFERENCED"), params));
                            }
                        }
                        this.expenseTypeIsRefMap.put(expenseType.getId(), false);
                    }
                } else {
                    Object[] params = new Object[]{parentNumber.desc, parentNumber.data};
                    throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCImportExportResource", (String)"NUMBER_INCOMPANY_NOT_EXIST"), params));
                }
                this.supExpenseType = expenseType;
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
    }

    private ObjectBaseInfo getInfoByNumber(Context ctx, Map obj, BOSObjectType type, String propName) throws TaskExternalException {
        try {
            DataToken number = (DataToken)obj.get(propName);
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            StringBuffer queryOql = new StringBuffer();
            queryOql.append("SELECT ID, NUMBER ");
            if (new ExpenseTypeInfo().getBOSType().equals((Object)type)) {
                queryOql.append(", CONTROLTYPE ");
            }
            if (new OperationTypeInfo().getBOSType().equals((Object)type)) {
                queryOql.append(", ISENABLE ");
            }
            queryOql.append("WHERE NUMBER = '%s'");
            IObjectCollection collection = iDynamicObject.getCollection(type, String.format(queryOql.toString(), number));
            if (collection == null || collection.size() == 0) {
                Object[] params = new Object[]{number.desc, number};
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.cp.bc.BCImportExportResource", (String)"NUMBER_NOT_EXIST"), params));
            }
            return (ObjectBaseInfo)collection.getObject(0);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }
}

