/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.mobile;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.ImageStateEnum;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AccountStandardFactory;
import com.kingdee.eas.cp.bc.BizAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.BizAccountBillInfo;
import com.kingdee.eas.cp.bc.BizBaseDataWebFacadeFactory;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CollectionAccountFactory;
import com.kingdee.eas.cp.bc.CollectionAccountInfo;
import com.kingdee.eas.cp.bc.CommonUtilFacadeFactory;
import com.kingdee.eas.cp.bc.DailyLoanBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.DailyLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.EvectionLoanBillInfo;
import com.kingdee.eas.cp.bc.EvectionStandardFactory;
import com.kingdee.eas.cp.bc.ExpenseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseReqBillInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.ICollectionAccount;
import com.kingdee.eas.cp.bc.ICommonUtilFacade;
import com.kingdee.eas.cp.bc.LoanBillInfo;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.cp.bc.PayerTypeEnum;
import com.kingdee.eas.cp.bc.TravelAccountBillAccountEntryInfo;
import com.kingdee.eas.cp.bc.TravelAccountBillInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbizCollUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.mobile.MbizCollUtil");

    public static SettlementTypeInfo getPayMode(Context ctx) throws BOSException, EASBizException {
        ISettlementType iSettle = SettlementTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)true));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(BizCollUtil.getDefaultSelector());
        SettlementTypeCollection collPay = iSettle.getSettlementTypeCollection(viewInfo);
        SettlementTypeInfo settle = null;
        if (collPay != null && collPay.size() > 0) {
            settle = collPay.get(0);
        }
        return settle;
    }

    public static CurrencyInfo getCurrentType(Context ctx) throws BOSException, EASBizException {
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo baseCurrency = ContextUtil.getCurrentFIUnit((Context)ctx).getBaseCurrency();
        CurrencyInfo currencyInfo = null;
        if (baseCurrency != null) {
            currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()), BizCollUtil.getDefaultSelector());
        }
        logger.error((Object)("### runner cpbc mbos currencyInfo =" + currencyInfo));
        return currencyInfo;
    }

    public static CurrencyInfo getCurrentType(Context ctx, BizCollBillBaseInfo info) throws BOSException, EASBizException {
        if (info.getCurrencyType() != null) {
            return info.getCurrencyType();
        }
        CompanyOrgUnitInfo applierCompany = info.getApplierCompany();
        String applierCompanyId = applierCompany.getId().toString();
        if (applierCompany.getBaseCurrency() == null) {
            CompanyOrgUnitInfo applierCompanytemp = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("SELECT ID, BASECURRENCY.ID, BASECURRENCY.NAME, BASECURRENCY.NUMBER WHERE ID = '" + applierCompanyId + "'");
            applierCompany.put("baseCurrency", (Object)applierCompanytemp.getBaseCurrency());
        }
        return applierCompany.getBaseCurrency();
    }

    public static List fetchBizAccountStandard(Context ctx, String StrBillInfo) throws EASBizException, BOSException {
        IObjectValue billInfo = null;
        List bizAccountStandard = null;
        billInfo = (IObjectValue)JSONUtils.convertJsonToObject((Context)ctx, (String)StrBillInfo, BizAccountBillInfo.class);
        bizAccountStandard = AccountStandardFactory.getLocalInstance(ctx).fetchAccountStandard(billInfo);
        logger.error((Object)("### runner cpbc mbos bizAccountStandard =" + bizAccountStandard));
        return bizAccountStandard;
    }

    public static List fetchEvectionStandard(Context ctx, String StrBillInfo) throws EASBizException, BOSException {
        IObjectValue billInfo = null;
        List evectionStandard = null;
        billInfo = (IObjectValue)JSONUtils.convertJsonToObject((Context)ctx, (String)StrBillInfo, TravelAccountBillInfo.class);
        evectionStandard = EvectionStandardFactory.getLocalInstance(ctx).fetchEvectionStandard(billInfo);
        logger.error((Object)("### runner cpbc mbos evectionStandard =" + evectionStandard));
        return evectionStandard;
    }

    public static Map initData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> initDataMap = new HashMap<String, Object>();
        BizCollBillBaseInfo bizCollInfo = CommonUtilFacadeFactory.getLocalInstance(ctx).forLoanBillCreateNewData();
        logger.error((Object)("### runner cpbc mbos initData currencyType =" + bizCollInfo.getCurrencyType()));
        logger.error((Object)("### runner cpbc mbos initData applierCompany =" + bizCollInfo.getApplierCompany()));
        logger.error((Object)("### runner cpbc mbos initData position =" + bizCollInfo.getPosition()));
        logger.error((Object)("### runner cpbc mbos initData orgUnitInfo =" + bizCollInfo.getOrgUnit()));
        logger.error((Object)("### runner cpbc mbos initData costCenterOrgUnitInfo =" + bizCollInfo.getCostedDept()));
        logger.error((Object)("### runner cpbc mbos initData company =" + bizCollInfo.getCompany()));
        CurrencyInfo cinfo = new CurrencyInfo();
        if (bizCollInfo.getCurrencyType() != null) {
            cinfo.setId(bizCollInfo.getCurrencyType().getId());
            cinfo.setName(bizCollInfo.getCurrencyType().getName());
            cinfo.setNumber(bizCollInfo.getCurrencyType().getNumber());
            initDataMap.put("currencyType", cinfo);
        }
        CompanyOrgUnitInfo ainfo = new CompanyOrgUnitInfo();
        if (bizCollInfo.getApplierCompany() != null) {
            ainfo.setId(bizCollInfo.getApplierCompany().getId());
            ainfo.setName(bizCollInfo.getApplierCompany().getName());
            ainfo.setNumber(bizCollInfo.getApplierCompany().getNumber());
            initDataMap.put("applierCompany", ainfo);
        }
        PositionInfo pinfo = new PositionInfo();
        if (bizCollInfo.getPosition() != null) {
            pinfo.setId(bizCollInfo.getPosition().getId());
            pinfo.setName(bizCollInfo.getPosition().getName());
            pinfo.setNumber(bizCollInfo.getPosition().getNumber());
            initDataMap.put("position", pinfo);
        }
        AdminOrgUnitInfo orginfo = new AdminOrgUnitInfo();
        if (bizCollInfo.getOrgUnit() != null) {
            orginfo.setId(bizCollInfo.getOrgUnit().getId());
            orginfo.setName(bizCollInfo.getOrgUnit().getName());
            orginfo.setNumber(bizCollInfo.getOrgUnit().getNumber());
            initDataMap.put("orgUnitInfo", orginfo);
        }
        CostCenterOrgUnitInfo costCenterinfo = new CostCenterOrgUnitInfo();
        if (bizCollInfo.getCostedDept() != null) {
            costCenterinfo.setId(bizCollInfo.getCostedDept().getId());
            costCenterinfo.setName(bizCollInfo.getCostedDept().getName());
            costCenterinfo.setNumber(bizCollInfo.getCostedDept().getNumber());
            initDataMap.put("costCenterOrgUnitInfo", costCenterinfo);
        }
        CompanyOrgUnitInfo companyinfo = new CompanyOrgUnitInfo();
        if (bizCollInfo.getCompany() != null) {
            companyinfo.setId(bizCollInfo.getCompany().getId());
            companyinfo.setName(bizCollInfo.getCompany().getName());
            companyinfo.setNumber(bizCollInfo.getCompany().getNumber());
            initDataMap.put("company", companyinfo);
        }
        if (bizCollInfo.getBizDate() != null) {
            initDataMap.put("bizDate", bizCollInfo.getBizDate());
        }
        return initDataMap;
    }

    public static String getOrgIdsByUserAndType(Context ctx, String userId) throws BOSException, EASBizException {
        Set set = MbizCollUtil.getOrgIdsByUserAndType(ctx, userId, OrgRangeType.BIZ_ORG_TYPE);
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterColl = filter.getFilterItems();
        filterColl.add(new FilterItemInfo("isBIzUnit", (Object)1));
        filterColl.add(new FilterItemInfo("isSealUp", (Object)0));
        filterColl.add(new FilterItemInfo("isAssistantOrg", (Object)0));
        filterColl.add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        CompanyOrgUnitCollection orgcon = iCompany.getCompanyOrgUnitCollection(evi);
        HashSet<String> ret = new HashSet<String>();
        int j = orgcon.size();
        for (int i = 0; i < j; ++i) {
            ret.add(orgcon.get(i).getId().toString());
        }
        String str = MbizCollUtil.setToString(ret);
        logger.error((Object)("### runner cpbc mbos company set =" + str));
        return str;
    }

    public static String getCompanyIdsByCtx(Context ctx) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterColl = filter.getFilterItems();
        filterColl.add(new FilterItemInfo("isBIzUnit", (Object)1));
        filterColl.add(new FilterItemInfo("isSealUp", (Object)0));
        filterColl.add(new FilterItemInfo("isAssistantOrg", (Object)0));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        CompanyOrgUnitCollection orgcon = iCompany.getCompanyOrgUnitCollection(evi);
        HashSet<String> ret = new HashSet<String>();
        int j = orgcon.size();
        for (int i = 0; i < j; ++i) {
            ret.add(orgcon.get(i).getId().toString());
        }
        String str = MbizCollUtil.setToString(ret);
        logger.error((Object)("### runner cpbc mbos company set =" + str));
        return str;
    }

    public static Set getOrgIdsByUserAndType(Context ctx, String userid, OrgRangeType orgRangeType) throws BOSException, EASBizException {
        HashSet<String> ret = new HashSet<String>();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterColl = filter.getFilterItems();
        filterColl.add(new FilterItemInfo("user.id", (Object)userid));
        filterColl.add(new FilterItemInfo("type", (Object)String.valueOf(orgRangeType.getValue())));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IOrgRange iOrgRange = OrgRangeFactory.getLocalInstance((Context)ctx);
        OrgRangeCollection orgcon = iOrgRange.getOrgRangeCollection(evi);
        int j = orgcon.size();
        for (int i = 0; i < j; ++i) {
            ret.add(orgcon.get(i).getOrg().getId().toString());
        }
        return ret;
    }

    public static String getOpertionTypeSetIds(Context ctx, String billType) {
        EntityViewInfo operationView = new EntityViewInfo();
        FilterInfo operationFilter = new FilterInfo();
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.OperationTypeInitTreeQuery");
        operationFilter.getFilterItems().add(new FilterItemInfo("operationType.isEnable", (Object)Boolean.TRUE));
        operationFilter.getFilterItems().add(new FilterItemInfo("billType.number", (Object)billType));
        operationFilter.getFilterItems().add(new FilterItemInfo("entry.isFilterControl", (Object)Boolean.TRUE));
        operationView.setFilter(operationFilter);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(operationView);
        HashSet<String> operationIds = new HashSet<String>();
        try {
            IRowSet rowSet = exec.executeQuery();
            while (rowSet.next()) {
                operationIds.add(rowSet.getObject("operationType.id").toString());
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        String str = MbizCollUtil.setToString(operationIds);
        logger.error((Object)("### runner cpbc mbos operationtype set =" + str));
        return str;
    }

    public static String getOpertionTypeSetIds(Context ctx, String billType, String companyId, String costCenterId) throws EASBizException, BOSException {
        Set operationIds = BizBaseDataWebFacadeFactory.getRemoteInstance().getOperationIdsByCompany(companyId, billType, costCenterId);
        logger.error((Object)("### runner cpbc mbos operationtype set =" + operationIds));
        String str = operationIds.size() > 0 ? MbizCollUtil.setToString(operationIds) : "nodata";
        return str;
    }

    public static void initDefaultCollectionEntry(Context ctx, ExpenseAccountBillInfo info, BigDecimal amountEncashed) {
        if (info.getApplier() == null) {
            return;
        }
        String applierid = info.getApplier().getId().toString();
        String id = info.getId().toString();
        try {
            SettlementTypeInfo payMode = info.getPayMode();
            if (payMode == null) {
                payMode = MbizCollUtil.getPayMode(ctx);
                info.setPayMode(payMode);
            }
            ICollectionAccount icollection = null;
            icollection = ctx == null ? CollectionAccountFactory.getRemoteInstance() : CollectionAccountFactory.getLocalInstance(ctx);
            CollectionAccountInfo collectioninfo = icollection.getCollectionAccountInfo("select OpenArea.id,OpenArea.name,OpenArea.number,Bebank.id,Bebank.name,Bebank.number,Bebank.state,BebankStr,BankAccount,Payee,SwiftCode where applier.id='" + applierid + "' and isDefault=1");
            if (collectioninfo != null) {
                logger.error((Object)"### runner cpbc mbos initDefaultCollectionEntry collectioninfo is success");
                info.setPayerName(collectioninfo.getPayee());
                info.setPayerAccount(collectioninfo.getBankAccount());
                if (collectioninfo.getBebank() != null) {
                    info.setPayerBankStr(collectioninfo.getBebank());
                }
                info.setPayerBank(collectioninfo.getBebankStr());
                info.setOpenArea(collectioninfo.getOpenArea());
                if (MbizCollUtil.isBizAccountBill(id)) {
                    logger.error((Object)("#### runner cpbc mbos initDefaultCollectionEntry BizAccountBillInfo id = " + id));
                    BizAccountBillAccountEntryInfo entry = null;
                    entry = ((BizAccountBillInfo)info).getCollectionEntries() != null && ((BizAccountBillInfo)info).getCollectionEntries().size() > 0 ? ((BizAccountBillInfo)info).getCollectionEntries().get(0) : new BizAccountBillAccountEntryInfo();
                    entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
                    entry.setPayerId(applierid);
                    entry.setPayerName(collectioninfo.getPayee());
                    entry.setPayerBank(collectioninfo.getBebankStr());
                    entry.setPayerBankF7(collectioninfo.getBebank());
                    entry.setOpenArea(collectioninfo.getOpenArea());
                    entry.setPayerAccount(collectioninfo.getBankAccount());
                    entry.setPayMode(payMode);
                    entry.setCurrencyType(MbizCollUtil.getCurrentType(ctx, info));
                    entry.setExchangeRate(new BigDecimal(1).setScale(4));
                    entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                    entry.setExchangeRatePrecision(4);
                    entry.setAmount(amountEncashed);
                    entry.setAmountOri(amountEncashed);
                    ((BizAccountBillInfo)info).getCollectionEntries().clear();
                    ((BizAccountBillInfo)info).getCollectionEntries().add(entry);
                } else if (MbizCollUtil.isTravelAccountBill(id)) {
                    logger.error((Object)("#### runner cpbc mbos initDefaultCollectionEntry TravelAccountBillInfo id = " + id));
                    TravelAccountBillAccountEntryInfo entry = null;
                    if (((TravelAccountBillInfo)info).getCollectionEntries() != null && ((TravelAccountBillInfo)info).getCollectionEntries().size() > 0) {
                        ((TravelAccountBillInfo)info).getCollectionEntries().get(0);
                        entry = ((TravelAccountBillInfo)info).getCollectionEntries().get(0);
                    } else {
                        entry = new TravelAccountBillAccountEntryInfo();
                    }
                    entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
                    entry.setPayerId(applierid);
                    entry.setPayerName(collectioninfo.getPayee());
                    entry.setPayerBank(collectioninfo.getBebankStr());
                    entry.setPayerBankF7(collectioninfo.getBebank());
                    entry.setOpenArea(collectioninfo.getOpenArea());
                    entry.setPayerAccount(collectioninfo.getBankAccount());
                    entry.setPayMode(payMode);
                    entry.setCurrencyType(MbizCollUtil.getCurrentType(ctx, info));
                    entry.setExchangeRate(new BigDecimal(1).setScale(4));
                    entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                    entry.setExchangeRatePrecision(4);
                    entry.setAmount(amountEncashed);
                    entry.setAmountOri(amountEncashed);
                    ((TravelAccountBillInfo)info).getCollectionEntries().clear();
                    ((TravelAccountBillInfo)info).getCollectionEntries().add(entry);
                }
            } else {
                logger.error((Object)"### runner cpbc mbos initDefaultCollectionEntry collectioninfo is null");
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void initDefaultCollectionEntry(Context ctx, LoanBillInfo info, BigDecimal amount) {
        if (info.getApplier() == null) {
            return;
        }
        String applierid = info.getApplier().getId().toString();
        String id = info.getId().toString();
        try {
            SettlementTypeInfo payMode = info.getPayMode();
            if (payMode == null) {
                payMode = MbizCollUtil.getPayMode(ctx);
                info.setPayMode(payMode);
            }
            ICollectionAccount icollection = null;
            icollection = ctx == null ? CollectionAccountFactory.getRemoteInstance() : CollectionAccountFactory.getLocalInstance(ctx);
            CollectionAccountInfo collectioninfo = icollection.getCollectionAccountInfo("select OpenArea.id,OpenArea.name,OpenArea.number,Bebank.id,Bebank.name,Bebank.number,BebankStr,BankAccount,Payee, applier.id,applier.number where applier.id='" + applierid + "' and isDefault=1");
            if (collectioninfo != null) {
                logger.error((Object)"### runner cpbc mbos initDefaultCollectionEntry collectioninfo is success");
                info.setPayerName(collectioninfo.getPayee());
                info.setPayerAccount(collectioninfo.getBankAccount());
                if (collectioninfo.getBebank() != null) {
                    info.setPayerBankStr(collectioninfo.getBebank());
                }
                info.setPayerBank(collectioninfo.getBebankStr());
                info.setOpenArea(collectioninfo.getOpenArea());
                if (MbizCollUtil.isDailyLoanBill(id)) {
                    logger.error((Object)("#### runner cpbc mbos initDefaultCollectionEntry DailyLoanBillInfo id = " + id));
                    DailyLoanBillAccountEntryInfo entry = null;
                    entry = ((DailyLoanBillInfo)info).getCollectionEntries() != null && ((DailyLoanBillInfo)info).getCollectionEntries().size() > 0 ? ((DailyLoanBillInfo)info).getCollectionEntries().get(0) : new DailyLoanBillAccountEntryInfo();
                    entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
                    entry.setPayerId(applierid);
                    entry.setPayerNumber(collectioninfo.getApplier().getNumber());
                    entry.setPayerType(PayerTypeEnum.other);
                    entry.setPayerName(collectioninfo.getPayee());
                    entry.setPayerBank(collectioninfo.getBebankStr());
                    entry.setPayerBankF7(collectioninfo.getBebank());
                    entry.setOpenArea(collectioninfo.getOpenArea());
                    entry.setPayerAccount(collectioninfo.getBankAccount());
                    entry.setPayMode(payMode);
                    entry.setCurrencyType(MbizCollUtil.getCurrentType(ctx, info));
                    entry.setExchangeRate(new BigDecimal(1).setScale(4));
                    entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                    entry.setExchangeRatePrecision(4);
                    entry.setAmount(amount);
                    entry.setAmountOri(amount);
                    ((DailyLoanBillInfo)info).getCollectionEntries().clear();
                    ((DailyLoanBillInfo)info).getCollectionEntries().add(entry);
                } else if (MbizCollUtil.isEvectionLoanBill(id)) {
                    logger.error((Object)("#### runner cpbc mbos initDefaultCollectionEntry EvectionLoanBillInfo id = " + id));
                    EvectionLoanBillAccountEntryInfo entry = null;
                    entry = ((EvectionLoanBillInfo)info).getCollectionEntries() != null && ((EvectionLoanBillInfo)info).getCollectionEntries().size() > 0 ? ((EvectionLoanBillInfo)info).getCollectionEntries().get(0) : new EvectionLoanBillAccountEntryInfo();
                    entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
                    entry.setPayerId(applierid);
                    entry.setPayerName(collectioninfo.getPayee());
                    entry.setPayerBank(collectioninfo.getBebankStr());
                    entry.setPayerBankF7(collectioninfo.getBebank());
                    entry.setOpenArea(collectioninfo.getOpenArea());
                    entry.setPayerAccount(collectioninfo.getBankAccount());
                    entry.setPayMode(payMode);
                    entry.setCurrencyType(MbizCollUtil.getCurrentType(ctx, info));
                    entry.setExchangeRate(new BigDecimal(1).setScale(4));
                    entry.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
                    entry.setExchangeRatePrecision(4);
                    entry.setAmount(amount);
                    entry.setAmountOri(amount);
                    ((EvectionLoanBillInfo)info).getCollectionEntries().clear();
                    ((EvectionLoanBillInfo)info).getCollectionEntries().add(entry);
                }
            } else {
                logger.error((Object)"### runner cpbc mbos initDefaultCollectionEntry collectioninfo is null");
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static String getOpertionTypeIdsByExpenseType(Context ctx, String billType, String companId, String companyLongNumber) throws BOSException {
        logger.error((Object)("### runner cpbc mbos getOpertionTypeIdsByExpenseType billType =" + billType));
        logger.error((Object)("### runner cpbc mbos getOpertionTypeIdsByExpenseType companId =" + companId));
        logger.error((Object)("### runner cpbc mbos getOpertionTypeIdsByExpenseType companyLongNumber =" + companyLongNumber));
        EntityViewInfo expenseTypeView = new EntityViewInfo();
        FilterInfo expenseTypeFilter = new FilterInfo();
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.F7ExpenseTypeQuery");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("operationType.isEnable", (Object)Boolean.TRUE));
        expenseTypeFilter.mergeFilter(filterInfo, "and");
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companId, CompareType.EQUALS));
        if (companyLongNumber != null) {
            String[] lnSecs = companyLongNumber.split("!");
            int size = lnSecs.length;
            HashSet<String> lnUps = new HashSet<String>();
            for (int i = 0; i < size; ++i) {
                lnUps.add(lnSecs[i]);
            }
            if (lnUps.size() != 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("company.number", lnUps, CompareType.INCLUDE));
                filterInfo.setMaskString("#0 or #1");
            }
        }
        expenseTypeFilter.mergeFilter(filterInfo, "and");
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billType.number", (Object)billType, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("entry.isFilterControl", (Object)Boolean.TRUE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)Boolean.TRUE, CompareType.EQUALS));
        expenseTypeFilter.mergeFilter(filterInfo, "and");
        filterInfo = new FilterInfo();
        HashSet ids = new HashSet();
        try {
            ids = MbizCollUtil.getExpenseTypeIdSet(ctx, billType);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (ids != null && ids.size() > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
            expenseTypeFilter.mergeFilter(filterInfo, "and");
        }
        expenseTypeView.setFilter(expenseTypeFilter);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(expenseTypeView);
        HashSet<String> expenseIds = new HashSet<String>();
        try {
            IRowSet rowSet = exec.executeQuery();
            while (rowSet.next()) {
                expenseIds.add(rowSet.getObject("id").toString());
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        String str = MbizCollUtil.setToString(expenseIds);
        logger.error((Object)("### runner cpbc mbos expensetype set =" + str));
        return str;
    }

    public static HashSet getExpenseTypeIdSet(Context ctx, String billTypeId) throws EASBizException, BOSException {
        ICommonUtilFacade iCommonUtilFacade = CommonUtilFacadeFactory.getLocalInstance(ctx);
        IRowSet rowSet = null;
        HashSet<String> tempSet = new HashSet<String>();
        try {
            rowSet = iCommonUtilFacade.forCheckExpenseType(MbizCollUtil.getExpenseTypeQuerySql(billTypeId));
            while (rowSet.next()) {
                String tempExpenseTypeId = rowSet.getString("fid");
                tempSet.add(tempExpenseTypeId);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tempSet;
    }

    private static String getExpenseTypeQuerySql(String billTypeId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select expType.fid,expType.fname_l2 ");
        sql.append(" from t_bc_expensetype expType ");
        sql.append(" inner join t_bc_operationtype opeType on expType.foperationTypeid = opeType.fid ");
        sql.append(" inner join t_bc_expensetypeentry expEntry on expEntry.fparentid = expType.fid ");
        sql.append(" where  opeType.fisEnable =1 and expType.fisstart=1 ");
        sql.append(" and expEntry.fbillid='").append(MbizCollUtil.getBillTypeId(billTypeId)).append("' ");
        logger.error((Object)("### runner cpbc mbos getExpenseTypeQuerySql sql = " + sql));
        return sql.toString();
    }

    public static String setToString(Set set) {
        ArrayList list = new ArrayList(set);
        String str = null;
        str = ((Object)list).toString();
        str = str.replace(", ", "','");
        str = str.replace("[", "");
        str = str.replace("]", "");
        return str;
    }

    private static String getBillTypeId(String str) {
        String billTypeId = null;
        if (str.equals("OtherExpenseBill")) {
            billTypeId = "UcN+cgExEADgAAABwKjIWG8A6j8=";
        } else if (str.equals("DailyLoanBill")) {
            billTypeId = "UcN+cgExEADgAAACwKjIWG8A6j8=";
        } else if (str.equals("BizAccountBill")) {
            billTypeId = "UcN+cgExEADgAAAEwKjIWG8A6j8=";
        } else if (str.equals("EvectionLoanBill")) {
            billTypeId = "UcN+cgExEADgAAAGwKjIWG8A6j8=";
        } else if (str.equals("TravelAccountBill")) {
            billTypeId = "UcN+cgExEADgAAAHwKjIWG8A6j8=";
        } else if (str.equals("DailyPurchaseAccountBill")) {
            billTypeId = "UcN+cgExEADgAAAJwKjIWG8A6j8=";
        }
        return billTypeId;
    }

    public static boolean isTravelAccountBill(String id) {
        boolean isTravelAccountBill = false;
        if (id != null && !"".equals(id) && new TravelAccountBillInfo().getBOSType().toString().equals(BOSUuid.getBOSObjectType((String)id, (boolean)false).toString())) {
            isTravelAccountBill = true;
        }
        return isTravelAccountBill;
    }

    public static boolean isBizAccountBill(String id) {
        boolean isBizAccountBill = false;
        if (id != null && !"".equals(id) && new BizAccountBillInfo().getBOSType().toString().equals(BOSUuid.getBOSObjectType((String)id, (boolean)false).toString())) {
            isBizAccountBill = true;
        }
        return isBizAccountBill;
    }

    public static boolean isDailyLoanBill(String id) {
        boolean isDailyLoanBill = false;
        if (id != null && !"".equals(id) && new DailyLoanBillInfo().getBOSType().toString().equals(BOSUuid.getBOSObjectType((String)id, (boolean)false).toString())) {
            isDailyLoanBill = true;
        }
        return isDailyLoanBill;
    }

    public static boolean isEvectionLoanBill(String id) {
        boolean isEvectionLoanBill = false;
        if (id != null && !"".equals(id) && new EvectionLoanBillInfo().getBOSType().toString().equals(BOSUuid.getBOSObjectType((String)id, (boolean)false).toString())) {
            isEvectionLoanBill = true;
        }
        return isEvectionLoanBill;
    }

    public static Map getMobileParamList(Context ctx, String applierCompanyId) {
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP001");
        paramList.add("CP002");
        paramList.add("CP008");
        paramList.add("CP009");
        paramList.add("CP010");
        paramList.add("CP016");
        paramList.add("CP017");
        paramList.add("CP019");
        paramList.add("CP020");
        paramList.add("CP023");
        paramList.add("CP025");
        paramList.add("CP027");
        paramList.add("CP028");
        paramList.add("CP029");
        paramList.add("CP030");
        paramList.add("CP031");
        paramList.add("CP032");
        paramList.add("CP033");
        paramList.add("CP036");
        paramList.add("CP037");
        paramList.add("CP039");
        paramList.add("CP040");
        paramList.add("CP042");
        paramList.add("CP045");
        paramList.add("CP049");
        paramList.add("CP032");
        paramList.add("IsSSC");
        paramList.add("IsPaperParkIntegration");
        HashMap paramMap = new HashMap();
        IParamControl iParam = null;
        String[] paramNumbers = null;
        int size = paramList.size();
        try {
            iParam = ParamControlFactory.getLocalInstance((Context)ctx);
            if (paramList != null && size > 0) {
                paramNumbers = new String[size];
                for (int i = 0; i < size; ++i) {
                    paramNumbers[i] = (String)paramList.get(i);
                }
                paramMap = iParam.getParamHashMap(paramNumbers, applierCompanyId);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return paramMap;
    }

    public static Map getMobileParamAfterLoad(Context ctx, String applierCompanyId, Map map) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        try {
            if (map != null && map.get("id") != null && map.get("id").toString() != "") {
                String id = map.get("id").toString();
                logger.error((Object)("### runner cpbc mbos getMobileParamAfterLoad id = " + id));
                ImageStateEnum imageStateEnum = BillImageFacadeFactory.getLocalInstance((Context)ctx).getImageState(null, id);
                if (imageStateEnum != null) {
                    paramMap.put("imageState", imageStateEnum.getValue());
                    paramMap.put("imageStateEnum", (String)imageStateEnum);
                    logger.error((Object)("### runner cpbc mbos getMobileParamAfterLoad imageState = " + imageStateEnum.getValue()));
                }
            }
        }
        catch (BOSException e) {
            paramMap.put("imageState", "error");
            e.printStackTrace();
        }
        return paramMap;
    }

    public static boolean getMobileParam(Context ctx, String applierCompanyId, String CP00X) {
        boolean param = false;
        Map paramMap = MbizCollUtil.getMobileParamList(ctx, applierCompanyId);
        param = new Boolean(paramMap.get(CP00X).toString());
        logger.error((Object)("### runner cpbc mbos applierCompanyId = " + applierCompanyId));
        logger.error((Object)("### runner cpbc mbos param " + CP00X + " = " + param));
        return param;
    }

    public static BigDecimal getExRateInfo(Context ctx, String srcCurrId, String destCurrId, CompanyOrgUnitInfo company) {
        Date date = new Date();
        logger.error((Object)("### runner cpbc mbos exRateInfo company=" + company));
        if (destCurrId == null) {
            destCurrId = company.getBaseCurrency().getId().toString();
        }
        ExchangeTableInfo baseExchangeTable = company.getBaseExchangeTable();
        ExchangeRateInfo exRateInfo = null;
        if (baseExchangeTable == null) {
            return null;
        }
        if (srcCurrId == null) {
            BigDecimal convertrate = new BigDecimal("0.00");
            return convertrate;
        }
        logger.error((Object)("### runner cpbc mbos exRateInfo srcCurrId=" + srcCurrId));
        logger.error((Object)("### runner cpbc mbos exRateInfo destCurrId=" + destCurrId));
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurrId);
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurrId);
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        try {
            IExchangeRate iExchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
            exRateInfo = iExchangRate.getExchangeRate((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, DateTimeUtils.truncateDate((Date)date));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        BigDecimal convertrate = new BigDecimal("1.00");
        if (exRateInfo != null) {
            convertrate = (BigDecimal)exRateInfo.get("convertrate");
        }
        logger.error((Object)("### runner cpbc mbos exRateInfo rateValue=" + convertrate));
        return convertrate;
    }

    public static IObjectValue getExRateInfoValue(Context ctx, String srcCurrId, String destCurrId, CompanyOrgUnitInfo company) {
        Date date = new Date();
        logger.error((Object)("### runner cpbc mbos exRateInfo company=" + company));
        if (destCurrId == null) {
            destCurrId = company.getBaseCurrency().getId().toString();
        }
        ExchangeTableInfo baseExchangeTable = company.getBaseExchangeTable();
        ExchangeRateInfo exRateInfo = null;
        if (baseExchangeTable == null) {
            return null;
        }
        if (srcCurrId == null) {
            logger.error((Object)"### runner cpbc mbos exRateInfo srcCurrId is null");
            return null;
        }
        logger.error((Object)("### runner cpbc mbos exRateInfo srcCurrId=" + srcCurrId));
        logger.error((Object)("### runner cpbc mbos exRateInfo destCurrId=" + destCurrId));
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(srcCurrId);
        ObjectUuidPK destCurrpk = new ObjectUuidPK(destCurrId);
        ObjectUuidPK exchangeTablepk = new ObjectUuidPK(baseExchangeTable.getId());
        try {
            IExchangeRate iExchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
            exRateInfo = iExchangRate.getExchangeRate((IObjectPK)exchangeTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, DateTimeUtils.truncateDate((Date)date));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        if (exRateInfo != null) {
            logger.error((Object)("### runner cpbc mbos exRateInfoValue rateValue=" + exRateInfo.getConvertRate()));
        }
        return exRateInfo;
    }

    public static boolean expenseInOperation(Context ctx, String operationTypeId, String expenseTypeId) {
        ExpenseTypeInfo expenseTypeInfo = null;
        boolean isNotIn = true;
        if (expenseTypeId == null || operationTypeId == null) {
            return isNotIn;
        }
        logger.error((Object)("### runner cpbc mbos operationTypeId = " + operationTypeId));
        logger.error((Object)("### runner cpbc mbos expenseTypeId = " + expenseTypeId));
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("operationType.*"));
            sic.add(new SelectorItemInfo("operationType.isEnable"));
            sic.add(new SelectorItemInfo("operationType.id"));
            sic.add(new SelectorItemInfo("operationType.number"));
            sic.add(new SelectorItemInfo("operationType.name"));
            expenseTypeInfo = (ExpenseTypeInfo)ExpenseTypeFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(expenseTypeId), sic);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        OperationTypeInfo operationTypeInfo = null;
        if (expenseTypeInfo != null && null != expenseTypeInfo.get("operationtype")) {
            operationTypeInfo = (OperationTypeInfo)expenseTypeInfo.get("operationtype");
        }
        if (operationTypeInfo != null && null != operationTypeInfo.getId() && operationTypeId.equals(operationTypeInfo.getId().toString())) {
            isNotIn = false;
        }
        return isNotIn;
    }

    public static Set getMobileCostCenterF7(Context ctx, String companyId, String applierCompanyId, String userId) throws BOSException, EASBizException {
        boolean CP019 = new Boolean(false);
        Map paramMap = MbizCollUtil.getMobileParamList(ctx, applierCompanyId);
        CP019 = new Boolean(paramMap.get("CP019").toString());
        logger.error((Object)("### runner cpbc mbos getMobileCostCenterF7 companyId = " + companyId));
        logger.error((Object)("### runner cpbc mbos getMobileCostCenterF7 userId = " + userId));
        logger.error((Object)("### runner cpbc mbos getMobileCostCenterF7 CP019 = " + CP019));
        Set orgRangeSet = MbizCollUtil.getMobileOrgIdsByUserAndType(ctx, userId, OrgRangeType.BIZ_ORG_TYPE, null);
        logger.error((Object)("### runner cpbc mbos getMobileCostCenterF7 orgRangeSet = " + orgRangeSet));
        HashSet<String> orgIdSet = new HashSet<String>();
        EntityViewInfo evi = new EntityViewInfo();
        try {
            OrgUnitCollection unitColl = null;
            if (companyId != null) {
                unitColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getFromUnit(companyId, 1, 5);
            }
            if (CP019) {
                Set setIds = orgRangeSet;
                if (setIds != null && setIds.size() > 0 && unitColl != null && unitColl.size() > 0) {
                    String temp = null;
                    for (int i = unitColl.size() - 1; i >= 0; --i) {
                        temp = unitColl.get(i).getId().toString();
                        if (!setIds.contains(temp)) continue;
                        orgIdSet.add(temp);
                    }
                }
            } else if (unitColl != null) {
                for (int i = unitColl.size() - 1; i >= 0; --i) {
                    String temp = unitColl.get(i).getId().toString();
                    orgIdSet.add(temp);
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        logger.error((Object)("### runner cpbc mbos getMobileCostCenterF7 applierCompanyId = " + applierCompanyId));
        logger.error((Object)("### runner cpbc mbos getMobileCostCenterF7 CP019 = " + CP019));
        logger.error((Object)("### runner cpbc mbos getMobileCostCenterF7 orgIdSet = " + orgIdSet));
        return orgIdSet;
    }

    public static Set getMobileOrgIdsByUserAndType(Context ctx, String userid, OrgRangeType orgRangeType, Set orgIdSet) throws BOSException, EASBizException {
        HashSet<String> ret = new HashSet<String>();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterColl = filter.getFilterItems();
        filterColl.add(new FilterItemInfo("user.id", (Object)userid));
        filterColl.add(new FilterItemInfo("type", (Object)String.valueOf(orgRangeType.getValue())));
        if (orgIdSet != null && orgIdSet.size() > 0) {
            filterColl.add(new FilterItemInfo("org.id", (Object)orgIdSet, CompareType.INCLUDE));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IOrgRange iOrgRange = null;
        iOrgRange = ctx != null ? OrgRangeFactory.getLocalInstance((Context)ctx) : OrgRangeFactory.getRemoteInstance();
        OrgRangeCollection orgcon = iOrgRange.getOrgRangeCollection(evi);
        int j = orgcon.size();
        for (int i = 0; i < j; ++i) {
            ret.add(orgcon.get(i).getOrg().getId().toString());
        }
        return ret;
    }

    public static String getBudgetBalance(Context ctx, String billId, String entryId) throws EASBizException, BOSException {
        logger.error((Object)("---cp.bc.mobile---\u5355\u636eID\u4e3a---" + billId));
        logger.error((Object)("---cp.bc.mobile---\u5206\u5f55ID\u4e3a---" + entryId));
        if (ctx == null) {
            logger.error((Object)"---cp.bc.mobile---\u4e0a\u4e0b\u6587\u4e3a\u7a7a---");
            return "";
        }
        if (billId == null || "".equals(billId)) {
            logger.error((Object)"---cp.bc.mobile---\u5355\u636eID\u4e3a\u7a7a---");
            return "";
        }
        if (entryId == null || "".equals(entryId)) {
            logger.error((Object)"---cp.bc.mobile---\u5206\u5f55ID\u4e3a\u7a7a---");
            return "";
        }
        HashMap<String, IObjectValue> paramMap = new HashMap<String, IObjectValue>();
        Map maps = new HashMap();
        Map listMap = new HashMap();
        ObjectUuidPK billPK = new ObjectUuidPK(billId);
        BizCollBillBaseInfo billInfo = (BizCollBillBaseInfo)DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(billPK.getObjectType(), (IObjectPK)billPK, MbizCollUtil.getSelectorForBill(ctx, billPK.getObjectType()));
        String applierCompanyId = billInfo.getApplierCompany().getId().toString();
        listMap = MbizCollUtil.getMobileParamList(ctx, applierCompanyId);
        if (!MbizCollUtil.isShowBudgetOnMobile(listMap, billInfo).booleanValue()) {
            logger.error((Object)"---cp.bc.mobile---\u53c2\u6570\u5224\u65ad\u4e0d\u901a\u8fc7");
            return "";
        }
        ObjectUuidPK entryPK = new ObjectUuidPK(entryId);
        IObjectValue entryInfo = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(entryPK.getObjectType(), (IObjectPK)entryPK, MbizCollUtil.getSelectorForEntry(ctx, billPK.getObjectType()));
        paramMap.put("entry", entryInfo);
        String result = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getBudget(billInfo, billInfo.getId(), paramMap);
        maps = (Map)JSON.parse((String)result);
        String bgBalace = "";
        if (maps != null && maps.get("budgetText") != null) {
            bgBalace = (String)maps.get("budgetText");
        }
        return bgBalace;
    }

    private static Boolean isShowBudgetOnMobile(Map paramMap, BizCollBillBaseInfo billInfo) {
        Boolean bool = false;
        Boolean isWithBudget = paramMap.get("CP001") == null ? false : new Boolean(paramMap.get("CP001").toString());
        Boolean isShowBudget = paramMap.get("CP010") == null ? false : new Boolean(paramMap.get("CP010").toString());
        Boolean isLoanBill = paramMap.get("CP029") == null ? false : new Boolean(paramMap.get("CP029").toString());
        Boolean isReqBill = paramMap.get("CP030") == null ? false : new Boolean(paramMap.get("CP030").toString());
        if (!isWithBudget.booleanValue() || !isShowBudget.booleanValue()) {
            return bool;
        }
        bool = true;
        if (billInfo instanceof LoanBillInfo && isLoanBill.booleanValue() || billInfo instanceof ExpenseReqBillInfo && isReqBill.booleanValue()) {
            bool = true;
        }
        return bool;
    }

    private static SelectorItemCollection getSelectorForBill(Context ctx, BOSObjectType bosType) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic = MbizCollUtil.getEntityDepPropertySelector(ctx, bosType, true, false, null);
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("expenseType.id"));
        sic.add(new SelectorItemInfo("expenseType.name"));
        sic.add(new SelectorItemInfo("expenseType.number"));
        sic.add(new SelectorItemInfo("operationType.id"));
        sic.add(new SelectorItemInfo("operationType.name"));
        sic.add(new SelectorItemInfo("operationType.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("costedDept.id"));
        sic.add(new SelectorItemInfo("costedDept.name"));
        sic.add(new SelectorItemInfo("costedDept.number"));
        sic.add(new SelectorItemInfo("currencyType.id"));
        sic.add(new SelectorItemInfo("currencyType.name"));
        sic.add(new SelectorItemInfo("currencyType.number"));
        sic.add(new SelectorItemInfo("applierCompany.id"));
        sic.add(new SelectorItemInfo("applierCompany.name"));
        sic.add(new SelectorItemInfo("applierCompany.number"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        return sic;
    }

    private static SelectorItemCollection getSelectorForEntry(Context ctx, BOSObjectType bosType) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic = MbizCollUtil.getEntityDepPropertySelector(ctx, bosType, true, false, null);
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("expenseType.id"));
        sic.add(new SelectorItemInfo("expenseType.name"));
        sic.add(new SelectorItemInfo("expenseType.number"));
        sic.add(new SelectorItemInfo("operationType.id"));
        sic.add(new SelectorItemInfo("operationType.name"));
        sic.add(new SelectorItemInfo("operationType.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("costCenter.id"));
        sic.add(new SelectorItemInfo("costCenter.name"));
        sic.add(new SelectorItemInfo("costCenter.number"));
        sic.add(new SelectorItemInfo("currencyType.id"));
        sic.add(new SelectorItemInfo("currencyType.name"));
        sic.add(new SelectorItemInfo("currencyType.number"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.type"));
        return sic;
    }

    public static SelectorItemCollection getEntityDepPropertySelector(Context ctx, BOSObjectType bosType, boolean isGetDepOwnProperty, boolean isGetEntryDepProperty, List needGetEntriesList) {
        SelectorItemCollection sic = new SelectorItemCollection();
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entityInfo = loader.getEntity(bosType);
        PropertyCollection pCollection = entityInfo.getPropertiesRuntime();
        for (int i = 0; i < pCollection.size(); ++i) {
            RelationshipInfo resInfo;
            PropertyInfo propInfo = entityInfo.getPropertyByName(pCollection.get(i).toString());
            if (propInfo == null) continue;
            if (propInfo.isConfigured()) {
                if (isGetDepOwnProperty && propInfo instanceof OwnPropertyInfo) {
                    sic.add(new SelectorItemInfo(pCollection.get(i).toString()));
                } else if (propInfo instanceof LinkPropertyInfo) {
                    sic.add(new SelectorItemInfo(pCollection.get(i).toString() + ".*"));
                }
            }
            if (!isGetEntryDepProperty || propInfo.getMappingField() != null || !(propInfo instanceof LinkPropertyInfo) || needGetEntriesList != null && !needGetEntriesList.contains(propInfo.getName()) || (resInfo = ((LinkPropertyInfo)propInfo).getRelationship()) == null || resInfo.getSupplierObject() == null) continue;
            SelectorItemCollection entrySelector = MbizCollUtil.getEntryEntityDepPropertySelector(ctx, resInfo.getSupplierObject().getType(), propInfo, isGetDepOwnProperty);
            sic.addObjectCollection((IObjectCollection)entrySelector);
        }
        return sic;
    }

    public static SelectorItemCollection getEntryEntityDepPropertySelector(Context ctx, BOSObjectType bosType, PropertyInfo entryPropertyInfo, boolean isGetDepOwnProperty) {
        SelectorItemCollection sic = new SelectorItemCollection();
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entityInfo = loader.getEntity(bosType);
        PropertyCollection pCollection = entityInfo.getPropertiesRuntime();
        for (int i = 0; i < pCollection.size(); ++i) {
            PropertyInfo propInfo = entityInfo.getPropertyByName(pCollection.get(i).toString());
            if (propInfo == null || !propInfo.isConfigured()) continue;
            if (isGetDepOwnProperty && propInfo instanceof OwnPropertyInfo) {
                sic.add(new SelectorItemInfo(pCollection.get(i).toString()));
                continue;
            }
            if (!(propInfo instanceof LinkPropertyInfo)) continue;
            sic.add(new SelectorItemInfo(entryPropertyInfo.getName() + "." + pCollection.get(i).toString() + ".*"));
        }
        return sic;
    }
}

