/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.openApi;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.openapi.util.json.JSONUtils;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.openApi.BillResultInfo;
import com.kingdee.eas.cp.bc.app.openApi.IImporter;
import com.kingdee.eas.cp.bc.app.openApi.OpenApiUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractDefaultImporter
implements IImporter {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.openApi.AbstractDefaultImporter");
    public static final String SAVE = "SAVE";
    public static final String SUBMIT = "SUBMIT";
    protected static String[] notNullFieldForSaveBase = new String[]{"applierCompany", "applier"};
    protected static String[] notNullFieldForSubmitBase = new String[]{"applierCompany", "applier", "orgUnit", "cause", "currencyType", "bizReqDate"};
    protected Context ctx;

    public AbstractDefaultImporter(Context ctx) {
        this.ctx = ctx;
    }

    public IObjectPK save(CoreBillBaseInfo model, BillResultInfo result) throws Exception {
        IObjectPK retValue = null;
        this.checkBillNumber(model, result);
        this.verifyBillForSave(model, result);
        this.initDataByNumber(model, result);
        this.checkBillPermission(model, result);
        if (!result.hasError()) {
            retValue = this.getInterface().save((CoreBaseInfo)model);
        }
        return retValue;
    }

    private void checkBillNumber(CoreBillBaseInfo model, BillResultInfo result) throws CodingRuleException, EASBizException, BOSException {
        CoreBillBaseInfo info;
        String number = model.getNumber();
        if (number != null && number.toString() != "" && (info = this.getInterface().getCoreBillBaseInfo("select id where number='" + number + "'")).getId() != null) {
            result.addErrorMsgs("\u7cfb\u7edf\u5df2\u5b58\u5728\u7f16\u53f7\u4e3a" + number + "\u7684\u5355\u636e");
        }
    }

    public IObjectPK submit(CoreBillBaseInfo model, BillResultInfo result) throws Exception {
        IObjectPK retValue = null;
        this.checkBillNumber(model, result);
        this.verifyBillForSubmit(model, result);
        this.initDataByNumber(model, result);
        this.checkBillPermission(model, result);
        if (!result.hasError()) {
            model.put("state", (Object)StateEnum.SUBMIT);
            retValue = this.getInterface().submit((CoreBaseInfo)model);
        }
        return retValue;
    }

    public void verifyBillForSave(CoreBillBaseInfo model, BillResultInfo result) {
        if (result.hasError()) {
            return;
        }
        this.verifyBillHeadForSave(model, result);
        this.verifyBillEntryForSave(model, result);
    }

    public void verifyBillForSubmit(CoreBillBaseInfo model, BillResultInfo result) {
        if (result.hasError()) {
            return;
        }
        this.verifyBillHeadForSubmit(model, result);
        this.verifyBillEntryForSubmit(model, result);
    }

    public void verifyBillHeadForSave(CoreBillBaseInfo model, BillResultInfo result) {
        OpenApiUtil.verifyData((CoreBaseInfo)model, result, notNullFieldForSaveBase);
    }

    public void verifyBillHeadForSubmit(CoreBillBaseInfo model, BillResultInfo result) {
        OpenApiUtil.verifyData((CoreBaseInfo)model, result, notNullFieldForSubmitBase);
    }

    public void verifyBillEntryForSave(CoreBillBaseInfo model, BillResultInfo result) {
        AbstractObjectCollection entries = (AbstractObjectCollection)model.get("entries");
        if (entries.size() < 1) {
            result.addErrorMsgs("\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public void verifyBillEntryForSubmit(CoreBillBaseInfo model, BillResultInfo result) {
        AbstractObjectCollection entries = (AbstractObjectCollection)model.get("entries");
        if (entries.size() < 1) {
            result.addErrorMsgs("\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
    }

    public void initDataByNumber(CoreBillBaseInfo model, BillResultInfo result) throws BOSException {
        if (result.hasError()) {
            return;
        }
        OpenApiUtil.buildInfoByNumber(this.ctx, (CoreBaseInfo)model, result);
    }

    @Override
    public BillResultInfo importing(CoreBillBaseInfo model, String params) {
        BillResultInfo result = new BillResultInfo();
        IObjectPK retValue = null;
        try {
            HashMap paramsMap = JSONUtils.convertJsonToObject((String)params);
            String action = (String)paramsMap.get("actionType");
            if (SAVE.equalsIgnoreCase(action)) {
                retValue = this.save(model, result);
            } else if (SUBMIT.equalsIgnoreCase(action)) {
                retValue = this.submit(model, result);
            } else {
                result.setStatus(1);
                result.addErrorMsgs("actionType\u4e0d\u5339\u914d");
            }
        }
        catch (Exception e) {
            result.addErrorMsgs(e.getMessage());
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (!result.hasError()) {
            result.setStatus(0);
            result.setId(retValue != null ? retValue.toString() : null);
            result.setNumber(model.getNumber());
        }
        return result;
    }

    public void checkBillPermission(CoreBillBaseInfo model, BillResultInfo result) {
        String permissionItem = this.getEditPermItemName();
        if (StringUtils.isEmpty((String)permissionItem)) {
            return;
        }
        CompanyOrgUnitInfo applierCompany = (CompanyOrgUnitInfo)model.get("applierCompany");
        if (applierCompany == null) {
            return;
        }
        UserInfo user = (UserInfo)this.ctx.get((Object)"UserInfo");
        String userId = user.getId().toString();
        String companyId = applierCompany.getId().toString();
        logger.info((Object)("##checkBillPermission userId=" + userId + ",companyId=" + companyId + ",permissionItem" + permissionItem));
        try {
            PermissionFactory.getLocalInstance((Context)this.ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(companyId), permissionItem);
        }
        catch (EASBizException e) {
            result.addErrorMsgs(e.getMessage());
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            result.addErrorMsgs(e.getMessage());
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected String getEditPermItemName() {
        return null;
    }

    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    public abstract Class getInfoClass();

    @Override
    public abstract ICoreBillBase getInterface() throws BOSException;
}

