/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.app.reverse.payPlan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AdjustStateEnum;
import com.kingdee.eas.cp.bc.BizAccountOutBillInfo;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.cp.bc.BizCollException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CreateToException;
import com.kingdee.eas.cp.bc.DailyPurchaseAccountBillInfo;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.IBizCollBillBase;
import com.kingdee.eas.cp.bc.StateEnum;
import com.kingdee.eas.cp.bc.app.reverse.payment.BillReverseHandler;
import com.kingdee.eas.fm.pp.PayPlanBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class PayPlanBillReverseHandler {
    static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.app.reverse.payPlan.PayPlanBillReverseHandler");
    public static final String Save = "Save";
    public static final String CallBack = "callBack";
    public static final String EXCHANGERATE = "exchangeRate";

    public static void payPlanHandler(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo baseInfo, PayPlanBillInfo payPlanInfo, String mode) throws BOSException, EASBizException {
        iservice.updatePartial((CoreBaseInfo)baseInfo, BillReverseHandler.getBillSic("id"));
        baseInfo = iservice.getBizCollBillBaseInfo((IObjectPK)new ObjectUuidPK(baseInfo.getId()), BizCollUtil.getBillPaySic(mode));
        PayPlanBillReverseHandler.payPlanSingleHandler(ctx, iservice, baseInfo, payPlanInfo, mode);
    }

    public static BizCollBillBaseInfo payPlanSingleHandler(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo baseInfo, PayPlanBillInfo payPlanInfo, String mode) throws BOSException, EASBizException {
        StringBuilder sb = new StringBuilder();
        sb.append("\u4ed8\u6b3e\u8ba1\u5212\u5355\u53cd\u5199\uff0c\u8d39\u7528\u5355\u636e").append(baseInfo.getNumber()).append(",\u8ba1\u5212\u5355\uff1a").append(payPlanInfo.getNumber()).append(",\u72b6\u6001\uff1a").append((Object)baseInfo.getState()).append(",mode\uff1a").append(mode).append(",\u662f\u5426\u751f\u6210\uff1a").append(baseInfo.isIsCreatePayPlanBill()).append(",\u662f\u5426\u6253\u56de\uff1a").append(baseInfo.isIsCallBackPayPlan()).append(",\u672a\u4ed8\u91d1\u989d\uff1a").append(baseInfo.getAmountNotPaid()).append(",\u4ed8\u6b3e\u91d1\u989d\uff1a").append(payPlanInfo.getApplyPayAmount());
        if (Save.equals(mode)) {
            PayPlanBillReverseHandler.checkBill(ctx, baseInfo, payPlanInfo);
            if (baseInfo.getState().equals((Object)StateEnum.CHECKED)) {
                baseInfo.setIsCreatePayPlanBill(true);
                baseInfo.setState(StateEnum.ISPAYBILL);
                PayPlanBillReverseHandler.updateBill(ctx, iservice, baseInfo, Save);
            }
        } else if (CallBack.equals(mode) && baseInfo.getState().equals((Object)StateEnum.ISPAYBILL) && PayPlanBillReverseHandler.checkTracDownPaybill(ctx, mode, mode) == 0) {
            baseInfo.setIsCreatePayPlanBill(false);
            baseInfo.setIsCallBackPayPlan(true);
            baseInfo.setState(StateEnum.CHECKED);
            PayPlanBillReverseHandler.updateBill(ctx, iservice, baseInfo, CallBack);
        }
        IObjectPK logpk = LogUtil.beginLog((Context)ctx, (String)"payPlanSingleHandler", (BOSObjectType)baseInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(baseInfo.getId()), (String)sb.toString());
        LogUtil.afterLog((Context)ctx, (IObjectPK)logpk);
        return baseInfo;
    }

    public static void checkBill(Context ctx, BizCollBillBaseInfo baseInfo, PayPlanBillInfo payPlanInfo) throws EASBizException, BOSException {
        AdjustStateEnum adjustState;
        if (baseInfo.getState() != null && baseInfo.getState().getValue() < 60) {
            throw new CreateToException(CreateToException.CANNOT_PAYPLANBILL_STATE);
        }
        if (baseInfo instanceof BizAccountOutBillInfo && (AdjustStateEnum.EDIT.equals((Object)(adjustState = ((BizAccountOutBillInfo)baseInfo).getAdjustState())) || AdjustStateEnum.SUBMIT.equals((Object)adjustState) || AdjustStateEnum.CHECKING.equals((Object)adjustState))) {
            throw new BizCollException(BizCollException.ADJUST_CREATETO);
        }
        if (!baseInfo.isIsPaySchedule()) {
            throw new CreateToException(CreateToException.BILL_NOT_PS);
        }
        if (baseInfo.isIsCallBackPayPlan()) {
            throw new CreateToException(CreateToException.CANNOT_PAYPLAN_CALLBACKPAYPLAN);
        }
        if (baseInfo.isIsCreatePayBill()) {
            throw new CreateToException(CreateToException.CANNOT_PAYBILL_PAYPLAN);
        }
        if ((baseInfo instanceof DailyPurchaseAccountBillInfo || baseInfo instanceof BizAccountOutBillInfo) && baseInfo.getBoolean("isCreateOtherBill")) {
            throw new CreateToException(CreateToException.CANNOT_OTHERBILL_PAYPLAN);
        }
        PayPlanBillReverseHandler.checkExpenseAndLoanBill(ctx, baseInfo, payPlanInfo);
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add("CP080");
        String applierCompanyId = baseInfo.getApplierCompany().getId().toString();
        Map param = ExpenseCommenFacadeFactory.getLocalInstance(ctx).getParamsForCompany(paramList, applierCompanyId);
        BigDecimal payPrec = param.get("CP080") == null ? new BigDecimal("0.00") : new BigDecimal(param.get("CP080").toString());
        CurrencyInfo payCurrency = payPlanInfo.getCurrency();
        if (payPrec.compareTo(BizCollUtil.ZERO) == 0 && payCurrency != null && !payCurrency.getId().equals((Object)baseInfo.getCurrencyType().getId())) {
            payPrec = new BigDecimal("0.05");
        }
        BigDecimal payAmount = PayPlanBillReverseHandler.getPayAmount(ctx, baseInfo, payPlanInfo);
        BigDecimal amountNotPaid = baseInfo.getAmountNotPaid();
        logger.error((Object)("--payPlanHandler payAmount=" + payAmount + ";amountNotPaid=" + amountNotPaid + ";number=" + baseInfo.getNumber() + ";id=" + baseInfo.getString("id")));
        if (payAmount.compareTo(amountNotPaid.add(payPrec)) > 0) {
            throw new CreateToException(CreateToException.PAY_BIGGER_THAN_AMOUNTNOTPAID, new Object[]{amountNotPaid, payAmount});
        }
        BigDecimal amountNotPaidAndPaid = amountNotPaid.add(baseInfo.getAmountPaid());
        BigDecimal payAmountCount = PayPlanBillReverseHandler.getPayAmountCount(ctx, baseInfo);
        logger.error((Object)("--payPlanHandler payAmountCount=" + payAmountCount + ";amountNotPaidAndPaid=" + amountNotPaidAndPaid + ";number=" + baseInfo.getNumber()));
        if (payAmountCount.compareTo(amountNotPaidAndPaid.add(payPrec)) > 0) {
            throw new CreateToException(CreateToException.SOURCEAMOUNT_LT_PAYAMOUNT, new Object[]{amountNotPaidAndPaid, payAmountCount});
        }
    }

    public static void checkExpenseAndLoanBill(Context ctx, BizCollBillBaseInfo baseInfo, PayPlanBillInfo payPlanInfo) throws CreateToException {
        String srcBillHeadID = payPlanInfo.getSrcBillHeadID();
        if (!StringUtils.isEmpty((String)srcBillHeadID) && PayPlanBillReverseHandler.getPayPlanCountByEntryId(ctx, srcBillHeadID) > 1) {
            throw new CreateToException(CreateToException.CANNOT_ENTRY_REPEAT_PAYPLAN);
        }
    }

    public static BigDecimal getPayAmount(Context ctx, BizCollBillBaseInfo baseInfo, PayPlanBillInfo payPlanInfo) throws EASBizException, BOSException {
        String payCurrencyId = payPlanInfo.getCurrency().getId().toString();
        BigDecimal applyPayAmount = payPlanInfo.getApplyPayAmount();
        return PayPlanBillReverseHandler.getPayAmountByExchange(ctx, applyPayAmount, payCurrencyId, baseInfo);
    }

    public static BigDecimal getPayAmountByExchange(Context ctx, BigDecimal payAmountOri, String payCurrencyId, BizCollBillBaseInfo baseInfo) throws EASBizException, BOSException {
        BigDecimal payAmount = null;
        if (payCurrencyId != null && !payCurrencyId.equals(baseInfo.getCurrencyType().getId().toString())) {
            IObjectValue entryCoreBaseInfo = BizCollUtil.getEntryCoreBaseInfo(baseInfo, payCurrencyId);
            payAmount = BizCollUtil.getAmountByAmountOriAndInfo(ctx, baseInfo, entryCoreBaseInfo, payAmountOri, payCurrencyId);
        } else {
            payAmount = payAmountOri;
        }
        return payAmount;
    }

    public static BigDecimal getPayAmountCount(Context ctx, BizCollBillBaseInfo baseInfo) throws EASBizException {
        BigDecimal payAmountSum = BigDecimal.ZERO;
        BigDecimal payAmountOri = BigDecimal.ZERO;
        StringBuffer sqlString = new StringBuffer();
        sqlString.append(" SELECT sum(FApplyPayAmount) as amount, ");
        sqlString.append(" FCurrencyID as currencyId ");
        sqlString.append(" FROM T_PP_PayPlanBill ");
        sqlString.append(" WHERE fsourcebillid = ? ");
        sqlString.append(" group by FCurrencyID  ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlString.toString(), (Object[])new Object[]{baseInfo.getId().toString()});
            while (rowSet.next()) {
                if (rowSet.getBigDecimal("amount") != null) {
                    payAmountOri = rowSet.getBigDecimal("amount");
                }
                String currencyId = rowSet.getString("currencyId");
                logger.error((Object)("--getPayAmountCount payAmountOri=" + payAmountOri + " currencyId=" + currencyId));
                payAmountSum = payAmountSum.add(PayPlanBillReverseHandler.getPayAmountByExchange(ctx, payAmountOri, currencyId, baseInfo));
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)e.getMessage(), e);
            return BizCollUtil.ZERO;
        }
        return payAmountSum;
    }

    public static int getPayPlanCountByEntryId(Context ctx, String entryId) {
        int count = 0;
        StringBuffer sqlString = new StringBuffer();
        sqlString.append(" SELECT count(*) as count ");
        sqlString.append(" FROM T_PP_PayPlanBill ");
        sqlString.append(" WHERE FSRCBILLHEADID = ? ");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlString.toString(), (Object[])new Object[]{entryId});
            while (rowSet.next()) {
                count = rowSet.getInt("count");
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)e.getMessage(), e);
            return count;
        }
        return count;
    }

    public static void updateBill(Context ctx, IBizCollBillBase iservice, BizCollBillBaseInfo billInfo, String type) throws EASBizException, BOSException {
        billInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        billInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("isCreatePayPlanBill"));
        if (type.equals(CallBack)) {
            sic.add(new SelectorItemInfo("isCallBackPayPlan"));
        }
        iservice.updatePartial((CoreBaseInfo)billInfo, sic);
    }

    public static void updateBillProperty(Context ctx, BizCollBillBaseInfo billInfo, String fieldName, Object fieldValue) throws EASBizException, BOSException {
        billInfo.put(fieldName, fieldValue);
        billInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        billInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
        ICoreBase iCoreBase = BizCollUtil.getBizInterfaceByBOSUuid(ctx, billInfo.getId());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(fieldName));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser"));
        iCoreBase.updatePartial((CoreBaseInfo)billInfo, sic);
    }

    protected static void reWriteBillState(IBizCollBillBase iservice, BizCollBillBaseInfo billInfo, StateEnum state) throws BOSException, EASBizException {
        billInfo.setState(state);
        iservice.updatePartial((CoreBaseInfo)billInfo, BillReverseHandler.getBillSic("state"));
    }

    public static int checkTracDownPaybill(Context ctx, String payBillId, String billId) {
        int count = 0;
        StringBuffer sqlString = new StringBuffer();
        sqlString.append("select  count(*) as count from T_BOT_Relation botRelation ");
        sqlString.append(" where FDestObjectID != ? and botRelation.FSrcObjectID= ?");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlString.toString(), (Object[])new Object[]{payBillId, billId});
            while (rowSet.next()) {
                count = rowSet.getInt("count");
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)e.getMessage(), e);
            return count;
        }
        return count;
    }
}

