/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.logger;

import com.kingdee.bos.Context;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public abstract class AbstractLogger {
    protected static final String LEFT = "[";
    protected static final String RIGHT = "]";
    protected static final int INFO = 1;
    protected static final int DEBUG = 2;
    protected Context ctx;
    protected String clazzName = "";
    protected static Logger logger = null;
    protected int level;

    protected void initLogger() {
        if (logger == null) {
            PropertyConfigurator.configure((Properties)this.getLogProperties());
            logger = Logger.getLogger((String)this.getLoggerName());
        }
    }

    public void error(Object message) {
        logger.error((Object)this.handleMessage(message));
    }

    public void info(Object message) {
        if (this.level < 1) {
            return;
        }
        logger.info((Object)this.handleMessage(message));
    }

    public void debug(Object message) {
        if (this.level < 2) {
            return;
        }
        logger.debug((Object)this.handleMessage(message));
    }

    protected Properties getLogProperties() {
        Properties properties = new Properties();
        String appendFullName = "log4j.appender.bc";
        String fileName = System.getProperty("EAS_HOME") + "/logs/cpbcGUI/" + this.getFileName();
        properties.put("log4j.logger." + this.getLoggerName(), "info, bc");
        properties.put("log4j.additivity." + this.getLoggerName(), "true");
        properties.put(appendFullName, "org.apache.log4j.RollingFileAppender");
        properties.put(appendFullName + ".MaxBackupIndex", "10");
        properties.put(appendFullName + ".MaxFileSize", "10MB");
        properties.put(appendFullName + ".layout", "org.apache.log4j.PatternLayout");
        properties.put(appendFullName + ".layout.ConversionPattern", "%d{yyyy-MM-dd HH:mm:ss} [%-5p][%t %l]%m %n");
        properties.put(appendFullName + ".File", fileName);
        properties.put(appendFullName + ".encoding", "UTF-8");
        return properties;
    }

    protected abstract String getFileName();

    protected abstract String getLoggerName();

    protected void initParam() {
        this.level = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String handleMessage(Object message) {
        String error;
        if (message == null) {
            error = "message is null";
        } else if (message instanceof Throwable) {
            Throwable t = (Throwable)message;
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                t.printStackTrace(pw);
                error = sw.toString();
            }
        } else {
            error = message.toString();
        }
        return LEFT + this.clazzName + RIGHT + error;
    }
}

