/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.upgrade.datatask;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.UpgradeBillFacadeFactory;
import com.kingdee.eas.cp.bc.upgrade.datatask.IUpgradeAdapter;
import com.kingdee.eas.cp.bc.upgrade.datatask.UpgradeTaskSchedule;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class UpgradeBillPayEntryAdapter
implements IUpgradeAdapter {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.upgrade.datatask.UpgradeBillPayEntryAdapter");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean upgrade(Context ctx, String taskId, Map upgradeParam) throws BOSException, EASBizException {
        StringBuffer queryOql = new StringBuffer();
        queryOql.append("SELECT FID FROM %s WHERE ((FSTATE = 65 AND FAMOUNTNOTPAID IS NOT NULL AND FAMOUNTNOTPAID != 0) ").append("OR ((FSTATE = 110 OR FSTATE = 115) AND FAMOUNTNOTPAID IS NOT NULL AND FAMOUNTNOTPAID != 0) ").append("OR (FSTATE = 70 OR FSTATE = 115)) AND (FBIZREQDATE <= {%s} AND FBIZREQDATE >= {%s}) ");
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        java.sql.Date nowDate = new java.sql.Date(now.getTime());
        String nowStr = dateFormat.format(now);
        calendar.add(1, -1);
        Date lastYear = calendar.getTime();
        java.sql.Date lastYearDate = new java.sql.Date(lastYear.getTime());
        String lastYearStr = dateFormat.format(lastYear);
        Object iBizCollBillBase = null;
        String billType = (String)upgradeParam.get("billType");
        String tableName = "T_BC_BIZACCOUNTBILL";
        if ("DailyLoanBill".equals(billType)) {
            tableName = "T_BC_DAILYLOANBILL";
        } else if ("BizAccountBill".equals(billType)) {
            tableName = "T_BC_BIZACCOUNTBILL";
        } else if ("EvectionLoanBill".equals(billType)) {
            tableName = "T_BC_EVECTIONLOANBILL";
        } else if ("TravelAccountBill".equals(billType)) {
            tableName = "T_BC_TravelAccountBill";
        } else if ("BizAccountOutbill".equals(billType)) {
            tableName = "T_BC_BizAccountOutBill";
        } else if ("PurchaseAccountBill".equals(billType)) {
            tableName = "T_BC_DAILYPURCHASEACCOUNTBILL";
        } else {
            UpgradeTaskSchedule.stopTask(taskId);
            return false;
        }
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e) {
            SQLUtils.cleanup((Connection)conn);
            logger.error((Object)e);
        }
        try {
            String sql = String.format(queryOql.toString(), tableName, nowDate, lastYearDate);
            String countSql = "SELECT COUNT(1) FROM (" + sql + ")";
            statement = conn.createStatement();
            rs = statement.executeQuery(countSql);
            int size = 0;
            while (rs.next()) {
                size = rs.getInt(1);
            }
            rs = statement.executeQuery(sql);
            int i = 0;
            while (rs.next()) {
                BigDecimal percent = new BigDecimal(++i).multiply(new BigDecimal(100)).divide(new BigDecimal(size), 0, 4);
                UpgradeTaskSchedule.updateProcessMap(taskId, percent.intValue());
                String billId = rs.getString("FID");
                UpgradeBillFacadeFactory.getLocalInstance(ctx).updatePayEntry(billId);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup(rs, statement, (Connection)conn);
        }
        UpgradeTaskSchedule.stopTask(taskId);
        return false;
    }
}

