/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AccountLimitCollection;
import com.kingdee.eas.cp.bc.AccountLimitFactory;
import com.kingdee.eas.cp.bc.AccountLimitInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.BizCommonUtilForWKFacadeFactory;
import com.kingdee.eas.cp.bc.ControlType;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.DataSubmitModeEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.SqlInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AccountLimitAddByExcel
extends BlockDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.AccountLimitAddByExcel");
    private static final String RESOURCE = "com.kingdee.eas.cp.bc.BCImportExportResource";
    private HashSet<Map> dataSet = new HashSet();
    private HashSet<String> permissionSet = new HashSet();
    private static final String[] notNullFields = new String[]{"FPerson_number", "FExpenseType_number", "FCurrency_number", "FYear", "FCompanyOrgUnitNumberOrName"};
    private static final String[] amountFields = new String[]{"FOne", "FTwo", "FThree", "FFour", "FFive", "FSix", "FSeven", "FEight", "FNine", "FTen", "FEleven", "FTwelve"};
    private static final String[] colNames = new String[]{"\u804c\u5458_\u7f16\u7801", "\u8d39\u7528\u7c7b\u578b_\u7f16\u7801", "\u5e01\u522b_\u7f16\u7801", "\u5e74\u5ea6", "\u6240\u5c5e\u516c\u53f8", "\u4e00\u6708\u6807\u51c6", "\u4e8c\u6708\u6807\u51c6", "\u4e09\u6708\u6807\u51c6", "\u56db\u6708\u6807\u51c6", "\u4e94\u6708\u6807\u51c6", "\u516d\u6708\u6807\u51c6", "\u4e03\u6708\u6807\u51c6", "\u516b\u6708\u6807\u51c6", "\u4e5d\u6708\u6807\u51c6", "\u5341\u6708\u6807\u51c6", "\u5341\u4e00\u6708\u6807\u51c6", "\u5341\u4e8c\u6708\u6807\u51c6"};
    private Map<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.cp.bc.app.AccountLimitQuery";
    }

    protected DataSubmitModeEnum getDataSubmitMode() {
        return DataSubmitModeEnum.SQL;
    }

    protected SqlInfo toSQL(Context ctx, IRecord rec) throws TaskExternalException {
        try {
            String queryPositionOql;
            SqlInfo sqlInfo = new SqlInfo();
            this.validateNotNullField(rec);
            this.validateAmountField(rec);
            String personNumber = (String)rec.get((String)"FPerson_number").data;
            String personId = this.getPersonInfoByNumber(ctx, personNumber, null);
            if (personId == null) {
                throw new TaskExternalException(EASResource.getString((String)RESOURCE, (String)"HAS_NO_COMPANY"));
            }
            String numberOrName = (String)rec.get((String)"FCompanyOrgUnitNumberOrName").data;
            CompanyOrgUnitInfo company = this.getCompanyOrgUnitByNumberOrName(ctx, numberOrName);
            if (company == null) {
                throw new TaskExternalException(EASResource.getString((String)RESOURCE, (String)"HAS_NO_COMPANY"));
            }
            IPositionMember iPositionMember = PositionMemberFactory.getLocalInstance((Context)ctx);
            if (!iPositionMember.exists(String.format(queryPositionOql = "SELECT POSITION.ID WHERE POSITION.ADMINORGUNIT.ID IN (SELECT DISTINCT RELATION.FFROMUNITID FROM T_ORG_UNITRELATION RELATION INNER JOIN T_ORG_TYPERELATION TYPE ON TYPE.FID=RELATION.FTYPERELATIONID WHERE RELATION.FTOUNITID='%s' AND TYPE.FFROMTYPE=0 AND TYPE.FTOTYPE=1) AND POSITION.ADMINORGUNIT.ISSEALUP = 0  AND ISPRIMARY = 1 AND PERSON.ID = '%s'", company.getId().toString(), personId))) {
                Object[] params = new Object[]{personNumber, numberOrName};
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"PERSONNOTMATCHCOMPANY"), params));
            }
            String companyOrgId = company.getId().toString();
            ExpenseTypeInfo expenseType = this.getExpenseTypeInfoByNumber(ctx, (String)rec.get((String)"FExpenseType_number").data, company.getLongNumber());
            if (ControlType.No.equals((Object)expenseType.getControlType())) {
                Object[] params = new Object[]{expenseType.getNumber()};
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"FCONTROLTYPENOTCONTROL"), params));
            }
            CurrencyInfo currency = (CurrencyInfo)this.getInfoByNumber(ctx, rec, new CurrencyInfo().getBOSType(), "FCurrency_number");
            String data = (String)rec.get((String)"FYear").data;
            Integer fyear = Integer.valueOf(data);
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String companyIdForPerm = company.getId().toString();
            if (!this.permissionSet.contains(companyIdForPerm)) {
                boolean hasPerm = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(companyIdForPerm), "cp_bc_AccountLimit_Edit");
                if (hasPerm) {
                    this.permissionSet.add(companyIdForPerm);
                } else {
                    Object[] params = new Object[]{personNumber};
                    throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"HASNOTFUNCTIONPERMISSION"), params));
                }
            }
            HashMap<String, Object> tmpMap = new HashMap<String, Object>();
            tmpMap.put("personNumber", personNumber);
            tmpMap.put("expenseTypeNumber", expenseType.getNumber());
            tmpMap.put("currencyNumber", currency.getNumber());
            tmpMap.put("year", fyear);
            if (this.dataSet.contains(tmpMap)) {
                if (!this.isSltImportUpdate()) {
                    throw new TaskExternalException(EASResource.getString((String)RESOURCE, (String)"NOT_ALLOW_REPEAT"));
                }
            } else {
                this.dataSet.add(tmpMap);
            }
            HashMap resultMapExt = BizCommonUtilForWKFacadeFactory.getLocalInstance(ctx).getMapForAccountLimitImport(personId);
            StringBuffer operSql = new StringBuffer();
            String existOql = "SELECT FID WHERE PERSON.NUMBER = '%s' AND EXPENSETYPE.NUMBER = '%s' AND CURRENCY.NUMBER = '%s' AND YEAR = '%s'";
            boolean existSame = AccountLimitFactory.getLocalInstance(ctx).exists(String.format(existOql, personNumber, expenseType.getNumber(), currency.getNumber(), fyear));
            if (existSame && !this.isSltImportUpdate()) {
                throw new TaskExternalException(EASResource.getString((String)RESOURCE, (String)"NOT_ALLOW_REPEAT"));
            }
            if (existSame && this.isSltImportUpdate()) {
                List limitIds = this.getLimitIds(ctx, companyOrgId, personId, fyear, expenseType.getId().toString());
                if (limitIds.size() > 0) {
                    this.checkAccountLimit(ctx, rec, limitIds, companyOrgId, fyear, expenseType.getControlMethod().getValue());
                }
                operSql.append("UPDATE T_BC_ACCOUNTLIMIT SET ");
                if (!StringUtils.isEmpty((String)((String)rec.get((String)"FOne").data))) {
                    operSql.append("FONE = '").append(new BigDecimal((String)rec.get((String)"FOne").data)).append("', ");
                }
                if (!StringUtils.isEmpty((String)((String)rec.get((String)"FTwo").data))) {
                    operSql.append("FTWO = '").append(new BigDecimal((String)rec.get((String)"FTwo").data)).append("', ");
                }
                if (!StringUtils.isEmpty((String)((String)rec.get((String)"FThree").data))) {
                    operSql.append("FTHREE = '").append(new BigDecimal((String)rec.get((String)"FThree").data)).append("', ");
                }
                if (!StringUtils.isEmpty((String)((String)rec.get((String)"FFour").data))) {
                    operSql.append("FFOUR = '").append(new BigDecimal((String)rec.get((String)"FFour").data)).append("', ");
                }
                if (!StringUtils.isEmpty((String)((String)rec.get((String)"FFive").data))) {
                    operSql.append("FFIVE = '").append(new BigDecimal((String)rec.get((String)"FFive").data)).append("', ");
                }
                if (!StringUtils.isEmpty((String)((String)rec.get((String)"FSix").data))) {
                    operSql.append("FSIX = '").append(new BigDecimal((String)rec.get((String)"FSix").data)).append("', ");
                }
                if (!StringUtils.isEmpty((String)((String)rec.get((String)"FSeven").data))) {
                    operSql.append("FSEVEN = '").append(new BigDecimal((String)rec.get((String)"FSeven").data)).append("', ");
                }
                if (!StringUtils.isEmpty((String)((String)rec.get((String)"FEight").data))) {
                    operSql.append("FEIGHT = '").append(new BigDecimal((String)rec.get((String)"FEight").data)).append("', ");
                }
                if (!StringUtils.isEmpty((String)((String)rec.get((String)"FNine").data))) {
                    operSql.append("FNINE = '").append(new BigDecimal((String)rec.get((String)"FNine").data)).append("', ");
                }
                if (!StringUtils.isEmpty((String)((String)rec.get((String)"FTen").data))) {
                    operSql.append("FTEN = '").append(new BigDecimal((String)rec.get((String)"FTen").data)).append("', ");
                }
                if (!StringUtils.isEmpty((String)((String)rec.get((String)"FEleven").data))) {
                    operSql.append("FELEVEN = '").append(new BigDecimal((String)rec.get((String)"FEleven").data)).append("', ");
                }
                if (!StringUtils.isEmpty((String)((String)rec.get((String)"FTwelve").data))) {
                    operSql.append("FTWELVE = '").append(new BigDecimal((String)rec.get((String)"FTwelve").data)).append("', ");
                }
                operSql.append("FCOMPANYORGUNITID = '").append(companyOrgId).append("' ").append("WHERE FPERSONID = '").append(personId).append("' ").append("AND FEXPENSETYPEID = '").append(expenseType.getId().toString()).append("' ").append("AND FCURRENCYID = '").append(currency.getId().toString()).append("' ").append("AND FYEAR = '").append(fyear).append("' ").append("AND FCARRYOVERCOMPANY IS NULL ");
            } else {
                boolean hasExt = false;
                ArrayList keyListExt = new ArrayList();
                ArrayList valueListExt = new ArrayList();
                if (resultMapExt != null && resultMapExt.size() > 0) {
                    hasExt = true;
                    for (Object key : resultMapExt.keySet()) {
                        keyListExt.add(key);
                        valueListExt.add(resultMapExt.get(key));
                    }
                }
                operSql.append("INSERT INTO T_BC_ACCOUNTLIMIT ").append("(FID, FPERSONID, FEXPENSETYPEID, FCURRENCYID, FYEAR, FONE, FTWO, FTHREE, FFOUR, ").append("FFIVE, FSIX, FSEVEN, FEIGHT, FNINE, FTEN, FELEVEN, FTWELVE, ").append("FCOMPANYORGUNITID, FISSTART");
                if (hasExt && keyListExt != null && keyListExt.size() > 0) {
                    for (int i = 0; i < keyListExt.size(); ++i) {
                        operSql.append(", ").append(keyListExt.get(i));
                    }
                }
                operSql.append(") VALUES (").append("NEWBOSID('98E4E4EC')").append(", ").append("'").append(personId).append("', ").append("'").append(expenseType.getId().toString()).append("', ").append("'").append(currency.getId().toString()).append("', ").append("'").append(fyear).append("', ").append("'").append(rec.get((String)"FOne").data == null || StringUtils.isEmpty((String)((String)rec.get((String)"FOne").data)) ? BigDecimal.ZERO : new BigDecimal((String)rec.get((String)"FOne").data)).append("', ").append("'").append(rec.get((String)"FTwo").data == null || StringUtils.isEmpty((String)((String)rec.get((String)"FTwo").data)) ? BigDecimal.ZERO : new BigDecimal((String)rec.get((String)"FTwo").data)).append("', ").append("'").append(rec.get((String)"FThree").data == null || StringUtils.isEmpty((String)((String)rec.get((String)"FThree").data)) ? BigDecimal.ZERO : new BigDecimal((String)rec.get((String)"FThree").data)).append("', ").append("'").append(rec.get((String)"FFour").data == null || StringUtils.isEmpty((String)((String)rec.get((String)"FFour").data)) ? BigDecimal.ZERO : new BigDecimal((String)rec.get((String)"FFour").data)).append("', ").append("'").append(rec.get((String)"FFive").data == null || StringUtils.isEmpty((String)((String)rec.get((String)"FFive").data)) ? BigDecimal.ZERO : new BigDecimal((String)rec.get((String)"FFive").data)).append("', ").append("'").append(rec.get((String)"FSix").data == null || StringUtils.isEmpty((String)((String)rec.get((String)"FSix").data)) ? BigDecimal.ZERO : new BigDecimal((String)rec.get((String)"FSix").data)).append("', ").append("'").append(rec.get((String)"FSeven").data == null || StringUtils.isEmpty((String)((String)rec.get((String)"FSeven").data)) ? BigDecimal.ZERO : new BigDecimal((String)rec.get((String)"FSeven").data)).append("', ").append("'").append(rec.get((String)"FEight").data == null || StringUtils.isEmpty((String)((String)rec.get((String)"FEight").data)) ? BigDecimal.ZERO : new BigDecimal((String)rec.get((String)"FEight").data)).append("', ").append("'").append(rec.get((String)"FNine").data == null || StringUtils.isEmpty((String)((String)rec.get((String)"FNine").data)) ? BigDecimal.ZERO : new BigDecimal((String)rec.get((String)"FNine").data)).append("', ").append("'").append(rec.get((String)"FTen").data == null || StringUtils.isEmpty((String)((String)rec.get((String)"FTen").data)) ? BigDecimal.ZERO : new BigDecimal((String)rec.get((String)"FTen").data)).append("', ").append("'").append(rec.get((String)"FEleven").data == null || StringUtils.isEmpty((String)((String)rec.get((String)"FEleven").data)) ? BigDecimal.ZERO : new BigDecimal((String)rec.get((String)"FEleven").data)).append("', ").append("'").append(rec.get((String)"FTwelve").data == null || StringUtils.isEmpty((String)((String)rec.get((String)"FTwelve").data)) ? BigDecimal.ZERO : new BigDecimal((String)rec.get((String)"FTwelve").data)).append("', ").append("'").append(companyOrgId).append("',").append(0);
                if (hasExt && valueListExt != null && valueListExt.size() > 0) {
                    for (int i = 0; i < valueListExt.size(); ++i) {
                        operSql.append(", '").append(valueListExt.get(i)).append("'");
                    }
                }
                operSql.append(") ");
            }
            logger.error((Object)("-----cpbc-----\u989d\u5ea6\u5f15\u5165sql\u8bed\u53e5" + operSql.toString()));
            sqlInfo.setSql(operSql.toString());
            return sqlInfo;
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo exportFilter = new FilterInfo();
        Map contextMap = this.getContextMap();
        if (contextMap != null && contextMap.get("filterItems") != null) {
            try {
                exportFilter = new FilterInfo((String)contextMap.get("filterItems"));
            }
            catch (ParserException e) {
                logger.error((Object)e);
            }
        } else if (contextMap != null && contextMap.get("context") != null) {
            Context context = (Context)contextMap.get("context");
            exportFilter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", context.get((Object)"CurCompanyId")));
        }
        return exportFilter;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            result = BizCommonUtilForWKFacadeFactory.getLocalInstance(ctx).setValuesForAccountLimitExport(result);
            result.put("FPerson_number", StringUtils.defaultString((String)rs.getString("person.number")));
            result.put("FExpenseType_number", StringUtils.defaultString((String)rs.getString("expenseType.number")));
            result.put("FCurrency_number", StringUtils.defaultString((String)rs.getString("currency.number")));
            result.put("FYear", StringUtils.defaultString((String)rs.getString("year")));
            result.put("FOne", StringUtils.defaultString((String)rs.getString("one")));
            result.put("FTwo", StringUtils.defaultString((String)rs.getString("two")));
            result.put("FThree", StringUtils.defaultString((String)rs.getString("three")));
            result.put("FFour", StringUtils.defaultString((String)rs.getString("four")));
            result.put("FFive", StringUtils.defaultString((String)rs.getString("five")));
            result.put("FSix", StringUtils.defaultString((String)rs.getString("six")));
            result.put("FSeven", StringUtils.defaultString((String)rs.getString("seven")));
            result.put("FEight", StringUtils.defaultString((String)rs.getString("eight")));
            result.put("FNine", StringUtils.defaultString((String)rs.getString("nine")));
            result.put("FTen", StringUtils.defaultString((String)rs.getString("ten")));
            result.put("FEleven", StringUtils.defaultString((String)rs.getString("eleven")));
            result.put("FTwelve", StringUtils.defaultString((String)rs.getString("twelve")));
            result.put("FCompanyOrgUnitNumberOrName", StringUtils.defaultString((String)rs.getString("companyOrgUnit.name")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void validateNotNullField(IRecord rec) throws TaskExternalException {
        int il = notNullFields.length;
        for (int i = 0; i < il; ++i) {
            DataToken dataToken = rec.get(notNullFields[i]);
            if (dataToken == null) {
                Object[] params = new Object[]{notNullFields[i]};
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"NOT_NULL"), params));
            }
            String data = (String)dataToken.data;
            if (!StringUtils.isBlank((String)data)) continue;
            String desc = dataToken.desc;
            if (StringUtils.isBlank((String)desc)) {
                desc = colNames[i];
            }
            Object[] params = new Object[]{desc};
            throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"NOT_NULL"), params));
        }
    }

    private void validateAmountField(IRecord rec) throws TaskExternalException {
        int il = amountFields.length;
        for (int i = 0; i < il; ++i) {
            DataToken dataToken = rec.get(amountFields[i]);
            String data = (String)dataToken.data;
            if (StringUtils.isEmpty((String)data)) continue;
            try {
                BigDecimal amount = new BigDecimal(data);
                if (amount.compareTo(amount.setScale(2, 4)) == 0) continue;
                Object[] params = new Object[]{dataToken.desc};
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"DECIMALS_TOO_LONG"), params));
            }
            catch (TaskExternalException e) {
                throw e;
            }
            catch (Exception e) {
                Object[] params = new Object[]{dataToken.desc};
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"FORMAT_ERROR"), params));
            }
        }
    }

    private ObjectBaseInfo getInfoByNumber(Context ctx, IRecord rec, BOSObjectType type, String propName) throws TaskExternalException {
        try {
            DataToken dataToken = rec.get(propName);
            String number = (String)dataToken.data;
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            StringBuffer queryOql = new StringBuffer();
            queryOql.append("SELECT ID, NUMBER ");
            if (new ExpenseTypeInfo().getBOSType().equals((Object)type)) {
                queryOql.append(", CONTROLTYPE ");
            }
            queryOql.append("WHERE NUMBER = '%s'");
            IObjectCollection collection = iDynamicObject.getCollection(type, String.format(queryOql.toString(), number));
            if (collection == null || collection.size() == 0) {
                Object[] params = new Object[]{dataToken.desc, number};
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"NUMBER_NOT_EXIST"), params));
            }
            return (ObjectBaseInfo)collection.getObject(0);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitByNumberOrName(Context ctx, String numberOrName) throws Exception {
        ICompanyOrgUnit icompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberOrName, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)numberOrName, CompareType.EQUALS));
        filter.setMaskString("#0 or #1");
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("longNumber"));
        CompanyOrgUnitCollection collection = icompany.getCompanyOrgUnitCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            CompanyOrgUnitInfo info = collection.get(0);
            return info;
        }
        return null;
    }

    private String getPersonInfoByNumber(Context ctx, String fPersonNumber, String companyId) throws Exception {
        PersonCollection personCon = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("select id,name,number where number='" + fPersonNumber + "'");
        if (personCon != null && personCon.size() > 0) {
            return personCon.get(0).getId().toString();
        }
        throw new TaskExternalException(EASResource.getString((String)RESOURCE, (String)"PERSON_HAS_NO_COMPANY"));
    }

    private ExpenseTypeInfo getExpenseTypeInfoByNumber(Context ctx, String fExpensetypeNumber, String companyLongNumber) throws Exception {
        ExpenseTypeInfo expenseTypeInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String[] numbers = StringUtils.split((String)companyLongNumber, (String)"!");
        HashSet<String> numberSet = new HashSet<String>(Arrays.asList(numbers));
        filter.getFilterItems().add(new FilterItemInfo("company.number", numberSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)fExpensetypeNumber));
        view.setFilter(filter);
        logger.error((Object)("---cpbc--AccountLimitAddByExcel--getExpenseTypeInfoByNumber---filter:" + filter));
        ExpenseTypeCollection coll = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new TaskExternalException(EASResource.getString((String)RESOURCE, (String)"EXPENSETYPE_HAS_NO_COMPANY"));
        }
        expenseTypeInfo = coll.get(0);
        return expenseTypeInfo;
    }

    private void checkAccountLimit(Context ctx, IRecord rec, List limitIds, String companyOrgId, Integer fyear, int convertMethod) throws EASBizException, BOSException, TaskExternalException {
        BigDecimal one = StringUtils.isEmpty((String)((String)rec.get((String)"FOne").data)) ? new BigDecimal(0) : new BigDecimal((String)rec.get((String)"FOne").data);
        BigDecimal two = StringUtils.isEmpty((String)((String)rec.get((String)"FTwo").data)) ? new BigDecimal(0) : new BigDecimal((String)rec.get((String)"FTwo").data);
        BigDecimal three = StringUtils.isEmpty((String)((String)rec.get((String)"FThree").data)) ? new BigDecimal(0) : new BigDecimal((String)rec.get((String)"FThree").data);
        BigDecimal four = StringUtils.isEmpty((String)((String)rec.get((String)"FFour").data)) ? new BigDecimal(0) : new BigDecimal((String)rec.get((String)"FFour").data);
        BigDecimal five = StringUtils.isEmpty((String)((String)rec.get((String)"FFive").data)) ? new BigDecimal(0) : new BigDecimal((String)rec.get((String)"FFive").data);
        BigDecimal six = StringUtils.isEmpty((String)((String)rec.get((String)"FSix").data)) ? new BigDecimal(0) : new BigDecimal((String)rec.get((String)"FSix").data);
        BigDecimal seven = StringUtils.isEmpty((String)((String)rec.get((String)"FSeven").data)) ? new BigDecimal(0) : new BigDecimal((String)rec.get((String)"FSeven").data);
        BigDecimal eight = StringUtils.isEmpty((String)((String)rec.get((String)"FEight").data)) ? new BigDecimal(0) : new BigDecimal((String)rec.get((String)"FEight").data);
        BigDecimal nine = StringUtils.isEmpty((String)((String)rec.get((String)"FNine").data)) ? new BigDecimal(0) : new BigDecimal((String)rec.get((String)"FNine").data);
        BigDecimal ten = StringUtils.isEmpty((String)((String)rec.get((String)"FTen").data)) ? new BigDecimal(0) : new BigDecimal((String)rec.get((String)"FTen").data);
        BigDecimal eleven = StringUtils.isEmpty((String)((String)rec.get((String)"FEleven").data)) ? new BigDecimal(0) : new BigDecimal((String)rec.get((String)"FEleven").data);
        BigDecimal twelve = StringUtils.isEmpty((String)((String)rec.get((String)"FTwelve").data)) ? new BigDecimal(0) : new BigDecimal((String)rec.get((String)"FTwelve").data);
        ArrayList<BigDecimal> importLimitList = new ArrayList<BigDecimal>();
        importLimitList.add(one);
        importLimitList.add(two);
        importLimitList.add(three);
        importLimitList.add(four);
        importLimitList.add(five);
        importLimitList.add(six);
        importLimitList.add(seven);
        importLimitList.add(eight);
        importLimitList.add(nine);
        importLimitList.add(ten);
        importLimitList.add(eleven);
        importLimitList.add(twelve);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountLimitId", limitIds.get(0));
        params.put("companyId", companyOrgId);
        params.put("year", fyear);
        Map usedAccountLimit = BizCollUtil.getUsedAccountLimit(ctx, params, true);
        String[] months = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve"};
        logger.error((Object)("---cpbc---AccountLimitAddByExcel--accountLimitId:" + limitIds.get(0) + ",usedAccountLimit:" + usedAccountLimit));
        if (convertMethod == 1) {
            for (int i = 0; i <= 11; ++i) {
                BigDecimal importMonthLimit;
                BigDecimal usedMonthLimit = (BigDecimal)usedAccountLimit.get(months[i]);
                if (usedMonthLimit.compareTo(importMonthLimit = (BigDecimal)importLimitList.get(i)) <= 0) continue;
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"NOTIMPORT_USEDMONTHLIMITOVER"), i + 1, usedMonthLimit, importMonthLimit));
            }
        } else {
            BigDecimal usedTotalLimit = new BigDecimal(0);
            BigDecimal importTotalLimit = new BigDecimal(0);
            for (int i = 0; i <= 11; ++i) {
                BigDecimal everyMonthLimit = (BigDecimal)usedAccountLimit.get(months[i]);
                BigDecimal everyImportLimit = (BigDecimal)importLimitList.get(i);
                if ((usedTotalLimit = usedTotalLimit.add(everyMonthLimit)).compareTo(importTotalLimit = importTotalLimit.add(everyImportLimit)) <= 0) continue;
                throw new TaskExternalException(MessageFormat.format(EASResource.getString((String)RESOURCE, (String)"NOTIMPORT_USEDTOTALLIMITOVER"), i + 1, usedTotalLimit, importTotalLimit));
            }
        }
    }

    private List getLimitIds(Context ctx, String companyOrgId, String personId, Integer fyear, String expenseTypeId) {
        ArrayList<String> limitIds = new ArrayList<String>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyOrgId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)fyear, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("expenseType.id", (Object)expenseTypeId, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        logger.error((Object)("---cpbc--AccountLimitAddByExcel--getLimitIds---filter:" + filter));
        try {
            AccountLimitCollection accountLimitCollection = AccountLimitFactory.getLocalInstance(ctx).getAccountLimitCollection(viewInfo);
            if (accountLimitCollection != null && accountLimitCollection.size() > 0) {
                for (int i = 0; i < accountLimitCollection.size(); ++i) {
                    AccountLimitInfo accountLimitInfo = accountLimitCollection.get(i);
                    String limitId = accountLimitInfo.getId().toString();
                    limitIds.add(limitId);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return limitIds;
    }
}

