/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.formula.api.IFormulaFunctions;
import com.kingdee.bos.service.formula.api.InvokeFunctionException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AbstractExpenseTypeSubjectMappingInfo;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.cp.bc.CollectionAccountInfo;
import com.kingdee.eas.cp.bc.CostCenterType;
import com.kingdee.eas.cp.bc.ExpenseTypeAsstActTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeAsstActTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeAsstActTypeInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingInfo;
import com.kingdee.eas.cp.bc.IExpenseTypeAsstActType;
import com.kingdee.eas.cp.bc.IExpenseTypeSubjectMapping;
import com.kingdee.eas.cp.bc.OperationTypeFactory;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.cp.bc.OperationTypeSubjectMappingCollection;
import com.kingdee.eas.cp.bc.OperationTypeSubjectMappingFactory;
import com.kingdee.eas.cp.bc.OperationTypeSubjectMappingInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ExpTpAccFormulaFunctions
implements IFormulaFunctions {
    private Vector funcInfos = new Vector();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.bc.util.ExpTpAccFormulaFunctions");
    private static String BIZCOLLRESOURCE = "com.kingdee.eas.cp.bc.BizCollResource";

    public ExpTpAccFormulaFunctions() {
        String funcInfo_CATEGORY_OTHER = (ExpTpAccFormulaFunctions)this.new FuncInfo().CATEGORY_OTHER;
        this.funcInfos.add(new FuncInfo("__BOTgetExpenseTypeAccountOnOrgUnit", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetExpenseTypeAccountOnOrgUnit")));
        this.funcInfos.add(new FuncInfo("__BOTgetOperateionTypeDebitAccount", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetOperateionTypeDebitAccount")));
        this.funcInfos.add(new FuncInfo("__BOTgetOperateionTypeLenderAccount", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetOperateionTypeLenderAccount")));
        this.funcInfos.add(new FuncInfo("__BOTgetSupplierByCompany", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetSupplierByCompany")));
        this.funcInfos.add(new FuncInfo("__BOTgetLoanAccountOnOrgUnit", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetLoanAccountOnOrgUnit")));
        this.funcInfos.add(new FuncInfo("__BOTgetCompanyByOrgUnit", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetCompanyByOrgUnit")));
        this.funcInfos.add(new FuncInfo("__BOTgetAsstActTypeByExpenseType", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetAsstActTypeByExpenseType")));
        this.funcInfos.add(new FuncInfo("__BOTgetOrgUnitByCostCenter", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetOrgUnitByCostCenter")));
        this.funcInfos.add(new FuncInfo("__BOTgetExpenseTypePCAAccountOnOrgUnit", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetExpenseTypePCAAccountOnOrgUnit")));
        this.funcInfos.add(new FuncInfo("__BOTgetPCALoanAccountOnOrgUnit", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetPCALoanAccountOnOrgUnit")));
        this.funcInfos.add(new FuncInfo("__BOTgetOperateionTypePCADebitAccount", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetOperateionTypePCADebitAccount")));
        this.funcInfos.add(new FuncInfo("__BOTgetOperateionTypePCALenderAccount", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetOperateionTypePCALenderAccount")));
        this.funcInfos.add(new FuncInfo("__BOTgetPayAccount", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetPayAccount")));
        this.funcInfos.add(new FuncInfo("__BOTgetPayAccountBank", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetPayAccountBank")));
        this.funcInfos.add(new FuncInfo("__BOTgetBank", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetBank")));
        this.funcInfos.add(new FuncInfo("__BOTgetExpenseTypeAccount", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetExpenseTypeAccount")));
        this.funcInfos.add(new FuncInfo("__BOTgetLoanAccount", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetExpenseTypeLoanAccount")));
        this.funcInfos.add(new FuncInfo("__BOTgetPayerById", funcInfo_CATEGORY_OTHER, this.getStrResource("BOTgetPayerById")));
    }

    public String[] getAllFuncNames() {
        String[] funcNames = new String[this.funcInfos.size()];
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            funcNames[i] = ((FuncInfo)this.funcInfos.get((int)i)).funcName;
        }
        return funcNames;
    }

    public String getFuncCategory(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get((int)i)).funcName)) continue;
            return ((FuncInfo)this.funcInfos.get((int)i)).funcCategory;
        }
        return null;
    }

    public String getFuncDesc(String funcName) {
        if (funcName == null) {
            return null;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get((int)i)).funcName)) continue;
            return ((FuncInfo)this.funcInfos.get((int)i)).funcDesc;
        }
        return null;
    }

    public boolean existFunction(String funcName) {
        if (funcName == null) {
            return false;
        }
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            if (!funcName.equals(((FuncInfo)this.funcInfos.get((int)i)).funcName)) continue;
            return true;
        }
        return false;
    }

    public Object evalFunction(String funcName, List paramList) throws KScriptException {
        if (funcName == null) {
            return null;
        }
        try {
            if (paramList != null && paramList.size() > 0) {
                Context ctx = (Context)paramList.get(0);
                return this.getInnerAsstActProperty(ctx, funcName, paramList);
            }
        }
        catch (InvokeFunctionException e) {
            throw new KScriptException(e.toString());
        }
        catch (BOSException e) {
            throw new KScriptException(e.toString());
        }
        catch (EASBizException e) {
            throw new KScriptException(e.toString());
        }
        return null;
    }

    private Object getInnerAsstActProperty(Context ctx, String funcName, List paramList) throws InvokeFunctionException, BOSException, EASBizException {
        if (paramList == null || paramList.size() < 1) {
            throw new InvokeFunctionException(funcName, 2);
        }
        if (paramList.size() > 4) {
            throw new InvokeFunctionException(funcName, 1);
        }
        if (paramList.get(1) == null) {
            return null;
        }
        if ("__BOTgetExpenseTypeAccountOnOrgUnit".equals(funcName)) {
            return this.getAccuralPrepareAccount(ctx, paramList.get(1).toString(), paramList.get(2).toString());
        }
        if ("__BOTgetOperateionTypeDebitAccount".equals(funcName)) {
            return this.getOperationTypeAccount(ctx, paramList.get(1).toString(), paramList.get(2).toString(), "debit");
        }
        if ("__BOTgetOperateionTypeLenderAccount".equals(funcName)) {
            return this.getOperationTypeAccount(ctx, paramList.get(1).toString(), paramList.get(2).toString(), "lender");
        }
        if ("__BOTgetSupplierByCompany".equals(funcName)) {
            return this.getSupplierByCompany(ctx, paramList.get(1).toString());
        }
        if ("__BOTgetLoanAccountOnOrgUnit".equals(funcName)) {
            return this.getLoanAccount(ctx, paramList.get(1).toString(), paramList.get(2).toString());
        }
        if ("__BOTgetCompanyByOrgUnit".equals(funcName)) {
            return this.getCompanyByOrgUnit(ctx, paramList.get(1).toString());
        }
        if ("__BOTgetAsstActTypeByExpenseType".equals(funcName)) {
            String expenseTypeId = paramList.get(1).toString();
            String companyId = paramList.get(2).toString();
            int asstActTypeNumber = (Integer)paramList.get(3);
            return this.getAsstActTypeByExpenseType(ctx, expenseTypeId, companyId, asstActTypeNumber);
        }
        if ("__BOTgetOrgUnitByCostCenter".equals(funcName)) {
            return this.getOrgUnitByCostCenter(ctx, paramList.get(1).toString());
        }
        if ("__BOTgetExpenseTypePCAAccountOnOrgUnit".equals(funcName)) {
            return this.getPCAAccuralPrepareAccount(ctx, paramList.get(1).toString(), paramList.get(2).toString());
        }
        if ("__BOTgetPCALoanAccountOnOrgUnit".equals(funcName)) {
            return this.getPCALoanAccount(ctx, paramList.get(1).toString(), paramList.get(2).toString());
        }
        if ("__BOTgetOperateionTypePCADebitAccount".equals(funcName)) {
            return this.getOperationTypePCAAccount(ctx, paramList.get(1).toString(), paramList.get(2).toString(), "debit");
        }
        if ("__BOTgetOperateionTypePCALenderAccount".equals(funcName)) {
            return this.getOperationTypePCAAccount(ctx, paramList.get(1).toString(), paramList.get(2).toString(), "lender");
        }
        if ("__BOTgetPayAccount".equals(funcName)) {
            return this.getPayAccount(ctx, (CompanyOrgUnitInfo)paramList.get(1), (CurrencyInfo)paramList.get(2));
        }
        if ("__BOTgetPayAccountBank".equals(funcName)) {
            return this.getPayAccountBank(ctx, (CompanyOrgUnitInfo)paramList.get(1), (CurrencyInfo)paramList.get(2));
        }
        if ("__BOTgetBank".equals(funcName)) {
            return this.getBank(ctx, (CompanyOrgUnitInfo)paramList.get(1), (CurrencyInfo)paramList.get(2));
        }
        if ("__BOTgetExpenseTypeAccount".equals(funcName)) {
            return this.getExpenseTypeAccount(ctx, paramList.get(1).toString(), paramList.get(2).toString(), paramList.get(3).toString());
        }
        if ("__BOTgetLoanAccount".equals(funcName)) {
            return this.getLoanAccount(ctx, paramList.get(1).toString(), paramList.get(2).toString(), paramList.get(3).toString());
        }
        if ("__BOTgetPayerById".equals(funcName)) {
            return this.getPayerById(ctx, paramList.get(1).toString());
        }
        return null;
    }

    public Object getPayerById(Context ctx, String payerId) throws InvokeFunctionException {
        CoreBaseCollection coreCol;
        if (StringUtils.isEmpty((String)payerId) || !BOSUuid.isValidLength((String)payerId)) {
            logger.info((Object)("##getPayerById payerId isValid payerId=" + payerId));
            return null;
        }
        CoreBaseInfo result = null;
        String bosType = BOSUuid.read((String)payerId).getType().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        if (new PersonInfo().getBOSType().toString().equals(bosType)) {
            sic.addObjectCollection((IObjectCollection)this.getPersonSic());
        }
        if (new PersonInfo().getBOSType().toString().equals(bosType) || new CustomerInfo().getBOSType().toString().equals(bosType) || new SupplierInfo().getBOSType().toString().equals(bosType)) {
            coreCol = ExpTpAccFormulaFunctions.getCoreBaseCollection(ctx, BOSObjectType.create((String)bosType), payerId, sic);
            if (coreCol != null && coreCol.size() > 0) {
                result = coreCol.get(0);
            }
        } else if (new CollectionAccountInfo().getBOSType().toString().equals(bosType)) {
            sic.add(new SelectorItemInfo("applier.id"));
            sic.add(new SelectorItemInfo("applier.number"));
            sic.add(new SelectorItemInfo("applier.name"));
            coreCol = ExpTpAccFormulaFunctions.getCoreBaseCollection(ctx, BOSObjectType.create((String)bosType), payerId, sic);
            if (coreCol != null && coreCol.size() > 0) {
                CollectionAccountInfo collAccountInfo = (CollectionAccountInfo)coreCol.get(0);
                result = collAccountInfo.getApplier();
            }
        }
        String logStr = "##getPayerById payerId=" + payerId + ",result=" + (result == null ? "is null" : result.getString("number"));
        logger.info((Object)logStr);
        return result;
    }

    public SelectorItemCollection getPersonSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("idNum"));
        sic.add(new SelectorItemInfo("email"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("gender"));
        sic.add(new SelectorItemInfo("cell"));
        sic.add(new SelectorItemInfo("employeeType.id"));
        sic.add(new SelectorItemInfo("employeeType.name"));
        sic.add(new SelectorItemInfo("employeeType.number"));
        sic.add(new SelectorItemInfo("gkAdmin.id"));
        sic.add(new SelectorItemInfo("gkAdmin.name"));
        sic.add(new SelectorItemInfo("gkAdmin.number"));
        return sic;
    }

    private static CoreBaseCollection getCoreBaseCollection(Context ctx, BOSObjectType bosObjectType, String payerId, SelectorItemCollection sic) throws InvokeFunctionException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)payerId, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        CoreBaseCollection coreCol = null;
        try {
            coreCol = (CoreBaseCollection)DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(bosObjectType, viewInfo);
        }
        catch (BOSException bex) {
            logger.error((Object)bex.getMessage(), (Throwable)bex);
            throw new InvokeFunctionException(bex.getMessage(), (Throwable)bex);
        }
        return coreCol;
    }

    public Object getExpenseTypeAccount(Context ctx, String expenseTypeId, String companyId, String costCenterId) throws InvokeFunctionException {
        AccountViewInfo accountInfo = null;
        try {
            accountInfo = this.getAccountUtil(ctx, expenseTypeId, companyId, costCenterId, true, false);
        }
        catch (EASBizException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new InvokeFunctionException(e1.getMessage());
        }
        catch (BOSException e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            throw new InvokeFunctionException(e2.getMessage());
        }
        return accountInfo;
    }

    public Object getLoanAccount(Context ctx, String expenseTypeId, String companyId, String costCenterId) throws InvokeFunctionException {
        AccountViewInfo accountInfo = null;
        try {
            accountInfo = this.getAccountUtil(ctx, expenseTypeId, companyId, costCenterId, false, false);
        }
        catch (EASBizException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new InvokeFunctionException(e1.getMessage());
        }
        catch (BOSException e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            throw new InvokeFunctionException(e2.getMessage());
        }
        return accountInfo;
    }

    public Object getExpenseTypePCAccount(Context ctx, String expenseTypeId, String companyId, String costCenterId) throws InvokeFunctionException {
        AccountViewInfo accountInfo = null;
        try {
            accountInfo = this.getAccountUtil(ctx, expenseTypeId, companyId, costCenterId, true, true);
        }
        catch (EASBizException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new InvokeFunctionException(e1.getMessage());
        }
        catch (BOSException e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            throw new InvokeFunctionException(e2.getMessage());
        }
        return accountInfo;
    }

    public Object getPCLoanAccount(Context ctx, String expenseTypeId, String companyId, String costCenterId) throws InvokeFunctionException {
        AccountViewInfo accountInfo = null;
        try {
            accountInfo = this.getAccountUtil(ctx, expenseTypeId, companyId, costCenterId, false, true);
        }
        catch (EASBizException e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            throw new InvokeFunctionException(e1.getMessage());
        }
        catch (BOSException e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            throw new InvokeFunctionException(e2.getMessage());
        }
        return accountInfo;
    }

    public Object getAccuralPrepareAccount(Context ctx, String expenseTypeID, String companyId) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(expenseTypeID);
        ExpenseTypeInfo expenseTypeInfo = null;
        AccountViewInfo accountInfo = null;
        try {
            expenseTypeInfo = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeInfo((IObjectPK)pk);
            accountInfo = this.getAccountUtil(ctx, expenseTypeInfo, companyId, false);
        }
        catch (EASBizException e) {
            logger.error((Object)"##cpbc--getAccountUtil error", (Throwable)e);
        }
        return accountInfo;
    }

    public Object getPCAAccuralPrepareAccount(Context ctx, String expenseTypeID, String companyId) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(expenseTypeID);
        ExpenseTypeInfo expenseTypeInfo = null;
        AccountViewInfo accountInfo = null;
        try {
            expenseTypeInfo = ExpenseTypeFactory.getLocalInstance(ctx).getExpenseTypeInfo((IObjectPK)pk);
            accountInfo = this.getAccountUtil(ctx, expenseTypeInfo, companyId, true);
        }
        catch (EASBizException e) {
            logger.error((Object)"##cpbc--getAccountUtil error", (Throwable)e);
        }
        return accountInfo;
    }

    private AccountViewInfo getAccountUtil(Context ctx, ExpenseTypeInfo expenseTypeInfo, String companyId, boolean isPACAccount) throws BOSException, EASBizException {
        if (expenseTypeInfo == null) {
            logger.error((Object)"####getAccountUtil--expenseTypeInfo is null");
            return null;
        }
        long startTime = System.currentTimeMillis();
        logger.error((Object)("####getAccountUtil--expenseTypeID=" + expenseTypeInfo.getId() + ",companyId=" + companyId + ",isPACAccount=" + isPACAccount));
        AbstractExpenseTypeSubjectMappingInfo mappingInfo = null;
        ExpenseTypeSubjectMappingCollection mappingCollection = null;
        AccountViewInfo accountViewInfo = null;
        String cuId = null;
        try {
            String expenseTypeID = expenseTypeInfo.getId().toString();
            CompanyOrgUnitInfo ctrlUnitInfo = null;
            ctrlUnitInfo = companyId != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), ExpTpAccFormulaFunctions.getCompanySic()) : ContextUtil.getCurrentFIUnit((Context)ctx);
            if (ctrlUnitInfo != null) {
                cuId = ctrlUnitInfo.getId().toString();
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("accountId.id"));
            sic.add(new SelectorItemInfo("PCaccountId.id"));
            filter.getFilterItems().add(new FilterItemInfo("expenseTypeId", (Object)expenseTypeID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)cuId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)10, CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2");
            viewInfo.setFilter(filter);
            viewInfo.setSelector(sic);
            logger.error((Object)("####getAccountUtil--filter=" + filter));
            mappingCollection = ExpenseTypeSubjectMappingFactory.getLocalInstance(ctx).getExpenseTypeSubjectMappingCollection(viewInfo);
            if (mappingCollection != null && mappingCollection.size() > 0) {
                int size = mappingCollection.size();
                for (int i = 0; i < size; ++i) {
                    ExpenseTypeSubjectMappingInfo info = mappingCollection.get(i);
                    if (info == null || info.getCostCenterID() != null) continue;
                    mappingInfo = info;
                    break;
                }
            }
            if (mappingInfo == null) {
                String[] numbers = StringUtils.split((String)ctrlUnitInfo.getLongNumber(), (String)"!");
                HashSet<String> cuSet = new HashSet<String>();
                for (int i = 0; i < numbers.length; ++i) {
                    cuSet.add(numbers[i]);
                }
                EntityViewInfo viewInfo2 = new EntityViewInfo();
                FilterInfo filter2 = new FilterInfo();
                filter2.getFilterItems().add(new FilterItemInfo("expenseTypeId", (Object)expenseTypeID, CompareType.EQUALS));
                filter2.getFilterItems().add(new FilterItemInfo("company.number", cuSet, CompareType.INCLUDE));
                filter2.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)10, CompareType.EQUALS));
                filter2.setMaskString("#0 and #1 and #2");
                viewInfo2.setFilter(filter2);
                SorterItemInfo itemInfo = new SorterItemInfo("company.longNumber");
                itemInfo.setSortType(SortType.ASCEND);
                viewInfo2.getSorter().add(itemInfo);
                viewInfo2.setSelector(sic);
                mappingCollection = ExpenseTypeSubjectMappingFactory.getLocalInstance(ctx).getExpenseTypeSubjectMappingCollection(viewInfo2);
                for (int i = mappingCollection.size() - 1; i >= 0; --i) {
                    ExpenseTypeSubjectMappingInfo info = mappingCollection.get(i);
                    if (info == null || info.getCostCenterID() != null) continue;
                    mappingInfo = info;
                    break;
                }
            }
            if (mappingInfo != null) {
                String accountId = null;
                if (isPACAccount) {
                    accountId = mappingInfo.getPCaccountId() == null ? null : mappingInfo.getPCaccountId().getId().toString();
                } else {
                    String string = accountId = mappingInfo.getAccountId() == null ? null : mappingInfo.getAccountId().getId().toString();
                }
                if (accountId != null) {
                    ObjectUuidPK pk = new ObjectUuidPK(accountId);
                    accountViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)pk, ExpTpAccFormulaFunctions.getCommonSic());
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"##cpbc--getAccountUtil error", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"##cpbc--getAccountUtil error", (Throwable)e);
        }
        if (accountViewInfo == null) {
            logger.error((Object)("##cpbc--getAccountUtil--accountViewInfo is null,time\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
        } else {
            logger.error((Object)("##cpbc--getAccountUtil--accountViewInfo=" + accountViewInfo.getName() + "," + accountViewInfo.getNumber() + ",time\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
        }
        return accountViewInfo;
    }

    private AccountViewInfo getAccountUtil(Context ctx, String expenseTypeId, String companyId, String costCenterId, boolean isDebitOrLoan, boolean isPc) throws InvokeFunctionException, BOSException, EASBizException {
        if (StringUtils.isEmpty((String)expenseTypeId)) {
            logger.error((Object)"##cpbc##getAccountUtil--expenseTypeId is null");
            return null;
        }
        if (!ExpenseTypeFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(expenseTypeId))) {
            throw new InvokeFunctionException(EASResource.getString((String)BIZCOLLRESOURCE, (String)"EXPENSETYPE_IS_NULL", (Object[])new Object[]{expenseTypeId}));
        }
        long startTime = System.currentTimeMillis();
        logger.error((Object)("##cpbc##getAccountUtil--expenseTypeID=" + expenseTypeId + ",companyId=" + companyId + ",isAccOrLoan=" + isDebitOrLoan + ",isPc=" + isPc + ",costerCenterId=" + costCenterId));
        AbstractExpenseTypeSubjectMappingInfo mappingInfo = null;
        ExpenseTypeSubjectMappingCollection mappingCollection = null;
        AccountViewInfo accountViewInfo = null;
        CostCenterOrgUnitInfo costCenterOrgInfo = null;
        int costCenterType = 10;
        CompanyOrgUnitInfo company = null;
        if (companyId != null) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), ExpTpAccFormulaFunctions.getCompanySic());
            if (company == null) {
                throw new InvokeFunctionException(EASResource.getString((String)BIZCOLLRESOURCE, (String)"COMPANY_IS_NULL", (Object[])new Object[]{companyId}));
            }
        } else {
            company = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.longNumber"));
        sic.add(new SelectorItemInfo("costCenterType"));
        sic.add(new SelectorItemInfo("costCenterID"));
        if (isPc) {
            sic.add(new SelectorItemInfo("PCaccountId.id"));
            sic.add(new SelectorItemInfo("PCloanAccountID.id"));
        } else {
            sic.add(new SelectorItemInfo("accountId.id"));
            sic.add(new SelectorItemInfo("loanAccountID.id"));
        }
        String[] numbers = StringUtils.split((String)company.getLongNumber(), (String)"!");
        LinkedHashSet<String> cuSet = new LinkedHashSet<String>();
        int k = numbers.length;
        for (int i = 0; i < k; ++i) {
            cuSet.add(numbers[k - i - 1]);
        }
        filter.getFilterItems().add(new FilterItemInfo("expenseTypeId", (Object)expenseTypeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.number", cuSet, CompareType.INCLUDE));
        if (!StringUtils.isEmpty((String)costCenterId)) {
            costCenterOrgInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(costCenterId));
            if (costCenterOrgInfo == null) {
                throw new InvokeFunctionException(EASResource.getString((String)BIZCOLLRESOURCE, (String)"COSTCENTER_IS_NULL", (Object[])new Object[]{costCenterId}));
            }
            costCenterType = costCenterOrgInfo.getCostCenterType().getValue();
        }
        HashSet<Integer> cctSet = new HashSet<Integer>();
        cctSet.add(costCenterType);
        cctSet.add(10);
        filter.getFilterItems().add(new FilterItemInfo("costCenterType", cctSet, CompareType.INCLUDE));
        filter.setMaskString("#0 and #1 and #2");
        ev.setFilter(filter);
        SorterItemInfo itemInfo = new SorterItemInfo("company.longNumber");
        itemInfo.setSortType(SortType.DESCEND);
        ev.getSorter().add(itemInfo);
        mappingCollection = ExpenseTypeSubjectMappingFactory.getLocalInstance(ctx).getExpenseTypeSubjectMappingCollection(ev);
        AbstractExpenseTypeSubjectMappingInfo temp1 = null;
        AbstractExpenseTypeSubjectMappingInfo temp2 = null;
        AbstractExpenseTypeSubjectMappingInfo temp3 = null;
        if (mappingCollection != null && mappingCollection.size() > 0) {
            ExpenseTypeSubjectMappingInfo tempMappingInfo = null;
            for (String lnUp : cuSet) {
                int k2 = mappingCollection.size();
                for (int i = 0; i < k2; ++i) {
                    tempMappingInfo = mappingCollection.get(i);
                    if (!lnUp.equals(tempMappingInfo.getCompany().getNumber())) continue;
                    if (StringUtils.isEmpty((String)costCenterId) && CostCenterType.NoDept.equals((Object)tempMappingInfo.getCostCenterType())) {
                        temp1 = tempMappingInfo;
                        break;
                    }
                    if (costCenterId.equals(tempMappingInfo.getCostCenterID() == null ? "" : tempMappingInfo.getCostCenterID().getId().toString())) {
                        temp1 = tempMappingInfo;
                        continue;
                    }
                    if (costCenterOrgInfo != null && costCenterOrgInfo.getCostCenterType().getValue() == (tempMappingInfo.getCostCenterType() == null ? 10 : tempMappingInfo.getCostCenterType().getValue()) && tempMappingInfo.getCostCenterID() == null) {
                        temp2 = tempMappingInfo;
                        continue;
                    }
                    if (10 != (tempMappingInfo.getCostCenterType() == null ? 10 : tempMappingInfo.getCostCenterType().getValue())) continue;
                    temp3 = tempMappingInfo;
                }
                if (temp1 == null && temp2 == null && temp3 == null) continue;
                break;
            }
        }
        if (temp1 != null) {
            mappingInfo = temp1;
        } else if (temp2 != null) {
            mappingInfo = temp2;
        } else if (temp3 != null) {
            mappingInfo = temp3;
        }
        if (mappingInfo != null) {
            String accountId = null;
            if (isPc) {
                accountId = isDebitOrLoan ? (mappingInfo.getPCaccountId() == null ? null : mappingInfo.getPCaccountId().getId().toString()) : (mappingInfo.getPCloanAccountID() == null ? null : mappingInfo.getPCloanAccountID().getId().toString());
            } else if (isDebitOrLoan) {
                accountId = mappingInfo.getAccountId() == null ? null : mappingInfo.getAccountId().getId().toString();
            } else {
                String string = accountId = mappingInfo.getLoanAccountID() == null ? null : mappingInfo.getLoanAccountID().getId().toString();
            }
            if (!StringUtils.isEmpty((String)accountId)) {
                accountViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId), ExpTpAccFormulaFunctions.getCommonSic());
            }
        }
        if (accountViewInfo == null) {
            logger.error((Object)("##cpbc##getAccountUtil--accountViewInfo is null,time\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
        } else {
            logger.error((Object)("##cpbc##getAccountUtil--accountViewNumber=" + accountViewInfo.getNumber() + ",time\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
        }
        return accountViewInfo;
    }

    public Object getOperationTypeAccount(Context ctx, String operationTypeID, String companyId, String method) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(operationTypeID);
        OperationTypeInfo operationTypeInfo = null;
        AccountViewInfo accountInfo = null;
        try {
            operationTypeInfo = OperationTypeFactory.getLocalInstance(ctx).getOperationTypeInfo((IObjectPK)pk);
            accountInfo = this.getOperationAccountUtil(ctx, operationTypeInfo, companyId, method, false);
        }
        catch (EASBizException e) {
            logger.error((Object)"##cpbc--getOperationAccountUtil error", (Throwable)e);
        }
        return accountInfo;
    }

    public Object getOperationTypePCAAccount(Context ctx, String operationTypeID, String companyId, String method) throws BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(operationTypeID);
        OperationTypeInfo operationTypeInfo = null;
        AccountViewInfo accountInfo = null;
        try {
            operationTypeInfo = OperationTypeFactory.getLocalInstance(ctx).getOperationTypeInfo((IObjectPK)pk);
            accountInfo = this.getOperationAccountUtil(ctx, operationTypeInfo, companyId, method, true);
        }
        catch (EASBizException e) {
            logger.error((Object)"##cpbc--getOperationAccountUtil error", (Throwable)e);
        }
        return accountInfo;
    }

    private AccountViewInfo getOperationAccountUtil(Context ctx, OperationTypeInfo operationTypeInfo, String companyId, String method, boolean isPCAAccount) throws BOSException, EASBizException {
        if (operationTypeInfo == null) {
            logger.error((Object)"####getOperationAccountUtil--expenseTypeInfo is null");
            return null;
        }
        long startTime = System.currentTimeMillis();
        logger.error((Object)("####getOperationAccountUtil--expenseTypeID=" + operationTypeInfo.getId() + ",companyId=" + companyId + ",isPCAAccount=" + isPCAAccount));
        OperationTypeSubjectMappingInfo mappingInfo = null;
        OperationTypeSubjectMappingCollection mappingCollection = null;
        AccountViewInfo accountViewInfo = null;
        String cuId = null;
        try {
            String operationTypeID = operationTypeInfo.getId().toString();
            CompanyOrgUnitInfo ctrlUnitInfo = null;
            ctrlUnitInfo = companyId != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), ExpTpAccFormulaFunctions.getCompanySic()) : ContextUtil.getCurrentFIUnit((Context)ctx);
            if (ctrlUnitInfo != null) {
                cuId = ctrlUnitInfo.getId().toString();
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("debitAccountView.id"));
            sic.add(new SelectorItemInfo("lenderAccountView.id"));
            sic.add(new SelectorItemInfo("PCdebitAccountView.id"));
            sic.add(new SelectorItemInfo("PClenderAccountView.id"));
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("operationType.id", (Object)operationTypeID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)cuId, CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
            viewInfo.setFilter(filter);
            viewInfo.setSelector(sic);
            mappingCollection = OperationTypeSubjectMappingFactory.getLocalInstance(ctx).getOperationTypeSubjectMappingCollection(viewInfo);
            if (mappingCollection != null && mappingCollection.size() > 0) {
                mappingInfo = mappingCollection.get(0);
            } else {
                String[] numbers = StringUtils.split((String)ctrlUnitInfo.getLongNumber(), (String)"!");
                HashSet<String> cuSet = new HashSet<String>();
                for (int i = 0; i < numbers.length; ++i) {
                    cuSet.add(numbers[i]);
                }
                EntityViewInfo viewInfo2 = new EntityViewInfo();
                FilterInfo filter2 = new FilterInfo();
                filter2.getFilterItems().add(new FilterItemInfo("operationType.id", (Object)operationTypeID, CompareType.EQUALS));
                filter2.getFilterItems().add(new FilterItemInfo("company.number", cuSet, CompareType.INCLUDE));
                filter2.setMaskString("#0 and #1");
                viewInfo2.setFilter(filter2);
                viewInfo2.setSelector(sic);
                SorterItemInfo itemInfo = new SorterItemInfo("company.longNumber");
                itemInfo.setSortType(SortType.ASCEND);
                viewInfo2.getSorter().add(itemInfo);
                mappingCollection = OperationTypeSubjectMappingFactory.getLocalInstance(ctx).getOperationTypeSubjectMappingCollection(viewInfo2);
                for (int i = mappingCollection.size() - 1; i >= 0 && (mappingInfo = mappingCollection.get(i)) == null; --i) {
                }
            }
            String accountId = null;
            if (mappingInfo != null) {
                if ("debit".equals(method)) {
                    if (isPCAAccount) {
                        if (mappingInfo.getPCdebitAccountView() != null) {
                            accountId = mappingInfo.getPCdebitAccountView().getId().toString();
                        }
                    } else if (mappingInfo.getDebitAccountView() != null) {
                        accountId = mappingInfo.getDebitAccountView().getId().toString();
                    }
                } else if ("lender".equals(method)) {
                    if (isPCAAccount) {
                        if (mappingInfo.getPClenderAccountView() != null) {
                            accountId = mappingInfo.getPClenderAccountView().getId().toString();
                        }
                    } else if (mappingInfo.getLenderAccountView() != null) {
                        accountId = mappingInfo.getLenderAccountView().getId().toString();
                    }
                }
                if (accountId != null) {
                    ObjectUuidPK pk = new ObjectUuidPK(accountId);
                    accountViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)pk, ExpTpAccFormulaFunctions.getCommonSic());
                }
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"##cpbc--getOperationAccountUtil error", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"##cpbc--getOperationAccountUtil error", (Throwable)e);
        }
        if (accountViewInfo == null) {
            logger.error((Object)("##cpbc--getOperationAccountUtil--accountViewInfo is null,time\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
        } else {
            logger.error((Object)("##cpbc--getOperationAccountUtil--accountViewInfo=" + accountViewInfo.getName() + "," + accountViewInfo.getNumber() + ",time\uff1a" + (System.currentTimeMillis() - startTime) + "ms"));
        }
        return accountViewInfo;
    }

    private SupplierInfo getSupplierByCompany(Context ctx, String companyId) throws BOSException {
        ISupplier supplier = SupplierFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("internalCompany.id", (Object)companyId, CompareType.EQUALS));
        viewInfo.setFilter(fInfo);
        SupplierCollection sc = supplier.getSupplierCollection(viewInfo);
        if (sc != null && sc.size() > 0) {
            SupplierInfo info = sc.get(0);
            return sc.get(0);
        }
        return null;
    }

    private AccountViewInfo getPCALoanAccount(Context ctx, String expenseTypeID, String companyId) throws BOSException, EASBizException {
        return this.getLoanAccountUtil(ctx, expenseTypeID, companyId, true);
    }

    private AccountViewInfo getLoanAccount(Context ctx, String expenseTypeID, String companyId) throws BOSException, EASBizException {
        return this.getLoanAccountUtil(ctx, expenseTypeID, companyId, false);
    }

    private AccountViewInfo getLoanAccountUtil(Context ctx, String expenseTypeID, String companyId, boolean isaPACAccount) throws BOSException, EASBizException {
        logger.error((Object)("####getLoanAccountUtil--expenseTypeID=" + expenseTypeID + ",companyId=" + companyId + ",isaPACAccount=" + isaPACAccount));
        AbstractExpenseTypeSubjectMappingInfo mappingInfo = null;
        AccountViewInfo accountViewInfo = null;
        if (expenseTypeID != null) {
            try {
                CompanyOrgUnitInfo ctrlUnitInfo = null;
                ctrlUnitInfo = companyId != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), ExpTpAccFormulaFunctions.getCompanySic()) : ContextUtil.getCurrentFIUnit((Context)ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                IExpenseTypeSubjectMapping expenseType = ExpenseTypeSubjectMappingFactory.getLocalInstance(ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("loanAccountID.id"));
                sic.add(new SelectorItemInfo("PCloanAccountID.id"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("expenseTypeId", (Object)expenseTypeID, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ctrlUnitInfo.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)10, CompareType.EQUALS));
                filter.setMaskString("#0 and #1 and #2");
                viewInfo.setFilter(filter);
                viewInfo.setSelector(sic);
                logger.error((Object)("####getLoanAccountUtil--filter=" + filter));
                ExpenseTypeSubjectMappingCollection mappingCollection = expenseType.getExpenseTypeSubjectMappingCollection(viewInfo);
                if (mappingCollection != null && mappingCollection.size() > 0) {
                    int size = mappingCollection.size();
                    for (int i = 0; i < size; ++i) {
                        ExpenseTypeSubjectMappingInfo info = mappingCollection.get(i);
                        if (info == null || info.getCostCenterID() != null) continue;
                        mappingInfo = info;
                        break;
                    }
                }
                if (mappingInfo == null) {
                    String[] numbers = StringUtils.split((String)ctrlUnitInfo.getLongNumber(), (String)"!");
                    HashSet<String> cuSet = new HashSet<String>();
                    for (int i = 0; i < numbers.length; ++i) {
                        cuSet.add(numbers[i]);
                    }
                    viewInfo = new EntityViewInfo();
                    FilterInfo fi = new FilterInfo();
                    fi.getFilterItems().add(new FilterItemInfo("expenseTypeId", (Object)expenseTypeID, CompareType.EQUALS));
                    fi.getFilterItems().add(new FilterItemInfo("company.number", cuSet, CompareType.INCLUDE));
                    fi.getFilterItems().add(new FilterItemInfo("costCenterType", (Object)10, CompareType.EQUALS));
                    fi.setMaskString("#0 and #1 and #2");
                    viewInfo.setFilter(fi);
                    viewInfo.setSelector(sic);
                    SorterItemInfo siInfo = new SorterItemInfo("company.longNumber");
                    siInfo.setSortType(SortType.DESCEND);
                    viewInfo.getSorter().add(siInfo);
                    mappingCollection = expenseType.getExpenseTypeSubjectMappingCollection(viewInfo);
                    int size = mappingCollection.size();
                    for (int i = 0; i < size; ++i) {
                        ExpenseTypeSubjectMappingInfo info = mappingCollection.get(i);
                        if (info == null || info.getCostCenterID() != null) continue;
                        mappingInfo = info;
                        break;
                    }
                }
                if (mappingInfo != null) {
                    String loanAccountId = null;
                    if (isaPACAccount) {
                        if (mappingInfo.getPCloanAccountID() != null) {
                            loanAccountId = mappingInfo.getPCloanAccountID().getId().toString();
                        }
                    } else if (mappingInfo.getLoanAccountID() != null) {
                        loanAccountId = mappingInfo.getLoanAccountID().getId().toString();
                    }
                    if (loanAccountId != null) {
                        accountViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(loanAccountId), ExpTpAccFormulaFunctions.getCommonSic());
                    }
                }
            }
            catch (BOSException e) {
                logger.error((Object)"##cpbc--getLoanAccountUtil error", (Throwable)e);
            }
        }
        if (accountViewInfo == null) {
            logger.error((Object)"##cpbc--getLoanAccountUtil--accountViewInfo is null");
        } else {
            logger.error((Object)("##cpbc--getLoanAccountUtil--accountViewInfo=" + accountViewInfo.getName() + "," + accountViewInfo.getNumber()));
        }
        return accountViewInfo;
    }

    public Object getAsstActTypeByExpenseType(Context ctx, String expenseTypeId, String companyId, int asstActTypeNumber) throws BOSException {
        if (expenseTypeId == null) {
            logger.error((Object)"####getAsstActTypeByExpenseType--expenseTypeId is null");
            return null;
        }
        logger.error((Object)("####getAsstActTypeByExpenseType--expenseTypeId=" + expenseTypeId + ",companyId=" + companyId + ",asstActTypeNumber=" + asstActTypeNumber));
        EntityViewInfo evi = new EntityViewInfo();
        IExpenseTypeAsstActType bizInterface = ExpenseTypeAsstActTypeFactory.getLocalInstance(ctx);
        ExpenseTypeAsstActTypeInfo mapInfo = null;
        GeneralAsstActTypeInfo info = null;
        CompanyOrgUnitInfo ctrlUnitInfo = null;
        if (companyId != null) {
            try {
                ctrlUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), ExpTpAccFormulaFunctions.getCompanySic());
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        } else {
            ctrlUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("expenseType.id", (Object)expenseTypeId));
        fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)ctrlUnitInfo.getId().toString()));
        evi.setFilter(fi);
        ExpenseTypeAsstActTypeCollection coll = bizInterface.getExpenseTypeAsstActTypeCollection(evi);
        if (coll != null && coll.size() > 0) {
            mapInfo = coll.get(0);
        } else {
            String[] numbers = StringUtils.split((String)ctrlUnitInfo.getLongNumber(), (String)"!");
            HashSet<String> cuSet = new HashSet<String>();
            for (int i = 0; i < numbers.length; ++i) {
                cuSet.add(numbers[i]);
            }
            FilterInfo fi2 = new FilterInfo();
            fi2.getFilterItems().add(new FilterItemInfo("expenseType.id", (Object)expenseTypeId, CompareType.EQUALS));
            fi2.getFilterItems().add(new FilterItemInfo("company.number", cuSet, CompareType.INCLUDE));
            SorterItemInfo siInfo = new SorterItemInfo("company.longNumber");
            siInfo.setSortType(SortType.DESCEND);
            evi.getSorter().add(siInfo);
            evi.setFilter(fi2);
            evi.setSelector(ExpTpAccFormulaFunctions.getExpTypeAsstActTypeSic());
            coll = bizInterface.getExpenseTypeAsstActTypeCollection(evi);
            if (coll != null && coll.size() > 0) {
                mapInfo = coll.get(0);
            }
        }
        if (mapInfo != null) {
            switch (asstActTypeNumber) {
                case 1: {
                    info = mapInfo.getAsstActType1();
                    break;
                }
                case 2: {
                    info = mapInfo.getAsstActType2();
                    break;
                }
                case 3: {
                    info = mapInfo.getAsstActType3();
                    break;
                }
                case 4: {
                    info = mapInfo.getAsstActType4();
                    break;
                }
                default: {
                    info = mapInfo.getAsstActType1();
                }
            }
        }
        if (info != null) {
            try {
                info = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), ExpTpAccFormulaFunctions.getCommonSic());
            }
            catch (Exception e) {
                logger.error((Object)"####getAsstActTypeByExpenseType error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (info == null) {
            logger.error((Object)"####getAsstActTypeByExpenseType--info is null");
        } else {
            logger.error((Object)("####getAsstActTypeByExpenseType--info=" + info.getName() + "," + info.getNumber()));
        }
        return info;
    }

    public Object getCompanyByOrgUnit(Context ctx, String orgUnitId) throws BOSException {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (orgUnitId != null) {
            try {
                OrgUnitCollection unitColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(orgUnitId.trim(), 0, 1);
                if (unitColl != null && unitColl.size() > 0) {
                    companyOrgUnitInfo = (CompanyOrgUnitInfo)unitColl.get(0);
                }
            }
            catch (EASBizException e) {
                logger.error((Object)("##cp.bc getCompanyByOrgUnit error. " + e.getMessage()), (Throwable)e);
                return companyOrgUnitInfo;
            }
        }
        return companyOrgUnitInfo;
    }

    public Object getOrgUnitByCostCenter(Context ctx, String costCenterId) throws BOSException {
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        if (costCenterId != null) {
            try {
                CostCenterOrgUnitInfo centerOrgUnitInfo;
                adminOrgUnitInfo = (AdminOrgUnitInfo)OrgUnitRelationFactory.getLocalInstance((Context)ctx).getDefaultToUnit(costCenterId, 5, 0);
                if (adminOrgUnitInfo == null && (centerOrgUnitInfo = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(costCenterId))) != null && centerOrgUnitInfo.isIsAdminOrgUnit()) {
                    adminOrgUnitInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(costCenterId), ExpTpAccFormulaFunctions.getCompanySic());
                }
            }
            catch (EASBizException e) {
                logger.error((Object)("##cp.bc getOrgUnitByCostCenter error. " + e.getMessage()), (Throwable)e);
                return adminOrgUnitInfo;
            }
            catch (BOSException e) {
                logger.error((Object)("##cp.bc getOrgUnitByCostCenter error. " + e.getMessage()), (Throwable)e);
                return adminOrgUnitInfo;
            }
        }
        return adminOrgUnitInfo;
    }

    private String getStrResource(String resKey) {
        return EASResource.getString((String)BIZCOLLRESOURCE, (String)resKey);
    }

    public Object getPayAccount(Context ctx, CompanyOrgUnitInfo companyInfo, CurrencyInfo currencyInfo) {
        try {
            AccountBankInfo accountBank = BizCollUtil.getCurrentOrgAccountBankInfo(ctx, companyInfo, currencyInfo);
            if (accountBank != null) {
                logger.error((Object)("##cpbc--getPayAccount=" + accountBank.getAccount()));
                return accountBank.getAccount();
            }
        }
        catch (Exception e) {
            logger.error((Object)"##cpbc--getPayAccount error", (Throwable)e);
        }
        return null;
    }

    public Object getPayAccountBank(Context ctx, CompanyOrgUnitInfo companyInfo, CurrencyInfo currencyInfo) {
        AccountBankInfo obj = null;
        try {
            obj = BizCollUtil.getCurrentOrgAccountBankInfo(ctx, companyInfo, currencyInfo);
        }
        catch (Exception e) {
            logger.error((Object)"##cpbc--getPayAccountBank error", (Throwable)e);
        }
        return obj;
    }

    public Object getBank(Context ctx, CompanyOrgUnitInfo companyInfo, CurrencyInfo currencyInfo) {
        try {
            AccountBankInfo accountBank = BizCollUtil.getCurrentOrgAccountBankInfo(ctx, companyInfo, currencyInfo);
            if (accountBank != null) {
                logger.error((Object)("##cpbc--getBank=" + accountBank.getBank()));
                return accountBank.getBank();
            }
        }
        catch (Exception e) {
            logger.error((Object)"##cpbc--getBank error", (Throwable)e);
        }
        return null;
    }

    public static SelectorItemCollection getCompanySic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        return sic;
    }

    public static SelectorItemCollection getCommonSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        return sic;
    }

    public static SelectorItemCollection getExpTypeAsstActTypeSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("asstActType1"));
        sic.add(new SelectorItemInfo("asstActType2"));
        sic.add(new SelectorItemInfo("asstActType3"));
        sic.add(new SelectorItemInfo("asstActType4"));
        return sic;
    }

    class FuncInfo {
        public final String CATEGORY_OTHER = EASResource.getString((String)"com.kingdee.eas.cp.bc.BCAutoGenerateResource", (String)"103_ExpTpAccFormulaFunctions");
        String funcName;
        String funcCategory;
        String funcDesc;

        public FuncInfo(String name, String category, String desc) {
            this.funcName = name;
            this.funcCategory = category;
            this.funcDesc = desc;
        }

        public FuncInfo() {
        }

        public void setFuncName(String name) {
            this.funcName = name;
        }

        public void setFuncDesc(String desc) {
            this.funcDesc = desc;
        }

        public void setFuncCatetory(String category) {
            this.funcCategory = category;
        }
    }
}

