/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class MultilingualUtil {
    public static DateFormat getDateFormat() {
        DateFormat dateFormat = CtrlFormatUtilities.getDateFormat();
        return dateFormat;
    }

    public static DateFormat getTimeFormat() {
        DateFormat dateFormat = CtrlFormatUtilities.getTimeFormat();
        return dateFormat;
    }

    public static DateFormat getDateTimeFormat() {
        DateFormat dateFormat = CtrlFormatUtilities.getDateTimeFormat();
        return dateFormat;
    }

    public static DecimalFormat getDecimalFormat() {
        DecimalFormat decimalFormat = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
        return decimalFormat;
    }

    public static String getDateFormatString() {
        String strDateFormat = CtrlFormatUtilities.getDateFormatString();
        return strDateFormat;
    }

    public static String getTimeFormatString() {
        String strTimeFormat = CtrlFormatUtilities.getTimeFormatString();
        return strTimeFormat;
    }

    public static String getDateTimeFormatString() {
        String strDateTimeFormat = CtrlFormatUtilities.getDateTimeFormatString();
        return strDateTimeFormat;
    }

    public static String getDecimalFormatString() {
        String strDecimalFormat = CtrlFormatUtilities.getDecimalFormatString();
        return strDecimalFormat;
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        DateFormat dateFormat = MultilingualUtil.getDateFormat();
        if (dateFormat != null) {
            return dateFormat.format(date);
        }
        return format.format((Object)date);
    }

    public static String formatTime(Date date) {
        DateFormat dateFormat = MultilingualUtil.getTimeFormat();
        return dateFormat.format(date);
    }

    public static String formatDateTime(Date date) {
        DateFormat dateFormat = MultilingualUtil.getDateTimeFormat();
        return dateFormat.format(date);
    }

    public static String formatDecimal(BigDecimal val) {
        DecimalFormat decimalFormat = MultilingualUtil.getDecimalFormat();
        decimalFormat.applyPattern(MultilingualUtil.toPattern(val.scale()));
        return decimalFormat.format(val);
    }

    public static String formatDecimal(BigDecimal val, int scale) {
        DecimalFormat decimalFormat = MultilingualUtil.getDecimalFormat();
        decimalFormat.applyPattern(MultilingualUtil.toPattern(scale));
        return decimalFormat.format(val);
    }

    public static String formatDecimal(String text) {
        BigDecimal val = new BigDecimal(MultilingualUtil.removeThousand(text));
        DecimalFormat decimalFormat = MultilingualUtil.getDecimalFormat();
        if (decimalFormat != null) {
            decimalFormat.applyPattern(MultilingualUtil.toPattern(val.scale()));
            return decimalFormat.format(val);
        }
        return text;
    }

    public static String formatDecimal(String text, int scale) {
        BigDecimal val = new BigDecimal(MultilingualUtil.removeThousand(text));
        DecimalFormat decimalFormat = MultilingualUtil.getDecimalFormat();
        decimalFormat.applyPattern(MultilingualUtil.toPattern(scale));
        return decimalFormat.format(val);
    }

    public static DateFormat getDateFormat(Context ctx) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return dateFormat;
    }

    public static DateFormat getDateTimeFormat(Context ctx) throws EASBizException, BOSException {
        HashMap nationmap = MultilingualUtil.getNationMap(ctx);
        DateFormat dateFormat = (DateFormat)nationmap.get("dateTimeFormat");
        return dateFormat;
    }

    public static DecimalFormat getDecimalFormat(Context ctx) throws EASBizException, BOSException {
        HashMap nationmap = MultilingualUtil.getNationMap(ctx);
        DecimalFormat decimalFormat = (DecimalFormat)nationmap.get("numberFormat");
        return decimalFormat;
    }

    public static String formatDate(Context ctx, Date date) throws EASBizException, BOSException {
        DateFormat dateFormat = MultilingualUtil.getDateFormat(ctx);
        return dateFormat.format(date);
    }

    public static String formatDateTime(Context ctx, Date date) throws EASBizException, BOSException {
        DateFormat dateFormat = MultilingualUtil.getDateTimeFormat(ctx);
        return dateFormat.format(date);
    }

    public static String formatDecimal(Context ctx, BigDecimal val) throws EASBizException, BOSException {
        DecimalFormat decimalFormat = MultilingualUtil.getDecimalFormat(ctx);
        decimalFormat.applyPattern(MultilingualUtil.toPattern(val.scale()));
        return decimalFormat.format(val);
    }

    public static String formatDecimal(Context ctx, BigDecimal val, int scale) throws EASBizException, BOSException {
        DecimalFormat decimalFormat = MultilingualUtil.getDecimalFormat(ctx);
        decimalFormat.applyPattern(MultilingualUtil.toPattern(scale));
        return decimalFormat.format(val);
    }

    private static HashMap getNationMap(Context ctx) throws EASBizException, BOSException {
        HashMap nationmap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), ctx.getOriginLocale().toString());
        return nationmap;
    }

    private static String removeThousand(String text) {
        StringBuffer s = new StringBuffer();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (c == ',') continue;
            s.append(c);
        }
        return s.toString();
    }

    private static String toPattern(int scale) {
        StringBuffer s = new StringBuffer(25);
        s.append("###,###,###,###,##0.");
        for (int i = 0; i < scale; ++i) {
            s.append("0");
        }
        return s.toString();
    }
}

