/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.CategoryInfo;
import com.kingdee.eas.cp.dm.DmState;
import com.kingdee.eas.cp.dm.DocHistoryInfo;
import com.kingdee.eas.cp.dm.DocWfState;
import com.kingdee.eas.cp.dm.DocumentCollection;
import com.kingdee.eas.cp.dm.DocumentFactory;
import com.kingdee.eas.cp.dm.DocumentInfo;
import com.kingdee.eas.cp.dm.IDocument;
import com.kingdee.eas.cp.dm.ISynDocumentMark;
import com.kingdee.eas.cp.dm.SynDocumentMarkFactory;
import com.kingdee.eas.cp.dm.SynDocumentMarkInfo;
import com.kingdee.eas.cp.dm.app.AbstractDMForWafFacadeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class DMForWafFacadeControllerBean
extends AbstractDMForWafFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.dm.app.DMForWafFacadeControllerBean");

    @Override
    protected List _cancelDocument(Context ctx, List ids) throws BOSException, EASBizException {
        DocumentCollection docCols = this.getDocumentCollection(ctx, ids);
        if (docCols == null) {
            return null;
        }
        ArrayList<DocumentInfo> tempList = new ArrayList<DocumentInfo>();
        Iterator ite = docCols.iterator();
        ISynDocumentMark iMark = SynDocumentMarkFactory.getLocalInstance(ctx);
        IDocument iDoc = DocumentFactory.getLocalInstance(ctx);
        while (ite.hasNext()) {
            DocumentInfo docInfo = (DocumentInfo)ite.next();
            if (DocWfState.PUBLISH.equals((Object)docInfo.getWfState())) {
                CategoryInfo cateInfo = docInfo.getCategory();
                if (cateInfo.getWfForbProcess() != null && !"".equals(cateInfo.getWfForbProcess())) {
                    docInfo.setWfForbProcess(cateInfo.getWfForbProcess());
                    iDoc.wfCancel(docInfo);
                    SynDocumentMarkInfo markInfo = new SynDocumentMarkInfo();
                    markInfo.setBizID(docInfo.getId().toString());
                    markInfo.setOpraName("cancelDocument");
                    iMark.addnew(markInfo);
                    continue;
                }
                docInfo.setWfState(DocWfState.FORBIDDEN);
                iDoc.update((IObjectPK)new ObjectUuidPK(docInfo.getId()), (CoreBaseInfo)docInfo);
                continue;
            }
            tempList.add(docInfo);
        }
        return tempList;
    }

    @Override
    protected List _cancelCancelDocument(Context ctx, List ids) throws BOSException, EASBizException {
        DocumentCollection docCols = this.getDocumentCollection(ctx, ids);
        if (docCols == null) {
            return null;
        }
        ArrayList<DocumentInfo> tempList = new ArrayList<DocumentInfo>();
        Iterator ite = docCols.iterator();
        IDocument idm = DocumentFactory.getLocalInstance(ctx);
        while (ite.hasNext()) {
            DocumentInfo docInfo = (DocumentInfo)ite.next();
            if (DocWfState.FORBIDDEN.equals((Object)docInfo.getWfState())) {
                idm.setPubState(docInfo.getId());
                continue;
            }
            tempList.add(docInfo);
        }
        return tempList;
    }

    @Override
    protected List _submitDocument(Context ctx, List docIds) throws BOSException, EASBizException {
        DocumentCollection docCols = this.getDocumentCollection(ctx, docIds);
        if (docCols == null) {
            return null;
        }
        ArrayList<DocumentInfo> tempList = new ArrayList<DocumentInfo>();
        Iterator ite = docCols.iterator();
        while (ite.hasNext()) {
            DocumentInfo docInfo = (DocumentInfo)ite.next();
            if (DocWfState.DRAFT.equals((Object)docInfo.getWfState())) {
                ObjectUuidPK tempPk;
                DocumentFactory.getLocalInstance(ctx).submit((CoreBaseInfo)docInfo);
                CategoryInfo cateInfo = docInfo.getCategory();
                if (cateInfo.getWfPubProcess() != null && !"".equals(cateInfo.getWfPubProcess())) {
                    docInfo.setWfState(DocWfState.SUBMIT);
                    docInfo.setWfPubProcess(cateInfo.getWfPubProcess());
                    DocumentFactory.getLocalInstance(ctx).publishDocument(docInfo);
                    continue;
                }
                IDocument idoc = DocumentFactory.getLocalInstance(ctx);
                if (idoc.exists((IObjectPK)(tempPk = new ObjectUuidPK(docInfo.getId())))) {
                    this.setPubState(ctx, tempPk.toString());
                    continue;
                }
                logger.info((Object)("[In the submitDocument] id:" + tempPk.toString() + " is not exist!"));
                continue;
            }
            tempList.add(docInfo);
        }
        return tempList;
    }

    private DocumentCollection getDocumentCollection(Context ctx, List ids) throws BOSException {
        if (ids == null) {
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        int size = ids.size();
        if (size <= 0) {
            return null;
        }
        StringBuffer mark = new StringBuffer();
        mark.append(" ( #0 ");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids.get(0).toString()));
        for (int i = 1; i < size; ++i) {
            mark.append(" or #").append(String.valueOf(i));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids.get(i).toString()));
        }
        mark.append(" ) ");
        filter.setMaskString(mark.toString());
        ev.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("wfState"));
        selector.add(new SelectorItemInfo("category.id"));
        selector.add(new SelectorItemInfo("category.wfForbProcess"));
        selector.add(new SelectorItemInfo("category.wfPubProcess"));
        ev.setSelector(selector);
        DocumentCollection docCols = DocumentFactory.getLocalInstance(ctx).getDocumentCollection(ev);
        return docCols;
    }

    private void setPubState(Context ctx, String billID) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("wfState"));
        selector.add(new SelectorItemInfo("source.id"));
        selector.add(new SelectorItemInfo("category.id"));
        selector.add(new SelectorItemInfo("category.isVerSet"));
        IDocument iDoc = DocumentFactory.getLocalInstance(ctx);
        ObjectUuidPK pk = new ObjectUuidPK(billID);
        DocumentInfo docInfo = iDoc.getDocumentInfo((IObjectPK)pk, selector);
        if (docInfo != null) {
            DocumentInfo sourceDocInfo = docInfo.getSource();
            if (sourceDocInfo != null) {
                CategoryInfo cateInfo = docInfo.getCategory();
                DocumentInfo currentShowDocument = this.getShowDocument(ctx, sourceDocInfo.getId().toString());
                if (currentShowDocument == null) {
                    return;
                }
                if (cateInfo.isIsVerSet()) {
                    currentShowDocument.setIsHistory(true);
                    iDoc.update((IObjectPK)new ObjectUuidPK(currentShowDocument.getId()), (CoreBaseInfo)currentShowDocument);
                    DocHistoryInfo docHistory = new DocHistoryInfo();
                    docHistory.setDeletePerson(null);
                    docHistory.setDeleteTime(this.getTime());
                    docHistory.setState(DmState.ENABLE);
                    docHistory.setDocument(currentShowDocument);
                    docHistory.setSourceDocument(docInfo);
                } else {
                    currentShowDocument.setIsHistory(true);
                    currentShowDocument.setState(DmState.DELETE);
                    iDoc.update((IObjectPK)new ObjectUuidPK(currentShowDocument.getId()), (CoreBaseInfo)currentShowDocument);
                }
            }
            docInfo.setWfState(DocWfState.PUBLISH);
            docInfo.setState(DmState.ENABLE);
            docInfo.setIsHistory(false);
            iDoc.update((IObjectPK)pk, (CoreBaseInfo)docInfo);
        }
    }

    private DocumentInfo getShowDocument(Context ctx, String sourceId) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sourceId));
        filter.getFilterItems().add(new FilterItemInfo("source", (Object)sourceId));
        filter.getFilterItems().add(new FilterItemInfo("wfState", (Object)new Integer(3)));
        filter.getFilterItems().add(new FilterItemInfo("isHistory", (Object)Boolean.FALSE));
        filter.setMaskString(" ( #0 or #1 )and #2 and #3 ");
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("isHistory"));
        ev.setFilter(filter);
        ev.setSelector(selector);
        DocumentCollection docCols = DocumentFactory.getLocalInstance(ctx).getDocumentCollection(ev);
        if (docCols == null) {
            return null;
        }
        int size = docCols.size();
        if (size <= 0) {
            logger.info((Object)"[In the getShowDocument]: not find source document ");
            return null;
        }
        if (size == 1) {
            return docCols.get(0);
        }
        logger.info((Object)"[In the getShowDocument]: find more source documents, select one ");
        return docCols.get(0);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }
}

