/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.DmState;
import com.kingdee.eas.cp.dm.DocAreaInfo;
import com.kingdee.eas.cp.dm.app.AbstractDocAreaControllerBean;
import com.kingdee.eas.cp.dm.app.DmServerService;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DocAreaControllerBean
extends AbstractDocAreaControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.dm.app.DocAreaControllerBean");
    private static final String TABLENAME = "t_dm_docarea";

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        int maxIndex;
        try {
            maxIndex = DmServerService.getMaxMinIndex(ctx, TABLENAME, null, "max");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        DocAreaInfo docAreaInfo = (DocAreaInfo)model;
        docAreaInfo.setIndex(maxIndex + 1);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _cancel(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        DocAreaInfo docAreaInfo = (DocAreaInfo)valueInfo;
        docAreaInfo.setState(DmState.DISABLE);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(docAreaInfo.getId()), (CoreBaseInfo)docAreaInfo);
        this.updateCatStateByDa(ctx, ((DocAreaInfo)valueInfo).getId().toString(), 0);
    }

    @Override
    protected void _cancelCancel(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        DocAreaInfo docAreaInfo = (DocAreaInfo)valueInfo;
        docAreaInfo.setState(DmState.ENABLE);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(docAreaInfo.getId()), (CoreBaseInfo)docAreaInfo);
        this.updateCatStateByDa(ctx, ((DocAreaInfo)valueInfo).getId().toString(), 1);
    }

    private void updateCatStateByDa(Context ctx, String catId, int state) throws BOSException {
        String updateSql = "update t_dm_category  set fstate =" + state + " where fstate != 2 and fdocareaid = '" + catId + "'";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    @Override
    protected void _moveDown(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        DocAreaInfo info = (DocAreaInfo)valueInfo;
        try {
            DmServerService.moveDown(ctx, TABLENAME, info.getIndex(), this.makeWhereExp(), info.getId().toString());
        }
        catch (SQLException e) {
            logger.info((Object)"get docarea maxindex error!");
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _moveUp(Context ctx, IObjectValue valueInfo) throws BOSException, EASBizException {
        DocAreaInfo info = (DocAreaInfo)valueInfo;
        try {
            DmServerService.moveUp(ctx, TABLENAME, info.getIndex(), this.makeWhereExp(), info.getId().toString());
        }
        catch (SQLException e) {
            logger.info((Object)"get docarea minindex error!");
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _cancel(Context ctx, List pkList) throws BOSException, EASBizException {
        DmServerService.changeVOStateBySql(ctx, TABLENAME, 0, pkList);
    }

    @Override
    protected void _cancelCancel(Context ctx, List pkList) throws BOSException, EASBizException {
        DmServerService.changeVOStateBySql(ctx, TABLENAME, 1, pkList);
    }

    private String makeWhereExp() {
        return DmServerService.makeDefaultWhereExp();
    }

    @Override
    protected void _deleteDocArea(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ArrayList<String> pkList = new ArrayList<String>();
        pkList.add(pk.toString());
        DmServerService.changeVOStateBySql(ctx, TABLENAME, 2, pkList);
    }
}

