/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.DmPermPortletInfo;
import com.kingdee.eas.cp.dm.DmPermissionFacadeFactory;
import com.kingdee.eas.cp.dm.DmState;
import com.kingdee.eas.cp.dm.IDmPermissionFacade;
import com.kingdee.eas.cp.dm.PortletSetFactory;
import com.kingdee.eas.cp.dm.PortletSetInfo;
import com.kingdee.eas.cp.dm.app.AbstractPortletSetControllerBean;
import com.kingdee.eas.cp.dm.app.DmServerService;
import com.kingdee.eas.cp.dm.web.DMPortletUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.portal.IPortalServiceFacade;
import com.kingdee.eas.portal.IPortlet;
import com.kingdee.eas.portal.PortalServiceFacadeFactory;
import com.kingdee.eas.portal.PortletFactory;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.PortletParameterInfo;
import com.kingdee.eas.portal.PortletStateEnum;
import com.kingdee.eas.portal.web.configuration.PortletDefinitionsFactoryWrapper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class PortletSetControllerBean
extends AbstractPortletSetControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.dm.app.PortletSetControllerBean");

    @Override
    protected void _cancel(Context ctx, List pkList) throws BOSException, EASBizException {
        DmServerService.changeVOStateBySql(ctx, "t_dm_portletset", 0, pkList);
        this.invokePortletSet(ctx, pkList);
    }

    @Override
    protected void _cancelCancel(Context ctx, List pkList) throws BOSException, EASBizException {
        DmServerService.changeVOStateBySql(ctx, "t_dm_portletset", 1, pkList);
        this.invokePortletSet(ctx, pkList);
    }

    @Override
    protected void _delete(Context ctx, List pkList) throws BOSException {
        DmServerService.changeVOStateBySql(ctx, "t_dm_portletset", 2, pkList);
        this.invokePortletSet(ctx, pkList);
    }

    private void invokePortletSet(Context ctx, List pkList) {
        PortletSetInfo portletSetInfo = null;
        for (int i = 0; i < pkList.size(); ++i) {
            try {
                portletSetInfo = PortletSetFactory.getLocalInstance(ctx).getPortletSetInfo((IObjectPK)new ObjectUuidPK(pkList.get(i).toString()));
                this._portletSet(ctx, portletSetInfo);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void _portletSet(Context ctx, PortletSetInfo portletSetInfo) throws BOSException {
        IPortlet iportlet = PortletFactory.getLocalInstance((Context)ctx);
        IPortalServiceFacade iPortal = PortalServiceFacadeFactory.getLocalInstance((Context)ctx);
        boolean exists = false;
        try {
            if (portletSetInfo.getPortletID() != null) {
                ObjectUuidPK pk = new ObjectUuidPK(portletSetInfo.getPortletID().toString());
                exists = iportlet.exists((IObjectPK)pk);
            }
            PortletInfo pInfo = null;
            if (portletSetInfo.getPortletID() == null || !exists) {
                pInfo = new PortletInfo();
                pInfo.setId(BOSUuid.create((BOSObjectType)pInfo.getBOSType()));
                Locale locale = new Locale("L1");
                pInfo.setPortletName(portletSetInfo.getName(locale), locale);
                pInfo.setDescription(portletSetInfo.getDescription(locale), locale);
                locale = new Locale("L2");
                pInfo.setDescription(portletSetInfo.getDescription(locale), locale);
                pInfo.setPortletName(portletSetInfo.getName(locale), locale);
                locale = new Locale("L3");
                pInfo.setDescription(portletSetInfo.getDescription(locale), locale);
                pInfo.setPortletName(portletSetInfo.getName(locale), locale);
                pInfo.setPortletDefineId("201");
                pInfo.setEnable(PortletStateEnum.PORTLET_RUN);
                Date date = new Date();
                pInfo.setPortletNumber("DM-" + Long.toString(date.getTime()).substring(4));
                PortletParameterInfo paramInfo1 = new PortletParameterInfo();
                paramInfo1.setParamName("id");
                paramInfo1.setParamValue(portletSetInfo.getId().toString());
                pInfo.getParams().add(paramInfo1);
                iPortal.addPortlet(pInfo);
            } else {
                ObjectUuidPK pk = new ObjectUuidPK(portletSetInfo.getPortletID().toString());
                pInfo = (PortletInfo)iportlet.getValue((IObjectPK)pk);
                if (pInfo != null && portletSetInfo.getState().equals((Object)DmState.ENABLE)) {
                    Locale locale = new Locale("L1");
                    pInfo.setPortletName(portletSetInfo.getName(locale), locale);
                    locale = new Locale("L2");
                    pInfo.setPortletName(portletSetInfo.getName(locale), locale);
                    locale = new Locale("L3");
                    pInfo.setPortletName(portletSetInfo.getName(locale), locale);
                    iPortal.update(BOSUuid.read((String)portletSetInfo.getPortletID()), pInfo);
                }
            }
            if (pInfo != null) {
                portletSetInfo.setPortletID(pInfo.getId().toString());
                PortletSetFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(portletSetInfo.getId()), (CoreBaseInfo)portletSetInfo);
            }
            if (portletSetInfo.getState().equals((Object)DmState.DISABLE)) {
                iPortal.disablePortlet(portletSetInfo.getPortletID().toString());
            }
            if (portletSetInfo.getState().equals((Object)DmState.DELETE)) {
                iPortal.deletePortlet(portletSetInfo.getPortletID().toString());
            }
            if (portletSetInfo.getState().equals((Object)DmState.ENABLE)) {
                iPortal.enablePortlet(portletSetInfo.getPortletID().toString());
            }
            PortletDefinitionsFactoryWrapper.refreshPortletDefinitions((Context)ctx);
            PortalServiceFacadeFactory.getLocalInstance((Context)ctx).refreshPortletCache();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Set getDocIdSet(Context ctx, StringBuffer sql) {
        HashSet<String> set = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            set = new HashSet<String>(rs.size());
            logger.info((Object)("getDocIdSet: rs.size()=" + rs.size()));
            while (rs.next()) {
                String permList = rs.getString("permList");
                if (null == permList || "".equals(permList)) continue;
                String[] permListArray = permList.split(",");
                HashSet<String> permListsSet = new HashSet<String>(permListArray.length);
                for (int i = 0; i < permListArray.length; ++i) {
                    permListsSet.add(permListArray[i]);
                }
                if (!permListsSet.contains("3") && !permListsSet.contains("4") && !permListsSet.contains("5") && !permListsSet.contains("6") && !permListsSet.contains("7") && !permListsSet.contains("8") && !permListsSet.contains("10") && !permListsSet.contains("20") && !permListsSet.contains("21") && !permListsSet.contains("22") && !permListsSet.contains("23")) continue;
                if (null != rs.getString("docID") && !"".equals(rs.getString("docID"))) {
                    set.add(rs.getString("docID"));
                    continue;
                }
                if (null == rs.getString("catID") || "".equals(rs.getString("catID"))) continue;
                String getdocIdbyCategoryIdSql = "select fid from t_dm_document where fcategoryid='" + rs.getString("catID") + "'";
                IRowSet docIdByDategoryIdrs = DbUtil.executeQuery((Context)ctx, (String)getdocIdbyCategoryIdSql);
                while (docIdByDategoryIdrs.next()) {
                    String documentId = docIdByDategoryIdrs.getString("fid");
                    String sqlDocumentperson = "select * from t_dm_documentperson where fparentid ='" + documentId + "'";
                    String sqlDocumentadmin = "select * from t_dm_documentadmin where fparentid ='" + documentId + "'";
                    String sqlDocumentrole = "select * from t_dm_documentrole where fparentid ='" + documentId + "'";
                    if (PortletSetControllerBean.isExist(ctx, sqlDocumentperson) || PortletSetControllerBean.isExist(ctx, sqlDocumentadmin) || PortletSetControllerBean.isExist(ctx, sqlDocumentrole)) continue;
                    set.add(documentId);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)("getDocIdSet error:" + e.getMessage()));
        }
        catch (SQLException e) {
            logger.error((Object)("getDocIdSet error:" + e.getMessage()));
        }
        return set;
    }

    public Set getAllAdminSqlMethd(Context ctx, StringBuffer getAllAdminSql) {
        HashSet<String> rtnSet = new HashSet<String>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getAllAdminSql.toString());
            while (rs.next()) {
                String adminLongNum = rs.getString("flongnumber");
                if (null == adminLongNum || "".equals(adminLongNum)) continue;
                String[] as = adminLongNum.split("!");
                int len = as.length;
                for (int i = 0; i < len; ++i) {
                    rtnSet.add(as[i]);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rtnSet;
    }

    public Set getLegalPermDocIdSet(Context ctx, Set categorySet, StringBuffer sql) {
        long begin = System.currentTimeMillis();
        logger.info((Object)("getDmPermListCacheBySql(ctx,sql) the  sql is  " + sql.toString()));
        List dpcList = this.getDmPermListCacheBySql(ctx, sql);
        logger.info((Object)("getDmPermListCacheBySql(ctx,sql)'s resut  " + (null != dpcList ? "size is  " + dpcList.size() : " is null!")));
        HashSet<String> rtnSet = new HashSet<String>();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = "";
        String perId = "";
        if (userInfo != null) {
            userId = userInfo.getId().toString();
            perId = userInfo.getPerson().getId().toString();
        }
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select doc.fid, doc.fWfState,doc.fState, doc.fcategoryId, doc.fauthorid, doc.FisEnablePerm from T_DM_Document doc where doc.fWfState=3 and doc.fState <> 2 and doc.fcategoryId in " + PortletSetControllerBean.getStrFromSet(categorySet));
        logger.info((Object)("Get the docs by categoryId from portletId,the  sql is  " + selectSql.toString()));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            logger.info((Object)("Get the docs by categoryId from portletId,the  result size  is  " + rs.size()));
            String docId = "";
            String categoryId = "";
            String authorId = "";
            boolean isEnablePerm = false;
            int size = dpcList.size();
            block3: while (rs.next()) {
                int i;
                docId = rs.getString("fid");
                categoryId = rs.getString("fcategoryId");
                authorId = rs.getString("fauthorid");
                isEnablePerm = rs.getBoolean("FisEnablePerm");
                if (null == authorId || "".equals(authorId)) continue;
                if (authorId.equals(perId)) {
                    rtnSet.add(docId);
                    continue;
                }
                DmPermPortletInfo dp = null;
                String permList = "";
                boolean hasPut = false;
                if (isEnablePerm) {
                    for (i = 0; i < size; ++i) {
                        if (!(dpcList.get(i) instanceof DmPermPortletInfo) || !docId.equals((dp = (DmPermPortletInfo)dpcList.get(i)).getDocID())) continue;
                        rtnSet.add(docId);
                        continue block3;
                    }
                    continue;
                }
                block5: for (i = 0; i < size && !hasPut; ++i) {
                    if (!(dpcList.get(i) instanceof DmPermPortletInfo) || null != (dp = (DmPermPortletInfo)dpcList.get(i)).getDocID() || null == dp.getCatID() || !dp.getCatID().equals(categoryId)) continue;
                    permList = dp.getPermList();
                    for (String per : permList.split(",")) {
                        if (!per.equals("5") && !per.equals("21") && !per.equals("22") && !per.equals("6") && !per.equals("23") && !per.equals("7") && !per.equals("3") && !per.equals("10") && !per.equals("4")) continue;
                        rtnSet.add(docId);
                        hasPut = true;
                        continue block5;
                    }
                }
            }
            System.out.println("***************************************************getLegalPermDocIdSet tatal cost time " + (System.currentTimeMillis() - begin));
            logger.info((Object)("getLegalPermDocIdSet tatal cost time " + (System.currentTimeMillis() - begin)));
            logger.info((Object)("getLegalPermDocIdSet result size is  " + rtnSet.size()));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rtnSet;
    }

    public List getDmPermListCacheBySql(Context ctx, StringBuffer sql) {
        ArrayList<DmPermPortletInfo> list = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            list = new ArrayList<DmPermPortletInfo>(rs.size());
            logger.info((Object)("getDmPermListCacheBySql: rs.size()=" + rs.size()));
            DmPermPortletInfo dp = null;
            while (rs.next()) {
                dp = new DmPermPortletInfo(rs.getString("adminID"), rs.getString("roleID"), rs.getString("personID"), rs.getString("permList"), rs.getString("docID"), rs.getString("catID"), rs.getString("docAreaID"));
                list.add(dp);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("getDmPermListCacheBySql error:" + e.getMessage()));
        }
        catch (SQLException e) {
            logger.error((Object)("getDmPermListCacheBySql error:" + e.getMessage()));
        }
        return list;
    }

    public static String getStrFromSet(Set set) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int i = 0;
        int len = set.size();
        for (Object key : set) {
            sb.append("'").append((String)key).append("'");
            if (i < len - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    public static boolean isExist(Context ctx, String sql) {
        boolean rtnVal = false;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.size() > 0) {
                rtnVal = true;
            }
        }
        catch (BOSException e) {
            logger.info((Object)"create ejb interface error");
            logger.info((Object)e.getMessage());
        }
        return rtnVal;
    }

    @Override
    protected FilterInfo _getPermDocFilter(Context ctx, String portletId) throws BOSException {
        IDmPermissionFacade idmFacade = DmPermissionFacadeFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        try {
            Set catIdSet = DMPortletUtils.getCatIdSetByPortlet(ctx, portletId);
            if (null != catIdSet && catIdSet.size() > 0) {
                Object perMissionSet = null;
                String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                String perId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
                StringBuffer getAllAdminSql = new StringBuffer();
                getAllAdminSql.append("select ADMINP.fname_l2,ADMINP.flongnumber,ADMINP.fnumber,person.fname_l2,person.fid  \n");
                getAllAdminSql.append("FROM T_BD_PERSON PERSON \n");
                getAllAdminSql.append("LEFT OUTER JOIN T_ORG_PositionMember PM ON PM.FPERSONID = PERSON.FID \n");
                getAllAdminSql.append("LEFT OUTER JOIN T_ORG_Position POSITION ON POSITION.FID = PM.FPOSITIONID \n");
                getAllAdminSql.append("LEFT OUTER JOIN T_ORG_ADMIN ADMINP ON ADMINP.FID = POSITION.FADMINORGUNITID \n");
                getAllAdminSql.append("where PERSON.fid='");
                getAllAdminSql.append(perId);
                getAllAdminSql.append("'");
                Set rtnSet = this.getAllAdminSqlMethd(ctx, getAllAdminSql);
                ArrayList<String> adminNumList = null;
                if (null != rtnSet && rtnSet.size() > 0) {
                    adminNumList = new ArrayList(rtnSet.size());
                    for (String number : rtnSet) {
                        adminNumList.add(number);
                    }
                }
                if (null == adminNumList) {
                    adminNumList = new ArrayList<String>();
                }
                StringBuffer sb = new StringBuffer();
                sb.append("select adminID,roleID,personID,permList,docID,catID,catNumber,catLongNumber,docAreaID from (").append(this.getPerm4CatAdminSql(perId, adminNumList)).append(" UNION ALL").append(this.getPerm4CatRoleSql(perId)).append(" UNION ALL").append(this.getPerm4CatPersonSql(perId)).append(" UNION ALL").append(this.getPerm4DocAdminSql(perId, adminNumList)).append(" UNION ALL").append(this.getPerm4DocRoleSql(perId)).append(" UNION ALL").append(this.getPerm4DocPersonSql(perId)).append(") t");
                Set docIdSet = this.getLegalPermDocIdSet(ctx, catIdSet, sb);
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)docIdSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("category.id", (Object)catIdSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("category.state", (Object)new Integer(1)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filter;
    }

    private StringBuffer getPerm4CatAdminSql(String personId, List adminNumList) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT DISTINCT").append(" T_DM_CategoryAdmin.FAdminID AS adminID,").append(" null as roleID,").append(" null as personID,").append(" T_DM_CategoryAdmin.FPermList AS permList,").append(" null AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_Category T_DM_Category RIGHT OUTER JOIN T_DM_CategoryAdmin T_DM_CategoryAdmin ON T_DM_Category.FID = T_DM_CategoryAdmin.FParentID").append(" WHERE").append(" EXISTS (SELECT T_ORG_Admin.FID").append("         FROM T_ORG_Position T_ORG_Position").append("         INNER JOIN T_ORG_PositionMember T_ORG_PositionMember ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID").append("         INNER JOIN T_ORG_Admin T_ORG_Admin ON T_ORG_Position.FAdminOrgUnitID = T_ORG_Admin.FID").append("         WHERE T_ORG_PositionMember.FPersonID = '").append(personId).append("'        AND T_ORG_Admin.FID = T_DM_CategoryAdmin.FAdminID )").append(" OR EXISTS (SELECT T_ORG_Admin.FID").append(" FROM T_ORG_Admin T_ORG_Admin").append("            WHERE T_ORG_Admin.FID = T_DM_CategoryAdmin.FAdminID AND T_ORG_Admin.FNumber IN ").append(this.getStrFromList(adminNumList)).append(" AND T_DM_CategoryAdmin.FIncludeSub = 1)").append(" AND T_DM_Category.FState <> 2");
        return sb;
    }

    private StringBuffer getPerm4CatRoleSql(String personId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT DISTINCT").append(" null as adminID,").append(" T_DM_CategoryRole.FRoleID AS roleID,").append(" null as personID,").append(" T_DM_CategoryRole.FPermList AS permList,").append(" null AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_CategoryRole T_DM_CategoryRole LEFT OUTER JOIN T_PM_UserRoleOrg T_PM_UserRoleOrg ON T_DM_CategoryRole.FRoleID = T_PM_UserRoleOrg.FRoleID").append(" RIGHT OUTER JOIN T_DM_Category T_DM_Category ON T_DM_CategoryRole.FParentID = T_DM_Category.FID").append(" INNER JOIN T_PM_User T_PM_User ON T_PM_UserRoleOrg.FUserID = T_PM_User.FID").append(" WHERE").append(" T_DM_Category.FState <> 2 AND T_PM_User.FPersonID = '").append(personId).append("'");
        return sb;
    }

    private StringBuffer getPerm4CatPersonSql(String personId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT").append(" null as adminID,").append(" null as roleID,").append(" T_DM_CategoryPerson.FPersonID AS personID,").append(" T_DM_CategoryPerson.FPermList AS permList,").append(" null AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_Category T_DM_Category INNER JOIN T_DM_CategoryPerson T_DM_CategoryPerson ON T_DM_Category.FID = T_DM_CategoryPerson.FParentID").append(" WHERE").append(" T_DM_Category.FState <> 2 AND T_DM_CategoryPerson.FPersonID = '").append(personId).append("'");
        return sb;
    }

    private StringBuffer getPerm4DocAdminSql(String personId, List adminNumList) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT DISTINCT").append(" T_DM_DocumentAdmin.FAdminID AS adminID,").append(" null as roleID,").append(" null as personID,").append(" T_DM_DocumentAdmin.FPermList AS permList,").append(" T_DM_Document.FID AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_DocumentAdmin T_DM_DocumentAdmin LEFT OUTER JOIN T_DM_Document T_DM_Document ON T_DM_DocumentAdmin.FParentID = T_DM_Document.FID").append(" INNER JOIN T_DM_Category T_DM_Category ON T_DM_Document.FCategoryID = T_DM_Category.FID").append(" WHERE ").append(" EXISTS (SELECT T_ORG_Admin.FID").append(" \t\t  FROM T_ORG_Position T_ORG_Position").append(" \t\t  INNER JOIN T_ORG_PositionMember T_ORG_PositionMember ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID").append(" \t\t  INNER JOIN T_ORG_Admin T_ORG_Admin ON T_ORG_Position.FAdminOrgUnitID = T_ORG_Admin.FID").append(" \t\t  WHERE T_ORG_PositionMember.FPersonID = '").append(personId).append("'\t\t  AND T_ORG_Admin.FID = T_DM_DocumentAdmin.FAdminID)").append(" \t\t  OR EXISTS ( SELECT T_ORG_Admin.FID").append(" \t\t  FROM T_ORG_Admin T_ORG_Admin").append(" \t\t  WHERE T_ORG_Admin.FID = T_DM_DocumentAdmin.FAdminID AND T_ORG_Admin.FNumber IN ").append(this.getStrFromList(adminNumList)).append(" \t\t  AND T_DM_DocumentAdmin.FIncludeSub = 1)").append(" \t\t  AND T_DM_Category.FState <> 2 AND T_DM_Document.FState <> 2");
        return sb;
    }

    private StringBuffer getPerm4DocRoleSql(String personId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT DISTINCT").append(" null as adminID,").append(" T_DM_DocumentRole.FRoleID AS roleID,").append(" null as personID,").append(" T_DM_DocumentRole.FPermList AS permList,").append(" T_DM_Document.FID AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_Document T_DM_Document INNER JOIN T_DM_Category T_DM_Category ON T_DM_Document.FCategoryID = T_DM_Category.FID").append(" RIGHT OUTER JOIN T_DM_DocumentRole T_DM_DocumentRole ON T_DM_Document.FID = T_DM_DocumentRole.FParentID").append(" LEFT OUTER JOIN T_PM_UserRoleOrg T_PM_UserRoleOrg ON T_DM_DocumentRole.FRoleID = T_PM_UserRoleOrg.FRoleID").append(" INNER JOIN T_PM_User T_PM_User ON T_PM_UserRoleOrg.FUserID = T_PM_User.FID").append(" WHERE").append(" T_DM_Category.FState <> 2 AND T_DM_Document.FState <> 2 AND T_PM_User.FPersonID = '").append(personId).append("'");
        return sb;
    }

    private StringBuffer getPerm4DocPersonSql(String personId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT").append(" null as adminID,").append(" null as roleID,").append(" T_DM_DocumentPerson.FPersonID AS personID,").append(" T_DM_DocumentPerson.FPermList AS permList,").append(" T_DM_Document.FID AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_Document T_DM_Document INNER JOIN T_DM_Category T_DM_Category ON T_DM_Document.FCategoryID = T_DM_Category.FID").append(" INNER JOIN T_DM_DocumentPerson T_DM_DocumentPerson ON T_DM_Document.FID = T_DM_DocumentPerson.FParentID").append(" WHERE").append(" T_DM_Category.FState <> 2 AND T_DM_DocumentPerson.FPersonID = '").append(personId).append("'");
        return sb;
    }

    private String getStrFromList(List list) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (size == 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("')");
                continue;
            }
            if (i != size - 1) {
                sb.append("'");
                sb.append((String)list.get(i));
                sb.append("', ");
                continue;
            }
            sb.append("'");
            sb.append((String)list.get(i));
            sb.append("')");
        }
        return sb.toString();
    }
}

