/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.archive;

import com.kingdee.eas.cp.dm.archive.util.ArchiUuid;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import org.apache.log4j.Logger;
import sun.misc.BASE64Encoder;

public class ArchiveUtil {
    public static Logger logger = Logger.getLogger((String)"com.kingdee.eas.cp.dm.app.archive.ArchiveUtil");
    private static final long RANDOM_SEED = 876543L;
    private static long lastRandomLongValue;
    private static final String DEFAULT_FILE_EXT_NAME = ".pdf";
    private static final int BASE64_ENCODING_LENGTH = 44;

    public static String getRandomFileName(String fileExtName) {
        Random rd = new Random(876543L);
        if (fileExtName == null || fileExtName.trim().length() <= 0) {
            fileExtName = DEFAULT_FILE_EXT_NAME;
        }
        String randomStr = ArchiveUtil.getSimpleUUIDString("" + rd.nextLong() + ArchiveUtil.getCurrrentDate().getTime());
        randomStr = randomStr.replaceAll("\\/", "G");
        return "" + randomStr + "." + fileExtName;
    }

    public static Date getCurrrentDate() {
        return Calendar.getInstance().getTime();
    }

    public static String getSimpleUUIDString(String type) {
        String uuidStr = "";
        try {
            ArchiUuid uuid = ArchiUuid.randomUUID();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(44);
            DataOutputStream out = new DataOutputStream(baos);
            try {
                out.writeLong(uuid.getMostSignificantBits());
                out.writeLong(uuid.getLeastSignificantBits());
                out.writeInt(type.hashCode());
            }
            catch (IOException ioe) {
                throw new Exception(ioe);
            }
            BASE64Encoder be = new BASE64Encoder();
            uuidStr = be.encode(baos.toByteArray());
        }
        catch (Exception se) {
            logger.info((Object)("\u521b\u5efa SimpleUUID\u629b\u51fa\u5f02\u5e38:" + se.getMessage()));
        }
        return uuidStr;
    }
}

