/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web;

import com.kingdee.eas.cp.dm.web.SmartFile;
import com.kingdee.eas.cp.dm.web.SmartFiles;
import com.kingdee.eas.cp.dm.web.SmartRequest;
import com.kingdee.eas.cp.dm.web.SmartUploadException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

public class SmartUpload {
    protected byte[] mBinArray;
    protected HttpServletRequest mRequest;
    protected HttpServletResponse mResponse;
    protected ServletContext mApplication;
    private int mTotalBytes = 0;
    private int mCurrentIndex = 0;
    private int mStartData = 0;
    private int mEndData = 0;
    private String mBoundary = "";
    private long mTotalMaxFileSize = 0L;
    private long mMaxFileSize = 0L;
    private Vector mDeniedFilesList = new Vector();
    private Vector mAllowedFilesList = new Vector();
    private boolean mDenyPhysicalPath = false;
    private String mContentDisposition = "";
    public static final int SAVE_AUTO = 0;
    public static final int SAVE_VIRTUAL = 1;
    public static final int SAVE_PHYSICAL = 2;
    private SmartFiles mFiles = new SmartFiles();
    private SmartRequest mFormRequest = new SmartRequest();
    private String[] fileNames;

    public final void init(ServletConfig servletconfig) throws ServletException {
        this.mApplication = servletconfig.getServletContext();
    }

    public void service(HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse) throws ServletException, IOException {
        this.mRequest = httpservletrequest;
        this.mResponse = httpservletresponse;
    }

    public final void initialize(ServletConfig servletconfig, HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse) throws ServletException {
        this.mApplication = servletconfig.getServletContext();
        this.mRequest = httpservletrequest;
        this.mResponse = httpservletresponse;
    }

    public final void initialize(PageContext pagecontext) throws ServletException {
        this.mApplication = pagecontext.getServletContext();
        this.mRequest = (HttpServletRequest)pagecontext.getRequest();
        this.mResponse = (HttpServletResponse)pagecontext.getResponse();
    }

    public final void initialize(ServletContext servletcontext, HttpSession httpsession, HttpServletRequest httpservletrequest, HttpServletResponse httpservletresponse, JspWriter jspwriter) throws ServletException {
        this.mApplication = servletcontext;
        this.mRequest = httpservletrequest;
        this.mResponse = httpservletresponse;
    }

    public void upload() throws ServletException, IOException, SmartUploadException {
        int j;
        boolean flag1 = false;
        long l = 0L;
        String s4 = "";
        String s5 = "";
        String s6 = "";
        String s7 = "";
        String s8 = "";
        String s9 = "";
        String s10 = "";
        this.mTotalBytes = this.mRequest.getContentLength();
        this.mBinArray = new byte[this.mTotalBytes];
        for (int i = 0; i < this.mTotalBytes; i += j) {
            try {
                this.mRequest.getInputStream();
                j = this.mRequest.getInputStream().read(this.mBinArray, i, this.mTotalBytes - i);
                continue;
            }
            catch (Exception exception) {
                throw new SmartUploadException("Unable to upload.");
            }
        }
        while (!flag1 && this.mCurrentIndex < this.mTotalBytes) {
            if (this.mBinArray[this.mCurrentIndex] == 13) {
                flag1 = true;
            } else {
                this.mBoundary = this.mBoundary + (char)this.mBinArray[this.mCurrentIndex];
            }
            ++this.mCurrentIndex;
        }
        if (this.mCurrentIndex == 1) {
            return;
        }
        ++this.mCurrentIndex;
        while (this.mCurrentIndex < this.mTotalBytes) {
            String s1 = this.getDataHeader();
            this.mCurrentIndex += 2;
            boolean flag3 = s1.indexOf("filename") > 0;
            String s3 = this.getDataFieldValue(s1, "name");
            if (flag3) {
                s6 = this.getDataFieldValue(s1, "filename");
                s4 = this.getFileName(s6);
                s5 = this.getFileExt(s4);
                s7 = this.getContentType(s1);
                s8 = this.getContentDisp(s1);
                s9 = this.getTypeMIME(s7);
                s10 = this.getSubTypeMIME(s7);
            }
            this.getDataSection();
            if (flag3 && s4.length() > 0) {
                if (this.mDeniedFilesList.contains(s5)) {
                    throw new SecurityException("The extension of the file is denied to be uploaded (1015).");
                }
                if (!this.mAllowedFilesList.isEmpty() && !this.mAllowedFilesList.contains(s5)) {
                    throw new SecurityException("The extension of the file is not allowed to be uploaded (1010).");
                }
                if (this.mMaxFileSize > 0L && (long)(this.mEndData - this.mStartData + 1) > this.mMaxFileSize) {
                    throw new SecurityException("Size exceeded for this file : " + s4 + " (1105).");
                }
                if (this.mTotalMaxFileSize > 0L && (l += (long)(this.mEndData - this.mStartData + 1)) > this.mTotalMaxFileSize) {
                    throw new SecurityException("Total File Size exceeded (1110).");
                }
            }
            if (flag3) {
                SmartFile file = new SmartFile();
                file.setParent(this);
                file.setFieldName(s3);
                file.setFileName(s4);
                file.setFileExt(s5);
                file.setFilePathName(s6);
                file.setIsMissing(s6.length() == 0);
                file.setContentType(s7);
                file.setContentDisp(s8);
                file.setTypeMIME(s9);
                file.setSubTypeMIME(s10);
                if (s7.indexOf("application/x-macbinary") > 0) {
                    this.mStartData += 128;
                }
                file.setSize(this.mEndData - this.mStartData + 1);
                file.setStartData(this.mStartData);
                file.setEndData(this.mEndData);
                this.mFiles.addFile(file);
            } else {
                String s11 = new String(this.mBinArray, this.mStartData, this.mEndData - this.mStartData + 1);
                this.mFormRequest.putParameter(s3, s11);
            }
            if ((char)this.mBinArray[this.mCurrentIndex + 1] == '-') break;
            this.mCurrentIndex += 2;
        }
    }

    public int save(String s) throws ServletException, IOException, SmartUploadException {
        return this.save(s, 0);
    }

    public int save(String s, int i) throws ServletException, IOException, SmartUploadException {
        int j = 0;
        String tempStr = s;
        if (s == null) {
            tempStr = this.mApplication.getRealPath("/");
        }
        if (tempStr.indexOf("/") != -1) {
            if (tempStr.charAt(tempStr.length() - 1) != '/') {
                tempStr = tempStr + "/";
            }
        } else if (tempStr.charAt(tempStr.length() - 1) != '\\') {
            tempStr = tempStr + "\\";
        }
        this.fileNames = new String[this.mFiles.getCount()];
        for (int k = 0; k < this.mFiles.getCount(); ++k) {
            if (this.mFiles.getFile(k).isMissing()) continue;
            this.mFiles.getFile(k).saveAs(tempStr + this.mFiles.getFile(k).getFileName(), i);
            this.fileNames[j] = tempStr + this.mFiles.getFile(k).getFileName();
            ++j;
        }
        return j;
    }

    public String[] getFileNames() {
        String[] vFileNames = new String[this.fileNames.length];
        System.arraycopy(this.fileNames, 0, vFileNames, 0, this.fileNames.length);
        return vFileNames;
    }

    public int getSize() {
        return this.mTotalBytes;
    }

    public byte getBinaryData(int i) {
        byte byte0;
        try {
            byte0 = this.mBinArray[i];
        }
        catch (Exception exception) {
            throw new ArrayIndexOutOfBoundsException("Index out of range (1005).");
        }
        return byte0;
    }

    public SmartFiles getFiles() {
        return this.mFiles;
    }

    public SmartRequest getRequest() {
        return this.mFormRequest;
    }

    public void downloadFile(String s) throws ServletException, IOException, SmartUploadException {
        this.downloadFile(s, null, null);
    }

    public void downloadFile(String s, String s1) throws ServletException, IOException, SmartUploadException, SmartUploadException {
        this.downloadFile(s, s1, null);
    }

    public void downloadFile(String s, String s1, String s2) throws ServletException, IOException, SmartUploadException {
        this.downloadFile(s, s1, s2, 65000);
    }

    public void downloadFile(String s, String s1, String s2, int i) throws ServletException, IOException, SmartUploadException {
        String str = s;
        if (s == null) {
            throw new IllegalArgumentException("File '" + s + "' not found (1040).");
        }
        if (s.equals("")) {
            throw new IllegalArgumentException("File '" + s + "' not found (1040).");
        }
        if (!this.isVirtual(s) && this.mDenyPhysicalPath) {
            throw new SecurityException("Physical path is denied (1035).");
        }
        if (this.isVirtual(s)) {
            str = this.mApplication.getRealPath(s);
        }
        File file = new File(str);
        FileInputStream fileinputstream = new FileInputStream(file);
        long l = file.length();
        int k = 0;
        byte[] abyte0 = new byte[i];
        if (s1 == null) {
            this.mResponse.setContentType("application/x-msdownload");
        } else if (s1.length() == 0) {
            this.mResponse.setContentType("application/x-msdownload");
        } else {
            this.mResponse.setContentType(s1);
        }
        this.mResponse.setContentLength((int)l);
        String string = this.mContentDisposition = this.mContentDisposition != null ? this.mContentDisposition : "attachment;";
        if (s2 == null) {
            this.mResponse.setHeader("Content-Disposition", this.mContentDisposition + " filename=" + this.getFileName(str));
        } else if (s2.length() == 0) {
            this.mResponse.setHeader("Content-Disposition", this.mContentDisposition);
        } else {
            this.mResponse.setHeader("Content-Disposition", this.mContentDisposition + " filename=" + s2);
        }
        while ((long)k < l) {
            int j = fileinputstream.read(abyte0, 0, i);
            k += j;
            this.mResponse.getOutputStream().write(abyte0, 0, j);
        }
        fileinputstream.close();
    }

    public void downloadField(ResultSet resultset, String s, String s1, String s2) throws ServletException, IOException, SQLException {
        if (resultset == null) {
            throw new IllegalArgumentException("The RecordSet cannot be null (1045).");
        }
        if (s == null) {
            throw new IllegalArgumentException("The columnName cannot be null (1050).");
        }
        if (s.length() == 0) {
            throw new IllegalArgumentException("The columnName cannot be empty (1055).");
        }
        byte[] abyte0 = resultset.getBytes(s);
        if (s1 == null) {
            this.mResponse.setContentType("application/x-msdownload");
        } else if (s1.length() == 0) {
            this.mResponse.setContentType("application/x-msdownload");
        } else {
            this.mResponse.setContentType(s1);
        }
        this.mResponse.setContentLength(abyte0.length);
        if (s2 == null) {
            this.mResponse.setHeader("Content-Disposition", "attachment;");
        } else if (s2.length() == 0) {
            this.mResponse.setHeader("Content-Disposition", "attachment;");
        } else {
            this.mResponse.setHeader("Content-Disposition", "attachment; filename=" + s2);
        }
        this.mResponse.getOutputStream().write(abyte0, 0, abyte0.length);
    }

    public void fieldToFile(ResultSet resultset, String s, String s1) throws ServletException, IOException, SmartUploadException, SQLException {
        String str = s1;
        try {
            int i;
            if (this.mApplication.getRealPath(s1) != null) {
                str = this.mApplication.getRealPath(s1);
            }
            InputStream inputstream = resultset.getBinaryStream(s);
            FileOutputStream fileoutputstream = new FileOutputStream(str);
            while ((i = inputstream.read()) != -1) {
                fileoutputstream.write(i);
            }
            fileoutputstream.close();
        }
        catch (Exception exception) {
            throw new SmartUploadException("Unable to save file from the DataBase (1020).");
        }
    }

    private String getDataFieldValue(String s, String s1) {
        String s2 = "";
        String s3 = "";
        int i = 0;
        s2 = s1 + "=" + '\"';
        i = s.indexOf(s2);
        if (i > 0) {
            int j;
            int k = j = i + s2.length();
            s2 = "\"";
            int l = s.indexOf(s2, j);
            if (k > 0 && l > 0) {
                s3 = s.substring(k, l);
            }
        }
        return s3;
    }

    private String getFileExt(String s) {
        int i = 0;
        int j = 0;
        if (s == null) {
            return null;
        }
        i = s.lastIndexOf(46) + 1;
        j = s.length();
        String s1 = s.substring(i, j);
        if (s.lastIndexOf(46) > 0) {
            return s1;
        }
        return "";
    }

    private String getContentType(String s) {
        String s1 = "";
        String s2 = "";
        int i = 0;
        s1 = "Content-Type:";
        i = s.indexOf(s1) + s1.length();
        if (i != -1) {
            int j = s.length();
            s2 = s.substring(i, j);
        }
        return s2;
    }

    private String getTypeMIME(String s) {
        int i = 0;
        i = s.indexOf("/");
        if (i != -1) {
            return s.substring(1, i);
        }
        return s;
    }

    private String getSubTypeMIME(String s) {
        int i = 0;
        i = s.indexOf("/") + 1;
        if (i != -1) {
            int j = s.length();
            return s.substring(i, j);
        }
        return s;
    }

    private String getContentDisp(String s) {
        String s1 = "";
        int i = 0;
        int j = 0;
        i = s.indexOf(":") + 1;
        j = s.indexOf(";");
        s1 = s.substring(i, j);
        return s1;
    }

    private void getDataSection() {
        int i = this.mCurrentIndex;
        int j = 0;
        int k = this.mBoundary.length();
        this.mStartData = this.mCurrentIndex;
        this.mEndData = 0;
        while (i < this.mTotalBytes) {
            if (this.mBinArray[i] == (byte)this.mBoundary.charAt(j)) {
                if (j == k - 1) {
                    this.mEndData = i - k + 1 - 3;
                    break;
                }
                ++i;
                ++j;
                continue;
            }
            ++i;
            j = 0;
        }
        this.mCurrentIndex = this.mEndData + k + 3;
    }

    private String getDataHeader() {
        int i = this.mCurrentIndex;
        int j = 0;
        boolean flag1 = false;
        while (!flag1) {
            if (this.mBinArray[this.mCurrentIndex] == 13 && this.mBinArray[this.mCurrentIndex + 2] == 13) {
                flag1 = true;
                j = this.mCurrentIndex - 1;
                this.mCurrentIndex += 2;
                continue;
            }
            ++this.mCurrentIndex;
        }
        String s = new String(this.mBinArray, i, j - i + 1);
        return s;
    }

    private String getFileName(String s) {
        int i = 0;
        i = s.lastIndexOf(47);
        if (i != -1) {
            return s.substring(i + 1, s.length());
        }
        i = s.lastIndexOf(92);
        if (i != -1) {
            return s.substring(i + 1, s.length());
        }
        return s;
    }

    public void setDeniedFilesList(String s) throws ServletException, IOException, SQLException {
        if (s != null) {
            String s2 = "";
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) == ',') {
                    if (!this.mDeniedFilesList.contains(s2)) {
                        this.mDeniedFilesList.addElement(s2);
                    }
                    s2 = "";
                    continue;
                }
                s2 = s2 + s.charAt(i);
            }
            if (!s2.equals("")) {
                this.mDeniedFilesList.addElement(s2);
            }
        } else {
            this.mDeniedFilesList = null;
        }
    }

    public void setAllowedFilesList(String s) {
        if (s != null) {
            String s2 = "";
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) == ',') {
                    if (!this.mAllowedFilesList.contains(s2)) {
                        this.mAllowedFilesList.addElement(s2);
                    }
                    s2 = "";
                    continue;
                }
                s2 = s2 + s.charAt(i);
            }
            if (!s2.equals("")) {
                this.mAllowedFilesList.addElement(s2);
            }
        } else {
            this.mAllowedFilesList = null;
        }
    }

    public void setDenyPhysicalPath(boolean flag) {
        this.mDenyPhysicalPath = flag;
    }

    public void setForcePhysicalPath(boolean flag) {
    }

    public void setContentDisposition(String s) {
        this.mContentDisposition = s;
    }

    public void setTotalMaxFileSize(long l) {
        this.mTotalMaxFileSize = l;
    }

    public void setMaxFileSize(long l) {
        this.mMaxFileSize = l;
    }

    protected String getPhysicalPath(String s, int i) throws IOException {
        File file;
        String s1 = "";
        String s2 = "";
        String s3 = "";
        boolean flag = false;
        s3 = System.getProperty("file.separator");
        if (s == null) {
            throw new IllegalArgumentException("There is no specified destination file (1140).");
        }
        if (s.equals("")) {
            throw new IllegalArgumentException("There is no specified destination file (1140).");
        }
        if (s.lastIndexOf("\\") >= 0) {
            s1 = s.substring(0, s.lastIndexOf("\\"));
            s2 = s.substring(s.lastIndexOf("\\") + 1);
        }
        if (s.lastIndexOf("/") >= 0) {
            s1 = s.substring(0, s.lastIndexOf("/"));
            s2 = s.substring(s.lastIndexOf("/") + 1);
        }
        if ((file = new File(s1 = s1.length() != 0 ? s1 : "/")).exists()) {
            flag = true;
        }
        if (i == 0) {
            if (this.isVirtual(s1)) {
                s1 = (s1 = this.mApplication.getRealPath(s1)).endsWith(s3) ? s1 + s2 : s1 + s3 + s2;
                return s1;
            }
            if (flag) {
                if (this.mDenyPhysicalPath) {
                    throw new IllegalArgumentException("Physical path is denied (1125).");
                }
                return s;
            }
            throw new IllegalArgumentException("This path does not exist (1135).");
        }
        if (i == 1) {
            if (this.isVirtual(s1)) {
                s1 = (s1 = this.mApplication.getRealPath(s1)).endsWith(s3) ? s1 + s2 : s1 + s3 + s2;
                return s1;
            }
            if (flag) {
                throw new IllegalArgumentException("The path is not a virtual path.");
            }
            throw new IllegalArgumentException("This path does not exist (1135).");
        }
        if (i == 2) {
            if (flag) {
                if (this.mDenyPhysicalPath) {
                    throw new IllegalArgumentException("Physical path is denied (1125).");
                }
                return s;
            }
            if (this.isVirtual(s1)) {
                throw new IllegalArgumentException("The path is not a physical path.");
            }
            throw new IllegalArgumentException("This path does not exist (1135).");
        }
        return null;
    }

    public void uploadInFile(String s) throws IOException, SmartUploadException {
        int k;
        int i = 0;
        String str = s;
        if (s == null) {
            throw new IllegalArgumentException("There is no specified destination file (1025).");
        }
        if (s.length() == 0) {
            throw new IllegalArgumentException("There is no specified destination file (1025).");
        }
        if (!this.isVirtual(s) && this.mDenyPhysicalPath) {
            throw new SecurityException("Physical path is denied (1035).");
        }
        i = this.mRequest.getContentLength();
        this.mBinArray = new byte[i];
        for (int j = 0; j < i; j += k) {
            try {
                k = this.mRequest.getInputStream().read(this.mBinArray, j, i - j);
                continue;
            }
            catch (Exception exception) {
                throw new SmartUploadException("Unable to upload.");
            }
        }
        if (this.isVirtual(s)) {
            str = this.mApplication.getRealPath(s);
        }
        try {
            File file = new File(str);
            FileOutputStream fileoutputstream = new FileOutputStream(file);
            fileoutputstream.write(this.mBinArray);
            fileoutputstream.close();
        }
        catch (Exception exception1) {
            throw new SmartUploadException("The Form cannot be saved in the specified file (1030).");
        }
    }

    private boolean isVirtual(String s) {
        if (this.mApplication.getRealPath(s) != null) {
            File file = new File(this.mApplication.getRealPath(s));
            return file.exists();
        }
        return false;
    }
}

