/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.attachment.common.SimpleAttachmentInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManager;
import com.kingdee.eas.base.fme.service.FMEServiceFactory;
import com.kingdee.eas.base.fme.service.IFMEService;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnit;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnit;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.Category;
import com.kingdee.eas.cp.dm.CategoryInfo;
import com.kingdee.eas.cp.dm.ContentTypeEnum;
import com.kingdee.eas.cp.dm.DMForWafFacadeFactory;
import com.kingdee.eas.cp.dm.DimensionInfo;
import com.kingdee.eas.cp.dm.DmState;
import com.kingdee.eas.cp.dm.DocAreaCollection;
import com.kingdee.eas.cp.dm.DocAreaFactory;
import com.kingdee.eas.cp.dm.DocHistory;
import com.kingdee.eas.cp.dm.DocTemplateInfo;
import com.kingdee.eas.cp.dm.DocWfState;
import com.kingdee.eas.cp.dm.Document;
import com.kingdee.eas.cp.dm.DocumentAdminInfo;
import com.kingdee.eas.cp.dm.DocumentAssociateDocCollection;
import com.kingdee.eas.cp.dm.DocumentAssociateDocInfo;
import com.kingdee.eas.cp.dm.DocumentDimensionCollection;
import com.kingdee.eas.cp.dm.DocumentDimensionFactory;
import com.kingdee.eas.cp.dm.DocumentDimensionInfo;
import com.kingdee.eas.cp.dm.DocumentDistributeCollection;
import com.kingdee.eas.cp.dm.DocumentDistributeFactory;
import com.kingdee.eas.cp.dm.DocumentDistributeInfo;
import com.kingdee.eas.cp.dm.DocumentFactory;
import com.kingdee.eas.cp.dm.DocumentInfo;
import com.kingdee.eas.cp.dm.DocumentPersonInfo;
import com.kingdee.eas.cp.dm.DocumentRoleInfo;
import com.kingdee.eas.cp.dm.IDocumentDimension;
import com.kingdee.eas.cp.dm.IDocumentDistribute;
import com.kingdee.eas.cp.dm.app.DmServerService;
import com.kingdee.eas.cp.dm.utils.DmCommonUtils;
import com.kingdee.eas.cp.dm.web.DocListHelper;
import com.kingdee.eas.cp.dm.web.dto.ColumnParamsDTO;
import com.kingdee.eas.cp.dm.web.dto.ContentFilterParamDTO;
import com.kingdee.eas.cp.dm.web.dto.ContentListDTO;
import com.kingdee.eas.cp.dm.web.dto.DocumentInfoDTO;
import com.kingdee.eas.cp.dm.web.dto.PermInfoDTO;
import com.kingdee.eas.cp.dm.web.service.DefaultDmPermissionService;
import com.kingdee.eas.cp.dm.web.service.DmColumnManagerService;
import com.kingdee.eas.cp.dm.web.service.DmDocumentFlowDaoImp;
import com.kingdee.eas.cp.dm.web.service.DocumentLockServiceImpl;
import com.kingdee.eas.cp.dm.web.service.IDmPermissionService;
import com.kingdee.eas.cp.dm.web.util.DmPermCacheInfo;
import com.kingdee.eas.cp.dm.web.util.PermissionUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.json.JSONObject;

public class DMContentManagerService {
    private static final Logger logger = Logger.getLogger(DMContentManagerService.class);
    protected static DMContentManagerService instance = new DMContentManagerService();
    private boolean addNewBtnFlag;

    protected DMContentManagerService() {
    }

    public static DMContentManagerService getInstance() {
        return instance;
    }

    public PagingResult<ContentListDTO> findContentList(Context ctx, ContentFilterParamDTO param, PagingParam pagingParam) throws Exception {
        ContentListDTO ct;
        String sql;
        this.addNewBtnFlag = false;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.dm.app", "DocumentQuery");
        PermissionUtil.initPermListCache(ctx);
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        int total = 0;
        int pageNo = pagingParam.getPageNo();
        int pageSize = pagingParam.getPageSize();
        PagingResult pagingResult = new PagingResult();
        SorterItemInfo sortInfo = new SorterItemInfo("index");
        sortInfo.setSortType(SortType.DESCEND);
        entityViewInfo.getSorter().clear();
        entityViewInfo.getSorter().add(sortInfo);
        FilterInfo filterInfo = new FilterInfo();
        if ("column".equals(param.getCateType())) {
            filterInfo = this.buildTreeFilterSelectCategory(ctx, filterInfo, param.getColumnId());
        } else if ("myCreate".equals(param.getCateType())) {
            filterInfo = this.buildTreeFilterMyCreate(ctx, filterInfo, this.transferAuditType(param.getAuditType()));
            sortInfo = this.buildTreeSortTypeMyCreate(this.transferAuditType(param.getAuditType()));
            entityViewInfo.getSorter().clear();
            entityViewInfo.getSorter().add(sortInfo);
            if ("It8v2FraTAaQ9+O0K3Ukn8NdkBQ=".equals(this.transferAuditType(param.getAuditType()))) {
                return this.findToContentList(ctx, param, pagingParam);
            }
        } else {
            if ("myDealWith".equals(param.getCateType())) {
                return this.findMyDealContentList(ctx, param, pagingParam);
            }
            if ("myShared".equals(param.getCateType())) {
                return this.findMySharedContentList(ctx, param, pagingParam);
            }
            filterInfo = this.buildTreeFilterSelectDocArea(ctx, filterInfo, param.getAreaId());
        }
        FilterInfo docStatusFilter = new FilterInfo();
        docStatusFilter.getFilterItems().add(new FilterItemInfo("isHistory", (Object)Boolean.FALSE, CompareType.EQUALS));
        docStatusFilter.getFilterItems().add(new FilterItemInfo("state", (Object)String.valueOf(2), CompareType.NOTEQUALS));
        String mark = " ( #0 and #1 )";
        if ("F7".equals(param.getLoadType())) {
            docStatusFilter.getFilterItems().add(new FilterItemInfo("wfState", (Object)String.valueOf(3), CompareType.EQUALS));
            docStatusFilter.getFilterItems().add(new FilterItemInfo("state", (Object)String.valueOf(0), CompareType.NOTEQUALS));
            mark = " ( #0 and #1 and #2 and #3 )";
        }
        docStatusFilter.setMaskString(mark);
        filterInfo.mergeFilter(docStatusFilter, "and");
        if (!StringUtil.isEmpty((String)param.getSearchKey())) {
            filterInfo.mergeFilter(this.getQuickQueryFilter(param.getSearchKey()), "and");
        }
        entityViewInfo.setFilter(filterInfo);
        exec = this.getListQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
        logger.debug((Object)("executor search content sql is:" + exec.getSQL()));
        String countSql = sql = exec.getSQL();
        if (sql.indexOf("ORDER BY") > 0) {
            countSql = sql.substring(0, sql.indexOf("ORDER BY"));
        }
        if ((countRowSet = DbUtil.executeQuery((Context)ctx, (String)(countSql = " select count(1) from ( " + countSql + " )  AAA "))).next()) {
            total = countRowSet.getInt(1);
        }
        if ("myCreate".equals(param.getCateType())) {
            this.addNewBtnFlag = false;
        }
        Locale local = ctx.getLocale();
        rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
        ArrayList<ContentListDTO> list = new ArrayList<ContentListDTO>();
        if (rowSet != null) {
            while (rowSet.next()) {
                ct = new ContentListDTO();
                ct.setId(rowSet.getString("id"));
                ct.setTitle(rowSet.getString("title"));
                ct.setAuthorName(rowSet.getString("AUTHOR.NAME"));
                logger.debug((Object)("rowSet.getString('STATE') is:" + rowSet.getInt("STATE")));
                System.out.println("rowSet.getString('STATE') is:" + rowSet.getInt("STATE"));
                System.out.println("rowSet.getString('wfState') is:" + rowSet.getInt("wfState"));
                if (0 == rowSet.getInt("STATE")) {
                    ct.setState(DmState.DISABLE.getAlias());
                } else {
                    int wfstate = rowSet.getInt("wfState");
                    if (0 == wfstate) {
                        ct.setState(DocWfState.DRAFT.getAlias());
                    } else if (1 == wfstate) {
                        ct.setState(DocWfState.SUBMIT.getAlias());
                    } else if (2 == wfstate) {
                        ct.setState(DocWfState.INAPPROVE.getAlias());
                    } else if (3 == wfstate) {
                        ct.setState(DocWfState.PUBLISH.getAlias());
                    } else if (4 == wfstate) {
                        ct.setState(DocWfState.ABANDON.getAlias());
                    } else if (5 == wfstate) {
                        ct.setState(DocWfState.FORBIDDEN.getAlias());
                    }
                }
                ct.setIsArchive(rowSet.getString("isArchive"));
                ct.setViewCount(String.valueOf(rowSet.getInt("READCOUNT")));
                ct.setCreateTime(rowSet.getString("CREATETIME"));
                ct.setDistbuteTime(rowSet.getString("CREATETIME"));
                ct.setColumnId(rowSet.getString("category.id"));
                ct.setColumnName(rowSet.getString("category.name"));
                ct.setTag(rowSet.getString("tag"));
                ct.setAddNewBtnFlag(this.addNewBtnFlag);
                list.add(ct);
            }
        }
        ct = new ContentListDTO();
        ct.setId("1");
        ct.setAddNewBtnFlag(this.addNewBtnFlag);
        list.add(ct);
        pagingResult.setPagingParam(pagingParam);
        pagingResult.setTotalCount(total);
        pagingResult.setRecords(list);
        return pagingResult;
    }

    private String transferStateByLang(Locale local, String str) {
        String resultStr = "";
        resultStr = local.equals(new Locale("L2")) ? (str.equals("\u5df2\u53d1\u5e03") || str.equals("\u5df2\u767c\u4f48") ? "\u5df2\u53d1\u5e03" : (str.equals("\u5ba1\u6279\u4e2d") || str.equals("\u5be9\u6279\u4e2d") ? "\u5ba1\u6279\u4e2d" : (str.equals("\u5e9f\u5f03") || str.equals("\u5ee2\u68c4") ? "\u5e9f\u5f03" : str))) : (local.equals(new Locale("L3")) ? str : str);
        return resultStr;
    }

    private FilterInfo getQuickQueryFilter(String searchKey) {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("ucase(title) like '%" + searchKey.toUpperCase() + "%'"));
        filterInfo.getFilterItems().add(new FilterItemInfo("author.name", (Object)("%" + searchKey + "%"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("tag", (Object)("%" + searchKey + "%"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("docMarkNumber", (Object)("%" + searchKey + "%"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("summary", (Object)("%" + searchKey + "%"), CompareType.LIKE));
        filterInfo.getFilterItems().add(new FilterItemInfo("category.name", (Object)("%" + searchKey + "%"), CompareType.LIKE));
        String maskString = " ( #0 or #1 or #2 or #3 or #4 or #5 ) ";
        filterInfo.setMaskString(maskString);
        return filterInfo;
    }

    public PagingResult<ContentListDTO> findToContentList(Context ctx, ContentFilterParamDTO param, PagingParam pagingParam) throws Exception {
        PagingResult pagingResult = new PagingResult();
        int total = DmDocumentFlowDaoImp.getInstance().getProcessMyPutoutCount(ctx, ctx.getLocale(), "todo", param.getSearchKey());
        int pageNo = pagingParam.getPageNo();
        int pageSize = pagingParam.getPageSize();
        List<ContentListDTO> docList = DmDocumentFlowDaoImp.getInstance().getDoProcessMyPutoutByUser(ctx, ctx.getLocale(), pageNo, pageSize, "todo", param.getSearchKey());
        ContentListDTO ct = new ContentListDTO();
        ct.setId("1");
        ct.setAddNewBtnFlag(this.addNewBtnFlag);
        docList.add(ct);
        pagingResult.setPagingParam(pagingParam);
        pagingResult.setTotalCount(total);
        pagingResult.setRecords(docList);
        return pagingResult;
    }

    public PagingResult<ContentListDTO> findMyDealContentList(Context ctx, ContentFilterParamDTO param, PagingParam pagingParam) throws Exception {
        PagingResult pagingResult = new PagingResult();
        int total = DmDocumentFlowDaoImp.getInstance().getProcessCount(ctx, ctx.getLocale(), param.getAuditType(), param.getSearchKey());
        int pageNo = pagingParam.getPageNo();
        int pageSize = pagingParam.getPageSize();
        List<ContentListDTO> docList = DmDocumentFlowDaoImp.getInstance().getDocumentProcessByUserAndLanaguage(ctx, ctx.getLocale(), pageNo, pageSize, param.getAuditType(), param.getSearchKey());
        ContentListDTO ct = new ContentListDTO();
        ct.setId("1");
        ct.setAddNewBtnFlag(this.addNewBtnFlag);
        docList.add(ct);
        pagingResult.setPagingParam(pagingParam);
        pagingResult.setTotalCount(total);
        pagingResult.setRecords(docList);
        return pagingResult;
    }

    public PagingResult<ContentListDTO> findMySharedContentList(Context ctx, ContentFilterParamDTO param, PagingParam pagingParam) throws Exception {
        PagingResult pagingResult = new PagingResult();
        int total = DmDocumentFlowDaoImp.getInstance().getMySharedCount(ctx, ctx.getLocale(), param.getAuditType(), param.getSearchKey());
        int pageNo = pagingParam.getPageNo();
        int pageSize = pagingParam.getPageSize();
        List<ContentListDTO> docList = DmDocumentFlowDaoImp.getInstance().getMySharedList(ctx, ctx.getLocale(), pageNo, pageSize, param.getAuditType(), param.getSearchKey());
        ContentListDTO ct = new ContentListDTO();
        ct.setId("1");
        ct.setAddNewBtnFlag(this.addNewBtnFlag);
        docList.add(ct);
        pagingResult.setPagingParam(pagingParam);
        pagingResult.setTotalCount(total);
        pagingResult.setRecords(docList);
        return pagingResult;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private IQueryExecutor getListQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateEnum = false;
        return exec;
    }

    private FilterInfo buildTreeFilterSelectCategory(Context ctx, FilterInfo filterInfo, String catId) {
        block4: {
            try {
                Category service = new Category(ctx);
                CategoryInfo catInfo = service.getCategoryInfo((IObjectPK)new ObjectUuidPK(catId));
                filterInfo = this.buildTreeFilterSelectCategory(ctx, filterInfo, catInfo);
                if (!DmState.ENABLE.equals((Object)catInfo.getState())) break block4;
                List dmPermListCache = PermissionUtil.getDmPermListCache();
                for (DmPermCacheInfo obj : dmPermListCache) {
                    String[] permList;
                    DmPermCacheInfo dmPerm;
                    if (!(obj instanceof DmPermCacheInfo) || !catId.equals((dmPerm = obj).getCatID())) continue;
                    String perms = dmPerm.getPermList();
                    if (perms == null || perms.length() <= 0) break;
                    for (String perm : permList = perms.split(",")) {
                        if (!"1".equals(perm) && !"2".equals(perm) && !"3".equals(perm)) continue;
                        this.addNewBtnFlag = true;
                        break block4;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return filterInfo;
    }

    public PagingResult<ContentListDTO> findDocQouteF7List(Context ctx, ContentFilterParamDTO param, PagingParam pagingParam) throws Exception {
        String sql;
        int total = 0;
        int pageNo = pagingParam.getPageNo();
        int pageSize = pagingParam.getPageSize();
        PagingResult pagingResult = new PagingResult();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = this.buildDocQouteF7Filter(ctx, param);
        if (!StringUtil.isEmpty((String)param.getSearchKey())) {
            filter.mergeFilter(this.getQuickQueryFilter(param.getSearchKey()), "and");
        }
        entityViewInfo.setFilter(filter);
        IQueryExecutor exec = null;
        IRowSet rowSet = null;
        IRowSet countRowSet = null;
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.dm.app", "DocumentQuery");
        exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
        logger.error((Object)("executor search content sql is:" + exec.getSQL()));
        String countSql = sql = exec.getSQL();
        if (sql.indexOf("ORDER BY") > 0) {
            countSql = sql.substring(0, sql.indexOf("ORDER BY"));
        }
        if ((countRowSet = DbUtil.executeQuery((Context)ctx, (String)(countSql = " select count(1) from ( " + countSql + " )  AAA "))).next()) {
            total = countRowSet.getInt(1);
        }
        rowSet = exec.executeQuery((pageNo - 1) * pageSize, pageSize);
        logger.error((Object)("CCCCCCCCCCCCCCc  rowSet.size() is:" + rowSet.size()));
        ArrayList<ContentListDTO> list = new ArrayList<ContentListDTO>();
        if (rowSet != null) {
            while (rowSet.next()) {
                ContentListDTO ct = new ContentListDTO();
                String id = rowSet.getString("id");
                String wState = null;
                String findAssignidSql = "select FassignId from T_WFR_assign where Fbizobjid='" + id + "'";
                ct.setId(id);
                ct.setTitle(rowSet.getString("title"));
                ct.setAuthorName(rowSet.getString("AUTHOR.NAME"));
                if ("\u7981\u7528".equals(rowSet.getString("STATE"))) {
                    ct.setState(rowSet.getString("STATE"));
                } else {
                    wState = rowSet.getString("wfState");
                    ct.setState(wState);
                }
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)findAssignidSql.toString());
                if ("\u5ba1\u6279\u4e2d".equals(wState) && rs != null && rs.next()) {
                    ct.setAssinId(rs.getString("FassignId"));
                }
                ct.setIsArchive(rowSet.getString("isArchive"));
                ct.setViewCount(rowSet.getString("READCOUNT"));
                ct.setCreateTime(rowSet.getString("CREATETIME"));
                ct.setDistbuteTime(rowSet.getString("CREATETIME"));
                ct.setColumnId(rowSet.getString("category.id"));
                ct.setColumnName(rowSet.getString("category.name"));
                ct.setTag(rowSet.getString("tag"));
                list.add(ct);
            }
        }
        pagingResult.setPagingParam(pagingParam);
        pagingResult.setTotalCount(total);
        pagingResult.setRecords(list);
        return pagingResult;
    }

    private FilterInfo buildDocQouteF7Filter(Context ctx, ContentFilterParamDTO param) throws Exception {
        FilterInfo filter = new FilterInfo();
        boolean searchAllFlag = this.transferCheckBoxToBoolean(param.getSearchAllArea());
        HashSet<String> areaIdSet = new HashSet<String>();
        if (searchAllFlag) {
            areaIdSet = this.getDocAreaSet(ctx);
        } else {
            areaIdSet.add(param.getAreaId());
        }
        if (!searchAllFlag) {
            if (param.getCateType().equals("column")) {
                filter.getFilterItems().add(new FilterItemInfo("Category.id", (Object)param.getColumnId()));
                Category service = new Category(ctx);
                CategoryInfo catInfo = service.getCategoryInfo((IObjectPK)new ObjectUuidPK(param.getColumnId()));
                if ("checked".equals(param.getIncludeSubColumn()) || "true".equals(param.getIncludeSubColumn())) {
                    filter.getFilterItems().add(new FilterItemInfo("Category.longnumber", (Object)(catInfo.getLongNumber() + "!%"), CompareType.LIKE));
                    filter.setMaskString("#0 or #1");
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("da.id", (Object)param.getAreaId(), CompareType.EQUALS));
                if (!"checked".equals(param.getIncludeSubColumn()) && !"true".equals(param.getIncludeSubColumn())) {
                    filter.getFilterItems().add(new FilterItemInfo("Category.id", (Object)"nodata"));
                }
            }
        }
        try {
            FilterInfo filterInfo2 = this.getEntityViewInfo4Per(ctx, areaIdSet).getFilter();
            if (FilterUtility.hasFilterItem((FilterInfo)filter) && !FilterUtility.hasFilterItem((FilterInfo)filterInfo2)) {
                return filter;
            }
            if (!FilterUtility.hasFilterItem((FilterInfo)filter) && FilterUtility.hasFilterItem((FilterInfo)filterInfo2)) {
                return filterInfo2;
            }
            if (FilterUtility.hasFilterItem((FilterInfo)filter) && FilterUtility.hasFilterItem((FilterInfo)filterInfo2)) {
                filter.mergeFilter(filterInfo2, "and");
                return filter;
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return filter;
    }

    private EntityViewInfo getEntityViewInfo4Per(Context ctx, Set<String> areaIdSet) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("category.id", this.getPermCatList(ctx, areaIdSet), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isHistory", (Object)"0", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("wfState", (Object)3, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("category.state", (Object)1, CompareType.EQUALS));
        evi.setFilter(filter);
        return evi;
    }

    private Object getPermCatList(Context ctx, Set<String> areaIdSet) {
        HashSet<String> catSet = new HashSet<String>();
        ColumnParamsDTO columnParamDto = new ColumnParamsDTO();
        columnParamDto.setSlevel("1");
        DmColumnManagerService dmService = new DmColumnManagerService(null);
        try {
            for (String areaId : areaIdSet) {
                IRowSet rs = dmService.findColumnTreeData(ctx, areaId, columnParamDto, false);
                if (rs == null) continue;
                while (rs.next()) {
                    if (rs.getInt("fstate") == 0) continue;
                    catSet.add(rs.getString("fid"));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return catSet;
    }

    private Object getPerCatList(Context ctx) {
        Date a = new Date();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String perId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        HashSet<String> operStrNumSet = new HashSet<String>();
        operStrNumSet.add("4");
        Map<String, Set<String>> map = DefaultDmPermissionService.getInstance().getHasPermCatIdMap(ctx, perId, userId, operStrNumSet, this.getDocAreaSet(ctx), "t_dm_category");
        Date c = new Date();
        long ca = c.getTime() - a.getTime();
        System.out.println("---------getPerCatList costTime:" + ca);
        HashSet<String> set = new HashSet<String>();
        for (Set<String> tempSet : map.values()) {
            set.addAll(tempSet);
        }
        return set;
    }

    private Set<String> getDocAreaSet(Context ctx) {
        Date a = new Date();
        DocAreaCollection daColl = new DocAreaCollection();
        try {
            daColl = DocAreaFactory.getLocalInstance(ctx).getDocAreaCollection("select id where state = 1 and id not in('00000000-0000-0000-0000-000000000000EEFEE00F', '11111111-1111-1111-1111-111111111111EEFEE00F')");
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        HashSet<String> set = new HashSet<String>();
        int length = daColl.size();
        for (int i = 0; i < length; ++i) {
            String docId = daColl.get(i).getId().toString();
            if (set.contains(docId)) continue;
            set.add(docId);
        }
        Date c = new Date();
        long ca = c.getTime() - a.getTime();
        return set;
    }

    private FilterInfo buildTreeFilterSelectCategory(Context ctx, FilterInfo filterInfo, CategoryInfo catInfo) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String perId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String bizId = catInfo.getId().toString();
        try {
            if (DmState.DISABLE.equals((Object)catInfo.getState()) || DmState.DISABLE.equals((Object)DocAreaFactory.getLocalInstance(ctx).getDocAreaInfo("select state where id ='" + catInfo.getDocArea().getId().toString() + "'").getState())) {
                HashSet<String> operStrNumSet = new HashSet<String>();
                operStrNumSet.add("2");
                operStrNumSet.add("6");
                boolean hasDocOpt = PermissionUtil.checkHasPermission(ctx, operStrNumSet, bizId, "t_dm_category");
                if (hasDocOpt) {
                    String dataPermSql = this.getDmPermissionService().getHasPermDocIdSql(ctx, perId, userId);
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)dataPermSql, CompareType.INNER));
                    filterInfo.getFilterItems().add(new FilterItemInfo("category.id", (Object)bizId));
                } else {
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"nodata", CompareType.INCLUDE));
                }
                return filterInfo;
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        HashSet<String> operCatSet = new HashSet<String>();
        operCatSet.add(bizId);
        Set<String> docSet = DefaultDmPermissionService.getInstance().getLegalPermDocIdSet(ctx, operCatSet);
        if (docSet.size() < 1) {
            docSet.add("''");
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", docSet, CompareType.INCLUDE));
        return filterInfo;
    }

    protected IDmPermissionService getDmPermissionService() {
        return DefaultDmPermissionService.getInstance();
    }

    public FilterInfo buildTreeFilterSelectDocArea(Context ctx, FilterInfo filterInfo, String docAreaId) {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String perId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("category.docArea.id", (Object)docAreaId));
        HashSet<String> operStrNumSet = new HashSet<String>();
        operStrNumSet.add("4");
        operStrNumSet.add("5");
        HashSet<String> bizSet = new HashSet<String>();
        bizSet.add(docAreaId);
        Map<String, Set<String>> rtnMap = DefaultDmPermissionService.getInstance().getHasPermCatIdMap(ctx, perId, userId, operStrNumSet, bizSet, "t_dm_category");
        Set<String> operCatSet = rtnMap.get(docAreaId);
        if (null != operCatSet && !operCatSet.isEmpty()) {
            Set<String> docSet = DefaultDmPermissionService.getInstance().getLegalPermDocIdSet(ctx, operCatSet);
            filterInfo.getFilterItems().add(new FilterItemInfo("id", docSet, CompareType.INCLUDE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)"nodata", CompareType.INCLUDE));
        }
        return filterInfo;
    }

    private FilterInfo buildTreeFilterMyCreate(Context ctx, FilterInfo filterInfo, String catId) {
        try {
            if ("It8v2FraTAaQ9+O0K3Ukn8NdkBQ=".equals(catId)) {
                return filterInfo;
            }
            String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
            if ("vefc5pHWTcWwzKvDCQHg88NdkBQ=".equals(catId)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("createPerson.id", (Object)personId, CompareType.EQUALS));
                HashSet<Integer> stateSet = new HashSet<Integer>();
                stateSet.add(3);
                stateSet.add(4);
                filterInfo.getFilterItems().add(new FilterItemInfo("wfState", stateSet, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("category.state", (Object)1, CompareType.EQUALS));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("createPerson.id", (Object)personId, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("wfState", (Object)0, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("category.state", (Object)1, CompareType.EQUALS));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filterInfo;
    }

    private SorterItemInfo buildTreeSortTypeMyCreate(String type) {
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        if ("It8v2FraTAaQ9+O0K3Ukn8NdkBQ=".equals(type)) {
            return sortInfo;
        }
        sortInfo = "vefc5pHWTcWwzKvDCQHg88NdkBQ=".equals(type) ? new SorterItemInfo("createTime") : new SorterItemInfo("createTime");
        sortInfo.setSortType(SortType.DESCEND);
        return sortInfo;
    }

    private String transferAuditType(String auditId) {
        String result = "";
        result = "INAPPROVE".equals(auditId) ? "vefc5pHWTcWwzKvDCQHg88NdkBQ=" : ("SUBMIT".equals(auditId) ? "It8v2FraTAaQ9+O0K3Ukn8NdkBQ=" : "35vn/runTie71gWo5zfrjsNdkBQ=");
        return result;
    }

    public DocumentInfo findDocumentById(Context ctx, String docId, String columnId) throws Exception {
        DocumentInfo info = null;
        if (StringUtil.isEmpty((String)docId)) {
            info = new DocumentInfo();
            BOSUuid addNewId = BOSUuid.create((BOSObjectType)info.getBOSType());
            info.setId(addNewId);
            info.setAuthor(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
            DmColumnManagerService dmService = new DmColumnManagerService(null);
            CategoryInfo catInfo = dmService.findCategoryInfoById(ctx, columnId, null, null);
            info.setCategory(catInfo);
            info.setNumber(this.setDocNumber(ctx, info));
        } else {
            info = (DocumentInfo)DocumentFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(docId), this.getSelectors());
        }
        return info;
    }

    private String setDocNumber(Context ctx, DocumentInfo model) {
        String orgId;
        String docNumber = new String();
        OrgUnitInfo mainOrg = (OrgUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        String string = orgId = mainOrg == null ? "" : mainOrg.getString("id");
        if (orgId == null || orgId.trim().length() == 0) {
            orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        CodingRuleManager iCodingRuleManager = new CodingRuleManager(ctx);
        boolean hasCodingRule = this.hasCodingRule(ctx, (IObjectValue)model, orgId);
        if (hasCodingRule) {
            try {
                docNumber = iCodingRuleManager.getNumber((IObjectValue)model, orgId);
                model.setNumber(docNumber);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return docNumber;
    }

    private boolean hasCodingRule(Context ctx, IObjectValue caller, String orgId) {
        CodingRuleManager iCodingRuleManager = new CodingRuleManager(ctx);
        try {
            if (orgId != null && orgId.trim().length() > 0 && iCodingRuleManager.isExist(caller, orgId)) {
                return true;
            }
            String companyId = this.getNextCompanyId();
            return companyId != null && companyId.trim().length() > 0 && iCodingRuleManager.isExist(caller, companyId);
        }
        catch (Exception err) {
            err.printStackTrace();
            return false;
        }
    }

    private String getNextCompanyId() throws Exception {
        CompanyOrgUnitInfo comInfo = null;
        CtrlUnit iCtrlUnit = new CtrlUnit();
        ObjectUuidPK pk = new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4");
        CtrlUnitInfo rootCU = iCtrlUnit.getCtrlUnitInfo((IObjectPK)pk);
        if (rootCU.isIsCompanyOrgUnit()) {
            CompanyOrgUnit iCompanyOrgUnit = new CompanyOrgUnit();
            comInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(rootCU.getId()));
        }
        if (comInfo != null) {
            return comInfo.getId().toString();
        }
        return null;
    }

    public List<String> buildDocDim(Context ctx, DocumentInfo docInfo) {
        ArrayList<String> dims = new ArrayList<String>();
        String dimId = "";
        String dimName = "";
        for (int i = 0; i < docInfo.getDimension().size(); ++i) {
            DocumentDimensionInfo item = docInfo.getDimension().get(i);
            dimId = dimId + item.getDimension().getId().toString() + ",";
            dimName = dimName + item.getDimension().getName().toString() + ",";
        }
        if (dimId.length() > 0) {
            dimId = dimId.substring(0, dimId.length() - 1);
        }
        if (dimName.length() > 0) {
            dimName = dimName.substring(0, dimName.length() - 1);
        }
        dims.add(dimId);
        dims.add(dimName);
        return dims;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("docDept.id"));
        sic.add(new SelectorItemInfo("docDept.name"));
        sic.add(new SelectorItemInfo("createPerson.id"));
        sic.add(new SelectorItemInfo("createPerson.name"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("author.name"));
        sic.add(new SelectorItemInfo("author.id"));
        sic.add(new SelectorItemInfo("category.id"));
        sic.add(new SelectorItemInfo("category.number"));
        sic.add(new SelectorItemInfo("category.name"));
        sic.add(new SelectorItemInfo("category.state"));
        sic.add(new SelectorItemInfo("category.isVerSet"));
        sic.add(new SelectorItemInfo("category.attachSet"));
        sic.add(new SelectorItemInfo("category.attachTypes"));
        sic.add(new SelectorItemInfo("category.attachSizes"));
        sic.add(new SelectorItemInfo("category.attachUnit"));
        sic.add(new SelectorItemInfo("category.isAnonymous"));
        sic.add(new SelectorItemInfo("category.docArea.id"));
        sic.add(new SelectorItemInfo("category.docArea.ftpPath"));
        sic.add(new SelectorItemInfo("category.docArea.state"));
        sic.add(new SelectorItemInfo("category.template.id"));
        sic.add(new SelectorItemInfo("category.template.name"));
        sic.add(new SelectorItemInfo("category.canReSelectTemplate"));
        sic.add(new SelectorItemInfo("category.canCopy"));
        sic.add(new SelectorItemInfo("category.canDownload"));
        sic.add(new SelectorItemInfo("category.canEdit"));
        sic.add(new SelectorItemInfo("category.isPrintAttach"));
        sic.add("Role.role.id");
        sic.add("Role.role.name");
        sic.add("Role.role.number");
        sic.add("Role.permList");
        sic.add("Role.permListDiff");
        sic.add("Person.person.id");
        sic.add("Person.person.name");
        sic.add("Person.person.number");
        sic.add("Person.permList");
        sic.add("Person.permListDiff");
        sic.add("Admin.admin.id");
        sic.add("Admin.admin.name");
        sic.add("Admin.admin.number");
        sic.add("Admin.permList");
        sic.add("Admin.permListDiff");
        sic.add("Admin.includeSub");
        sic.add(new SelectorItemInfo("AssociateDoc.document.id"));
        sic.add(new SelectorItemInfo("AssociateDoc.url"));
        sic.add(new SelectorItemInfo("AssociateDoc.urlTitle"));
        sic.add(new SelectorItemInfo("AssociateDoc.document.title"));
        sic.add(new SelectorItemInfo("version"));
        sic.add(new SelectorItemInfo("source"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("Dimension.dimension.id"));
        sic.add(new SelectorItemInfo("Dimension.dimension.name"));
        sic.add(new SelectorItemInfo("isHistory"));
        return sic;
    }

    public List<PermInfoDTO> findColPermPerson(Context ctx, DocumentInfo docInfo) {
        String perId = "";
        HashMap<String, String> permList = new HashMap<String, String>();
        StringBuilder perIds = new StringBuilder(100);
        if (docInfo != null && docInfo.getPerson().size() > 0) {
            perIds.append("''");
            for (int i = 0; i < docInfo.getPerson().size(); ++i) {
                DocumentPersonInfo info = docInfo.getPerson().get(i);
                if (info == null) continue;
                perIds.append(",'").append(info.getPerson().getId().toString()).append("'");
                permList.put(info.getPerson().getId().toString(), info.getPermList());
            }
            perId = perIds.toString();
        }
        return this.getPermPersonFromDb(ctx, perId, permList);
    }

    private List<PermInfoDTO> getPermPersonFromDb(Context ctx, String permIds, Map<String, String> permList) {
        ArrayList<PermInfoDTO> ppInfoDto = new ArrayList<PermInfoDTO>();
        if (permIds != null && permIds.length() > 0) {
            StringBuilder sql = new StringBuilder("select per.fid as ");
            sql.append("id").append(", per.fname_l2 as ").append("name").append(",per.fnumber as ").append("number").append(",admin.fname_l2 as ").append("AdminOrgUnitName").append(",admin.fdisplayname_l2 as ").append("AdminOrgUnitdisplayName").append(",admin.fid as AdminOrgUnitID").append(" from t_bd_person per").append(" inner join t_hr_personposition pp on pp.fpersonid = per.fid").append(" inner join t_org_admin admin on admin.fid = pp.fpersondep where per.fid in(").append(permIds).append(")");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    PermInfoDTO info = new PermInfoDTO();
                    info.setId(rs.getString("id"));
                    info.setName(rs.getString("name"));
                    info.setNumber(rs.getString("number"));
                    info.setAdminName(rs.getString("AdminOrgUnitName"));
                    info.setAdminDisplayName(rs.getString("AdminOrgUnitdisplayName"));
                    info.setAdminOrgUnitId(rs.getString("AdminOrgUnitID"));
                    info.setPerms(permList.get(rs.getString("id")));
                    ppInfoDto.add(info);
                }
            }
            catch (Exception e) {
                logger.error((Object)"findDefaultPerson error===", (Throwable)e);
            }
        }
        return ppInfoDto;
    }

    public List<PermInfoDTO> findColPermOrg(Context ctx, DocumentInfo docInfo) {
        String orgId = "";
        HashMap<String, String> permList = new HashMap<String, String>();
        StringBuilder perIds = new StringBuilder(100);
        if (docInfo != null && docInfo.getAdmin().size() > 0) {
            perIds.append("''");
            for (int i = 0; i < docInfo.getAdmin().size(); ++i) {
                DocumentAdminInfo info = docInfo.getAdmin().get(i);
                if (info == null) continue;
                perIds.append(",'").append(info.getAdmin().getId().toString()).append("'");
                permList.put(info.getAdmin().getId().toString(), info.getPermList());
            }
            orgId = perIds.toString();
        }
        return this.getPermOrgFromDb(ctx, orgId, permList);
    }

    private List<PermInfoDTO> getPermOrgFromDb(Context ctx, String permIds, Map<String, String> permList) {
        ArrayList<PermInfoDTO> ppInfoDto = new ArrayList<PermInfoDTO>();
        if (permIds.length() > 0) {
            StringBuilder sql = new StringBuilder("select fid as ");
            sql.append("id").append(", fname_l2 as ").append("name").append(",fnumber as ").append("number").append(",fdisplayname_l2 as ").append("AdminOrgUnitdisplayName").append(" from t_org_admin where fid in(").append(permIds).append(")");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    PermInfoDTO info = new PermInfoDTO();
                    info.setId(rs.getString("id"));
                    info.setName(rs.getString("name"));
                    info.setNumber(rs.getString("number"));
                    info.setAdminDisplayName(rs.getString("AdminOrgUnitdisplayName"));
                    info.setPerms(permList.get(rs.getString("id")));
                    ppInfoDto.add(info);
                }
            }
            catch (Exception e) {
                logger.error((Object)"findDefaultPerson error===", (Throwable)e);
            }
        }
        return ppInfoDto;
    }

    public List<PermInfoDTO> findColPermRole(Context ctx, DocumentInfo docInfo) {
        String roleId = "";
        HashMap<String, String> permList = new HashMap<String, String>();
        StringBuilder perIds = new StringBuilder(100);
        if (docInfo != null && docInfo.getRole().size() > 0) {
            perIds.append("''");
            for (int i = 0; i < docInfo.getRole().size(); ++i) {
                DocumentRoleInfo info = docInfo.getRole().get(i);
                if (info == null) continue;
                perIds.append(",'").append(info.getRole().getId().toString()).append("'");
                permList.put(info.getRole().getId().toString(), info.getPermList());
            }
            roleId = perIds.toString();
        }
        return this.getPermRoleFromDb(ctx, roleId, permList);
    }

    private List<PermInfoDTO> getPermRoleFromDb(Context ctx, String permIds, Map<String, String> permList) {
        ArrayList<PermInfoDTO> ppInfoDto = new ArrayList<PermInfoDTO>();
        if (permIds.length() > 0) {
            StringBuilder sql = new StringBuilder("select fid as ");
            sql.append("id").append(", fname_l2 as ").append("name").append(",fnumber as ").append("number").append(" from T_PM_Role where fid in(").append(permIds).append(")");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    PermInfoDTO info = new PermInfoDTO();
                    info.setId(rs.getString("id"));
                    info.setName(rs.getString("name"));
                    info.setNumber(rs.getString("number"));
                    info.setPerms(permList.get(rs.getString("id")));
                    ppInfoDto.add(info);
                }
            }
            catch (Exception e) {
                logger.error((Object)"findDefaultPerson error===", (Throwable)e);
            }
        }
        return ppInfoDto;
    }

    public String getBodyContent(Context ctx, DocumentInfo docInfo) {
        String bodyContent = null;
        if (docInfo.getId() == null) {
            return null;
        }
        if (docInfo.getContentType().getValue() == ContentTypeEnum.HTML.getValue()) {
            AttachmentInfo attachInfo = this.getAttacheByBizID(ctx, docInfo.getId().toString());
            bodyContent = attachInfo != null ? new String(attachInfo.getFile()) : null;
        }
        return bodyContent;
    }

    private AttachmentInfo getAttacheByBizID(Context ctx, String seleID) {
        AttachmentInfo attachInfo = null;
        try {
            BOSUuid attachID = this.getAttachBOSId(ctx, seleID);
            attachInfo = (AttachmentInfo)AttachmentFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(attachID));
            if (attachInfo.getFile() == null) {
                byte[] files = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx).downLoad(attachID.toString());
                attachInfo.setFile(files);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return attachInfo;
    }

    private BOSUuid getAttachBOSId(Context ctx, String seleID) {
        BOSUuid attachID = null;
        IBoAttchAsso boAtt = null;
        BoAttchAssoInfo info = null;
        BoAttchAssoCollection cols = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("boID", (Object)seleID, CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        try {
            boAtt = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            cols = boAtt.getBoAttchAssoCollection(ev);
            if (cols != null && cols.size() > 0) {
                info = cols.get(0);
            }
            if (info == null) {
                return null;
            }
            attachID = info.getAttachment().getId();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attachID;
    }

    public DocumentInfo saveDocument(Context ctx, DocumentInfoDTO docInfoDto, String personMapStr, String orgMapStr, String roleMapStr, String associateDoc) throws Exception {
        DocumentInfo info = null;
        if (!"true".equals(docInfoDto.getAddNew())) {
            info = this.findDocumentById(ctx, docInfoDto.getId(), docInfoDto.getColumnId());
        } else {
            info = new DocumentInfo();
            DmColumnManagerService dmService = new DmColumnManagerService(null);
            CategoryInfo catInfo = dmService.findCategoryInfoById(ctx, docInfoDto.getColumnId(), null, null);
            info.setId(BOSUuid.read((String)docInfoDto.getId()));
            info.setCategory(catInfo);
            info.setState(DmState.ENABLE);
            info.setReadCount(0);
            info.setCommentCount(0);
            info.setPublishCount(0);
            info.setRecommendCount(0);
            info.setWfState(DocWfState.DRAFT);
            info.setCreatePerson(ContextUtil.getCurrentUserInfo((Context)ctx).getPerson());
            info.setCreateTime(DmCommonUtils.getTime());
        }
        boolean needSaveVersion = false;
        if (info.getWfState() == DocWfState.PUBLISH && !"info".equals(docInfoDto.getEditType())) {
            needSaveVersion = true;
        }
        info = this.setDocumentBasicInfo(ctx, info, docInfoDto, associateDoc);
        info = this.setDocDim(info, docInfoDto.getDimIds());
        info = this.setContentPerson(info, personMapStr);
        info = this.setContentOrg(info, orgMapStr);
        info = this.setContentRole(info, roleMapStr);
        Document service = new Document(ctx);
        if (needSaveVersion && info.getCategory().getBoolean("isVerSet")) {
            info.setId(BOSUuid.read((String)docInfoDto.getNewVersionDocId()));
            service.addnew((CoreBaseInfo)info);
        } else {
            service.save((CoreBaseInfo)info);
        }
        if ("1".equals(docInfoDto.getContentType())) {
            this.saveBodyContent(ctx, docInfoDto.getContent(), info.getId().toString());
        }
        return info;
    }

    private DocumentInfo setDocumentBasicInfo(Context ctx, DocumentInfo info, DocumentInfoDTO docInfoDto, String associateDoc) throws Exception {
        info.setTitle(docInfoDto.getTitle());
        info.setNumber(docInfoDto.getNumber());
        info.setVersion(docInfoDto.getVersion());
        if (!StringUtil.isEmpty((String)docInfoDto.getTemplate())) {
            DocTemplateInfo ti = new DocTemplateInfo();
            ti.setId(BOSUuid.read((String)docInfoDto.getTemplate()));
            info.setTemplate(ti);
        }
        info.setContentType(ContentTypeEnum.getEnum(Integer.parseInt(docInfoDto.getContentType())));
        info.setIsFullScreen(this.transferCheckBoxToBoolean(docInfoDto.getViewScreen()));
        info.setSourceCreateTime(docInfoDto.getAuthorDate());
        info.getAssociateDoc().clear();
        info.getAssociateDoc().addCollection(this.setAssociateDoc(ctx, associateDoc));
        if (info.getWfState() == DocWfState.DRAFT) {
            info.setWfState(DocWfState.getEnum(docInfoDto.getWfState()));
        } else if (!"info".equals(docInfoDto.getEditType())) {
            info.setWfState(DocWfState.getEnum(docInfoDto.getWfState()));
        }
        info.setIsEnablePerm(this.transferCheckBoxToBoolean(docInfoDto.getEnablePerm()));
        info.setIsPrintAttach(this.transferCheckBoxToBoolean(docInfoDto.getCanPrintAttach()));
        PersonInfo person = new PersonInfo();
        person.setId(BOSUuid.read((String)docInfoDto.getAuthorId()));
        info.setAuthor(person);
        info.setDocDept(DmCommonUtils.getHeightOrgByUserID(ctx, docInfoDto.getAuthorId()));
        info.setTag(docInfoDto.getTab());
        info.setDocMarkNumber(docInfoDto.getSn());
        info.setSourceCreateTime(docInfoDto.getAuthorDate());
        info.setSummary(docInfoDto.getSummary());
        info.setCanCopy(this.transferCheckBoxToBoolean(docInfoDto.getCanCopy()));
        info.setCanDownload(this.transferCheckBoxToBoolean(docInfoDto.getCanDownload()));
        info.setIsRed(this.transferCheckBoxToBoolean(docInfoDto.getSetRed()));
        if (this.transferCheckBoxToBoolean(docInfoDto.getSetRed())) {
            info.setRedStartTime(docInfoDto.getRedStartDate());
            info.setRedEndTime(docInfoDto.getRedEndDate());
        }
        info.setIsTop(this.transferCheckBoxToBoolean(docInfoDto.getSetTop()));
        if (this.transferCheckBoxToBoolean(docInfoDto.getSetTop())) {
            info.setTopStartTime(docInfoDto.getTopStartDate());
            info.setTopEndTime(docInfoDto.getTopEndDate());
        }
        info.setIsLatest(this.transferCheckBoxToBoolean(docInfoDto.getSetNew()));
        if (this.transferCheckBoxToBoolean(docInfoDto.getSetNew())) {
            info.setLatestStartTime(docInfoDto.getNewStartDate());
            info.setLatestEndTime(docInfoDto.getNewEndDate());
        }
        info.setDocSerialNO(Integer.parseInt(docInfoDto.getOrderNumber()));
        return info;
    }

    private DocumentAssociateDocCollection setAssociateDoc(Context ctx, String associateDoc) throws Exception {
        DocumentAssociateDocCollection dadc = new DocumentAssociateDocCollection();
        JSONObject assMap = new JSONObject(associateDoc);
        Iterator iter = assMap.keys();
        while (iter.hasNext()) {
            DocumentAssociateDocInfo daInfo = new DocumentAssociateDocInfo();
            String key = (String)iter.next();
            JSONObject assDoc = (JSONObject)assMap.get(key);
            if ("url".equals(assDoc.get("type").toString())) {
                daInfo.setUrl(assDoc.get("url").toString());
                daInfo.setUrlTitle(assDoc.get("title").toString());
            } else {
                ObjectUuidPK pk = new ObjectUuidPK(assDoc.get("docId").toString());
                DocumentInfo docInfo = DocumentFactory.getLocalInstance(ctx).getDocumentInfo((IObjectPK)pk);
                daInfo.setDocument(docInfo);
            }
            dadc.add(daInfo);
        }
        return dadc;
    }

    private DocumentInfo setDocDim(DocumentInfo info, String dimIds) throws Exception {
        String[] ids;
        if (StringUtil.isEmpty((String)dimIds)) {
            return info;
        }
        info.getDimension().clear();
        for (String dimId : ids = dimIds.split(",")) {
            DocumentDimensionInfo item = new DocumentDimensionInfo();
            DimensionInfo dim = new DimensionInfo();
            dim.setId(BOSUuid.read((String)dimId));
            item.setDimension(dim);
            if (info.getDimension().contains(item)) continue;
            info.getDimension().add(item);
        }
        return info;
    }

    private DocumentInfo setContentPerson(DocumentInfo info, String personMapStr) throws Exception {
        info.getPerson().clear();
        JSONObject personMap = new JSONObject(personMapStr);
        Iterator iter = personMap.keys();
        PersonInfo perInfo = null;
        String key = null;
        while (iter.hasNext()) {
            DocumentPersonInfo documentPersonInfo = new DocumentPersonInfo();
            key = (String)iter.next();
            String permColumn = (String)personMap.get(key);
            if ("".equals(permColumn)) continue;
            perInfo = new PersonInfo();
            perInfo.setId(BOSUuid.read((String)key));
            documentPersonInfo.setPerson(perInfo);
            documentPersonInfo.setPermList((String)personMap.get(key));
            info.getPerson().add(documentPersonInfo);
        }
        return info;
    }

    private DocumentInfo setContentOrg(DocumentInfo info, String orgMapStr) throws Exception {
        info.getAdmin().clear();
        JSONObject orgMap = new JSONObject(orgMapStr);
        Iterator iter = orgMap.keys();
        AdminOrgUnitInfo adminInfo = null;
        String key = null;
        while (iter.hasNext()) {
            DocumentAdminInfo documentAdminInfo = new DocumentAdminInfo();
            key = (String)iter.next();
            String permColumn = (String)orgMap.get(key);
            if ("".equals(permColumn)) continue;
            adminInfo = new AdminOrgUnitInfo();
            adminInfo.setId(BOSUuid.read((String)key));
            documentAdminInfo.setPermList((String)orgMap.get(key));
            documentAdminInfo.setAdmin(adminInfo);
            info.getAdmin().add(documentAdminInfo);
        }
        return info;
    }

    private DocumentInfo setContentRole(DocumentInfo info, String roleMapStr) throws Exception {
        info.getRole().clear();
        JSONObject roleMap = new JSONObject(roleMapStr);
        Iterator iter = roleMap.keys();
        RoleInfo roleInfo = null;
        String key = null;
        while (iter.hasNext()) {
            DocumentRoleInfo documentRoleInfo = new DocumentRoleInfo();
            key = (String)iter.next();
            String permColumn = (String)roleMap.get(key);
            if ("".equals(permColumn)) continue;
            roleInfo = new RoleInfo();
            roleInfo.setId(BOSUuid.read((String)key));
            documentRoleInfo.setRole(roleInfo);
            documentRoleInfo.setPermList((String)roleMap.get(key));
            info.getRole().add(documentRoleInfo);
        }
        return info;
    }

    private void saveBodyContent(Context ctx, String bodyContent, String docId) throws Exception {
        boolean removeFlag = false;
        if (bodyContent == null || bodyContent.trim().length() <= 0) {
            removeFlag = true;
        }
        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
        String tempAttacheId = null;
        String[] ids = asm.getAttachmentIDsByBoID(docId);
        if (ids != null && ids.length > 0) {
            tempAttacheId = ids[0];
        }
        Calendar date = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String docName = format.format(date.getTime()).replaceAll(":", "-");
        if (tempAttacheId != null) {
            if (removeFlag) {
                asm.deleteAttachemtsByBoID(docId);
            } else {
                IAttachment attach = AttachmentFactory.getLocalInstance((Context)ctx);
                AttachmentInfo attachInfo = attach.getAttachmentInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempAttacheId)));
                attachInfo.setName("DMdocBody_" + docName);
                attachInfo.setSimpleName("DMdocBody_" + docName);
                attachInfo.setType("b");
                attach.update((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)tempAttacheId)), attachInfo);
                asm.updateAttachmentContent(tempAttacheId, bodyContent.getBytes());
            }
        } else {
            if (removeFlag) {
                return;
            }
            SimpleAttachmentInfo info = new SimpleAttachmentInfo();
            info.setContent(bodyContent.getBytes());
            info.setMainName("DMdocBody_" + docName);
            info.setExtName("b");
            asm.addNewAttachment(ctx, docId, info);
        }
    }

    public String validateDocVersion(Context ctx, DocumentInfo documentInfo) {
        String sourceDocumentId;
        String result = "";
        StringBuilder oql = new StringBuilder();
        oql.append("select document.version where document.version='").append(documentInfo.getVersion().toString()).append("'");
        DocHistory docHistoryService = new DocHistory(ctx);
        if (null != documentInfo.getSource()) {
            String sourceId = documentInfo.getSource().getId().toString();
            sourceDocumentId = null;
            try {
                sourceDocumentId = docHistoryService.getDocHistoryInfo("select sourceDocument.id where document.id='" + sourceId + "'").getSourceDocument().getId().toString();
            }
            catch (Exception e) {
                result = "findHistoryError";
                e.printStackTrace();
            }
        } else {
            return "notExit";
        }
        oql.append(" and sourceDocument.id ='").append(sourceDocumentId).append("'");
        oql.append(" and document.wfstate in (1,2,3)");
        oql.append(" and state != 2");
        oql.append(" and (document.version != '' or document.version is not null)");
        try {
            result = docHistoryService.exists(oql.toString()) ? "versonIsExit" : "notExit";
        }
        catch (Exception e2) {
            logger.error((Object)("validateDocVersion()_oql:" + oql.toString()), (Throwable)e2);
            result = "judgeExitError";
            e2.printStackTrace();
        }
        return result;
    }

    public void delMySendShared(Context ctx, List<String> docrIdList) throws Exception {
        String countSql = "select count(*) sum from t_dm_documentrecommend where fid=?";
        String delSql = "update t_dm_documentrecommend set fstate=? where fid=?";
        IRowSet rowSet = null;
        for (String docrId : docrIdList) {
            int sum;
            Object[] param = new Object[]{docrId};
            rowSet = DbUtil.executeQuery((Context)ctx, (String)countSql, (Object[])param);
            if (rowSet == null || !rowSet.next() || (sum = rowSet.getInt(1)) != 1) continue;
            Object[] _param = new Object[]{2, docrId};
            DbUtil.execute((Context)ctx, (String)delSql, (Object[])_param);
        }
    }

    public void delMyReceiveShared(Context ctx, List<String> docreIdList) throws Exception {
        String countSql = "select count(*) sum from t_dm_documentrecommendentry where fid=?";
        String delSql = "update t_dm_documentrecommendentry set fstate=? where fid=?";
        IRowSet rowSet = null;
        for (String docreId : docreIdList) {
            int sum;
            Object[] param = new Object[]{docreId};
            rowSet = DbUtil.executeQuery((Context)ctx, (String)countSql, (Object[])param);
            if (rowSet == null || !rowSet.next() || (sum = rowSet.getInt(1)) != 1) continue;
            Object[] _param = new Object[]{2, docreId};
            DbUtil.execute((Context)ctx, (String)delSql, (Object[])_param);
        }
    }

    public void delDoc(Context ctx, int dmStateValue, List<String> idList) throws Exception {
        boolean deleteResult = false;
        this.changeVOState(ctx, dmStateValue, idList);
        DocumentLockServiceImpl lockService = new DocumentLockServiceImpl();
        lockService.delDocLock(ctx, idList);
        IDocumentDistribute idd = DocumentDistributeFactory.getLocalInstance(ctx);
        for (String id : idList) {
            DocumentInfo docInfo = DocumentFactory.getLocalInstance(ctx).getDocumentInfo("select category.id where id = '" + id + "'");
            IFMEService service = FMEServiceFactory.getServiceInstance((Context)ctx);
            String[] businessID = new String[]{docInfo.getId().toString()};
            deleteResult = service.deleteFile(businessID);
            if (!deleteResult) break;
            if (!idd.exists("select id where distributeDoc.id = '" + id + "'")) continue;
            DocumentDistributeCollection ddc = idd.getDocumentDistributeCollection("select id where distributeDoc.id = '" + id + "'");
            for (int i = 0; i < ddc.size(); ++i) {
                DocumentDistributeInfo ddInfo = ddc.get(i);
                ddInfo.setState(DmState.DELETE);
                idd.update((IObjectPK)new ObjectUuidPK(ddInfo.getId().toString()), ddInfo);
            }
        }
    }

    public void removeDimForDoc(Context ctx, String dimId, List<String> idList) throws Exception {
        IDocumentDimension docDim = DocumentDimensionFactory.getLocalInstance(ctx);
        for (String docId : idList) {
            DocumentInfo docInfo = (DocumentInfo)DocumentFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)docId)));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("dimension", (Object)dimId));
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)docInfo.getId().toString()));
            docDim.delete(filter);
        }
    }

    public void setDocState(Context ctx, int dmStateValue, List<String> idList) throws Exception {
        if (0 == dmStateValue) {
            DMForWafFacadeFactory.getLocalInstance(ctx).cancelDocument(idList);
        } else {
            DMForWafFacadeFactory.getLocalInstance(ctx).cancelCancelDocument(idList);
        }
    }

    public List<String> changeStringsToList(String str) throws Exception {
        ArrayList<String> strList = new ArrayList<String>();
        if (str != null) {
            String[] strs;
            for (String s : strs = str.split(",")) {
                strList.add(s);
            }
        }
        return strList;
    }

    private void changeVOState(Context ctx, int dmStateValue, List idList) throws BOSException {
        DmServerService.changeVOStateBySql(ctx, this.getEntityTable(), dmStateValue, idList);
    }

    private String getEntityTable() {
        return "T_DM_Document";
    }

    public String submitDOc(Context ctx, String docId) throws Exception {
        String result = "success";
        Document service = new Document(ctx);
        DocumentInfo doc = service.getDocumentInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)docId)), this.getSelectors());
        if (!this.checkCategoryState(doc)) {
            return "hasDisabled";
        }
        if (doc.getCategory().isIsVerSet() && StringUtil.isEmpty((String)doc.getVersion())) {
            return "versionNull";
        }
        if (doc != null) {
            service.submit((CoreBaseInfo)doc);
            try {
                Thread.sleep(1500L);
                for (int i = 0; i < 30; ++i) {
                    if (this.isCompleteWorkFlow(ctx, docId)) {
                        logger.info((Object)"submitDoc=====================Thread.sleep outttttttt");
                    }
                    logger.info((Object)("before Thread.sleep, times: " + i + "====================" + DmCommonUtils.getTime()));
                    Thread.sleep(2500L);
                    logger.info((Object)("after Thread.sleep, times: " + i + "====================" + DmCommonUtils.getTime()));
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)("submitDoc=====Thread.sleep(2000)=====Error:" + e.getMessage() + "=====" + DmCommonUtils.getTime()));
            }
        } else {
            result = "noRecord";
        }
        return result;
    }

    private boolean checkCategoryState(DocumentInfo doc) {
        return !DmState.DISABLE.equals((Object)doc.getCategory().getState());
    }

    public boolean isCompleteWorkFlow(Context ctx, String boId) {
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from t_wfr_bizevent where fboid='").append(boId).append("'");
        boolean isComplete = false;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            isComplete = !rs.next();
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
        }
        return isComplete;
    }

    public String setDim(Context ctx, String docId, String dimIds) throws Exception {
        String[] ids;
        String result = "success";
        DocumentDimensionCollection ddCols = new DocumentDimensionCollection();
        IDocumentDimension docDim = DocumentDimensionFactory.getLocalInstance(ctx);
        DocumentInfo docInfo = (DocumentInfo)DocumentFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)docId)));
        for (String dimId : ids = dimIds.split(",")) {
            DimensionInfo item = new DimensionInfo();
            item.setId(BOSUuid.read((String)dimId));
            DocumentDimensionInfo ddInfo = new DocumentDimensionInfo();
            if (docDim.exists("where parent='" + docInfo.getId().toString() + "' and dimension='" + item.getId().toString() + "'")) continue;
            ddInfo.setDimension(item);
            ddInfo.setParent(docInfo);
            ddCols.add(ddInfo);
            docDim.addnew(ddInfo);
        }
        return result;
    }

    public Set<String> getCatPerssionSet(Context ctx, String categoryId) {
        if (StringUtil.isEmpty((String)categoryId)) {
            return null;
        }
        String perId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String bizTableName = "t_dm_category";
        Map<String, Set<String>> permssionMap = PermissionUtil.getBizPermMap(ctx, categoryId, bizTableName);
        Set<String> perssionSet = null;
        if (permssionMap != null && permssionMap.size() > 0) {
            perssionSet = permssionMap.get(perId + categoryId);
        }
        return perssionSet;
    }

    public String moveDoc(Context ctx, String docId, String columnId, String moveType) {
        DocListHelper docListHelper = new DocListHelper();
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(docId);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(this.buildMoveDocFilter(ctx, columnId));
        String result = null;
        result = "up".equals(moveType) ? docListHelper.moveCommonHandle(ctx, idList, ev, SortType.ASCEND, CompareType.GREATER) : docListHelper.moveCommonHandle(ctx, idList, ev, SortType.DESCEND, CompareType.LESS);
        return result;
    }

    private FilterInfo buildMoveDocFilter(Context ctx, String columnId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("category.id", (Object)columnId));
        return filter;
    }

    private boolean transferCheckBoxToBoolean(String checkedValue) {
        return "checked".equals(checkedValue) || "true".equals(checkedValue);
    }

    public boolean isAddNewBtnFlag() {
        return this.addNewBtnFlag;
    }

    public void setAddNewBtnFlag(boolean addNewBtnFlag) {
        this.addNewBtnFlag = addNewBtnFlag;
    }
}

