/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.fme.service.FMEServiceFactory;
import com.kingdee.eas.base.fme.service.IFMEService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.DmState;
import com.kingdee.eas.cp.dm.DocHistoryCollection;
import com.kingdee.eas.cp.dm.DocHistoryFactory;
import com.kingdee.eas.cp.dm.DocHistoryInfo;
import com.kingdee.eas.cp.dm.DocumentFactory;
import com.kingdee.eas.cp.dm.DocumentInfo;
import com.kingdee.eas.cp.dm.IDocHistory;
import com.kingdee.eas.cp.dm.IDocument;
import com.kingdee.eas.cp.dm.web.dto.DocHistoryDTO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DMDocHistoryManager {
    private static final Logger logger = Logger.getLogger(DMDocHistoryManager.class);
    protected static DMDocHistoryManager instance = new DMDocHistoryManager();

    protected DMDocHistoryManager() {
    }

    public static DMDocHistoryManager getInstance() {
        return instance;
    }

    public List<DocHistoryDTO> findDocHistoryList(Context ctx, String docId) throws Exception {
        ArrayList<DocHistoryDTO> historyList = new ArrayList<DocHistoryDTO>();
        MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.cp.dm.app.DocHistoryQuery");
        EntityViewInfo entityViewInfo = this.getEntityViewInfo(ctx, docId);
        IQueryExecutor exec = this.getQueryExecutor((IMetaDataPK)mainQueryPK, entityViewInfo, ctx);
        IRowSet rowSet = exec.executeQuery();
        if (rowSet != null) {
            while (rowSet.next()) {
                DocHistoryDTO dt = new DocHistoryDTO();
                dt.setId(rowSet.getString("id"));
                dt.setTitle(rowSet.getString("title"));
                dt.setAuthor(rowSet.getString("author"));
                dt.setVersion(rowSet.getString("version"));
                dt.setDisbuteTime(rowSet.getString("issueTime"));
                dt.setHistoryState(rowSet.getString("isHistory"));
                dt.setDocumentid(rowSet.getString("documentid"));
                dt.setParentId(rowSet.getString("parentid"));
                historyList.add(dt);
            }
        }
        return historyList;
    }

    private EntityViewInfo getEntityViewInfo(Context ctx, String docId) throws BOSException {
        String sourceid = "";
        IDocHistory idh = DocHistoryFactory.getLocalInstance(ctx);
        FilterInfo filterinfo = new FilterInfo();
        filterinfo.getFilterItems().add(new FilterItemInfo("document.id", (Object)docId, CompareType.EQUALS));
        try {
            if (idh.exists(filterinfo)) {
                EntityViewInfo ev = new EntityViewInfo();
                ev.setFilter(filterinfo);
                DocHistoryInfo dhInfo = idh.getDocHistoryCollection(ev).get(0);
                sourceid = dhInfo.getSourceDocument().getId().toString();
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parentid", (Object)sourceid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("state", (Object)2, CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("wfstate", (Object)3, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("wfstate", (Object)5, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("docstate", (Object)2, CompareType.NOTEQUALS));
        filter.setMaskString("( #0 and #1 and ( #2 or #3 ) and #4 )");
        view.setFilter(filter);
        return view;
    }

    private IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo, Context context) throws Exception {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        exec.option().isIgnoreOrder = false;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    public String delDocHistory(Context ctx, String docId, String hisId, String isHistory) {
        String result = "success";
        try {
            ObjectUuidPK pk = new ObjectUuidPK(hisId);
            IDocHistory idh = DocHistoryFactory.getLocalInstance(ctx);
            DocHistoryInfo dhInfo = idh.getDocHistoryInfo((IObjectPK)pk);
            dhInfo.setState(DmState.DELETE);
            idh.update((IObjectPK)pk, (CoreBaseInfo)dhInfo);
        }
        catch (Exception e) {
            result = "delHistoryError";
            logger.error((Object)("del doc history error=" + e.getMessage()));
            e.printStackTrace();
        }
        try {
            IDocument idoc = DocumentFactory.getLocalInstance(ctx);
            DocumentInfo docInfo = idoc.getDocumentInfo((IObjectPK)new ObjectUuidPK(docId));
            docInfo.setState(DmState.DELETE);
            idoc.update((IObjectPK)new ObjectUuidPK(docInfo.getId()), (CoreBaseInfo)docInfo);
        }
        catch (Exception e) {
            result = "updateDocError";
            logger.error((Object)("update doc  error=" + e.getMessage()));
            e.printStackTrace();
        }
        IFMEService service = FMEServiceFactory.getServiceInstance((Context)ctx);
        String[] businessID = new String[]{docId};
        service.deleteFile(businessID);
        return result;
    }

    public String setCurrentVersion(Context ctx, String docId, String hisId, String sourceId) {
        String result = "";
        try {
            IDocHistory idh = DocHistoryFactory.getLocalInstance(ctx);
            String publishid = "";
            DocHistoryCollection dhc = idh.getDocHistoryCollection("select sourceDocument.id where document.id = '" + sourceId + "'");
            if (dhc.size() > 0) {
                DocHistoryInfo dhInfo = dhc.get(0);
                sourceId = dhInfo.getDocument().getId().toString();
                dhc = idh.getDocHistoryCollection("select document.id,document.isHistory where sourceDocument.id = '" + sourceId + "'");
                if (dhc.size() > 0) {
                    for (int i = 0; i < dhc.size(); ++i) {
                        dhInfo = dhc.get(i);
                        if (dhInfo.getDocument().isIsHistory()) continue;
                        publishid = dhInfo.getDocument().getId().toString();
                        break;
                    }
                }
                IDocument idoc = DocumentFactory.getLocalInstance(ctx);
                ObjectUuidPK pk = new ObjectUuidPK(docId);
                DocumentInfo docInfo = idoc.getDocumentInfo((IObjectPK)pk);
                docInfo.setIsHistory(false);
                docInfo.setState(DmState.ENABLE);
                ObjectUuidPK publishpk = new ObjectUuidPK(publishid);
                DocumentInfo publishInfo = idoc.getDocumentInfo((IObjectPK)publishpk);
                publishInfo.setIsHistory(true);
                docInfo.setCategory(publishInfo.getCategory());
                idoc.update((IObjectPK)publishpk, (CoreBaseInfo)publishInfo);
                idoc.update((IObjectPK)pk, (CoreBaseInfo)docInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)("setCurrentVersion  error=" + e.getMessage()));
            e.printStackTrace();
        }
        return result;
    }
}

