/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserRoleOrgException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.AbstractCategoryInfo;
import com.kingdee.eas.cp.dm.AbstractDocumentInfo;
import com.kingdee.eas.cp.dm.CategoryFactory;
import com.kingdee.eas.cp.dm.CategoryInfo;
import com.kingdee.eas.cp.dm.DimensionInfo;
import com.kingdee.eas.cp.dm.DocAreaFactory;
import com.kingdee.eas.cp.dm.DocAreaInfo;
import com.kingdee.eas.cp.dm.DocumentFactory;
import com.kingdee.eas.cp.dm.DocumentInfo;
import com.kingdee.eas.cp.dm.utils.CommonUtils;
import com.kingdee.eas.cp.dm.web.service.DimensionPermissionServiceHelper;
import com.kingdee.eas.cp.dm.web.service.IDmPermissionService;
import com.kingdee.eas.cp.dm.web.util.DmCommonUtils;
import com.kingdee.eas.cp.dm.web.util.PermissionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.plt.cp.module.document.entity.DmPermCacheInfo;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultDmPermissionService
implements IDmPermissionService {
    private static final Logger logger = Logger.getLogger(DefaultDmPermissionService.class);
    private static Map<String, Set<String>> dmPermissionCache = null;
    public static final String IS_TOP_CAT_USER = "isTopCatUser";
    public static final String IS_TOP_DIM_USER = "isTopDimUser";
    public static final String IS_PER_TEMPLETE_TYPE = "isPerTempleteType";
    public static final String IS_PER_TEMPLETE_MANAGE = "isPerTempleteManage";
    public static final String IS_PER_TAG = "isPerTag";
    public static final String IS_PER_PORTLET_ADDNEW = "isPerPortletAddNew";
    public static final String IS_PER_PORTLET_UPDATE = "isPerPortletUpdate";
    public static final String IS_PER_PORTLET_DELETE = "isPerPortletDelete";
    public static final String IS_PER_PORTLET_CANCEL = "isPerPortletCancel";
    public static final String IS_PER_PORTLET_CANCELCANCEL = "isPerPortletCancelCancel";
    public static final String IS_PER_ATTACHMENTSET = "isPerAttachmentSet";
    public static final String IS_PER_DOCREADHIS = "isPerDocReadHis";
    public static final String IS_PER_DOCMANAGEPARAMETERSSET = "isPerDocManageParametersSet";
    public static final String IS_PER_MANAGE_BORROW = "isPerManageBorrow";
    public static final String IS_PER_VIEW_DOC = "isPerViewDoc";
    public static final String IS_PER_COMMENT_DOC = "isPerCommentDoc";
    public static final String IS_PER_HISTORY_VIEW_DOC = "isPerHistoryViewDoc";
    private static DefaultDmPermissionService dmPermissionService;

    private static synchronized Map<String, Set<String>> getDmPermissionCache() {
        if (dmPermissionCache == null) {
            dmPermissionCache = new HashMap<String, Set<String>>();
        }
        return dmPermissionCache;
    }

    public static synchronized DefaultDmPermissionService getInstance() {
        if (dmPermissionService == null) {
            dmPermissionService = new DefaultDmPermissionService();
        }
        return dmPermissionService;
    }

    @Override
    public boolean hasTopCatPermission(Context ctx) throws BOSException {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
        boolean hasFunctionPermission = false;
        try {
            hasFunctionPermission = iPermission.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, "docArea_maintain");
        }
        catch (EASBizException e) {
            logger.info((Object)("\u83b7\u53d6\u6587\u6863\u533a\u7ba1\u7406\u5458\u6743\u9650\u5931\u8d25: " + e.getMessage()));
        }
        return hasFunctionPermission;
    }

    @Override
    public boolean hasTopDimPermission(Context ctx) throws BOSException {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId());
        boolean hasFunctionPermission = false;
        try {
            hasFunctionPermission = iPermission.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, "dimension_maintain");
        }
        catch (EASBizException e) {
            logger.info((Object)"\u83b7\u53d6\u7ef4\u5ea6\u7ba1\u7406\u5458\u6743\u9650\u5931\u8d25");
            logger.info((Object)e.getMessage());
        }
        return hasFunctionPermission;
    }

    public String getUserSqlByRole(Context ctx, String orgId, List<String> roleIdList) throws BOSException, EASBizException {
        assert (roleIdList != null);
        String organizationId = orgId == null ? ContextUtil.getCurrentAdminUnit((Context)ctx).getId().toString() : orgId;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT UserRoleOrg.FUserID FROM T_PM_UserRoleOrg UserRoleOrg ").append(" INNER JOIN T_PM_User U ON U.FID = UserRoleOrg.FUserID ").append(" WHERE UserRoleOrg.FOrgID = '").append(organizationId).append("' AND UserRoleOrg.FRoleID in ").append(com.kingdee.eas.cp.dm.web.util.CommonUtils.getStrFromList(roleIdList));
        return sql.toString();
    }

    public UserCollection getUsers(Context ctx, IObjectPK orgPK, IObjectPK rolePK) throws BOSException, EASBizException {
        assert (orgPK != null && rolePK != null);
        try {
            UserCollection collection = new UserCollection();
            StringBuffer sql = new StringBuffer(200);
            String nameField = MultiLangHelper.getFieldName((String)"FName", (Locale)ctx.getLocale());
            Object[] params = new Object[]{orgPK.toString(), rolePK.toString()};
            sql.append("SELECT UserRoleOrg.FUserID, ").append(" U.FNumber , U.").append(nameField).append(" FROM T_PM_UserRoleOrg UserRoleOrg ").append(" INNER JOIN T_PM_User U ON U.FID = UserRoleOrg.FUserID ").append(" WHERE UserRoleOrg.FOrgID = ? ").append(" AND UserRoleOrg.FRoleID = ? ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            UserInfo userInfo = null;
            while (rowSet.next()) {
                userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rowSet.getString("FUserID")));
                userInfo.setNumber(rowSet.getString("FNumber"));
                userInfo.setName(rowSet.getString(nameField));
                collection.add(userInfo);
            }
            return collection;
        }
        catch (SQLException e) {
            throw new UserRoleOrgException(UserRoleOrgException.GET_USERROLEORG_FAIL, (Throwable)e);
        }
    }

    @Override
    public boolean checkHasPermission(Context ctx, String perId, String userId, String operStr, String bizId, String bizTableName) {
        boolean rtnVal;
        block3: {
            String[] operArray;
            block4: {
                rtnVal = false;
                if (!"t_dm_category".equals(bizTableName)) break block4;
                List dmPermCacheList = PermissionUtil.getDmPermListCache();
                for (com.kingdee.eas.cp.dm.web.util.DmPermCacheInfo dmPermCacheInfo : dmPermCacheList) {
                    if (null != dmPermCacheInfo.getDocID() || !bizId.equals(dmPermCacheInfo.getCatID())) continue;
                    rtnVal = true;
                    break block3;
                }
                break block3;
            }
            this.loadPermission(ctx, perId, userId, bizId, bizTableName);
            if (!StringUtils.isNotEmpty((String)operStr)) break block3;
            for (String oper : operArray = operStr.split(",")) {
                rtnVal = DefaultDmPermissionService.getDmPermissionCache().get(perId + bizId).contains(oper);
                if (!rtnVal) {
                    continue;
                }
                break;
            }
        }
        return rtnVal;
    }

    @Override
    public boolean checkHasPermission(Context ctx, String perId, String userId, Set<String> operStrNumSet, String bizId, String bizTableName) {
        this.loadPermission(ctx, perId, userId, bizId, bizTableName);
        boolean isPerm = false;
        if (DefaultDmPermissionService.getDmPermissionCache().get(perId + bizId) != null) {
            Set<String> permSet = DefaultDmPermissionService.getDmPermissionCache().get(perId + bizId);
            if (permSet.contains("2") || permSet.contains("3") || permSet.contains("6")) {
                permSet.add("4");
            }
            for (String perMission : operStrNumSet) {
                isPerm = DefaultDmPermissionService.getDmPermissionCache().get(perId + bizId).contains(perMission);
                if (!isPerm) continue;
                break;
            }
        }
        return isPerm;
    }

    private void loadPermission(Context ctx, String perId, String userId, String bizId, String bizTableName) {
        DefaultDmPermissionService.getDmPermissionCache().putAll(this.getBizPermMap(ctx, perId, userId, bizId, bizTableName));
    }

    private static String makeWhereExpByOperNumSet(Set<String> operStrNumSet) {
        StringBuilder whereExp = new StringBuilder();
        String permLikeValue = null;
        String permEndLikeValue = null;
        String permMiddleLikeValue = null;
        int i = 0;
        for (String operNum : operStrNumSet) {
            permLikeValue = operNum + ",%";
            permEndLikeValue = "%," + operNum;
            permMiddleLikeValue = "%," + operNum + ",%";
            if (i != 0) {
                whereExp.append(" or ");
            }
            whereExp.append(" bizadmin.FPermList like '").append(permLikeValue).append("' or bizperson.FPermList like '").append(permLikeValue).append("' or bizrole.FPermList like '").append(permLikeValue).append("' or ").append(" bizadmin.FPermList like '").append(permEndLikeValue).append("' or bizperson.FPermList like '").append(permEndLikeValue).append("' or bizrole.FPermList like '").append(permEndLikeValue).append("' or ").append(" bizadmin.FPermList like '").append(permMiddleLikeValue).append("' or bizperson.FPermList like '").append(permMiddleLikeValue).append("' or bizrole.FPermList like '").append(permMiddleLikeValue).append("' or ").append("bizadmin.FPermList = '").append(operNum).append("' or bizperson.FPermList = '").append(operNum).append("' or bizrole.FPermList = '").append(operNum).append("'  \n");
            ++i;
        }
        return whereExp.toString();
    }

    @Override
    public Set<String> getHasPermCatIdSet(Context ctx, String perId, String userId, Set<String> operStrNumSet, String bizId, String bizTableName) {
        HashSet<String> bizSet = new HashSet<String>();
        bizSet.add(bizId);
        Map<String, Set<String>> rtnMap = this.getHasPermCatIdMap(ctx, perId, userId, operStrNumSet, bizSet, "t_dm_category");
        return rtnMap.get(bizId);
    }

    public String getHasPermDocIdSql(Context ctx, String perId, String userId, String catId) {
        String personSql = this.getHasPermDocIdSqlPerson(ctx, perId, userId);
        String adminSql = this.getHasPermDocIdSqlAdminByCategory(ctx, perId, userId, catId);
        String roleSql = this.getHasPermDocIdSqlRole(perId, userId);
        String specialSql = DefaultDmPermissionService.getHasPermDocIdSqlSpecial(ctx, perId, userId, null, null, catId);
        StringBuffer allSql = new StringBuffer();
        allSql.append(" ( ");
        allSql.append(personSql).append(" union ").append(adminSql).append(" union ").append(roleSql).append(" union ").append(specialSql).append(" ) ");
        return allSql.toString();
    }

    public boolean hasLv1DimPermission(Context ctx, DimensionInfo dimInfo) throws BOSException {
        return DimensionPermissionServiceHelper.getInstance().hasLv1DimPermission(ctx, dimInfo);
    }

    public Map<String, Set<String>> getHasPermCatIdSetExcludeNull(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, int[] state) {
        Set value;
        HashMap<String, Set<String>> daCatMap = new HashMap<String, Set<String>>();
        Map<String, Set<String>> rtnMap1 = this.getHasPermCatIdSetPerson(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        Map<String, Set<String>> rtnMap2 = this.getHasPermCatIdSetAdmin(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        Map<String, Set<String>> rtnMap3 = this.getHasPermCatIdSetRole(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        Map<String, Set<String>> rtnMap4 = this.getHasPermCatIdSetBySpecial(ctx, perId, userId, bizIdSet, bizTableName, daCatMap, state);
        if (null != rtnMap1 && rtnMap1.size() > 0) {
            daCatMap.putAll(rtnMap1);
        }
        if (null != rtnMap2 && rtnMap2.size() > 0) {
            if (daCatMap.size() == 0) {
                daCatMap.putAll(rtnMap2);
            } else {
                for (Map.Entry<String, Set<String>> b2 : rtnMap2.entrySet()) {
                    String key2 = b2.getKey();
                    Set<String> value2 = b2.getValue();
                    if (daCatMap.containsKey(key2)) {
                        value = (Set)daCatMap.get(key2);
                        value.addAll(value2);
                        daCatMap.put(key2, value);
                        continue;
                    }
                    daCatMap.put(key2, value2);
                }
            }
        }
        if (null != rtnMap3 && rtnMap3.size() > 0) {
            if (daCatMap.size() == 0) {
                daCatMap.putAll(rtnMap3);
            } else {
                for (Map.Entry<String, Set<String>> b3 : rtnMap3.entrySet()) {
                    String key3 = b3.getKey();
                    Set<String> value3 = b3.getValue();
                    if (daCatMap.containsKey(key3)) {
                        value = (Set)daCatMap.get(key3);
                        value.addAll(value3);
                        daCatMap.put(key3, value);
                        continue;
                    }
                    daCatMap.put(key3, value3);
                }
            }
        }
        if (null != rtnMap4 && rtnMap4.size() > 0) {
            if (daCatMap.size() == 0) {
                daCatMap.putAll(rtnMap4);
            } else {
                for (Map.Entry<String, Set<String>> b4 : rtnMap4.entrySet()) {
                    String key4 = b4.getKey();
                    Set<String> value4 = b4.getValue();
                    if (daCatMap.containsKey(key4)) {
                        value = (Set)daCatMap.get(key4);
                        value.addAll(value4);
                        daCatMap.put(key4, value);
                        continue;
                    }
                    daCatMap.put(key4, value4);
                }
            }
        }
        if (daCatMap != null) {
            for (String str : daCatMap.keySet()) {
                if (((Set)daCatMap.get(str)).size() > 0) continue;
                daCatMap.remove(str);
            }
        }
        return daCatMap;
    }

    private Map<String, Set<String>> getHasPermCatIdSet(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap, int[] state) {
        List dmPermListCache = PermissionUtil.getDmPermListCache();
        Set<String> tempSet = operStrNumSet;
        if (operStrNumSet == null) {
            tempSet = new HashSet<String>();
            tempSet.add("4");
        }
        String permList = null;
        HashSet<String> catIdSet = new HashSet<String>();
        if (dmPermListCache != null) {
            block0: for (com.kingdee.eas.cp.dm.web.util.DmPermCacheInfo d : dmPermListCache) {
                if (!StringUtils.isEmpty((String)d.getDocID()) || !bizIdSet.contains(d.getDocAreaID())) continue;
                permList = d.getPermList();
                if (null == permList || "".equals(permList)) break;
                String[] pa = permList.split(",");
                HashSet<String> ps = new HashSet<String>();
                for (String s : pa) {
                    ps.add(s);
                }
                for (String s : tempSet) {
                    if (!ps.contains(s) || catIdSet.contains(d.getCatID())) continue;
                    catIdSet.add(d.getCatID());
                    continue block0;
                }
            }
        }
        Map<String, Set<String>> rtnMap = this.getBizParentIds(ctx, catIdSet, "t_dm_category");
        return rtnMap;
    }

    private Map<String, Set<String>> getHasPermCatIdSetBySpecial(Context ctx, String perId, String userId, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap, int[] state) {
        List dmPermListCache = PermissionUtil.getDmPermListCache();
        Map<String, Set<String>> rtnMap = daCatMap;
        String bizName = bizTableName;
        if (bizTableName == null) {
            bizName = "t_dm_category";
        }
        if (daCatMap == null) {
            rtnMap = new HashMap<String, Set<String>>();
        }
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.add("4");
        tempSet.add("20");
        tempSet.add("5");
        tempSet.add("8");
        tempSet.add("13");
        String permList = null;
        HashSet<String> catIdSet = new HashSet<String>();
        if (dmPermListCache != null) {
            block0: for (com.kingdee.eas.cp.dm.web.util.DmPermCacheInfo d : dmPermListCache) {
                if (StringUtils.isEmpty((String)d.getDocID()) || !bizIdSet.contains(d.getDocAreaID())) continue;
                permList = d.getPermList();
                if (null == permList || "".equals(permList)) break;
                String[] pa = permList.split(",");
                HashSet<String> ps = new HashSet<String>();
                for (String s : pa) {
                    ps.add(s);
                }
                for (String s : tempSet) {
                    if (!ps.contains(s) || catIdSet.contains(d.getCatID())) continue;
                    catIdSet.add(d.getCatID());
                    continue block0;
                }
            }
        }
        rtnMap = this.getBizParentIds(ctx, catIdSet, "t_dm_category");
        return rtnMap;
    }

    public void clearDmPermissionCache() {
        DefaultDmPermissionService.getDmPermissionCache().clear();
    }

    public Map<String, Set<String>> getBizPermMap(Context ctx, String perId, String userId, String bizId, String bizTableName) {
        List dmPermListCache = PermissionUtil.getDmPermListCache();
        HashMap<String, Set<String>> bizPermMap = new HashMap<String, Set<String>>();
        HashSet<String> permSet = new HashSet<String>();
        bizTableName = bizTableName.toLowerCase();
        this.getBizPermMapAdmin(ctx, perId, userId, bizId, bizTableName, permSet);
        this.getBizPermMapPerson(ctx, perId, userId, bizId, bizTableName, permSet);
        this.getBizPermMapRole(ctx, perId, userId, bizId, bizTableName, permSet);
        bizPermMap.put(perId + bizId, permSet);
        return bizPermMap;
    }

    public static String generateCategoryIdBySpecialPermission(Context ctx, String perId, String userId, Set<String> operStrNumSet, String bizId) {
        String ctrlUnitID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        boolean containCU = false;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("CUEntry.includeSub"));
            DocAreaInfo curInfo = (DocAreaInfo)DocAreaFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bizId), sic);
            containCU = curInfo.getCUEntry().get(0) != null ? curInfo.getCUEntry().get(0).isIncludeSub() : false;
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        String adminNum = DefaultDmPermissionService.convertLongNumber2Condition(DefaultDmPermissionService.getAdminLongNumberByPersonID(ctx, perId));
        HashSet<String> operSet = new HashSet<String>();
        operSet.add("4");
        operSet.add("20");
        operSet.add("5");
        operSet.add("8");
        operSet.add("13");
        operStrNumSet = operSet;
        String bizTableName = "T_DM_Document";
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select distinct biz.FCategoryID from ");
        selectSql.append(bizTableName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("admin bizadmin on bizadmin.fparentid = biz.fid \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("person bizperson on bizperson.fparentid = biz.fid \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("role bizrole on bizrole.fparentid = biz.fid \n");
        selectSql.append("left outer join t_dm_category bizcategory on bizcategory.fid = biz.FCategoryID \n");
        selectSql.append("left outer join t_dm_docarea da on bizcategory.fdocareaid = da.fid \n");
        selectSql.append("where  \n");
        selectSql.append(" biz.fisEnablePerm = 1 \n");
        selectSql.append(" and ((biz.FWfState=3) or (biz.FCreatorID='" + perId + "')) and ");
        selectSql.append("   (bizperson.fpersonid = '");
        selectSql.append(perId);
        selectSql.append("' or bizperson.fpersonid = '");
        if (DmCommonUtils.isPersonInCU(ctx, perId, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString())) {
            selectSql.append("00000000-0000-0000-0000-000000000000CCE7AED4");
        } else {
            selectSql.append("nodata");
        }
        selectSql.append("' or ");
        selectSql.append(" (exists (  ");
        selectSql.append("SELECT  subADMIN.FID  ");
        selectSql.append("FROM T_BD_Person AS PERSON   ");
        selectSql.append("INNER JOIN T_HR_PersonPosition AS PP ON PERSON.FID = PP.FPersonID ");
        selectSql.append("INNER JOIN T_ORG_PositionMember AS PM ON PERSON.FID = PM.FPersonID ");
        selectSql.append("INNER JOIN T_ORG_Position AS POSITION ON PM.FPositionID = POSITION.FID ");
        selectSql.append("INNER JOIN T_ORG_Admin AS subADMIN ON POSITION.FAdminOrgUnitID = subADMIN.FID  ");
        selectSql.append("where PERSON.fid = '").append(perId).append("'  ");
        selectSql.append("and subADMIN.fid = bizadmin.FAdminID)  ");
        selectSql.append("or ( bizadmin.FIncludeSub = 1 and exists ( ");
        selectSql.append("select fid from T_ORG_Admin sbadmin where sbadmin.fid = bizadmin.FAdminID ");
        if (!containCU) {
            selectSql.append("and fcontrolUnitID = '").append(ctrlUnitID).append("' ");
        }
        selectSql.append("and fnumber in (").append(adminNum).append(") ");
        selectSql.append("))) ");
        selectSql.append("\t\tor bizrole.froleid  \n");
        selectSql.append("\t\tin( \n");
        selectSql.append("\t\t\tselect froleid from T_PM_UserRoleOrg where 1=1");
        selectSql.append("\t\t\tand fuserid = '");
        selectSql.append(userId);
        selectSql.append("' \n");
        selectSql.append("\t\t) \n");
        selectSql.append("\t) \n");
        selectSql.append("    AND da.FID = '");
        selectSql.append(bizId);
        selectSql.append("'  \n");
        selectSql.append("\tAND (");
        selectSql.append(DefaultDmPermissionService.makeWhereExpByOperNumSet(operStrNumSet));
        selectSql.append(")  \n");
        return selectSql.toString();
    }

    public static String getHasPermDocIdSqlSpecial(Context ctx, String perId, String userId, Set<String> operStrNumSet, String docId, String categoryId) {
        HashSet<String> operSet = new HashSet<String>();
        operSet.add("4");
        operSet.add("20");
        operSet.add("5");
        operSet.add("8");
        operSet.add("13");
        operStrNumSet = operSet;
        String bizTableName = "T_DM_Document";
        String ctrlUnitID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        boolean containCU = false;
        try {
            Serializable model;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            if (docId != null && !"".equals(docId)) {
                sic.add(new SelectorItemInfo("category.docArea.CUEntry.includeSub"));
                model = (DocumentInfo)DocumentFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(docId), sic);
                DocAreaInfo curInfo = ((AbstractDocumentInfo)model).getCategory().getDocArea();
                containCU = curInfo.getCUEntry().get(0) != null ? curInfo.getCUEntry().get(0).isIncludeSub() : false;
            } else if (categoryId != null && !"".equals(categoryId)) {
                sic.add(new SelectorItemInfo("docArea.CUEntry.includeSub"));
                model = (CategoryInfo)CategoryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(categoryId), sic);
                DocAreaInfo curInfo = ((AbstractCategoryInfo)model).getDocArea();
                containCU = curInfo.getCUEntry().get(0) != null ? curInfo.getCUEntry().get(0).isIncludeSub() : false;
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        String adminNum = DefaultDmPermissionService.convertLongNumber2Condition(DefaultDmPermissionService.getAdminLongNumberByPersonID(ctx, perId));
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select biz.fid from ");
        selectSql.append(bizTableName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("admin bizadmin on bizadmin.fparentid = biz.fid \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("person bizperson on bizperson.fparentid = biz.fid \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("role bizrole on bizrole.fparentid = biz.fid \n");
        selectSql.append("left outer join t_dm_category bizcategory on bizcategory.fid = biz.FCategoryID \n");
        selectSql.append("left outer join t_dm_docarea da on bizcategory.fdocareaid = da.fid \n");
        selectSql.append("where  \n");
        selectSql.append(" biz.fisEnablePerm = 1 \n");
        selectSql.append(" and (bizperson.fpersonid = '");
        selectSql.append(perId);
        selectSql.append("' or bizperson.fpersonid = '");
        if (DmCommonUtils.isPersonInCU(ctx, perId, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString())) {
            selectSql.append("00000000-0000-0000-0000-000000000000CCE7AED4");
        } else {
            selectSql.append("nodata");
        }
        selectSql.append("' or ");
        selectSql.append(" (exists (  ");
        selectSql.append("SELECT  subADMIN.FID  ");
        selectSql.append("FROM T_BD_Person AS PERSON   ");
        selectSql.append("INNER JOIN T_HR_PersonPosition AS PP ON PERSON.FID = PP.FPersonID ");
        selectSql.append("INNER JOIN T_ORG_PositionMember AS PM ON PERSON.FID = PM.FPersonID ");
        selectSql.append("INNER JOIN T_ORG_Position AS POSITION ON PM.FPositionID = POSITION.FID ");
        selectSql.append("INNER JOIN T_ORG_Admin AS subADMIN ON POSITION.FAdminOrgUnitID = subADMIN.FID  ");
        selectSql.append("where PERSON.fid = '").append(perId).append("'  ");
        selectSql.append("and subADMIN.fid = bizadmin.FAdminID)  ");
        selectSql.append("or ( bizadmin.FIncludeSub = 1 and exists ( ");
        selectSql.append("select fid from T_ORG_Admin sbadmin where sbadmin.fid = bizadmin.FAdminID ");
        if (!containCU) {
            selectSql.append("and fcontrolUnitID = '").append(ctrlUnitID).append("' ");
        }
        selectSql.append("and fnumber in (").append(adminNum).append(") ");
        selectSql.append("))) ");
        selectSql.append("\t\tor bizrole.froleid  \n");
        selectSql.append("\t\tin( \n");
        selectSql.append("\t\t\tselect froleid from T_PM_UserRoleOrg where 1=1 ");
        selectSql.append("\t\t\tand fuserid = '");
        selectSql.append(userId);
        selectSql.append("' \n");
        selectSql.append("\t\t) \n");
        selectSql.append("\t) \n");
        if (docId != null && !"".equals(docId)) {
            selectSql.append("    AND da.FID = '");
            selectSql.append(docId);
            selectSql.append("'  \n");
        }
        selectSql.append("\tAND (");
        selectSql.append(DefaultDmPermissionService.makeWhereExpByOperNumSet(operStrNumSet));
        selectSql.append(")  \n");
        return selectSql.toString();
    }

    public static boolean hasSpecialPermDocInCategory(Context ctx, String perId, String userId, String categoryId, Set operaionPermSet) {
        boolean rtnVal = false;
        String ctrlUnitID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        boolean containCU = false;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("docArea.CUEntry.includeSub"));
            CategoryInfo model = (CategoryInfo)CategoryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(categoryId), sic);
            DocAreaInfo curInfo = model.getDocArea();
            containCU = curInfo.getCUEntry().get(0) != null ? curInfo.getCUEntry().get(0).isIncludeSub() : false;
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        String adminNum = DefaultDmPermissionService.convertLongNumber2Condition(DefaultDmPermissionService.getAdminLongNumberByPersonID(ctx, perId));
        HashSet<String> operSet = new HashSet<String>();
        operSet.add("4");
        operSet.add("20");
        operSet.add("5");
        operSet.add("8");
        operSet.add("13");
        if (operaionPermSet == null || operaionPermSet.isEmpty()) {
            operaionPermSet = operSet;
        }
        String bizTableName = "T_DM_Document";
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select biz.fid from ");
        selectSql.append(bizTableName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("admin bizadmin on bizadmin.fparentid = biz.fid \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("person bizperson on bizperson.fparentid = biz.fid \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("role bizrole on bizrole.fparentid = biz.fid \n");
        selectSql.append("left outer join t_dm_category bizcategory on bizcategory.fid = biz.FCategoryID \n");
        selectSql.append("where  \n");
        selectSql.append(" biz.fisEnablePerm = 1 \n");
        selectSql.append(" and (bizperson.fpersonid = '");
        selectSql.append(perId);
        selectSql.append("' or bizperson.fpersonid = '");
        if (DmCommonUtils.isPersonInCU(ctx, perId, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString())) {
            selectSql.append("00000000-0000-0000-0000-000000000000CCE7AED4");
        } else {
            selectSql.append("nodata");
        }
        selectSql.append("' or ");
        selectSql.append("(exists (  ");
        selectSql.append("SELECT  subADMIN.FID  ");
        selectSql.append("FROM T_BD_Person AS PERSON   ");
        selectSql.append("INNER JOIN T_HR_PersonPosition AS PP ON PERSON.FID = PP.FPersonID ");
        selectSql.append("INNER JOIN T_ORG_PositionMember AS PM ON PERSON.FID = PM.FPersonID ");
        selectSql.append("INNER JOIN T_ORG_Position AS POSITION ON PM.FPositionID = POSITION.FID ");
        selectSql.append("INNER JOIN T_ORG_Admin AS subADMIN ON POSITION.FAdminOrgUnitID = subADMIN.FID  ");
        selectSql.append("where PERSON.fid = '").append(perId).append("'  ");
        selectSql.append("and subADMIN.fid = bizadmin.FAdminID)  ");
        selectSql.append("or ( bizadmin.FIncludeSub = 1 and exists ( ");
        selectSql.append("select fid from T_ORG_Admin sbadmin where sbadmin.fid = bizadmin.FAdminID ");
        if (!containCU) {
            selectSql.append("and fcontrolUnitID = '").append(ctrlUnitID).append("' ");
        }
        selectSql.append("and fnumber in (").append(adminNum).append(") ");
        selectSql.append("))) ");
        selectSql.append("\t\tor bizrole.froleid  \n");
        selectSql.append("\t\tin( \n");
        selectSql.append("\t\t\tselect froleid from T_PM_UserRoleOrg where 1=1 ");
        selectSql.append("\t\t\tand fuserid = '");
        selectSql.append(userId);
        selectSql.append("' \n");
        selectSql.append("\t\t) \n");
        selectSql.append("\t\n");
        selectSql.append("   ) AND bizcategory.FID = '");
        selectSql.append(categoryId);
        selectSql.append("'  \n");
        selectSql.append("\tAND (");
        selectSql.append(DefaultDmPermissionService.makeWhereExpByOperNumSet(operaionPermSet));
        selectSql.append(")  \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            rtnVal = rs.size() != 0;
        }
        catch (BOSException e) {
            logger.info((Object)"create ejb interface error");
            e.printStackTrace();
        }
        return rtnVal;
    }

    public Set<String> getBizPermMapAdmin(Context ctx, String perId, String userId, String bizId, String bizTableName, Set<String> permSet) {
        Date a = new Date();
        String ctrlUnitID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        boolean containCU = false;
        try {
            DocAreaInfo curInfo;
            Serializable model;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            if ("t_dm_category".equals(bizTableName)) {
                sic.add(new SelectorItemInfo("docArea.CUEntry.includeSub"));
                model = (CategoryInfo)CategoryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bizId), sic);
                curInfo = ((AbstractCategoryInfo)model).getDocArea();
                containCU = curInfo.getCUEntry().get(0) != null ? curInfo.getCUEntry().get(0).isIncludeSub() : false;
            } else if ("t_dm_docarea".equals(bizTableName)) {
                sic.add(new SelectorItemInfo("CUEntry.includeSub"));
                DocAreaInfo curInfo2 = (DocAreaInfo)DocAreaFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bizId), sic);
                containCU = curInfo2.getCUEntry().get(0) != null ? curInfo2.getCUEntry().get(0).isIncludeSub() : false;
            } else {
                sic.add(new SelectorItemInfo("category.docArea.CUEntry.includeSub"));
                model = (DocumentInfo)DocumentFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bizId), sic);
                curInfo = ((AbstractDocumentInfo)model).getCategory().getDocArea();
                containCU = curInfo.getCUEntry().get(0) != null ? curInfo.getCUEntry().get(0).isIncludeSub() : false;
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        String adminNum = DefaultDmPermissionService.convertLongNumber2Condition(DefaultDmPermissionService.getAdminLongNumberByPersonID(ctx, perId));
        Set<String> rtnSet = permSet;
        if (permSet == null) {
            rtnSet = new HashSet<String>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select  bizadmin.FPermList as personList  from ");
        selectSql.append(bizTableName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        if ("t_dm_dimension".equals(bizTableName)) {
            selectSql.append("adminorg bizadmin on bizadmin.fparentid = biz.fid \n");
            selectSql.append(" where  bizadmin.fadminorgid  \n");
        } else {
            selectSql.append("admin bizadmin on bizadmin.fparentid = biz.fid \n");
        }
        if ("t_dm_category".equals(bizTableName) || "t_dm_document".equals(bizTableName)) {
            selectSql.append(" where 1=1 ");
            if ("t_dm_document".equals(bizTableName)) {
                selectSql.append(" and biz.fisEnablePerm = 1 \n");
            }
            selectSql.append("and (exists (  ");
            selectSql.append("SELECT  subADMIN.FID  ");
            selectSql.append("FROM T_BD_Person AS PERSON   ");
            selectSql.append("INNER JOIN T_HR_PersonPosition AS PP ON PERSON.FID = PP.FPersonID ");
            selectSql.append("INNER JOIN T_ORG_PositionMember AS PM ON PERSON.FID = PM.FPersonID ");
            selectSql.append("INNER JOIN T_ORG_Position AS POSITION ON PM.FPositionID = POSITION.FID ");
            selectSql.append("INNER JOIN T_ORG_Admin AS subADMIN ON POSITION.FAdminOrgUnitID = subADMIN.FID  ");
            selectSql.append("where PERSON.fid = '").append(perId).append("'  ");
            selectSql.append("and subADMIN.fid = bizadmin.FAdminID)  ");
            selectSql.append("or ( bizadmin.FIncludeSub = 1 and exists ( ");
            selectSql.append("select fid from T_ORG_Admin sbadmin where sbadmin.fid = bizadmin.FAdminID ");
            if (!containCU) {
                selectSql.append("and fcontrolUnitID = '").append(ctrlUnitID).append("' ");
            }
            selectSql.append("and fnumber in (").append(adminNum).append(") ");
            selectSql.append("))) ");
            selectSql.append("    AND biz.FID = '");
            selectSql.append(bizId);
            selectSql.append("'  \n");
            selectSql.append("\t  \n");
        } else {
            selectSql.append(" where  bizadmin.fadminid  \n");
            selectSql.append("\t\tin( \n");
            selectSql.append("\t\t\tSELECT  ADMIN.FID \n");
            selectSql.append("\t\t\tFROM T_BD_Person AS PERSON  \n");
            selectSql.append("\t\t\tINNER JOIN T_HR_PersonPosition AS PP  \n");
            selectSql.append("\t\t\tON PERSON.FID = PP.FPersonID  \n");
            selectSql.append("\t\t\tINNER JOIN T_ORG_PositionMember AS PM  \n");
            selectSql.append("\t\t\tON PERSON.FID = PM.FPersonID  \n");
            selectSql.append("\t\t\tINNER JOIN T_PM_USER AS PMUSER \n");
            selectSql.append("\t\t\tON PMUSER.FPERSONID = PERSON.FID \n");
            selectSql.append("\t\t\tINNER JOIN T_ORG_Position AS POSITION  \n");
            selectSql.append("\t\t\tON PM.FPositionID = POSITION.FID  \n");
            selectSql.append("\t\t\tINNER JOIN T_ORG_Admin AS ADMIN  \n");
            selectSql.append("\t\t\tON POSITION.FAdminOrgUnitID = ADMIN.FID where PMUSER.fid = '");
            selectSql.append(userId);
            selectSql.append("' \n");
            selectSql.append("\t\t)  \n");
            selectSql.append(" and biz.fid='" + bizId + "'");
        }
        Date b = new Date();
        logger.info((Object)("-----------------getBizPermMapAdmin: b-a=" + (b.getTime() - a.getTime())));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            String[] permList = null;
            String tempStr2 = null;
            while (rs.next()) {
                permList = StringUtils.split((String)rs.getString("personList"), (String)",");
                if (permList == null) continue;
                for (String tempStr2 : permList) {
                    if (tempStr2 == null || tempStr2.trim().length() <= 0) continue;
                    rtnSet.add(tempStr2);
                }
            }
        }
        catch (BOSException e) {
            logger.info((Object)"create ejb interface error");
            return rtnSet;
        }
        catch (SQLException e) {
            logger.info((Object)"execute sql error");
            return rtnSet;
        }
        Date c = new Date();
        logger.info((Object)("-----------------getBizPermMapAdmin: c-b=" + (c.getTime() - b.getTime())));
        logger.info((Object)(bizId + "|" + bizTableName + "|" + permSet));
        return rtnSet;
    }

    private Set<String> getBizPermMapPerson(Context ctx, String perId, String userId, String bizId, String bizTableName, Set<String> permSet) {
        Set<String> rtnSet = permSet;
        if (permSet == null) {
            rtnSet = new HashSet<String>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select bizperson.FPermList as adminList from ");
        selectSql.append(bizTableName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("person bizperson on bizperson.fparentid = biz.fid \n");
        selectSql.append("where  \n");
        selectSql.append("   (bizperson.fpersonid = '");
        selectSql.append(perId);
        selectSql.append("'\t) \n");
        selectSql.append("    AND biz.FID = '");
        selectSql.append(bizId);
        selectSql.append("'  \n");
        selectSql.append("\t  \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            String[] permList = null;
            String tempStr2 = null;
            while (rs.next()) {
                permList = StringUtils.split((String)rs.getString("adminList"), (String)",");
                if (permList == null) continue;
                for (String tempStr2 : permList) {
                    if (tempStr2 == null || tempStr2.trim().length() <= 0) continue;
                    rtnSet.add(tempStr2);
                }
            }
        }
        catch (BOSException e) {
            logger.info((Object)"create ejb interface error");
            return rtnSet;
        }
        catch (SQLException e) {
            logger.info((Object)"execute sql error");
            return rtnSet;
        }
        return rtnSet;
    }

    public Set<String> getBizPermMapRole(Context ctx, String perId, String userId, String bizId, String bizTableName, Set<String> permSet) {
        Set<String> rtnSet = permSet;
        if (permSet == null) {
            rtnSet = new HashSet<String>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select  bizrole.FPermList as roleList from ");
        selectSql.append(bizTableName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizTableName);
        selectSql.append("role bizrole on bizrole.fparentid = biz.fid \n");
        selectSql.append("where  \n");
        selectSql.append("\t\t bizrole.froleid  \n");
        selectSql.append("\t\tin( \n");
        selectSql.append("\t\t\tselect froleid from T_PM_UserRoleOrg where 1=1 ");
        selectSql.append("\t\t\tand fuserid = '");
        selectSql.append(userId);
        selectSql.append("' \n");
        selectSql.append("\t\t) \n");
        selectSql.append("    AND biz.FID = '");
        selectSql.append(bizId);
        selectSql.append("'  \n");
        selectSql.append("\t  \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            String[] permList = null;
            String tempStr2 = null;
            while (rs.next()) {
                permList = StringUtils.split((String)rs.getString("roleList"), (String)",");
                if (permList == null) continue;
                for (String tempStr2 : permList) {
                    if (tempStr2 == null || tempStr2.trim().length() <= 0) continue;
                    rtnSet.add(tempStr2);
                }
            }
        }
        catch (BOSException e) {
            logger.info((Object)"create ejb interface error");
            return rtnSet;
        }
        catch (SQLException e) {
            logger.info((Object)"execute sql error");
            return rtnSet;
        }
        return rtnSet;
    }

    public Map<String, Set<String>> getHasPermCatIdSetPerson(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap, int[] state) {
        List dmPermListCache = PermissionUtil.getDmPermListCache();
        Set<String> tempSet = operStrNumSet;
        Map<String, Set<String>> rtnMap = daCatMap;
        if (operStrNumSet == null) {
            tempSet = new HashSet<String>();
            tempSet.add("4");
        }
        String bizName = bizTableName;
        if (bizTableName == null) {
            bizName = "t_dm_category";
        }
        if (daCatMap == null) {
            rtnMap = new HashMap<String, Set<String>>();
        }
        String permList = null;
        HashSet<String> catIdSet = new HashSet<String>();
        block0: for (com.kingdee.eas.cp.dm.web.util.DmPermCacheInfo d : dmPermListCache) {
            if (!StringUtils.isEmpty((String)d.getDocID()) || StringUtils.isEmpty((String)d.getPersonID()) || !bizIdSet.contains(d.getDocAreaID())) continue;
            permList = d.getPermList();
            if (null == permList || "".equals(permList)) break;
            for (String s : tempSet) {
                if (!permList.contains(s)) continue;
                catIdSet.add(d.getCatID());
                continue block0;
            }
        }
        rtnMap = this.getBizParentIds(ctx, catIdSet, "t_dm_category");
        return rtnMap;
    }

    private Map<String, Set<String>> getBizParentIds(Context ctx, Set<String> bizIdSet, String bizTableName) {
        int pSize;
        if (0 >= bizIdSet.size()) {
            return new HashMap<String, Set<String>>();
        }
        HashMap<String, Set<String>> rtnMap = new HashMap<String, Set<String>>();
        Object[] ay = bizIdSet.toArray();
        int firstId = 0;
        int maxId = pSize = 950;
        int totalCount = ay.length;
        int totalPage = (totalCount - 1) / maxId + 1;
        for (int p = 0; p < totalPage; ++p) {
            firstId = p * pSize;
            maxId = (p + 1) * pSize;
            if (totalCount < maxId) {
                maxId = totalCount;
            }
            StringBuilder sbIds = new StringBuilder();
            for (int i = firstId; i < maxId; ++i) {
                sbIds.append("'").append(ay[i]).append("',");
            }
            String ids = sbIds.toString();
            if (ids.length() > 0) {
                ids = ids.substring(0, ids.length() - 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(" select fid, fdocAreaId from ").append(bizTableName).append(" as paz where exists(select biz.flongnumber from ").append(bizTableName).append(" biz where biz.fid in (").append(ids).append(") and substring(biz.flongnumber,1,length(paz.flongnumber)) = paz.flongnumber) ").append("and fstate != 2");
            this.querySql(ctx, sb, rtnMap);
        }
        return rtnMap;
    }

    private void querySql(Context ctx, StringBuilder sb, Map<String, Set<String>> rtnMap) {
        Set<Object> catSet = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            while (rs.next()) {
                String docAreaId = rs.getString("fdocAreaId");
                catSet = rtnMap.containsKey(docAreaId) ? rtnMap.get(docAreaId) : new HashSet();
                if (catSet.contains(rs.getString("fid"))) continue;
                catSet.add(rs.getString("fid"));
                rtnMap.put(docAreaId, catSet);
            }
        }
        catch (BOSException e) {
            logger.info((Object)"create ejb interface error");
        }
        catch (SQLException e) {
            logger.info((Object)"execute sql error");
        }
    }

    public Map<String, Set<String>> getHasPermCatIdSetAdmin(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap, int[] state) {
        Set<String> tempSet = operStrNumSet;
        if (operStrNumSet == null) {
            tempSet = new HashSet<String>();
            tempSet.add("4");
        }
        String bizName = bizTableName;
        if (bizTableName == null) {
            bizName = "t_dm_category";
        }
        Map<String, Set<String>> rtnMap = daCatMap;
        if (daCatMap == null) {
            rtnMap = new HashMap<String, Set<String>>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select bizadmin.FPermList, biz.fid, da.FID as daid from ");
        selectSql.append(bizName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizName);
        selectSql.append("admin bizadmin on bizadmin.fparentid = biz.fid \n");
        selectSql.append("left outer join t_dm_docarea da ");
        selectSql.append(" on biz.fdocareaid = da.fid \n");
        selectSql.append("where  1=1 \n");
        Map res = this.getCurrentUserAdminIncludeParent(ctx, userId);
        String currentAdminId = (String)res.get(userId);
        if (currentAdminId != null) {
            selectSql.append(" and  ( ");
            selectSql.append(" bizadmin.fadminid  \n");
            selectSql.append(" in ").append(CommonUtils.getStrFromSet((Set)res.get(currentAdminId)));
            selectSql.append("\t) \n");
        }
        selectSql.append("    AND da.FID in");
        selectSql.append(CommonUtils.getStrFromSet(bizIdSet));
        selectSql.append("  \n");
        if (tempSet.size() > 0) {
            selectSql.append("\tAND (");
            selectSql.append(this.makeWhereExpByOperNumSetAdmin(tempSet));
            selectSql.append(")  \n");
        }
        selectSql.append("  or (bizadmin.fincludesub=1");
        if (currentAdminId != null) {
            selectSql.append(" or bizadmin.fadminid='" + currentAdminId + "'");
        }
        selectSql.append(")");
        if (state != null && state.length > 0) {
            for (int i = 0; i < state.length; ++i) {
                if (i == 0) {
                    selectSql.append(" and ( ").append(" biz.fstate=").append(state[i]);
                    continue;
                }
                selectSql.append(" or ").append(" biz.fstate=").append(state[i]);
            }
            selectSql.append(" ) ");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            Set<Object> catIdSet = null;
            while (rs.next()) {
                String daId = rs.getString("daid");
                catIdSet = rtnMap.get(daId) == null ? new HashSet() : rtnMap.get(daId);
                catIdSet.add(rs.getString("fid"));
                rtnMap.put(daId, catIdSet);
            }
        }
        catch (BOSException e) {
            logger.info((Object)"create ejb interface error");
            return rtnMap;
        }
        catch (SQLException e) {
            logger.info((Object)"execute sql error");
            return rtnMap;
        }
        return rtnMap;
    }

    public Map<String, Set<String>> getHasPermCatIdSetRole(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap, int[] state) {
        List dmPermListCache = PermissionUtil.getDmPermListCache();
        Set<String> tempSet = operStrNumSet;
        if (operStrNumSet == null) {
            tempSet = new HashSet<String>();
            tempSet.add("4");
        }
        String bizName = bizTableName;
        if (bizTableName == null) {
            bizName = "t_dm_category";
        }
        Map<String, Set<String>> rtnMap = daCatMap;
        if (daCatMap == null) {
            rtnMap = new HashMap<String, Set<String>>();
        }
        String permList = null;
        HashSet<String> catIdSet = new HashSet<String>();
        block0: for (com.kingdee.eas.cp.dm.web.util.DmPermCacheInfo d : dmPermListCache) {
            if (!StringUtils.isEmpty((String)d.getDocID()) || StringUtils.isEmpty((String)d.getRoleID()) || !bizIdSet.contains(d.getDocAreaID())) continue;
            permList = d.getPermList();
            if (null == permList || "".equals(permList)) break;
            for (String s : tempSet) {
                if (!permList.contains(s)) continue;
                catIdSet.add(d.getCatID());
                continue block0;
            }
        }
        rtnMap = this.getBizParentIds(ctx, catIdSet, "t_dm_category");
        return rtnMap;
    }

    private String makeWhereExpByOperNumSetRole(Set<String> operStrNumSet) {
        StringBuilder whereExp = new StringBuilder();
        String permLikeValue = null;
        String permEndLikeValue = null;
        String permMiddleLikeValue = null;
        int i = 0;
        for (String operNum : operStrNumSet) {
            permLikeValue = operNum + ",%";
            permEndLikeValue = "%," + operNum;
            permMiddleLikeValue = "%," + operNum + ",%";
            if (i != 0) {
                whereExp.append(" or ");
            }
            whereExp.append(" bizrole.FPermList like '").append(permLikeValue).append("' or ").append(" bizrole.FPermList like '").append(permEndLikeValue).append("' or ").append(" bizrole.FPermList like '").append(permMiddleLikeValue).append("' or ").append("bizrole.FPermList = '").append(operNum).append("'  \n");
            ++i;
        }
        return whereExp.toString();
    }

    private String makeWhereExpByOperNumSetPerson(Set<String> operStrNumSet) {
        StringBuilder whereExp = new StringBuilder();
        String permLikeValue = null;
        String permEndLikeValue = null;
        String permMiddleLikeValue = null;
        int i = 0;
        for (String operNum : operStrNumSet) {
            permLikeValue = operNum + ",%";
            permEndLikeValue = "%," + operNum;
            permMiddleLikeValue = "%," + operNum + ",%";
            if (i != 0) {
                whereExp.append(" or ");
            }
            whereExp.append(" bizperson.FPermList like '").append(permLikeValue).append("' or ").append(" bizperson.FPermList like '").append(permEndLikeValue).append("' or ").append(" bizperson.FPermList like '").append(permMiddleLikeValue).append("' or ").append("bizperson.FPermList = '").append(operNum).append("'  \n");
            ++i;
        }
        return whereExp.toString();
    }

    private Map getCurrentUserAdminIncludeParent(Context ctx, String userId) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        HashSet<String> adminIdSet = new HashSet<String>();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("          SELECT  ADMIN.FID,ADMIN.FLONGNUMBER \n");
        selectSql.append("          FROM T_BD_Person AS PERSON  \n");
        selectSql.append("          INNER JOIN T_HR_PersonPosition AS PP  \n");
        selectSql.append("          ON PERSON.FID = PP.FPersonID  \n");
        selectSql.append("          INNER JOIN T_ORG_PositionMember AS PM  \n");
        selectSql.append("          ON PERSON.FID = PM.FPersonID  \n");
        selectSql.append("          INNER JOIN T_PM_USER AS PMUSER \n");
        selectSql.append("          ON PMUSER.FPERSONID = PERSON.FID \n");
        selectSql.append("          INNER JOIN T_ORG_Position AS POSITION  \n");
        selectSql.append("          ON PM.FPositionID = POSITION.FID  \n");
        selectSql.append("          INNER JOIN T_ORG_Admin AS ADMIN  \n");
        selectSql.append("           ON POSITION.FAdminOrgUnitID = ADMIN.FID where PMUSER.fid = '");
        selectSql.append(userId);
        selectSql.append("' \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            if (rs.next()) {
                resMap.put(userId, rs.getString("FID"));
                String longNumber = rs.getString("FLONGNUMBER");
                Object s = null;
                String[] numberArr = longNumber.split("!");
                String insql = CommonUtils.getStrFromSet(new HashSet<String>(Arrays.asList(numberArr)));
                rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT FID FROM T_ORG_Admin WHERE FNUMBER IN " + insql + ""));
                while (rs.next()) {
                    adminIdSet.add(rs.getString("FID"));
                }
                resMap.put((String)resMap.get(userId), adminIdSet);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resMap;
    }

    private String makeWhereExpByOperNumSetAdmin(Set<String> operStrNumSet) {
        StringBuilder whereExp = new StringBuilder();
        String permLikeValue = null;
        String permEndLikeValue = null;
        String permMiddleLikeValue = null;
        int i = 0;
        for (String operNum : operStrNumSet) {
            permLikeValue = operNum + ",%";
            permEndLikeValue = "%," + operNum;
            permMiddleLikeValue = "%," + operNum + ",%";
            if (i != 0) {
                whereExp.append(" or ");
            }
            whereExp.append(" bizadmin.FPermList like '").append(permLikeValue).append("' or ").append(" bizadmin.FPermList like '").append(permEndLikeValue).append("' or ").append(" bizadmin.FPermList like '").append(permMiddleLikeValue).append("' or ").append("bizadmin.FPermList = '").append(operNum).append("'  \n");
            ++i;
        }
        return whereExp.toString();
    }

    public String getHasPermDocIdSqlRole(String perId, String userId) {
        HashSet<String> operStrNumSet = new HashSet<String>();
        operStrNumSet.add("6");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select doc.fid from t_dm_document doc \n").append("inner join t_dm_category biz on doc.fcategoryid = biz.fid \n");
        selectSql.append("inner join t_bd_person author on doc.fauthorid = author.fid \n").append("left outer join t_dm_categoryrole bizrole on bizrole.fparentid = biz.fid  \n").append("left outer join t_dm_docarea da  on biz.fdocareaid = da.fid  \n").append("where   \n").append("\t\t\tbizrole.froleid   \n").append("\t\t\tin(  \n").append("\t\t\t\tselect froleid from T_PM_UserRoleOrg where 1=1");
        selectSql.append("\t\t\t\tand fuserid = '").append(userId).append("'\n").append("\t\t)  \n").append("\t\tAND \n");
        selectSql.append("((doc.fwfstate=3 and (bizrole.FPermList like '%4%' or bizrole.FPermList like '%5%'))");
        selectSql.append("or ( bizrole.FPermList like '%3%' or bizrole.FPermList like '%2%' or bizrole.FPermList like '%4%')");
        selectSql.append("or (bizrole.FPermList like '%6%' and doc.fwfstate in (4,5) and author.fid = '" + perId + "'))");
        selectSql.append("and (biz.fstate = 1 or  (biz.fstate = 0 and (bizrole.FPermList like '6,%' or  bizrole.FPermList like '%,6' or  bizrole.FPermList like '%,6,%' or bizrole.FPermList = '6'");
        selectSql.append("))) and (doc.fwfstate > 2 or doc.fauthorId = '" + perId + "')");
        return selectSql.toString();
    }

    public String getHasPermDocIdSqlAdmin(String perId, String userId) {
        HashSet<String> operStrNumSet = new HashSet<String>();
        operStrNumSet.add("6");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select doc.fid from t_dm_document doc \n").append("inner join t_dm_category biz on doc.fcategoryid = biz.fid \n").append("inner join t_bd_person author on doc.fauthorid = author.fid \n").append("left outer join t_dm_categoryadmin bizadmin on bizadmin.fparentid = biz.fid  \n").append("left outer join t_dm_categoryrole bizrole on bizrole.fparentid = biz.fid  \n").append("left outer join t_dm_docarea da  on biz.fdocareaid = da.fid  \n").append("where   \n").append(" bizadmin.fadminid in(  \n").append("\t\t\t\tSELECT  ADMIN.FID  \n").append("\t\t\t\tFROM T_BD_Person AS PERSON   \n").append("\t\t\t\tINNER JOIN T_HR_PersonPosition AS PP   \n").append("\t\t\t\tON PERSON.FID = PP.FPersonID   \n").append("\t\t\t\tINNER JOIN T_ORG_PositionMember AS PM   \n").append("\t\t\t\tON PERSON.FID = PM.FPersonID   \n").append("\t\t\t\tINNER JOIN T_PM_USER AS PMUSER  \n").append("\t\t\t\tON PMUSER.FPERSONID = PERSON.FID  \n").append("\t\t\t\tINNER JOIN T_ORG_Position AS POSITION   \n").append("\t\t\t\tON PM.FPositionID = POSITION.FID   \n").append("\t\t\t\tINNER JOIN T_ORG_Admin AS ADMIN   \n").append("\t\t\t\tON POSITION.FAdminOrgUnitID = ADMIN.FID where PMUSER.fid = '").append(userId).append("'  \n").append("\t\t\t)   \n").append("\n").append("\n").append("\t\tAND (  \n");
        selectSql.append("     (doc.fwfstate=").append(3).append(" and (bizadmin.FPermList like '%4%' or bizadmin.FPermList like '%5%')) \n");
        selectSql.append("      or(  \n");
        selectSql.append("      ((bizadmin.FPermList like '%6%' ) \n");
        selectSql.append("      and doc.fwfstate in (4,5) \n");
        selectSql.append("      and author.fid = '").append(perId).append("')");
        selectSql.append("      or((bizadmin.FPermList like '%6%') \n");
        selectSql.append("      )) \n");
        selectSql.append("      ) \n").append(" and ( biz.fstate = ").append(1).append(" or ").append(" (biz.fstate = ").append(0).append(" and ( ").append(this.makeWhereExpByOperNumSetAdmin(operStrNumSet)).append("))) ");
        return selectSql.toString();
    }

    public String getHasPermDocIdSqlAdminByCategory(Context ctx, String perId, String userId, String cateId) {
        HashSet<String> operStrNumSet = new HashSet<String>();
        operStrNumSet.add("6");
        String ctrlUnitID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        boolean containCU = false;
        if (cateId != null) {
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("docArea.CUEntry.includeSub"));
                CategoryInfo model = (CategoryInfo)CategoryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(cateId), sic);
                DocAreaInfo curInfo = model.getDocArea();
                containCU = curInfo.getCUEntry().get(0) != null ? curInfo.getCUEntry().get(0).isIncludeSub() : false;
            }
            catch (EASBizException e1) {
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                e1.printStackTrace();
            }
        }
        String adminNum = DefaultDmPermissionService.convertLongNumber2Condition(DefaultDmPermissionService.getAdminLongNumberByPersonID(ctx, perId));
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select doc.fid from t_dm_document doc \n").append("inner join t_dm_category biz on doc.fcategoryid = biz.fid \n").append("inner join t_bd_person author on doc.fauthorid = author.fid \n").append("left outer join t_dm_categoryadmin bizadmin on bizadmin.fparentid = biz.fid  \n").append("left outer join t_dm_categoryrole bizrole on bizrole.fparentid = biz.fid  \n").append("left outer join t_dm_docarea da  on biz.fdocareaid = da.fid  \n").append("where   \n");
        if (cateId != null) {
            selectSql.append(" biz.fId='" + cateId + "'");
        } else {
            selectSql.append(" bizadmin.fadminid in(  \n").append("\t\t\t\tSELECT  ADMIN.FID  \n").append("\t\t\t\tFROM T_BD_Person AS PERSON   \n").append("\t\t\t\tINNER JOIN T_HR_PersonPosition AS PP   \n").append("\t\t\t\tON PERSON.FID = PP.FPersonID   \n").append("\t\t\t\tINNER JOIN T_ORG_PositionMember AS PM   \n").append("\t\t\t\tON PERSON.FID = PM.FPersonID   \n").append("\t\t\t\tINNER JOIN T_PM_USER AS PMUSER  \n").append("\t\t\t\tON PMUSER.FPERSONID = PERSON.FID  \n").append("\t\t\t\tINNER JOIN T_ORG_Position AS POSITION   \n").append("\t\t\t\tON PM.FPositionID = POSITION.FID   \n").append("\t\t\t\tINNER JOIN T_ORG_Admin AS ADMIN   \n").append("\t\t\t\tON POSITION.FAdminOrgUnitID = ADMIN.FID where PMUSER.fid = '").append(userId).append("'  \n").append("\t\t\t)   \n");
        }
        selectSql.append("\n").append("\n").append("\t\tAND (  \n");
        selectSql.append("     (doc.fwfstate=").append(3).append(" and (bizadmin.FPermList like '%4%' or bizadmin.FPermList like '%5%')) \n");
        selectSql.append("      or(  \n");
        selectSql.append("      ((bizadmin.FPermList like '%6%' ) \n");
        selectSql.append("      and doc.fwfstate in (4,5) \n");
        selectSql.append("      and author.fid = '").append(perId).append("')");
        selectSql.append("      or((bizadmin.FPermList like '%6%') \n");
        selectSql.append("      )) \n");
        selectSql.append("      ) \n").append(" and ( biz.fstate = ").append(1).append(" or ").append(" (biz.fstate = ").append(0).append(" and ( ").append(this.makeWhereExpByOperNumSetAdmin(operStrNumSet)).append("))) ");
        return selectSql.toString();
    }

    public String getHasPermDocIdSqlPerson(Context ctx, String perId, String userId) {
        HashSet<String> operStrNumSet = new HashSet<String>();
        operStrNumSet.add("3");
        operStrNumSet.add("6");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select doc.fid from t_dm_document doc \n");
        selectSql.append("inner join t_dm_category biz on doc.fcategoryid = biz.fid \n");
        selectSql.append("left outer join t_dm_categoryperson bizperson on bizperson.fparentid = biz.fid  \n");
        selectSql.append("left outer join t_dm_docarea da  on biz.fdocareaid = da.fid  \n");
        selectSql.append("where ");
        selectSql.append("(bizperson.FPermList LIKE '%4%' OR ");
        selectSql.append("bizperson.FPermList LIKE '%5%'or bizperson.FPermList LIKE '%3%' or bizperson.FPermList LIKE '%2%') AND (biz.FState < 2)");
        selectSql.append("and (doc.fwfstate > 2 or doc.fauthorId = '" + perId + "' or doc.fcreatePersonId='" + perId + "') and ");
        selectSql.append("(bizperson.FPersonID = '" + perId + "' OR ");
        selectSql.append("bizperson.FPersonID = '");
        if (DmCommonUtils.isPersonInCU(ctx, perId, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString())) {
            selectSql.append("00000000-0000-0000-0000-000000000000CCE7AED4");
        } else {
            selectSql.append("nodata");
        }
        selectSql.append("')");
        return selectSql.toString();
    }

    public Map<String, Set<String>> getHasPermDimIdMap(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, int[] state) {
        HashMap<String, Set<String>> daCatMap = new HashMap<String, Set<String>>();
        this.getHasPermDimIdSetPerson(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        this.getHasPermDimIdSetAdmin(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        this.getHasPermDimIdSetRole(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        return daCatMap;
    }

    public Map<String, Set<String>> getHasPermDimIdSetPerson(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap, int[] state) {
        Set<String> tempSet = operStrNumSet;
        Map<String, Set<String>> rtnMap = daCatMap;
        if (operStrNumSet == null) {
            tempSet = new HashSet<String>();
            tempSet.add("13");
        }
        String bizName = bizTableName;
        if (bizTableName == null) {
            bizName = "t_dm_dimension";
        }
        if (daCatMap == null) {
            rtnMap = new HashMap<String, Set<String>>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select  bizperson.FPermList,biz.fid, biz.FLv1dimensionID as lv1dim  from ");
        selectSql.append(bizName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizName);
        selectSql.append("person bizperson on bizperson.fparentid = biz.fid \n");
        selectSql.append("where  \n");
        if (tempSet.size() != 0) {
            selectSql.append("   (bizperson.fpersonid = '");
            selectSql.append(perId);
            selectSql.append("' or bizperson.fpersonid = '");
            if (DmCommonUtils.isPersonInCU(ctx, perId, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString())) {
                selectSql.append("00000000-0000-0000-0000-000000000000CCE7AED4");
            } else {
                selectSql.append("nodata");
            }
            selectSql.append("'     ) \n");
            selectSql.append(" AND");
        }
        selectSql.append("   biz.FLv1dimensionID in");
        selectSql.append(CommonUtils.getStrFromSet(bizIdSet));
        selectSql.append("  \n");
        if (tempSet.size() > 0) {
            selectSql.append("  AND (");
            selectSql.append(this.makeWhereExpByOperNumSetPerson(tempSet));
            selectSql.append(")  \n");
        }
        if (state != null && state.length > 0) {
            for (int i = 0; i < state.length; ++i) {
                if (i == 0) {
                    selectSql.append(" and ( ").append(" biz.fstate=").append(state[i]);
                    continue;
                }
                selectSql.append(" or ").append(" biz.fstate=").append(state[i]);
            }
            selectSql.append(" ) ");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            Set<Object> catIdSet = null;
            while (rs.next()) {
                String daId = rs.getString("lv1dim");
                catIdSet = rtnMap.get(daId) == null ? new HashSet() : rtnMap.get(daId);
                catIdSet.add(rs.getString("fid"));
                rtnMap.put(daId, catIdSet);
            }
        }
        catch (BOSException e) {
            logger.info((Object)"create ejb interface error");
            return rtnMap;
        }
        catch (SQLException e) {
            logger.info((Object)"execute sql error");
            return rtnMap;
        }
        return rtnMap;
    }

    public Map<String, Set<String>> getHasPermDimIdSetAdmin(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap, int[] state) {
        Set<String> tempSet = operStrNumSet;
        if (operStrNumSet == null) {
            tempSet = new HashSet<String>();
            tempSet.add("13");
        }
        String bizName = bizTableName;
        if (bizTableName == null) {
            bizName = "t_dm_dimension";
        }
        Map<String, Set<String>> rtnMap = daCatMap;
        if (daCatMap == null) {
            rtnMap = new HashMap<String, Set<String>>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select  bizadmin.FPermList,biz.fid, biz.FLv1dimensionID as lv1dim  from ");
        selectSql.append(bizName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizName);
        selectSql.append("adminorg bizadmin on bizadmin.fparentid = biz.fid \n");
        selectSql.append("where  \n");
        selectSql.append("   ( ");
        selectSql.append(" bizadmin.FAdminOrgID  \n");
        selectSql.append("      in( \n");
        selectSql.append("          SELECT  ADMIN.FID \n");
        selectSql.append("          FROM T_BD_Person AS PERSON  \n");
        selectSql.append("          INNER JOIN T_HR_PersonPosition AS PP  \n");
        selectSql.append("          ON PERSON.FID = PP.FPersonID  \n");
        selectSql.append("          INNER JOIN T_ORG_PositionMember AS PM  \n");
        selectSql.append("          ON PERSON.FID = PM.FPersonID  \n");
        selectSql.append("          INNER JOIN T_PM_USER AS PMUSER \n");
        selectSql.append("          ON PMUSER.FPERSONID = PERSON.FID \n");
        selectSql.append("          INNER JOIN T_ORG_Position AS POSITION  \n");
        selectSql.append("          ON PM.FPositionID = POSITION.FID  \n");
        selectSql.append("          INNER JOIN T_ORG_Admin AS ADMIN  \n");
        selectSql.append("           ON POSITION.FAdminOrgUnitID = ADMIN.FID where PMUSER.fid = '");
        selectSql.append(userId);
        selectSql.append("' \n");
        selectSql.append("      )  \n");
        selectSql.append("  ) \n");
        selectSql.append("  and  biz.FLv1dimensionID in");
        selectSql.append(CommonUtils.getStrFromSet(bizIdSet));
        selectSql.append("  \n");
        if (tempSet.size() > 0) {
            selectSql.append("  AND (");
            selectSql.append(this.makeWhereExpByOperNumSetAdmin(tempSet));
            selectSql.append(")  \n");
        }
        if (state != null && state.length > 0) {
            for (int i = 0; i < state.length; ++i) {
                if (i == 0) {
                    selectSql.append(" and ( ").append(" biz.fstate=").append(state[i]);
                    continue;
                }
                selectSql.append(" or ").append(" biz.fstate=").append(state[i]);
            }
            selectSql.append(" ) ");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            Set<Object> catIdSet = null;
            while (rs.next()) {
                String daId = rs.getString("lv1dim");
                catIdSet = rtnMap.get(daId) == null ? new HashSet() : rtnMap.get(daId);
                catIdSet.add(rs.getString("fid"));
                rtnMap.put(daId, catIdSet);
            }
        }
        catch (BOSException e) {
            logger.info((Object)e.getMessage());
            return rtnMap;
        }
        catch (SQLException e) {
            logger.info((Object)"execute sql error");
            return rtnMap;
        }
        return rtnMap;
    }

    public Map<String, Set<String>> getHasPermDimIdSetRole(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap, int[] state) {
        Set<String> tempSet = operStrNumSet;
        if (operStrNumSet == null) {
            tempSet = new HashSet<String>();
            tempSet.add("13");
        }
        String bizName = bizTableName;
        if (bizTableName == null) {
            bizName = "t_dm_dimension";
        }
        Map<String, Set<String>> rtnMap = daCatMap;
        if (daCatMap == null) {
            rtnMap = new HashMap<String, Set<String>>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select  bizrole.FPermList,biz.fid, biz.FLv1dimensionID as lv1dim  from ");
        selectSql.append(bizName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join ");
        selectSql.append(bizName);
        selectSql.append("role bizrole on bizrole.fparentid = biz.fid \n");
        selectSql.append("where  \n");
        selectSql.append("   ( ");
        selectSql.append("      bizrole.froleid  \n");
        selectSql.append("      in( \n");
        selectSql.append("           select froleid from T_PM_UserRoleOrg where 1=1");
        selectSql.append("          and fuserid = '");
        selectSql.append(userId);
        selectSql.append("' \n");
        selectSql.append("      ) \n");
        selectSql.append("  ) \n");
        if (bizIdSet.size() <= 0) {
            selectSql.append("   and biz.FLv1dimensionID='nodata' ");
        } else {
            selectSql.append("  and biz.FLv1dimensionID in");
            selectSql.append(CommonUtils.getStrFromSet(bizIdSet));
            selectSql.append("  \n");
        }
        if (tempSet.size() > 0) {
            selectSql.append("  AND (");
            selectSql.append(this.makeWhereExpByOperNumSetRole(tempSet));
            selectSql.append(")  \n");
        }
        if (state != null && state.length > 0) {
            for (int i = 0; i < state.length; ++i) {
                if (i == 0) {
                    selectSql.append(" and ( ").append(" biz.fstate=").append(state[i]);
                    continue;
                }
                selectSql.append(" or ").append(" biz.fstate=").append(state[i]);
            }
            selectSql.append(" ) ");
        }
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            Set<Object> catIdSet = null;
            while (rs.next()) {
                String daId = rs.getString("lv1dim");
                catIdSet = rtnMap.get(daId) == null ? new HashSet() : rtnMap.get(daId);
                catIdSet.add(rs.getString("fid"));
                rtnMap.put(daId, catIdSet);
            }
        }
        catch (BOSException e) {
            logger.info((Object)"create ejb interface error");
            return rtnMap;
        }
        catch (SQLException e) {
            logger.info((Object)"execute sql error");
            return rtnMap;
        }
        return rtnMap;
    }

    public Map<String, Set<String>> getHasPermCatIdMap(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, int[] state) {
        HashMap<String, Set<String>> daCatMap = new HashMap<String, Set<String>>();
        daCatMap.putAll(this.getHasPermCatIdSet(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state));
        Map<String, Set<String>> specialPermDaCatMap = this.getHasPermCatIdSetBySpecial(ctx, perId, userId, bizIdSet, bizTableName, daCatMap, state);
        Set mapKs = daCatMap.keySet();
        Set<String> spMapKs = specialPermDaCatMap.keySet();
        for (String sp : spMapKs) {
            if (mapKs.contains(sp)) {
                ((Set)daCatMap.get(sp)).addAll((Collection)specialPermDaCatMap.get(sp));
                continue;
            }
            daCatMap.put(sp, specialPermDaCatMap.get(sp));
        }
        return daCatMap;
    }

    @Override
    public Map<String, Set<String>> getHasPermCatIdMap(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName) {
        return this.getHasPermCatIdMap(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, new int[]{0, 1});
    }

    @Override
    public String getCreatorDocIdSql(Context ctx, String perId, String userId) {
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select doc.fid from t_dm_document doc \n");
        selectSql.append("inner join t_dm_category biz on doc.fcategoryid = biz.fid \n");
        selectSql.append("left outer join t_dm_categoryperson bizperson on bizperson.fparentid = biz.fid  \n");
        selectSql.append("left outer join t_dm_docarea da  on biz.fdocareaid = da.fid  \n");
        selectSql.append("where ");
        selectSql.append("(doc.fwfstate > 2 or doc.fauthorId = '" + perId + "' or doc.fcreatePersonId='" + perId + "') and ");
        selectSql.append("(bizperson.FPersonID = '" + perId + "' OR ");
        selectSql.append("bizperson.FPersonID = '");
        if (DmCommonUtils.isPersonInCU(ctx, perId, ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString())) {
            selectSql.append("00000000-0000-0000-0000-000000000000CCE7AED4");
        } else {
            selectSql.append("nodata");
        }
        selectSql.append("')");
        return selectSql.toString();
    }

    public Map<String, Set<String>> getLeftTreeCatIdMap(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName) throws BOSException {
        int[] state = new int[]{0, 1};
        HashMap<String, Set<String>> daCatMap = new HashMap<String, Set<String>>();
        HashSet<String> notAdminSet = new HashSet<String>();
        for (String docAreaId : bizIdSet) {
            boolean isCategoryAdmin = false;
            isCategoryAdmin = PermissionUtil.checkHasPermission(ctx, "1", docAreaId, "t_dm_docarea");
            HashSet<String> docAreaIdSet = new HashSet<String>();
            docAreaIdSet.add(docAreaId);
            if (isCategoryAdmin) {
                this.getAllCatIdSetByDocareaId(ctx, perId, userId, operStrNumSet, docAreaIdSet, bizTableName, daCatMap, state);
                continue;
            }
            notAdminSet.add(docAreaId);
        }
        if (notAdminSet.size() > 0) {
            Map<String, Set<String>> noeAdmindaCatMap = this.getHasPermCatIdMap(ctx, perId, userId, operStrNumSet, notAdminSet, bizTableName, state);
            daCatMap.putAll(noeAdmindaCatMap);
        }
        return daCatMap;
    }

    public Map<String, Set<String>> getAllCatIdSetByDocareaId(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, String bizTableName, Map<String, Set<String>> daCatMap, int[] state) {
        Set<String> tempSet = operStrNumSet;
        Map<String, Set<String>> rtnMap = daCatMap;
        if (operStrNumSet == null) {
            tempSet = new HashSet<String>();
            tempSet.add("4");
        }
        String bizName = bizTableName;
        if (bizTableName == null) {
            bizName = "t_dm_category";
        }
        if (daCatMap == null) {
            rtnMap = new HashMap<String, Set<String>>();
        }
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select biz.fid, da.FID as daid  from ");
        selectSql.append(bizName);
        selectSql.append(" biz  \n");
        selectSql.append("left outer join t_dm_docarea da ");
        selectSql.append(" on biz.fdocareaid = da.fid \n");
        selectSql.append("where  \n");
        selectSql.append("   da.FID in");
        selectSql.append(CommonUtils.getStrFromSet(bizIdSet));
        selectSql.append("  \n");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            Set<Object> catIdSet = null;
            while (rs.next()) {
                String daId = rs.getString("daid");
                catIdSet = rtnMap.get(daId) == null ? new HashSet() : rtnMap.get(daId);
                catIdSet.add(rs.getString("fid"));
                rtnMap.put(daId, catIdSet);
            }
        }
        catch (BOSException e) {
            logger.info((Object)"create ejb interface error");
            e.printStackTrace();
            return rtnMap;
        }
        catch (SQLException e) {
            logger.info((Object)"execute sql error");
            e.printStackTrace();
            return rtnMap;
        }
        return rtnMap;
    }

    public static Set<String> getPermByPersonID(Context ctx, String personId, String bizId, String bizName) {
        List dpcList = PermissionUtil.getDmPermListCache();
        List lstPerm = com.kingdee.portal.plt.cp.module.document.service.PermissionUtil.getDmPermListCache();
        HashSet<String> permSet = new HashSet<String>();
        String ctrlUnitID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        boolean containCU = false;
        try {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            if ("t_dm_category".equals(bizName)) {
                sic.add(new SelectorItemInfo("docArea.CUEntry.includeSub"));
                CategoryInfo model = (CategoryInfo)CategoryFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bizId), sic);
                DocAreaInfo curInfo = model.getDocArea();
                containCU = curInfo.getCUEntry().get(0) != null ? curInfo.getCUEntry().get(0).isIncludeSub() : false;
            } else {
                if ("t_dm_document".equals(bizName)) {
                    for (DmPermCacheInfo dpc : lstPerm) {
                        if (!bizId.equals(dpc.getDocID())) continue;
                        if (null == dpc.getPermList() || "".equals(dpc.getPermList())) break;
                        String[] permList = dpc.getPermList().split(",");
                        int len = permList.length;
                        for (int i = 0; i < len; ++i) {
                            if (permSet.contains(permList[i])) continue;
                            permSet.add(permList[i]);
                        }
                    }
                    return permSet;
                }
                sic.add(new SelectorItemInfo("CUEntry.includeSub"));
                DocAreaInfo curInfo = (DocAreaInfo)DocAreaFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bizId), sic);
                containCU = curInfo.getCUEntry().get(0) != null ? curInfo.getCUEntry().get(0).isIncludeSub() : false;
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        String adminNum = DefaultDmPermissionService.convertLongNumber2Condition(DefaultDmPermissionService.getAdminLongNumberByPersonID(ctx, personId));
        StringBuffer sql = new StringBuffer();
        sql.append("select role.fpermlist as permList ");
        sql.append("from " + bizName + "role role ");
        sql.append("where role.fparentid = '").append(bizId).append("' ");
        sql.append("and exists (  ");
        sql.append("  select userRole.froleid from T_PM_UserRoleOrg userRole  ");
        sql.append("  INNER JOIN T_PM_USER AS pmuser ON pmuser.FID = userRole.fuserid  ");
        sql.append(" where 1=1 ");
        sql.append("  and pmuser.FPERSONID = '").append(personId).append("'  ");
        sql.append("  and userRole.froleid = role.froleid )  ");
        sql.append("union all ");
        sql.append("select admin.fpermlist as permList ");
        sql.append("from " + bizName + "admin admin ");
        sql.append("where admin.fparentid = '").append(bizId).append("' ");
        sql.append("and ( exists (  ");
        sql.append("SELECT  subADMIN.FID  ");
        sql.append("FROM T_BD_Person AS PERSON   ");
        sql.append("INNER JOIN T_HR_PersonPosition AS PP ON PERSON.FID = PP.FPersonID ");
        sql.append("INNER JOIN T_ORG_PositionMember AS PM ON PERSON.FID = PM.FPersonID ");
        sql.append("INNER JOIN T_ORG_Position AS POSITION ON PM.FPositionID = POSITION.FID ");
        sql.append("INNER JOIN T_ORG_Admin AS subADMIN ON POSITION.FAdminOrgUnitID = subADMIN.FID  ");
        sql.append("where PERSON.fid = '").append(personId).append("'  ");
        sql.append("and subADMIN.fid = admin.FAdminID)  ");
        sql.append("or ( admin.FIncludeSub = 1 and exists ( ");
        sql.append("select fid from T_ORG_Admin sbadmin where sbadmin.fid = admin.FAdminID ");
        if (!containCU) {
            sql.append("and fcontrolUnitID = '").append(ctrlUnitID).append("' ");
        }
        sql.append("and fnumber in (").append(adminNum).append(") ");
        sql.append(")) ");
        sql.append(") ");
        sql.append("union all ");
        sql.append("select person.fpermlist as permList  ");
        sql.append("from " + bizName + "person person ");
        sql.append("where person.fparentid = '").append(bizId).append("' ");
        sql.append("and (person.fpersonid = '").append(personId).append("' ");
        sql.append(" or person.fpersonid = '").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("') ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String[] permList = null;
            String tempStr2 = null;
            while (rs.next()) {
                permList = StringUtils.split((String)rs.getString("permList"), (String)",");
                if (permList == null) continue;
                for (String tempStr2 : permList) {
                    if (tempStr2 == null || tempStr2.trim().length() <= 0) continue;
                    permSet.add(tempStr2);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return permSet;
    }

    private static String getAdminLongNumberByPersonID(Context ctx, String personId) {
        String result = "";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT  subADMIN.FLongNumber as longnumber  FROM T_BD_Person AS PERSON ");
        sql.append("INNER JOIN T_HR_PersonPosition AS PP ON PERSON.FID = PP.FPersonID ");
        sql.append("INNER JOIN T_ORG_PositionMember AS PM ON PERSON.FID = PM.FPersonID ");
        sql.append("INNER JOIN T_ORG_Position AS POSITION ON PM.FPositionID = POSITION.FID ");
        sql.append("INNER JOIN T_ORG_Admin AS subADMIN ON POSITION.FAdminOrgUnitID = subADMIN.FID ");
        sql.append("where PERSON.fid = '").append(personId).append("' ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                result = rs.getString("longnumber");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String convertLongNumber2Condition(String longNumber) {
        StringBuffer adminNum = new StringBuffer();
        if (longNumber != null && !"".equals(longNumber)) {
            String[] nums;
            for (String str : nums = StringUtils.split((String)longNumber, (String)"!")) {
                adminNum.append("'" + str + "',");
            }
            String rtnVal = adminNum.toString();
            if (rtnVal.length() > 0) {
                rtnVal = rtnVal.substring(0, adminNum.length() - 1);
            }
            return rtnVal;
        }
        return "''";
    }

    @Override
    public String getHasPermDocIdSql(Context ctx, String perId, String userId) {
        String personSql = this.getHasPermDocIdSqlPerson(ctx, perId, userId);
        String adminSql = this.getHasPermDocIdSqlAdminByCategory(ctx, perId, userId, null);
        String roleSql = this.getHasPermDocIdSqlRole(perId, userId);
        String specialSql = DefaultDmPermissionService.getHasPermDocIdSqlSpecial(ctx, perId, userId, null, null, null);
        StringBuffer allSql = new StringBuffer();
        allSql.append(" ( ");
        allSql.append(personSql).append(" union ").append(adminSql).append(" union ").append(roleSql).append(" union ").append(specialSql).append(" ) ");
        return allSql.toString();
    }

    public Set<String> getLegalPermDocIdSet(Context ctx, Set<String> categorySet) {
        ArrayList dpcList = PermissionUtil.getDmPermListCache();
        if (dpcList == null) {
            dpcList = new ArrayList();
        }
        HashSet<String> rtnSet = new HashSet<String>();
        String userId = PermissionUtil.getCurrentUserId(ctx);
        String perId = PermissionUtil.getCurrentPersonId(ctx);
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select doc.fid, doc.fWfState, doc.fcategoryId, doc.fauthorid, doc.FisEnablePerm, doc.fcreatepersonId from T_DM_Document doc where doc.fcategoryId in " + com.kingdee.eas.cp.dm.web.util.CommonUtils.getStrFromSet(categorySet));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
            block3: while (rs.next()) {
                String[] pa;
                String permList;
                String docId = rs.getString("fid");
                int wfstate = rs.getInt("fWfState");
                String categoryId = rs.getString("fcategoryId");
                String creatorId = rs.getString("fcreatepersonId");
                boolean isEnablePerm = rs.getBoolean("FisEnablePerm");
                boolean isSkip = false;
                if (!isEnablePerm) {
                    for (com.kingdee.eas.cp.dm.web.util.DmPermCacheInfo dp : dpcList) {
                        if (categoryId.equals(dp.getCatID()) && null == dp.getDocID()) {
                            permList = dp.getPermList();
                            if (null == permList || "".equals(permList)) continue block3;
                            for (String s : pa = permList.split(",")) {
                                if (perId.equals(creatorId)) {
                                    rtnSet.add(docId);
                                    isSkip = true;
                                    break;
                                }
                                if ((s.equals("21") || s.equals("22") || s.equals("6") || s.equals("23") || s.equals("7") || s.equals("3") || s.equals("10")) && (wfstate == 3 || wfstate == 5)) {
                                    rtnSet.add(docId);
                                    isSkip = true;
                                    break;
                                }
                                if (!s.equals("4") && !s.equals("5") || wfstate != 3) continue;
                                rtnSet.add(docId);
                                isSkip = true;
                                break;
                            }
                        }
                        if (!isSkip) continue;
                        continue block3;
                    }
                    continue;
                }
                if (perId.equals(creatorId)) {
                    rtnSet.add(docId);
                    continue;
                }
                for (com.kingdee.eas.cp.dm.web.util.DmPermCacheInfo dp : dpcList) {
                    if (wfstate == 3 && docId.equals(dp.getDocID())) {
                        rtnSet.add(docId);
                        isSkip = true;
                        continue block3;
                    }
                    if ((wfstate == 3 || wfstate == 5) && categoryId.equals(dp.getCatID()) && null == dp.getDocID()) {
                        permList = dp.getPermList();
                        if (null == permList || "".equals(permList)) continue block3;
                        for (String s : pa = permList.split(",")) {
                            if (!s.equals("21") && !s.equals("22") && !s.equals("6") && !s.equals("23") && !s.equals("7") && !s.equals("3") && !s.equals("10")) continue;
                            rtnSet.add(docId);
                            isSkip = true;
                            break;
                        }
                    }
                    if (!isSkip) continue;
                    continue block3;
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        rtnSet.add("");
        return rtnSet;
    }

    public Map<String, Set<String>> getHasPermCatIdMapAdmin(Context ctx, String perId, String userId, Set<String> operStrNumSet, Set<String> bizIdSet, Map<String, Set<String>> daCatMap, int[] state) {
        List dmPermListCache = PermissionUtil.getDmPermListCache();
        Map<String, Set<String>> rtnMap = daCatMap;
        if (daCatMap == null) {
            rtnMap = new HashMap<String, Set<String>>();
        }
        Set<String> tempSet = operStrNumSet;
        if (operStrNumSet == null) {
            tempSet = new HashSet<String>();
            tempSet.add("4");
        }
        String bizTableName = "t_dm_category";
        String permList = null;
        HashSet<String> catIdSet = new HashSet<String>();
        block0: for (com.kingdee.eas.cp.dm.web.util.DmPermCacheInfo d : dmPermListCache) {
            if (!StringUtils.isEmpty((String)d.getDocID()) || StringUtils.isEmpty((String)d.getAdminID()) || !bizIdSet.contains(d.getDocAreaID())) continue;
            permList = d.getPermList();
            if (null == permList || "".equals(permList)) break;
            for (String s : tempSet) {
                if (!permList.contains(s)) continue;
                catIdSet.add(d.getCatID());
                continue block0;
            }
        }
        rtnMap = this.getBizParentIds(ctx, catIdSet, "t_dm_category");
        return rtnMap;
    }

    public Map<String, Set<String>> getCategoryAddNewDocTreeCatIdMap(Context ctx, Set<String> bizIdSet) {
        HashSet<String> operStrNumSet = new HashSet<String>();
        String userId = PermissionUtil.getCurrentUserId(ctx);
        String perId = PermissionUtil.getCurrentPersonId(ctx);
        operStrNumSet.add("2");
        String bizTableName = "t_dm_category";
        int[] state = new int[]{0, 1};
        Map<String, Set<String>> daCatMap = new HashMap<String, Set<String>>();
        daCatMap = this.getHasPermCatIdSet(ctx, perId, userId, operStrNumSet, bizIdSet, bizTableName, daCatMap, state);
        return daCatMap;
    }

    public void clearDirtyPermData(Context ctx) {
        StringBuffer sb = new StringBuffer();
        sb.append("delete T_DM_CategoryAdmin where fPermList is null or fPermList = '';");
        sb.append("delete T_DM_CategoryRole where fPermList is null or fPermList = '';");
        sb.append("delete T_DM_CategoryPerson where fPermList is null or fPermList = '';");
        sb.append("delete T_DM_DocumentAdmin where fPermList is null or fPermList = '';");
        sb.append("delete T_DM_DocumentRole where fPermList is null or fPermList = '';");
        sb.append("delete T_DM_DocumentPerson where fPermList is null or fPermList = '';");
        try {
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)("clearDirtyPermData error:" + e.getMessage()));
        }
    }

    @Deprecated
    public StringBuffer getAllPermByPersonSql(String personId) {
        StringBuffer sb = new StringBuffer();
        sb.append("select adminID,roleID,personID,permList,includeSub,docID,catID,catNumber,catLongNumber,docAreaID from (").append(this.getPerm4CatAdminSql(personId)).append(" UNION ALL").append(this.getPerm4CatRoleSql(personId)).append(" UNION ALL").append(this.getPerm4CatPersonSql(personId)).append(" UNION ALL").append(this.getPerm4DocAdminSql(personId)).append(" UNION ALL").append(this.getPerm4DocRoleSql(personId)).append(" UNION ALL").append(this.getPerm4DocPersonSql(personId)).append(") t");
        return sb;
    }

    public StringBuffer getAllPermByPersonSql(String personId, String adminLongNum) {
        String[] as = adminLongNum.split("!");
        ArrayList<String> adminNumList = new ArrayList<String>(as.length);
        int len = as.length;
        for (int i = 0; i < len; ++i) {
            adminNumList.add(as[i]);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select adminID,roleID,personID,permList,includeSub,docID,catID,catNumber,catLongNumber,docAreaID from (").append(this.getPerm4CatAdminSql(personId, adminNumList)).append(" UNION ALL").append(this.getPerm4CatRoleSql(personId)).append(" UNION ALL").append(this.getPerm4CatPersonSql(personId)).append(" UNION ALL").append(this.getPerm4DocAdminSql(personId, adminNumList)).append(" UNION ALL").append(this.getPerm4DocRoleSql(personId)).append(" UNION ALL").append(this.getPerm4DocPersonSql(personId)).append(") t");
        return sb;
    }

    public StringBuffer getAllPermByPersonSql(String personId, List adminNumList) {
        if (null == adminNumList) {
            adminNumList = new ArrayList<String>();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select adminID,roleID,personID,permList,docID,catID,catNumber,catLongNumber,docAreaID from (").append(this.getPerm4CatAdminSql(personId, adminNumList)).append(" UNION ALL").append(this.getPerm4CatRoleSql(personId)).append(" UNION ALL").append(this.getPerm4CatPersonSql(personId)).append(" UNION ALL").append(this.getPerm4DocAdminSql(personId, adminNumList)).append(" UNION ALL").append(this.getPerm4DocRoleSql(personId)).append(" UNION ALL").append(this.getPerm4DocPersonSql(personId)).append(") t");
        return sb;
    }

    @Deprecated
    private StringBuffer getPerm4CatAdminSql(String personId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT DISTINCT").append(" T_DM_CategoryAdmin.FAdminID AS adminID,").append(" null as roleID,").append(" null as personID,").append(" T_DM_CategoryAdmin.FPermList AS permList,").append(" null AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_Category T_DM_Category RIGHT OUTER JOIN T_DM_CategoryAdmin T_DM_CategoryAdmin ON T_DM_Category.FID = T_DM_CategoryAdmin.FParentID").append(" LEFT OUTER JOIN T_ORG_Position T_ORG_Position ON T_DM_CategoryAdmin.FAdminID = T_ORG_Position.FAdminOrgUnitID").append(" INNER JOIN T_ORG_PositionMember T_ORG_PositionMember ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID").append(" WHERE").append(" T_DM_CategoryAdmin.FPermList <> '' AND T_DM_Category.FState <> 2 AND T_ORG_PositionMember.FPersonID = '").append(personId).append("'");
        return sb;
    }

    private StringBuffer getPerm4CatAdminSql(String personId, List<String> adminNumList) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT DISTINCT").append(" T_DM_CategoryAdmin.FAdminID AS adminID,").append(" null as roleID,").append(" null as personID,").append(" T_DM_CategoryAdmin.FPermList AS permList,").append(" null AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_Category T_DM_Category RIGHT OUTER JOIN T_DM_CategoryAdmin T_DM_CategoryAdmin ON T_DM_Category.FID = T_DM_CategoryAdmin.FParentID").append(" WHERE").append(" EXISTS (SELECT T_ORG_Admin.FID").append("         FROM T_ORG_Position T_ORG_Position").append("         INNER JOIN T_ORG_PositionMember T_ORG_PositionMember ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID").append("         INNER JOIN T_ORG_Admin T_ORG_Admin ON T_ORG_Position.FAdminOrgUnitID = T_ORG_Admin.FID").append("         WHERE T_ORG_PositionMember.FPersonID = '").append(personId).append("'        AND T_ORG_Admin.FID = T_DM_CategoryAdmin.FAdminID )").append(" OR EXISTS (SELECT T_ORG_Admin.FID").append(" FROM T_ORG_Admin T_ORG_Admin").append("            WHERE T_ORG_Admin.FID = T_DM_CategoryAdmin.FAdminID AND T_ORG_Admin.FNumber IN ").append(com.kingdee.eas.cp.dm.web.util.CommonUtils.getStrFromList(adminNumList)).append(" AND T_DM_CategoryAdmin.FIncludeSub = 1)").append(" AND T_DM_Category.FState <> 2");
        return sb;
    }

    private StringBuffer getPerm4CatRoleSql(String personId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT DISTINCT").append(" null as adminID,").append(" T_DM_CategoryRole.FRoleID AS roleID,").append(" null as personID,").append(" T_DM_CategoryRole.FPermList AS permList,").append(" null AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_CategoryRole T_DM_CategoryRole LEFT OUTER JOIN T_PM_UserRoleOrg T_PM_UserRoleOrg ON T_DM_CategoryRole.FRoleID = T_PM_UserRoleOrg.FRoleID").append(" RIGHT OUTER JOIN T_DM_Category T_DM_Category ON T_DM_CategoryRole.FParentID = T_DM_Category.FID").append(" INNER JOIN T_PM_User T_PM_User ON T_PM_UserRoleOrg.FUserID = T_PM_User.FID").append(" WHERE").append(" T_DM_Category.FState <> 2 AND T_PM_User.FPersonID = '").append(personId).append("'");
        return sb;
    }

    private StringBuffer getPerm4CatPersonSql(String personId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT").append(" null as adminID,").append(" null as roleID,").append(" T_DM_CategoryPerson.FPersonID AS personID,").append(" T_DM_CategoryPerson.FPermList AS permList,").append(" null AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_Category T_DM_Category INNER JOIN T_DM_CategoryPerson T_DM_CategoryPerson ON T_DM_Category.FID = T_DM_CategoryPerson.FParentID").append(" WHERE").append(" T_DM_Category.FState <> 2 AND T_DM_CategoryPerson.FPersonID = '").append(personId).append("'");
        return sb;
    }

    @Deprecated
    private StringBuffer getPerm4DocAdminSql(String personId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT DISTINCT").append(" T_DM_DocumentAdmin.FAdminID AS adminID,").append(" null as roleID,").append(" null as personID,").append(" T_DM_DocumentAdmin.FPermList AS permList,").append(" T_DM_DocumentAdmin.FIncludeSub as includeSub,").append(" T_DM_Document.FID AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_DocumentAdmin T_DM_DocumentAdmin LEFT OUTER JOIN T_DM_Document T_DM_Document ON T_DM_DocumentAdmin.FParentID = T_DM_Document.FID").append(" LEFT OUTER JOIN T_ORG_Position T_ORG_Position ON T_DM_DocumentAdmin.FAdminID = T_ORG_Position.FAdminOrgUnitID").append(" INNER JOIN T_ORG_PositionMember T_ORG_PositionMember ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID").append(" INNER JOIN T_DM_Category T_DM_Category ON T_DM_Document.FCategoryID = T_DM_Category.FID").append(" WHERE").append(" T_DM_DocumentAdmin.FPermList != '' AND T_DM_Category.FState <> 2 AND T_DM_Document.FState <> 2 AND T_ORG_PositionMember.FPersonID = '").append(personId).append("'");
        return sb;
    }

    private StringBuffer getPerm4DocAdminSql(String personId, List<String> adminNumList) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT DISTINCT").append(" T_DM_DocumentAdmin.FAdminID AS adminID,").append(" null as roleID,").append(" null as personID,").append(" T_DM_DocumentAdmin.FPermList AS permList,").append(" T_DM_Document.FID AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_DocumentAdmin T_DM_DocumentAdmin LEFT OUTER JOIN T_DM_Document T_DM_Document ON T_DM_DocumentAdmin.FParentID = T_DM_Document.FID").append(" INNER JOIN T_DM_Category T_DM_Category ON T_DM_Document.FCategoryID = T_DM_Category.FID").append(" WHERE ").append(" EXISTS (SELECT T_ORG_Admin.FID").append(" \t\t  FROM T_ORG_Position T_ORG_Position").append(" \t\t  INNER JOIN T_ORG_PositionMember T_ORG_PositionMember ON T_ORG_Position.FID = T_ORG_PositionMember.FPositionID").append(" \t\t  INNER JOIN T_ORG_Admin T_ORG_Admin ON T_ORG_Position.FAdminOrgUnitID = T_ORG_Admin.FID").append(" \t\t  WHERE T_ORG_PositionMember.FPersonID = '").append(personId).append("'\t\t  AND T_ORG_Admin.FID = T_DM_DocumentAdmin.FAdminID)").append(" \t\t  OR EXISTS ( SELECT T_ORG_Admin.FID").append(" \t\t  FROM T_ORG_Admin T_ORG_Admin").append(" \t\t  WHERE T_ORG_Admin.FID = T_DM_DocumentAdmin.FAdminID AND T_ORG_Admin.FNumber IN ").append(com.kingdee.eas.cp.dm.web.util.CommonUtils.getStrFromList(adminNumList)).append(" \t\t  AND T_DM_DocumentAdmin.FIncludeSub = 1)").append(" \t\t  AND T_DM_Category.FState <> 2 AND T_DM_Document.FState <> 2");
        return sb;
    }

    private StringBuffer getPerm4DocRoleSql(String personId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT DISTINCT").append(" null as adminID,").append(" T_DM_DocumentRole.FRoleID AS roleID,").append(" null as personID,").append(" T_DM_DocumentRole.FPermList AS permList,").append(" T_DM_Document.FID AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_Document T_DM_Document INNER JOIN T_DM_Category T_DM_Category ON T_DM_Document.FCategoryID = T_DM_Category.FID").append(" RIGHT OUTER JOIN T_DM_DocumentRole T_DM_DocumentRole ON T_DM_Document.FID = T_DM_DocumentRole.FParentID").append(" LEFT OUTER JOIN T_PM_UserRoleOrg T_PM_UserRoleOrg ON T_DM_DocumentRole.FRoleID = T_PM_UserRoleOrg.FRoleID").append(" INNER JOIN T_PM_User T_PM_User ON T_PM_UserRoleOrg.FUserID = T_PM_User.FID").append(" WHERE").append(" T_DM_Category.FState <> 2 AND T_DM_Document.FState <> 2 AND T_PM_User.FPersonID = '").append(personId).append("'");
        return sb;
    }

    private StringBuffer getPerm4DocPersonSql(String personId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT").append(" null as adminID,").append(" null as roleID,").append(" T_DM_DocumentPerson.FPersonID AS personID,").append(" T_DM_DocumentPerson.FPermList AS permList,").append(" T_DM_Document.FID AS docID,").append(" T_DM_Category.FID AS catID,").append(" T_DM_Category.FNumber AS catNumber,").append(" T_DM_Category.FLongNumber AS catLongNumber,").append(" T_DM_Category.FDocAreaID AS docAreaID").append(" FROM").append(" T_DM_Document T_DM_Document INNER JOIN T_DM_Category T_DM_Category ON T_DM_Document.FCategoryID = T_DM_Category.FID").append(" INNER JOIN T_DM_DocumentPerson T_DM_DocumentPerson ON T_DM_Document.FID = T_DM_DocumentPerson.FParentID").append(" WHERE").append(" T_DM_Category.FState <> 2 AND T_DM_DocumentPerson.FPersonID = '").append(personId).append("'");
        return sb;
    }

    public StringBuffer getPermByPermListSql(Set<String> permSet) {
        StringBuffer sb = new StringBuffer();
        String[] permArray = (String[])permSet.toArray();
        int len = permArray.length;
        for (int i = 0; i < len; ++i) {
            sb.append(" and (t.permList = '").append(permArray[i]).append("'");
            sb.append(" or t.permList like '").append(permArray[i]).append(",%'");
            sb.append(" or t.permList like '%,").append(permArray[i]).append("'");
            sb.append(" or t.permList like '%,").append(permArray[i]).append(",%'");
        }
        return sb;
    }

    @Deprecated
    public StringBuffer getPermByCatListSql(List<String> catIdList) {
        StringBuffer sb = new StringBuffer();
        String[] catIdArray = (String[])catIdList.toArray();
        sb.append(" and t.catID in (");
        int len = catIdArray.length;
        for (int i = 0; i < len; ++i) {
            sb.append("'").append(catIdArray[i]).append("'");
            if (i >= len - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb;
    }

    @Deprecated
    public StringBuffer getPermByCatSql(String catId) {
        StringBuffer sb = new StringBuffer();
        sb.append(" and t.catID = '").append(catId).append("'");
        return sb;
    }

    @Deprecated
    public StringBuffer getPermByDocAreaList(List<String> docAreaIdList) {
        StringBuffer sb = new StringBuffer();
        String[] docAreaIdArray = (String[])docAreaIdList.toArray();
        sb.append(" and t.docAreaID in (");
        int len = docAreaIdArray.length;
        for (int i = 0; i < len; ++i) {
            sb.append("'").append(docAreaIdArray[i]).append("'");
            if (i >= len - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb;
    }

    @Deprecated
    public StringBuffer getPermByDocAreaSql(Context ctx, String docAreaID) {
        StringBuffer sb = new StringBuffer();
        sb.append(" and t.docAreaID = '").append(docAreaID).append("'");
        return sb;
    }

    public List getDmPermListCacheBySql(Context ctx, StringBuffer sql) {
        ArrayList<com.kingdee.eas.cp.dm.web.util.DmPermCacheInfo> list = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            list = new ArrayList<com.kingdee.eas.cp.dm.web.util.DmPermCacheInfo>(rs.size());
            logger.info((Object)("getDmPermListCacheBySql: rs.size()=" + rs.size()));
            com.kingdee.eas.cp.dm.web.util.DmPermCacheInfo dp = null;
            while (rs.next()) {
                dp = new com.kingdee.eas.cp.dm.web.util.DmPermCacheInfo(rs.getString("adminID"), rs.getString("roleID"), rs.getString("personID"), rs.getString("permList"), rs.getString("docID"), rs.getString("catID"), rs.getString("docAreaID"));
                list.add(dp);
            }
        }
        catch (BOSException e) {
            logger.error((Object)("getDmPermListCacheBySql error:" + e.getMessage()));
        }
        catch (SQLException e) {
            logger.error((Object)("getDmPermListCacheBySql error:" + e.getMessage()));
        }
        return list;
    }
}

