/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.DimensionAdminCollection;
import com.kingdee.eas.cp.dm.DimensionAdminInfo;
import com.kingdee.eas.cp.dm.DimensionCollection;
import com.kingdee.eas.cp.dm.DimensionFactory;
import com.kingdee.eas.cp.dm.DimensionInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DimensionPermissionServiceHelper {
    private static final Logger LOGGER = Logger.getLogger(DimensionPermissionServiceHelper.class);
    private static DimensionPermissionServiceHelper dimPermServiceHelper;

    public static DimensionPermissionServiceHelper getInstance() {
        return null == dimPermServiceHelper ? new DimensionPermissionServiceHelper() : dimPermServiceHelper;
    }

    public boolean hasLv1DimPermission(Context ctx, DimensionInfo dimInfo) throws BOSException {
        String curPersonId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        boolean hasFunctionPermission = false;
        try {
            DimensionAdminCollection dimAdminColl;
            if (null == dimInfo.getLv1dimension() || null == dimInfo.getLv1dimension().getAdmin() || dimInfo.getLv1dimension().getAdmin().size() == 0) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("Admin.id"));
                sic.add(new SelectorItemInfo("Admin.admin.id"));
                sic.add(new SelectorItemInfo("Admin.admin.name"));
                dimAdminColl = DimensionFactory.getLocalInstance(ctx).getDimensionInfo((IObjectPK)new ObjectUuidPK(dimInfo.getLv1dimension().getId()), sic).getAdmin();
            } else {
                dimAdminColl = dimInfo.getLv1dimension().getAdmin();
            }
            for (int i = 0; i < dimAdminColl.size(); ++i) {
                DimensionAdminInfo dimAdmin = dimAdminColl.get(i);
                if (!curPersonId.equals(dimAdmin.getAdmin().getId().toString())) continue;
                hasFunctionPermission = true;
                break;
            }
        }
        catch (EASBizException e) {
            LOGGER.info((Object)"\u83b7\u53d6\u4e00\u7ea7\u7ef4\u5ea6\u7ba1\u7406\u5458\u6743\u9650\u5931\u8d25");
            e.printStackTrace();
        }
        return hasFunctionPermission;
    }

    public List hasAllLv1DimPermission(Context ctx) {
        ArrayList<String> lv1DimPermList = new ArrayList<String>();
        String curPersonId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        try {
            DimensionCollection dimensionCollection = null;
            DimensionAdminCollection dimAdminColl = null;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("Admin.id"));
            sic.add(new SelectorItemInfo("Admin.admin.id"));
            sic.add(new SelectorItemInfo("Admin.admin.name"));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1));
            view.setFilter(filter);
            view.setSelector(sic);
            dimensionCollection = DimensionFactory.getLocalInstance(ctx).getDimensionCollection(view);
            if (null != dimensionCollection && dimensionCollection.size() > 0) {
                int j = dimensionCollection.size();
                block2: for (int i = 0; i < j; ++i) {
                    dimAdminColl = dimensionCollection.get(i).getAdmin();
                    int n = dimAdminColl.size();
                    for (int m = 0; m < n; ++m) {
                        DimensionAdminInfo dimAdmin = dimAdminColl.get(m);
                        if (!curPersonId.equals(dimAdmin.getAdmin().getId().toString())) continue;
                        lv1DimPermList.add(dimensionCollection.get(i).getId().toString());
                        continue block2;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)"\u83b7\u53d6\u4e00\u7ea7\u7ef4\u5ea6\u7ba1\u7406\u5458\u6743\u9650\u5931\u8d25");
            e.printStackTrace();
        }
        return lv1DimPermList;
    }
}

