/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.dm.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.dm.CategoryInfo;
import com.kingdee.eas.cp.dm.DefaultDACollection;
import com.kingdee.eas.cp.dm.DefaultDAFactory;
import com.kingdee.eas.cp.dm.DimensionInfo;
import com.kingdee.eas.cp.dm.DocAreaFactory;
import com.kingdee.eas.cp.dm.DocAreaInfo;
import com.kingdee.eas.cp.dm.IDefaultDA;
import com.kingdee.eas.cp.dm.web.util.CommonUtils;
import com.kingdee.eas.cp.dm.web.util.PermissionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class DmLeftTreeBeanService {
    private static DmLeftTreeBeanService dmLeftTreeBeanService;
    private static final Logger LOGGER;

    public List<DocAreaInfo> getDefaultDocAreaList(Context ctx) {
        return this.getPermDocAreaList(ctx);
    }

    public List<String> getDefaultDocAreaIdList(Context ctx) {
        String personId = CommonUtils.getPersonId(ctx);
        ArrayList<String> curDocAreaIdList = new ArrayList<String>();
        List<DocAreaInfo> docAreaList = this.getDefaultDocAreaList(ctx);
        if (null != docAreaList && docAreaList.size() > 0) {
            for (int i = 0; i < docAreaList.size(); ++i) {
                curDocAreaIdList.add(docAreaList.get(i).getId().toString());
            }
        }
        try {
            IDefaultDA idda = DefaultDAFactory.getLocalInstance(ctx);
            String oql = "select id, docArea.id where person.id = '" + CommonUtils.getPersonId(ctx) + "' and docArea.state != '2'";
            if (idda.exists(oql)) {
                DefaultDACollection ddac = idda.getDefaultDACollection(oql);
                int size = ddac.size();
                for (int i = 0; i < size; ++i) {
                    DocAreaInfo curDocArea = ddac.get(i).getDocArea();
                    if (curDocArea == null || !curDocAreaIdList.contains(curDocArea.getId().toString())) continue;
                    curDocAreaIdList.remove(curDocArea.getId().toString());
                }
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)e.getMessage());
        }
        return curDocAreaIdList;
    }

    public List<String> getDefaultDocAreaIdList2(HttpServletRequest request, Context ctx) {
        return this.getDefaultDocAreaIdList2(request, ctx, CommonUtils.getPersonId(ctx));
    }

    public List<String> getDefaultDocAreaIdList2(HttpServletRequest request, Context ctx, String personId) {
        ArrayList<String> curDocAreaIdList = new ArrayList<String>();
        List<DocAreaInfo> docAreaList = this.getDefaultDocAreaList(ctx);
        if (null != docAreaList && docAreaList.size() > 0) {
            for (int i = 0; i < docAreaList.size(); ++i) {
                curDocAreaIdList.add(docAreaList.get(i).getId().toString());
            }
        }
        EntityViewInfo ev = new EntityViewInfo();
        try {
            IDefaultDA idda = DefaultDAFactory.getLocalInstance(ctx);
            String oql = "select id, docArea.id where person.id = '" + personId + "' and docArea.state != '2'";
            if (idda.exists(oql)) {
                DefaultDACollection ddac = idda.getDefaultDACollection(oql);
                int size = ddac.size();
                for (int i = 0; i < size; ++i) {
                    DocAreaInfo curDocArea = ddac.get(i).getDocArea();
                    if (curDocArea == null || !curDocAreaIdList.contains(curDocArea.getId().toString())) continue;
                    curDocAreaIdList.remove(curDocArea.getId().toString());
                }
            }
            List noPerList = new ArrayList();
            boolean isDAAdmin = PermissionUtil.isTopCatUser(request, ctx);
            if (!isDAAdmin) {
                noPerList = this.getPermDocAreaListByDel(ctx);
                for (String id : noPerList) {
                    if (!curDocAreaIdList.contains(id)) continue;
                    curDocAreaIdList.remove(id);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.info((Object)e.getMessage());
        }
        return curDocAreaIdList;
    }

    public List getPermDocAreaListByDel(Context ctx) {
        ArrayList<String> noPerList = new ArrayList<String>();
        List<DocAreaInfo> disableDocAreaList = this.getDocAreaList(ctx, "state=0");
        ArrayList<String> disableDocAreaIdList = new ArrayList<String>();
        if (disableDocAreaList.size() > 0) {
            for (int i = 0; i < disableDocAreaList.size(); ++i) {
                disableDocAreaIdList.add(disableDocAreaList.get(i).getId().toString());
            }
        }
        HashSet<String> perMissionSet = new HashSet<String>();
        perMissionSet.add("1");
        Map<String, Set<String>> map = PermissionUtil.getHasPermCatIdMap(ctx, perMissionSet, new HashSet<String>(disableDocAreaIdList), "t_dm_category");
        for (String id : disableDocAreaIdList) {
            if (map.keySet().contains(id)) continue;
            noPerList.add(id);
        }
        return noPerList;
    }

    public List<String> getPermEnabledDocAreaIdList(Context ctx) {
        ArrayList<String> curDocAreaIdList = new ArrayList<String>();
        List<DocAreaInfo> docAreaList = this.getPermEnabledDocAreaList(ctx);
        if (null != docAreaList && docAreaList.size() > 0) {
            for (int i = 0; i < docAreaList.size(); ++i) {
                curDocAreaIdList.add(docAreaList.get(i).getId().toString());
            }
        }
        return curDocAreaIdList;
    }

    public List<DocAreaInfo> getDocAreaList(Context ctx, String extOql) {
        ArrayList<DocAreaInfo> curDocAreaIdList = new ArrayList<DocAreaInfo>();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.getQueryPK());
        EntityViewInfo ev = new EntityViewInfo();
        try {
            ev.setFilter(extOql + " and id not in ('" + "22222222-2222-2222-2222-222222222222CCE7AED4" + "','" + "33333333-3333-3333-3333-333333333333CCE7AED4" + "','" + "00000000-0000-0000-0000-000000000000EEFEE00F" + "', '" + "MelW/dHHTYOlHlNhgLZyRMNdkBQ=" + "') and index>0 ");
            exec.setObjectView(ev);
            IRowSet set = exec.executeQuery();
            ArrayList disableDocAreaIdList = new ArrayList();
            if (set.first()) {
                do {
                    DocAreaInfo areaInfo = new DocAreaInfo();
                    areaInfo.put("id", set.getString("id"));
                    areaInfo.put("cu.name", set.getString("cu.name"));
                    areaInfo.put("state", set.getInt("state"));
                    areaInfo.put("name", set.getString("name"));
                    curDocAreaIdList.add(areaInfo);
                } while (set.next());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.info((Object)e.getMessage());
        }
        return curDocAreaIdList;
    }

    public List<DocAreaInfo> getPermDocAreaList(Context ctx) {
        ArrayList<DocAreaInfo> permDocAreaIdList = null;
        try {
            CtrlUnitInfo ctrlInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String extSql = this.getCUIncludeSub(ctx, ctrlInfo);
            StringBuffer sql = new StringBuffer();
            sql.append("select area.fid as id, area.findex as findex, area.fname_l2 as name,area.fstate as state,ctrl.fname_l2 as cuName  from t_dm_docarea as area");
            sql.append(" inner join t_dm_docareacuentry as entry on area.fid=entry.fparentid inner join ");
            sql.append(" t_org_ctrlunit as ctrl on ctrl.fid=entry.fcuid ");
            sql.append(" where area.fstate<>2 and (ctrl.fid='" + ctrlInfo.getId().toString() + "'");
            if (!StringUtils.isEmpty((String)extSql)) {
                sql.append("or (ctrl.fid in (" + extSql + ") and entry.fincludesub=1 ) ");
            }
            sql.append(" )");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            permDocAreaIdList = new ArrayList<DocAreaInfo>(rs.size());
            while (rs.next()) {
                DocAreaInfo areaInfo = new DocAreaInfo();
                areaInfo.put("id", rs.getString("id"));
                areaInfo.put("cu.name", rs.getString("cuName"));
                areaInfo.put("state", rs.getInt("state"));
                areaInfo.put("name", rs.getString("name"));
                areaInfo.put("index", rs.getString("findex"));
                String daId = rs.getString("id");
                permDocAreaIdList.add(areaInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return permDocAreaIdList;
    }

    public List<DocAreaInfo> getPermEnabledDocAreaList(Context ctx) {
        ArrayList<DocAreaInfo> permDocAreaIdList = new ArrayList<DocAreaInfo>();
        try {
            CtrlUnitInfo ctrlInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            String extSql = this.getCUIncludeSub(ctx, ctrlInfo);
            StringBuffer sql = new StringBuffer();
            sql.append("select area.fid as id,area.fname_l2 as name,area.fstate as state,ctrl.fname_l2 as cuName  from t_dm_docarea as area");
            sql.append(" inner join t_dm_docareacuentry as entry on area.fid=entry.fparentid inner join ");
            sql.append(" t_org_ctrlunit as ctrl on ctrl.fid=entry.fcuid ");
            sql.append(" where area.fstate=1 and (ctrl.fid='" + ctrlInfo.getId().toString() + "'");
            if (!StringUtils.isEmpty((String)extSql)) {
                sql.append("or (ctrl.fid in (" + extSql + ") and entry.fincludesub=1 ) ");
            }
            sql.append(" )");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                DocAreaInfo areaInfo = new DocAreaInfo();
                areaInfo.put("id", rs.getString("id"));
                areaInfo.put("cu.name", rs.getString("cuName"));
                areaInfo.put("state", rs.getInt("state"));
                areaInfo.put("name", rs.getString("name"));
                String daId = rs.getString("id");
                permDocAreaIdList.add(areaInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return permDocAreaIdList;
    }

    private String getCUIncludeSub(Context ctx, CtrlUnitInfo personCUInfo) {
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct(ctrl.fid) as id,ctrl.fname_l2 as name,ctrl.flevel as flevel,ctrl.flongnumber as longnumber  from t_dm_docarea as area");
        sql.append(" inner join t_dm_docareacuentry as entry on area.fid=entry.fparentid inner join ");
        sql.append(" t_org_ctrlunit as ctrl on ctrl.fid=entry.fcuid ");
        sql.append(" where area.fstate<>2 and entry.fincludesub=1 ");
        ArrayList<CtrlUnitInfo> ctrlList = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ctrlList = new ArrayList<CtrlUnitInfo>(rs.size());
            CtrlUnitInfo ctrlInfo = null;
            while (rs.next()) {
                ctrlInfo = new CtrlUnitInfo();
                ctrlInfo.put("id", (Object)rs.getString("id"));
                ctrlInfo.put("name", (Object)rs.getString("name"));
                ctrlInfo.put("level", (Object)rs.getInt("flevel"));
                ctrlInfo.put("longnumber", (Object)rs.getString("longnumber"));
                ctrlList.add(ctrlInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String personCULNumber = personCUInfo.getLongNumber();
        String cuLNumber = null;
        StringBuffer cuIdSql = new StringBuffer();
        for (int i = 0; i < ctrlList.size(); ++i) {
            cuLNumber = ((CtrlUnitInfo)ctrlList.get(i)).getLongNumber();
            if (personCUInfo.getLevel() <= (Integer)((CtrlUnitInfo)ctrlList.get(i)).get("level") || personCULNumber.indexOf(cuLNumber) <= -1) continue;
            cuIdSql.append("'").append(((CtrlUnitInfo)ctrlList.get(i)).getId().toString()).append("'").append(",");
        }
        return cuIdSql.length() == 0 ? cuIdSql.toString() : cuIdSql.toString().substring(0, cuIdSql.toString().length() - 1);
    }

    public List<String> getMenuItems4DA(DocAreaInfo curSelectedModel, boolean isDocAreaAdmin, boolean isCategoryAdmin) {
        ArrayList<String> list = new ArrayList<String>();
        if (curSelectedModel.getState().getValue() == 1) {
            if (isCategoryAdmin) {
                list.add("newCat");
            }
            if (isDocAreaAdmin) {
                list.add("newDA");
                list.add("editDA");
                list.add("disableDA");
            }
        } else if (curSelectedModel.getState().getValue() == 0 && isDocAreaAdmin) {
            list.add("newDA");
            list.add("enableDA");
            list.add("deleteDA");
        }
        return list;
    }

    public List<String> getMenuItems4Cat(CategoryInfo curSelectedModel, Context ctx, boolean isDocAreaAdmin, boolean isCategoryAdmin) {
        ArrayList<String> list = new ArrayList<String>();
        boolean hasCurrentCatAdmin = isCategoryAdmin;
        if (curSelectedModel.getState().getValue() == 1) {
            if (isCategoryAdmin || hasCurrentCatAdmin) {
                list.add("newCat");
                list.add("editCat");
                list.add("moveCat");
                list.add("moveUpCat");
                list.add("moveDownCat");
                list.add("disableCat");
            }
            if (isDocAreaAdmin) {
                list.add("newDA");
            }
        } else if (curSelectedModel.getState().getValue() == 0) {
            try {
                DocAreaInfo daInfo = DocAreaFactory.getLocalInstance(ctx).getDocAreaInfo("select state where id = '" + curSelectedModel.getDocArea().getId().toString() + "'");
                if (daInfo.getState().getValue() == 0) {
                    if (isDocAreaAdmin) {
                        list.add("deleteCat");
                        list.add("newDA");
                    } else if (isCategoryAdmin || hasCurrentCatAdmin) {
                        list.add("deleteCat");
                    }
                } else {
                    if (isCategoryAdmin || hasCurrentCatAdmin) {
                        list.add("enableCat");
                        list.add("deleteCat");
                    }
                    if (isDocAreaAdmin) {
                        list.add("newDA");
                    }
                }
            }
            catch (EASBizException e1) {
                LOGGER.error((Object)e1.getMessage());
            }
            catch (BOSException e1) {
                LOGGER.error((Object)e1.getMessage());
            }
        }
        return list;
    }

    public List<String> getMenuItems4Dim(HttpServletRequest request, Context ctx, DimensionInfo curSelectedModel) {
        ArrayList<String> list;
        block15: {
            String userId = CommonUtils.getUserId(ctx);
            String perId = CommonUtils.getPersonId(ctx);
            String bizId = curSelectedModel.getId().toString();
            boolean hasTopPermission = false;
            boolean hasLv1DimPermission = false;
            try {
                hasTopPermission = PermissionUtil.isTopDimUser(request, ctx);
                hasLv1DimPermission = PermissionUtil.hasLv1DimPermission(request, curSelectedModel);
            }
            catch (BOSException e) {
                e.printStackTrace();
                LOGGER.error((Object)e.getMessage());
            }
            list = new ArrayList<String>();
            if (curSelectedModel.getState().getValue() == 1) {
                if (hasTopPermission) {
                    list.add("newLv1Dimenssion");
                    if (curSelectedModel.getLevel() == 1) {
                        list.add("editLv1Dimenssion");
                        list.add("disableDimenssion");
                    }
                }
                try {
                    if (!hasLv1DimPermission && !PermissionUtil.checkHasPermission(ctx, "11", bizId, "t_dm_dimension")) break block15;
                    list.add("newDimenssion");
                    if (curSelectedModel.getLevel() > 1) {
                        list.add("disableDimenssion");
                        list.add("insertDimenssion");
                        list.add("editDimenssion");
                        list.add("moveDimenssion");
                        list.add("moveUpDimenssion");
                        list.add("moveDownDimenssion");
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            } else if (curSelectedModel.getState().getValue() == 0) {
                if (hasTopPermission) {
                    list.add("newLv1Dimenssion");
                    if (curSelectedModel.getLevel() == 1) {
                        list.add("editLv1Dimenssion");
                        list.add("deleteDimenssion");
                        list.add("enableDimenssion");
                    }
                }
                try {
                    if ((hasLv1DimPermission || PermissionUtil.checkHasPermission(ctx, "11", bizId, "t_dm_dimension")) && curSelectedModel.getLevel() > 1) {
                        list.add("deleteDimenssion");
                        list.add("enableDimenssion");
                        list.add("editDimenssion");
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    public List getDefaultDimIdList(Context ctx, List<String> selectedDimensionIdList) {
        return this.getDefaultDimIdListByPerson(ctx, selectedDimensionIdList, CommonUtils.getPersonId(ctx));
    }

    public List getDefaultDimIdListByPerson(Context ctx, List<String> selectedDimensionIdList, String personId) {
        ArrayList<String> idList;
        block8: {
            ArrayList<String> curDimensionIdList = new ArrayList<String>();
            idList = new ArrayList<String>();
            try {
                IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.cp.dm.app.DimensionQuery"));
                EntityViewInfo ev = new EntityViewInfo();
                ev.setFilter("state!=2 and level = 1");
                queryExecutor.setObjectView(ev);
                IRowSet rs = queryExecutor.executeQuery();
                while (rs.next()) {
                    curDimensionIdList.add(rs.getString("id"));
                }
                queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.cp.dm.app.DefaultDIMQuery"));
                ev = new EntityViewInfo();
                ev.setFilter("person.id = '" + personId + "' and dimension.state != '2'");
                queryExecutor.setObjectView(ev);
                rs = queryExecutor.executeQuery();
                while (rs.next()) {
                    String id = rs.getString("dimension.id");
                    if (id == null || !curDimensionIdList.contains(id)) continue;
                    curDimensionIdList.remove(id);
                }
                if (selectedDimensionIdList != null && selectedDimensionIdList.size() > 0) {
                    for (String id : curDimensionIdList) {
                        if (!selectedDimensionIdList.contains(id)) continue;
                        idList.add(id);
                    }
                    break block8;
                }
                return curDimensionIdList;
            }
            catch (BOSException e) {
                LOGGER.error((Object)e.getMessage());
            }
            catch (SQLException e) {
                LOGGER.error((Object)e.getMessage());
            }
            catch (ParserException e) {
                LOGGER.error((Object)e.getMessage());
            }
        }
        return idList;
    }

    private IMetaDataPK getQueryPK() {
        return new MetaDataPK("com.kingdee.eas.cp.dm.app.DocAreaQuery");
    }

    public static synchronized DmLeftTreeBeanService getInstance() {
        return null == dmLeftTreeBeanService ? new DmLeftTreeBeanService() : dmLeftTreeBeanService;
    }

    static {
        LOGGER = Logger.getLogger(DmLeftTreeBeanService.class);
    }
}

