/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eps.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.cp.eps.app.BusinessDocument;
import com.kingdee.eas.cp.eps.plugin.AbstractModulePlugin;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;

public class CMPlugin
extends AbstractModulePlugin {
    private String attchType;

    public CMPlugin() {
        this.queryName = "ContentQuery";
        this.queryPackage = "com.kingdee.eas.cp.eip.cm.app";
    }

    protected EntityViewInfo getEntityView(boolean isUpdate) {
        EntityViewInfo ev = super.getEntityView(isUpdate);
        FilterInfo filterInfo = ev.getFilter() == null ? new FilterInfo() : ev.getFilter();
        filterInfo.getFilterItems().add(new FilterItemInfo("STATUS", (Object)String.valueOf(2), CompareType.EQUALS));
        ev.setFilter(filterInfo);
        return ev;
    }

    public BusinessDocument getBusinessDocument(IRowSet rowSet) {
        BusinessDocument obj = null;
        try {
            obj = new BusinessDocument();
            obj.setId(rowSet.getString("id"));
            obj.setTitle(rowSet.getString("title"));
            obj.setCreateUser(rowSet.getString("User.name"));
            obj.setCreateTime(rowSet.getTimestamp("createTime"));
            obj.setLastUpdateTime(rowSet.getTimestamp("lastUpdateTime"));
            obj.setKeyWord(rowSet.getString("keyword"));
            obj.setPath(this.getURL(rowSet.getString("id")));
            obj.setContent(this.getContent(rowSet));
            obj.setGategory("cm");
            obj.setCategoryID(rowSet.getString("COLUMNID"));
            obj.setCategoryName(rowSet.getString("CMColumn.name"));
            obj.setAttachType(this.attchType);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public String getURL(String bizID) {
        try {
            return "/easportal/cm/ContentView.do?contentId=" + URLEncoder.encode(bizID, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean hasPermission(String bizID) {
        boolean result = true;
        String personId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getPerson().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select ca.fid from T_CM_CMRoleAdmin ca ");
        sql.append("where ca.fcontentid = ? ");
        sql.append("and exists ( ");
        sql.append("\tSELECT  subADMIN.FID FROM T_BD_Person AS PERSON ");
        sql.append("    INNER JOIN T_HR_PersonPosition AS PP ON PERSON.FID = PP.FPersonID ");
        sql.append("    INNER JOIN T_ORG_PositionMember AS PM ON PERSON.FID = PM.FPersonID ");
        sql.append("    INNER JOIN T_ORG_Position AS POSITION ON PM.FPositionID = POSITION.FID ");
        sql.append("    INNER JOIN T_ORG_Admin AS subADMIN ON POSITION.FAdminOrgUnitID = subADMIN.FID ");
        sql.append("    where PERSON.fid = ? and subADMIN.fid = ca.FAdminOrgID) ");
        sql.append("union all ");
        sql.append("select cr.fid from T_CM_CMRoleRole cr ");
        sql.append("where cr.fcontentid = ? ");
        sql.append("and exists ( ");
        sql.append("\tselect userRole.froleid from T_PM_UserRoleOrg userRole ");
        sql.append("\tINNER JOIN T_PM_USER AS pmuser ON pmuser.FID = userRole.fuserid ");
        sql.append("\twhere pmuser.FPERSONID = ? ");
        sql.append("\tand userRole.froleid = cr.froleid ) ");
        sql.append("union all ");
        sql.append("select cp.fid from T_CM_CMRolePerson cp ");
        sql.append("where cp.fcontentid = ? and cp.fpersonid = ?");
        sql.append("union all ");
        sql.append("select crr.fid from T_CM_ColumnReadRight crr,T_CM_Content cc ");
        sql.append("where crr.FColumnID = cc.FColumnID and cc.fid = ? ");
        sql.append("and exists ( ");
        sql.append("\tselect userRole.froleid from T_PM_UserRoleOrg userRole ");
        sql.append("\tINNER JOIN T_PM_USER AS pmuser ON pmuser.FID = userRole.fuserid ");
        sql.append("\twhere pmuser.FPERSONID = ? ");
        sql.append("\tand userRole.froleid = crr.froleid ) ");
        try {
            IRowSet rowset = DbUtil.executeQuery((Context)this.getCtx(), (String)sql.toString(), (Object[])new Object[]{bizID, personId, bizID, personId, bizID, personId, bizID, personId});
            result = rowset.next();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected String getContent(IRowSet rowSet) throws SQLException {
        BoAttchAssoCollection bac2;
        this.attchType = "";
        String type = "";
        BoAttchAssoCollection bac = this.getAttach(rowSet.getString("id"));
        StringBuffer sb = new StringBuffer();
        sb.append(rowSet.getString("summary"));
        if (bac != null && bac.size() > 0) {
            ByteArrayInputStream stream = null;
            int size = bac.size();
            for (int n = 0; n < size; ++n) {
                if (bac.get(n).getAttachment() == null) continue;
                type = ("," + bac.get(n).getAttachment().getSimpleName() + ",").toLowerCase();
                if (this.attchType.indexOf(type) < 0) {
                    this.attchType = this.attchType + type;
                }
                if (bac.get(n).getAttachment().getFile() == null || bac.get(n).getAttachment().getFile().length <= 0) continue;
                stream = new ByteArrayInputStream(bac.get(n).getAttachment().getFile());
                sb.append(this.parseToString(stream));
            }
        }
        if (!StringUtils.isEmpty((String)rowSet.getString("file")) && (bac2 = this.getAttach(rowSet.getString("file"))) != null && bac2.size() > 0) {
            ByteArrayInputStream stream = null;
            int size = bac2.size();
            for (int n = 0; n < size; ++n) {
                if (bac2.get(n).getAttachment() == null) continue;
                type = ("," + bac2.get(n).getAttachment().getSimpleName() + ",").toLowerCase();
                if (this.attchType.indexOf(type) < 0) {
                    this.attchType = this.attchType + type;
                }
                if (bac2.get(n).getAttachment().getFile() == null || bac2.get(n).getAttachment().getFile().length <= 0) continue;
                stream = new ByteArrayInputStream(bac2.get(n).getAttachment().getFile());
                sb.append(this.parseToString(stream));
            }
        }
        return sb.toString();
    }
}

